/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.function.DoubleConsumer;

public class DoubleSummaryStatistics
implements DoubleConsumer {
    private long count;
    private double sum;
    private double sumCompensation;
    private double simpleSum;
    private double min;
    private double max;

    public DoubleSummaryStatistics() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public void accept(double d) {
        ++this.count;
        this.simpleSum += d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.sumWithCompensation:(D)V");
        this.sumWithCompensation(d);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(DD)D");
        this.min = Math.min(this.min, d);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(DD)D");
        this.max = Math.max(this.max, d);
    }

    public void combine(DoubleSummaryStatistics doubleSummaryStatistics) {
        this.count += doubleSummaryStatistics.count;
        this.simpleSum += doubleSummaryStatistics.simpleSum;
        double d = doubleSummaryStatistics.sum;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.sumWithCompensation:(D)V");
        this.sumWithCompensation(d);
        double d2 = doubleSummaryStatistics.sumCompensation;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.sumWithCompensation:(D)V");
        this.sumWithCompensation(d2);
        double d3 = doubleSummaryStatistics.min;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(DD)D");
        this.min = Math.min(this.min, d3);
        double d4 = doubleSummaryStatistics.max;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(DD)D");
        this.max = Math.max(this.max, d4);
    }

    private void sumWithCompensation(double d) {
        double d2 = d - this.sumCompensation;
        double d3 = this.sum + d2;
        this.sumCompensation = d3 - this.sum - d2;
        this.sum = d3;
    }

    public final long getCount() {
        return this.count;
    }

    public final double getSum() {
        double d = this.sum + this.sumCompensation;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.isNaN:(D)Z");
        boolean bl = Double.isNaN(d);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.isInfinite:(D)Z");
            boolean bl2 = Double.isInfinite(this.simpleSum);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return this.simpleSum;
            }
        }
        return d;
    }

    public final double getMin() {
        return this.min;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getAverage() {
        double d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getCount:()J");
        long l = this.getCount() - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getSum:()D");
            double d2 = this.getSum();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getCount:()J");
            d = d2 / (double)this.getCount();
            RuntimeCostAccounter.recordJump();
        } else {
            d = 0.0;
        }
        return d;
    }

    public String toString() {
        RuntimeCostAccounter.recordArrayAllocation((int)6, (int)8);
        Object[] objectArray = new Object[6];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
        objectArray[0] = clazz.getSimpleName();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getCount:()J");
        long l = this.getCount();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[1] = l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getSum:()D");
        double d = this.getSum();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
        objectArray[2] = d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getMin:()D");
        double d2 = this.getMin();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
        objectArray[3] = d2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getAverage:()D");
        double d3 = this.getAverage();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
        objectArray[4] = d3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/DoubleSummaryStatistics.getMax:()D");
        double d4 = this.getMax();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
        objectArray[5] = d4;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
        return String.format("%s{count=%d, sum=%f, min=%f, average=%f, max=%f}", objectArray);
    }
}

