/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.io.Serializable;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Collections;
import sandbox.java.util.Comparators;
import sandbox.java.util.Objects;
import sandbox.java.util.function.Function;
import sandbox.java.util.function.ToDoubleFunction;
import sandbox.java.util.function.ToIntFunction;
import sandbox.java.util.function.ToLongFunction;

@FunctionalInterface
public interface Comparator<T> {
    public int compare(T var1, T var2);

    public boolean equals(Object var1);

    default public Comparator<T> reversed() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverseOrder:(Ljava/util/Comparator;)Ljava/util/Comparator;");
        return Collections.reverseOrder(this);
    }

    default public Comparator<T> thenComparing(Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(comparator);
        return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(object, object2) -> {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n2 = this.compare(object, object2);
            RuntimeCostAccounter.recordJump();
            if (n2 != 0) {
                n = n2;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                n = comparator.compare(object, object2);
            }
            return n;
        }));
    }

    default public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.comparing:(Ljava/util/function/Function;Ljava/util/Comparator;)Ljava/util/Comparator;");
        Comparator<? super T> comparator2 = Comparator.comparing(function, comparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.thenComparing:(Ljava/util/Comparator;)Ljava/util/Comparator;");
        return this.thenComparing(comparator2);
    }

    default public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.comparing:(Ljava/util/function/Function;)Ljava/util/Comparator;");
        Comparator<? super T> comparator = Comparator.comparing(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.thenComparing:(Ljava/util/Comparator;)Ljava/util/Comparator;");
        return this.thenComparing(comparator);
    }

    default public Comparator<T> thenComparingInt(ToIntFunction<? super T> toIntFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.comparingInt:(Ljava/util/function/ToIntFunction;)Ljava/util/Comparator;");
        Comparator<? super T> comparator = Comparator.comparingInt(toIntFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.thenComparing:(Ljava/util/Comparator;)Ljava/util/Comparator;");
        return this.thenComparing(comparator);
    }

    default public Comparator<T> thenComparingLong(ToLongFunction<? super T> toLongFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.comparingLong:(Ljava/util/function/ToLongFunction;)Ljava/util/Comparator;");
        Comparator<? super T> comparator = Comparator.comparingLong(toLongFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.thenComparing:(Ljava/util/Comparator;)Ljava/util/Comparator;");
        return this.thenComparing(comparator);
    }

    default public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.comparingDouble:(Ljava/util/function/ToDoubleFunction;)Ljava/util/Comparator;");
        Comparator<? super T> comparator = Comparator.comparingDouble(toDoubleFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.thenComparing:(Ljava/util/Comparator;)Ljava/util/Comparator;");
        return this.thenComparing(comparator);
    }

    public static <T extends Comparable<? super T>> Comparator<T> reverseOrder() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.reverseOrder:()Ljava/util/Comparator;");
        return Collections.reverseOrder();
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return Comparators.NaturalOrderComparator.INSTANCE;
    }

    public static <T> Comparator<T> nullsFirst(Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Comparators$NullComparator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparators$NullComparator.<init>:(ZLjava/util/Comparator;)V");
        return new Comparators.NullComparator<T>(true, comparator);
    }

    public static <T> Comparator<T> nullsLast(Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Comparators$NullComparator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparators$NullComparator.<init>:(ZLjava/util/Comparator;)V");
        return new Comparators.NullComparator<T>(false, comparator);
    }

    public static <T, U> Comparator<T> comparing(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(comparator);
        return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(object, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r2 = function.apply(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            return comparator.compare((Object)r, (Object)r2);
        }));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(object, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Comparable comparable = (Comparable)function.apply(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = function.apply(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            return comparable.compareTo(r);
        }));
    }

    public static <T> Comparator<T> comparingInt(ToIntFunction<? super T> toIntFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(toIntFunction);
        return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(object, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToIntFunction.applyAsInt:(Ljava/lang/Object;)I");
            int n = toIntFunction.applyAsInt(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToIntFunction.applyAsInt:(Ljava/lang/Object;)I");
            int n2 = toIntFunction.applyAsInt(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.compare:(II)I");
            return Integer.compare(n, n2);
        }));
    }

    public static <T> Comparator<T> comparingLong(ToLongFunction<? super T> toLongFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(toLongFunction);
        return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(object, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToLongFunction.applyAsLong:(Ljava/lang/Object;)J");
            long l = toLongFunction.applyAsLong(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToLongFunction.applyAsLong:(Ljava/lang/Object;)J");
            long l2 = toLongFunction.applyAsLong(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
            return Long.compare(l, l2);
        }));
    }

    public static <T> Comparator<T> comparingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(toDoubleFunction);
        return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(object, object2) -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            double d = toDoubleFunction.applyAsDouble(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/ToDoubleFunction.applyAsDouble:(Ljava/lang/Object;)D");
            double d2 = toDoubleFunction.applyAsDouble(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.compare:(DD)I");
            return Double.compare(d, d2);
        }));
    }
}

