/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.reflect.Array;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;

public abstract class AbstractCollection<E>
implements Collection<E> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    protected AbstractCollection() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            E e;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl2 = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl2) return false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                e = iterator.next();
                RuntimeCostAccounter.recordJump();
            } while (e != null);
            return true;
        }
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl3 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            bl = object.equals(e);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return true;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.size:()I");
        int n = this.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        Object[] objectArray2 = new Object[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        int n2 = 0;
        while (true) {
            int n3 = objectArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                return Arrays.copyOf(objectArray2, n2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            objectArray2[n2] = iterator.next();
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
        boolean bl = iterator.hasNext();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.finishToArray:([Ljava/lang/Object;Ljava/util/Iterator;)[Ljava/lang/Object;");
            objectArray = AbstractCollection.finishToArray(objectArray2, iterator);
            RuntimeCostAccounter.recordJump();
        } else {
            objectArray = objectArray2;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2;
        Object[] objectArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.size:()I");
        int n = this.size();
        int n2 = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 >= n) {
            objectArray = TArray;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = TArray.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getComponentType:()Ljava/lang/Class;");
            Class<?> clazz2 = clazz.getComponentType();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.newInstance:(Ljava/lang/Class;I)Ljava/lang/Object;");
            objectArray = (Object[])Array.newInstance(clazz2, n);
        }
        T[] TArray3 = objectArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        int n3 = 0;
        while (true) {
            int n4 = TArray3.length;
            RuntimeCostAccounter.recordJump();
            if (n3 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (TArray == TArray3) {
                    TArray3[n3] = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n5 = TArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n5 < n3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                        return Arrays.copyOf(TArray3, n3);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(TArray3, 0, TArray, 0, n3);
                    int n6 = TArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n6 > n3) {
                        TArray[n3] = null;
                    }
                }
                return TArray;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            TArray3[n3] = iterator.next();
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
        boolean bl = iterator.hasNext();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.finishToArray:([Ljava/lang/Object;Ljava/util/Iterator;)[Ljava/lang/Object;");
            TArray2 = AbstractCollection.finishToArray(TArray3, iterator);
            RuntimeCostAccounter.recordJump();
        } else {
            TArray2 = TArray3;
        }
        return TArray2;
    }

    private static <T> T[] finishToArray(T[] TArray, Iterator<?> iterator) {
        T[] TArray2;
        int n = TArray.length;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            int n2 = TArray.length;
            RuntimeCostAccounter.recordJump();
            if (n == n2) {
                int n3 = n2 + (n2 >> 1) + 1;
                RuntimeCostAccounter.recordJump();
                if (n3 - 0x7FFFFFF7 > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.hugeCapacity:(I)I");
                    n3 = AbstractCollection.hugeCapacity(n2 + 1);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
                TArray = Arrays.copyOf(TArray, n3);
            }
            int n4 = n++;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            TArray[n4] = iterator.next();
            RuntimeCostAccounter.recordJump();
        }
        int n5 = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n == n5) {
            TArray2 = TArray;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
            TArray2 = Arrays.copyOf(TArray, n);
        }
        return TArray2;
    }

    private static int hugeCapacity(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/OutOfMemoryError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/OutOfMemoryError.<init>:(Ljava/lang/String;)V");
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError("Required array size too large");
            RuntimeCostAccounter.recordThrow();
            throw outOfMemoryError;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0x7FFFFFF7) {
            n2 = Integer.MAX_VALUE;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0x7FFFFFF7;
        }
        return n2;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
        RuntimeCostAccounter.recordThrow();
        throw unsupportedOperationException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            E e;
            do {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl2 = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl2) return false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                e = iterator.next();
                RuntimeCostAccounter.recordJump();
            } while (e != null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
            iterator.remove();
            return true;
        }
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl3 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
            bl = object.equals(e);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
        iterator.remove();
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<?> iterator = collection.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Object obj = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.contains:(Ljava/lang/Object;)Z");
            boolean bl2 = this.contains(obj);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                return false;
            }
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = collection.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.add:(Ljava/lang/Object;)Z");
            boolean bl3 = this.add(e);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                bl = true;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(collection);
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
            boolean bl3 = collection.contains(e);
            RuntimeCostAccounter.recordJump();
            if (!bl3) continue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
            iterator.remove();
            bl = true;
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(collection);
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.contains:(Ljava/lang/Object;)Z");
            boolean bl3 = collection.contains(e);
            RuntimeCostAccounter.recordJump();
            if (bl3) continue;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
            iterator.remove();
            bl = true;
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    @Override
    public void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
            iterator.remove();
            RuntimeCostAccounter.recordJump();
        }
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractCollection.iterator:()Ljava/util/Iterator;");
        Iterator<E> iterator = this.iterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
        boolean bl = iterator.hasNext();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return "[]";
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder.append('[');
        while (true) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            E e = iterator.next();
            RuntimeCostAccounter.recordJump();
            if (e == this) {
                string = "(this Collection)";
                RuntimeCostAccounter.recordJump();
            } else {
                string = e;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            stringBuilder.append((Object)string);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(']');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                return stringBuilder2.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(',');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder3.append(' ');
            RuntimeCostAccounter.recordJump();
        }
    }
}

