/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.zone;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Duration;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.zone.Ser;
import sandbox.java.time.zone.ZoneOffsetTransition;
import sandbox.java.time.zone.ZoneOffsetTransitionRule;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Objects;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;

public final class ZoneRules
implements Serializable {
    private static final long serialVersionUID = 3044319355680032515L;
    private static final int LAST_CACHED_YEAR = 2100;
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private final transient ConcurrentMap<Integer, ZoneOffsetTransition[]> lastRulesCache;
    private static final long[] EMPTY_LONG_ARRAY;
    private static final ZoneOffsetTransitionRule[] EMPTY_LASTRULES;
    private static final LocalDateTime[] EMPTY_LDT_ARRAY;

    public static ZoneRules of(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "baseStandardOffset");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset2, "baseWallOffset");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(list, "standardOffsetTransitionList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(list2, "transitionList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(list3, "lastRules");
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRules");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.<init>:(Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V");
        return new ZoneRules(zoneOffset, zoneOffset2, list, list2, list3);
    }

    public static ZoneRules of(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRules");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.<init>:(Ljava/time/ZoneOffset;)V");
        return new ZoneRules(zoneOffset);
    }

    ZoneRules(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
        this.lastRulesCache = new ConcurrentHashMap<Integer, ZoneOffsetTransition[]>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = list.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.standardTransitions = new long[n];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n2 = list.size() + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.standardOffsets = new ZoneOffset[n2];
        this.standardOffsets[0] = zoneOffset;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n4 = list.size();
            RuntimeCostAccounter.recordJump();
            if (n3 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.toEpochSecond:()J");
            this.standardTransitions[n3] = list.get(n3).toEpochSecond();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
            this.standardOffsets[n3 + 1] = list.get(n3).getOffsetAfter();
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<ZoneOffset> arrayList2 = new ArrayList<ZoneOffset>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
        arrayList2.add(zoneOffset2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
        Iterator<ZoneOffsetTransition> iterator = list2.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            ZoneOffsetTransition zoneOffsetTransition = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
            boolean bl2 = zoneOffsetTransition.isGap();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeBefore:()Ljava/time/LocalDateTime;");
                LocalDateTime localDateTime = zoneOffsetTransition.getDateTimeBefore();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(localDateTime);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
                LocalDateTime localDateTime2 = zoneOffsetTransition.getDateTimeAfter();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(localDateTime2);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
                LocalDateTime localDateTime = zoneOffsetTransition.getDateTimeAfter();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(localDateTime);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeBefore:()Ljava/time/LocalDateTime;");
                LocalDateTime localDateTime3 = zoneOffsetTransition.getDateTimeBefore();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(localDateTime3);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset3 = zoneOffsetTransition.getOffsetAfter();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            arrayList2.add(zoneOffset3);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n5 = arrayList.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
        LocalDateTime[] localDateTimeArray = new LocalDateTime[n5];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        this.savingsLocalTransitions = arrayList.toArray(localDateTimeArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n6 = arrayList2.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)8);
        ZoneOffset[] zoneOffsetArray = new ZoneOffset[n6];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        this.wallOffsets = arrayList2.toArray(zoneOffsetArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n7 = list2.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)8);
        this.savingsInstantTransitions = new long[n7];
        int n8 = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n9 = list2.size();
            RuntimeCostAccounter.recordJump();
            if (n8 >= n9) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.toEpochSecond:()J");
            this.savingsInstantTransitions[n8] = list2.get(n8).toEpochSecond();
            ++n8;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n10 = list3.size();
        RuntimeCostAccounter.recordJump();
        if (n10 > 16) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Too many transition rules");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n11 = list3.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n11, (int)8);
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = new ZoneOffsetTransitionRule[n11];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        this.lastRules = list3.toArray(zoneOffsetTransitionRuleArray);
    }

    private ZoneRules(long[] lArray, ZoneOffset[] zoneOffsetArray, long[] lArray2, ZoneOffset[] zoneOffsetArray2, ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
        this.lastRulesCache = new ConcurrentHashMap<Integer, ZoneOffsetTransition[]>();
        this.standardTransitions = lArray;
        this.standardOffsets = zoneOffsetArray;
        this.savingsInstantTransitions = lArray2;
        this.wallOffsets = zoneOffsetArray2;
        this.lastRules = zoneOffsetTransitionRuleArray;
        int n = lArray2.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
            int n2 = 0;
            while (true) {
                int n3 = lArray2.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                ZoneOffset zoneOffset = zoneOffsetArray2[n2];
                ZoneOffset zoneOffset2 = zoneOffsetArray2[n2 + 1];
                RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
                long l = lArray2[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(JLjava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
                ZoneOffsetTransition zoneOffsetTransition = new ZoneOffsetTransition(l, zoneOffset, zoneOffset2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
                boolean bl = zoneOffsetTransition.isGap();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeBefore:()Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime = zoneOffsetTransition.getDateTimeBefore();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(localDateTime);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime2 = zoneOffsetTransition.getDateTimeAfter();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(localDateTime2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime = zoneOffsetTransition.getDateTimeAfter();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(localDateTime);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeBefore:()Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime3 = zoneOffsetTransition.getDateTimeBefore();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(localDateTime3);
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n4 = arrayList.size();
            RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
            LocalDateTime[] localDateTimeArray = new LocalDateTime[n4];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            this.savingsLocalTransitions = arrayList.toArray(localDateTimeArray);
        }
    }

    private ZoneRules(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
        this.lastRulesCache = new ConcurrentHashMap<Integer, ZoneOffsetTransition[]>();
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        this.standardOffsets = new ZoneOffset[1];
        this.standardOffsets[0] = zoneOffset;
        this.standardTransitions = EMPTY_LONG_ARRAY;
        this.savingsInstantTransitions = EMPTY_LONG_ARRAY;
        this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        this.wallOffsets = this.standardOffsets;
        this.lastRules = EMPTY_LASTRULES;
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(1, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        long l;
        long l2;
        int n = this.standardTransitions.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(n);
        Object[] objectArray = this.standardTransitions;
        int n2 = objectArray.length;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            l2 = objectArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeEpochSec:(JLjava/io/DataOutput;)V");
            Ser.writeEpochSec(l2, dataOutput);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        objectArray = this.standardOffsets;
        n2 = objectArray.length;
        n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            l = objectArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeOffset:(Ljava/time/ZoneOffset;Ljava/io/DataOutput;)V");
            Ser.writeOffset((ZoneOffset)l, dataOutput);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        int n4 = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(n4);
        objectArray = this.savingsInstantTransitions;
        n2 = objectArray.length;
        n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            l2 = objectArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeEpochSec:(JLjava/io/DataOutput;)V");
            Ser.writeEpochSec(l2, dataOutput);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        objectArray = this.wallOffsets;
        n2 = objectArray.length;
        n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            l = objectArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.writeOffset:(Ljava/time/ZoneOffset;Ljava/io/DataOutput;)V");
            Ser.writeOffset((ZoneOffset)l, dataOutput);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        int n5 = this.lastRules.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(n5);
        objectArray = this.lastRules;
        n2 = objectArray.length;
        n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n2) break;
            l = objectArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.writeExternal:(Ljava/io/DataOutput;)V");
            l.writeExternal(dataOutput);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
    }

    static ZoneRules readExternal(DataInput dataInput) throws IOException, ClassNotFoundException {
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray;
        long[] lArray;
        long[] lArray2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            lArray2 = EMPTY_LONG_ARRAY;
            RuntimeCostAccounter.recordJump();
        } else {
            int n2 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
            lArray2 = new long[n2];
        }
        long[] lArray3 = lArray2;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readEpochSec:(Ljava/io/DataInput;)J");
            lArray3[n3] = Ser.readEpochSec(dataInput);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        int n4 = n + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)8);
        ZoneOffset[] zoneOffsetArray = new ZoneOffset[n4];
        int n5 = 0;
        while (true) {
            int n6 = zoneOffsetArray.length;
            RuntimeCostAccounter.recordJump();
            if (n5 >= n6) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readOffset:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
            zoneOffsetArray[n5] = Ser.readOffset(dataInput);
            ++n5;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        n5 = dataInput.readInt();
        RuntimeCostAccounter.recordJump();
        if (n5 == 0) {
            lArray = EMPTY_LONG_ARRAY;
            RuntimeCostAccounter.recordJump();
        } else {
            int n7 = n5;
            RuntimeCostAccounter.recordArrayAllocation((int)n7, (int)8);
            lArray = new long[n7];
        }
        long[] lArray4 = lArray;
        int n8 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n8 >= n5) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readEpochSec:(Ljava/io/DataInput;)J");
            lArray4[n8] = Ser.readEpochSec(dataInput);
            ++n8;
            RuntimeCostAccounter.recordJump();
        }
        int n9 = n5 + 1;
        RuntimeCostAccounter.recordArrayAllocation((int)n9, (int)8);
        ZoneOffset[] zoneOffsetArray2 = new ZoneOffset[n9];
        int n10 = 0;
        while (true) {
            int n11 = zoneOffsetArray2.length;
            RuntimeCostAccounter.recordJump();
            if (n10 >= n11) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.readOffset:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
            zoneOffsetArray2[n10] = Ser.readOffset(dataInput);
            ++n10;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        n10 = dataInput.readByte();
        RuntimeCostAccounter.recordJump();
        if (n10 == 0) {
            zoneOffsetTransitionRuleArray = EMPTY_LASTRULES;
            RuntimeCostAccounter.recordJump();
        } else {
            int n12 = n10;
            RuntimeCostAccounter.recordArrayAllocation((int)n12, (int)8);
            zoneOffsetTransitionRuleArray = new ZoneOffsetTransitionRule[n12];
        }
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray2 = zoneOffsetTransitionRuleArray;
        int n13 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n13 >= n10) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.readExternal:(Ljava/io/DataInput;)Ljava/time/zone/ZoneOffsetTransitionRule;");
            zoneOffsetTransitionRuleArray2[n13] = ZoneOffsetTransitionRule.readExternal(dataInput);
            ++n13;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRules");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.<init>:([J[Ljava/time/ZoneOffset;[J[Ljava/time/ZoneOffset;[Ljava/time/zone/ZoneOffsetTransitionRule;)V");
        return new ZoneRules(lArray3, zoneOffsetArray, lArray4, zoneOffsetArray2, zoneOffsetTransitionRuleArray2);
    }

    public boolean isFixedOffset() {
        boolean bl;
        int n = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public ZoneOffset getOffset(Instant instant) {
        int n = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return this.standardOffsets[0];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        int n2 = this.lastRules.length;
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            long l2 = l - this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 > 0) {
                ZoneOffset zoneOffset = this.wallOffsets[this.wallOffsets.length - 1];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findYear:(JLjava/time/ZoneOffset;)I");
                int n3 = this.findYear(l, zoneOffset);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findTransitionArray:(I)[Ljava/time/zone/ZoneOffsetTransition;");
                ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n3);
                ZoneOffsetTransition zoneOffsetTransition = null;
                int n4 = 0;
                while (true) {
                    int n5 = zoneOffsetTransitionArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n5) break;
                    zoneOffsetTransition = zoneOffsetTransitionArray[n4];
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.toEpochSecond:()J");
                    long l4 = l - zoneOffsetTransition.toEpochSecond();
                    long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l5 < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
                        return zoneOffsetTransition.getOffsetBefore();
                    }
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
                return zoneOffsetTransition.getOffsetAfter();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.binarySearch:([JJ)I");
        int n6 = Arrays.binarySearch(this.savingsInstantTransitions, l);
        RuntimeCostAccounter.recordJump();
        if (n6 < 0) {
            n6 = -n6 - 2;
        }
        return this.wallOffsets[n6 + 1];
    }

    public ZoneOffset getOffset(LocalDateTime localDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffsetInfo:(Ljava/time/LocalDateTime;)Ljava/lang/Object;");
        Object object = this.getOffsetInfo(localDateTime);
        boolean bl = object instanceof ZoneOffsetTransition;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ZoneOffsetTransition zoneOffsetTransition = (ZoneOffsetTransition)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
            return zoneOffsetTransition.getOffsetBefore();
        }
        return (ZoneOffset)object;
    }

    public List<ZoneOffset> getValidOffsets(LocalDateTime localDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffsetInfo:(Ljava/time/LocalDateTime;)Ljava/lang/Object;");
        Object object = this.getOffsetInfo(localDateTime);
        boolean bl = object instanceof ZoneOffsetTransition;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ZoneOffsetTransition zoneOffsetTransition = (ZoneOffsetTransition)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getValidOffsets:()Ljava/util/List;");
            return zoneOffsetTransition.getValidOffsets();
        }
        ZoneOffset zoneOffset = (ZoneOffset)object;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singletonList:(Ljava/lang/Object;)Ljava/util/List;");
        return Collections.singletonList(zoneOffset);
    }

    public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
        ZoneOffsetTransition zoneOffsetTransition;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffsetInfo:(Ljava/time/LocalDateTime;)Ljava/lang/Object;");
        Object object = this.getOffsetInfo(localDateTime);
        boolean bl = object instanceof ZoneOffsetTransition;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            zoneOffsetTransition = (ZoneOffsetTransition)object;
            RuntimeCostAccounter.recordJump();
        } else {
            zoneOffsetTransition = null;
        }
        return zoneOffsetTransition;
    }

    private Object getOffsetInfo(LocalDateTime localDateTime) {
        block12: {
            int n = this.savingsInstantTransitions.length;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                return this.standardOffsets[0];
            }
            int n2 = this.lastRules.length;
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) break block12;
            LocalDateTime localDateTime2 = this.savingsLocalTransitions[this.savingsLocalTransitions.length - 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.isAfter:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
            boolean bl = localDateTime.isAfter(localDateTime2);
            RuntimeCostAccounter.recordJump();
            if (!bl) break block12;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getYear:()I");
            int n3 = localDateTime.getYear();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findTransitionArray:(I)[Ljava/time/zone/ZoneOffsetTransition;");
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n3);
            Object object = null;
            ZoneOffsetTransition[] zoneOffsetTransitionArray2 = zoneOffsetTransitionArray;
            int n4 = zoneOffsetTransitionArray2.length;
            int n5 = 0;
            while (true) {
                block14: {
                    block13: {
                        RuntimeCostAccounter.recordJump();
                        if (n5 >= n4) break;
                        ZoneOffsetTransition zoneOffsetTransition = zoneOffsetTransitionArray2[n5];
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findOffsetInfo:(Ljava/time/LocalDateTime;Ljava/time/zone/ZoneOffsetTransition;)Ljava/lang/Object;");
                        object = this.findOffsetInfo(localDateTime, zoneOffsetTransition);
                        boolean bl2 = object instanceof ZoneOffsetTransition;
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block13;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
                        ZoneOffset zoneOffset = zoneOffsetTransition.getOffsetBefore();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                        boolean bl3 = object.equals(zoneOffset);
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break block14;
                    }
                    return object;
                }
                ++n5;
                RuntimeCostAccounter.recordJump();
            }
            return object;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.binarySearch:([Ljava/lang/Object;Ljava/lang/Object;)I");
        int n = Arrays.binarySearch(this.savingsLocalTransitions, localDateTime);
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            return this.wallOffsets[0];
        }
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            n = -n - 2;
            RuntimeCostAccounter.recordJump();
        } else {
            int n6 = this.savingsLocalTransitions.length - 1;
            RuntimeCostAccounter.recordJump();
            if (n < n6) {
                LocalDateTime localDateTime3 = this.savingsLocalTransitions[n];
                LocalDateTime localDateTime4 = this.savingsLocalTransitions[n + 1];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.equals:(Ljava/lang/Object;)Z");
                boolean bl = localDateTime3.equals(localDateTime4);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    ++n;
                }
            }
        }
        RuntimeCostAccounter.recordJump();
        if ((n & 1) == 0) {
            LocalDateTime localDateTime5 = this.savingsLocalTransitions[n];
            LocalDateTime localDateTime6 = this.savingsLocalTransitions[n + 1];
            ZoneOffset zoneOffset = this.wallOffsets[n / 2];
            ZoneOffset zoneOffset2 = this.wallOffsets[n / 2 + 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
            int n7 = zoneOffset2.getTotalSeconds();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
            int n8 = zoneOffset.getTotalSeconds();
            RuntimeCostAccounter.recordJump();
            if (n7 > n8) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
                return new ZoneOffsetTransition(localDateTime5, zoneOffset, zoneOffset2);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
            return new ZoneOffsetTransition(localDateTime6, zoneOffset, zoneOffset2);
        }
        return this.wallOffsets[n / 2 + 1];
    }

    private Object findOffsetInfo(LocalDateTime localDateTime, ZoneOffsetTransition zoneOffsetTransition) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeBefore:()Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime2 = zoneOffsetTransition.getDateTimeBefore();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
        boolean bl = zoneOffsetTransition.isGap();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.isBefore:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
            boolean bl2 = localDateTime.isBefore(localDateTime2);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
                return zoneOffsetTransition.getOffsetBefore();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime3 = zoneOffsetTransition.getDateTimeAfter();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.isBefore:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
            boolean bl3 = localDateTime.isBefore(localDateTime3);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                return zoneOffsetTransition;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
            return zoneOffsetTransition.getOffsetAfter();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.isBefore:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
        boolean bl4 = localDateTime.isBefore(localDateTime2);
        RuntimeCostAccounter.recordJump();
        if (!bl4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
            return zoneOffsetTransition.getOffsetAfter();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime4 = zoneOffsetTransition.getDateTimeAfter();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.isBefore:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
        boolean bl5 = localDateTime.isBefore(localDateTime4);
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
            return zoneOffsetTransition.getOffsetBefore();
        }
        return zoneOffsetTransition;
    }

    private ZoneOffsetTransition[] findTransitionArray(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
        Integer n2 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        ZoneOffsetTransition[] zoneOffsetTransitionArray = (ZoneOffsetTransition[])this.lastRulesCache.get(n2);
        RuntimeCostAccounter.recordJump();
        if (zoneOffsetTransitionArray != null) {
            return zoneOffsetTransitionArray;
        }
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = this.lastRules;
        int n3 = zoneOffsetTransitionRuleArray.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        zoneOffsetTransitionArray = new ZoneOffsetTransition[n3];
        int n4 = 0;
        while (true) {
            int n5 = zoneOffsetTransitionRuleArray.length;
            RuntimeCostAccounter.recordJump();
            if (n4 >= n5) break;
            ZoneOffsetTransitionRule zoneOffsetTransitionRule = zoneOffsetTransitionRuleArray[n4];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransitionRule.createTransition:(I)Ljava/time/zone/ZoneOffsetTransition;");
            zoneOffsetTransitionArray[n4] = zoneOffsetTransitionRule.createTransition(n);
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n < 2100) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.lastRulesCache.putIfAbsent(n2, zoneOffsetTransitionArray);
        }
        return zoneOffsetTransitionArray;
    }

    public ZoneOffset getStandardOffset(Instant instant) {
        int n = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return this.standardOffsets[0];
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.binarySearch:([JJ)I");
        int n2 = Arrays.binarySearch(this.standardTransitions, l);
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return this.standardOffsets[n2 + 1];
    }

    public Duration getDaylightSavings(Instant instant) {
        int n = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return Duration.ZERO;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getStandardOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getStandardOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = this.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = zoneOffset2.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l = n2 - zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofSeconds:(J)Ljava/time/Duration;");
        return Duration.ofSeconds(l);
    }

    public boolean isDaylightSavings(Instant instant) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getStandardOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = this.getStandardOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset2 = this.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = zoneOffset.equals(zoneOffset2);
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isValidOffset(LocalDateTime localDateTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getValidOffsets:(Ljava/time/LocalDateTime;)Ljava/util/List;");
        List<ZoneOffset> list = this.getValidOffsets(localDateTime);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.contains:(Ljava/lang/Object;)Z");
        return list.contains(zoneOffset);
    }

    public ZoneOffsetTransition nextTransition(Instant instant) {
        int n = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        long l2 = l - this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 >= 0) {
            ZoneOffsetTransition[] zoneOffsetTransitionArray;
            int n2 = this.lastRules.length;
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return null;
            }
            ZoneOffset zoneOffset = this.wallOffsets[this.wallOffsets.length - 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findYear:(JLjava/time/ZoneOffset;)I");
            int n3 = this.findYear(l, zoneOffset);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findTransitionArray:(I)[Ljava/time/zone/ZoneOffsetTransition;");
            ZoneOffsetTransition[] zoneOffsetTransitionArray2 = zoneOffsetTransitionArray = this.findTransitionArray(n3);
            int n4 = zoneOffsetTransitionArray2.length;
            int n5 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n5 >= n4) break;
                ZoneOffsetTransition zoneOffsetTransition = zoneOffsetTransitionArray2[n5];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.toEpochSecond:()J");
                long l4 = l - zoneOffsetTransition.toEpochSecond();
                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l5 < 0) {
                    return zoneOffsetTransition;
                }
                ++n5;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (n3 < 999999999) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findTransitionArray:(I)[Ljava/time/zone/ZoneOffsetTransition;");
                zoneOffsetTransitionArray = this.findTransitionArray(n3 + 1);
                return zoneOffsetTransitionArray[0];
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.binarySearch:([JJ)I");
        int n6 = Arrays.binarySearch(this.savingsInstantTransitions, l);
        RuntimeCostAccounter.recordJump();
        if (n6 < 0) {
            n6 = -n6 - 1;
            RuntimeCostAccounter.recordJump();
        } else {
            ++n6;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
        long l6 = this.savingsInstantTransitions[n6];
        ZoneOffset zoneOffset = this.wallOffsets[n6];
        ZoneOffset zoneOffset2 = this.wallOffsets[n6 + 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(JLjava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
        return new ZoneOffsetTransition(l6, zoneOffset, zoneOffset2);
    }

    public ZoneOffsetTransition previousTransition(Instant instant) {
        int n = this.savingsInstantTransitions.length;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        int n2 = instant.getNano();
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordJump();
            if (l < Long.MAX_VALUE) {
                ++l;
            }
        }
        long l2 = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        int n3 = this.lastRules.length;
        RuntimeCostAccounter.recordJump();
        if (n3 > 0) {
            RuntimeCostAccounter.recordJump();
            if (l > l2) {
                ZoneOffset zoneOffset = this.wallOffsets[this.wallOffsets.length - 1];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findYear:(JLjava/time/ZoneOffset;)I");
                int n4 = this.findYear(l, zoneOffset);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findTransitionArray:(I)[Ljava/time/zone/ZoneOffsetTransition;");
                ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(n4);
                int n5 = zoneOffsetTransitionArray.length - 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n5 < 0) break;
                    ZoneOffsetTransition zoneOffsetTransition = zoneOffsetTransitionArray[n5];
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.toEpochSecond:()J");
                    long l3 = l - zoneOffsetTransition.toEpochSecond();
                    long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l4 > 0) {
                        return zoneOffsetTransitionArray[n5];
                    }
                    --n5;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findYear:(JLjava/time/ZoneOffset;)I");
                n5 = this.findYear(l2, zoneOffset);
                RuntimeCostAccounter.recordJump();
                if (--n4 > n5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.findTransitionArray:(I)[Ljava/time/zone/ZoneOffsetTransition;");
                    zoneOffsetTransitionArray = this.findTransitionArray(n4);
                    return zoneOffsetTransitionArray[zoneOffsetTransitionArray.length - 1];
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.binarySearch:([JJ)I");
        int n6 = Arrays.binarySearch(this.savingsInstantTransitions, l);
        RuntimeCostAccounter.recordJump();
        if (n6 < 0) {
            n6 = -n6 - 1;
        }
        RuntimeCostAccounter.recordJump();
        if (n6 <= 0) {
            return null;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
        long l5 = this.savingsInstantTransitions[n6 - 1];
        ZoneOffset zoneOffset = this.wallOffsets[n6 - 1];
        ZoneOffset zoneOffset2 = this.wallOffsets[n6];
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(JLjava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
        return new ZoneOffsetTransition(l5, zoneOffset, zoneOffset2);
    }

    private int findYear(long l, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l3 = Math.floorDiv(l2, 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofEpochDay(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
        return localDate.getYear();
    }

    public List<ZoneOffsetTransition> getTransitions() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<ZoneOffsetTransition> arrayList = new ArrayList<ZoneOffsetTransition>();
        int n = 0;
        while (true) {
            int n2 = this.savingsInstantTransitions.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneOffsetTransition");
            long l = this.savingsInstantTransitions[n];
            ZoneOffset zoneOffset = this.wallOffsets[n];
            ZoneOffset zoneOffset2 = this.wallOffsets[n + 1];
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.<init>:(JLjava/time/ZoneOffset;Ljava/time/ZoneOffset;)V");
            ZoneOffsetTransition zoneOffsetTransition = new ZoneOffsetTransition(l, zoneOffset, zoneOffset2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            arrayList.add(zoneOffsetTransition);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableList:(Ljava/util/List;)Ljava/util/List;");
        return Collections.unmodifiableList(arrayList);
    }

    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        List<ZoneOffsetTransitionRule> list = Arrays.asList(this.lastRules);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.unmodifiableList:(Ljava/util/List;)Ljava/util/List;");
        return Collections.unmodifiableList(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ZoneRules;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        ZoneRules zoneRules = (ZoneRules)object;
        long[] lArray = zoneRules.standardTransitions;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.equals:([J[J)Z");
        boolean bl2 = Arrays.equals(this.standardTransitions, lArray);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        Object[] objectArray = zoneRules.standardOffsets;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.equals:([Ljava/lang/Object;[Ljava/lang/Object;)Z");
        boolean bl3 = Arrays.equals(this.standardOffsets, objectArray);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        long[] lArray2 = zoneRules.savingsInstantTransitions;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.equals:([J[J)Z");
        boolean bl4 = Arrays.equals(this.savingsInstantTransitions, lArray2);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        Object[] objectArray2 = zoneRules.wallOffsets;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.equals:([Ljava/lang/Object;[Ljava/lang/Object;)Z");
        boolean bl5 = Arrays.equals(this.wallOffsets, objectArray2);
        RuntimeCostAccounter.recordJump();
        if (!bl5) return false;
        Object[] objectArray3 = zoneRules.lastRules;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.equals:([Ljava/lang/Object;[Ljava/lang/Object;)Z");
        boolean bl6 = Arrays.equals(this.lastRules, objectArray3);
        RuntimeCostAccounter.recordJump();
        if (!bl6) return false;
        boolean bl7 = true;
        RuntimeCostAccounter.recordJump();
        return bl7;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.hashCode:([J)I");
        int n = Arrays.hashCode(this.standardTransitions);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.hashCode:([Ljava/lang/Object;)I");
        int n2 = n ^ Arrays.hashCode(this.standardOffsets);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.hashCode:([J)I");
        int n3 = n2 ^ Arrays.hashCode(this.savingsInstantTransitions);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.hashCode:([Ljava/lang/Object;)I");
        int n4 = n3 ^ Arrays.hashCode(this.wallOffsets);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.hashCode:([Ljava/lang/Object;)I");
        return n4 ^ Arrays.hashCode(this.lastRules);
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("ZoneRules[currentStandardOffset=");
        ZoneOffset zoneOffset = this.standardOffsets[this.standardOffsets.length - 1];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(zoneOffset);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder4.toString();
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_LONG_ARRAY = new long[0];
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_LASTRULES = new ZoneOffsetTransitionRule[0];
        RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
        EMPTY_LDT_ARRAY = new LocalDateTime[0];
    }
}

