/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.temporal;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.LocalDate;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;
import sandbox.java.util.function.UnaryOperator;

public final class TemporalAdjusters {
    private TemporalAdjusters() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static TemporalAdjuster ofDateAdjuster(UnaryOperator<LocalDate> unaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(unaryOperator, "dateBasedAdjuster");
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
            LocalDate localDate = LocalDate.from(temporal);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            LocalDate localDate2 = (LocalDate)unaryOperator.apply(localDate);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/temporal/Temporal;");
            return temporal.with(localDate2);
        };
    }

    public static TemporalAdjuster firstDayOfMonth() {
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            return temporal.with(ChronoField.DAY_OF_MONTH, 1L);
        };
    }

    public static TemporalAdjuster lastDayOfMonth() {
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporal.range(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            long l = valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            return temporal.with(ChronoField.DAY_OF_MONTH, l);
        };
    }

    public static TemporalAdjuster firstDayOfNextMonth() {
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            Temporal temporal2 = temporal.with(ChronoField.DAY_OF_MONTH, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal2.plus(1L, ChronoUnit.MONTHS);
        };
    }

    public static TemporalAdjuster firstDayOfYear() {
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            return temporal.with(ChronoField.DAY_OF_YEAR, 1L);
        };
    }

    public static TemporalAdjuster lastDayOfYear() {
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporal.range(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            long l = valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            return temporal.with(ChronoField.DAY_OF_YEAR, l);
        };
    }

    public static TemporalAdjuster firstDayOfNextYear() {
        return temporal -> {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            Temporal temporal2 = temporal.with(ChronoField.DAY_OF_YEAR, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal2.plus(1L, ChronoUnit.YEARS);
        };
    }

    public static TemporalAdjuster firstInMonth(DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.dayOfWeekInMonth:(ILjava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
        return TemporalAdjusters.dayOfWeekInMonth(1, dayOfWeek);
    }

    public static TemporalAdjuster lastInMonth(DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.dayOfWeekInMonth:(ILjava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
        return TemporalAdjusters.dayOfWeekInMonth(-1, dayOfWeek);
    }

    public static TemporalAdjuster dayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dayOfWeek, "dayOfWeek");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
        int n2 = dayOfWeek.getValue();
        RuntimeCostAccounter.recordJump();
        if (n >= 0) {
            return temporal -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
                Temporal temporal2 = temporal.with(ChronoField.DAY_OF_MONTH, 1L);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
                int n3 = temporal2.get(ChronoField.DAY_OF_WEEK);
                int n4 = (n2 - n3 + 7) % 7;
                n4 = (int)((long)n4 + ((long)n - 1L) * 7L);
                long l = n4;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
                return temporal2.plus(l, ChronoUnit.DAYS);
            };
        }
        return temporal -> {
            int n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = temporal.range(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            long l = valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
            Temporal temporal2 = temporal.with(ChronoField.DAY_OF_MONTH, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
            int n4 = temporal2.get(ChronoField.DAY_OF_WEEK);
            int n5 = n2 - n4;
            RuntimeCostAccounter.recordJump();
            if (n5 == 0) {
                n3 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n5 > 0) {
                    n3 = n5 - 7;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n3 = n5;
                }
            }
            n5 = n3;
            n5 = (int)((long)n5 - ((long)(-n) - 1L) * 7L);
            long l2 = n5;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal2.plus(l2, ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster next(DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
        int n = dayOfWeek.getValue();
        return temporal -> {
            long l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            int n3 = n2 - n;
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                l = 7 - n3;
                RuntimeCostAccounter.recordJump();
            } else {
                l = -n3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal.plus(l, ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster nextOrSame(DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
        int n = dayOfWeek.getValue();
        return temporal -> {
            long l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            RuntimeCostAccounter.recordJump();
            if (n2 == n) {
                return temporal;
            }
            int n3 = n2 - n;
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                l = 7 - n3;
                RuntimeCostAccounter.recordJump();
            } else {
                l = -n3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal.plus(l, ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster previous(DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
        int n = dayOfWeek.getValue();
        return temporal -> {
            long l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            int n3 = n - n2;
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                l = 7 - n3;
                RuntimeCostAccounter.recordJump();
            } else {
                l = -n3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal.minus(l, ChronoUnit.DAYS);
        };
    }

    public static TemporalAdjuster previousOrSame(DayOfWeek dayOfWeek) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
        int n = dayOfWeek.getValue();
        return temporal -> {
            long l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporal.get(ChronoField.DAY_OF_WEEK);
            RuntimeCostAccounter.recordJump();
            if (n2 == n) {
                return temporal;
            }
            int n3 = n - n2;
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                l = 7 - n3;
                RuntimeCostAccounter.recordJump();
            } else {
                l = -n3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/temporal/Temporal;");
            return temporal.minus(l, ChronoUnit.DAYS);
        };
    }
}

