/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.format;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Period;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.util.HashMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;

final class Parsed
implements TemporalAccessor {
    final Map<TemporalField, Long> fieldValues;
    ZoneId zone;
    Chronology chrono;
    boolean leapSecond;
    private ResolverStyle resolverStyle;
    private ChronoLocalDate date;
    private LocalTime time;
    Period excessDays;

    Parsed() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        this.fieldValues = new HashMap<TemporalField, Long>();
        this.excessDays = Period.ZERO;
    }

    Parsed copy() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/Parsed");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.<init>:()V");
        Parsed parsed = new Parsed();
        Map<TemporalField, Long> map = parsed.fieldValues;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.putAll:(Ljava/util/Map;)V");
        map.putAll(this.fieldValues);
        parsed.zone = this.zone;
        parsed.chrono = this.chrono;
        parsed.leapSecond = this.leapSecond;
        return parsed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl = this.fieldValues.containsKey(temporalField);
        RuntimeCostAccounter.recordJump();
        if (bl) return true;
        RuntimeCostAccounter.recordJump();
        if (this.date != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl2 = this.date.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl2) return true;
        }
        RuntimeCostAccounter.recordJump();
        if (this.time != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl3 = this.time.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                return true;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        boolean bl4 = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl4) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl5 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl5) return false;
        boolean bl6 = true;
        RuntimeCostAccounter.recordJump();
        return bl6;
    }

    @Override
    public long getLong(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l = this.fieldValues.get(temporalField);
        RuntimeCostAccounter.recordJump();
        if (l != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            return l;
        }
        RuntimeCostAccounter.recordJump();
        if (this.date != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl = this.date.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                return this.date.getLong(temporalField);
            }
        }
        RuntimeCostAccounter.recordJump();
        if (this.time != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl = this.time.isSupported(temporalField);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getLong:(Ljava/time/temporal/TemporalField;)J");
                return this.time.getLong(temporalField);
            }
        }
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        block11: {
            block10: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery2 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) {
                    return (R)this.zone;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<Chronology> temporalQuery3 = TemporalQueries.chronology();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery3) {
                    return (R)this.chrono;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<LocalDate> temporalQuery4 = TemporalQueries.localDate();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery4) {
                    LocalDate localDate;
                    RuntimeCostAccounter.recordJump();
                    if (this.date != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
                        localDate = LocalDate.from(this.date);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        localDate = null;
                    }
                    return (R)localDate;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<LocalTime> temporalQuery5 = TemporalQueries.localTime();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery5) {
                    return (R)this.time;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery6 = TemporalQueries.zone();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery6) break block10;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneOffset> temporalQuery7 = TemporalQueries.offset();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery7) break block11;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
            return temporalQuery.queryFrom(this);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery8 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery8) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    TemporalAccessor resolve(ResolverStyle resolverStyle, Set<TemporalField> set) {
        RuntimeCostAccounter.recordJump();
        if (set != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.keySet:()Ljava/util/Set;");
            Set<TemporalField> set2 = this.fieldValues.keySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.retainAll:(Ljava/util/Collection;)Z");
            set2.retainAll(set);
        }
        this.resolverStyle = resolverStyle;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveFields:()V");
        this.resolveFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveTimeLenient:()V");
        this.resolveTimeLenient();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.crossCheck:()V");
        this.crossCheck();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolvePeriod:()V");
        this.resolvePeriod();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveFractional:()V");
        this.resolveFractional();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveInstant:()V");
        this.resolveInstant();
        return this;
    }

    private void resolveFields() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveInstantFields:()V");
        this.resolveInstantFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveDateFields:()V");
        this.resolveDateFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveTimeFields:()V");
        this.resolveTimeFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n = this.fieldValues.size();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            int n2;
            block14: {
                n2 = 0;
                block0: while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= 50) break block14;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                    Set<Map.Entry<TemporalField, Long>> set = this.fieldValues.entrySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                    Iterator<Map.Entry<TemporalField, Long>> iterator = set.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block0;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        Map.Entry<TemporalField, Long> entry = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        TemporalField temporalField = entry.getKey();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.resolve:(Ljava/util/Map;Ljava/time/temporal/TemporalAccessor;Ljava/time/format/ResolverStyle;)Ljava/time/temporal/TemporalAccessor;");
                        ChronoLocalDateTime chronoLocalDateTime = temporalField.resolve(this.fieldValues, this, this.resolverStyle);
                        RuntimeCostAccounter.recordJump();
                        if (chronoLocalDateTime != null) {
                            Comparable<ChronoZonedDateTime<?>> comparable;
                            boolean bl2 = chronoLocalDateTime instanceof ChronoZonedDateTime;
                            RuntimeCostAccounter.recordJump();
                            if (bl2) {
                                comparable = (ChronoZonedDateTime)((Object)chronoLocalDateTime);
                                RuntimeCostAccounter.recordJump();
                                if (this.zone == null) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getZone:()Ljava/time/ZoneId;");
                                    this.zone = comparable.getZone();
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getZone:()Ljava/time/ZoneId;");
                                    ZoneId zoneId = comparable.getZone();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
                                    boolean bl3 = this.zone.equals(zoneId);
                                    RuntimeCostAccounter.recordJump();
                                    if (!bl3) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                        StringBuilder stringBuilder = new StringBuilder();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder2 = stringBuilder.append("ChronoZonedDateTime must use the effective parsed zone: ");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder3 = stringBuilder2.append(this.zone);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                        String string = stringBuilder3.toString();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                                        DateTimeException dateTimeException = new DateTimeException(string);
                                        RuntimeCostAccounter.recordThrow();
                                        throw dateTimeException;
                                    }
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDateTime:()Ljava/time/chrono/ChronoLocalDateTime;");
                                chronoLocalDateTime = comparable.toLocalDateTime();
                            }
                            boolean bl4 = chronoLocalDateTime instanceof ChronoLocalDateTime;
                            RuntimeCostAccounter.recordJump();
                            if (bl4) {
                                comparable = chronoLocalDateTime;
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
                                LocalTime localTime = comparable.toLocalTime();
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/LocalTime;Ljava/time/Period;)V");
                                this.updateCheckConflict(localTime, Period.ZERO);
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
                                Object d = comparable.toLocalDate();
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/chrono/ChronoLocalDate;)V");
                                this.updateCheckConflict((ChronoLocalDate)d);
                                ++n2;
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                            boolean bl5 = chronoLocalDateTime instanceof ChronoLocalDate;
                            RuntimeCostAccounter.recordJump();
                            if (bl5) {
                                ChronoLocalDate chronoLocalDate = (ChronoLocalDate)((Object)chronoLocalDateTime);
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/chrono/ChronoLocalDate;)V");
                                this.updateCheckConflict(chronoLocalDate);
                                ++n2;
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                            boolean bl6 = chronoLocalDateTime instanceof LocalTime;
                            RuntimeCostAccounter.recordJump();
                            if (bl6) {
                                LocalTime localTime = (LocalTime)((Object)chronoLocalDateTime);
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/LocalTime;Ljava/time/Period;)V");
                                this.updateCheckConflict(localTime, Period.ZERO);
                                ++n2;
                                RuntimeCostAccounter.recordJump();
                                continue block0;
                            }
                            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                            DateTimeException dateTimeException = new DateTimeException("Method resolve() can only return ChronoZonedDateTime, ChronoLocalDateTime, ChronoLocalDate or LocalTime");
                            RuntimeCostAccounter.recordThrow();
                            throw dateTimeException;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                        boolean bl7 = this.fieldValues.containsKey(temporalField);
                        RuntimeCostAccounter.recordJump();
                        if (!bl7) {
                            ++n2;
                            RuntimeCostAccounter.recordJump();
                            continue block0;
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    break;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == 50) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException("One of the parsed fields has an incorrectly implemented resolve method");
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveInstantFields:()V");
                this.resolveInstantFields();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveDateFields:()V");
                this.resolveDateFields();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveTimeFields:()V");
                this.resolveTimeFields();
            }
        }
    }

    private void updateCheckConflict(TemporalField temporalField, TemporalField temporalField2, Long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        Long l2 = this.fieldValues.put(temporalField2, l);
        RuntimeCostAccounter.recordJump();
        if (l2 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l3 = l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = l3 - l;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 != false) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Conflict found: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(temporalField2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(" ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(" differs from ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(temporalField2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(" ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder10 = stringBuilder9.append(" while resolving  ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder11 = stringBuilder10.append(temporalField);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder11.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
    }

    private void resolveInstantFields() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl = this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (this.zone != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveInstantFields0:(Ljava/time/ZoneId;)V");
                this.resolveInstantFields0(this.zone);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                Long l = this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                RuntimeCostAccounter.recordJump();
                if (l != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
                    int n = l.intValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveInstantFields0:(Ljava/time/ZoneId;)V");
                    this.resolveInstantFields0(zoneOffset);
                }
            }
        }
    }

    private void resolveInstantFields0(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = this.fieldValues.remove(ChronoField.INSTANT_SECONDS);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(J)Ljava/time/Instant;");
        Instant instant = Instant.ofEpochSecond(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.zonedDateTime:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
        ChronoZonedDateTime<? extends ChronoLocalDate> chronoZonedDateTime = this.chrono.zonedDateTime(instant, zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = chronoZonedDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/chrono/ChronoLocalDate;)V");
        this.updateCheckConflict(chronoLocalDate);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = chronoZonedDateTime.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toSecondOfDay:()I");
        long l2 = localTime.toSecondOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l3 = l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
        this.updateCheckConflict(ChronoField.INSTANT_SECONDS, ChronoField.SECOND_OF_DAY, l3);
    }

    private void resolveDateFields() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.resolveDate:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.chrono.resolveDate(this.fieldValues, this.resolverStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/chrono/ChronoLocalDate;)V");
        this.updateCheckConflict(chronoLocalDate);
    }

    private void updateCheckConflict(ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordJump();
        if (this.date != null) {
            RuntimeCostAccounter.recordJump();
            if (chronoLocalDate != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.date.equals(chronoLocalDate);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Conflict found: Fields resolved to two different dates: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(this.date);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(" ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(chronoLocalDate);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder5.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
            }
        } else {
            RuntimeCostAccounter.recordJump();
            if (chronoLocalDate != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
                Chronology chronology = chronoLocalDate.getChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
                boolean bl = this.chrono.equals(chronology);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder.append("ChronoLocalDate must use the effective parsed chronology: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(this.chrono);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder7.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                this.date = chronoLocalDate;
            }
        }
    }

    private void resolveTimeFields() {
        long l;
        long l2;
        block37: {
            long l3;
            block39: {
                block38: {
                    block34: {
                        long l4;
                        block36: {
                            block35: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                                boolean bl = this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_DAY);
                                RuntimeCostAccounter.recordJump();
                                if (!bl) break block34;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                l2 = this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_DAY);
                                RuntimeCostAccounter.recordJump();
                                if (this.resolverStyle == ResolverStyle.STRICT) break block35;
                                RuntimeCostAccounter.recordJump();
                                if (this.resolverStyle != ResolverStyle.SMART) break block36;
                                RuntimeCostAccounter.recordJump();
                                if (l2 == 0L) break block36;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                            ChronoField.CLOCK_HOUR_OF_DAY.checkValidValue(l2);
                        }
                        RuntimeCostAccounter.recordJump();
                        if (l2 == 24L) {
                            l4 = 0L;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            l4 = l2;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l5 = l4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
                        this.updateCheckConflict(ChronoField.CLOCK_HOUR_OF_DAY, ChronoField.HOUR_OF_DAY, l5);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl = this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_AMPM);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block37;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                    l2 = this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_AMPM);
                    RuntimeCostAccounter.recordJump();
                    if (this.resolverStyle == ResolverStyle.STRICT) break block38;
                    RuntimeCostAccounter.recordJump();
                    if (this.resolverStyle != ResolverStyle.SMART) break block39;
                    RuntimeCostAccounter.recordJump();
                    if (l2 == 0L) break block39;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.CLOCK_HOUR_OF_AMPM.checkValidValue(l2);
            }
            RuntimeCostAccounter.recordJump();
            if (l2 == 12L) {
                l3 = 0L;
                RuntimeCostAccounter.recordJump();
            } else {
                l3 = l2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l6 = l3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.CLOCK_HOUR_OF_AMPM, ChronoField.HOUR_OF_AMPM, l6);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl = this.fieldValues.containsKey(ChronoField.AMPM_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl2 = this.fieldValues.containsKey(ChronoField.HOUR_OF_AMPM);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l2 = this.fieldValues.remove(ChronoField.AMPM_OF_DAY);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l = this.fieldValues.remove(ChronoField.HOUR_OF_AMPM);
                RuntimeCostAccounter.recordJump();
                if (this.resolverStyle == ResolverStyle.LENIENT) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l7 = Math.multiplyExact(l2, 12L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                    long l8 = Math.addExact(l7, l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l9 = l8;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
                    this.updateCheckConflict(ChronoField.AMPM_OF_DAY, ChronoField.HOUR_OF_DAY, l9);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                    ChronoField.AMPM_OF_DAY.checkValidValue(l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                    ChronoField.HOUR_OF_AMPM.checkValidValue(l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l10 = l2 * 12L + l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
                    this.updateCheckConflict(ChronoField.AMPM_OF_DAY, ChronoField.HOUR_OF_DAY, l10);
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl3 = this.fieldValues.containsKey(ChronoField.NANO_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            l2 = this.fieldValues.remove(ChronoField.NANO_OF_DAY);
            RuntimeCostAccounter.recordJump();
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.NANO_OF_DAY.checkValidValue(l2);
            }
            long l11 = l2 / 3600000000000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l12 = l11;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.HOUR_OF_DAY, l12);
            long l13 = l2 / 60000000000L % 60L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l14 = l13;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.MINUTE_OF_HOUR, l14);
            long l15 = l2 / 1000000000L % 60L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l16 = l15;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.SECOND_OF_MINUTE, l16);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l17 = l2 % 1000000000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.NANO_OF_SECOND, l17);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl4 = this.fieldValues.containsKey(ChronoField.MICRO_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            l2 = this.fieldValues.remove(ChronoField.MICRO_OF_DAY);
            RuntimeCostAccounter.recordJump();
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.MICRO_OF_DAY.checkValidValue(l2);
            }
            long l18 = l2 / 1000000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l19 = l18;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.MICRO_OF_DAY, ChronoField.SECOND_OF_DAY, l19);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l20 = l2 % 1000000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.MICRO_OF_DAY, ChronoField.MICRO_OF_SECOND, l20);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl5 = this.fieldValues.containsKey(ChronoField.MILLI_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            l2 = this.fieldValues.remove(ChronoField.MILLI_OF_DAY);
            RuntimeCostAccounter.recordJump();
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.MILLI_OF_DAY.checkValidValue(l2);
            }
            long l21 = l2 / 1000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l22 = l21;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.MILLI_OF_DAY, ChronoField.SECOND_OF_DAY, l22);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l23 = l2 % 1000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.MILLI_OF_DAY, ChronoField.MILLI_OF_SECOND, l23);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl6 = this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl6) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            l2 = this.fieldValues.remove(ChronoField.SECOND_OF_DAY);
            RuntimeCostAccounter.recordJump();
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.SECOND_OF_DAY.checkValidValue(l2);
            }
            long l24 = l2 / 3600L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l25 = l24;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.HOUR_OF_DAY, l25);
            long l26 = l2 / 60L % 60L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l27 = l26;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.MINUTE_OF_HOUR, l27);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l28 = l2 % 60L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.SECOND_OF_MINUTE, l28);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl7 = this.fieldValues.containsKey(ChronoField.MINUTE_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl7) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            l2 = this.fieldValues.remove(ChronoField.MINUTE_OF_DAY);
            RuntimeCostAccounter.recordJump();
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.MINUTE_OF_DAY.checkValidValue(l2);
            }
            long l29 = l2 / 60L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l30 = l29;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.MINUTE_OF_DAY, ChronoField.HOUR_OF_DAY, l30);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
            Long l31 = l2 % 60L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
            this.updateCheckConflict(ChronoField.MINUTE_OF_DAY, ChronoField.MINUTE_OF_HOUR, l31);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl8 = this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND);
        RuntimeCostAccounter.recordJump();
        if (bl8) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            l2 = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
            RuntimeCostAccounter.recordJump();
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.NANO_OF_SECOND.checkValidValue(l2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl9 = this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND);
            RuntimeCostAccounter.recordJump();
            if (bl9) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l = this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                RuntimeCostAccounter.recordJump();
                if (this.resolverStyle != ResolverStyle.LENIENT) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                    ChronoField.MICRO_OF_SECOND.checkValidValue(l);
                }
                l2 = l * 1000L + l2 % 1000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l32 = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
                this.updateCheckConflict(ChronoField.MICRO_OF_SECOND, ChronoField.NANO_OF_SECOND, l32);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl10 = this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND);
            RuntimeCostAccounter.recordJump();
            if (bl10) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l = this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
                RuntimeCostAccounter.recordJump();
                if (this.resolverStyle != ResolverStyle.LENIENT) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                    ChronoField.MILLI_OF_SECOND.checkValidValue(l);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l33 = l * 1000000L + l2 % 1000000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
                this.updateCheckConflict(ChronoField.MILLI_OF_SECOND, ChronoField.NANO_OF_SECOND, l33);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl11 = this.fieldValues.containsKey(ChronoField.HOUR_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl11) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl12 = this.fieldValues.containsKey(ChronoField.MINUTE_OF_HOUR);
            RuntimeCostAccounter.recordJump();
            if (bl12) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl13 = this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE);
                RuntimeCostAccounter.recordJump();
                if (bl13) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl14 = this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND);
                    RuntimeCostAccounter.recordJump();
                    if (bl14) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        l2 = this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        l = this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l34 = this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l35 = this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveTime:(JJJJ)V");
                        this.resolveTime(l2, l, l34, l35);
                    }
                }
            }
        }
    }

    private void resolveTimeLenient() {
        Object object;
        Object object2;
        Object object3;
        block19: {
            long l;
            long l2;
            long l3;
            Long l4;
            block22: {
                block21: {
                    block20: {
                        long l5;
                        RuntimeCostAccounter.recordJump();
                        if (this.time != null) break block19;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                        boolean bl = this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            l5 = this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                            boolean bl2 = this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND);
                            RuntimeCostAccounter.recordJump();
                            if (bl2) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                long l6 = l5 * 1000L + this.fieldValues.get(ChronoField.MICRO_OF_SECOND) % 1000L;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                                Long l7 = l6;
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/temporal/TemporalField;Ljava/time/temporal/TemporalField;Ljava/lang/Long;)V");
                                this.updateCheckConflict(ChronoField.MILLI_OF_SECOND, ChronoField.MICRO_OF_SECOND, l7);
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                                this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                                Long l8 = l6 * 1000L;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                                this.fieldValues.put(ChronoField.NANO_OF_SECOND, l8);
                                RuntimeCostAccounter.recordJump();
                            } else {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                                Long l9 = l5 * 1000000L;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                                this.fieldValues.put(ChronoField.NANO_OF_SECOND, l9);
                            }
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                            boolean bl3 = this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND);
                            RuntimeCostAccounter.recordJump();
                            if (bl3) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                l5 = this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                                Long l10 = l5 * 1000L;
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                                this.fieldValues.put(ChronoField.NANO_OF_SECOND, l10);
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        object3 = this.fieldValues.get(ChronoField.HOUR_OF_DAY);
                        RuntimeCostAccounter.recordJump();
                        if (object3 == null) break block19;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        object2 = this.fieldValues.get(ChronoField.MINUTE_OF_HOUR);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        object = this.fieldValues.get(ChronoField.SECOND_OF_MINUTE);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                        l4 = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                        RuntimeCostAccounter.recordJump();
                        if (object2 != null) break block20;
                        RuntimeCostAccounter.recordJump();
                        if (object != null) break block21;
                        RuntimeCostAccounter.recordJump();
                        if (l4 != null) break block21;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (object2 == null) break block22;
                    RuntimeCostAccounter.recordJump();
                    if (object != null) break block22;
                    RuntimeCostAccounter.recordJump();
                    if (l4 == null) break block22;
                }
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (object2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l3 = (Long)object2;
                RuntimeCostAccounter.recordJump();
            } else {
                l3 = 0L;
            }
            long l11 = l3;
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l2 = (Long)object;
                RuntimeCostAccounter.recordJump();
            } else {
                l2 = 0L;
            }
            long l12 = l2;
            RuntimeCostAccounter.recordJump();
            if (l4 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                l = l4;
                RuntimeCostAccounter.recordJump();
            } else {
                l = 0L;
            }
            long l13 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l14 = (Long)object3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolveTime:(JJJJ)V");
            this.resolveTime(l14, l11, l12, l13);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
        }
        RuntimeCostAccounter.recordJump();
        if (this.resolverStyle != ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
            int n = this.fieldValues.size();
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set<Map.Entry<TemporalField, Long>> set = this.fieldValues.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                object3 = set.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = object3.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    object2 = (Map.Entry)object3.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    object = (TemporalField)object2.getKey();
                    boolean bl4 = object instanceof ChronoField;
                    RuntimeCostAccounter.recordJump();
                    if (bl4) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isTimeBased:()Z");
                        boolean bl5 = object.isTimeBased();
                        RuntimeCostAccounter.recordJump();
                        if (bl5) {
                            ChronoField chronoField = (ChronoField)object;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                            Long l = (Long)object2.getValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            long l15 = l;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                            chronoField.checkValidValue(l15);
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resolveTime(long l, long l2, long l3, long l4) {
        RuntimeCostAccounter.recordJump();
        if (this.resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            long l5 = Math.multiplyExact(l, 3600000000000L);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            long l6 = Math.multiplyExact(l2, 60000000000L);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
            l5 = Math.addExact(l5, l6);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            long l7 = Math.multiplyExact(l3, 1000000000L);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
            l5 = Math.addExact(l5, l7);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
            l5 = Math.addExact(l5, l4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
            int n = (int)Math.floorDiv(l5, 86400000000000L);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
            long l8 = Math.floorMod(l5, 86400000000000L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
            LocalTime localTime = LocalTime.ofNanoOfDay(l8);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.ofDays:(I)Ljava/time/Period;");
            Period period = Period.ofDays(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/LocalTime;Ljava/time/Period;)V");
            this.updateCheckConflict(localTime, period);
            RuntimeCostAccounter.recordJump();
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n = ChronoField.MINUTE_OF_HOUR.checkValidIntValue(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n2 = ChronoField.NANO_OF_SECOND.checkValidIntValue(l4);
        RuntimeCostAccounter.recordJump();
        if (this.resolverStyle == ResolverStyle.SMART) {
            RuntimeCostAccounter.recordJump();
            if (l == 24L) {
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    RuntimeCostAccounter.recordJump();
                    if (l3 == 0L) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 == 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.ofDays:(I)Ljava/time/Period;");
                            Period period = Period.ofDays(1);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/LocalTime;Ljava/time/Period;)V");
                            this.updateCheckConflict(LocalTime.MIDNIGHT, period);
                            RuntimeCostAccounter.recordJump();
                            return;
                        }
                    }
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n3 = ChronoField.HOUR_OF_DAY.checkValidIntValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n4 = ChronoField.SECOND_OF_MINUTE.checkValidIntValue(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(IIII)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n3, n, n4, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.updateCheckConflict:(Ljava/time/LocalTime;Ljava/time/Period;)V");
        this.updateCheckConflict(localTime, Period.ZERO);
    }

    private void resolvePeriod() {
        RuntimeCostAccounter.recordJump();
        if (this.date != null) {
            RuntimeCostAccounter.recordJump();
            if (this.time != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.isZero:()Z");
                boolean bl = this.excessDays.isZero();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/chrono/ChronoLocalDate;");
                    this.date = this.date.plus(this.excessDays);
                    this.excessDays = Period.ZERO;
                }
            }
        }
    }

    private void resolveFractional() {
        block5: {
            block6: {
                RuntimeCostAccounter.recordJump();
                if (this.time != null) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl = this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS);
                RuntimeCostAccounter.recordJump();
                if (bl) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl2 = this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY);
                RuntimeCostAccounter.recordJump();
                if (bl2) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl3 = this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE);
                RuntimeCostAccounter.recordJump();
                if (!bl3) break block5;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl = this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                long l2 = l / 1000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l3 = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, l3);
                long l4 = l / 1000000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l5 = l4;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, l5);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l = 0L;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.fieldValues.put(ChronoField.NANO_OF_SECOND, l);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l6 = 0L;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, l6);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l7 = 0L;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, l7);
            }
        }
    }

    private void resolveInstant() {
        RuntimeCostAccounter.recordJump();
        if (this.date != null) {
            RuntimeCostAccounter.recordJump();
            if (this.time != null) {
                RuntimeCostAccounter.recordJump();
                if (this.zone != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
                    ChronoLocalDateTime<?> chronoLocalDateTime = this.date.atTime(this.time);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.atZone:(Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
                    ChronoZonedDateTime<?> chronoZonedDateTime = chronoLocalDateTime.atZone(this.zone);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l = chronoZonedDateTime.getLong(ChronoField.INSTANT_SECONDS);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l2 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    this.fieldValues.put(ChronoField.INSTANT_SECONDS, l2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Long l = this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                    RuntimeCostAccounter.recordJump();
                    if (l != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
                        int n = l.intValue();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
                        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
                        ChronoLocalDateTime<?> chronoLocalDateTime = this.date.atTime(this.time);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.atZone:(Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
                        ChronoZonedDateTime<?> chronoZonedDateTime = chronoLocalDateTime.atZone(zoneOffset);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.getLong:(Ljava/time/temporal/TemporalField;)J");
                        long l3 = chronoZonedDateTime.getLong(ChronoField.INSTANT_SECONDS);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l4 = l3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.fieldValues.put(ChronoField.INSTANT_SECONDS, l4);
                    }
                }
            }
        }
    }

    private void updateCheckConflict(LocalTime localTime, Period period) {
        RuntimeCostAccounter.recordJump();
        if (this.time != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.equals:(Ljava/lang/Object;)Z");
            boolean bl = this.time.equals(localTime);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Conflict found: Fields resolved to different times: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(this.time);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(" ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(localTime);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.isZero:()Z");
            boolean bl2 = this.excessDays.isZero();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.isZero:()Z");
                boolean bl3 = period.isZero();
                RuntimeCostAccounter.recordJump();
                if (!bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.equals:(Ljava/lang/Object;)Z");
                    boolean bl4 = this.excessDays.equals(period);
                    RuntimeCostAccounter.recordJump();
                    if (!bl4) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder.append("Conflict found: Fields resolved to different excess periods: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder7 = stringBuilder6.append(this.excessDays);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder8 = stringBuilder7.append(" ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder9 = stringBuilder8.append(period);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder9.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            this.excessDays = period;
            RuntimeCostAccounter.recordJump();
        } else {
            this.time = localTime;
            this.excessDays = period;
        }
    }

    private void crossCheck() {
        RuntimeCostAccounter.recordJump();
        if (this.date != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.crossCheck:(Ljava/time/temporal/TemporalAccessor;)V");
            this.crossCheck(this.date);
        }
        RuntimeCostAccounter.recordJump();
        if (this.time != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.crossCheck:(Ljava/time/temporal/TemporalAccessor;)V");
            this.crossCheck(this.time);
            RuntimeCostAccounter.recordJump();
            if (this.date != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
                int n = this.fieldValues.size();
                RuntimeCostAccounter.recordJump();
                if (n > 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
                    ChronoLocalDateTime<?> chronoLocalDateTime = this.date.atTime(this.time);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.crossCheck:(Ljava/time/temporal/TemporalAccessor;)V");
                    this.crossCheck(chronoLocalDateTime);
                }
            }
        }
    }

    private void crossCheck(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Map.Entry<TemporalField, Long>> set = this.fieldValues.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Map.Entry<TemporalField, Long>> iterator = set.iterator();
        while (true) {
            block4: {
                long l;
                TemporalField temporalField;
                Map.Entry<TemporalField, Long> entry;
                block5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    entry = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    temporalField = entry.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                    boolean bl2 = temporalAccessor.isSupported(temporalField);
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) break block4;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
                        l = temporalAccessor.getLong(temporalField);
                    }
                    catch (RuntimeException runtimeException) {
                        RuntimeCostAccounter.recordJump();
                    }
                    break block5;
                    continue;
                }
                RuntimeCostAccounter.recordJump();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l2 = entry.getValue();
                RuntimeCostAccounter.recordJump();
                if (l != l2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Conflict found: Field ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(" ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append(" differs from ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(temporalField);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder8 = stringBuilder7.append(" ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder9 = stringBuilder8.append(l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder10 = stringBuilder9.append(" derived from ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder11 = stringBuilder10.append(temporalAccessor);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder11.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.remove:()V");
                iterator.remove();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public String toString() {
        StringBuilder stringBuilder;
        block8: {
            block7: {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
                stringBuilder = new StringBuilder(64);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(this.fieldValues);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(',');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder3.append(this.chrono);
                RuntimeCostAccounter.recordJump();
                if (this.zone != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder.append(',');
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    stringBuilder4.append(this.zone);
                }
                RuntimeCostAccounter.recordJump();
                if (this.date != null) break block7;
                RuntimeCostAccounter.recordJump();
                if (this.time == null) break block8;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(" resolved to ");
            RuntimeCostAccounter.recordJump();
            if (this.date != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder.append(this.date);
                RuntimeCostAccounter.recordJump();
                if (this.time != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder.append('T');
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    stringBuilder5.append(this.time);
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                stringBuilder.append(this.time);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder.toString();
    }
}

