/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.format;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.chrono.JapaneseChronology;
import sandbox.java.time.format.TextStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.IsoFields;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Collection;
import sandbox.java.util.Collections;
import sandbox.java.util.Comparator;
import sandbox.java.util.HashMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.ResourceBundle;
import sandbox.java.util.Set;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.sun.util.locale.provider.CalendarDataUtility;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleResources;

class DateTimeTextProvider {
    private static final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> CACHE;
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR;

    DateTimeTextProvider() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    static DateTimeTextProvider getInstance() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.<init>:()V");
        return new DateTimeTextProvider();
    }

    public String getText(TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.findStore:(Ljava/time/temporal/TemporalField;Ljava/util/Locale;)Ljava/lang/Object;");
        Object object = this.findStore(temporalField, locale);
        boolean bl = object instanceof LocaleStore;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocaleStore localeStore = (LocaleStore)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.getText:(JLjava/time/format/TextStyle;)Ljava/lang/String;");
            return localeStore.getText(l, textStyle);
        }
        return null;
    }

    public String getText(Chronology chronology, TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
        int n;
        int n2;
        block18: {
            block17: {
                RuntimeCostAccounter.recordJump();
                if (chronology == IsoChronology.INSTANCE) break block17;
                boolean bl = temporalField instanceof ChronoField;
                RuntimeCostAccounter.recordJump();
                if (bl) break block18;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getText:(Ljava/time/temporal/TemporalField;JLjava/time/format/TextStyle;Ljava/util/Locale;)Ljava/lang/String;");
            return this.getText(temporalField, l, textStyle, locale);
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.ERA) {
            n2 = 0;
            RuntimeCostAccounter.recordJump();
            if (chronology == JapaneseChronology.INSTANCE) {
                RuntimeCostAccounter.recordJump();
                if (l == -999L) {
                    n = 0;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = (int)l + 2;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                n = (int)l;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.MONTH_OF_YEAR) {
                n2 = 2;
                n = (int)l - 1;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (temporalField == ChronoField.DAY_OF_WEEK) {
                    n2 = 7;
                    n = (int)l + 1;
                    RuntimeCostAccounter.recordJump();
                    if (n > 7) {
                        n = 1;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (temporalField == ChronoField.AMPM_OF_DAY) {
                        n2 = 9;
                        n = (int)l;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        return null;
                    }
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
        String string = chronology.getCalendarType();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
        int n3 = textStyle.toCalendarStyle();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueName:(Ljava/lang/String;IIILjava/util/Locale;)Ljava/lang/String;");
        return CalendarDataUtility.retrieveJavaTimeFieldValueName((String)string, (int)n2, (int)n, (int)n3, (Locale)locale);
    }

    public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField temporalField, TextStyle textStyle, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.findStore:(Ljava/time/temporal/TemporalField;Ljava/util/Locale;)Ljava/lang/Object;");
        Object object = this.findStore(temporalField, locale);
        boolean bl = object instanceof LocaleStore;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocaleStore localeStore = (LocaleStore)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.getTextIterator:(Ljava/time/format/TextStyle;)Ljava/util/Iterator;");
            return localeStore.getTextIterator(textStyle);
        }
        return null;
    }

    public Iterator<Map.Entry<String, Long>> getTextIterator(Chronology chronology, TemporalField temporalField, TextStyle textStyle, Locale locale) {
        int n;
        int n2;
        block25: {
            block24: {
                RuntimeCostAccounter.recordJump();
                if (chronology == IsoChronology.INSTANCE) break block24;
                boolean bl = temporalField instanceof ChronoField;
                RuntimeCostAccounter.recordJump();
                if (bl) break block25;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getTextIterator:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;Ljava/util/Locale;)Ljava/util/Iterator;");
            return this.getTextIterator(temporalField, textStyle, locale);
        }
        ChronoField chronoField = (ChronoField)temporalField;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
        switch (2.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
            case 1: {
                n2 = 0;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 2: {
                n2 = 2;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 3: {
                n2 = 7;
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 4: {
                n2 = 9;
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                return null;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (textStyle == null) {
            n = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
            n = textStyle.toCalendarStyle();
        }
        int n3 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
        String string = chronology.getCalendarType();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueNames:(Ljava/lang/String;IILjava/util/Locale;)Ljava/util/Map;");
        Map map = CalendarDataUtility.retrieveJavaTimeFieldValueNames((String)string, (int)n2, (int)n3, (Locale)locale);
        RuntimeCostAccounter.recordJump();
        if (map == null) {
            return null;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.size:()I");
        int n4 = map.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
        ArrayList arrayList = new ArrayList(n4);
        block6 : switch (n2) {
            case 0: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set set = map.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                Iterator iterator = set.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry entry = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Integer n5 = (Integer)entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    int n6 = n5;
                    RuntimeCostAccounter.recordJump();
                    if (chronology == JapaneseChronology.INSTANCE) {
                        RuntimeCostAccounter.recordJump();
                        if (n6 == 0) {
                            n6 = -999;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n6 -= 2;
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    Object k = entry.getKey();
                    long l = n6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l2 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createEntry:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
                    Map.Entry entry2 = DateTimeTextProvider.createEntry(k, l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(entry2);
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set set = map.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                Iterator iterator = set.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry entry = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    Object k = entry.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Integer n7 = (Integer)entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    long l = n7 + 1;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l3 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createEntry:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
                    Map.Entry entry3 = DateTimeTextProvider.createEntry(k, l3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(entry3);
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set set = map.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                Iterator iterator = set.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry entry = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    Object k = entry.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Integer n8 = (Integer)entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    int n9 = n8;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.toWeekDay:(I)I");
                    long l = DateTimeTextProvider.toWeekDay(n9);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l4 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createEntry:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
                    Map.Entry entry4 = DateTimeTextProvider.createEntry(k, l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(entry4);
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                break;
            }
            default: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set set = map.entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                Iterator iterator = set.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry entry = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    Object k = entry.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    Integer n10 = (Integer)entry.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    long l = n10.intValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                    Long l5 = l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createEntry:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
                    Map.Entry entry5 = DateTimeTextProvider.createEntry(k, l5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                    arrayList.add(entry5);
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
        return arrayList.iterator();
    }

    private Object findStore(TemporalField temporalField, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createEntry:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
        Map.Entry<TemporalField, Locale> entry = DateTimeTextProvider.createEntry(temporalField, locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object = CACHE.get(entry);
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createStore:(Ljava/time/temporal/TemporalField;Ljava/util/Locale;)Ljava/lang/Object;");
            object = this.createStore(temporalField, locale);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            CACHE.putIfAbsent(entry, object);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            object = CACHE.get(entry);
        }
        return object;
    }

    private static int toWeekDay(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == 1) {
            return 7;
        }
        return n - 1;
    }

    private Object createStore(TemporalField temporalField, Locale locale) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        HashMap<TextStyle, Map<Long, String>> hashMap = new HashMap<TextStyle, Map<Long, String>>();
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.ERA) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.values:()[Ljava/time/format/TextStyle;");
            TextStyle[] textStyleArray = TextStyle.values();
            int n = textStyleArray.length;
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break;
                TextStyle textStyle = textStyleArray[n2];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.isStandalone:()Z");
                boolean bl = textStyle.isStandalone();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
                    int n3 = textStyle.toCalendarStyle();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueNames:(Ljava/lang/String;IILjava/util/Locale;)Ljava/util/Map;");
                    Map map = CalendarDataUtility.retrieveJavaTimeFieldValueNames((String)"gregory", (int)0, (int)n3, (Locale)locale);
                    RuntimeCostAccounter.recordJump();
                    if (map != null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                        HashMap hashMap2 = new HashMap();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                        Set set = map.entrySet();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                        Iterator iterator = set.iterator();
                        while (true) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                            boolean bl2 = iterator.hasNext();
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                            Map.Entry entry = iterator.next();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                            Integer n4 = (Integer)entry.getValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                            long l = n4.intValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                            Long l2 = l;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                            Object k = entry.getKey();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            hashMap2.put(l2, k);
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
                        boolean bl3 = hashMap2.isEmpty();
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            hashMap.put(textStyle, hashMap2);
                        }
                    }
                }
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$LocaleStore");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.<init>:(Ljava/util/Map;)V");
            return new LocaleStore(hashMap);
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.values:()[Ljava/time/format/TextStyle;");
            TextStyle[] textStyleArray = TextStyle.values();
            int n = textStyleArray.length;
            int n5 = 0;
            while (true) {
                Object object;
                RuntimeCostAccounter.recordJump();
                if (n5 >= n) break;
                TextStyle textStyle = textStyleArray[n5];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
                int n6 = textStyle.toCalendarStyle();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueNames:(Ljava/lang/String;IILjava/util/Locale;)Ljava/util/Map;");
                Map map = CalendarDataUtility.retrieveJavaTimeFieldValueNames((String)"gregory", (int)2, (int)n6, (Locale)locale);
                RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                HashMap<Long, Object> hashMap3 = new HashMap<Long, Object>();
                RuntimeCostAccounter.recordJump();
                if (map != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                    Set set = map.entrySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                    Iterator iterator = set.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        object = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                        Integer n7 = (Integer)object.getValue();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                        long l = n7 + 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l3 = l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        Object k = object.getKey();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        hashMap3.put(l3, k);
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n8 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n8 > 11) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
                        int n9 = textStyle.toCalendarStyle();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueName:(Ljava/lang/String;IIILjava/util/Locale;)Ljava/lang/String;");
                        object = CalendarDataUtility.retrieveJavaTimeFieldValueName((String)"gregory", (int)2, (int)n8, (int)n9, (Locale)locale);
                        RuntimeCostAccounter.recordJump();
                        if (object == null) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        long l = n8 + 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l4 = l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        hashMap3.put(l4, object);
                        ++n8;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
                boolean bl = hashMap3.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    hashMap.put(textStyle, hashMap3);
                }
                ++n5;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$LocaleStore");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.<init>:(Ljava/util/Map;)V");
            return new LocaleStore(hashMap);
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.DAY_OF_WEEK) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.values:()[Ljava/time/format/TextStyle;");
            TextStyle[] textStyleArray = TextStyle.values();
            int n = textStyleArray.length;
            int n10 = 0;
            while (true) {
                Object object;
                RuntimeCostAccounter.recordJump();
                if (n10 >= n) break;
                TextStyle textStyle = textStyleArray[n10];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
                int n11 = textStyle.toCalendarStyle();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueNames:(Ljava/lang/String;IILjava/util/Locale;)Ljava/util/Map;");
                Map map = CalendarDataUtility.retrieveJavaTimeFieldValueNames((String)"gregory", (int)7, (int)n11, (Locale)locale);
                RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                HashMap<Long, Object> hashMap4 = new HashMap<Long, Object>();
                RuntimeCostAccounter.recordJump();
                if (map != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                    Set set = map.entrySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                    Iterator iterator = set.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        object = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                        Integer n12 = (Integer)object.getValue();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                        int n13 = n12;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.toWeekDay:(I)I");
                        long l = DateTimeTextProvider.toWeekDay(n13);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l5 = l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        Object k = object.getKey();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        hashMap4.put(l5, k);
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n14 = 1;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n14 > 7) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
                        int n15 = textStyle.toCalendarStyle();
                        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueName:(Ljava/lang/String;IIILjava/util/Locale;)Ljava/lang/String;");
                        object = CalendarDataUtility.retrieveJavaTimeFieldValueName((String)"gregory", (int)7, (int)n14, (int)n15, (Locale)locale);
                        RuntimeCostAccounter.recordJump();
                        if (object == null) {
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.toWeekDay:(I)I");
                        long l = DateTimeTextProvider.toWeekDay(n14);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l6 = l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        hashMap4.put(l6, object);
                        ++n14;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
                boolean bl = hashMap4.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    hashMap.put(textStyle, hashMap4);
                }
                ++n10;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$LocaleStore");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.<init>:(Ljava/util/Map;)V");
            return new LocaleStore(hashMap);
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.AMPM_OF_DAY) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.values:()[Ljava/time/format/TextStyle;");
            TextStyle[] textStyleArray = TextStyle.values();
            int n = textStyleArray.length;
            int n16 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n16 >= n) break;
                TextStyle textStyle = textStyleArray[n16];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.isStandalone:()Z");
                boolean bl = textStyle.isStandalone();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.toCalendarStyle:()I");
                    int n17 = textStyle.toCalendarStyle();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/CalendarDataUtility.retrieveJavaTimeFieldValueNames:(Ljava/lang/String;IILjava/util/Locale;)Ljava/util/Map;");
                    Map map = CalendarDataUtility.retrieveJavaTimeFieldValueNames((String)"gregory", (int)9, (int)n17, (Locale)locale);
                    RuntimeCostAccounter.recordJump();
                    if (map != null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                        HashMap hashMap5 = new HashMap();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                        Set set = map.entrySet();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                        Iterator iterator = set.iterator();
                        while (true) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                            boolean bl4 = iterator.hasNext();
                            RuntimeCostAccounter.recordJump();
                            if (!bl4) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                            Map.Entry entry = iterator.next();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                            Integer n18 = (Integer)entry.getValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                            long l = n18.intValue();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                            Long l7 = l;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                            Object k = entry.getKey();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            hashMap5.put(l7, k);
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.isEmpty:()Z");
                        boolean bl5 = hashMap5.isEmpty();
                        RuntimeCostAccounter.recordJump();
                        if (!bl5) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                            hashMap.put(textStyle, hashMap5);
                        }
                    }
                }
                ++n16;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$LocaleStore");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.<init>:(Ljava/util/Map;)V");
            return new LocaleStore(hashMap);
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == IsoFields.QUARTER_OF_YEAR) {
            RuntimeCostAccounter.recordArrayAllocation((int)6, (int)8);
            String[] stringArray = new String[]{"QuarterNames", "standalone.QuarterNames", "QuarterAbbreviations", "standalone.QuarterAbbreviations", "QuarterNarrows", "standalone.QuarterNarrows"};
            int n = 0;
            while (true) {
                int n19 = stringArray.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n19) break;
                String string = stringArray[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getLocalizedResource:(Ljava/lang/String;Ljava/util/Locale;)Ljava/lang/Object;");
                String[] stringArray2 = (String[])DateTimeTextProvider.getLocalizedResource(string, locale);
                RuntimeCostAccounter.recordJump();
                if (stringArray2 != null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                    HashMap<Long, String> hashMap6 = new HashMap<Long, String>();
                    int n20 = 0;
                    while (true) {
                        int n21 = stringArray2.length;
                        RuntimeCostAccounter.recordJump();
                        if (n20 >= n21) break;
                        long l = n20 + 1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                        Long l8 = l;
                        String string2 = stringArray2[n20];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        hashMap6.put(l8, string2);
                        ++n20;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.values:()[Ljava/time/format/TextStyle;");
                    TextStyle textStyle = TextStyle.values()[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    hashMap.put(textStyle, hashMap6);
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$LocaleStore");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.<init>:(Ljava/util/Map;)V");
            return new LocaleStore(hashMap);
        }
        return "";
    }

    private static <A, B> Map.Entry<A, B> createEntry(A a, B b) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
        return new AbstractMap.SimpleImmutableEntry<A, B>(a, b);
    }

    static <T> T getLocalizedResource(String string, Locale locale) {
        Object object;
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getResourceBundleBased:()Lsun/util/locale/provider/LocaleProviderAdapter;");
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getResourceBundleBased();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getLocaleResources:(Ljava/util/Locale;)Lsun/util/locale/provider/LocaleResources;");
        LocaleResources localeResources = localeProviderAdapter.getLocaleResources(locale);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleResources.getJavaTimeFormatData:()Ljava/util/ResourceBundle;");
        ResourceBundle resourceBundle = localeResources.getJavaTimeFormatData();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.containsKey:(Ljava/lang/String;)Z");
        boolean bl = resourceBundle.containsKey(string);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ResourceBundle.getObject:(Ljava/lang/String;)Ljava/lang/Object;");
            object = resourceBundle.getObject(string);
            RuntimeCostAccounter.recordJump();
        } else {
            object = null;
        }
        return (T)object;
    }

    static /* synthetic */ Map.Entry access$000(Object object, Object object2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.createEntry:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
        return DateTimeTextProvider.createEntry(object, object2);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
        CACHE = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$1.<init>:()V");
        COMPARATOR = new Comparator<Map.Entry<String, Long>>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public int compare(Map.Entry<String, Long> entry, Map.Entry<String, Long> entry2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n = entry2.getKey().length();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                return n - entry.getKey().length();
            }
        };
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> map) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.valueTextMap = map;
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
            HashMap<TextStyle, List<Map.Entry<String, Long>>> hashMap = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            ArrayList arrayList = new ArrayList();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
            Set<Map.Entry<TextStyle, Map<Long, String>>> set = map.entrySet();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<Map.Entry<TextStyle, Map<Long, String>>> iterator = set.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Map.Entry<TextStyle, Map<Long, String>> entry = iterator.next();
                RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                HashMap<String, Map.Entry> hashMap2 = new HashMap<String, Map.Entry>();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
                Set<Map.Entry<Long, String>> set2 = entry.getValue().entrySet();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                Object object = set2.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl2 = object.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    Map.Entry<Long, String> entry2 = object.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    String string = entry2.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    String string2 = entry2.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    Long l = entry2.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.access$000:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;");
                    Map.Entry entry3 = DateTimeTextProvider.access$000(string2, l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    Map.Entry entry4 = hashMap2.put(string, entry3);
                    RuntimeCostAccounter.recordJump();
                    if (entry4 != null) {
                        RuntimeCostAccounter.recordJump();
                        continue;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.values:()Ljava/util/Collection;");
                Collection collection = hashMap2.values();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(Ljava/util/Collection;)V");
                object = new ArrayList(collection);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.access$100:()Ljava/util/Comparator;");
                Comparator comparator = COMPARATOR;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.sort:(Ljava/util/List;Ljava/util/Comparator;)V");
                Collections.sort(object, comparator);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                TextStyle textStyle = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                hashMap.put(textStyle, (List<Map.Entry<String, Long>>)object);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.addAll:(Ljava/util/Collection;)Z");
                arrayList.addAll(object);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                hashMap.put(null, arrayList);
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.access$100:()Ljava/util/Comparator;");
            Comparator comparator = COMPARATOR;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.sort:(Ljava/util/List;Ljava/util/Comparator;)V");
            Collections.sort(arrayList, comparator);
            this.parsable = hashMap;
        }

        String getText(long l, TextStyle textStyle) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            Map<Long, String> map = this.valueTextMap.get((Object)textStyle);
            RuntimeCostAccounter.recordJump();
            if (map != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                Long l2 = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                string = map.get(l2);
                RuntimeCostAccounter.recordJump();
            } else {
                string = null;
            }
            return string;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle textStyle) {
            Iterator<Map.Entry<String, Long>> iterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)textStyle);
            RuntimeCostAccounter.recordJump();
            if (list != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.iterator:()Ljava/util/Iterator;");
                iterator = list.iterator();
                RuntimeCostAccounter.recordJump();
            } else {
                iterator = null;
            }
            return iterator;
        }
    }
}

