/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.format;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DecimalStyle;
import sandbox.java.time.format.Parsed;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.function.Consumer;

final class DateTimeParseContext {
    private DateTimeFormatter formatter;
    private boolean caseSensitive;
    private boolean strict;
    private final ArrayList<Parsed> parsed;
    private ArrayList<Consumer<Chronology>> chronoListeners;

    DateTimeParseContext(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.caseSensitive = true;
        this.strict = true;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.parsed = new ArrayList();
        this.chronoListeners = null;
        this.formatter = dateTimeFormatter;
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/Parsed");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.<init>:()V");
        Parsed parsed = new Parsed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
        this.parsed.add(parsed);
    }

    DateTimeParseContext copy() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeParseContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.<init>:(Ljava/time/format/DateTimeFormatter;)V");
        DateTimeParseContext dateTimeParseContext = new DateTimeParseContext(this.formatter);
        dateTimeParseContext.caseSensitive = this.caseSensitive;
        dateTimeParseContext.strict = this.strict;
        return dateTimeParseContext;
    }

    Locale getLocale() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.getLocale:()Ljava/util/Locale;");
        return this.formatter.getLocale();
    }

    DecimalStyle getDecimalStyle() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
        return this.formatter.getDecimalStyle();
    }

    Chronology getEffectiveChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        Chronology chronology = this.currentParsed().chrono;
        RuntimeCostAccounter.recordJump();
        if (chronology == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.getChronology:()Ljava/time/chrono/Chronology;");
            chronology = this.formatter.getChronology();
            RuntimeCostAccounter.recordJump();
            if (chronology == null) {
                chronology = IsoChronology.INSTANCE;
            }
        }
        return chronology;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    boolean subSequenceEquals(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        block12: {
            block11: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                int n4 = charSequence.length();
                RuntimeCostAccounter.recordJump();
                if (n + n3 > n4) break block11;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                int n5 = charSequence2.length();
                RuntimeCostAccounter.recordJump();
                if (n2 + n3 <= n5) break block12;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
        boolean bl = this.isCaseSensitive();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            int n6 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n6 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c = charSequence.charAt(n + n6);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c2 = charSequence2.charAt(n2 + n6);
                RuntimeCostAccounter.recordJump();
                if (c != c2) {
                    return false;
                }
                ++n6;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        } else {
            int n7 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n7 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c = charSequence.charAt(n + n7);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c3 = charSequence2.charAt(n2 + n7);
                RuntimeCostAccounter.recordJump();
                if (c != c3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toUpperCase:(C)C");
                    char c4 = Character.toUpperCase(c);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toUpperCase:(C)C");
                    char c5 = Character.toUpperCase(c3);
                    RuntimeCostAccounter.recordJump();
                    if (c4 != c5) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                        char c6 = Character.toLowerCase(c);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                        char c7 = Character.toLowerCase(c3);
                        RuntimeCostAccounter.recordJump();
                        if (c6 != c7) {
                            return false;
                        }
                    }
                }
                ++n7;
                RuntimeCostAccounter.recordJump();
            }
        }
        return true;
    }

    boolean charEquals(char c, char c2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
        boolean bl = this.isCaseSensitive();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            RuntimeCostAccounter.recordJump();
            if (c == c2) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEqualsIgnoreCase:(CC)Z");
        return DateTimeParseContext.charEqualsIgnoreCase(c, c2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean charEqualsIgnoreCase(char c, char c2) {
        RuntimeCostAccounter.recordJump();
        if (c != c2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toUpperCase:(C)C");
            char c3 = Character.toUpperCase(c);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toUpperCase:(C)C");
            char c4 = Character.toUpperCase(c2);
            RuntimeCostAccounter.recordJump();
            if (c3 != c4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                char c5 = Character.toLowerCase(c);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                char c6 = Character.toLowerCase(c2);
                RuntimeCostAccounter.recordJump();
                if (c5 != c6) return false;
            }
        }
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    boolean isStrict() {
        return this.strict;
    }

    void setStrict(boolean bl) {
        this.strict = bl;
    }

    void startOptional() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        Parsed parsed = this.currentParsed();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.copy:()Ljava/time/format/Parsed;");
        Parsed parsed2 = parsed.copy();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
        this.parsed.add(parsed2);
    }

    void endOptional(boolean bl) {
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
            int n = this.parsed.size() - 2;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.remove:(I)Ljava/lang/Object;");
            this.parsed.remove(n);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
            int n = this.parsed.size() - 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.remove:(I)Ljava/lang/Object;");
            this.parsed.remove(n);
        }
    }

    private Parsed currentParsed() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
        int n = this.parsed.size() - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.get:(I)Ljava/lang/Object;");
        return this.parsed.get(n);
    }

    Parsed toUnresolved() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        return this.currentParsed();
    }

    TemporalAccessor toResolved(ResolverStyle resolverStyle, Set<TemporalField> set) {
        ZoneId zoneId;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        Parsed parsed = this.currentParsed();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getEffectiveChronology:()Ljava/time/chrono/Chronology;");
        parsed.chrono = this.getEffectiveChronology();
        ZoneId zoneId2 = parsed.zone;
        RuntimeCostAccounter.recordJump();
        if (zoneId2 != null) {
            zoneId = parsed.zone;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.getZone:()Ljava/time/ZoneId;");
            zoneId = this.formatter.getZone();
        }
        parsed.zone = zoneId;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.resolve:(Ljava/time/format/ResolverStyle;Ljava/util/Set;)Ljava/time/temporal/TemporalAccessor;");
        return parsed.resolve(resolverStyle, set);
    }

    Long getParsed(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        Map<TemporalField, Long> map = this.currentParsed().fieldValues;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        return map.get(temporalField);
    }

    /*
     * Enabled aggressive block sorting
     */
    int setParsedField(TemporalField temporalField, long l, int n, int n2) {
        int n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        Map<TemporalField, Long> map = this.currentParsed().fieldValues;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l2 = l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        Long l3 = map.put(temporalField, l2);
        RuntimeCostAccounter.recordJump();
        if (l3 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = l3 - l;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l5 != false) {
                n3 = ~n;
                RuntimeCostAccounter.recordJump();
                return n3;
            }
        }
        n3 = n2;
        return n3;
    }

    void setParsed(Chronology chronology) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(chronology, "chrono");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        this.currentParsed().chrono = chronology;
        RuntimeCostAccounter.recordJump();
        if (this.chronoListeners != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.isEmpty:()Z");
            boolean bl = this.chronoListeners.isEmpty();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
                Consumer[] consumerArray = new Consumer[1];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
                Consumer[] consumerArray2 = this.chronoListeners.toArray(consumerArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.clear:()V");
                this.chronoListeners.clear();
                Consumer[] consumerArray3 = consumerArray2;
                int n = consumerArray3.length;
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    Consumer consumer = consumerArray3[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(chronology);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
    }

    void addChronoChangedListener(Consumer<Chronology> consumer) {
        RuntimeCostAccounter.recordJump();
        if (this.chronoListeners == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
            this.chronoListeners = new ArrayList();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
        this.chronoListeners.add(consumer);
    }

    void setParsed(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        this.currentParsed().zone = zoneId;
    }

    void setParsedLeapSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        this.currentParsed().leapSecond = true;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.currentParsed:()Ljava/time/format/Parsed;");
        Parsed parsed = this.currentParsed();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/Parsed.toString:()Ljava/lang/String;");
        return parsed.toString();
    }
}

