/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.chrono.ThaiBuddhistDate;
import sandbox.java.time.chrono.ThaiBuddhistEra;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.HashMap;
import sandbox.java.util.List;
import sandbox.java.util.Map;

public final class ThaiBuddhistChronology
extends AbstractChronology
implements Serializable {
    public static final ThaiBuddhistChronology INSTANCE;
    private static final long serialVersionUID = 2775954514031616474L;
    static final int YEARS_DIFFERENCE = 543;
    private static final HashMap<String, String[]> ERA_NARROW_NAMES;
    private static final HashMap<String, String[]> ERA_SHORT_NAMES;
    private static final HashMap<String, String[]> ERA_FULL_NAMES;
    private static final String FALLBACK_LANGUAGE = "en";
    private static final String TARGET_LANGUAGE = "th";

    private ThaiBuddhistChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.<init>:()V");
    }

    @Override
    public String getId() {
        return "ThaiBuddhist";
    }

    @Override
    public String getCalendarType() {
        return "buddhist";
    }

    @Override
    public ThaiBuddhistDate date(Era era, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n4 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.date:(III)Ljava/time/chrono/ThaiBuddhistDate;");
        return this.date(n4, n2, n3);
    }

    @Override
    public ThaiBuddhistDate date(int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ThaiBuddhistDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n - 543, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistDate.<init>:(Ljava/time/LocalDate;)V");
        return new ThaiBuddhistDate(localDate);
    }

    @Override
    public ThaiBuddhistDate dateYearDay(Era era, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n3 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.dateYearDay:(II)Ljava/time/chrono/ThaiBuddhistDate;");
        return this.dateYearDay(n3, n2);
    }

    @Override
    public ThaiBuddhistDate dateYearDay(int n, int n2) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ThaiBuddhistDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofYearDay:(II)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofYearDay(n - 543, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistDate.<init>:(Ljava/time/LocalDate;)V");
        return new ThaiBuddhistDate(localDate);
    }

    @Override
    public ThaiBuddhistDate dateEpochDay(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ThaiBuddhistDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofEpochDay(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistDate.<init>:(Ljava/time/LocalDate;)V");
        return new ThaiBuddhistDate(localDate);
    }

    @Override
    public ThaiBuddhistDate dateNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/ThaiBuddhistDate;");
        return this.dateNow(clock);
    }

    @Override
    public ThaiBuddhistDate dateNow(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/ThaiBuddhistDate;");
        return this.dateNow(clock);
    }

    @Override
    public ThaiBuddhistDate dateNow(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ThaiBuddhistDate;");
        return this.date(localDate);
    }

    @Override
    public ThaiBuddhistDate date(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof ThaiBuddhistDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (ThaiBuddhistDate)temporalAccessor;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ThaiBuddhistDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.from(temporalAccessor);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistDate.<init>:(Ljava/time/LocalDate;)V");
        return new ThaiBuddhistDate(localDate);
    }

    public ChronoLocalDateTime<ThaiBuddhistDate> localDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<ThaiBuddhistDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<ThaiBuddhistDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(instant, zoneId);
    }

    @Override
    public boolean isLeapYear(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
        return IsoChronology.INSTANCE.isLeapYear(l - 543L);
    }

    @Override
    public int prolepticYear(Era era, int n) {
        int n2;
        boolean bl = era instanceof ThaiBuddhistEra;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException("Era must be BuddhistEra");
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        RuntimeCostAccounter.recordJump();
        if (era == ThaiBuddhistEra.BE) {
            n2 = n;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 1 - n;
        }
        return n2;
    }

    @Override
    public ThaiBuddhistEra eraOf(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistEra.of:(I)Ljava/time/chrono/ThaiBuddhistEra;");
        return ThaiBuddhistEra.of(n);
    }

    @Override
    public List<Era> eras() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistEra.values:()[Ljava/time/chrono/ThaiBuddhistEra;");
        ThaiBuddhistEra[] thaiBuddhistEraArray = ThaiBuddhistEra.values();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        return Arrays.asList(thaiBuddhistEraArray);
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
        switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
            case 1: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = ChronoField.PROLEPTIC_MONTH.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                long l = valueRange.getMinimum() + 6516L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l2 = valueRange.getMaximum() + 6516L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, l2);
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = ChronoField.YEAR.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                long l = -(valueRange.getMinimum() + 543L) + 1L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l3 = valueRange.getMaximum() + 543L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(1L, l, l3);
            }
            case 3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = ChronoField.YEAR.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                long l = valueRange.getMinimum() + 543L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l4 = valueRange.getMaximum() + 543L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, l4);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
        return chronoField.range();
    }

    @Override
    public ThaiBuddhistDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveDate:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        return (ThaiBuddhistDate)super.resolveDate(map, resolverStyle);
    }

    @Override
    Object writeReplace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.writeReplace:()Ljava/lang/Object;");
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ThaiBuddhistChronology");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ThaiBuddhistChronology.<init>:()V");
        INSTANCE = new ThaiBuddhistChronology();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        ERA_NARROW_NAMES = new HashMap();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        ERA_SHORT_NAMES = new HashMap();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        ERA_FULL_NAMES = new HashMap();
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        String[] stringArray = new String[]{"BB", "BE"};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        ERA_NARROW_NAMES.put(FALLBACK_LANGUAGE, stringArray);
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        String[] stringArray2 = new String[]{"BB", "BE"};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        ERA_NARROW_NAMES.put(TARGET_LANGUAGE, stringArray2);
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        String[] stringArray3 = new String[]{"B.B.", "B.E."};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        ERA_SHORT_NAMES.put(FALLBACK_LANGUAGE, stringArray3);
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        String[] stringArray4 = new String[]{"\u0e1e.\u0e28.", "\u0e1b\u0e35\u0e01\u0e48\u0e2d\u0e19\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e01\u0e32\u0e25\u0e17\u0e35\u0e48"};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        ERA_SHORT_NAMES.put(TARGET_LANGUAGE, stringArray4);
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        String[] stringArray5 = new String[]{"Before Buddhist", "Budhhist Era"};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        ERA_FULL_NAMES.put(FALLBACK_LANGUAGE, stringArray5);
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        String[] stringArray6 = new String[]{"\u0e1e\u0e38\u0e17\u0e18\u0e28\u0e31\u0e01\u0e23\u0e32\u0e0a", "\u0e1b\u0e35\u0e01\u0e48\u0e2d\u0e19\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e01\u0e32\u0e25\u0e17\u0e35\u0e48"};
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        ERA_FULL_NAMES.put(TARGET_LANGUAGE, stringArray6);
    }
}

