/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.chrono.MinguoDate;
import sandbox.java.time.chrono.MinguoEra;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.List;
import sandbox.java.util.Map;

public final class MinguoChronology
extends AbstractChronology
implements Serializable {
    public static final MinguoChronology INSTANCE;
    private static final long serialVersionUID = 1039765215346859963L;
    static final int YEARS_DIFFERENCE = 1911;

    private MinguoChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.<init>:()V");
    }

    @Override
    public String getId() {
        return "Minguo";
    }

    @Override
    public String getCalendarType() {
        return "roc";
    }

    @Override
    public MinguoDate date(Era era, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n4 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.date:(III)Ljava/time/chrono/MinguoDate;");
        return this.date(n4, n2, n3);
    }

    @Override
    public MinguoDate date(int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n + 1911, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
        return new MinguoDate(localDate);
    }

    @Override
    public MinguoDate dateYearDay(Era era, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n3 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.dateYearDay:(II)Ljava/time/chrono/MinguoDate;");
        return this.dateYearDay(n3, n2);
    }

    @Override
    public MinguoDate dateYearDay(int n, int n2) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofYearDay:(II)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofYearDay(n + 1911, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
        return new MinguoDate(localDate);
    }

    @Override
    public MinguoDate dateEpochDay(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofEpochDay(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
        return new MinguoDate(localDate);
    }

    @Override
    public MinguoDate dateNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/MinguoDate;");
        return this.dateNow(clock);
    }

    @Override
    public MinguoDate dateNow(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/MinguoDate;");
        return this.dateNow(clock);
    }

    @Override
    public MinguoDate dateNow(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/MinguoDate;");
        return this.date(localDate);
    }

    @Override
    public MinguoDate date(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof MinguoDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (MinguoDate)temporalAccessor;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.from(temporalAccessor);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoDate.<init>:(Ljava/time/LocalDate;)V");
        return new MinguoDate(localDate);
    }

    public ChronoLocalDateTime<MinguoDate> localDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<MinguoDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<MinguoDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(instant, zoneId);
    }

    @Override
    public boolean isLeapYear(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
        return IsoChronology.INSTANCE.isLeapYear(l + 1911L);
    }

    @Override
    public int prolepticYear(Era era, int n) {
        int n2;
        boolean bl = era instanceof MinguoEra;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException("Era must be MinguoEra");
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        RuntimeCostAccounter.recordJump();
        if (era == MinguoEra.ROC) {
            n2 = n;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 1 - n;
        }
        return n2;
    }

    @Override
    public MinguoEra eraOf(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoEra.of:(I)Ljava/time/chrono/MinguoEra;");
        return MinguoEra.of(n);
    }

    @Override
    public List<Era> eras() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoEra.values:()[Ljava/time/chrono/MinguoEra;");
        MinguoEra[] minguoEraArray = MinguoEra.values();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        return Arrays.asList(minguoEraArray);
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
        switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
            case 1: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = ChronoField.PROLEPTIC_MONTH.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                long l = valueRange.getMinimum() - 22932L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l2 = valueRange.getMaximum() - 22932L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, l2);
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = ChronoField.YEAR.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l = valueRange.getMaximum() - 1911L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                long l3 = -valueRange.getMinimum() + 1L + 1911L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(1L, l, l3);
            }
            case 3: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = ChronoField.YEAR.range();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
                long l = valueRange.getMinimum() - 1911L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
                long l4 = valueRange.getMaximum() - 1911L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                return ValueRange.of(l, l4);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
        return chronoField.range();
    }

    @Override
    public MinguoDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveDate:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        return (MinguoDate)super.resolveDate(map, resolverStyle);
    }

    @Override
    Object writeReplace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.writeReplace:()Ljava/lang/Object;");
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/MinguoChronology");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/MinguoChronology.<init>:()V");
        INSTANCE = new MinguoChronology();
    }
}

