/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.File;
import sandbox.java.io.FileInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedActionException;
import sandbox.java.security.PrivilegedExceptionAction;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.HijrahDate;
import sandbox.java.time.chrono.HijrahEra;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Arrays;
import sandbox.java.util.HashMap;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Properties;
import sandbox.java.util.Set;
import sandbox.sun.util.calendar.BaseCalendar;
import sandbox.sun.util.logging.PlatformLogger;

public final class HijrahChronology
extends AbstractChronology
implements Serializable {
    private final transient String typeId;
    private final transient String calendarType;
    private static final long serialVersionUID = 3127340209035924785L;
    public static final HijrahChronology INSTANCE;
    private volatile transient boolean initComplete;
    private transient int[] hijrahEpochMonthStartDays;
    private transient int minEpochDay;
    private transient int maxEpochDay;
    private transient int hijrahStartEpochMonth;
    private transient int minMonthLength;
    private transient int maxMonthLength;
    private transient int minYearLength;
    private transient int maxYearLength;
    private static final transient Properties calendarProperties;
    private static final String PROP_PREFIX = "calendar.hijrah.";
    private static final String PROP_TYPE_SUFFIX = ".type";
    private static final String KEY_ID = "id";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VERSION = "version";
    private static final String KEY_ISO_START = "iso-start";

    private static void registerVariants() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.stringPropertyNames:()Ljava/util/Set;");
        Set<String> set = calendarProperties.stringPropertyNames();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<String> iterator = set.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            String string = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string.startsWith(PROP_PREFIX);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n = PROP_PREFIX.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                String string2 = string.substring(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
                int n2 = string2.indexOf(46);
                RuntimeCostAccounter.recordJump();
                if (n2 >= 0) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getId:()Ljava/lang/String;");
                String string3 = INSTANCE.getId();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = string2.equals(string3);
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                try {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/HijrahChronology");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.<init>:(Ljava/lang/String;)V");
                    HijrahChronology hijrahChronology = new HijrahChronology(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
                    AbstractChronology.registerChrono(hijrahChronology);
                }
                catch (DateTimeException dateTimeException) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.getLogger:(Ljava/lang/String;)Lsun/util/logging/PlatformLogger;");
                    PlatformLogger platformLogger = PlatformLogger.getLogger((String)"java.time.chrono");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Unable to initialize Hijrah calendar: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string4 = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.severe:(Ljava/lang/String;Ljava/lang/Throwable;)V");
                    platformLogger.severe(string4, (Throwable)dateTimeException);
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    private HijrahChronology(String string) throws DateTimeException {
        String string2;
        block5: {
            String string3;
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.<init>:()V");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.isEmpty:()Z");
                boolean bl = string.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("calendar id is empty");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(PROP_PREFIX);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(PROP_TYPE_SUFFIX);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string3 = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                string2 = calendarProperties.getProperty(string3);
                RuntimeCostAccounter.recordJump();
                if (string2 == null) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.isEmpty:()Z");
                boolean bl2 = string2.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder.append("calendarType is missing or empty for: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string4 = stringBuilder6.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string4);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        this.typeId = string;
        this.calendarType = string2;
    }

    private void checkCalendarInit() {
        RuntimeCostAccounter.recordJump();
        if (!this.initComplete) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.loadCalendarData:()V");
            this.loadCalendarData();
            this.initComplete = true;
        }
    }

    @Override
    public String getId() {
        return this.typeId;
    }

    @Override
    public String getCalendarType() {
        return this.calendarType;
    }

    @Override
    public HijrahDate date(Era era, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n4 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.date:(III)Ljava/time/chrono/HijrahDate;");
        return this.date(n4, n2, n3);
    }

    @Override
    public HijrahDate date(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.of:(Ljava/time/chrono/HijrahChronology;III)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.of(this, n, n2, n3);
    }

    @Override
    public HijrahDate dateYearDay(Era era, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n3 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.dateYearDay:(II)Ljava/time/chrono/HijrahDate;");
        return this.dateYearDay(n3, n2);
    }

    @Override
    public HijrahDate dateYearDay(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.of:(Ljava/time/chrono/HijrahChronology;III)Ljava/time/chrono/HijrahDate;");
        HijrahDate hijrahDate = HijrahDate.of(this, n, 1, 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.lengthOfYear:()I");
        int n3 = hijrahDate.lengthOfYear();
        RuntimeCostAccounter.recordJump();
        if (n2 > n3) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid dayOfYear: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        long l = n2 - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.plusDays:(J)Ljava/time/chrono/HijrahDate;");
        return hijrahDate.plusDays(l);
    }

    @Override
    public HijrahDate dateEpochDay(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.ofEpochDay:(Ljava/time/chrono/HijrahChronology;J)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.ofEpochDay(this, l);
    }

    @Override
    public HijrahDate dateNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/HijrahDate;");
        return this.dateNow(clock);
    }

    @Override
    public HijrahDate dateNow(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/HijrahDate;");
        return this.dateNow(clock);
    }

    @Override
    public HijrahDate dateNow(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/HijrahDate;");
        return this.date(localDate);
    }

    @Override
    public HijrahDate date(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof HijrahDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (HijrahDate)temporalAccessor;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = temporalAccessor.getLong(ChronoField.EPOCH_DAY);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahDate.ofEpochDay:(Ljava/time/chrono/HijrahChronology;J)Ljava/time/chrono/HijrahDate;");
        return HijrahDate.ofEpochDay(this, l);
    }

    public ChronoLocalDateTime<HijrahDate> localDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.zonedDateTime:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
        return super.zonedDateTime(instant, zoneId);
    }

    @Override
    public boolean isLeapYear(long l) {
        boolean bl;
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.checkCalendarInit:()V");
                this.checkCalendarInit();
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.yearToEpochMonth:(I)I");
                int n2 = this.yearToEpochMonth(n);
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block5;
                RuntimeCostAccounter.recordJump();
                if (n2 <= this.maxEpochDay) break block6;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Hijrah date out of range");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        int n = (int)l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getYearLength:(I)I");
        int n3 = this.getYearLength(n);
        RuntimeCostAccounter.recordJump();
        if (n3 > 354) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int prolepticYear(Era era, int n) {
        boolean bl = era instanceof HijrahEra;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException("Era must be HijrahEra");
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        return n;
    }

    @Override
    public HijrahEra eraOf(int n) {
        switch (n) {
            case 1: {
                return HijrahEra.AH;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
        DateTimeException dateTimeException = new DateTimeException("invalid Hijrah era");
        RuntimeCostAccounter.recordThrow();
        throw dateTimeException;
    }

    @Override
    public List<Era> eras() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahEra.values:()[Ljava/time/chrono/HijrahEra;");
        HijrahEra[] hijrahEraArray = HijrahEra.values();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        return Arrays.asList(hijrahEraArray);
    }

    @Override
    public ValueRange range(ChronoField chronoField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.checkCalendarInit:()V");
        this.checkCalendarInit();
        boolean bl = chronoField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField2 = chronoField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField2.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMinimumMonthLength:()I");
                    long l = this.getMinimumMonthLength();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMaximumMonthLength:()I");
                    long l2 = this.getMaximumMonthLength();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJJ)Ljava/time/temporal/ValueRange;");
                    return ValueRange.of(1L, 1L, l, l2);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMaximumDayOfYear:()I");
                    long l = this.getMaximumDayOfYear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                    return ValueRange.of(1L, l);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                    return ValueRange.of(1L, 5L);
                }
                case 4: 
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMinimumYear:()I");
                    long l = this.getMinimumYear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMaximumYear:()I");
                    long l3 = this.getMaximumYear();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                    return ValueRange.of(l, l3);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                    return ValueRange.of(1L, 1L);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
            return chronoField.range();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.range:()Ljava/time/temporal/ValueRange;");
        return chronoField.range();
    }

    @Override
    public HijrahDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveDate:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        return (HijrahDate)super.resolveDate(map, resolverStyle);
    }

    int checkValidYear(long l) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMinimumYear:()I");
                long l2 = l - (long)this.getMinimumYear();
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 < 0) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMaximumYear:()I");
                long l4 = l - (long)this.getMaximumYear();
                long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l5 <= 0) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid Hijrah year: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return (int)l;
    }

    void checkValidDayOfYear(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < 1) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMaximumDayOfYear:()I");
                int n2 = this.getMaximumDayOfYear();
                RuntimeCostAccounter.recordJump();
                if (n <= n2) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid Hijrah day of year: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
    }

    void checkValidMonth(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < 1) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= 12) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid Hijrah month: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
    }

    int[] getHijrahDateInfo(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.checkCalendarInit:()V");
                this.checkCalendarInit();
                RuntimeCostAccounter.recordJump();
                if (n < this.minEpochDay) break block2;
                RuntimeCostAccounter.recordJump();
                if (n < this.maxEpochDay) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Hijrah date out of range");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochDayToEpochMonth:(I)I");
        int n2 = this.epochDayToEpochMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToYear:(I)I");
        int n3 = this.epochMonthToYear(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToMonth:(I)I");
        int n4 = this.epochMonthToMonth(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToEpochDay:(I)I");
        int n5 = this.epochMonthToEpochDay(n2);
        int n6 = n - n5;
        RuntimeCostAccounter.recordArrayAllocation((int)3, (int)4);
        int[] nArray = new int[]{n3, n4 + 1, n6 + 1};
        return nArray;
    }

    long getEpochDay(int n, int n2, int n3) {
        int n4;
        block7: {
            block6: {
                block5: {
                    block4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.checkCalendarInit:()V");
                        this.checkCalendarInit();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.checkValidMonth:(I)V");
                        this.checkValidMonth(n2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.yearToEpochMonth:(I)I");
                        n4 = this.yearToEpochMonth(n) + (n2 - 1);
                        RuntimeCostAccounter.recordJump();
                        if (n4 < 0) break block4;
                        int n5 = this.hijrahEpochMonthStartDays.length;
                        RuntimeCostAccounter.recordJump();
                        if (n4 < n5) break block5;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Invalid Hijrah date, year: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(", month: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder5.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                RuntimeCostAccounter.recordJump();
                if (n3 < 1) break block6;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getMonthLength:(II)I");
                int n6 = this.getMonthLength(n, n2);
                RuntimeCostAccounter.recordJump();
                if (n3 <= n6) break block7;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder.append("Invalid Hijrah day of month: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(n3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToEpochDay:(I)I");
        return this.epochMonthToEpochDay(n4) + (n3 - 1);
    }

    int getDayOfYear(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.yearMonthToDayOfYear:(II)I");
        return this.yearMonthToDayOfYear(n, n2 - 1);
    }

    int getMonthLength(int n, int n2) {
        int n3;
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.yearToEpochMonth:(I)I");
                n3 = this.yearToEpochMonth(n) + (n2 - 1);
                RuntimeCostAccounter.recordJump();
                if (n3 < 0) break block2;
                int n4 = this.hijrahEpochMonthStartDays.length;
                RuntimeCostAccounter.recordJump();
                if (n3 < n4) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid Hijrah date, year: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(", month: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthLength:(I)I");
        return this.epochMonthLength(n3);
    }

    int getYearLength(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.yearMonthToDayOfYear:(II)I");
        return this.yearMonthToDayOfYear(n, 12);
    }

    int getMinimumYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToYear:(I)I");
        return this.epochMonthToYear(0);
    }

    int getMaximumYear() {
        int n = this.hijrahEpochMonthStartDays.length - 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToYear:(I)I");
        return this.epochMonthToYear(n) - 1;
    }

    int getMaximumMonthLength() {
        return this.maxMonthLength;
    }

    int getMinimumMonthLength() {
        return this.minMonthLength;
    }

    int getMaximumDayOfYear() {
        return this.maxYearLength;
    }

    int getSmallestMaximumDayOfYear() {
        return this.minYearLength;
    }

    private int epochDayToEpochMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.binarySearch:([II)I");
        int n2 = Arrays.binarySearch(this.hijrahEpochMonthStartDays, n);
        RuntimeCostAccounter.recordJump();
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return n2;
    }

    private int epochMonthToYear(int n) {
        return (n + this.hijrahStartEpochMonth) / 12;
    }

    private int yearToEpochMonth(int n) {
        return n * 12 - this.hijrahStartEpochMonth;
    }

    private int epochMonthToMonth(int n) {
        return (n + this.hijrahStartEpochMonth) % 12;
    }

    private int epochMonthToEpochDay(int n) {
        return this.hijrahEpochMonthStartDays[n];
    }

    private int yearMonthToDayOfYear(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.yearToEpochMonth:(I)I");
        int n3 = this.yearToEpochMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToEpochDay:(I)I");
        int n4 = this.epochMonthToEpochDay(n3 + n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.epochMonthToEpochDay:(I)I");
        return n4 - this.epochMonthToEpochDay(n3);
    }

    private int epochMonthLength(int n) {
        return this.hijrahEpochMonthStartDays[n + 1] - this.hijrahEpochMonthStartDays[n];
    }

    private static Properties readConfigProperties(String string) throws Exception {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = () -> {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                String string2 = System.getProperty("java.home");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(File.separator);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("lib");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder4.toString();
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
                File file = new File(string3, string);
                RuntimeCostAccounter.recordAllocation((String)"java/util/Properties");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.<init>:()V");
                Properties properties = new Properties();
                RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/io/File;)V");
                FileInputStream fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.load:(Ljava/io/InputStream;)V");
                    properties.load(fileInputStream);
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        RuntimeCostAccounter.recordThrow();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        block9: {
                            block10: {
                                RuntimeCostAccounter.recordJump();
                                if (fileInputStream == null) break block9;
                                RuntimeCostAccounter.recordJump();
                                if (throwable == null) break block10;
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                                    ((InputStream)fileInputStream).close();
                                }
                                catch (Throwable throwable5) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                    throwable.addSuppressed(throwable5);
                                    RuntimeCostAccounter.recordJump();
                                }
                                RuntimeCostAccounter.recordJump();
                                break block9;
                                break block9;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                            ((InputStream)fileInputStream).close();
                        }
                        RuntimeCostAccounter.recordThrow();
                        throw throwable4;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (fileInputStream == null) return properties;
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Throwable throwable2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                        throwable.addSuppressed(throwable2);
                        RuntimeCostAccounter.recordJump();
                        return properties;
                    }
                    RuntimeCostAccounter.recordJump();
                    return properties;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                ((InputStream)fileInputStream).close();
                RuntimeCostAccounter.recordJump();
                return properties;
            };
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedExceptionAction;)Ljava/lang/Object;");
            return (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/security/PrivilegedActionException.getException:()Ljava/lang/Exception;");
            Exception exception = privilegedActionException.getException();
            RuntimeCostAccounter.recordThrow();
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadCalendarData() {
        try {
            int n;
            int n2;
            int n3;
            HashMap<Integer, int[]> hashMap;
            block27: {
                block26: {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append(PROP_PREFIX);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(this.typeId);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                    String string2 = calendarProperties.getProperty(string);
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder4 = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append("Resource missing for calendar: calendar.hijrah.");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append(this.typeId);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string3 = stringBuilder6.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                    Objects.requireNonNull(string2, string3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.readConfigProperties:(Ljava/lang/String;)Ljava/util/Properties;");
                    Properties properties = HijrahChronology.readConfigProperties(string2);
                    RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
                    hashMap = new HashMap<Integer, int[]>();
                    n3 = Integer.MAX_VALUE;
                    n2 = Integer.MIN_VALUE;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    n = 0;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Properties.entrySet:()Ljava/util/Set;");
                    Set set = properties.entrySet();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                    Iterator iterator = set.iterator();
                    while (true) {
                        String string7;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        Map.Entry entry = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        String string8 = string7 = (String)entry.getKey();
                        int n4 = -1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
                        switch (string8.hashCode()) {
                            case 3355: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                                boolean bl2 = string8.equals(KEY_ID);
                                RuntimeCostAccounter.recordJump();
                                if (!bl2) break;
                                n4 = 0;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case 3575610: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                                boolean bl3 = string8.equals(KEY_TYPE);
                                RuntimeCostAccounter.recordJump();
                                if (!bl3) break;
                                n4 = 1;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case 351608024: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                                boolean bl4 = string8.equals(KEY_VERSION);
                                RuntimeCostAccounter.recordJump();
                                if (!bl4) break;
                                n4 = 2;
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case -1117701862: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                                boolean bl5 = string8.equals(KEY_ISO_START);
                                RuntimeCostAccounter.recordJump();
                                if (!bl5) break;
                                n4 = 3;
                                break;
                            }
                        }
                        switch (n4) {
                            case 0: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                                string4 = (String)entry.getValue();
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case 1: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                                string5 = (String)entry.getValue();
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case 2: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                                string6 = (String)entry.getValue();
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            case 3: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                                String string9 = (String)entry.getValue();
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.parseYMD:(Ljava/lang/String;)[I");
                                int[] nArray = this.parseYMD(string9);
                                int n5 = nArray[0];
                                int n6 = nArray[1];
                                int n7 = nArray[2];
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
                                LocalDate localDate = LocalDate.of(n5, n6, n7);
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
                                n = (int)localDate.toEpochDay();
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                            default: {
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(Ljava/lang/String;)Ljava/lang/Integer;");
                                    Integer n8 = Integer.valueOf(string7);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                                    int n9 = n8;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                                    String string10 = (String)entry.getValue();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.parseMonths:(Ljava/lang/String;)[I");
                                    int[] nArray = this.parseMonths(string10);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                                    Integer n10 = n9;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                                    hashMap.put(n10, nArray);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                                    n2 = Math.max(n2, n9);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                                    n3 = Math.min(n3, n9);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                    StringBuilder stringBuilder7 = new StringBuilder();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                    StringBuilder stringBuilder8 = stringBuilder7.append("bad key: ");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                    StringBuilder stringBuilder9 = stringBuilder8.append(string7);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                    String string11 = stringBuilder9.toString();
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string11);
                                    RuntimeCostAccounter.recordThrow();
                                    throw illegalArgumentException;
                                }
                                RuntimeCostAccounter.recordJump();
                                break;
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getId:()Ljava/lang/String;");
                    String string12 = this.getId();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl = string12.equals(string4);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder10 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder11 = stringBuilder10.append("Configuration is for a different calendar: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder12 = stringBuilder11.append(string4);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string13 = stringBuilder12.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string13);
                        RuntimeCostAccounter.recordThrow();
                        throw illegalArgumentException;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getCalendarType:()Ljava/lang/String;");
                    String string14 = this.getCalendarType();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl6 = string14.equals(string5);
                    RuntimeCostAccounter.recordJump();
                    if (!bl6) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder13 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder14 = stringBuilder13.append("Configuration is for a different calendar type: ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder15 = stringBuilder14.append(string5);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string15 = stringBuilder15.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string15);
                        RuntimeCostAccounter.recordThrow();
                        throw illegalArgumentException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (string6 == null) break block26;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.isEmpty:()Z");
                    boolean bl7 = string6.isEmpty();
                    RuntimeCostAccounter.recordJump();
                    if (!bl7) break block27;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Configuration does not contain a version");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Configuration does not contain a ISO start date");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            this.hijrahStartEpochMonth = n3 * 12;
            this.minEpochDay = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.createEpochMonths:(IIILjava/util/Map;)[I");
            this.hijrahEpochMonthStartDays = this.createEpochMonths(this.minEpochDay, n3, n2, hashMap);
            this.maxEpochDay = this.hijrahEpochMonthStartDays[this.hijrahEpochMonthStartDays.length - 1];
            int n11 = n3;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n11 < n2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.getYearLength:(I)I");
                    int n12 = this.getYearLength(n11);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                    this.minYearLength = Math.min(this.minYearLength, n12);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                    this.maxYearLength = Math.max(this.maxYearLength, n12);
                    ++n11;
                    RuntimeCostAccounter.recordJump();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.getLogger:(Ljava/lang/String;)Lsun/util/logging/PlatformLogger;");
            PlatformLogger platformLogger = PlatformLogger.getLogger((String)"java.time.chrono");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder16 = stringBuilder.append("Unable to initialize Hijrah calendar proxy: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder17 = stringBuilder16.append(this.typeId);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder17.toString();
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.severe:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            platformLogger.severe(string, (Throwable)exception);
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder18 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder19 = stringBuilder18.append("Unable to initialize HijrahCalendar: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder20 = stringBuilder19.append(this.typeId);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string16 = stringBuilder20.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException = new DateTimeException(string16, exception);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordJump();
    }

    private int[] createEpochMonths(int n, int n2, int n3, Map<Integer, int[]> map) {
        int n4 = (n3 - n2 + 1) * 12 + 1;
        int n5 = 0;
        int n6 = n4;
        RuntimeCostAccounter.recordArrayAllocation((int)n6, (int)4);
        int[] nArray = new int[n6];
        this.minMonthLength = Integer.MAX_VALUE;
        this.maxMonthLength = Integer.MIN_VALUE;
        int n7 = n2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n7 > n3) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            Integer n8 = n7;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            int[] nArray2 = map.get(n8);
            int n9 = 0;
            while (true) {
                int n10;
                block7: {
                    block6: {
                        RuntimeCostAccounter.recordJump();
                        if (n9 >= 12) break;
                        n10 = nArray2[n9];
                        nArray[n5++] = n;
                        RuntimeCostAccounter.recordJump();
                        if (n10 < 29) break block6;
                        RuntimeCostAccounter.recordJump();
                        if (n10 <= 32) break block7;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Invalid month length in year: ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                n += n10;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                this.minMonthLength = Math.min(this.minMonthLength, n10);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                this.maxMonthLength = Math.max(this.maxMonthLength, n10);
                ++n9;
                RuntimeCostAccounter.recordJump();
            }
            ++n7;
            RuntimeCostAccounter.recordJump();
        }
        nArray[n5++] = n;
        int n11 = nArray.length;
        RuntimeCostAccounter.recordJump();
        if (n5 != n11) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("Did not fill epochMonths exactly: ndx = ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n5);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(" should be ");
            int n12 = nArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(n12);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        return nArray;
    }

    private int[] parseMonths(String string) {
        RuntimeCostAccounter.recordArrayAllocation((int)12, (int)4);
        int[] nArray = new int[12];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.split:(Ljava/lang/String;)[Ljava/lang/String;");
        Object[] objectArray = string.split("\\s");
        int n = objectArray.length;
        RuntimeCostAccounter.recordJump();
        if (n != 12) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("wrong number of months on line: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.toString:([Ljava/lang/Object;)Ljava/lang/String;");
            String string2 = Arrays.toString(objectArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("; count: ");
            int n2 = objectArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= 12) break;
            try {
                String string4 = objectArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(Ljava/lang/String;)Ljava/lang/Integer;");
                Integer n4 = Integer.valueOf(string4);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                nArray[n3] = n4;
            }
            catch (NumberFormatException numberFormatException) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder.append("bad key: ");
                Object object = objectArray[n3];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append((String)object);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string5 = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string5);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return nArray;
    }

    private int[] parseYMD(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.trim:()Ljava/lang/String;");
        string = string.trim();
        try {
            block5: {
                block4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                    char c = string.charAt(4);
                    RuntimeCostAccounter.recordJump();
                    if (c != '-') break block4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                    char c2 = string.charAt(7);
                    RuntimeCostAccounter.recordJump();
                    if (c2 == '-') break block5;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("date must be yyyy-MM-dd");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordArrayAllocation((int)3, (int)4);
            int[] nArray = new int[3];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string2 = string.substring(0, 4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(Ljava/lang/String;)Ljava/lang/Integer;");
            Integer n = Integer.valueOf(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
            nArray[0] = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string3 = string.substring(5, 7);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(Ljava/lang/String;)Ljava/lang/Integer;");
            Integer n2 = Integer.valueOf(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
            nArray[1] = n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string4 = string.substring(8, 10);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(Ljava/lang/String;)Ljava/lang/Integer;");
            Integer n3 = Integer.valueOf(string4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
            nArray[2] = n3;
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("date must be yyyy-MM-dd", numberFormatException);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
    }

    @Override
    Object writeReplace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.writeReplace:()Ljava/lang/Object;");
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/calendar/BaseCalendar.getCalendarProperties:()Ljava/util/Properties;");
            calendarProperties = BaseCalendar.getCalendarProperties();
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError("Can't initialize lib/calendars.properties", iOException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
        RuntimeCostAccounter.recordJump();
        try {
            RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/HijrahChronology");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.<init>:(Ljava/lang/String;)V");
            INSTANCE = new HijrahChronology("Hijrah-umalqura");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;Ljava/lang/String;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(INSTANCE, "Hijrah");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;Ljava/lang/String;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(INSTANCE, "islamic");
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.getLogger:(Ljava/lang/String;)Lsun/util/logging/PlatformLogger;");
            PlatformLogger platformLogger = PlatformLogger.getLogger((String)"java.time.chrono");
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.severe:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            platformLogger.severe("Unable to initialize Hijrah calendar: Hijrah-umalqura", (Throwable)dateTimeException);
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.getCause:()Ljava/lang/Throwable;");
            Throwable throwable = dateTimeException.getCause();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            RuntimeException runtimeException = new RuntimeException("Unable to initialize Hijrah-umalqura calendar", throwable);
            RuntimeCostAccounter.recordThrow();
            throw runtimeException;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/HijrahChronology.registerVariants:()V");
        HijrahChronology.registerVariants();
    }
}

