/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.AbstractChronology;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoLocalDateTimeImpl;
import sandbox.java.time.chrono.ChronoPeriod;
import sandbox.java.time.chrono.ChronoPeriodImpl;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTimeImpl;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DateTimeFormatterBuilder;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.format.TextStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;

public interface Chronology
extends Comparable<Chronology> {
    public static Chronology from(TemporalAccessor temporalAccessor) {
        Chronology chronology;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        Chronology chronology2 = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (chronology2 != null) {
            chronology = chronology2;
            RuntimeCostAccounter.recordJump();
        } else {
            chronology = IsoChronology.INSTANCE;
        }
        return chronology;
    }

    public static Chronology ofLocale(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.ofLocale:(Ljava/util/Locale;)Ljava/time/chrono/Chronology;");
        return AbstractChronology.ofLocale(locale);
    }

    public static Chronology of(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.of:(Ljava/lang/String;)Ljava/time/chrono/Chronology;");
        return AbstractChronology.of(string);
    }

    public static Set<Chronology> getAvailableChronologies() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.getAvailableChronologies:()Ljava/util/Set;");
        return AbstractChronology.getAvailableChronologies();
    }

    public String getId();

    public String getCalendarType();

    default public ChronoLocalDate date(Era era, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n4 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
        return this.date(n4, n2, n3);
    }

    public ChronoLocalDate date(int var1, int var2, int var3);

    default public ChronoLocalDate dateYearDay(Era era, int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
        int n3 = this.prolepticYear(era, n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
        return this.dateYearDay(n3, n2);
    }

    public ChronoLocalDate dateYearDay(int var1, int var2);

    public ChronoLocalDate dateEpochDay(long var1);

    default public ChronoLocalDate dateNow() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/ChronoLocalDate;");
        return this.dateNow(clock);
    }

    default public ChronoLocalDate dateNow(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.dateNow:(Ljava/time/Clock;)Ljava/time/chrono/ChronoLocalDate;");
        return this.dateNow(clock);
    }

    default public ChronoLocalDate dateNow(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
        return this.date(localDate);
    }

    public ChronoLocalDate date(TemporalAccessor var1);

    default public ChronoLocalDateTime<? extends ChronoLocalDate> localDateTime(TemporalAccessor temporalAccessor) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.date(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalTime;");
            LocalTime localTime = LocalTime.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
            return chronoLocalDate.atTime(localTime);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ChronoLocalDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    default public ChronoZonedDateTime<? extends ChronoLocalDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/ZoneId;");
            ZoneId zoneId = ZoneId.from(temporalAccessor);
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/Instant;");
                Instant instant = Instant.from(temporalAccessor);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.zonedDateTime:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTime;");
                return this.zonedDateTime(instant, zoneId);
            }
            catch (DateTimeException dateTimeException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
                ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime = this.localDateTime(temporalAccessor);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = ChronoLocalDateTimeImpl.ensureValid(this, chronoLocalDateTime);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ofBest:(Ljava/time/chrono/ChronoLocalDateTimeImpl;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/chrono/ChronoZonedDateTime;");
                return ChronoZonedDateTimeImpl.ofBest(chronoLocalDateTimeImpl, zoneId, null);
            }
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ChronoZonedDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(clazz);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    default public ChronoZonedDateTime<? extends ChronoLocalDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ofInstant:(Ljava/time/chrono/Chronology;Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/chrono/ChronoZonedDateTimeImpl;");
        return ChronoZonedDateTimeImpl.ofInstant(this, instant, zoneId);
    }

    public boolean isLeapYear(long var1);

    public int prolepticYear(Era var1, int var2);

    public Era eraOf(int var1);

    public List<Era> eras();

    public ValueRange range(ChronoField var1);

    default public String getDisplayName(TextStyle textStyle, Locale locale) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Chronology$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology$1.<init>:(Ljava/time/chrono/Chronology;)V");
        TemporalAccessor temporalAccessor = new TemporalAccessor(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean isSupported(TemporalField temporalField) {
                return false;
            }

            @Override
            public long getLong(TemporalField temporalField) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder3.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }

            @Override
            public <R> R query(TemporalQuery<R> temporalQuery) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<Chronology> temporalQuery2 = TemporalQueries.chronology();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery2) {
                    return (R)Chronology.this;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
                return TemporalAccessor.super.query(temporalQuery);
            }
        };
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendChronologyText:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendChronologyText(textStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatter;");
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder2.toFormatter(locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(temporalAccessor);
    }

    public ChronoLocalDate resolveDate(Map<TemporalField, Long> var1, ResolverStyle var2);

    default public ChronoPeriod period(int n, int n2, int n3) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoPeriodImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoPeriodImpl.<init>:(Ljava/time/chrono/Chronology;III)V");
        return new ChronoPeriodImpl(this, n, n2, n3);
    }

    @Override
    public int compareTo(Chronology var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

