/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutput;
import sandbox.java.io.Serializable;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateImpl;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTimeImpl;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

final class ChronoLocalDateTimeImpl<D extends ChronoLocalDate>
implements ChronoLocalDateTime<D>,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 4556003607393004514L;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    private final transient D date;
    private final transient LocalTime time;

    static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> of(R r, LocalTime localTime) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoLocalDateTimeImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.<init>:(Ljava/time/chrono/ChronoLocalDate;Ljava/time/LocalTime;)V");
        return new ChronoLocalDateTimeImpl<R>(r, localTime);
    }

    static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> ensureValid(Chronology chronology, Temporal temporal) {
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)temporal;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology2 = chronoLocalDateTimeImpl.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl = chronology.equals(chronology2);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/ClassCastException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Chronology mismatch, required: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string = chronology.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(", actual: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology3 = chronoLocalDateTimeImpl.getChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string2 = chronology3.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassCastException.<init>:(Ljava/lang/String;)V");
            ClassCastException classCastException = new ClassCastException(string3);
            RuntimeCostAccounter.recordThrow();
            throw classCastException;
        }
        return chronoLocalDateTimeImpl;
    }

    private ChronoLocalDateTimeImpl(D d, LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(d, "date");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localTime, "time");
        this.date = d;
        this.time = localTime;
    }

    private ChronoLocalDateTimeImpl<D> with(Temporal temporal, LocalTime localTime) {
        RuntimeCostAccounter.recordJump();
        if (this.date == temporal) {
            RuntimeCostAccounter.recordJump();
            if (this.time == localTime) {
                return this;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.date.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDate;");
        Object d = ChronoLocalDateImpl.ensureValid(chronology, temporal);
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/ChronoLocalDateTimeImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.<init>:(Ljava/time/chrono/ChronoLocalDate;Ljava/time/LocalTime;)V");
        return new ChronoLocalDateTimeImpl(d, localTime);
    }

    @Override
    public D toLocalDate() {
        return this.date;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isDateBased:()Z");
            boolean bl2 = chronoField.isDateBased();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
                boolean bl3 = chronoField.isTimeBased();
                RuntimeCostAccounter.recordJump();
                if (!bl3) return false;
            }
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl5 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl5) return false;
        boolean bl6 = true;
        RuntimeCostAccounter.recordJump();
        return bl6;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ValueRange valueRange;
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                valueRange = this.time.range(temporalField);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                valueRange = this.date.range(temporalField);
            }
            return valueRange;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            int n;
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.get:(Ljava/time/temporal/TemporalField;)I");
                n = this.time.get(temporalField);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
                n = this.date.get(temporalField);
            }
            return n;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        return valueRange.checkValidIntValue(l, temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            long l;
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getLong:(Ljava/time/temporal/TemporalField;)J");
                l = this.time.getLong(temporalField);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                l = this.date.getLong(temporalField);
            }
            return l;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalAdjuster temporalAdjuster) {
        boolean bl = temporalAdjuster instanceof ChronoLocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoLocalDate chronoLocalDate = (ChronoLocalDate)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
            return this.with(chronoLocalDate, this.time);
        }
        boolean bl2 = temporalAdjuster instanceof LocalTime;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            LocalTime localTime = (LocalTime)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
            return this.with((Temporal)this.date, localTime);
        }
        boolean bl3 = temporalAdjuster instanceof ChronoLocalDateTimeImpl;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology = this.date.getChronology();
            ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
            return ChronoLocalDateTimeImpl.ensureValid(chronology, chronoLocalDateTimeImpl);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.date.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)temporalAdjuster.adjustInto(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, chronoLocalDateTimeImpl);
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalTime;");
                LocalTime localTime = this.time.with(temporalField, l);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                return this.with((Temporal)this.date, localTime);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.date.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
            return this.with(chronoLocalDate, this.time);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.date.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = temporalField.adjustInto(this, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, chronoLocalDateTimeImpl);
    }

    @Override
    public ChronoLocalDateTimeImpl<D> plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusNanos:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return this.plusNanos(l);
                }
                case 2: {
                    long l2 = l / 86400000000L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    ChronoLocalDateTimeImpl<D> chronoLocalDateTimeImpl = this.plusDays(l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusNanos:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return super.plusNanos(l % 86400000000L * 1000L);
                }
                case 3: {
                    long l3 = l / 86400000L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    ChronoLocalDateTimeImpl<D> chronoLocalDateTimeImpl = this.plusDays(l3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusNanos:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return super.plusNanos(l % 86400000L * 1000000L);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusSeconds:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return this.plusSeconds(l);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusMinutes:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return this.plusMinutes(l);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusHours:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return this.plusHours(l);
                }
                case 7: {
                    long l4 = l / 256L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusDays:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    ChronoLocalDateTimeImpl<D> chronoLocalDateTimeImpl = this.plusDays(l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusHours:(J)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
                    return super.plusHours(l % 256L * 12L);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.date.plus(l, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
            return this.with(chronoLocalDate, this.time);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.date.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = temporalUnit.addTo(this, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.ensureValid:(Ljava/time/chrono/Chronology;Ljava/time/temporal/Temporal;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return ChronoLocalDateTimeImpl.ensureValid(chronology, chronoLocalDateTimeImpl);
    }

    private ChronoLocalDateTimeImpl<D> plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.date.plus(l, ChronoUnit.DAYS);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return this.with(chronoLocalDate, this.time);
    }

    private ChronoLocalDateTimeImpl<D> plusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusWithOverflow:(Ljava/time/chrono/ChronoLocalDate;JJJJ)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusWithOverflow:(Ljava/time/chrono/ChronoLocalDate;JJJJ)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L);
    }

    ChronoLocalDateTimeImpl<D> plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusWithOverflow:(Ljava/time/chrono/ChronoLocalDate;JJJJ)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.plusWithOverflow:(Ljava/time/chrono/ChronoLocalDate;JJJJ)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l);
    }

    private ChronoLocalDateTimeImpl<D> plusWithOverflow(D d, long l, long l2, long l3, long l4) {
        LocalTime localTime;
        RuntimeCostAccounter.recordJump();
        if ((l | l2 | l3 | l4) == 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
            return this.with((Temporal)d, this.time);
        }
        long l5 = l4 / 86400000000000L + l3 / 86400L + l2 / 1440L + l / 24L;
        long l6 = l4 % 86400000000000L + l3 % 86400L * 1000000000L + l2 % 1440L * 60000000000L + l % 24L * 3600000000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l7 = this.time.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        l5 += Math.floorDiv(l6 += l7, 86400000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        long l8 = Math.floorMod(l6, 86400000000000L);
        RuntimeCostAccounter.recordJump();
        if (l8 == l7) {
            localTime = this.time;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
            localTime = LocalTime.ofNanoOfDay(l8);
        }
        LocalTime localTime2 = localTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = d.plus(l5, ChronoUnit.DAYS);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.with:(Ljava/time/temporal/Temporal;Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTimeImpl;");
        return this.with(chronoLocalDate, localTime2);
    }

    @Override
    public ChronoZonedDateTime<D> atZone(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTimeImpl.ofBest:(Ljava/time/chrono/ChronoLocalDateTimeImpl;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/chrono/ChronoZonedDateTime;");
        return ChronoZonedDateTimeImpl.ofBest(this, zoneId, null);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporal, "endExclusive");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.getChronology:()Ljava/time/chrono/Chronology;");
        Chronology chronology = this.getChronology();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.localDateTime:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDateTime;");
        ChronoLocalDateTime<? extends ChronoLocalDate> chronoLocalDateTime = chronology.localDateTime(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isTimeBased:()Z");
            boolean bl2 = temporalUnit.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.getLong:(Ljava/time/temporal/TemporalField;)J");
                long l = chronoLocalDateTime.getLong(ChronoField.EPOCH_DAY);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                long l2 = l - this.date.getLong(ChronoField.EPOCH_DAY);
                ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
                switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                    case 1: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 86400000000000L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 86400000000L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 86400000L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 86400L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 5: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 1440L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 24L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 7: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        l2 = Math.multiplyExact(l2, 2L);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
                LocalTime localTime = chronoLocalDateTime.toLocalTime();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
                long l3 = this.time.until(localTime, temporalUnit);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                return Math.addExact(l2, l3);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = chronoLocalDateTime.toLocalDate();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = chronoLocalDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.isBefore:(Ljava/time/LocalTime;)Z");
            boolean bl3 = localTime.isBefore(this.time);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.minus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate = chronoLocalDate.minus(1L, ChronoUnit.DAYS);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
            return this.date.until(chronoLocalDate, temporalUnit);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalUnit, "unit");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, chronoLocalDateTime);
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(2, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeObject:(Ljava/lang/Object;)V");
        objectOutput.writeObject(this.date);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutput.writeObject:(Ljava/lang/Object;)V");
        objectOutput.writeObject(this.time);
    }

    static ChronoLocalDateTime<?> readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readObject:()Ljava/lang/Object;");
        ChronoLocalDate chronoLocalDate = (ChronoLocalDate)objectInput.readObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInput.readObject:()Ljava/lang/Object;");
        LocalTime localTime = (LocalTime)objectInput.readObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/chrono/ChronoLocalDateTime;");
        return chronoLocalDate.atTime(localTime);
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ChronoLocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            ChronoLocalDateTime chronoLocalDateTime = (ChronoLocalDateTime)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.compareTo:(Ljava/time/chrono/ChronoLocalDateTime;)I");
            int n = this.compareTo(chronoLocalDateTime);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.hashCode:()I");
        int n = d.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.hashCode:()I");
        return n ^ localTime.hashCode();
    }

    @Override
    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        D d = this.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toString:()Ljava/lang/String;");
        String string = d.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append('T');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTimeImpl.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = this.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toString:()Ljava/lang/String;");
        String string2 = localTime.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder4.toString();
    }
}

