/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.chrono;

import java.io.Serializable;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectStreamException;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.LocalTime;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.HijrahChronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.chrono.JapaneseChronology;
import sandbox.java.time.chrono.MinguoChronology;
import sandbox.java.time.chrono.Ser;
import sandbox.java.time.chrono.ThaiBuddhistChronology;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAdjusters;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.HashSet;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.ServiceLoader;
import sandbox.java.util.Set;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.sun.util.logging.PlatformLogger;

public abstract class AbstractChronology
implements Chronology {
    static final Comparator<ChronoLocalDate> DATE_ORDER = (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(chronoLocalDate, chronoLocalDate2) -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = chronoLocalDate.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = chronoLocalDate2.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        return Long.compare(l, l2);
    }));
    static final Comparator<ChronoLocalDateTime<? extends ChronoLocalDate>> DATE_TIME_ORDER = (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(chronoLocalDateTime, chronoLocalDateTime2) -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        Object d = chronoLocalDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l = d.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalDate:()Ljava/time/chrono/ChronoLocalDate;");
        Object d2 = chronoLocalDateTime2.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.toEpochDay:()J");
        long l2 = d2.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(l, l2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = chronoLocalDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l3 = localTime.toNanoOfDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoLocalDateTime2.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
            long l4 = localTime2.toNanoOfDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
            n = Long.compare(l3, l4);
        }
        return n;
    }));
    static final Comparator<ChronoZonedDateTime<?>> INSTANT_ORDER = (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(chronoZonedDateTime, chronoZonedDateTime2) -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l = chronoZonedDateTime.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toEpochSecond:()J");
        long l2 = chronoZonedDateTime2.toEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(l, l2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = chronoZonedDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            long l3 = localTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime2 = chronoZonedDateTime2.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
            long l4 = localTime2.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
            n = Long.compare(l3, l4);
        }
        return n;
    }));
    private static final ConcurrentHashMap<String, Chronology> CHRONOS_BY_ID;
    private static final ConcurrentHashMap<String, Chronology> CHRONOS_BY_TYPE;

    static Chronology registerChrono(Chronology chronology) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
        String string = chronology.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;Ljava/lang/String;)Ljava/time/chrono/Chronology;");
        return AbstractChronology.registerChrono(chronology, string);
    }

    static Chronology registerChrono(Chronology chronology, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        Chronology chronology2 = CHRONOS_BY_ID.putIfAbsent(string, chronology);
        RuntimeCostAccounter.recordJump();
        if (chronology2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
            String string2 = chronology.getCalendarType();
            RuntimeCostAccounter.recordJump();
            if (string2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                CHRONOS_BY_TYPE.putIfAbsent(string2, chronology);
            }
        }
        return chronology2;
    }

    private static boolean initCache() {
        block3: {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            Chronology chronology = CHRONOS_BY_ID.get("ISO");
            RuntimeCostAccounter.recordJump();
            if (chronology != null) break block3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(HijrahChronology.INSTANCE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(JapaneseChronology.INSTANCE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(MinguoChronology.INSTANCE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(ThaiBuddhistChronology.INSTANCE);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;Ljava/lang/ClassLoader;)Ljava/util/ServiceLoader;");
            ServiceLoader<AbstractChronology> serviceLoader = ServiceLoader.load(AbstractChronology.class, null);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.iterator:()Ljava/util/Iterator;");
            Iterator<AbstractChronology> iterator = serviceLoader.iterator();
            while (true) {
                block5: {
                    String string;
                    block4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        AbstractChronology abstractChronology = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.getId:()Ljava/lang/String;");
                        string = abstractChronology.getId();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                        boolean bl2 = string.equals("ISO");
                        RuntimeCostAccounter.recordJump();
                        if (bl2) break block4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
                        Chronology chronology2 = AbstractChronology.registerChrono(abstractChronology);
                        RuntimeCostAccounter.recordJump();
                        if (chronology2 == null) break block5;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.getLogger:(Ljava/lang/String;)Lsun/util/logging/PlatformLogger;");
                    PlatformLogger platformLogger = PlatformLogger.getLogger((String)"java.time.chrono");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Ignoring duplicate Chronology, from ServiceLoader configuration ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string2 = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"sun/util/logging/PlatformLogger.warning:(Ljava/lang/String;)V");
                    platformLogger.warning(string2);
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.registerChrono:(Ljava/time/chrono/Chronology;)Ljava/time/chrono/Chronology;");
            AbstractChronology.registerChrono(IsoChronology.INSTANCE);
            return true;
        }
        return false;
    }

    static Chronology ofLocale(Locale locale) {
        Object object;
        boolean bl;
        String string;
        block8: {
            block7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(locale, "locale");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getUnicodeLocaleType:(Ljava/lang/String;)Ljava/lang/String;");
                string = locale.getUnicodeLocaleType("ca");
                RuntimeCostAccounter.recordJump();
                if (string == null) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = "iso".equals(string);
                RuntimeCostAccounter.recordJump();
                if (bl2) break block7;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl3 = "iso8601".equals(string);
                RuntimeCostAccounter.recordJump();
                if (!bl3) break block8;
            }
            return IsoChronology.INSTANCE;
        }
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            object = CHRONOS_BY_TYPE.get(string);
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                return object;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.initCache:()Z");
            bl = AbstractChronology.initCache();
            RuntimeCostAccounter.recordJump();
        } while (bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;)Ljava/util/ServiceLoader;");
        object = ServiceLoader.load(Chronology.class);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.iterator:()Ljava/util/Iterator;");
        Iterator iterator = ((ServiceLoader)object).iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl4 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Chronology chronology = (Chronology)iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
            String string2 = chronology.getCalendarType();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl5 = string.equals(string2);
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                return chronology;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unknown calendar system: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
        DateTimeException dateTimeException = new DateTimeException(string3);
        RuntimeCostAccounter.recordThrow();
        throw dateTimeException;
    }

    static Chronology of(String string) {
        Object object;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "id");
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.of0:(Ljava/lang/String;)Ljava/time/chrono/Chronology;");
            object = AbstractChronology.of0(string);
            RuntimeCostAccounter.recordJump();
            if (object != null) {
                return object;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.initCache:()Z");
            bl = AbstractChronology.initCache();
            RuntimeCostAccounter.recordJump();
        } while (bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;)Ljava/util/ServiceLoader;");
        object = ServiceLoader.load(Chronology.class);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.iterator:()Ljava/util/Iterator;");
        Iterator iterator = ((ServiceLoader)object).iterator();
        while (true) {
            block7: {
                Chronology chronology;
                block6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl2 = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    chronology = (Chronology)iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                    String string2 = chronology.getId();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl3 = string.equals(string2);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
                    String string3 = chronology.getCalendarType();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl4 = string.equals(string3);
                    RuntimeCostAccounter.recordJump();
                    if (!bl4) break block7;
                }
                return chronology;
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unknown chronology: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
        DateTimeException dateTimeException = new DateTimeException(string4);
        RuntimeCostAccounter.recordThrow();
        throw dateTimeException;
    }

    private static Chronology of0(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Chronology chronology = CHRONOS_BY_ID.get(string);
        RuntimeCostAccounter.recordJump();
        if (chronology == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            chronology = CHRONOS_BY_TYPE.get(string);
        }
        return chronology;
    }

    static Set<Chronology> getAvailableChronologies() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.initCache:()Z");
        AbstractChronology.initCache();
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.values:()Ljava/util/Collection;");
        Collection<Chronology> collection = CHRONOS_BY_ID.values();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:(Ljava/util/Collection;)V");
        HashSet<Chronology> hashSet = new HashSet<Chronology>(collection);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.load:(Ljava/lang/Class;)Ljava/util/ServiceLoader;");
        ServiceLoader<Chronology> serviceLoader = ServiceLoader.load(Chronology.class);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ServiceLoader.iterator:()Ljava/util/Iterator;");
        Iterator<Chronology> iterator = serviceLoader.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Chronology chronology = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.add:(Ljava/lang/Object;)Z");
            hashSet.add(chronology);
            RuntimeCostAccounter.recordJump();
        }
        return hashSet;
    }

    protected AbstractChronology() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    @Override
    public ChronoLocalDate resolveDate(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl = map.containsKey(ChronoField.EPOCH_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l = map.remove(ChronoField.EPOCH_DAY);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateEpochDay:(J)Ljava/time/chrono/ChronoLocalDate;");
            return this.dateEpochDay(l);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveProlepticMonth:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)V");
        this.resolveProlepticMonth(map, resolverStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYearOfEra:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.resolveYearOfEra(map, resolverStyle);
        RuntimeCostAccounter.recordJump();
        if (chronoLocalDate != null) {
            return chronoLocalDate;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
        boolean bl2 = map.containsKey(ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl3 = map.containsKey(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl4 = map.containsKey(ChronoField.DAY_OF_MONTH);
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYMD:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                    return this.resolveYMD(map, resolverStyle);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl5 = map.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH);
                RuntimeCostAccounter.recordJump();
                if (bl5) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl6 = map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
                    RuntimeCostAccounter.recordJump();
                    if (bl6) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYMAA:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                        return this.resolveYMAA(map, resolverStyle);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl7 = map.containsKey(ChronoField.DAY_OF_WEEK);
                    RuntimeCostAccounter.recordJump();
                    if (bl7) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYMAD:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                        return this.resolveYMAD(map, resolverStyle);
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl8 = map.containsKey(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordJump();
            if (bl8) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYD:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                return this.resolveYD(map, resolverStyle);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl9 = map.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR);
            RuntimeCostAccounter.recordJump();
            if (bl9) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl10 = map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
                RuntimeCostAccounter.recordJump();
                if (bl10) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYAA:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                    return this.resolveYAA(map, resolverStyle);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl11 = map.containsKey(ChronoField.DAY_OF_WEEK);
                RuntimeCostAccounter.recordJump();
                if (bl11) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveYAD:(Ljava/util/Map;Ljava/time/format/ResolverStyle;)Ljava/time/chrono/ChronoLocalDate;");
                    return this.resolveYAD(map, resolverStyle);
                }
            }
        }
        return null;
    }

    void resolveProlepticMonth(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l = map.remove(ChronoField.PROLEPTIC_MONTH);
        RuntimeCostAccounter.recordJump();
        if (l != null) {
            RuntimeCostAccounter.recordJump();
            if (resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l2 = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateNow:()Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.dateNow();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate2 = chronoLocalDate.with(ChronoField.DAY_OF_MONTH, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l3 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate3 = chronoLocalDate2.with(ChronoField.PROLEPTIC_MONTH, l3);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
            long l4 = chronoLocalDate3.get(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
            this.addFieldValue(map, ChronoField.MONTH_OF_YEAR, l4);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
            long l5 = chronoLocalDate3.get(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
            this.addFieldValue(map, ChronoField.YEAR, l5);
        }
    }

    ChronoLocalDate resolveYearOfEra(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l = map.remove(ChronoField.YEAR_OF_ERA);
        RuntimeCostAccounter.recordJump();
        if (l != null) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            Long l2 = map.remove(ChronoField.ERA);
            RuntimeCostAccounter.recordJump();
            if (resolverStyle != ResolverStyle.LENIENT) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = this.range(ChronoField.YEAR_OF_ERA);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l3 = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                n = valueRange.checkValidIntValue(l3, ChronoField.YEAR_OF_ERA);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l4 = l;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                n = Math.toIntExact(l4);
            }
            RuntimeCostAccounter.recordJump();
            if (l2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = this.range(ChronoField.ERA);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l5 = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                int n2 = valueRange.checkValidIntValue(l5, ChronoField.ERA);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.eraOf:(I)Ljava/time/chrono/Era;");
                Era era = this.eraOf(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
                long l6 = this.prolepticYear(era, n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                this.addFieldValue(map, ChronoField.YEAR, l6);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl = map.containsKey(ChronoField.YEAR);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                    ValueRange valueRange = this.range(ChronoField.YEAR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                    long l7 = map.get(ChronoField.YEAR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
                    int n3 = valueRange.checkValidIntValue(l7, ChronoField.YEAR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
                    ChronoLocalDate chronoLocalDate = this.dateYearDay(n3, 1);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getEra:()Ljava/time/chrono/Era;");
                    Era era = chronoLocalDate.getEra();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
                    long l8 = this.prolepticYear(era, n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                    this.addFieldValue(map, ChronoField.YEAR, l8);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (resolverStyle == ResolverStyle.STRICT) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        map.put(ChronoField.YEAR_OF_ERA, l);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.eras:()Ljava/util/List;");
                        List<Era> list = this.eras();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.isEmpty:()Z");
                        boolean bl2 = list.isEmpty();
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            long l9 = n;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                            this.addFieldValue(map, ChronoField.YEAR, l9);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                            int n4 = list.size() - 1;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                            Era era = list.get(n4);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.prolepticYear:(Ljava/time/chrono/Era;I)I");
                            long l10 = this.prolepticYear(era, n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.addFieldValue:(Ljava/util/Map;Ljava/time/temporal/ChronoField;J)V");
                            this.addFieldValue(map, ChronoField.YEAR, l10);
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl = map.containsKey(ChronoField.ERA);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = this.range(ChronoField.ERA);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                long l11 = map.get(ChronoField.ERA);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidValue:(JLjava/time/temporal/TemporalField;)J");
                valueRange.checkValidValue(l11, ChronoField.ERA);
            }
        }
        return null;
    }

    ChronoLocalDate resolveYMD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n = valueRange.checkValidIntValue(l, ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = map.remove(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l3 = Math.subtractExact(l2, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = map.remove(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l5 = Math.subtractExact(l4, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.date(n, 1, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l3, ChronoUnit.MONTHS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            return chronoLocalDate2.plus(l5, ChronoUnit.DAYS);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange2 = this.range(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l6 = map.remove(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n2 = valueRange2.checkValidIntValue(l6, ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange3 = this.range(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l7 = map.remove(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n3 = valueRange3.checkValidIntValue(l7, ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.SMART) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
                return this.date(n, n2, n3);
            }
            catch (DateTimeException dateTimeException) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate = this.date(n, n2, 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.lastDayOfMonth:()Ljava/time/temporal/TemporalAdjuster;");
                TemporalAdjuster temporalAdjuster = TemporalAdjusters.lastDayOfMonth();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
                return chronoLocalDate.with(temporalAdjuster);
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
        return this.date(n, n2, n3);
    }

    ChronoLocalDate resolveYD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n = valueRange.checkValidIntValue(l, ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = map.remove(ChronoField.DAY_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l3 = Math.subtractExact(l2, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            return chronoLocalDate.plus(l3, ChronoUnit.DAYS);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange2 = this.range(ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l4 = map.remove(ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n2 = valueRange2.checkValidIntValue(l4, ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
        return this.dateYearDay(n, n2);
    }

    ChronoLocalDate resolveYMAA(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n = valueRange.checkValidIntValue(l, ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = map.remove(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l3 = Math.subtractExact(l2, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l5 = Math.subtractExact(l4, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l6 = map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l7 = Math.subtractExact(l6, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.date(n, 1, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l3, ChronoUnit.MONTHS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate3 = chronoLocalDate2.plus(l5, ChronoUnit.WEEKS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            return chronoLocalDate3.plus(l7, ChronoUnit.DAYS);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange2 = this.range(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l8 = map.remove(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n2 = valueRange2.checkValidIntValue(l8, ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange3 = this.range(ChronoField.ALIGNED_WEEK_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l9 = map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n3 = valueRange3.checkValidIntValue(l9, ChronoField.ALIGNED_WEEK_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange4 = this.range(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l10 = map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n4 = valueRange4.checkValidIntValue(l10, ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.date(n, n2, 1);
        long l11 = (n3 - 1) * 7 + (n4 - 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate4 = chronoLocalDate.plus(l11, ChronoUnit.DAYS);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.STRICT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
            int n5 = chronoLocalDate4.get(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordJump();
            if (n5 != n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different month");
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        return chronoLocalDate4;
    }

    ChronoLocalDate resolveYMAD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n = valueRange.checkValidIntValue(l, ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = map.remove(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l3 = Math.subtractExact(l2, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l5 = Math.subtractExact(l4, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l6 = map.remove(ChronoField.DAY_OF_WEEK);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l7 = Math.subtractExact(l6, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.date(n, 1, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveAligned:(Ljava/time/chrono/ChronoLocalDate;JJJ)Ljava/time/chrono/ChronoLocalDate;");
            return this.resolveAligned(chronoLocalDate, l3, l5, l7);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange2 = this.range(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l8 = map.remove(ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n2 = valueRange2.checkValidIntValue(l8, ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange3 = this.range(ChronoField.ALIGNED_WEEK_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l9 = map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n3 = valueRange3.checkValidIntValue(l9, ChronoField.ALIGNED_WEEK_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange4 = this.range(ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l10 = map.remove(ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n4 = valueRange4.checkValidIntValue(l10, ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.date:(III)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.date(n, n2, 1);
        long l11 = (n3 - 1) * 7;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l11, ChronoUnit.DAYS);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.of:(I)Ljava/time/DayOfWeek;");
        DayOfWeek dayOfWeek = DayOfWeek.of(n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.nextOrSame:(Ljava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.nextOrSame(dayOfWeek);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate3 = chronoLocalDate2.with(temporalAdjuster);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.STRICT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
            int n5 = chronoLocalDate3.get(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordJump();
            if (n5 != n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different month");
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        return chronoLocalDate3;
    }

    ChronoLocalDate resolveYAA(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n = valueRange.checkValidIntValue(l, ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l3 = Math.subtractExact(l2, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l5 = Math.subtractExact(l4, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l3, ChronoUnit.WEEKS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            return chronoLocalDate2.plus(l5, ChronoUnit.DAYS);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange2 = this.range(ChronoField.ALIGNED_WEEK_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l6 = map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n2 = valueRange2.checkValidIntValue(l6, ChronoField.ALIGNED_WEEK_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange3 = this.range(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l7 = map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n3 = valueRange3.checkValidIntValue(l7, ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1);
        long l8 = (n2 - 1) * 7 + (n3 - 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate3 = chronoLocalDate.plus(l8, ChronoUnit.DAYS);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.STRICT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
            int n4 = chronoLocalDate3.get(ChronoField.YEAR);
            RuntimeCostAccounter.recordJump();
            if (n4 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different year");
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        return chronoLocalDate3;
    }

    ChronoLocalDate resolveYAD(Map<TemporalField, Long> map, ResolverStyle resolverStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l = map.remove(ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n = valueRange.checkValidIntValue(l, ChronoField.YEAR);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.LENIENT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l3 = Math.subtractExact(l2, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l4 = map.remove(ChronoField.DAY_OF_WEEK);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
            long l5 = Math.subtractExact(l4, 1L);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
            ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.resolveAligned:(Ljava/time/chrono/ChronoLocalDate;JJJ)Ljava/time/chrono/ChronoLocalDate;");
            return this.resolveAligned(chronoLocalDate, 0L, l3, l5);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange2 = this.range(ChronoField.ALIGNED_WEEK_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l6 = map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n2 = valueRange2.checkValidIntValue(l6, ChronoField.ALIGNED_WEEK_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.range:(Ljava/time/temporal/ChronoField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange3 = this.range(ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
        long l7 = map.remove(ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        int n3 = valueRange3.checkValidIntValue(l7, ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.dateYearDay:(II)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate = this.dateYearDay(n, 1);
        long l8 = (n2 - 1) * 7;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l8, ChronoUnit.DAYS);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.of:(I)Ljava/time/DayOfWeek;");
        DayOfWeek dayOfWeek = DayOfWeek.of(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.nextOrSame:(Ljava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.nextOrSame(dayOfWeek);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate3 = chronoLocalDate2.with(temporalAdjuster);
        RuntimeCostAccounter.recordJump();
        if (resolverStyle == ResolverStyle.STRICT) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
            int n4 = chronoLocalDate3.get(ChronoField.YEAR);
            RuntimeCostAccounter.recordJump();
            if (n4 != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException("Strict mode rejected resolved date as it is in a different year");
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        return chronoLocalDate3;
    }

    ChronoLocalDate resolveAligned(ChronoLocalDate chronoLocalDate, long l, long l2, long l3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate2 = chronoLocalDate.plus(l, ChronoUnit.MONTHS);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
        ChronoLocalDate chronoLocalDate3 = chronoLocalDate2.plus(l2, ChronoUnit.WEEKS);
        RuntimeCostAccounter.recordJump();
        if (l3 > 7L) {
            long l4 = (l3 - 1L) / 7L;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
            chronoLocalDate3 = chronoLocalDate3.plus(l4, ChronoUnit.WEEKS);
            l3 = (l3 - 1L) % 7L + 1L;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (l3 < 1L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.subtractExact:(JJ)J");
                long l5 = Math.subtractExact(l3, 7L) / 7L;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/chrono/ChronoLocalDate;");
                chronoLocalDate3 = chronoLocalDate3.plus(l5, ChronoUnit.WEEKS);
                l3 = (l3 + 6L) % 7L + 1L;
            }
        }
        int n = (int)l3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.of:(I)Ljava/time/DayOfWeek;");
        DayOfWeek dayOfWeek = DayOfWeek.of(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjusters.nextOrSame:(Ljava/time/DayOfWeek;)Ljava/time/temporal/TemporalAdjuster;");
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.nextOrSame(dayOfWeek);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.with:(Ljava/time/temporal/TemporalAdjuster;)Ljava/time/chrono/ChronoLocalDate;");
        return chronoLocalDate3.with(temporalAdjuster);
    }

    void addFieldValue(Map<TemporalField, Long> map, ChronoField chronoField, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Long l2 = map.get(chronoField);
        RuntimeCostAccounter.recordJump();
        if (l2 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l3 = l2 - l;
            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l4 != false) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Conflict found: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(chronoField);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(" ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(" differs from ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(chronoField);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(" ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder9.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        Long l5 = l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        map.put(chronoField, l5);
    }

    @Override
    public int compareTo(Chronology chronology) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.getId:()Ljava/lang/String;");
        String string = this.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
        String string2 = chronology.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.compareTo:(Ljava/lang/String;)I");
        return string.compareTo(string2);
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof AbstractChronology;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            AbstractChronology abstractChronology = (AbstractChronology)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.compareTo:(Ljava/time/chrono/Chronology;)I");
            int n = this.compareTo(abstractChronology);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        int n = clazz.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.getId:()Ljava/lang/String;");
        String string = this.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        return n ^ string.hashCode();
    }

    @Override
    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.getId:()Ljava/lang/String;");
        return this.getId();
    }

    Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/chrono/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(1, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ObjectStreamException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/AbstractChronology.getId:()Ljava/lang/String;");
        String string = this.getId();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeUTF:(Ljava/lang/String;)V");
        dataOutput.writeUTF(string);
    }

    static Chronology readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readUTF:()Ljava/lang/String;");
        String string = dataInput.readUTF();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.of:(Ljava/lang/String;)Ljava/time/chrono/Chronology;");
        return Chronology.of(string);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
        CHRONOS_BY_ID = new ConcurrentHashMap();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
        CHRONOS_BY_TYPE = new ConcurrentHashMap();
    }
}

