/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutput;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.OffsetDateTime;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Objects;

public final class OffsetTime
implements Temporal,
TemporalAdjuster,
Comparable<OffsetTime>,
Serializable {
    public static final OffsetTime MIN;
    public static final OffsetTime MAX;
    private static final long serialVersionUID = 7264499704384272492L;
    private final LocalTime time;
    private final ZoneOffset offset;

    public static OffsetTime now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.now:(Ljava/time/Clock;)Ljava/time/OffsetTime;");
        return OffsetTime.now(clock);
    }

    public static OffsetTime now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.now:(Ljava/time/Clock;)Ljava/time/OffsetTime;");
        return OffsetTime.now(clock);
    }

    public static OffsetTime now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = clock.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = clock.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/OffsetTime;");
        return OffsetTime.ofInstant(instant, zoneOffset);
    }

    public static OffsetTime of(LocalTime localTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime of(int n, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(IIII)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n, n2, n3, n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime ofInstant(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(instant, "instant");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l2, 86400L);
        long l3 = (long)n * 1000000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        long l4 = l3 + (long)instant.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.ofNanoOfDay(l4);
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof OffsetTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (OffsetTime)temporalAccessor;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalTime;");
            LocalTime localTime = LocalTime.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
            return new OffsetTime(localTime, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain OffsetTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static OffsetTime parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/OffsetTime;");
        return OffsetTime.parse(charSequence, DateTimeFormatter.ISO_OFFSET_TIME);
    }

    public static OffsetTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<OffsetTime> temporalQuery = OffsetTime::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private OffsetTime(LocalTime localTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.time = Objects.requireNonNull(localTime, "time");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        this.offset = Objects.requireNonNull(zoneOffset, "offset");
    }

    private OffsetTime with(LocalTime localTime, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordJump();
        if (this.time == localTime) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
            boolean bl = this.offset.equals(zoneOffset);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return this;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
        return new OffsetTime(localTime, zoneOffset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isTimeBased:()Z");
            boolean bl2 = temporalField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordJump();
                if (temporalField != ChronoField.OFFSET_SECONDS) return false;
            }
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl4 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        boolean bl5 = true;
        RuntimeCostAccounter.recordJump();
        return bl5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isTimeBased:()Z");
            return temporalUnit.isTimeBased();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalUnit == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isSupportedBy:(Ljava/time/temporal/Temporal;)Z");
        boolean bl2 = temporalUnit.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                return temporalField.range();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            return this.time.range(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.get:(Ljava/time/temporal/TemporalField;)I");
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                return this.offset.getTotalSeconds();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getLong:(Ljava/time/temporal/TemporalField;)J");
            return this.time.getLong(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public OffsetTime withOffsetSameLocal(ZoneOffset zoneOffset) {
        OffsetTime offsetTime;
        RuntimeCostAccounter.recordJump();
        if (zoneOffset != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
            boolean bl = zoneOffset.equals(this.offset);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                offsetTime = this;
                RuntimeCostAccounter.recordJump();
                return offsetTime;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
        offsetTime = new OffsetTime(this.time, zoneOffset);
        return offsetTime;
    }

    public OffsetTime withOffsetSameInstant(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = zoneOffset.equals(this.offset);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n = zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        int n2 = n - this.offset.getTotalSeconds();
        long l = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusSeconds:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.plusSeconds(l);
        RuntimeCostAccounter.recordAllocation((String)"java/time/OffsetTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.<init>:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)V");
        return new OffsetTime(localTime, zoneOffset);
    }

    public LocalTime toLocalTime() {
        return this.time;
    }

    public int getHour() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getHour:()I");
        return this.time.getHour();
    }

    public int getMinute() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getMinute:()I");
        return this.time.getMinute();
    }

    public int getSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getSecond:()I");
        return this.time.getSecond();
    }

    public int getNano() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        return this.time.getNano();
    }

    @Override
    public OffsetTime with(TemporalAdjuster temporalAdjuster) {
        boolean bl = temporalAdjuster instanceof LocalTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocalTime localTime = (LocalTime)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
            return this.with(localTime, this.offset);
        }
        boolean bl2 = temporalAdjuster instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
            return this.with(this.time, zoneOffset);
        }
        boolean bl3 = temporalAdjuster instanceof OffsetTime;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return (OffsetTime)temporalAdjuster;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (OffsetTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public OffsetTime with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                ChronoField chronoField = (ChronoField)temporalField;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                int n = chronoField.checkValidIntValue(l);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
                return this.with(this.time, zoneOffset);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalTime;");
            LocalTime localTime = this.time.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
            return this.with(localTime, this.offset);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public OffsetTime withHour(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withHour:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withHour(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime withMinute(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withMinute:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withMinute(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime withSecond(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withSecond:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withSecond(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime withNano(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withNano:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withNano(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime truncatedTo(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.truncatedTo:(Ljava/time/temporal/TemporalUnit;)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.truncatedTo(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    @Override
    public OffsetTime plus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (OffsetTime)temporalAmount.addTo(this);
    }

    @Override
    public OffsetTime plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalTime;");
            LocalTime localTime = this.time.plus(l, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
            return this.with(localTime, this.offset);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public OffsetTime plusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusHours:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.plusHours(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime plusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusMinutes:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.plusMinutes(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusSeconds:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.plusSeconds(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.plusNanos:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.plusNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    @Override
    public OffsetTime minus(TemporalAmount temporalAmount) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (OffsetTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public OffsetTime minus(long l, TemporalUnit temporalUnit) {
        OffsetTime offsetTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/OffsetTime;");
            OffsetTime offsetTime2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/OffsetTime;");
            offsetTime = offsetTime2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/OffsetTime;");
            offsetTime = this.plus(l2, temporalUnit);
        }
        return offsetTime;
    }

    public OffsetTime minusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.minusHours:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.minusHours(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime minusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.minusMinutes:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.minusMinutes(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime minusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.minusSeconds:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.minusSeconds(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    public OffsetTime minusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.minusNanos:(J)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.minusNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.with:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return this.with(localTime, this.offset);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        block15: {
            block14: {
                boolean bl;
                boolean bl2;
                block13: {
                    block12: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.offset:()Ljava/time/temporal/TemporalQuery;");
                        TemporalQuery<ZoneOffset> temporalQuery2 = TemporalQueries.offset();
                        RuntimeCostAccounter.recordJump();
                        if (temporalQuery == temporalQuery2) break block12;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
                        TemporalQuery<ZoneId> temporalQuery3 = TemporalQueries.zone();
                        RuntimeCostAccounter.recordJump();
                        if (temporalQuery != temporalQuery3) break block13;
                    }
                    return (R)this.offset;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<ZoneId> temporalQuery4 = TemporalQueries.zoneId();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery4) {
                    bl2 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl2 = false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<Chronology> temporalQuery5 = TemporalQueries.chronology();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery == temporalQuery5) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl = false;
                }
                boolean bl3 = bl2 | bl;
                RuntimeCostAccounter.recordJump();
                if (bl3) break block14;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
                TemporalQuery<LocalDate> temporalQuery6 = TemporalQueries.localDate();
                RuntimeCostAccounter.recordJump();
                if (temporalQuery != temporalQuery6) break block15;
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localTime:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalTime> temporalQuery7 = TemporalQueries.localTime();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery7) {
            return (R)this.time;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.precision:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<TemporalUnit> temporalQuery8 = TemporalQueries.precision();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery8) {
            return (R)ChronoUnit.NANOS;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQuery.queryFrom:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/Object;");
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l = this.time.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        Temporal temporal2 = temporal.with(ChronoField.NANO_OF_DAY, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l2 = this.offset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal2.with(ChronoField.OFFSET_SECONDS, l2);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/OffsetTime;");
        OffsetTime offsetTime = OffsetTime.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
            long l = offsetTime.toEpochNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
            long l2 = l - this.toEpochNano();
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    return l2;
                }
                case 2: {
                    return l2 / 1000L;
                }
                case 3: {
                    return l2 / 1000000L;
                }
                case 4: {
                    return l2 / 1000000000L;
                }
                case 5: {
                    return l2 / 60000000000L;
                }
                case 6: {
                    return l2 / 3600000000000L;
                }
                case 7: {
                    return l2 / 43200000000000L;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, offsetTime);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public OffsetDateTime atDate(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.of(localDate, this.time, this.offset);
    }

    private long toEpochNano() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l = this.time.toNanoOfDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l2 = (long)this.offset.getTotalSeconds() * 1000000000L;
        return l - l2;
    }

    @Override
    public int compareTo(OffsetTime offsetTime) {
        ZoneOffset zoneOffset = offsetTime.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.offset.equals(zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocalTime localTime = offsetTime.time;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.compareTo:(Ljava/time/LocalTime;)I");
            return this.time.compareTo(localTime);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l = this.toEpochNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l2 = offsetTime.toEpochNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.compare:(JJ)I");
        int n = Long.compare(l, l2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            LocalTime localTime = offsetTime.time;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.compareTo:(Ljava/time/LocalTime;)I");
            n = this.time.compareTo(localTime);
        }
        return n;
    }

    public boolean isAfter(OffsetTime offsetTime) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l = this.toEpochNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l2 = l - offsetTime.toEpochNano();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 > 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isBefore(OffsetTime offsetTime) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l = this.toEpochNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l2 = l - offsetTime.toEpochNano();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEqual(OffsetTime offsetTime) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l = this.toEpochNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toEpochNano:()J");
        long l2 = l - offsetTime.toEpochNano();
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l3 == false) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof OffsetTime;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        OffsetTime offsetTime = (OffsetTime)object;
        LocalTime localTime = offsetTime.time;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.time.equals(localTime);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        ZoneOffset zoneOffset = offsetTime.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = this.offset.equals(zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.hashCode:()I");
        int n = this.time.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        return n ^ this.offset.hashCode();
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toString:()Ljava/lang/String;");
        String string = this.time.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.toString:()Ljava/lang/String;");
        String string2 = this.offset.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder3.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(9, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.writeExternal:(Ljava/io/DataOutput;)V");
        this.time.writeExternal(objectOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.writeExternal:(Ljava/io/DataOutput;)V");
        this.offset.writeExternal(objectOutput);
    }

    static OffsetTime readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.readExternal:(Ljava/io/DataInput;)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.readExternal(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.readExternal:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = ZoneOffset.readExternal(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.of:(Ljava/time/LocalTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        return OffsetTime.of(localTime, zoneOffset);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.atOffset:(Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        MIN = LocalTime.MIN.atOffset(ZoneOffset.MAX);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.atOffset:(Ljava/time/ZoneOffset;)Ljava/time/OffsetTime;");
        MAX = LocalTime.MAX.atOffset(ZoneOffset.MIN);
    }
}

