/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.LocalDate;
import sandbox.java.time.Month;
import sandbox.java.time.Ser;
import sandbox.java.time.Year;
import sandbox.java.time.ZoneId;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DateTimeFormatterBuilder;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.util.Objects;

public final class MonthDay
implements TemporalAccessor,
TemporalAdjuster,
Comparable<MonthDay>,
Serializable {
    private static final long serialVersionUID = -939150713474957432L;
    private static final DateTimeFormatter PARSER;
    private final int month;
    private final int day;

    public static MonthDay now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.now:(Ljava/time/Clock;)Ljava/time/MonthDay;");
        return MonthDay.now(clock);
    }

    public static MonthDay now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.now:(Ljava/time/Clock;)Ljava/time/MonthDay;");
        return MonthDay.now(clock);
    }

    public static MonthDay now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.now(clock);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonth:()Ljava/time/Month;");
        Month month = localDate.getMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
        int n = localDate.getDayOfMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.of:(Ljava/time/Month;I)Ljava/time/MonthDay;");
        return MonthDay.of(month, n);
    }

    public static MonthDay of(Month month, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(month, "month");
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.DAY_OF_MONTH.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.maxLength:()I");
        int n2 = month.maxLength();
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Illegal value for DayOfMonth field, value ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" is not valid for month ");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.name:()Ljava/lang/String;");
            String string = month.name();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string2);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/MonthDay");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        int n3 = month.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.<init>:(II)V");
        return new MonthDay(n3, n);
    }

    public static MonthDay of(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        Month month = Month.of(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.of:(Ljava/time/Month;I)Ljava/time/MonthDay;");
        return MonthDay.of(month, n2);
    }

    public static MonthDay from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof MonthDay;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (MonthDay)temporalAccessor;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
            Chronology chronology = Chronology.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = IsoChronology.INSTANCE.equals(chronology);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.of:(II)Ljava/time/MonthDay;");
            return MonthDay.of(n, n2);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain MonthDay from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static MonthDay parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/MonthDay;");
        return MonthDay.parse(charSequence, PARSER);
    }

    public static MonthDay parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<MonthDay> temporalQuery = MonthDay::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private MonthDay(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.month = n;
        this.day = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField != ChronoField.MONTH_OF_YEAR) {
                RuntimeCostAccounter.recordJump();
                if (temporalField != ChronoField.DAY_OF_MONTH) return false;
            }
            boolean bl2 = true;
            RuntimeCostAccounter.recordJump();
            return bl2;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl3 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
            return temporalField.range();
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == ChronoField.DAY_OF_MONTH) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.getMonth:()Ljava/time/Month;");
            Month month = this.getMonth();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.minLength:()I");
            long l = month.minLength();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.getMonth:()Ljava/time/Month;");
            Month month2 = this.getMonth();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.maxLength:()I");
            long l2 = month2.maxLength();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJJ)Ljava/time/temporal/ValueRange;");
            return ValueRange.of(1L, l, l2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = this.range(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.getLong:(Ljava/time/temporal/TemporalField;)J");
        long l = this.getLong(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidIntValue:(JLjava/time/temporal/TemporalField;)I");
        return valueRange.checkValidIntValue(l, temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    return this.day;
                }
                case 2: {
                    return this.month;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        return Month.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isValidYear(int var1_1) {
        RuntimeCostAccounter.recordJump();
        if (this.day != 29) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (this.month != 2) ** GOTO lbl-1000
        v0 = var1_1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Year.isLeap:(J)Z");
        v1 = Year.isLeap(v0);
        RuntimeCostAccounter.recordJump();
        if (!v1) {
            v2 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 3 sources

        {
            v2 = false;
        }
        RuntimeCostAccounter.recordJump();
        if (!v2) {
            v3 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            v3 = false;
        }
        return v3;
    }

    public MonthDay withMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        Month month = Month.of(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.with:(Ljava/time/Month;)Ljava/time/MonthDay;");
        return this.with(month);
    }

    public MonthDay with(Month month) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(month, "month");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        int n = month.getValue();
        RuntimeCostAccounter.recordJump();
        if (n == this.month) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.maxLength:()I");
        int n2 = month.maxLength();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n3 = Math.min(this.day, n2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/MonthDay");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        int n4 = month.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.<init>:(II)V");
        return new MonthDay(n4, n3);
    }

    public MonthDay withDayOfMonth(int n) {
        RuntimeCostAccounter.recordJump();
        if (n == this.day) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.of:(II)Ljava/time/MonthDay;");
        return MonthDay.of(this.month, n);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<Chronology> temporalQuery2 = TemporalQueries.chronology();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery2) {
            return (R)IsoChronology.INSTANCE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return TemporalAccessor.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
        Chronology chronology = Chronology.from(temporal);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.equals:(Ljava/lang/Object;)Z");
        boolean bl = chronology.equals(IsoChronology.INSTANCE);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException("Adjustment only supported on ISO date-time");
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        long l = this.month;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        temporal = temporal.with(ChronoField.MONTH_OF_YEAR, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
        ValueRange valueRange = temporal.range(ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
        long l2 = valueRange.getMaximum();
        long l3 = this.day;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        long l4 = Math.min(l2, l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/Temporal.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/temporal/Temporal;");
        return temporal.with(ChronoField.DAY_OF_MONTH, l4);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public LocalDate atYear(int n) {
        int n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.isValidYear:(I)Z");
        boolean bl = this.isValidYear(n);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n2 = this.day;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 28;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(n, this.month, n2);
    }

    @Override
    public int compareTo(MonthDay monthDay) {
        int n = this.month - monthDay.month;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            n = this.day - monthDay.day;
        }
        return n;
    }

    public boolean isAfter(MonthDay monthDay) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.compareTo:(Ljava/time/MonthDay;)I");
        int n = this.compareTo(monthDay);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isBefore(MonthDay monthDay) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.compareTo:(Ljava/time/MonthDay;)I");
        int n = this.compareTo(monthDay);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof MonthDay;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        MonthDay monthDay = (MonthDay)object;
        int n = monthDay.month;
        RuntimeCostAccounter.recordJump();
        if (this.month != n) return false;
        int n2 = monthDay.day;
        RuntimeCostAccounter.recordJump();
        if (this.day != n2) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        return (this.month << 6) + this.day;
    }

    public String toString() {
        String string;
        String string2;
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        StringBuilder stringBuilder = new StringBuilder(10);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("--");
        RuntimeCostAccounter.recordJump();
        if (this.month < 10) {
            string2 = "0";
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = "";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(this.month);
        RuntimeCostAccounter.recordJump();
        if (this.day < 10) {
            string = "-0";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "-";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(this.day);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder6.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(13, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(this.month);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(this.day);
    }

    static MonthDay readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by2 = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/MonthDay.of:(II)Ljava/time/MonthDay;");
        return MonthDay.of(by, (int)by2);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendLiteral("--");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder3 = dateTimeFormatterBuilder2.appendValue(ChronoField.MONTH_OF_YEAR, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder4 = dateTimeFormatterBuilder3.appendLiteral('-');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
        DateTimeFormatterBuilder dateTimeFormatterBuilder5 = dateTimeFormatterBuilder4.appendValue(ChronoField.DAY_OF_MONTH, 2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:()Ljava/time/format/DateTimeFormatter;");
        PARSER = dateTimeFormatterBuilder5.toFormatter();
    }
}

