/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Month;
import sandbox.java.time.OffsetDateTime;
import sandbox.java.time.Period;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.ZonedDateTime;
import sandbox.java.time.chrono.ChronoLocalDateTime;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Objects;

public final class LocalDateTime
implements Temporal,
TemporalAdjuster,
ChronoLocalDateTime<LocalDate>,
Serializable {
    public static final LocalDateTime MIN;
    public static final LocalDateTime MAX;
    private static final long serialVersionUID = 6207766400415563566L;
    private final LocalDate date;
    private final LocalTime time;

    public static LocalDateTime now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.now:(Ljava/time/Clock;)Ljava/time/LocalDateTime;");
        return LocalDateTime.now(clock);
    }

    public static LocalDateTime now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.now:(Ljava/time/Clock;)Ljava/time/LocalDateTime;");
        return LocalDateTime.now(clock);
    }

    public static LocalDateTime now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = clock.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = clock.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        int n = instant.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
        return LocalDateTime.ofEpochSecond(l, n, zoneOffset);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(ILjava/time/Month;I)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, month, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(II)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n3, n4);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(ILjava/time/Month;I)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, month, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(III)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n3, n4, n5);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, Month month, int n2, int n3, int n4, int n5, int n6) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(ILjava/time/Month;I)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, month, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(IIII)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n3, n4, n5, n6);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(II)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n4, n5);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(III)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n4, n5, n6);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.of(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(IIII)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n4, n5, n6, n7);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime of(LocalDate localDate, LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localDate, "date");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localTime, "time");
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime ofInstant(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(instant, "instant");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        int n = instant.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
        return LocalDateTime.ofEpochSecond(l, n, zoneOffset);
    }

    public static LocalDateTime ofEpochSecond(long l, int n, ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        long l2 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.NANO_OF_SECOND.checkValidValue(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l3 = l + (long)zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l4 = Math.floorDiv(l3, 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n2 = (int)Math.floorMod(l3, 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.ofEpochDay(l4);
        long l5 = (long)n2 * 1000000000L + (long)n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.ofNanoOfDay(l5);
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    public static LocalDateTime from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (LocalDateTime)temporalAccessor;
        }
        boolean bl2 = temporalAccessor instanceof ZonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporalAccessor;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            return zonedDateTime.toLocalDateTime();
        }
        boolean bl3 = temporalAccessor instanceof OffsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)temporalAccessor;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            return offsetDateTime.toLocalDateTime();
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
            LocalDate localDate = LocalDate.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalTime;");
            LocalTime localTime = LocalTime.from(temporalAccessor);
            RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
            return new LocalDateTime(localDate, localTime);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain LocalDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static LocalDateTime parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/LocalDateTime;");
        return LocalDateTime.parse(charSequence, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<LocalDateTime> temporalQuery = LocalDateTime::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private LocalDateTime(LocalDate localDate, LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.date = localDate;
        this.time = localTime;
    }

    private LocalDateTime with(LocalDate localDate, LocalTime localTime) {
        RuntimeCostAccounter.recordJump();
        if (this.date == localDate) {
            RuntimeCostAccounter.recordJump();
            if (this.time == localTime) {
                return this;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.<init>:(Ljava/time/LocalDate;Ljava/time/LocalTime;)V");
        return new LocalDateTime(localDate, localTime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isDateBased:()Z");
            boolean bl2 = chronoField.isDateBased();
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
                boolean bl3 = chronoField.isTimeBased();
                RuntimeCostAccounter.recordJump();
                if (!bl3) return false;
            }
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }
        RuntimeCostAccounter.recordJump();
        if (temporalField == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
        boolean bl5 = temporalField.isSupportedBy(this);
        RuntimeCostAccounter.recordJump();
        if (!bl5) return false;
        boolean bl6 = true;
        RuntimeCostAccounter.recordJump();
        return bl6;
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.isSupported:(Ljava/time/temporal/TemporalUnit;)Z");
        return ChronoLocalDateTime.super.isSupported(temporalUnit);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ValueRange valueRange;
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                valueRange = this.time.range(temporalField);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
                valueRange = this.date.range(temporalField);
            }
            return valueRange;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            int n;
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.get:(Ljava/time/temporal/TemporalField;)I");
                n = this.time.get(temporalField);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.get:(Ljava/time/temporal/TemporalField;)I");
                n = this.date.get(temporalField);
            }
            return n;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.get:(Ljava/time/temporal/TemporalField;)I");
        return ChronoLocalDateTime.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            long l;
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getLong:(Ljava/time/temporal/TemporalField;)J");
                l = this.time.getLong(temporalField);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                l = this.date.getLong(temporalField);
            }
            return l;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date;
    }

    public int getYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
        return this.date.getYear();
    }

    public int getMonthValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonthValue:()I");
        return this.date.getMonthValue();
    }

    public Month getMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonth:()Ljava/time/Month;");
        return this.date.getMonth();
    }

    public int getDayOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfYear:()I");
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfWeek:()Ljava/time/DayOfWeek;");
        return this.date.getDayOfWeek();
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    public int getHour() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getHour:()I");
        return this.time.getHour();
    }

    public int getMinute() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getMinute:()I");
        return this.time.getMinute();
    }

    public int getSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getSecond:()I");
        return this.time.getSecond();
    }

    public int getNano() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.getNano:()I");
        return this.time.getNano();
    }

    @Override
    public LocalDateTime with(TemporalAdjuster temporalAdjuster) {
        boolean bl = temporalAdjuster instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocalDate localDate = (LocalDate)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(localDate, this.time);
        }
        boolean bl2 = temporalAdjuster instanceof LocalTime;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            LocalTime localTime = (LocalTime)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(this.date, localTime);
        }
        boolean bl3 = temporalAdjuster instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return (LocalDateTime)temporalAdjuster;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public LocalDateTime with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isTimeBased:()Z");
            boolean bl2 = chronoField.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalTime;");
                LocalTime localTime = this.time.with(temporalField, l);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
                return this.with(this.date, localTime);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalDate;");
            LocalDate localDate = this.date.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(localDate, this.time);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public LocalDateTime withYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.withYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime withMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withMonth:(I)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.withMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime withDayOfMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withDayOfMonth:(I)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.withDayOfMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime withDayOfYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withDayOfYear:(I)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.withDayOfYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime withHour(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withHour:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withHour(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(this.date, localTime);
    }

    public LocalDateTime withMinute(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withMinute:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withMinute(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(this.date, localTime);
    }

    public LocalDateTime withSecond(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withSecond:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withSecond(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(this.date, localTime);
    }

    public LocalDateTime withNano(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.withNano:(I)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.withNano(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(this.date, localTime);
    }

    public LocalDateTime truncatedTo(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.truncatedTo:(Ljava/time/temporal/TemporalUnit;)Ljava/time/LocalTime;");
        LocalTime localTime = this.time.truncatedTo(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(this.date, localTime);
    }

    @Override
    public LocalDateTime plus(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Period period = (Period)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/LocalDate;");
            LocalDate localDate = this.date.plus(period);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(localDate, this.time);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amountToAdd");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalDateTime)temporalAmount.addTo(this);
    }

    @Override
    public LocalDateTime plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusNanos:(J)Ljava/time/LocalDateTime;");
                    return this.plusNanos(l);
                }
                case 2: {
                    long l2 = l / 86400000000L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime = this.plusDays(l2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusNanos:(J)Ljava/time/LocalDateTime;");
                    return localDateTime.plusNanos(l % 86400000000L * 1000L);
                }
                case 3: {
                    long l3 = l / 86400000L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime = this.plusDays(l3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusNanos:(J)Ljava/time/LocalDateTime;");
                    return localDateTime.plusNanos(l % 86400000L * 1000000L);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
                    return this.plusSeconds(l);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMinutes:(J)Ljava/time/LocalDateTime;");
                    return this.plusMinutes(l);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusHours:(J)Ljava/time/LocalDateTime;");
                    return this.plusHours(l);
                }
                case 7: {
                    long l4 = l / 256L;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
                    LocalDateTime localDateTime = this.plusDays(l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusHours:(J)Ljava/time/LocalDateTime;");
                    return localDateTime.plusHours(l % 256L * 12L);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDate;");
            LocalDate localDate = this.date.plus(l, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(localDate, this.time);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public LocalDateTime plusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.plusYears(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.plusMonths(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.plusWeeks(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
        LocalDate localDate = this.date.plusDays(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate, this.time);
    }

    public LocalDateTime plusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L, 1);
    }

    public LocalDateTime plusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L, 1);
    }

    public LocalDateTime plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L, 1);
    }

    public LocalDateTime plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l, 1);
    }

    @Override
    public LocalDateTime minus(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Period period = (Period)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/LocalDate;");
            LocalDate localDate = this.date.minus(period);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(localDate, this.time);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amountToSubtract");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public LocalDateTime minus(long l, TemporalUnit temporalUnit) {
        LocalDateTime localDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
            localDateTime = localDateTime2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
            localDateTime = this.plus(l2, temporalUnit);
        }
        return localDateTime;
    }

    public LocalDateTime minusYears(long l) {
        LocalDateTime localDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusYears:(J)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusYears:(J)Ljava/time/LocalDateTime;");
            localDateTime = localDateTime2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusYears:(J)Ljava/time/LocalDateTime;");
            localDateTime = this.plusYears(l2);
        }
        return localDateTime;
    }

    public LocalDateTime minusMonths(long l) {
        LocalDateTime localDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMonths:(J)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMonths:(J)Ljava/time/LocalDateTime;");
            localDateTime = localDateTime2.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMonths:(J)Ljava/time/LocalDateTime;");
            localDateTime = this.plusMonths(l2);
        }
        return localDateTime;
    }

    public LocalDateTime minusWeeks(long l) {
        LocalDateTime localDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWeeks:(J)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = this.plusWeeks(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWeeks:(J)Ljava/time/LocalDateTime;");
            localDateTime = localDateTime2.plusWeeks(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWeeks:(J)Ljava/time/LocalDateTime;");
            localDateTime = this.plusWeeks(l2);
        }
        return localDateTime;
    }

    public LocalDateTime minusDays(long l) {
        LocalDateTime localDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime2 = this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
            localDateTime = localDateTime2.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
            localDateTime = this.plusDays(l2);
        }
        return localDateTime;
    }

    public LocalDateTime minusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, l, 0L, 0L, 0L, -1);
    }

    public LocalDateTime minusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, 0L, l, 0L, 0L, -1);
    }

    public LocalDateTime minusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, 0L, 0L, l, 0L, -1);
    }

    public LocalDateTime minusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWithOverflow:(Ljava/time/LocalDate;JJJJI)Ljava/time/LocalDateTime;");
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, l, -1);
    }

    private LocalDateTime plusWithOverflow(LocalDate localDate, long l, long l2, long l3, long l4, int n) {
        LocalTime localTime;
        RuntimeCostAccounter.recordJump();
        if ((l | l2 | l3 | l4) == 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            return this.with(localDate, this.time);
        }
        long l5 = l4 / 86400000000000L + l3 / 86400L + l2 / 1440L + l / 24L;
        l5 *= (long)n;
        long l6 = l4 % 86400000000000L + l3 % 86400L * 1000000000L + l2 % 1440L * 60000000000L + l % 24L * 3600000000000L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
        long l7 = this.time.toNanoOfDay();
        l6 = l6 * (long)n + l7;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        l5 += Math.floorDiv(l6, 86400000000000L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        long l8 = Math.floorMod(l6, 86400000000000L);
        RuntimeCostAccounter.recordJump();
        if (l8 == l7) {
            localTime = this.time;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
            localTime = LocalTime.ofNanoOfDay(l8);
        }
        LocalTime localTime2 = localTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
        LocalDate localDate2 = localDate.plusDays(l5);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.with(localDate2, localTime2);
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalDate> temporalQuery2 = TemporalQueries.localDate();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery2) {
            return (R)this.date;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return ChronoLocalDateTime.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return ChronoLocalDateTime.super.adjustInto(temporal);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long until(Temporal var1_1, TemporalUnit var2_2) {
        block17: {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDateTime;");
            var3_3 = LocalDateTime.from(var1_1);
            v0 = var2_2 instanceof ChronoUnit;
            RuntimeCostAccounter.recordJump();
            if (!v0) break block17;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isTimeBased:()Z");
            v1 = var2_2.isTimeBased();
            RuntimeCostAccounter.recordJump();
            if (v1) {
                v2 = var3_3.date;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.daysUntil:(Ljava/time/LocalDate;)J");
                var4_4 = this.date.daysUntil(v2);
                RuntimeCostAccounter.recordJump();
                if (var4_4 == 0L) {
                    v3 = var3_3.time;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
                    return this.time.until(v3, var2_2);
                }
                v4 = var3_3.time;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
                v5 = v4.toNanoOfDay();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toNanoOfDay:()J");
                var6_5 = v5 - this.time.toNanoOfDay();
                RuntimeCostAccounter.recordJump();
                if (var4_4 > 0L) {
                    --var4_4;
                    var6_5 += 86400000000000L;
                    RuntimeCostAccounter.recordJump();
                } else {
                    ++var4_4;
                    var6_5 -= 86400000000000L;
                }
                v6 = (ChronoUnit)var2_2;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
                switch (1.$SwitchMap$java$time$temporal$ChronoUnit[v6.ordinal()]) {
                    case 1: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 86400000000000L);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 86400000000L);
                        var6_5 /= 1000L;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 86400000L);
                        var6_5 /= 1000000L;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 86400L);
                        var6_5 /= 1000000000L;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 5: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 1440L);
                        var6_5 /= 60000000000L;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 6: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 24L);
                        var6_5 /= 3600000000000L;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 7: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                        var4_4 = Math.multiplyExact(var4_4, 2L);
                        var6_5 /= 43200000000000L;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                return Math.addExact(var4_4, var6_5);
            }
            var8_6 = var3_3.date;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isAfter:(Ljava/time/chrono/ChronoLocalDate;)Z");
            v7 = var8_6.isAfter(this.date);
            RuntimeCostAccounter.recordJump();
            if (!v7) ** GOTO lbl-1000
            v8 = var3_3.time;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.isBefore:(Ljava/time/LocalTime;)Z");
            v9 = v8.isBefore(this.time);
            RuntimeCostAccounter.recordJump();
            if (v9) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.minusDays:(J)Ljava/time/LocalDate;");
                var8_6 = var8_6.minusDays(1L);
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isBefore:(Ljava/time/chrono/ChronoLocalDate;)Z");
                v10 = var8_6.isBefore(this.date);
                RuntimeCostAccounter.recordJump();
                if (v10) {
                    v11 = var3_3.time;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.isAfter:(Ljava/time/LocalTime;)Z");
                    v12 = v11.isAfter(this.time);
                    RuntimeCostAccounter.recordJump();
                    if (v12) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
                        var8_6 = var8_6.plusDays(1L);
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
            return this.date.until(var8_6, var2_2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return var2_2.between(this, var3_3);
    }

    @Override
    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public OffsetDateTime atOffset(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.of(this, zoneOffset);
    }

    public ZonedDateTime atZone(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.of(this, zoneId);
    }

    @Override
    public int compareTo(ChronoLocalDateTime<?> chronoLocalDateTime) {
        boolean bl = chronoLocalDateTime instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocalDateTime localDateTime = (LocalDateTime)chronoLocalDateTime;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.compareTo0:(Ljava/time/LocalDateTime;)I");
            return this.compareTo0(localDateTime);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.compareTo:(Ljava/time/chrono/ChronoLocalDateTime;)I");
        return ChronoLocalDateTime.super.compareTo(chronoLocalDateTime);
    }

    private int compareTo0(LocalDateTime localDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalDate:()Ljava/time/LocalDate;");
        LocalDate localDate = localDateTime.toLocalDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo0:(Ljava/time/LocalDate;)I");
        int n = this.date.compareTo0(localDate);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = localDateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.compareTo:(Ljava/time/LocalTime;)I");
            n = this.time.compareTo(localTime);
        }
        return n;
    }

    @Override
    public boolean isAfter(ChronoLocalDateTime<?> chronoLocalDateTime) {
        boolean bl = chronoLocalDateTime instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDateTime localDateTime = (LocalDateTime)chronoLocalDateTime;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.compareTo0:(Ljava/time/LocalDateTime;)I");
            int n = this.compareTo0(localDateTime);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.isAfter:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
        return ChronoLocalDateTime.super.isAfter(chronoLocalDateTime);
    }

    @Override
    public boolean isBefore(ChronoLocalDateTime<?> chronoLocalDateTime) {
        boolean bl = chronoLocalDateTime instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDateTime localDateTime = (LocalDateTime)chronoLocalDateTime;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.compareTo0:(Ljava/time/LocalDateTime;)I");
            int n = this.compareTo0(localDateTime);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.isBefore:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
        return ChronoLocalDateTime.super.isBefore(chronoLocalDateTime);
    }

    @Override
    public boolean isEqual(ChronoLocalDateTime<?> chronoLocalDateTime) {
        boolean bl = chronoLocalDateTime instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDateTime localDateTime = (LocalDateTime)chronoLocalDateTime;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.compareTo0:(Ljava/time/LocalDateTime;)I");
            int n = this.compareTo0(localDateTime);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDateTime.isEqual:(Ljava/time/chrono/ChronoLocalDateTime;)Z");
        return ChronoLocalDateTime.super.isEqual(chronoLocalDateTime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        LocalDateTime localDateTime = (LocalDateTime)object;
        LocalDate localDate = localDateTime.date;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.date.equals(localDate);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        LocalTime localTime = localDateTime.time;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = this.time.equals(localTime);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.hashCode:()I");
        int n = this.date.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.hashCode:()I");
        return n ^ this.time.hashCode();
    }

    @Override
    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toString:()Ljava/lang/String;");
        String string = this.date.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append('T');
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.toString:()Ljava/lang/String;");
        String string2 = this.time.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder4.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(5, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.writeExternal:(Ljava/io/DataOutput;)V");
        this.date.writeExternal(dataOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.writeExternal:(Ljava/io/DataOutput;)V");
        this.time.writeExternal(dataOutput);
    }

    static LocalDateTime readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.readExternal:(Ljava/io/DataInput;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.readExternal(dataInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.readExternal:(Ljava/io/DataInput;)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.readExternal(dataInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return LocalDateTime.of(localDate, localTime);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        MIN = LocalDateTime.of(LocalDate.MIN, LocalTime.MIN);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        MAX = LocalDateTime.of(LocalDate.MAX, LocalTime.MAX);
    }
}

