/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.text;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.math.BigDecimal;
import sandbox.java.math.BigInteger;
import sandbox.java.math.RoundingMode;
import sandbox.sun.misc.FloatingDecimal;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public int decimalAt;
    public int count;
    public char[] digits;
    private char[] data;
    private RoundingMode roundingMode;
    private boolean isNegative;
    private static final char[] LONG_MIN_REP;
    private StringBuffer tempBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;

    DigitList() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.decimalAt = 0;
        this.count = 0;
        RuntimeCostAccounter.recordArrayAllocation((int)19, (int)2);
        this.digits = new char[19];
        this.roundingMode = RoundingMode.HALF_EVEN;
        this.isNegative = false;
    }

    boolean isZero() {
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.count) break;
            char c = this.digits[n];
            RuntimeCostAccounter.recordJump();
            if (c != '0') {
                return false;
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(char c) {
        int n = this.digits.length;
        RuntimeCostAccounter.recordJump();
        if (this.count == n) {
            int n2 = this.count + 100;
            RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
            char[] cArray = new char[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.digits, 0, cArray, 0, this.count);
            this.digits = cArray;
        }
        this.digits[this.count++] = c;
    }

    public final double getDouble() {
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            return 0.0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.getStringBuffer:()Ljava/lang/StringBuffer;");
        StringBuffer stringBuffer = this.getStringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
        stringBuffer.append('.');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:([CII)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.digits, 0, this.count);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
        stringBuffer.append('E');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(I)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.decimalAt);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        String string = stringBuffer.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.parseDouble:(Ljava/lang/String;)D");
        return Double.parseDouble(string);
    }

    public final long getLong() {
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            return 0L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.isLongMIN_VALUE:()Z");
        boolean bl = this.isLongMIN_VALUE();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return Long.MIN_VALUE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.getStringBuffer:()Ljava/lang/StringBuffer;");
        StringBuffer stringBuffer = this.getStringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:([CII)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.digits, 0, this.count);
        int n = this.count;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.decimalAt) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
            stringBuffer.append('0');
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        String string = stringBuffer.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.parseLong:(Ljava/lang/String;)J");
        return Long.parseLong(string);
    }

    public final BigDecimal getBigDecimal() {
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            RuntimeCostAccounter.recordJump();
            if (this.decimalAt == 0) {
                return BigDecimal.ZERO;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("0E");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.decimalAt);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:(Ljava/lang/String;)V");
            return new BigDecimal(string);
        }
        RuntimeCostAccounter.recordJump();
        if (this.decimalAt == this.count) {
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:([CII)V");
            return new BigDecimal(this.digits, 0, this.count);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:([CII)V");
        BigDecimal bigDecimal = new BigDecimal(this.digits, 0, this.count);
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.scaleByPowerOfTen:(I)Ljava/math/BigDecimal;");
        return bigDecimal.scaleByPowerOfTen(this.decimalAt - this.count);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean fitsIntoLong(boolean bl, boolean bl2) {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.count <= 0) break;
            char c = this.digits[this.count - 1];
            RuntimeCostAccounter.recordJump();
            if (c != '0') break;
            --this.count;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.count == 0) {
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordJump();
                if (!bl2) return false;
            }
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }
        RuntimeCostAccounter.recordJump();
        if (this.decimalAt < this.count) return false;
        RuntimeCostAccounter.recordJump();
        if (this.decimalAt > 19) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        if (this.decimalAt < 19) {
            return true;
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.count) break;
            char c = this.digits[n];
            char c2 = LONG_MIN_REP[n];
            RuntimeCostAccounter.recordJump();
            if (c > c2) {
                return false;
            }
            RuntimeCostAccounter.recordJump();
            if (c < c2) {
                return true;
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.count < this.decimalAt) {
            return true;
        }
        RuntimeCostAccounter.recordJump();
        if (bl) return false;
        boolean bl4 = true;
        RuntimeCostAccounter.recordJump();
        return bl4;
    }

    final void set(boolean bl, double d, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.set:(ZDIZ)V");
        this.set(bl, d, n, true);
    }

    final void set(boolean bl, double d, int n, boolean bl2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/FloatingDecimal.getBinaryToASCIIConverter:(D)Lsun/misc/FloatingDecimal$BinaryToASCIIConverter;");
        FloatingDecimal.BinaryToASCIIConverter binaryToASCIIConverter = FloatingDecimal.getBinaryToASCIIConverter((double)d);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/FloatingDecimal$BinaryToASCIIConverter.digitsRoundedUp:()Z");
        boolean bl3 = binaryToASCIIConverter.digitsRoundedUp();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/FloatingDecimal$BinaryToASCIIConverter.decimalDigitsExact:()Z");
        boolean bl4 = binaryToASCIIConverter.decimalDigitsExact();
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/FloatingDecimal$BinaryToASCIIConverter.isExceptional:()Z");
            boolean bl5 = binaryToASCIIConverter.isExceptional();
            RuntimeCostAccounter.recordJump();
            if (bl5) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/FloatingDecimal$BinaryToASCIIConverter.toJavaFormatString:()Ljava/lang/String;");
        String string = binaryToASCIIConverter.toJavaFormatString();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.set:(ZLjava/lang/String;ZZIZ)V");
        this.set(bl, string, bl3, bl4, n, bl2);
    }

    private void set(boolean bl, String string, boolean bl2, boolean bl3, int n, boolean bl4) {
        int n2;
        this.isNegative = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n3 = string.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.getDataChars:(I)[C");
        char[] cArray = this.getDataChars(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
        string.getChars(0, n3, cArray, 0);
        this.decimalAt = -1;
        this.count = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl5 = false;
        int n6 = 0;
        while (true) {
            block21: {
                char c;
                block23: {
                    block22: {
                        block20: {
                            RuntimeCostAccounter.recordJump();
                            if (n6 >= n3) break;
                            c = cArray[n6++];
                            RuntimeCostAccounter.recordJump();
                            if (c != '.') break block20;
                            this.decimalAt = this.count;
                            RuntimeCostAccounter.recordJump();
                            break block21;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (c == 'e') break block22;
                        RuntimeCostAccounter.recordJump();
                        if (c != 'E') break block23;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.parseInt:([CII)I");
                    n4 = DigitList.parseInt(cArray, n6, n3);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (!bl5) {
                    boolean bl6;
                    RuntimeCostAccounter.recordJump();
                    if (c != '0') {
                        bl6 = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl6 = false;
                    }
                    bl5 = bl6;
                    RuntimeCostAccounter.recordJump();
                    if (!bl5) {
                        RuntimeCostAccounter.recordJump();
                        if (this.decimalAt != -1) {
                            ++n5;
                        }
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (bl5) {
                    this.digits[this.count++] = c;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            this.decimalAt += n4 - n5;
        }
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            int n7 = -this.decimalAt;
            RuntimeCostAccounter.recordJump();
            if (n7 > n) {
                this.count = 0;
                return;
            }
            int n8 = -this.decimalAt;
            RuntimeCostAccounter.recordJump();
            if (n8 == n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.shouldRoundUp:(IZZ)Z");
                boolean bl7 = this.shouldRoundUp(0, bl2, bl3);
                RuntimeCostAccounter.recordJump();
                if (bl7) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                    RuntimeCostAccounter.recordJump();
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (this.count <= 1) break;
            char c = this.digits[this.count - 1];
            RuntimeCostAccounter.recordJump();
            if (c != '0') break;
            --this.count;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            n2 = n + this.decimalAt;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.round:(IZZ)V");
        this.round(n2, bl2, bl3);
    }

    private final void round(int n, boolean bl, boolean bl2) {
        RuntimeCostAccounter.recordJump();
        if (n >= 0) {
            RuntimeCostAccounter.recordJump();
            if (n < this.count) {
                RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.shouldRoundUp:(IZZ)Z");
                boolean bl3 = this.shouldRoundUp(n, bl, bl2);
                RuntimeCostAccounter.recordJump();
                if (bl3) {
                    block6: {
                        char c;
                        do {
                            RuntimeCostAccounter.recordJump();
                            if (--n < 0) {
                                this.digits[0] = 49;
                                ++this.decimalAt;
                                n = 0;
                                RuntimeCostAccounter.recordJump();
                                break block6;
                            }
                            int n2 = n;
                            this.digits[n2] = (char)(this.digits[n2] + '\u0001');
                            c = this.digits[n];
                            RuntimeCostAccounter.recordJump();
                        } while (c > '9');
                        RuntimeCostAccounter.recordJump();
                    }
                    ++n;
                }
                this.count = n;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (this.count <= 1) break;
                    char c = this.digits[this.count - 1];
                    RuntimeCostAccounter.recordJump();
                    if (c != '0') break;
                    --this.count;
                    RuntimeCostAccounter.recordJump();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldRoundUp(int n, boolean bl, boolean bl2) {
        RuntimeCostAccounter.recordJump();
        if (n >= this.count) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/RoundingMode.ordinal:()I");
        switch (1.$SwitchMap$java$math$RoundingMode[this.roundingMode.ordinal()]) {
            case 1: {
                int n2 = n;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= this.count) break;
                    char c = this.digits[n2];
                    RuntimeCostAccounter.recordJump();
                    if (c != '0') {
                        return true;
                    }
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                return false;
            }
            case 2: {
                RuntimeCostAccounter.recordJump();
                return false;
            }
            case 3: {
                int n3 = n;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= this.count) break;
                    char c = this.digits[n3];
                    RuntimeCostAccounter.recordJump();
                    if (c != '0') {
                        RuntimeCostAccounter.recordJump();
                        if (this.isNegative) return false;
                        boolean bl3 = true;
                        RuntimeCostAccounter.recordJump();
                        return bl3;
                    }
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                return false;
            }
            case 4: {
                int n4 = n;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= this.count) break;
                    char c = this.digits[n4];
                    RuntimeCostAccounter.recordJump();
                    if (c != '0') {
                        return this.isNegative;
                    }
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                return false;
            }
            case 5: {
                char c = this.digits[n];
                RuntimeCostAccounter.recordJump();
                if (c < '5') return false;
                RuntimeCostAccounter.recordJump();
                if (n != this.count - 1) return true;
                RuntimeCostAccounter.recordJump();
                if (!bl) return true;
                return false;
            }
            case 6: {
                char c = this.digits[n];
                RuntimeCostAccounter.recordJump();
                if (c > '5') {
                    return true;
                }
                char c2 = this.digits[n];
                RuntimeCostAccounter.recordJump();
                if (c2 != '5') return false;
                RuntimeCostAccounter.recordJump();
                if (n == this.count - 1) {
                    RuntimeCostAccounter.recordJump();
                    if (bl2) return false;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) return true;
                    return false;
                }
                int n5 = n + 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n5 >= this.count) break;
                    char c3 = this.digits[n5];
                    RuntimeCostAccounter.recordJump();
                    if (c3 != '0') {
                        return true;
                    }
                    ++n5;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                return false;
            }
            case 7: {
                char c = this.digits[n];
                RuntimeCostAccounter.recordJump();
                if (c > '5') {
                    return true;
                }
                char c4 = this.digits[n];
                RuntimeCostAccounter.recordJump();
                if (c4 != '5') return false;
                RuntimeCostAccounter.recordJump();
                if (n == this.count - 1) {
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        return false;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) {
                        return true;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n <= 0) return false;
                    int n6 = this.digits[n - 1] % 2;
                    RuntimeCostAccounter.recordJump();
                    if (n6 == 0) return false;
                    boolean bl4 = true;
                    RuntimeCostAccounter.recordJump();
                    return bl4;
                }
                int n7 = n + 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n7 >= this.count) break;
                    char c5 = this.digits[n7];
                    RuntimeCostAccounter.recordJump();
                    if (c5 != '0') {
                        return true;
                    }
                    ++n7;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                return false;
            }
            case 8: {
                int n8 = n;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n8 >= this.count) break;
                    char c = this.digits[n8];
                    RuntimeCostAccounter.recordJump();
                    if (c != '0') {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/ArithmeticException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ArithmeticException.<init>:(Ljava/lang/String;)V");
                        ArithmeticException arithmeticException = new ArithmeticException("Rounding needed with the rounding mode being set to RoundingMode.UNNECESSARY");
                        RuntimeCostAccounter.recordThrow();
                        throw arithmeticException;
                    }
                    ++n8;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                return false;
            }
            default: {
                RuntimeCostAccounter.recordJump();
                if ($assertionsDisabled) return false;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
    }

    final void set(boolean bl, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.set:(ZJI)V");
        this.set(bl, l, 0);
    }

    final void set(boolean bl, long l, int n) {
        this.isNegative = bl;
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            RuntimeCostAccounter.recordJump();
            if (l == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
                RuntimeCostAccounter.recordJump();
            } else {
                this.count = 0;
                this.decimalAt = 0;
                RuntimeCostAccounter.recordJump();
            }
        } else {
            int n2 = 19;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (l <= 0L) break;
                this.digits[--n2] = (char)(48L + l % 10L);
                l /= 10L;
                RuntimeCostAccounter.recordJump();
            }
            this.decimalAt = 19 - n2;
            int n3 = 18;
            while (true) {
                char c = this.digits[n3];
                RuntimeCostAccounter.recordJump();
                if (c != '0') break;
                --n3;
                RuntimeCostAccounter.recordJump();
            }
            this.count = n3 - n2 + 1;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.digits, n2, this.digits, 0, this.count);
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.round:(IZZ)V");
            this.round(n, false, true);
        }
    }

    final void set(boolean bl, BigDecimal bigDecimal, int n, boolean bl2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.toString:()Ljava/lang/String;");
        String string = bigDecimal.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.extendDigits:(I)V");
        this.extendDigits(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.set:(ZLjava/lang/String;ZZIZ)V");
        this.set(bl, string, false, true, n, bl2);
    }

    final void set(boolean bl, BigInteger bigInteger, int n) {
        this.isNegative = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.toString:()Ljava/lang/String;");
        String string = bigInteger.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.extendDigits:(I)V");
        this.extendDigits(n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
        string.getChars(0, n2, this.digits, 0);
        this.decimalAt = n2;
        int n3 = n2 - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 < 0) break;
            char c = this.digits[n3];
            RuntimeCostAccounter.recordJump();
            if (c != '0') break;
            --n3;
            RuntimeCostAccounter.recordJump();
        }
        this.count = n3 + 1;
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.round:(IZZ)V");
            this.round(n, false, true);
        }
    }

    public boolean equals(Object object) {
        DigitList digitList;
        block8: {
            block7: {
                RuntimeCostAccounter.recordJump();
                if (this == object) {
                    return true;
                }
                boolean bl = object instanceof DigitList;
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return false;
                }
                digitList = (DigitList)object;
                int n = digitList.count;
                RuntimeCostAccounter.recordJump();
                if (this.count != n) break block7;
                int n2 = digitList.decimalAt;
                RuntimeCostAccounter.recordJump();
                if (this.decimalAt == n2) break block8;
            }
            return false;
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.count) break;
            char c = this.digits[n];
            char c2 = digitList.digits[n];
            RuntimeCostAccounter.recordJump();
            if (c != c2) {
                return false;
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    public int hashCode() {
        int n = this.decimalAt;
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.count) break;
            n = n * 37 + this.digits[n2];
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        return n;
    }

    public Object clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            DigitList digitList = (DigitList)super.clone();
            int n = this.digits.length;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)2);
            char[] cArray = new char[n];
            int n2 = this.digits.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.digits, 0, cArray, 0, n2);
            digitList.digits = cArray;
            digitList.tempBuffer = null;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    private boolean isLongMIN_VALUE() {
        block6: {
            block5: {
                RuntimeCostAccounter.recordJump();
                if (this.decimalAt != this.count) break block5;
                RuntimeCostAccounter.recordJump();
                if (this.count == 19) break block6;
            }
            return false;
        }
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.count) break;
            char c = this.digits[n];
            char c2 = LONG_MIN_REP[n];
            RuntimeCostAccounter.recordJump();
            if (c != c2) {
                return false;
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return true;
    }

    private static final int parseInt(char[] cArray, int n, int n2) {
        int n3;
        boolean bl = true;
        char c = cArray[n];
        RuntimeCostAccounter.recordJump();
        if (c == '-') {
            bl = false;
            ++n;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (c == '+') {
                ++n;
            }
        }
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            c = cArray[n++];
            RuntimeCostAccounter.recordJump();
            if (c < '0') break;
            RuntimeCostAccounter.recordJump();
            if (c > '9') break;
            n4 = n4 * 10 + (c - 48);
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n3 = n4;
            RuntimeCostAccounter.recordJump();
        } else {
            n3 = -n4;
        }
        return n3;
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.isZero:()Z");
        boolean bl = this.isZero();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return "0";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/DigitList.getStringBuffer:()Ljava/lang/StringBuffer;");
        StringBuffer stringBuffer = this.getStringBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        stringBuffer.append("0.");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:([CII)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.digits, 0, this.count);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        stringBuffer.append("x10^");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(I)Ljava/lang/StringBuffer;");
        stringBuffer.append(this.decimalAt);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return stringBuffer.toString();
    }

    private StringBuffer getStringBuffer() {
        RuntimeCostAccounter.recordJump();
        if (this.tempBuffer == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:(I)V");
            this.tempBuffer = new StringBuffer(19);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.setLength:(I)V");
            this.tempBuffer.setLength(0);
        }
        return this.tempBuffer;
    }

    private void extendDigits(int n) {
        int n2 = this.digits.length;
        RuntimeCostAccounter.recordJump();
        if (n > n2) {
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)2);
            this.digits = new char[n3];
        }
    }

    private final char[] getDataChars(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (this.data == null) break block2;
                int n2 = this.data.length;
                RuntimeCostAccounter.recordJump();
                if (n2 >= n) break block3;
            }
            int n3 = n;
            RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)2);
            this.data = new char[n3];
        }
        return this.data;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = DigitList.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toCharArray:()[C");
        LONG_MIN_REP = "9223372036854775808".toCharArray();
    }
}

