/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.text;

import java.lang.ref.SoftReference;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.text.CollationKey;
import sandbox.java.text.spi.CollatorProvider;
import sandbox.java.util.Comparator;
import sandbox.java.util.Locale;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleServiceProviderPool;

public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength;
    private int decmp;
    private static final ConcurrentMap<Locale, SoftReference<Collator>> cache;
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;

    public static synchronized Collator getInstance() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
        Locale locale = Locale.getDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Collator.getInstance:(Ljava/util/Locale;)Ljava/text/Collator;");
        return Collator.getInstance(locale);
    }

    public static Collator getInstance(Locale locale) {
        Collator collator;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        SoftReference<Collator> softReference = (SoftReference<Collator>)cache.get(locale);
        RuntimeCostAccounter.recordJump();
        if (softReference != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.get:()Ljava/lang/Object;");
            collator = (Collator)softReference.get();
            RuntimeCostAccounter.recordJump();
        } else {
            collator = null;
        }
        Collator collator2 = collator;
        RuntimeCostAccounter.recordJump();
        if (collator2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getAdapter:(Ljava/lang/Class;Ljava/util/Locale;)Lsun/util/locale/provider/LocaleProviderAdapter;");
            LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(CollatorProvider.class, (Locale)locale);
            RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getCollatorProvider:()Ljava/text/spi/CollatorProvider;");
            CollatorProvider collatorProvider = localeProviderAdapter.getCollatorProvider();
            RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/CollatorProvider.getInstance:(Ljava/util/Locale;)Ljava/text/Collator;");
            collator2 = collatorProvider.getInstance(locale);
            RuntimeCostAccounter.recordJump();
            if (collator2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.forJRE:()Lsun/util/locale/provider/LocaleProviderAdapter;");
                LocaleProviderAdapter localeProviderAdapter2 = LocaleProviderAdapter.forJRE();
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getCollatorProvider:()Ljava/text/spi/CollatorProvider;");
                CollatorProvider collatorProvider2 = localeProviderAdapter2.getCollatorProvider();
                RuntimeCostAccounter.recordMethodCall((String)"java/text/spi/CollatorProvider.getInstance:(Ljava/util/Locale;)Ljava/text/Collator;");
                collator2 = collatorProvider2.getInstance(locale);
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (softReference != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                    cache.remove(locale, softReference);
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/SoftReference");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.<init>:(Ljava/lang/Object;)V");
                SoftReference<Collator> softReference2 = new SoftReference<Collator>(collator2);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                softReference = cache.putIfAbsent(locale, softReference2);
                RuntimeCostAccounter.recordJump();
                if (softReference == null) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.get:()Ljava/lang/Object;");
                Collator collator3 = softReference.get();
                RuntimeCostAccounter.recordJump();
                if (collator3 != null) {
                    collator2 = collator3;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Collator.clone:()Ljava/lang/Object;");
        return (Collator)collator2.clone();
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object object, Object object2) {
        String string = (String)object;
        String string2 = (String)object2;
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Collator.compare:(Ljava/lang/String;Ljava/lang/String;)I");
        return this.compare(string, string2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String string, String string2) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/text/Collator.compare:(Ljava/lang/String;Ljava/lang/String;)I");
        int n = this.compare(string, string2);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public synchronized void setStrength(int n) {
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            RuntimeCostAccounter.recordJump();
            if (n != 1) {
                RuntimeCostAccounter.recordJump();
                if (n != 2) {
                    RuntimeCostAccounter.recordJump();
                    if (n != 3) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Incorrect comparison level.");
                        RuntimeCostAccounter.recordThrow();
                        throw illegalArgumentException;
                    }
                }
            }
        }
        this.strength = n;
    }

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public synchronized void setDecomposition(int n) {
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            RuntimeCostAccounter.recordJump();
            if (n != 1) {
                RuntimeCostAccounter.recordJump();
                if (n != 2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Wrong decomposition mode.");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
            }
        }
        this.decmp = n;
    }

    public static synchronized Locale[] getAvailableLocales() {
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getPool:(Ljava/lang/Class;)Lsun/util/locale/provider/LocaleServiceProviderPool;");
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleServiceProviderPool.getAvailableLocales:()[Ljava/util/Locale;");
        return localeServiceProviderPool.getAvailableLocales();
    }

    public Object clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            return (Collator)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:(Ljava/lang/Throwable;)V");
            InternalError internalError = new InternalError(cloneNotSupportedException);
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz2 = object.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != clazz2) {
            return false;
        }
        Collator collator = (Collator)object;
        int n = collator.strength;
        RuntimeCostAccounter.recordJump();
        if (this.strength != n) return false;
        int n2 = collator.decmp;
        RuntimeCostAccounter.recordJump();
        if (this.decmp != n2) return false;
        boolean bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public abstract int hashCode();

    protected Collator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.strength = 0;
        this.decmp = 0;
        this.strength = 2;
        this.decmp = 1;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
        cache = new ConcurrentHashMap<Locale, SoftReference<Collator>>();
    }
}

