/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.math;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.math.RoundingMode;

public final class MathContext
implements Serializable {
    private static final int DEFAULT_DIGITS = 9;
    private static final RoundingMode DEFAULT_ROUNDINGMODE = RoundingMode.HALF_UP;
    private static final int MIN_DIGITS = 0;
    private static final long serialVersionUID = 5579720004786848255L;
    public static final MathContext UNLIMITED;
    public static final MathContext DECIMAL32;
    public static final MathContext DECIMAL64;
    public static final MathContext DECIMAL128;
    final int precision;
    final RoundingMode roundingMode;

    public MathContext(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MathContext.<init>:(ILjava/math/RoundingMode;)V");
        this(n, DEFAULT_ROUNDINGMODE);
    }

    public MathContext(int n, RoundingMode roundingMode) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Digits < 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (roundingMode == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("null RoundingMode");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        this.precision = n;
        this.roundingMode = roundingMode;
    }

    public MathContext(String string) {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        boolean bl = false;
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException("null String");
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string.startsWith("precision=");
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:()V");
                RuntimeException runtimeException = new RuntimeException();
                RuntimeCostAccounter.recordThrow();
                throw runtimeException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
            int n2 = string.indexOf(32);
            int n3 = 10;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string2 = string.substring(10, n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.parseInt:(Ljava/lang/String;)I");
            n = Integer.parseInt(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;I)Z");
            boolean bl3 = string.startsWith("roundingMode=", n2 + 1);
            RuntimeCostAccounter.recordJump();
            if (!bl3) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:()V");
                RuntimeException runtimeException = new RuntimeException();
                RuntimeCostAccounter.recordThrow();
                throw runtimeException;
            }
            n3 = n2 + 1 + 13;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n4 = string.length();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            String string3 = string.substring(n3, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/RoundingMode.valueOf:(Ljava/lang/String;)Ljava/math/RoundingMode;");
            this.roundingMode = RoundingMode.valueOf(string3);
        }
        catch (RuntimeException runtimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("bad string format");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Digits < 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.precision = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = object instanceof MathContext;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        MathContext mathContext = (MathContext)object;
        int n = mathContext.precision;
        RuntimeCostAccounter.recordJump();
        if (n != this.precision) return false;
        RoundingMode roundingMode = mathContext.roundingMode;
        RuntimeCostAccounter.recordJump();
        if (roundingMode != this.roundingMode) return false;
        boolean bl2 = true;
        RuntimeCostAccounter.recordJump();
        return bl2;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/math/RoundingMode.hashCode:()I");
        return this.precision + this.roundingMode.hashCode() * 59;
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("precision=");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(this.precision);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append(" ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("roundingMode=");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/RoundingMode.toString:()Ljava/lang/String;");
        String string = this.roundingMode.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder6.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordJump();
        if (this.precision < 0) {
            String string = "MathContext: invalid digits in stream";
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordJump();
        if (this.roundingMode == null) {
            String string = "MathContext: null roundingMode in stream";
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(string);
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/math/MathContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MathContext.<init>:(ILjava/math/RoundingMode;)V");
        UNLIMITED = new MathContext(0, RoundingMode.HALF_UP);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MathContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MathContext.<init>:(ILjava/math/RoundingMode;)V");
        DECIMAL32 = new MathContext(7, RoundingMode.HALF_EVEN);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MathContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MathContext.<init>:(ILjava/math/RoundingMode;)V");
        DECIMAL64 = new MathContext(16, RoundingMode.HALF_EVEN);
        RuntimeCostAccounter.recordAllocation((String)"java/math/MathContext");
        RuntimeCostAccounter.recordMethodCall((String)"java/math/MathContext.<init>:(ILjava/math/RoundingMode;)V");
        DECIMAL128 = new MathContext(34, RoundingMode.HALF_EVEN);
    }
}

