/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.ExpiringCache;
import sandbox.java.io.File;
import sandbox.java.io.FileSystem;
import sandbox.java.io.IOException;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash;
    private final char colon;
    private final String javaHome;
    private ExpiringCache cache;
    private ExpiringCache javaHomePrefixCache;

    public UnixFileSystem() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/io/ExpiringCache");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.<init>:()V");
        this.cache = new ExpiringCache();
        RuntimeCostAccounter.recordAllocation((String)"java/io/ExpiringCache");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.<init>:()V");
        this.javaHomePrefixCache = new ExpiringCache();
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("file.separator");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        this.slash = string.charAt(0);
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction2 = new GetPropertyAction("path.separator");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string2 = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        this.colon = string2.charAt(0);
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction3 = new GetPropertyAction("java.home");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        this.javaHome = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction3);
    }

    @Override
    public char getSeparator() {
        return this.slash;
    }

    @Override
    public char getPathSeparator() {
        return this.colon;
    }

    /*
     * Unable to fully structure code
     */
    private String normalize(String var1_1, int var2_2, int var3_3) {
        RuntimeCostAccounter.recordJump();
        if (var2_2 == 0) {
            return var1_1;
        }
        var4_4 = var2_2;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (var4_4 <= 0) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            v0 = var1_1.charAt(var4_4 - 1);
            RuntimeCostAccounter.recordJump();
            if (v0 != '/') break;
            --var4_4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (var4_4 == 0) {
            return "/";
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        v1 = var1_1.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:(I)V");
        var5_5 = new StringBuffer(v1);
        RuntimeCostAccounter.recordJump();
        if (var3_3 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            v2 = var1_1.substring(0, var3_3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            var5_5.append(v2);
        }
        var6_6 = 0;
        var7_7 = var3_3;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (var7_7 >= var4_4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            var8_8 = var1_1.charAt(var7_7);
            RuntimeCostAccounter.recordJump();
            if (var6_6 != 47) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var8_8 == '/') {
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:(C)Ljava/lang/StringBuffer;");
                var5_5.append(var8_8);
                var6_6 = var8_8;
            }
            ++var7_7;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
        return var5_5.toString();
    }

    @Override
    public String normalize(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
            char c = string.charAt(n3);
            RuntimeCostAccounter.recordJump();
            if (n2 == 47) {
                RuntimeCostAccounter.recordJump();
                if (c == '/') {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.normalize:(Ljava/lang/String;II)Ljava/lang/String;");
                    return this.normalize(string, n, n3 - 1);
                }
            }
            n2 = c;
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 47) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.normalize:(Ljava/lang/String;II)Ljava/lang/String;");
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    @Override
    public int prefixLength(String string) {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        char c = string.charAt(0);
        RuntimeCostAccounter.recordJump();
        if (c == '/') {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public String resolve(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = string2.equals("");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return string;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        char c = string2.charAt(0);
        RuntimeCostAccounter.recordJump();
        if (c == '/') {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = string.equals("/");
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                return string2;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder3.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = string.equals("/");
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder5.toString();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append('/');
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder8.toString();
    }

    @Override
    public String getDefaultParent() {
        return "/";
    }

    @Override
    public String fromURIPath(String string) {
        String string2 = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
        boolean bl = string2.endsWith("/");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string2.length();
            RuntimeCostAccounter.recordJump();
            if (n > 1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = string2.length() - 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                string2 = string2.substring(0, n2);
            }
        }
        return string2;
    }

    @Override
    public boolean isAbsolute(File file) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPrefixLength:()I");
        int n = file.getPrefixLength();
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public String resolve(File file) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.isAbsolute:(Ljava/io/File;)Z");
        boolean bl = this.isAbsolute(file);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
            return file.getPath();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string = System.getProperty("user.dir");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        String string2 = file.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.resolve:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        return this.resolve(string, string2);
    }

    @Override
    public String canonicalize(String string) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!useCanonCaches) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.canonicalize0:(Ljava/lang/String;)Ljava/lang/String;");
            return this.canonicalize0(string);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.get:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = this.cache.get(string);
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            RuntimeCostAccounter.recordJump();
            if (useCanonPrefixCache) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.parentOrNull:(Ljava/lang/String;)Ljava/lang/String;");
                string3 = UnixFileSystem.parentOrNull(string);
                RuntimeCostAccounter.recordJump();
                if (string3 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.get:(Ljava/lang/String;)Ljava/lang/String;");
                    string4 = this.javaHomePrefixCache.get(string3);
                    RuntimeCostAccounter.recordJump();
                    if (string4 != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                        int n = 1 + string3.length();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                        object = string.substring(n);
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append(string4);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(this.slash);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder3.append((String)object);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        string2 = stringBuilder4.toString();
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder5 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder5.append(string3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder7 = stringBuilder6.append(this.slash);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder8 = stringBuilder7.append((String)object);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string5 = stringBuilder8.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.put:(Ljava/lang/String;Ljava/lang/String;)V");
                        this.cache.put(string5, string2);
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.canonicalize0:(Ljava/lang/String;)Ljava/lang/String;");
                string2 = this.canonicalize0(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.put:(Ljava/lang/String;Ljava/lang/String;)V");
                this.cache.put(string, string2);
                RuntimeCostAccounter.recordJump();
                if (useCanonPrefixCache) {
                    RuntimeCostAccounter.recordJump();
                    if (string3 != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
                        boolean bl = string3.startsWith(this.javaHome);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.parentOrNull:(Ljava/lang/String;)Ljava/lang/String;");
                            string4 = UnixFileSystem.parentOrNull(string2);
                            RuntimeCostAccounter.recordJump();
                            if (string4 != null) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                                boolean bl2 = string4.equals(string3);
                                RuntimeCostAccounter.recordJump();
                                if (bl2) {
                                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                                    object = new File(string2);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
                                    boolean bl3 = ((File)object).exists();
                                    RuntimeCostAccounter.recordJump();
                                    if (bl3) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isDirectory:()Z");
                                        boolean bl4 = ((File)object).isDirectory();
                                        RuntimeCostAccounter.recordJump();
                                        if (!bl4) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.put:(Ljava/lang/String;Ljava/lang/String;)V");
                                            this.javaHomePrefixCache.put(string3, string4);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string2;
    }

    private native String canonicalize0(String var1) throws IOException;

    static String parentOrNull(String string) {
        int n;
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            return null;
        }
        char c = File.separatorChar;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = n = string.length() - 1;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            block10: {
                block11: {
                    block13: {
                        block12: {
                            char c2;
                            block9: {
                                RuntimeCostAccounter.recordJump();
                                if (n2 <= 0) break;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                c2 = string.charAt(n2);
                                RuntimeCostAccounter.recordJump();
                                if (c2 != '.') break block9;
                                RuntimeCostAccounter.recordJump();
                                if (++n3 >= 2) {
                                    return null;
                                }
                                break block10;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (c2 != c) break block11;
                            RuntimeCostAccounter.recordJump();
                            if (n3 == 1) {
                                RuntimeCostAccounter.recordJump();
                                if (n4 == 0) {
                                    return null;
                                }
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n2 == 0) break block12;
                            RuntimeCostAccounter.recordJump();
                            if (n2 >= n - 1) break block12;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                            char c3 = string.charAt(n2 - 1);
                            RuntimeCostAccounter.recordJump();
                            if (c3 != c) break block13;
                        }
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                    return string.substring(0, n2);
                }
                ++n4;
                n3 = 0;
            }
            --n2;
            RuntimeCostAccounter.recordJump();
        }
        return null;
    }

    public native int getBooleanAttributes0(File var1);

    /*
     * Unable to fully structure code
     */
    @Override
    public int getBooleanAttributes(File var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.getBooleanAttributes0:(Ljava/io/File;)I");
        var2_2 = this.getBooleanAttributes0(var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getName:()Ljava/lang/String;");
        var3_3 = var1_1.getName();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        v0 = var3_3.length();
        RuntimeCostAccounter.recordJump();
        if (v0 <= 0) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
        v1 = var3_3.charAt(0);
        RuntimeCostAccounter.recordJump();
        if (v1 == '.') {
            v2 = true;
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        var4_4 = v2;
        RuntimeCostAccounter.recordJump();
        if (var4_4) {
            v3 = 8;
            RuntimeCostAccounter.recordJump();
        } else {
            v3 = 0;
        }
        return var2_2 | v3;
    }

    @Override
    public native boolean checkAccess(File var1, int var2);

    @Override
    public native long getLastModifiedTime(File var1);

    @Override
    public native long getLength(File var1);

    @Override
    public native boolean setPermission(File var1, int var2, boolean var3, boolean var4);

    @Override
    public native boolean createFileExclusively(String var1) throws IOException;

    @Override
    public boolean delete(File file) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.clear:()V");
        this.cache.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.clear:()V");
        this.javaHomePrefixCache.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.delete0:(Ljava/io/File;)Z");
        return this.delete0(file);
    }

    private native boolean delete0(File var1);

    @Override
    public native String[] list(File var1);

    @Override
    public native boolean createDirectory(File var1);

    @Override
    public boolean rename(File file, File file2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.clear:()V");
        this.cache.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ExpiringCache.clear:()V");
        this.javaHomePrefixCache.clear();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.rename0:(Ljava/io/File;Ljava/io/File;)Z");
        return this.rename0(file, file2);
    }

    private native boolean rename0(File var1, File var2);

    @Override
    public native boolean setLastModifiedTime(File var1, long var2);

    @Override
    public native boolean setReadOnly(File var1);

    @Override
    public File[] listRoots() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
            SecurityManager securityManager = System.getSecurityManager();
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
                securityManager.checkRead("/");
            }
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            File[] fileArray = new File[1];
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
            fileArray[0] = new File("/");
            return fileArray;
        }
        catch (SecurityException securityException) {
            RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
            return new File[0];
        }
    }

    @Override
    public native long getSpace(File var1, int var2);

    @Override
    public int compare(File file, File file2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        String string = file.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        String string2 = file2.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.compareTo:(Ljava/lang/String;)I");
        return string.compareTo(string2);
    }

    @Override
    public int hashCode(File file) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        String string = file.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.hashCode:()I");
        return string.hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/UnixFileSystem.initIDs:()V");
        UnixFileSystem.initIDs();
    }
}

