/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedWriter;
import sandbox.java.io.File;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.FileOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InterruptedIOException;
import sandbox.java.io.OutputStream;
import sandbox.java.io.OutputStreamWriter;
import sandbox.java.io.PrintStream;
import sandbox.java.io.UnsupportedEncodingException;
import sandbox.java.io.Writer;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.IllegalCharsetNameException;
import sandbox.java.nio.charset.UnsupportedCharsetException;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.util.Formatter;
import sandbox.java.util.Locale;
import sandbox.java.util.Objects;
import sandbox.sun.security.action.GetPropertyAction;

public class PrintWriter
extends Writer {
    protected Writer out;
    private final boolean autoFlush;
    private boolean trouble;
    private Formatter formatter;
    private PrintStream psOut;
    private final String lineSeparator;

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "charsetName");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.forName:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
            return Charset.forName((String)string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException throwable) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/UnsupportedEncodingException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/UnsupportedEncodingException.<init>:(Ljava/lang/String;)V");
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedEncodingException;
        }
    }

    public PrintWriter(Writer writer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/io/Writer;Z)V");
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.<init>:(Ljava/lang/Object;)V");
        super(writer);
        this.trouble = false;
        this.psOut = null;
        this.out = writer;
        this.autoFlush = bl;
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("line.separator");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        this.lineSeparator = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
    }

    public PrintWriter(OutputStream outputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/io/OutputStream;Z)V");
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;)V");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;)V");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/io/Writer;Z)V");
        this(bufferedWriter, bl);
        boolean bl2 = outputStream instanceof PrintStream;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            this.psOut = (PrintStream)outputStream;
        }
    }

    public PrintWriter(String string) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/lang/String;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;)V");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;)V");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/io/Writer;Z)V");
        this(bufferedWriter, false);
    }

    private PrintWriter(Charset charset, File file) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;Ljava/nio/charset/Charset;)V");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;)V");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/io/Writer;Z)V");
        this(bufferedWriter, false);
    }

    public PrintWriter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = PrintWriter.toCharset(string2);
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
        File file = new File(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/nio/charset/Charset;Ljava/io/File;)V");
        this(charset, file);
    }

    public PrintWriter(File file) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;)V");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;)V");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/io/Writer;Z)V");
        this(bufferedWriter, false);
    }

    public PrintWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = PrintWriter.toCharset(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.<init>:(Ljava/nio/charset/Charset;Ljava/io/File;)V");
        this(charset, file);
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.out == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            Object object = this.lock;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
                this.out.flush();
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.lock;
            try {
                RuntimeCostAccounter.recordJump();
                if (this.out == null) {
                    return;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.close:()V");
                this.out.close();
                this.out = null;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    public boolean checkError() {
        RuntimeCostAccounter.recordJump();
        if (this.out != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.flush:()V");
            this.flush();
        }
        boolean bl = this.out instanceof PrintWriter;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            PrintWriter printWriter = (PrintWriter)this.out;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.checkError:()Z");
            return printWriter.checkError();
        }
        RuntimeCostAccounter.recordJump();
        if (this.psOut != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.checkError:()Z");
            return this.psOut.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        try {
            Object object = this.lock;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(I)V");
                this.out.write(n);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            Object object = this.lock;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:([CII)V");
                this.out.write(cArray, n, n2);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public void write(char[] cArray) {
        int n = cArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:([CII)V");
        this.write(cArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) {
        try {
            Object object = this.lock;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(Ljava/lang/String;II)V");
                this.out.write(string, n, n2);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public void write(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;II)V");
        this.write(string, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            block5: {
                Object object = this.lock;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:(Ljava/lang/String;)V");
                    this.out.write(this.lineSeparator);
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void print(boolean bl) {
        String string;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = "true";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "false";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(char c) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(I)V");
        this.write(c);
    }

    public void print(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(I)Ljava/lang/String;");
        String string = String.valueOf(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(J)Ljava/lang/String;");
        String string = String.valueOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(float f) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(F)Ljava/lang/String;");
        String string = String.valueOf(f);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(double d) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(D)Ljava/lang/String;");
        String string = String.valueOf(d);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(char[] cArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:([C)V");
        this.write(cArray);
    }

    public void print(String string) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            string = "null";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(Ljava/lang/Object;)Ljava/lang/String;");
        String string = String.valueOf(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void println() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.newLine:()V");
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(Z)V");
            this.print(bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(C)V");
            this.print(c);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(I)V");
            this.print(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(J)V");
            this.print(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(F)V");
            this.print(f);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(D)V");
            this.print(d);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:([C)V");
            this.print(cArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(Ljava/lang/String;)V");
            this.print(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(Ljava/lang/Object;)Ljava/lang/String;");
        String string = String.valueOf(object);
        Object object2 = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.print:(Ljava/lang/String;)V");
            this.print(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.println:()V");
            this.println();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public PrintWriter printf(String string, Object ... objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/io/PrintWriter;");
        return this.format(string, objectArray);
    }

    public PrintWriter printf(Locale locale, String string, Object ... objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.format:(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/io/PrintWriter;");
        return this.format(locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(String string, Object ... objectArray) {
        try {
            block7: {
                Object object = this.lock;
                try {
                    block10: {
                        block9: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                            this.ensureOpen();
                            RuntimeCostAccounter.recordJump();
                            if (this.formatter == null) break block9;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.locale:()Ljava/util/Locale;");
                            Locale locale = this.formatter.locale();
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
                            Locale locale2 = Locale.getDefault();
                            RuntimeCostAccounter.recordJump();
                            if (locale == locale2) break block10;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/Formatter");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.<init>:(Ljava/lang/Appendable;)V");
                        this.formatter = new Formatter(this);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
                    Locale locale = Locale.getDefault();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.format:(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/Formatter;");
                    this.formatter.format(locale, string, objectArray);
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(Locale locale, String string, Object ... objectArray) {
        try {
            block7: {
                Object object = this.lock;
                try {
                    block10: {
                        block9: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.ensureOpen:()V");
                            this.ensureOpen();
                            RuntimeCostAccounter.recordJump();
                            if (this.formatter == null) break block9;
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.locale:()Ljava/util/Locale;");
                            Locale locale2 = this.formatter.locale();
                            RuntimeCostAccounter.recordJump();
                            if (locale2 == locale) break block10;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/Formatter");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.<init>:(Ljava/lang/Appendable;Ljava/util/Locale;)V");
                        this.formatter = new Formatter(this, locale);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.format:(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/Formatter;");
                    this.formatter.format(locale, string, objectArray);
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block7;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
        return this;
    }

    @Override
    public PrintWriter append(CharSequence charSequence) {
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
            this.write("null");
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            String string = charSequence.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
            this.write(string);
        }
        return this;
    }

    @Override
    public PrintWriter append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2;
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            charSequence2 = "null";
            RuntimeCostAccounter.recordJump();
        } else {
            charSequence2 = charSequence;
        }
        CharSequence charSequence3 = charSequence2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
        CharSequence charSequence4 = charSequence3.subSequence(n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        String string = charSequence4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(Ljava/lang/String;)V");
        this.write(string);
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintWriter.write:(I)V");
        this.write(c);
        return this;
    }
}

