/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilePermission;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.io.Serializable;
import sandbox.java.security.Permission;
import sandbox.java.security.PermissionCollection;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Collections;
import sandbox.java.util.Enumeration;
import sandbox.java.util.List;
import sandbox.java.util.Vector;

final class FilePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List<Permission> perms;
    private static final long serialVersionUID = 2202956749081564585L;
    private static final ObjectStreamField[] serialPersistentFields;

    public FilePermissionCollection() {
        RuntimeCostAccounter.recordMethodCall((String)"java/security/PermissionCollection.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.perms = new ArrayList<Permission>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        boolean bl = permission instanceof FilePermission;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("invalid permission: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(permission);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermissionCollection.isReadOnly:()Z");
        boolean bl2 = this.isReadOnly();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/SecurityException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityException.<init>:(Ljava/lang/String;)V");
            SecurityException securityException = new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            RuntimeCostAccounter.recordThrow();
            throw securityException;
        }
        FilePermissionCollection filePermissionCollection = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
            this.perms.add(permission);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        boolean bl = permission instanceof FilePermission;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getMask:()I");
        int n = filePermission.getMask();
        int n2 = 0;
        int n3 = n;
        FilePermissionCollection filePermissionCollection = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n4 = this.perms.size();
            int n5 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n5 >= n4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                FilePermission filePermission2 = (FilePermission)this.perms.get(n5);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getMask:()I");
                int n6 = n3 & filePermission2.getMask();
                RuntimeCostAccounter.recordJump();
                if (n6 != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.impliesIgnoreMask:(Ljava/io/FilePermission;)Z");
                    boolean bl2 = filePermission2.impliesIgnoreMask(filePermission);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilePermission.getMask:()I");
                        RuntimeCostAccounter.recordJump();
                        if (((n2 |= filePermission2.getMask()) & n) == n) {
                            return true;
                        }
                        n3 = n ^ n2;
                    }
                }
                ++n5;
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<Permission> elements() {
        FilePermissionCollection filePermissionCollection = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.enumeration:(Ljava/util/Collection;)Ljava/util/Enumeration;");
            return Collections.enumeration(this.perms);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Vector");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = this.perms.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.<init>:(I)V");
        Vector<Permission> vector = new Vector<Permission>(n);
        Object object = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.addAll:(Ljava/util/Collection;)Z");
            vector.addAll(this.perms);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.putFields:()Ljava/io/ObjectOutputStream$PutField;");
        object = objectOutputStream.putFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;Ljava/lang/Object;)V");
        ((ObjectOutputStream.PutField)object).put("permissions", vector);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFields:()V");
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readFields:()Ljava/io/ObjectInputStream$GetField;");
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        Vector vector = (Vector)getField.get("permissions", null);
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Vector.size:()I");
        int n = vector.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
        this.perms = new ArrayList<Permission>(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.addAll:(Ljava/util/Collection;)Z");
        this.perms.addAll(vector);
    }

    static {
        RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[1];
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", Vector.class);
        serialPersistentFields = objectStreamFieldArray;
    }
}

