/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos;
    protected int count;

    public CharArrayReader(char[] cArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.<init>:()V");
        this.markedPos = 0;
        this.buf = cArray;
        this.pos = 0;
        this.count = cArray.length;
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.<init>:()V");
                this.markedPos = 0;
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                int n3 = cArray.length;
                RuntimeCostAccounter.recordJump();
                if (n > n3) break block2;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block2;
                RuntimeCostAccounter.recordJump();
                if (n + n2 >= 0) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.buf = cArray;
        this.pos = n;
        int n4 = cArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        this.count = Math.min(n + n2, n4);
        this.markedPos = n;
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.buf == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.pos >= this.count) {
                return -1;
            }
            return this.buf[this.pos++];
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        try {
            block10: {
                block9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayReader.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block9;
                    int n3 = cArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n > n3) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block9;
                    int n4 = cArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 > n4) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 >= 0) break block10;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return 0;
            }
            RuntimeCostAccounter.recordJump();
            if (this.pos >= this.count) {
                return -1;
            }
            RuntimeCostAccounter.recordJump();
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 <= 0) {
                return 0;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayReader.ensureOpen:()V");
            this.ensureOpen();
            long l2 = (long)this.pos + l - (long)this.count;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l3 > 0) {
                l = this.count - this.pos;
            }
            RuntimeCostAccounter.recordJump();
            if (l < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        try {
            boolean bl;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.count - this.pos > 0) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayReader.ensureOpen:()V");
            this.ensureOpen();
            this.markedPos = this.pos;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/CharArrayReader.ensureOpen:()V");
            this.ensureOpen();
            this.pos = this.markedPos;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    public void close() {
        this.buf = null;
    }
}

