/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.io.UnsupportedEncodingException;
import sandbox.java.util.Arrays;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.<init>:(I)V");
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Negative initial size: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
    }

    private void ensureCapacity(int n) {
        int n2 = n - this.buf.length;
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.grow:(I)V");
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.buf.length;
        int n3 = n2 << 1;
        RuntimeCostAccounter.recordJump();
        if (n3 - n < 0) {
            n3 = n;
        }
        RuntimeCostAccounter.recordJump();
        if (n3 < 0) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/OutOfMemoryError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/OutOfMemoryError.<init>:()V");
                OutOfMemoryError outOfMemoryError = new OutOfMemoryError();
                RuntimeCostAccounter.recordThrow();
                throw outOfMemoryError;
            }
            n3 = Integer.MAX_VALUE;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
        this.buf = Arrays.copyOf(this.buf, n3);
    }

    @Override
    public synchronized void write(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.ensureCapacity:(I)V");
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)n;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                int n3 = byArray.length;
                RuntimeCostAccounter.recordJump();
                if (n > n3) break block2;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block2;
                int n4 = n + n2 - byArray.length;
                RuntimeCostAccounter.recordJump();
                if (n4 <= 0) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayOutputStream.ensureCapacity:(I)V");
        this.ensureCapacity(this.count + n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([BI)[B");
        return Arrays.copyOf(this.buf, this.count);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BII)V");
        return new String(this.buf, 0, this.count);
    }

    public synchronized String toString(String string) throws UnsupportedEncodingException {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BIILjava/lang/String;)V");
        return new String(this.buf, 0, this.count, string);
    }

    @Deprecated
    public synchronized String toString(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([BIII)V");
        return new String(this.buf, n, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }
}

