/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream outputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.<init>:(Ljava/io/OutputStream;I)V");
        this(outputStream, 8192);
    }

    public BufferedOutputStream(OutputStream outputStream, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Buffer size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
    }

    private void flushBuffer() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.count > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        int n2 = this.buf.length;
        RuntimeCostAccounter.recordJump();
        if (this.count >= n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.flushBuffer:()V");
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buf.length;
        RuntimeCostAccounter.recordJump();
        if (n2 >= n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.flushBuffer:()V");
            this.flushBuffer();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
            this.out.write(byArray, n, n2);
            return;
        }
        int n4 = this.buf.length - this.count;
        RuntimeCostAccounter.recordJump();
        if (n2 > n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.flushBuffer:()V");
            this.flushBuffer();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    @Override
    public synchronized void flush() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedOutputStream.flushBuffer:()V");
        this.flushBuffer();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
        this.out.flush();
    }
}

