/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.util.DelegatingEquals;
import co.paralleluniverse.common.util.Function2;
import co.paralleluniverse.common.util.Function3;
import co.paralleluniverse.common.util.Function4;
import co.paralleluniverse.common.util.Function5;
import co.paralleluniverse.fibers.DefaultFiberScheduler;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.SuspendableAction1;
import co.paralleluniverse.strands.SuspendableAction2;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.Channel;
import co.paralleluniverse.strands.channels.DoubleChannel;
import co.paralleluniverse.strands.channels.DoubleReceivePort;
import co.paralleluniverse.strands.channels.ErrorMappingReceivePort;
import co.paralleluniverse.strands.channels.FilteringReceivePort;
import co.paralleluniverse.strands.channels.FilteringSendPort;
import co.paralleluniverse.strands.channels.FlatMappingReceivePort;
import co.paralleluniverse.strands.channels.FloatChannel;
import co.paralleluniverse.strands.channels.FloatReceivePort;
import co.paralleluniverse.strands.channels.IntChannel;
import co.paralleluniverse.strands.channels.IntReceivePort;
import co.paralleluniverse.strands.channels.LongChannel;
import co.paralleluniverse.strands.channels.LongReceivePort;
import co.paralleluniverse.strands.channels.MappingReceivePort;
import co.paralleluniverse.strands.channels.MappingSendPort;
import co.paralleluniverse.strands.channels.Mix;
import co.paralleluniverse.strands.channels.PipeChannel;
import co.paralleluniverse.strands.channels.QueueChannel;
import co.paralleluniverse.strands.channels.QueueDoubleChannel;
import co.paralleluniverse.strands.channels.QueueFloatChannel;
import co.paralleluniverse.strands.channels.QueueIntChannel;
import co.paralleluniverse.strands.channels.QueueLongChannel;
import co.paralleluniverse.strands.channels.QueueObjectChannel;
import co.paralleluniverse.strands.channels.ReceivePort;
import co.paralleluniverse.strands.channels.ReceivePortGroup;
import co.paralleluniverse.strands.channels.ReducingReceivePort;
import co.paralleluniverse.strands.channels.ReducingSendPort;
import co.paralleluniverse.strands.channels.SendPort;
import co.paralleluniverse.strands.channels.TakeReceivePort;
import co.paralleluniverse.strands.channels.TickerChannelConsumer;
import co.paralleluniverse.strands.channels.TransferChannel;
import co.paralleluniverse.strands.channels.TransformingReceivePort;
import co.paralleluniverse.strands.channels.TransformingSendPort;
import co.paralleluniverse.strands.channels.ZippingReceivePort;
import co.paralleluniverse.strands.queues.ArrayQueue;
import co.paralleluniverse.strands.queues.BasicQueue;
import co.paralleluniverse.strands.queues.BasicSingleConsumerDoubleQueue;
import co.paralleluniverse.strands.queues.BasicSingleConsumerFloatQueue;
import co.paralleluniverse.strands.queues.BasicSingleConsumerIntQueue;
import co.paralleluniverse.strands.queues.BasicSingleConsumerLongQueue;
import co.paralleluniverse.strands.queues.BoxQueue;
import co.paralleluniverse.strands.queues.CircularDoubleBuffer;
import co.paralleluniverse.strands.queues.CircularFloatBuffer;
import co.paralleluniverse.strands.queues.CircularIntBuffer;
import co.paralleluniverse.strands.queues.CircularLongBuffer;
import co.paralleluniverse.strands.queues.CircularObjectBuffer;
import co.paralleluniverse.strands.queues.SingleConsumerArrayDoubleQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayFloatQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayIntQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayLongQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayObjectQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayDoubleQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayFloatQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayIntQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayLongQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayObjectQueue;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Instrumented
public final class Channels {
    private static final OverflowPolicy defaultPolicy = OverflowPolicy.BLOCK;
    private static final boolean defaultSingleProducer = false;
    private static final boolean defaultSingleConsumer = true;
    private static final FiberFactory defaultFiberFactory = DefaultFiberScheduler.getInstance();
    private static final ReceivePort EMPTY_RECEIVE_PORT = new ReceivePort(){

        public Object receive() {
            return null;
        }

        public Object receive(long timeout, TimeUnit unit) {
            return null;
        }

        public Object receive(Timeout timeout) {
            return null;
        }

        public Object tryReceive() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isClosed() {
            return true;
        }
    };

    public static <Message> Channel<Message> newChannel(int bufferSize, OverflowPolicy policy, boolean singleProducer, boolean singleConsumer) {
        BasicQueue queue;
        if (bufferSize == 0) {
            if (policy != OverflowPolicy.BLOCK) {
                throw new IllegalArgumentException("Cannot use policy " + (Object)((Object)policy) + " for channel with size 0 (only BLOCK supported");
            }
            return new TransferChannel();
        }
        if (bufferSize < 0) {
            if (!singleConsumer) {
                throw new IllegalArgumentException("Unbounded queue with multiple consumers is unsupported");
            }
            queue = new SingleConsumerLinkedArrayObjectQueue();
        } else if (bufferSize == 1 && policy != OverflowPolicy.DISPLACE) {
            queue = new BoxQueue(policy == OverflowPolicy.DISPLACE, singleConsumer);
        } else if (policy == OverflowPolicy.DISPLACE) {
            if (!singleConsumer) {
                throw new IllegalArgumentException("Channel with DISPLACE policy configuration is not supported for multiple consumers");
            }
            queue = new CircularObjectBuffer(bufferSize, singleProducer);
        } else {
            queue = singleConsumer ? new SingleConsumerArrayObjectQueue(bufferSize) : new ArrayQueue(bufferSize);
        }
        return new QueueObjectChannel(queue, policy, singleProducer, singleConsumer);
    }

    public static <Message> Channel<Message> newChannel(int bufferSize, OverflowPolicy policy) {
        return Channels.newChannel(bufferSize, policy, false, true);
    }

    public static <Message> Channel<Message> newChannel(int bufferSize) {
        return Channels.newChannel(bufferSize, bufferSize == 0 ? OverflowPolicy.BLOCK : defaultPolicy);
    }

    public static IntChannel newIntChannel(int bufferSize, OverflowPolicy policy, boolean singleProducer, boolean singleConsumer) {
        if (!singleConsumer) {
            throw new IllegalArgumentException("Primitive queue with multiple consumers is unsupported");
        }
        BasicSingleConsumerIntQueue queue = bufferSize < 0 ? new SingleConsumerLinkedArrayIntQueue() : (policy == OverflowPolicy.DISPLACE ? new CircularIntBuffer(bufferSize, singleProducer) : new SingleConsumerArrayIntQueue(bufferSize));
        return new QueueIntChannel(queue, policy);
    }

    public static IntChannel newIntChannel(int bufferSize, OverflowPolicy policy) {
        return Channels.newIntChannel(bufferSize, policy, false, true);
    }

    public static IntChannel newIntChannel(int bufferSize) {
        return Channels.newIntChannel(bufferSize, defaultPolicy);
    }

    public static LongChannel newLongChannel(int bufferSize, OverflowPolicy policy, boolean singleProducer, boolean singleConsumer) {
        if (!singleConsumer) {
            throw new IllegalArgumentException("Primitive queue with multiple consumers is unsupported");
        }
        BasicSingleConsumerLongQueue queue = bufferSize < 0 ? new SingleConsumerLinkedArrayLongQueue() : (policy == OverflowPolicy.DISPLACE ? new CircularLongBuffer(bufferSize, singleProducer) : new SingleConsumerArrayLongQueue(bufferSize));
        return new QueueLongChannel(queue, policy);
    }

    public static LongChannel newLongChannel(int bufferSize, OverflowPolicy policy) {
        return Channels.newLongChannel(bufferSize, policy, false, true);
    }

    public static LongChannel newLongChannel(int bufferSize) {
        return Channels.newLongChannel(bufferSize, defaultPolicy);
    }

    public static FloatChannel newFloatChannel(int bufferSize, OverflowPolicy policy, boolean singleProducer, boolean singleConsumer) {
        if (!singleConsumer) {
            throw new IllegalArgumentException("Primitive queue with multiple consumers is unsupported");
        }
        BasicSingleConsumerFloatQueue queue = bufferSize < 0 ? new SingleConsumerLinkedArrayFloatQueue() : (policy == OverflowPolicy.DISPLACE ? new CircularFloatBuffer(bufferSize, singleProducer) : new SingleConsumerArrayFloatQueue(bufferSize));
        return new QueueFloatChannel(queue, policy);
    }

    public static FloatChannel newFloatChannel(int bufferSize, OverflowPolicy policy) {
        return Channels.newFloatChannel(bufferSize, policy, false, true);
    }

    public static FloatChannel newFloatChannel(int bufferSize) {
        return Channels.newFloatChannel(bufferSize, defaultPolicy);
    }

    public static DoubleChannel newDoubleChannel(int bufferSize, OverflowPolicy policy, boolean singleProducer, boolean singleConsumer) {
        if (!singleConsumer) {
            throw new IllegalArgumentException("Primitive queue with multiple consumers is unsupported");
        }
        BasicSingleConsumerDoubleQueue queue = bufferSize < 0 ? new SingleConsumerLinkedArrayDoubleQueue() : (policy == OverflowPolicy.DISPLACE ? new CircularDoubleBuffer(bufferSize, singleProducer) : new SingleConsumerArrayDoubleQueue(bufferSize));
        return new QueueDoubleChannel(queue, policy);
    }

    public static DoubleChannel newDoubleChannel(int bufferSize, OverflowPolicy policy) {
        return Channels.newDoubleChannel(bufferSize, policy, false, true);
    }

    public static DoubleChannel newDoubleChannel(int bufferSize) {
        return Channels.newDoubleChannel(bufferSize, defaultPolicy);
    }

    public static boolean isTickerChannel(ReceivePort<?> channel) {
        return channel instanceof QueueChannel && ((QueueChannel)channel).overflowPolicy == OverflowPolicy.DISPLACE && ((QueueChannel)channel).capacity() > 0;
    }

    public static <Message> ReceivePort<Message> newTickerConsumerFor(Channel<Message> channel) {
        return TickerChannelConsumer.newFor((QueueChannel)channel);
    }

    public static IntReceivePort newTickerConsumerFor(IntChannel channel) {
        return TickerChannelConsumer.newFor((QueueIntChannel)channel);
    }

    public static LongReceivePort newTickerConsumerFor(LongChannel channel) {
        return TickerChannelConsumer.newFor((QueueLongChannel)channel);
    }

    public static FloatReceivePort newTickerConsumerFor(FloatChannel channel) {
        return TickerChannelConsumer.newFor((QueueFloatChannel)channel);
    }

    public static DoubleReceivePort newTickerConsumerFor(DoubleChannel channel) {
        return TickerChannelConsumer.newFor((QueueDoubleChannel)channel);
    }

    public static <S, T> void fiberTransform(FiberFactory fiberFactory, final ReceivePort<S> in, final SendPort<T> out, final SuspendableAction2<? extends ReceivePort<? super S>, ? extends SendPort<? extends T>> transformer) {
        fiberFactory.newFiber(new SuspendableCallable<Void>(){

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=530, methodEnd=537, suspendableCallSites={530}, suspendableCallSiteNames={"co/paralleluniverse/strands/SuspendableAction2.call(Ljava/lang/Object;Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={110})
            public Void run() throws SuspendExecution, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }).start();
    }

    public static <S, T> void fiberTransform(ReceivePort<S> in, SendPort<T> out, SuspendableAction2<? extends ReceivePort<? super S>, ? extends SendPort<? extends T>> transformer) {
        Channels.fiberTransform(defaultFiberFactory, in, out, transformer);
    }

    public static <M> ReceivePort<M> group(ReceivePort<? extends M> ... channels) {
        return new ReceivePortGroup<M>(channels);
    }

    public static <M> ReceivePort<M> group(Collection<? extends ReceivePort<? extends M>> channels) {
        return new ReceivePortGroup(channels);
    }

    public static <M> Mix<? extends M> mix(ReceivePort<? extends M> ... channels) {
        return new ReceivePortGroup<M>(channels);
    }

    public static <M> Mix<? extends M> mix(Collection<? extends ReceivePort<? extends M>> channels) {
        return new ReceivePortGroup(channels);
    }

    public static <M> ReceivePort<M> filter(ReceivePort<M> channel, Predicate<M> pred) {
        return new FilteringReceivePort<M>(channel, pred);
    }

    public static <S, T> ReceivePort<T> map(ReceivePort<S> channel, Function<S, T> f) {
        return new MappingReceivePort<S, T>(channel, f);
    }

    public static <S, T> ReceivePort<T> reduce(ReceivePort<S> channel, Function2<T, S, T> f, T init) {
        return new ReducingReceivePort<S, T>(channel, f, init);
    }

    public static <T> ReceivePort<T> mapErrors(ReceivePort<T> channel, Function<Exception, T> f) {
        return new ErrorMappingReceivePort<T>(channel, f);
    }

    public static <S, T> ReceivePort<T> flatMap(ReceivePort<S> channel, Function<S, ReceivePort<T>> f) {
        return new FlatMappingReceivePort<S, T>(channel, f);
    }

    public static <T> ReceivePort<T> take(ReceivePort<T> channel, long count) {
        return new TakeReceivePort<T>(channel, count);
    }

    public static <M> ReceivePort<M> zip(List<? extends ReceivePort<?>> cs, Function<Object[], M> f) {
        return new ZippingReceivePort<M>(f, cs);
    }

    public static <M, S1, S2> ReceivePort<M> zip(ReceivePort<S1> c1, ReceivePort<S2> c2, final Function2<S1, S2, M> f) {
        return new ZippingReceivePort<M>(new ReceivePort[]{c1, c2}){

            @Override
            protected M transform(Object[] ms) {
                return f.apply(ms[0], ms[1]);
            }
        };
    }

    public static <M, S1, S2, S3> ReceivePort<M> zip(ReceivePort<S1> c1, ReceivePort<S2> c2, ReceivePort<S3> c3, final Function3<S1, S2, S3, M> f) {
        return new ZippingReceivePort<M>(new ReceivePort[]{c1, c2, c3}){

            @Override
            protected M transform(Object[] ms) {
                return f.apply(ms[0], ms[1], ms[2]);
            }
        };
    }

    public static <M, S1, S2, S3, S4> ReceivePort<M> zip(ReceivePort<S1> c1, ReceivePort<S2> c2, ReceivePort<S3> c3, ReceivePort<S4> c4, final Function4<S1, S2, S3, S4, M> f) {
        return new ZippingReceivePort<M>(new ReceivePort[]{c1, c2, c3, c4}){

            @Override
            protected M transform(Object[] ms) {
                return f.apply(ms[0], ms[1], ms[2], ms[3]);
            }
        };
    }

    public static <M, S1, S2, S3, S4, S5> ReceivePort<M> zip(ReceivePort<S1> c1, ReceivePort<S2> c2, ReceivePort<S3> c3, ReceivePort<S4> c4, ReceivePort<S5> c5, final Function5<S1, S2, S3, S4, S5, M> f) {
        return new ZippingReceivePort<M>(new ReceivePort[]{c1, c2, c3, c4, c5}){

            @Override
            protected M transform(Object[] ms) {
                return f.apply(ms[0], ms[1], ms[2], ms[3], ms[4]);
            }
        };
    }

    public static <M> TransformingReceivePort<M> transform(ReceivePort<M> channel) {
        return new TransformingReceivePort<M>(channel);
    }

    public static <M> SendPort<M> filterSend(SendPort<M> channel, Predicate<M> pred) {
        return new FilteringSendPort<M>(channel, pred);
    }

    public static <S, T> SendPort<S> mapSend(SendPort<T> channel, Function<S, T> f) {
        return new MappingSendPort<S, T>(channel, f);
    }

    public static <S, T> SendPort<S> reduceSend(SendPort<T> channel, Function2<T, S, T> f, T init) {
        return new ReducingSendPort<S, T>(channel, f, init);
    }

    public static <S, T> SendPort<S> flatMapSend(FiberFactory fiberFactory, Channel<S> pipe, SendPort<T> channel, final Function<S, ReceivePort<T>> f) {
        Channels.fiberTransform(fiberFactory, pipe, channel, new SuspendableAction2<ReceivePort<S>, SendPort<T>>(){

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=873, methodEnd=881, suspendableCallSites={873, 877, 878}, suspendableCallSiteNames={"co/paralleluniverse/strands/channels/ReceivePort.receive()Ljava/lang/Object;", "co/paralleluniverse/strands/channels/SendPort.send(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={127, 256, 398})
            public void call(ReceivePort<S> var1_1, SendPort<T> var2_2) throws SuspendExecution, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        return new PipeChannel<S>(pipe, channel);
    }

    public static <S, T> SendPort<S> flatMapSend(Channel<S> pipe, SendPort<T> channel, Function<S, ReceivePort<T>> f) {
        return Channels.flatMapSend(defaultFiberFactory, pipe, channel, f);
    }

    public static <M> TransformingSendPort<M> transformSend(SendPort<M> channel) {
        return new TransformingSendPort<M>(channel);
    }

    public static <T> ReceivePort<T> emptyReceivePort() {
        return EMPTY_RECEIVE_PORT;
    }

    public static <T> ReceivePort<T> singletonReceivePort(final T object) {
        if (object == null) {
            return null;
        }
        return new ReceivePort<T>(){
            private boolean closed;

            @Override
            public T receive() {
                return this.tryReceive();
            }

            @Override
            public T receive(long timeout, TimeUnit unit) {
                return this.tryReceive();
            }

            @Override
            public T receive(Timeout timeout) {
                return this.tryReceive();
            }

            @Override
            public T tryReceive() {
                if (this.closed) {
                    return null;
                }
                this.closed = true;
                return object;
            }

            @Override
            public void close() {
                this.closed = true;
            }

            @Override
            public boolean isClosed() {
                return this.closed;
            }
        };
    }

    public static <T> ReceivePort<T> toReceivePort(final Iterator<T> iterator) {
        if (iterator == null) {
            return null;
        }
        return new ReceivePort<T>(){
            private Iterator<T> it;
            {
                this.it = iterator;
            }

            @Override
            public T receive() {
                return this.tryReceive();
            }

            @Override
            public T receive(long timeout, TimeUnit unit) {
                return this.tryReceive();
            }

            @Override
            public T receive(Timeout timeout) {
                return this.tryReceive();
            }

            @Override
            public T tryReceive() {
                return !this.isClosed() ? (Object)this.it.next() : null;
            }

            @Override
            public void close() {
                this.it = null;
            }

            @Override
            public boolean isClosed() {
                return this.it == null || !this.it.hasNext();
            }
        };
    }

    public static <T> ReceivePort<T> toReceivePort(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        return Channels.toReceivePort(iterable.iterator());
    }

    private Channels() {
    }

    static boolean delegatingEquals(Object target, Object obj) {
        if (obj instanceof DelegatingEquals) {
            return obj.equals(target);
        }
        return target.equals(obj);
    }

    static String delegatingToString(Object self, Object target) {
        if (self != null) {
            return self.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(self)) + "{" + target + "}";
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=698, methodEnd=701, suspendableCallSites={698, 699}, suspendableCallSiteNames={"co/paralleluniverse/strands/SuspendableAction1.call(Ljava/lang/Object;)V", "co/paralleluniverse/strands/channels/ReceivePort.receive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={109, 199})
    public static <T> void forEach(ReceivePort<T> var0, SuspendableAction1<T> var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum OverflowPolicy {
        THROW,
        DROP,
        BLOCK,
        BACKOFF,
        DISPLACE;

    }
}

