/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.ClassWriter;
import co.paralleluniverse.asm.util.CheckClassAdapter;
import co.paralleluniverse.asm.util.TraceClassVisitor;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.DBClassWriter;
import co.paralleluniverse.fibers.instrument.DefaultSuspendableClassifier;
import co.paralleluniverse.fibers.instrument.InstrumentClass;
import co.paralleluniverse.fibers.instrument.LabelSuspendableCallSitesClassVisitor;
import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.OffsetClassReader;
import co.paralleluniverse.fibers.instrument.SuspOffsetsAfterInstrClassVisitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public final class QuasarInstrumentor {
    public static final int ASMAPI = 327680;
    private static final String EXAMINED_CLASS = System.getProperty("co.paralleluniverse.fibers.writeInstrumentedClasses");
    private static final boolean allowJdkInstrumentation = SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.allowJdkInstrumentation");
    private WeakHashMap<ClassLoader, MethodDatabase> dbForClassloader = new WeakHashMap();
    private boolean check;
    private final boolean aot;
    private boolean allowMonitors;
    private boolean allowBlocking;
    private final Collection<Pattern> exclusions = new ArrayList<Pattern>();
    private Log log;
    private boolean verbose;
    private boolean debug;
    private int logLevelMask;
    private static final int BUF_SIZE = 8192;

    public QuasarInstrumentor() {
        this(false);
    }

    public QuasarInstrumentor(boolean aot) {
        this.aot = aot;
        this.setLogLevelMask();
    }

    public boolean isAOT() {
        return this.aot;
    }

    public boolean shouldInstrument(String className) {
        if (className != null) {
            if ((className = className.replace('.', '/')).startsWith("co/paralleluniverse/fibers/instrument/") && !Debug.isUnitTest()) {
                return false;
            }
            if (className.equals(Classes.FIBER_CLASS_NAME) || className.startsWith(Classes.FIBER_CLASS_NAME + '$')) {
                return false;
            }
            if (className.equals(Classes.STACK_NAME)) {
                return false;
            }
            if (className.startsWith("co/paralleluniverse/asm/")) {
                return false;
            }
            if (className.startsWith("org/netbeans/lib/")) {
                return false;
            }
            if (className.startsWith("java/lang/") || !allowJdkInstrumentation && MethodDatabase.isJDK(className)) {
                return false;
            }
            if (this.isExcluded(className)) {
                return false;
            }
        }
        return true;
    }

    public byte[] instrumentClass(ClassLoader loader, String className, byte[] data) throws IOException {
        return this.shouldInstrument(className) ? this.instrumentClass(loader, className, new ByteArrayInputStream(data), false) : data;
    }

    public byte[] instrumentClass(ClassLoader loader, String className, InputStream is) throws IOException {
        return this.instrumentClass(loader, className, is, false);
    }

    byte[] instrumentClass(ClassLoader loader, String className, InputStream is, boolean forceInstrumentation) throws IOException {
        className = className != null ? className.replace('.', '/') : null;
        byte[] cb = QuasarInstrumentor.toByteArray(is);
        MethodDatabase db = this.getMethodDatabase(loader);
        if (className != null) {
            this.log(LogLevel.INFO, "TRANSFORM: %s %s", className, db.getClassEntry(className) != null && db.getClassEntry(className).requiresInstrumentation() ? "request" : "");
            this.examine(className, "quasar-1-preinstr", cb);
        } else {
            this.log(LogLevel.INFO, "TRANSFORM: null className", new Object[0]);
        }
        ClassReader r1 = new ClassReader(cb);
        ClassWriter cw1 = new ClassWriter(r1, 0);
        LabelSuspendableCallSitesClassVisitor ic1 = new LabelSuspendableCallSitesClassVisitor(cw1, db);
        r1.accept(ic1, 0);
        cb = cw1.toByteArray();
        this.examine(className, "quasar-2", cb);
        ClassReader r2 = new ClassReader(cb);
        DBClassWriter cw2 = new DBClassWriter(db, r2);
        DBClassWriter cv2 = this.check && EXAMINED_CLASS == null ? new CheckClassAdapter(cw2) : cw2;
        InstrumentClass ic2 = new InstrumentClass(cv2, db, forceInstrumentation);
        try {
            r2.accept(ic2, 4);
            cb = cw2.toByteArray();
        }
        catch (Exception e) {
            if (ic2.hasSuspendableMethods()) {
                this.error("Unable to instrument class " + className, e);
                throw e;
            }
            if (!MethodDatabase.isProblematicClass(className)) {
                this.log(LogLevel.DEBUG, "Unable to instrument class " + className, new Object[0]);
            }
            return null;
        }
        this.examine(className, "quasar-4", cb);
        OffsetClassReader r3 = new OffsetClassReader(cb);
        ClassWriter cw3 = new ClassWriter(r3, 0);
        SuspOffsetsAfterInstrClassVisitor ic3 = new SuspOffsetsAfterInstrClassVisitor(cw3, db);
        r3.accept(ic3, 0);
        cb = cw3.toByteArray();
        if (EXAMINED_CLASS != null) {
            this.examine(className, "quasar-5-final", cb);
            if (this.check) {
                ClassReader r4 = new ClassReader(cb);
                CheckClassAdapter cv4 = new CheckClassAdapter(new TraceClassVisitor(null), true);
                r4.accept(cv4, 0);
            }
        }
        return cb;
    }

    private void examine(String className, String suffix, byte[] data) {
        if (EXAMINED_CLASS != null && className != null && className.contains(EXAMINED_CLASS)) {
            String filename = className.replace('/', '.') + "-" + new Date().getTime() + "-" + suffix + ".class";
            QuasarInstrumentor.writeToFile(filename, data);
        }
    }

    public synchronized MethodDatabase getMethodDatabase(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        if (!this.dbForClassloader.containsKey(loader)) {
            MethodDatabase newDb = new MethodDatabase(this, loader, new DefaultSuspendableClassifier(loader));
            this.dbForClassloader.put(loader, newDb);
            return newDb;
        }
        return this.dbForClassloader.get(loader);
    }

    public QuasarInstrumentor setCheck(boolean check) {
        this.check = check;
        return this;
    }

    public synchronized boolean isAllowMonitors() {
        return this.allowMonitors;
    }

    public synchronized QuasarInstrumentor setAllowMonitors(boolean allowMonitors) {
        this.allowMonitors = allowMonitors;
        return this;
    }

    public synchronized boolean isAllowBlocking() {
        return this.allowBlocking;
    }

    public synchronized QuasarInstrumentor setAllowBlocking(boolean allowBlocking) {
        this.allowBlocking = allowBlocking;
        return this;
    }

    public synchronized QuasarInstrumentor setLog(Log log) {
        this.log = log;
        return this;
    }

    public Log getLog() {
        return this.log;
    }

    public synchronized boolean isVerbose() {
        return this.verbose;
    }

    public synchronized void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.setLogLevelMask();
    }

    public synchronized boolean isDebug() {
        return this.debug;
    }

    public synchronized void setDebug(boolean debug) {
        this.debug = debug;
        this.setLogLevelMask();
    }

    public synchronized void addExcludedPackage(String packageGlob) {
        this.exclusions.add(QuasarInstrumentor.packagePattern(packageGlob));
    }

    public synchronized boolean isExcluded(String className) {
        if (className != null) {
            int i = (className = className.replace('.', '/')).lastIndexOf(47);
            if (i < 0) {
                return false;
            }
            String packageName = className.substring(0, i);
            for (Pattern p : this.exclusions) {
                if (!p.matcher(packageName).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void setLogLevelMask() {
        this.logLevelMask = 1 << LogLevel.WARNING.ordinal();
        if (this.verbose || this.debug) {
            this.logLevelMask |= 1 << LogLevel.INFO.ordinal();
        }
        if (this.debug) {
            this.logLevelMask |= 1 << LogLevel.DEBUG.ordinal();
        }
    }

    public void log(LogLevel level, String msg, Object ... args) {
        if (this.log != null && (this.logLevelMask & 1 << level.ordinal()) != 0) {
            this.log.log(level, msg, args);
        }
    }

    public void error(String msg, Throwable ex) {
        if (this.log != null) {
            this.log.error(msg, ex);
        }
    }

    String checkClass(ClassLoader cl, File f) {
        return this.getMethodDatabase(cl).checkClass(f);
    }

    private static void writeToFile(String name, byte[] data) {
        try (OutputStream os = Files.newOutputStream(Paths.get(name, new String[0]), StandardOpenOption.CREATE_NEW);){
            os.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QuasarInstrumentor.copy(in, out);
        return out.toByteArray();
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    private static Pattern packagePattern(String packageGlob) {
        String DOT = "[^/]";
        String glob = packageGlob.replace('.', '/');
        StringBuilder out = new StringBuilder(glob.length() + 5);
        out.append('^');
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append("[^/]*");
                    continue block6;
                }
                case '?': {
                    out.append("[^/]");
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        if (glob.endsWith("**")) {
            out.append(".*");
        }
        out.append('$');
        return Pattern.compile(out.toString());
    }
}

