/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.reflection.ASMUtil;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.common.util.ExtendedStackTrace;
import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.common.util.Pair;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.concurrent.util.ThreadAccess;
import co.paralleluniverse.concurrent.util.ThreadUtil;
import co.paralleluniverse.fibers.DefaultFiberScheduler;
import co.paralleluniverse.fibers.FiberForkJoinScheduler;
import co.paralleluniverse.fibers.FiberInfo;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.FiberTask;
import co.paralleluniverse.fibers.FiberWriter;
import co.paralleluniverse.fibers.FiberWriterSerializer;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.Joinable;
import co.paralleluniverse.fibers.RuntimeExecutionException;
import co.paralleluniverse.fibers.RuntimeSuspendExecution;
import co.paralleluniverse.fibers.Stack;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.ThreadLocalSerializer;
import co.paralleluniverse.fibers.VerifyInstrumentationException;
import co.paralleluniverse.fibers.instrument.SuspendableHelper;
import co.paralleluniverse.io.serialization.ByteArraySerializer;
import co.paralleluniverse.io.serialization.kryo.KryoSerializer;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.Stranded;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.SuspendableRunnable;
import co.paralleluniverse.strands.SuspendableUtils;
import co.paralleluniverse.strands.dataflow.Val;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

public class Fiber<V>
extends Strand
implements Joinable<V>,
Serializable,
Future<V> {
    static final boolean USE_VAL_FOR_RESULT = true;
    private static final Object RESET = new Object();
    private static final boolean traceInterrupt = SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.traceInterrupt");
    private static final boolean disableAgentWarning = SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.disableAgentWarning");
    public static final int DEFAULT_STACK_SIZE = 32;
    private static final Object SERIALIZER_BLOCKER = new Object();
    private static final boolean MAINTAIN_ACCESS_CONTROL_CONTEXT = System.getSecurityManager() != null;
    private static final long serialVersionUID = 2783452871536981L;
    protected static final FlightRecorder flightRecorder = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;
    private static final boolean verifyInstrumentation = SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.verifyInstrumentation");
    private static volatile Strand.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private static final AtomicLong idGen;
    private transient FiberScheduler scheduler;
    private transient FiberTask<V> task;
    private String name;
    private int initialStackSize;
    private transient long fid;
    final Stack stack;
    private volatile Strand.State state;
    private InterruptedException interruptStack;
    private volatile boolean interrupted;
    private long run;
    private transient boolean noPreempt;
    private transient Thread runningThread;
    private final SuspendableCallable<V> target;
    private byte priority;
    private boolean noLocals = false;
    private transient ClassLoader contextClassLoader;
    private transient AccessControlContext inheritedAccessControlContext;
    private Object fiberLocals;
    private Object inheritableFiberLocals;
    private long sleepStart;
    private transient Future<Void> timeoutTask;
    private transient ParkAction prePark;
    private transient ParkAction postPark;
    private transient Object result;
    private transient boolean getStackTrace;
    private volatile Strand.UncaughtExceptionHandler uncaughtExceptionHandler;
    transient DummyRunnable fiberRef = new DummyRunnable(this);
    private static final Unsafe UNSAFE;
    private static final long stateOffset;

    private static boolean printVerifyInstrumentationWarning() {
        if (verifyInstrumentation) {
            System.err.println("QUASAR WARNING: Fibers are set to verify instrumentation. This may *severely* harm performance.");
        }
        return true;
    }

    private static long nextFiberId() {
        return idGen.incrementAndGet();
    }

    public Fiber(String name, FiberScheduler scheduler, int stackSize, SuspendableCallable<V> target) {
        Thread currentThread;
        Object inheritableThreadLocals;
        this.state = Strand.State.NEW;
        this.fid = Fiber.nextFiberId();
        this.scheduler = scheduler;
        this.setName(name);
        Strand parent = Strand.currentStrand();
        this.target = target;
        this.task = scheduler != null ? scheduler.newFiberTask(this) : new FiberForkJoinScheduler.FiberForkJoinTask(this);
        this.initialStackSize = stackSize;
        this.stack = new Stack(this, stackSize > 0 ? stackSize : 32);
        this.priority = (byte)5;
        if (Debug.isDebug()) {
            this.record(1, "Fiber", "<init>", "Creating fiber name: %s, scheduler: %s, parent: %s, target: %s, task: %s, stackSize: %s", (Object)name, (Object)scheduler, (Object)parent, (Object)target, (Object)this.task, (Object)stackSize);
        }
        if (target != null) {
            if (verifyInstrumentation) {
                Fiber.verifyInstrumentedTarget(target);
            }
            if (target instanceof Stranded) {
                ((Stranded)((Object)target)).setStrand(this);
            }
        } else if (!Fiber.isInstrumented(this.getClass())) {
            throw new IllegalArgumentException("Fiber class " + this.getClass().getName() + " has not been instrumented.");
        }
        if ((inheritableThreadLocals = ThreadAccess.getInheritableThreadLocals(currentThread = Thread.currentThread())) != null) {
            this.inheritableFiberLocals = ThreadAccess.createInheritedMap(inheritableThreadLocals);
        }
        this.contextClassLoader = ThreadAccess.getContextClassLoader(currentThread);
        if (MAINTAIN_ACCESS_CONTROL_CONTEXT) {
            this.inheritedAccessControlContext = AccessController.getContext();
        }
        this.result = new Val();
        this.record(1, "Fiber", "<init>", "Created fiber %s", (Object)this);
    }

    public Fiber(String name, int stackSize, SuspendableCallable<V> target) {
        this(name, Fiber.defaultScheduler(), stackSize, target);
    }

    private static FiberScheduler defaultScheduler() {
        Fiber parent = Fiber.currentFiber();
        if (parent == null) {
            return DefaultFiberScheduler.getInstance();
        }
        return parent.getScheduler();
    }

    private static Fiber verifyParent() {
        Fiber parent = Fiber.currentFiber();
        if (parent == null) {
            throw new IllegalStateException("This constructor may only be used from within a Fiber");
        }
        return parent;
    }

    private static void verifyInstrumentedTarget(SuspendableCallable<?> target) {
        Serializable t = target;
        if (target instanceof SuspendableUtils.VoidSuspendableCallable) {
            t = ((SuspendableUtils.VoidSuspendableCallable)target).getRunnable();
        }
        if (t.getClass().getName().contains("$$Lambda$")) {
            return;
        }
        if (verifyInstrumentation && !Fiber.isInstrumented(t.getClass())) {
            throw new VerifyInstrumentationException("Target class " + t.getClass() + " has not been instrumented.");
        }
    }

    private Future<V> future() {
        return (Val)this.result;
    }

    public final SuspendableCallable<V> getTarget() {
        return this.target;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public final String getName() {
        if (this.name == null) {
            this.name = "fiber-" + (this.scheduler != null && this.scheduler != DefaultFiberScheduler.getInstance() ? this.scheduler.getName() + '-' : "") + this.fid;
        }
        return this.name;
    }

    @Override
    public final Fiber<V> setName(String name) {
        if (this.state != Strand.State.NEW) {
            throw new IllegalStateException("Fiber name cannot be changed once it has started");
        }
        this.name = name;
        return this;
    }

    @Override
    public Fiber setPriority(int newPriority) {
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        this.priority = (byte)newPriority;
        return this;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getId() {
        return this.fid;
    }

    public Object getTask() {
        return this.task;
    }

    public FiberScheduler getScheduler() {
        return this.scheduler;
    }

    long getRun() {
        return this.run;
    }

    @Deprecated
    public Fiber setNoLocals(boolean value) {
        this.noLocals = value;
        if (value) {
            this.fiberLocals = null;
            this.inheritableFiberLocals = null;
            this.inheritedAccessControlContext = null;
            this.contextClassLoader = null;
        }
        return this;
    }

    @Deprecated
    public boolean getNoLocals() {
        return this.noLocals;
    }

    public Fiber(String name, FiberScheduler scheduler, SuspendableCallable<V> target) {
        this(name, scheduler, -1, target);
    }

    public Fiber(FiberScheduler scheduler, SuspendableCallable<V> target) {
        this(null, scheduler, -1, target);
    }

    public Fiber(String name, FiberScheduler scheduler, int stackSize, SuspendableRunnable target) {
        this(name, scheduler, stackSize, SuspendableUtils.runnableToCallable(target));
    }

    public Fiber(String name, FiberScheduler scheduler, SuspendableRunnable target) {
        this(name, scheduler, -1, target);
    }

    public Fiber(FiberScheduler scheduler, SuspendableRunnable target) {
        this(null, scheduler, -1, target);
    }

    public Fiber(String name, FiberScheduler scheduler, int stackSize) {
        this(name, scheduler, stackSize, (SuspendableCallable)null);
    }

    public Fiber(String name, FiberScheduler scheduler) {
        this(name, scheduler, -1, (SuspendableCallable)null);
    }

    public Fiber(FiberScheduler scheduler) {
        this(null, scheduler, -1, (SuspendableCallable)null);
    }

    public Fiber(String name, SuspendableCallable<V> target) {
        this(name, -1, target);
    }

    public Fiber(SuspendableCallable<V> target) {
        this(null, -1, target);
    }

    public Fiber(String name, int stackSize, SuspendableRunnable target) {
        this(name, stackSize, SuspendableUtils.runnableToCallable(target));
    }

    public Fiber(String name, SuspendableRunnable target) {
        this(name, -1, target);
    }

    public Fiber(SuspendableRunnable target) {
        this(null, -1, target);
    }

    public Fiber(String name, int stackSize) {
        this(name, stackSize, (SuspendableCallable)null);
    }

    public Fiber(String name) {
        this(name, -1, (SuspendableCallable)null);
    }

    public Fiber() {
        this(null, -1, (SuspendableCallable)null);
    }

    public Fiber(Fiber fiber, SuspendableCallable<V> target) {
        this(fiber.name, fiber.scheduler, fiber.initialStackSize, target);
    }

    public Fiber(Fiber fiber, SuspendableRunnable target) {
        this(fiber.name, fiber.scheduler, fiber.initialStackSize, target);
    }

    public Fiber(Fiber fiber, FiberScheduler scheduler, SuspendableCallable<V> target) {
        this(fiber.name, scheduler, fiber.initialStackSize, target);
    }

    public Fiber(Fiber fiber, FiberScheduler scheduler, SuspendableRunnable target) {
        this(fiber.name, scheduler, fiber.initialStackSize, target);
    }

    public static Fiber currentFiber() {
        return Fiber.getCurrentFiber();
    }

    public static boolean isCurrentFiber() {
        return FiberForkJoinScheduler.isFiberThread(Thread.currentThread()) || Fiber.getCurrentFiber() != null;
    }

    public static long getCurrentRun() {
        Fiber f = Fiber.currentFiber();
        if (f == null) {
            throw new IllegalStateException("Not in fiber");
        }
        return f.getRun();
    }

    @Override
    public final boolean isFiber() {
        return true;
    }

    @Override
    public final Object getUnderlying() {
        return this;
    }

    static boolean park(Object blocker, ParkAction postParkActions, long timeout, TimeUnit unit) throws SuspendExecution {
        return Fiber.verifySuspend().park1(blocker, postParkActions, timeout, unit);
    }

    static boolean park(Object blocker, ParkAction postParkActions) throws SuspendExecution {
        return Fiber.park(blocker, postParkActions, 0L, null);
    }

    public static boolean park(Object blocker, long timeout, TimeUnit unit) throws SuspendExecution {
        return Fiber.park(blocker, null, timeout, unit);
    }

    public static void park(Object blocker) throws SuspendExecution {
        Fiber.park(blocker, null, 0L, null);
    }

    public static void park(long timeout, TimeUnit unit) throws SuspendExecution {
        Fiber.park(null, null, timeout, unit);
    }

    public static void park() throws SuspendExecution {
        Fiber.park(null, null, 0L, null);
    }

    public static void yield() throws SuspendExecution {
        Fiber.verifySuspend().yield1();
    }

    public static void parkAndUnpark(Fiber other) throws SuspendExecution {
        Fiber.parkAndUnpark(other, null);
    }

    public static void parkAndUnpark(Fiber other, Object blocker) throws SuspendExecution {
        Fiber.verifySuspend().parkAndUnpark1(other, blocker, 0L, TimeUnit.NANOSECONDS);
    }

    public static void yieldAndUnpark(Fiber other, Object blocker) throws SuspendExecution {
        Fiber.verifySuspend().yieldAndUnpark1(other, blocker, 0L, TimeUnit.NANOSECONDS);
    }

    public static void yieldAndUnpark(Fiber other) throws SuspendExecution {
        Fiber.yieldAndUnpark(other, null);
    }

    public static void sleep(long millis) throws InterruptedException, SuspendExecution {
        Fiber.sleep(millis, TimeUnit.MILLISECONDS);
    }

    public static void sleep(long millis, int nanos) throws InterruptedException, SuspendExecution {
        Fiber.sleep(TimeUnit.MILLISECONDS.toNanos(millis) + (long)nanos, TimeUnit.NANOSECONDS);
    }

    public static void sleep(long duration, TimeUnit unit) throws InterruptedException, SuspendExecution {
        Fiber.verifySuspend().sleep1(duration, unit);
    }

    public static boolean interrupted() {
        Fiber current = Fiber.currentFiber();
        if (current == null) {
            throw new IllegalStateException("Not called on a fiber");
        }
        boolean interrupted = current.isInterrupted();
        if (interrupted) {
            current.interrupted = false;
        }
        return interrupted;
    }

    private boolean park1(Object blocker, ParkAction postParkAction, long timeout, TimeUnit unit) throws SuspendExecution {
        this.record(1, "Fiber", "park", "Parking %s blocker: %s", (Object)this, blocker);
        if (this.isRecordingLevel(2) && !this.getStackTrace) {
            this.record(2, "Fiber", "park", "Parking %s at %s", (Object)this, (Object)Arrays.toString(this.getStackTrace()));
        }
        if (this.prePark != null) {
            this.prePark.run(this);
        }
        this.postPark = postParkAction;
        if (timeout > 0L && unit != null) {
            this.timeoutTask = this.scheduler.schedule(this, blocker, timeout, unit);
        }
        return this.task.park(blocker, postParkAction != null);
    }

    private void yield1() throws SuspendExecution {
        if (this.isRecordingLevel(2)) {
            this.record(2, "Fiber", "yield", "Yielding %s at %s", (Object)this, (Object)Arrays.toString(this.getStackTrace()));
        }
        if (this.prePark != null) {
            this.prePark.run(this);
        }
        this.task.yield();
    }

    private void parkAndUnpark1(Fiber other, Object blocker, long timeout, TimeUnit unit) throws SuspendExecution {
        this.record(1, "Fiber", "parkAndUnpark", "Parking %s and unparking %s blocker: %s", (Object)this, (Object)other, blocker);
        if (!other.exec(blocker, timeout, unit)) {
            other.unpark(blocker);
        }
        this.park1(blocker, null, -1L, null);
    }

    private void yieldAndUnpark1(Fiber other, Object blocker, long timeout, TimeUnit unit) throws SuspendExecution {
        this.record(1, "Fiber", "yieldAndUnpark", "Yielding %s and unparking %s blocker: %s", (Object)this, (Object)other, blocker);
        if (!other.exec(blocker, timeout, unit)) {
            other.unpark(blocker);
            this.yield1();
        }
    }

    void preempt() throws SuspendExecution {
        if (this.isRecordingLevel(2)) {
            this.record(2, "Fiber", "preempt", "Preempting %s at %s", (Object)this, (Object)Arrays.toString(this.getStackTrace()));
        }
        this.task.yield();
    }

    boolean exec() {
        if (this.result != RESET && this.future().isDone()) {
            return true;
        }
        if (this.state == Strand.State.RUNNING) {
            throw new IllegalStateException("Not new or suspended");
        }
        this.cancelTimeoutTask();
        FibersMonitor monitor = this.getMonitor();
        if (Debug.isDebug()) {
            this.record(1, "Fiber", "exec", "running %s %s %s", (Object)this.state, (Object)this, (Object)this.run);
        }
        Thread currentThread = Thread.currentThread();
        Object old = this.getCurrentTarget(currentThread);
        this.installFiberDataInThread(currentThread);
        ++this.run;
        this.runningThread = currentThread;
        this.state = Strand.State.RUNNING;
        boolean restored = false;
        try {
            V res = this.run1();
            this.runningThread = null;
            this.state = Strand.State.TERMINATED;
            this.record(1, "Fiber", "exec", "finished %s %s res: %s", (Object)this.state, (Object)this, this.result);
            this.monitorFiberTerminated(monitor);
            this.onCompletion();
            this.setResult(res);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeSuspendExecution e) {
            try {
                throw (SuspendExecution)e.getCause();
            }
            catch (SuspendExecution ex) {
                assert (ex == SuspendExecution.PARK || ex == SuspendExecution.YIELD);
                this.stack.resumeStack();
                this.runningThread = null;
                this.orderedSetState(this.timeoutTask != null ? Strand.State.TIMED_WAITING : Strand.State.WAITING);
                ParkAction ppa = this.postPark;
                this.clearRunSettings();
                this.restoreThreadData(currentThread, old);
                restored = true;
                this.record(1, "Fiber", "exec", "parked %s %s", (Object)this.state, (Object)this);
                this.task.doPark(ex == SuspendExecution.YIELD);
                assert (ppa == null || ex == SuspendExecution.PARK);
                if (ppa != null) {
                    try {
                        ppa.run(this);
                    }
                    catch (Throwable t) {
                        this.onException(t);
                        throw Exceptions.rethrow(t);
                    }
                }
                boolean bl = false;
                return bl;
            }
            catch (Throwable t) {
                this.clearRunSettings();
                this.runningThread = null;
                if (Debug.isDebug()) {
                    if (t instanceof InterruptedException) {
                        this.record(1, "Fiber", "exec", "InterruptedException: %s, %s", (Object)this.state, (Object)this);
                    } else {
                        StringWriter sw = new StringWriter();
                        t.printStackTrace(new PrintWriter(sw));
                        this.record(1, "Fiber", "exec", "Exception in %s %s: %s %s", (Object)this.state, (Object)this, (Object)t, (Object)sw.toString());
                    }
                }
                try {
                    if (t instanceof InterruptedException) {
                        throw new RuntimeException(t);
                    }
                    this.onException(t);
                    throw Exceptions.rethrow(t);
                }
                catch (Throwable throwable) {
                    this.state = Strand.State.TERMINATED;
                    this.task.setState(0);
                    this.monitorFiberTerminated(monitor);
                    this.setException(t);
                    throw throwable;
                }
            }
        }
        finally {
            if (!restored) {
                this.restoreThreadData(currentThread, old);
            }
            if (this.scheduler instanceof FiberForkJoinScheduler) {
                ((FiberForkJoinScheduler)this.scheduler).tryOnIdle();
            }
        }
    }

    void setResult(V res) {
        if (this.result == RESET) {
            return;
        }
        try {
            ((Val)this.result).set(res);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void setException(Throwable t) {
        try {
            ((Val)this.result).setException(t);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void clearRunSettings() {
        this.prePark = null;
        this.postPark = null;
        this.noPreempt = false;
    }

    private StackTraceElement[] execStackTrace1() {
        if (this.future().isDone()) {
            return null;
        }
        if (this.state == Strand.State.RUNNING) {
            throw new IllegalStateException("Not new or suspended");
        }
        this.getStackTrace = true;
        Thread currentThread = Thread.currentThread();
        Object old = this.getCurrentTarget(currentThread);
        this.setCurrentFiber(this, currentThread);
        try {
            try {
                this.run1();
                throw new AssertionError();
            }
            catch (RuntimeSuspendExecution e) {
                throw (SuspendExecution)e.getCause();
            }
        }
        catch (SuspendExecution | IllegalStateException ex) {
            assert (ex != SuspendExecution.PARK && ex != SuspendExecution.YIELD);
            this.stack.resumeStack();
            this.setCurrentTarget(old, currentThread);
            this.noPreempt = false;
            this.getStackTrace = false;
            this.task.doPark(false);
            StackTraceElement[] st = ex.getStackTrace();
            if (ex instanceof IllegalStateException) {
                int index = -1;
                for (int i = 0; i < st.length; ++i) {
                    if (!Fiber.class.getName().equals(st[i].getClassName()) || !"sleep".equals(st[i].getMethodName())) continue;
                    index = i;
                    break;
                }
                assert (index >= 0);
                st = Fiber.skipStackTraceElements(st, index);
            } else {
                st = Fiber.skipStackTraceElements(st, 2);
            }
            return st;
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FibersMonitor getMonitor() {
        if (this.scheduler == null) {
            return null;
        }
        return this.scheduler.getMonitor();
    }

    private void monitorFiberTerminated(FibersMonitor monitor) {
        if (monitor != null) {
            monitor.fiberTerminated(this);
        }
    }

    private void cancelTimeoutTask() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
            this.timeoutTask = null;
        }
    }

    private void installFiberDataInThread(Thread currentThread) {
        this.record(1, "Fiber", "installFiberDataInThread", "%s <-> %s", (Object)this, (Object)currentThread);
        if (!this.noLocals) {
            this.installFiberLocals(currentThread);
            this.installFiberContextClassLoader(currentThread);
            if (MAINTAIN_ACCESS_CONTROL_CONTEXT) {
                this.installFiberInheritedAccessControlContext(currentThread);
            }
        }
        this.setCurrentFiber(this, currentThread);
    }

    private void restoreThreadData(Thread currentThread, Object old) {
        this.record(1, "Fiber", "restoreThreadData", "%s <-> %s", (Object)this, (Object)currentThread);
        if (!this.noLocals) {
            this.restoreThreadLocals(currentThread);
            this.restoreThreadContextClassLoader(currentThread);
            if (MAINTAIN_ACCESS_CONTROL_CONTEXT) {
                this.restoreThreadInheritedAccessControlContext(currentThread);
            }
        }
        this.setCurrentTarget(old, currentThread);
    }

    void installFiberLocals(Thread currentThread) {
        this.switchFiberAndThreadLocals(currentThread, true);
    }

    void restoreThreadLocals(Thread currentThread) {
        this.switchFiberAndThreadLocals(currentThread, false);
    }

    private void switchFiberAndThreadLocals(Thread currentThread, boolean install) {
        if (this.noLocals || this.scheduler == null) {
            return;
        }
        Object tmpThreadLocals = ThreadAccess.getThreadLocals(currentThread);
        Object tmpInheritableThreadLocals = ThreadAccess.getInheritableThreadLocals(currentThread);
        if (this.isRecordingLevel(2)) {
            this.record(2, "Fiber", "switchFiberAndThreadLocals", "fiberLocals: %s", (Object)ThreadUtil.getThreadLocalsString(install ? this.fiberLocals : tmpThreadLocals));
            this.record(2, "Fiber", "switchFiberAndThreadLocals", "inheritableFiberLocals: %s", (Object)ThreadUtil.getThreadLocalsString(install ? this.inheritableFiberLocals : tmpInheritableThreadLocals));
        }
        ThreadAccess.setThreadLocals(currentThread, this.fiberLocals);
        ThreadAccess.setInheritableThreadLocals(currentThread, this.inheritableFiberLocals);
        this.fiberLocals = tmpThreadLocals;
        this.inheritableFiberLocals = tmpInheritableThreadLocals;
    }

    private void installFiberContextClassLoader(Thread currentThread) {
        ClassLoader origContextClassLoader = ThreadAccess.getContextClassLoader(currentThread);
        ThreadAccess.setContextClassLoader(currentThread, this.contextClassLoader);
        this.contextClassLoader = origContextClassLoader;
    }

    private void restoreThreadContextClassLoader(Thread currentThread) {
        ClassLoader origContextClassLoader = this.contextClassLoader;
        this.contextClassLoader = ThreadAccess.getContextClassLoader(currentThread);
        ThreadAccess.setContextClassLoader(currentThread, origContextClassLoader);
    }

    private void installFiberInheritedAccessControlContext(Thread currentThread) {
        AccessControlContext origAcc = ThreadAccess.getInheritedAccessControlContext(currentThread);
        ThreadAccess.setInheritedAccessControlContext(currentThread, this.inheritedAccessControlContext);
        this.inheritedAccessControlContext = origAcc;
    }

    private void restoreThreadInheritedAccessControlContext(Thread currentThread) {
        AccessControlContext origAcc = this.inheritedAccessControlContext;
        this.inheritedAccessControlContext = ThreadAccess.getInheritedAccessControlContext(currentThread);
        ThreadAccess.setInheritedAccessControlContext(currentThread, origAcc);
    }

    private void setCurrentFiber(Fiber fiber, Thread currentThread) {
        if (this.scheduler != null) {
            this.scheduler.setCurrentFiber(fiber, currentThread);
        } else {
            currentStrand.set(fiber);
        }
    }

    private void setCurrentTarget(Object target, Thread currentThread) {
        if (this.scheduler != null) {
            this.scheduler.setCurrentTarget(target, currentThread);
        } else {
            currentStrand.set(null);
        }
    }

    private Object getCurrentTarget(Thread currentThread) {
        if (this.scheduler == null) {
            return null;
        }
        return this.scheduler.getCurrentTarget(currentThread);
    }

    private static Fiber getCurrentFiber() {
        Thread currentThread = Thread.currentThread();
        if (FiberForkJoinScheduler.isFiberThread(currentThread)) {
            return FiberForkJoinScheduler.getTargetFiber(currentThread);
        }
        Strand s = (Strand)currentStrand.get();
        return s instanceof Fiber ? (Fiber)s : null;
    }

    private V run1() throws SuspendExecution, InterruptedException {
        return this.run();
    }

    protected V run() throws SuspendExecution, InterruptedException {
        if (this.target != null) {
            return this.target.run();
        }
        return null;
    }

    public Fiber inheritThreadLocals() {
        if (this.state != Strand.State.NEW) {
            throw new IllegalStateException("Method called on a started fiber");
        }
        if (!this.noLocals) {
            this.fiberLocals = ThreadAccess.cloneThreadLocalMap(ThreadAccess.getThreadLocals(Thread.currentThread()));
        }
        return this;
    }

    @Override
    public final Fiber<V> start() {
        if (!this.casState(Strand.State.NEW, Strand.State.STARTED)) {
            if (this.state == Strand.State.TERMINATED && this.future().isCancelled()) {
                return this;
            }
            throw new IllegalThreadStateException("Fiber has already been started or has died");
        }
        this.getMonitor().fiberStarted(this);
        this.task.submit();
        return this;
    }

    protected void onParked() {
    }

    protected void onResume() throws SuspendExecution, InterruptedException {
        if (this.getStackTrace) {
            try {
                this.park1(null, null, 0L, null);
            }
            catch (SuspendExecution suspendExecution) {
                // empty catch block
            }
            SuspendExecution ex = new SuspendExecution();
            ex.setStackTrace(new Throwable().getStackTrace());
            throw ex;
        }
        this.record(1, "Fiber", "onResume", "Resuming %s", (Object)this);
        if (this.isRecordingLevel(2)) {
            this.record(2, "Fiber", "onResume", "Resuming %s at: %s", (Object)this, (Object)Arrays.toString(this.getStackTrace()));
        }
    }

    final void preemptionPoint(int type) throws SuspendExecution {
        if (this.noPreempt) {
            return;
        }
        if (this.shouldPreempt(type)) {
            this.preempt();
        }
    }

    protected boolean shouldPreempt(int type) {
        return false;
    }

    protected void onCompletion() {
    }

    protected void onException(Throwable t) {
        block5: {
            try {
                Strand.UncaughtExceptionHandler ueh = this.uncaughtExceptionHandler;
                if (ueh != null) {
                    ueh.uncaughtException(this, t);
                } else {
                    ueh = defaultUncaughtExceptionHandler;
                    if (ueh != null) {
                        ueh.uncaughtException(this, t);
                    }
                }
            }
            catch (Exception e) {
                if (e == t || t == null) break block5;
                t.addSuppressed(e);
            }
        }
        throw Exceptions.rethrow(t);
    }

    @Override
    public final void interrupt() {
        if (traceInterrupt) {
            this.interruptStack = new InterruptedException();
        }
        this.interrupted = true;
        this.unpark(FiberTask.EMERGENCY_UNBLOCKER);
    }

    @Override
    public final boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public final InterruptedException getInterruptStack() {
        if (!traceInterrupt) {
            return null;
        }
        return this.interruptStack;
    }

    @Override
    public final boolean isAlive() {
        return this.state != Strand.State.NEW && !this.future().isDone();
    }

    @Override
    public final Strand.State getState() {
        return this.state;
    }

    @Override
    public final boolean isTerminated() {
        return this.state == Strand.State.TERMINATED;
    }

    @Override
    public final Object getBlocker() {
        return this.task.getBlocker();
    }

    final boolean exec(Object blocker, long timeout, TimeUnit unit) {
        if (!this.scheduler.isCurrentThreadInScheduler()) {
            return false;
        }
        this.record(1, "Fiber", "exec", "Blocker %s attempting to immediately execute %s", blocker, (Object)this);
        if (!this.tryUnpark(blocker, timeout, unit)) {
            this.record(1, "Fiber", "exec", "Blocker %s attempt to immediately execute %s FAILED", blocker, (Object)this);
            return false;
        }
        this.immediateExecHelper();
        return true;
    }

    final boolean exec(Object blocker, ParkAction prePark) {
        if (!this.scheduler.isCurrentThreadInScheduler()) {
            return false;
        }
        this.record(1, "Fiber", "exec", "Blocker %s attempting to immediately execute %s", blocker, (Object)this);
        if (blocker != this.getBlocker() || !this.task.tryUnpark(blocker)) {
            this.record(1, "Fiber", "exec", "Blocker %s attempt to immediately execute %s FAILED", blocker, (Object)this);
            return false;
        }
        this.prePark = prePark;
        this.immediateExecHelper();
        return true;
    }

    private void immediateExecHelper() {
        this.noPreempt = true;
        this.task.doExec();
    }

    private StackTraceElement[] execStackTrace(long timeout, TimeUnit unit) {
        if (!this.tryUnpark(null, timeout, unit)) {
            return null;
        }
        this.noPreempt = true;
        return this.execStackTrace1();
    }

    private FiberInfo execFiberInfo(long timeout, TimeUnit unit) {
        if (!this.tryUnpark(null, timeout, unit)) {
            return null;
        }
        Strand.State s = this.state;
        this.noPreempt = true;
        StackTraceElement[] st = this.execStackTrace1();
        Object blocker = this.getBlocker();
        return this.makeFiberInfo(s, blocker, st);
    }

    private boolean tryUnpark(Object unblocker, long timeout, TimeUnit unit) {
        long start = 0L;
        int i = 0;
        while (true) {
            boolean tu;
            Object b = this.getBlocker();
            if ((unblocker == null || b == unblocker) && (tu = this.task.tryUnpark(unblocker))) {
                return true;
            }
            if ((start = this.isTimeoutExpired(i, start, timeout, unit)) < 0L) {
                return false;
            }
            ++i;
        }
    }

    private long isTimeoutExpired(int iter2, long start, long timeout, TimeUnit unit) {
        if (unit != null && timeout == 0L) {
            return -1L;
        }
        if (unit != null && timeout > 0L && iter2 > 4096) {
            if (start == 0L) {
                start = System.nanoTime();
            } else if (iter2 % 100 == 0 && System.nanoTime() - start > unit.toNanos(timeout)) {
                return -1L;
            }
        }
        return start;
    }

    Object getUnparker() {
        return this.task.getUnparker();
    }

    StackTraceElement[] getUnparkStackTrace() {
        return this.task.getUnparkStackTrace();
    }

    @Override
    public final void unpark() {
        this.record(1, "Fiber", "unpark", "Unpark %s", (Object)this);
        this.task.unpark();
    }

    @Override
    public final void unpark(Object unblocker) {
        this.record(1, "Fiber", "unpark", "Unpark %s by %s", (Object)this, unblocker);
        this.task.unpark(unblocker);
    }

    final boolean unpark1(Object unblocker) {
        this.record(1, "Fiber", "unpark1", "Unpark %s by %s", (Object)this, unblocker);
        return this.task.unpark(unblocker);
    }

    @Override
    @Suspendable
    public final void join() throws ExecutionException, InterruptedException {
        this.get();
    }

    @Override
    @Suspendable
    public final void join(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.get(timeout, unit);
    }

    public final Fiber<V> joinNoSuspend() throws ExecutionException, InterruptedException {
        this.task.get();
        return this;
    }

    public final Fiber<V> joinNoSuspend(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        this.task.get(timeout, unit);
        return this;
    }

    @Override
    @Suspendable
    public final V get() throws ExecutionException, InterruptedException {
        try {
            return this.future().get();
        }
        catch (RuntimeExecutionException t) {
            throw new ExecutionException(t.getCause());
        }
    }

    @Override
    @Suspendable
    public final V get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        try {
            return this.future().get(timeout, unit);
        }
        catch (RuntimeExecutionException t) {
            throw new ExecutionException(t.getCause());
        }
    }

    @Override
    public final boolean isDone() {
        return this.isTerminated();
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        if (this.casState(Strand.State.NEW, Strand.State.TERMINATED)) {
            this.future().cancel(mayInterruptIfRunning);
        } else {
            this.interrupt();
        }
        return !this.isDone();
    }

    @Override
    public final boolean isCancelled() {
        return this.future().isCancelled();
    }

    private void sleep1(long timeout, TimeUnit unit) throws InterruptedException, SuspendExecution {
        if (this.getStackTrace) {
            this.onResume();
            assert (false) : "shouldn't get here";
        }
        try {
            while (true) {
                long deadline;
                long left;
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                long now = System.nanoTime();
                if (this.sleepStart == 0L) {
                    this.sleepStart = now;
                }
                if ((left = (deadline = this.sleepStart + unit.toNanos(timeout)) - now) <= 0L) {
                    this.sleepStart = 0L;
                    return;
                }
                this.park1(null, null, left, TimeUnit.NANOSECONDS);
            }
        }
        catch (SuspendExecution s) {
            throw s;
        }
        catch (Throwable t) {
            this.sleepStart = 0L;
            throw t;
        }
    }

    @Override
    public final void setUncaughtExceptionHandler(Strand.UncaughtExceptionHandler eh) {
        this.uncaughtExceptionHandler = eh;
    }

    @Override
    public final Strand.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public static Strand.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(Strand.UncaughtExceptionHandler eh) {
        defaultUncaughtExceptionHandler = eh;
    }

    static void setCurrentStrand(Strand f) {
        currentStrand.set(f);
    }

    static Strand getCurrentStrand() {
        return (Strand)currentStrand.get();
    }

    Thread getRunningThread() {
        return this.runningThread;
    }

    @Override
    public final StackTraceElement[] getStackTrace() {
        StackTraceElement[] threadStack = null;
        if (Fiber.currentFiber() == this) {
            threadStack = Fiber.skipStackTraceElements(Thread.currentThread().getStackTrace(), 1);
        } else {
            while (this.state != Strand.State.TERMINATED && this.state != Strand.State.NEW) {
                if (this.state == Strand.State.RUNNING) {
                    long r = this.run;
                    Thread t = this.runningThread;
                    if (t != null) {
                        threadStack = t.getStackTrace();
                    }
                    if (t == null || this.state != Strand.State.RUNNING || this.run != r || this.runningThread != t) continue;
                    break;
                }
                threadStack = this.execStackTrace(1L, TimeUnit.MILLISECONDS);
                if (threadStack == null) continue;
                this.unpark("getStackTrace");
                break;
            }
        }
        return Fiber.threadToFiberStack(threadStack);
    }

    final FiberInfo getFiberInfo(boolean stack) {
        Object blocker;
        Strand.State s;
        if (Fiber.currentFiber() == this) {
            return this.makeFiberInfo(Strand.State.RUNNING, null, stack ? Fiber.skipStackTraceElements(Thread.currentThread().getStackTrace(), 1) : null);
        }
        while (true) {
            if (this.state == Strand.State.TERMINATED || this.state == Strand.State.NEW) {
                return this.makeFiberInfo(this.state, null, null);
            }
            if (this.state == Strand.State.RUNNING) {
                if (stack) {
                    long r = this.run;
                    Thread t = this.runningThread;
                    StackTraceElement[] threadStack = null;
                    if (t != null) {
                        threadStack = t.getStackTrace();
                    }
                    if (this.state != Strand.State.RUNNING || this.run != r || this.runningThread != t) continue;
                    return this.makeFiberInfo(Strand.State.RUNNING, null, threadStack);
                }
                return this.makeFiberInfo(Strand.State.RUNNING, null, null);
            }
            if (stack) {
                FiberInfo fi = this.execFiberInfo(1L, TimeUnit.MILLISECONDS);
                if (fi == null) continue;
                this.unpark();
                return fi;
            }
            s = this.state;
            if (s != Strand.State.WAITING && s != Strand.State.TIMED_WAITING) continue;
            blocker = this.getBlocker();
            s = this.state;
            if (s == Strand.State.WAITING || s == Strand.State.TIMED_WAITING) break;
        }
        return this.makeFiberInfo(s, blocker, null);
    }

    private FiberInfo makeFiberInfo(Strand.State state, Object blocker, StackTraceElement[] stackTrace) {
        return new FiberInfo(this.fid, this.getName(), state, blocker, Fiber.threadToFiberStack(stackTrace));
    }

    private static StackTraceElement[] threadToFiberStack(StackTraceElement[] threadStack) {
        if (threadStack == null) {
            return null;
        }
        if (threadStack.length == 0) {
            return threadStack;
        }
        int count = 0;
        for (StackTraceElement ste : threadStack) {
            ++count;
            if (!Fiber.class.getName().equals(ste.getClassName())) continue;
            if ("run".equals(ste.getMethodName())) break;
            if (!"run1".equals(ste.getMethodName())) continue;
            --count;
            break;
        }
        StackTraceElement[] fiberStack = new StackTraceElement[count];
        System.arraycopy(threadStack, 0, fiberStack, 0, count);
        return fiberStack;
    }

    public static void dumpStack() {
        Fiber.verifyCurrent();
        Fiber.printStackTrace(new Exception("Stack trace"), (OutputStream)System.err);
    }

    private static void printStackTrace(Throwable t, OutputStream out) {
        t.printStackTrace(new PrintStream(out){
            boolean seenExec;

            @Override
            public void println(String x) {
                if (x.startsWith("\tat ")) {
                    if (this.seenExec) {
                        return;
                    }
                    if (x.startsWith("\tat " + Fiber.class.getName() + ".exec")) {
                        this.seenExec = true;
                        return;
                    }
                }
                super.println(x);
            }
        });
    }

    V getResult() {
        return null;
    }

    public final String toString() {
        return "Fiber@" + this.fid + (this.name != null ? ':' + this.name : "") + "[task: " + this.task + ", target: " + Objects.systemToString(this.target) + ", scheduler: " + this.scheduler + ']';
    }

    final Stack getStack() {
        return this.stack;
    }

    private static Fiber verifySuspend() {
        return Fiber.verifySuspend(Fiber.verifyCurrent());
    }

    static Fiber verifySuspend(Fiber current) {
        if (verifyInstrumentation) {
            Fiber.checkInstrumentation();
        }
        return current;
    }

    private static Fiber verifyCurrent() {
        Fiber current = Fiber.currentFiber();
        if (current == null) {
            Stack stack = Stack.getStack();
            if (stack != null) {
                current = stack.getFiber();
                if (!current.getStackTrace) {
                    throw new AssertionError();
                }
                return current;
            }
            throw new IllegalStateException("Not called on a fiber (current strand: " + Strand.currentStrand() + ")");
        }
        return current;
    }

    private static String sourceLineToDesc(int sourceLine) {
        if (sourceLine == -1) {
            return "UNKNOWN";
        }
        return Integer.toString(sourceLine);
    }

    private static boolean checkInstrumentation() {
        return Fiber.checkInstrumentation(ExtendedStackTrace.here());
    }

    private static boolean checkInstrumentation(ExtendedStackTrace of) {
        return Fiber.checkInstrumentation(of, false);
    }

    private static boolean checkInstrumentation(ExtendedStackTrace st, boolean fromUncaughtExc) {
        ExtendedStackTraceElement first;
        if (!(!fromUncaughtExc || st.get().length <= 0 || st.get()[0] == null || (first = st.get()[0]).getDeclaringClass().equals(ClassCastException.class) || first.getDeclaringClass().equals(NullPointerException.class) && first.getDeclaringClass().getName().startsWith("co.paralleluniverse.fibers"))) {
            return true;
        }
        boolean ok = true;
        StringBuilder stackTrace = null;
        Object[] stes = st.get();
        for (int i = 0; i < stes.length; ++i) {
            ExtendedStackTraceElement ste = stes[i];
            if (ste.getClassName().equals(Thread.class.getName()) && ste.getMethodName().equals("getStackTrace") || ste.getClassName().equals(ExtendedStackTrace.class.getName())) continue;
            if (!ok) {
                Fiber.printTraceLine(stackTrace, ste);
            }
            if (ste.getClassName().contains("$$Lambda$")) continue;
            if (!(ste.getClassName().equals(Fiber.class.getName()) || ste.getClassName().startsWith(Fiber.class.getName() + '$') || ste.getClassName().equals(Stack.class.getName()) || SuspendableHelper.isWaiver(ste.getClassName(), ste.getMethodName()))) {
                Class<?> clazz = ste.getDeclaringClass();
                boolean classInstrumented = SuspendableHelper.isInstrumented(clazz);
                Member m = SuspendableHelper.lookupMethod(ste);
                if (m != null) {
                    boolean methodInstrumented = SuspendableHelper.isInstrumented(m);
                    Pair<Boolean, Instrumented> callSiteInstrumented = SuspendableHelper.isCallSiteInstrumented(m, ste.getLineNumber(), ste.getBytecodeIndex(), (ExtendedStackTraceElement[])stes, i);
                    if (classInstrumented && methodInstrumented && callSiteInstrumented.getFirst().booleanValue()) continue;
                    if (ok) {
                        stackTrace = Fiber.initTrace(i, (ExtendedStackTraceElement[])stes);
                    }
                    if (!classInstrumented || !methodInstrumented) {
                        stackTrace.append(" **");
                    } else if (!callSiteInstrumented.getFirst().booleanValue()) {
                        stackTrace.append(" !! (instrumented suspendable calls at: ").append(Fiber.callSitesString(callSiteInstrumented.getSecond())).append(")");
                    }
                    ok = false;
                    continue;
                }
                if (ok) {
                    stackTrace = Fiber.initTrace(i, (ExtendedStackTraceElement[])stes);
                }
                stackTrace.append(" **");
                ok = false;
                continue;
            }
            if (!ste.getClassName().equals(Fiber.class.getName()) || !ste.getMethodName().equals("run1")) continue;
            if (!ok) {
                String str = "Uninstrumented whole methods ('**') or single calls ('!!') detected: " + stackTrace;
                if (Debug.isUnitTest()) {
                    throw new VerifyInstrumentationException(str);
                }
                System.err.println("WARNING: " + str);
            }
            return ok;
        }
        throw new IllegalStateException("Not run through Fiber.exec(). (trace: " + Arrays.toString(stes) + ")");
    }

    private static String callSitesString(Instrumented i) {
        if (i == null) {
            return "N/A";
        }
        return "lines " + Arrays.toString(i.suspendableCallSites()) + ",  calls " + Arrays.toString(Fiber.getReadableCallsites(i.suspendableCallSiteNames()));
    }

    private static String[] getReadableCallsites(String[] callsites) {
        String[] readable = new String[callsites.length];
        for (int i = 0; i < callsites.length; ++i) {
            readable[i] = SuspendableHelper.getCallsiteOwner(callsites[i]) + "." + SuspendableHelper.getCallsiteName(callsites[i]) + ASMUtil.getReadableDescriptor(SuspendableHelper.getCallsiteDesc(callsites[i]));
        }
        return readable;
    }

    private static StringBuilder initTrace(int i, ExtendedStackTraceElement[] stes) {
        StringBuilder stackTrace = new StringBuilder();
        for (int j = 0; j <= i; ++j) {
            ExtendedStackTraceElement ste2 = stes[j];
            if (ste2.getClassName().equals(Thread.class.getName()) && ste2.getMethodName().equals("getStackTrace")) continue;
            Fiber.printTraceLine(stackTrace, ste2);
        }
        return stackTrace;
    }

    private static void printTraceLine(StringBuilder stackTrace, ExtendedStackTraceElement ste) {
        Member m = SuspendableHelper.lookupMethod(ste);
        stackTrace.append("\n\tat ").append(ste.getMethod() == null ? ste.toString(m) : ste.toString());
        if (SuspendableHelper.isOptimized(m)) {
            stackTrace.append(" (optimized)");
        }
    }

    private static boolean isInstrumented(Class clazz) {
        boolean res = clazz.isAnnotationPresent(Instrumented.class);
        if (!res) {
            res = Fiber.isInstrumented0(clazz);
        }
        return res;
    }

    private static boolean isInstrumented0(Class clazz) {
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            if (superclazz.isAnnotationPresent(Instrumented.class)) {
                Method[] ms;
                for (Method m : ms = clazz.getDeclaredMethods()) {
                    for (Class<?> et : m.getExceptionTypes()) {
                        if (!et.equals(SuspendExecution.class)) continue;
                        return false;
                    }
                    if (!m.isAnnotationPresent(Suspendable.class)) continue;
                    return false;
                }
                return true;
            }
            return Fiber.isInstrumented0(superclazz);
        }
        return false;
    }

    void resetState() {
        this.task.tryUnpark(null);
        assert (this.task.getState() == 0);
    }

    void reset() {
        this.result = RESET;
        this.stack.resetStack();
    }

    private boolean casState(Strand.State expected, Strand.State update) {
        return UNSAFE.compareAndSwapObject(this, stateOffset, (Object)expected, (Object)update);
    }

    private void orderedSetState(Strand.State value) {
        UNSAFE.putOrderedObject(this, stateOffset, (Object)value);
    }

    protected final boolean isRecordingLevel(int level) {
        FlightRecorder.ThreadRecorder recorder;
        if (!Debug.isDebug()) {
            return false;
        }
        FlightRecorder.ThreadRecorder threadRecorder = recorder = flightRecorder != null ? flightRecorder.get() : null;
        if (recorder == null) {
            return false;
        }
        return recorder.recordsLevel(level);
    }

    protected final void record(int level, String clazz, String method, String format) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1, arg2);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3, arg4);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3, arg4, arg5);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3, arg4, arg5, arg6);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object ... args) {
        if (flightRecorder != null) {
            Fiber.record(flightRecorder.get(), level, clazz, method, format, args);
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, null));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object ... args) {
        if (recorder != null) {
            recorder.record(level, (Object)Fiber.makeFlightRecorderMessage(recorder, clazz, method, format, args));
        }
    }

    private static FlightRecorderMessage makeFlightRecorderMessage(FlightRecorder.ThreadRecorder recorder, String clazz, String method, String format, Object[] args) {
        return new FlightRecorderMessage(clazz, method, format, args);
    }

    private static StackTraceElement[] skipStackTraceElements(StackTraceElement[] st, int skip) {
        if (skip >= st.length) {
            return st;
        }
        StackTraceElement[] st1 = new StackTraceElement[st.length - skip];
        System.arraycopy(st, skip, st1, 0, st1.length);
        return st1;
    }

    public static void parkAndSerialize(final FiberWriter writer) throws SuspendExecution {
        while (!Fiber.park(SERIALIZER_BLOCKER, new ParkAction(){

            @Override
            public void run(Fiber f) {
                f.record(1, "Fiber", "parkAndSerialize", "Serializing fiber %s", (Object)f);
                writer.write(f, Fiber.getFiberSerializer());
            }
        })) {
        }
    }

    public static <V> Fiber<V> unparkSerialized(byte[] serFiber, FiberScheduler scheduler) {
        Fiber f = (Fiber)Fiber.getFiberSerializer().read(serFiber);
        return Fiber.unparkDeserialized(f, scheduler);
    }

    public static <V> Fiber<V> unparkDeserialized(Fiber<V> f, FiberScheduler scheduler) {
        f.record(1, "Fiber", "unparkDeserialized", "Deserialized fiber %s", (Object)f);
        Thread currentThread = Thread.currentThread();
        f.fiberRef = new DummyRunnable(f);
        f.fid = Fiber.nextFiberId();
        f.scheduler = scheduler;
        f.task = scheduler.newFiberTask(f);
        f.task.setState(-1);
        f.result = new Val();
        f.contextClassLoader = ThreadAccess.getContextClassLoader(currentThread);
        if (MAINTAIN_ACCESS_CONTROL_CONTEXT) {
            f.inheritedAccessControlContext = AccessController.getContext();
        }
        f.record(1, "Fiber", "unparkDeserialized", "Unparking deserialized fiber %s", (Object)f);
        f.unpark(SERIALIZER_BLOCKER);
        return f;
    }

    public static ByteArraySerializer getFiberSerializer() {
        return Fiber.getFiberSerializer(true);
    }

    public static ByteArraySerializer getFiberSerializer(boolean includeThreadLocals) {
        KryoSerializer s = new KryoSerializer();
        s.getKryo().addDefaultSerializer(Fiber.class, (Serializer)new FiberSerializer(includeThreadLocals));
        s.getKryo().addDefaultSerializer(ThreadLocal.class, (Serializer)new ThreadLocalSerializer());
        s.getKryo().addDefaultSerializer(FiberWriter.class, (Serializer)new FiberWriterSerializer());
        s.getKryo().register(Fiber.class);
        s.getKryo().register(ThreadLocal.class);
        s.getKryo().register(InheritableThreadLocal.class);
        s.getKryo().register(ThreadLocalSerializer.DEFAULT.class);
        s.getKryo().register(FiberWriter.class);
        return s;
    }

    static {
        if (Debug.isDebug()) {
            System.err.println("QUASAR WARNING: Debug mode enabled. This may harm performance.");
        }
        if (Debug.isAssertionsEnabled()) {
            System.err.println("QUASAR WARNING: Assertions enabled. This may harm performance.");
        }
        if (!SuspendableHelper.isJavaAgentActive() && !disableAgentWarning) {
            System.err.println("QUASAR WARNING: Quasar Java Agent isn't running. If you're using another instrumentation method you can ignore this message; otherwise, please refer to the Getting Started section in the Quasar documentation.");
        }
        assert (Fiber.printVerifyInstrumentationWarning());
        defaultUncaughtExceptionHandler = new Strand.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Strand s, Throwable e) {
                System.err.print("Exception in Fiber \"" + s.getName() + "\" ");
                if (e instanceof NullPointerException || e instanceof ClassCastException || Exceptions.unwrap(e) instanceof NullPointerException || Exceptions.unwrap(e) instanceof ClassCastException) {
                    System.err.println("If this exception looks strange, perhaps you've forgotten to instrument a blocking method. Run your program with -Dco.paralleluniverse.fibers.verifyInstrumentation to catch the culprit!");
                }
                System.err.println(e);
                Strand.printStackTrace(Fiber.threadToFiberStack(e.getStackTrace()), System.err);
                Fiber.checkInstrumentation(ExtendedStackTrace.of(e), true);
            }
        };
        idGen = new AtomicLong(10000000L);
        UNSAFE = UtilUnsafe.getUnsafe();
        try {
            stateOffset = UNSAFE.objectFieldOffset(Fiber.class.getDeclaredField("state"));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static class FiberSerializer
    extends Serializer<Fiber> {
        private boolean includeThreadLocals;

        public FiberSerializer(boolean includeThreadLocals) {
            this.includeThreadLocals = includeThreadLocals;
            this.setImmutable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Kryo kryo, Output output, Fiber f) {
            Thread currentThread = Thread.currentThread();
            if (!this.includeThreadLocals || f.noLocals) {
                Object tmpFiberLocals = f.fiberLocals;
                Object tmpInheritableFiberLocals = f.inheritableFiberLocals;
                f.fiberLocals = null;
                f.inheritableFiberLocals = null;
                try {
                    f.stack.resumeStack();
                    kryo.writeClass(output, f.getClass());
                    new FieldSerializer(kryo, f.getClass()).write(kryo, output, (Object)f);
                }
                finally {
                    f.fiberLocals = tmpFiberLocals;
                    f.inheritableFiberLocals = tmpInheritableFiberLocals;
                }
            }
            Object tmpThreadLocals = ThreadAccess.getThreadLocals(currentThread);
            Object tmpInheritableThreadLocals = ThreadAccess.getInheritableThreadLocals(currentThread);
            ThreadAccess.setThreadLocals(currentThread, f.fiberLocals);
            ThreadAccess.setInheritableThreadLocals(currentThread, f.inheritableFiberLocals);
            Object realFiberLocals = f.fiberLocals;
            Object realInheritableFiberLocals = f.inheritableFiberLocals;
            try {
                f.fiberLocals = realFiberLocals != null ? ThreadAccess.toMap(realFiberLocals).keySet().toArray() : null;
                f.inheritableFiberLocals = realInheritableFiberLocals != null ? ThreadAccess.toMap(realInheritableFiberLocals).keySet().toArray() : null;
                f.stack.resumeStack();
                kryo.writeClass(output, f.getClass());
                new FieldSerializer(kryo, f.getClass()).write(kryo, output, (Object)f);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            finally {
                f.fiberLocals = realFiberLocals;
                f.inheritableFiberLocals = realInheritableFiberLocals;
                ThreadAccess.setThreadLocals(currentThread, tmpThreadLocals);
                ThreadAccess.setInheritableThreadLocals(currentThread, tmpInheritableThreadLocals);
            }
        }

        public Fiber read(Kryo kryo, Input input, Class<Fiber> type) {
            Thread currentThread = Thread.currentThread();
            Object tmpThreadLocals = ThreadAccess.getThreadLocals(currentThread);
            Object tmpInheritableThreadLocals = ThreadAccess.getInheritableThreadLocals(currentThread);
            ThreadAccess.setThreadLocals(currentThread, null);
            ThreadAccess.setInheritableThreadLocals(currentThread, null);
            try {
                Registration reg = kryo.readClass(input);
                if (reg == null) {
                    Fiber fiber = null;
                    return fiber;
                }
                Fiber f = (Fiber)new FieldSerializer(kryo, reg.getType()).read(kryo, input, reg.getType());
                if (!f.noLocals) {
                    f.fiberLocals = ThreadAccess.getThreadLocals(currentThread);
                    f.inheritableFiberLocals = ThreadAccess.getInheritableThreadLocals(currentThread);
                }
                Fiber fiber = f;
                return fiber;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            finally {
                ThreadAccess.setThreadLocals(currentThread, tmpThreadLocals);
                ThreadAccess.setInheritableThreadLocals(currentThread, tmpInheritableThreadLocals);
            }
        }
    }

    static interface ParkAction {
        public void run(Fiber var1);
    }

    static final class DummyRunnable
    implements Runnable {
        final Fiber fiber;

        public DummyRunnable(Fiber fiber) {
            this.fiber = fiber;
        }

        @Override
        public void run() {
            throw new RuntimeException("This method shouldn't be run. This object is a placeholder.");
        }
    }
}

