/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Objects;

public class ExtendedStackTraceElement {
    private final String declaringClassName;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;
    private final int bci;
    Class<?> clazz;
    Member method;

    public ExtendedStackTraceElement(StackTraceElement ste) {
        this(ste, null, null, -1);
    }

    public ExtendedStackTraceElement(StackTraceElement ste, Class<?> clazz, Member method, int bci) {
        this(ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber(), clazz, method, bci);
    }

    public ExtendedStackTraceElement(Class<?> clazz, Method method, String fileName, int lineNumber, int bci) {
        this(clazz.getName(), method.getName(), fileName, lineNumber, clazz, method, bci);
    }

    public ExtendedStackTraceElement(String declaringClassName, String methodName, String fileName, int lineNumber, Class<?> clazz, Member method, int bci) {
        Objects.requireNonNull(declaringClassName, "Declaring class is null");
        Objects.requireNonNull(methodName, "Method name is null");
        if (clazz != null && !declaringClassName.equals(clazz.getName())) {
            throw new IllegalArgumentException("Class name mismatch: " + declaringClassName + ", " + clazz.getName());
        }
        if (method != null && !methodName.equals(method.getName())) {
            throw new IllegalArgumentException("Method name mismatch: " + methodName + ", " + method.getName());
        }
        this.declaringClassName = declaringClassName;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.clazz = clazz;
        this.bci = bci;
        this.method = method;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public int getBytecodeIndex() {
        return this.bci;
    }

    public Member getMethod() {
        return this.method;
    }

    public StackTraceElement getStackTraceElement() {
        return new StackTraceElement(this.declaringClassName, this.methodName, this.fileName, this.lineNumber);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExtendedStackTraceElement)) {
            return false;
        }
        ExtendedStackTraceElement e = (ExtendedStackTraceElement)obj;
        return e.declaringClassName.equals(this.declaringClassName) && e.lineNumber == this.lineNumber && Objects.equals(this.methodName, e.methodName) && Objects.equals(this.fileName, e.fileName);
    }

    public int hashCode() {
        int result = 31 * this.declaringClassName.hashCode() + this.methodName.hashCode();
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.lineNumber;
        return result;
    }

    public String toString() {
        return this.toString(this.method);
    }

    public String toString(Member m) {
        StringBuilder sb = new StringBuilder();
        if (m != null) {
            sb.append(ExtendedStackTraceElement.asString(m));
        } else {
            sb.append(this.getClassName()).append('.').append(this.methodName);
        }
        sb.append(' ');
        if (this.isNativeMethod()) {
            sb.append("(Native Method)");
        } else {
            sb.append('(');
            if (this.fileName != null) {
                sb.append(this.fileName);
                if (this.lineNumber >= 0) {
                    sb.append(':').append(this.lineNumber);
                }
            } else {
                sb.append("Unknown Source");
            }
            if (this.bci >= 0) {
                sb.append(" bci: ").append(this.bci);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private static String asString(Member method) {
        Class<?>[] paramTypes;
        StringBuilder sb = new StringBuilder();
        sb.append(ExtendedStackTraceElement.getTypeName(method.getDeclaringClass())).append('.').append(method.getName());
        sb.append('(');
        for (Class<?> type : paramTypes = ExtendedStackTraceElement.getParameterTypes(method)) {
            sb.append(ExtendedStackTraceElement.getTypeName(type)).append(',');
        }
        if (paramTypes.length > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append(')');
        return sb.toString();
    }

    private static Class<?>[] getParameterTypes(Member m) {
        if (m instanceof Constructor) {
            return ((Constructor)m).getParameterTypes();
        }
        return ((Method)m).getParameterTypes();
    }

    private static Class<?> getReturnType(Member m) {
        if (m instanceof Constructor) {
            return ((Constructor)m).getDeclaringClass();
        }
        return ((Method)m).getReturnType();
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }
}

