/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.IntSupplier;
import sandbox.java.util.function.Supplier;

public final class OptionalInt {
    private static final OptionalInt EMPTY;
    private final boolean isPresent;
    private final int value;

    private OptionalInt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.isPresent = false;
        this.value = 0;
    }

    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.isPresent = true;
        this.value = n;
    }

    public static OptionalInt of(int n) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/OptionalInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalInt.<init>:(I)V");
        return new OptionalInt(n);
    }

    public int getAsInt() {
        RuntimeCostAccounter.recordJump();
        if (!this.isPresent) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:(Ljava/lang/String;)V");
            NoSuchElementException noSuchElementException = new NoSuchElementException("No value present");
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(IntConsumer intConsumer) {
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
            intConsumer.accept(this.value);
        }
    }

    public int orElse(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            n2 = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n;
        }
        return n2;
    }

    public int orElseGet(IntSupplier intSupplier) {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            n = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntSupplier.getAsInt:()I");
            n = intSupplier.getAsInt();
        }
        return n;
    }

    public <X extends Throwable> int orElseThrow(Supplier<X> supplier) throws X {
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            return this.value;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        Throwable throwable = (Throwable)supplier.get();
        RuntimeCostAccounter.recordThrow();
        throw throwable;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl2 = object instanceof OptionalInt;
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            return false;
        }
        OptionalInt optionalInt = (OptionalInt)object;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            boolean bl3 = optionalInt.isPresent;
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                int n = optionalInt.value;
                RuntimeCostAccounter.recordJump();
                if (this.value == n) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
                bl = false;
                RuntimeCostAccounter.recordJump();
                return bl;
            }
        }
        boolean bl4 = optionalInt.isPresent;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent != bl4) return false;
        bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public int hashCode() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.hashCode:(I)I");
            n = Integer.hashCode(this.value);
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
            objectArray[0] = this.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            string = String.format("OptionalInt[%s]", objectArray);
            RuntimeCostAccounter.recordJump();
        } else {
            string = "OptionalInt.empty";
        }
        return string;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/OptionalInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalInt.<init>:()V");
        EMPTY = new OptionalInt();
    }
}

