/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DefaultFileSystem;
import sandbox.java.io.DeleteOnExitHook;
import sandbox.java.io.FileFilter;
import sandbox.java.io.FileSystem;
import sandbox.java.io.FilenameFilter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.net.MalformedURLException;
import sandbox.java.net.URI;
import sandbox.java.net.URISyntaxException;
import sandbox.java.net.URL;
import sandbox.java.nio.file.FileSystems;
import sandbox.java.nio.file.Path;
import sandbox.java.security.AccessController;
import sandbox.java.security.Permission;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.SecureRandom;
import sandbox.java.util.ArrayList;
import sandbox.sun.misc.Unsafe;
import sandbox.sun.security.action.GetPropertyAction;

public class File
implements Serializable,
Comparable<File> {
    private static final FileSystem fs;
    private final String path;
    private transient PathStatus status;
    private final transient int prefixLength;
    public static final char separatorChar;
    public static final String separator;
    public static final char pathSeparatorChar;
    public static final String pathSeparator;
    private static final long PATH_OFFSET;
    private static final long PREFIX_LENGTH_OFFSET;
    private static final Unsafe UNSAFE;
    private static final long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;
    static final /* synthetic */ boolean $assertionsDisabled;

    final boolean isInvalid() {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this.status == null) {
            PathStatus pathStatus;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
            int n = this.path.indexOf(0);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                pathStatus = PathStatus.CHECKED;
                RuntimeCostAccounter.recordJump();
            } else {
                pathStatus = PathStatus.INVALID;
            }
            this.status = pathStatus;
        }
        RuntimeCostAccounter.recordJump();
        if (this.status == PathStatus.INVALID) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String string, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.status = null;
        this.path = string;
        this.prefixLength = n;
    }

    private File(String string, File file) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.status = null;
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            String string2 = file.path;
            RuntimeCostAccounter.recordJump();
            if (string2 == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (!$assertionsDisabled) {
            String string3 = file.path;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = string3.equals("");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/AssertionError");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/AssertionError.<init>:()V");
                AssertionError assertionError = new AssertionError();
                RuntimeCostAccounter.recordThrow();
                throw assertionError;
            }
        }
        String string4 = file.path;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        this.path = fs.resolve(string4, string);
        this.prefixLength = file.prefixLength;
    }

    public File(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.status = null;
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
        this.path = fs.normalize(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String string, String string2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.status = null;
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = string.equals("");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getDefaultParent:()Ljava/lang/String;");
                String string3 = fs.getDefaultParent();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
                String string4 = fs.normalize(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                this.path = fs.resolve(string3, string4);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
                String string5 = fs.normalize(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
                String string6 = fs.normalize(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                this.path = fs.resolve(string5, string6);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
            this.path = fs.normalize(string2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File file, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.status = null;
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (file != null) {
            String string2 = file.path;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
            boolean bl = string2.equals("");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getDefaultParent:()Ljava/lang/String;");
                String string3 = fs.getDefaultParent();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
                String string4 = fs.normalize(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                this.path = fs.resolve(string3, string4);
                RuntimeCostAccounter.recordJump();
            } else {
                String string5 = file.path;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
                String string6 = fs.normalize(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
                this.path = fs.resolve(string5, string6);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
            this.path = fs.normalize(string);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uRI) {
        block11: {
            block10: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.status = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.isAbsolute:()Z");
                boolean bl = uRI.isAbsolute();
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI is not absolute");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.isOpaque:()Z");
                boolean bl2 = uRI.isOpaque();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI is not hierarchical");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.getScheme:()Ljava/lang/String;");
                String string = uRI.getScheme();
                RuntimeCostAccounter.recordJump();
                if (string == null) break block10;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
                boolean bl3 = string.equalsIgnoreCase("file");
                RuntimeCostAccounter.recordJump();
                if (bl3) break block11;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI scheme is not \"file\"");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.getAuthority:()Ljava/lang/String;");
        String string = uRI.getAuthority();
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI has an authority component");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.getFragment:()Ljava/lang/String;");
        String string2 = uRI.getFragment();
        RuntimeCostAccounter.recordJump();
        if (string2 != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI has a fragment component");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.getQuery:()Ljava/lang/String;");
        String string3 = uRI.getQuery();
        RuntimeCostAccounter.recordJump();
        if (string3 != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI has a query component");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.getPath:()Ljava/lang/String;");
        String string4 = uRI.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = string4.equals("");
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("URI path component is empty");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.fromURIPath:(Ljava/lang/String;)Ljava/lang/String;");
        string4 = fs.fromURIPath(string4);
        RuntimeCostAccounter.recordJump();
        if (separatorChar != '/') {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(CC)Ljava/lang/String;");
            string4 = string4.replace('/', separatorChar);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
        this.path = fs.normalize(string4);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(I)I");
        int n = this.path.lastIndexOf(separatorChar);
        RuntimeCostAccounter.recordJump();
        if (n < this.prefixLength) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
            return this.path.substring(this.prefixLength);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
        return this.path.substring(n + 1);
    }

    public String getParent() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.lastIndexOf:(I)I");
        int n = this.path.lastIndexOf(separatorChar);
        RuntimeCostAccounter.recordJump();
        if (n < this.prefixLength) {
            RuntimeCostAccounter.recordJump();
            if (this.prefixLength > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = this.path.length();
                RuntimeCostAccounter.recordJump();
                if (n2 > this.prefixLength) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                    return this.path.substring(0, this.prefixLength);
                }
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
        return this.path.substring(0, n);
    }

    public File getParentFile() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getParent:()Ljava/lang/String;");
        String string = this.getParent();
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            return null;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;I)V");
        return new File(string, this.prefixLength);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.isAbsolute:(Ljava/io/File;)Z");
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/io/File;)Ljava/lang/String;");
        return fs.resolve(this);
    }

    public File getAbsoluteFile() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getAbsolutePath:()Ljava/lang/String;");
        String string = this.getAbsolutePath();
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        int n = fs.prefixLength(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;I)V");
        return new File(string, n);
    }

    public String getCanonicalPath() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Invalid file path");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.resolve:(Ljava/io/File;)Ljava/lang/String;");
        String string = fs.resolve(this);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.canonicalize:(Ljava/lang/String;)Ljava/lang/String;");
        return fs.canonicalize(string);
    }

    public File getCanonicalFile() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalPath:()Ljava/lang/String;");
        String string = this.getCanonicalPath();
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        int n = fs.prefixLength(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;I)V");
        return new File(string, n);
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        RuntimeCostAccounter.recordJump();
        if (separatorChar != '/') {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(CC)Ljava/lang/String;");
            string2 = string2.replace(separatorChar, '/');
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
        boolean bl2 = string2.startsWith("/");
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("/");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string2 = stringBuilder3.toString();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
        boolean bl3 = string2.endsWith("/");
        RuntimeCostAccounter.recordJump();
        if (!bl3) {
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append("/");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string2 = stringBuilder5.toString();
            }
        }
        return string2;
    }

    @Deprecated
    public URL toURL() throws MalformedURLException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/net/MalformedURLException");
            RuntimeCostAccounter.recordMethodCall((String)"java/net/MalformedURLException.<init>:(Ljava/lang/String;)V");
            MalformedURLException malformedURLException = new MalformedURLException("Invalid file path");
            RuntimeCostAccounter.recordThrow();
            throw malformedURLException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/net/URL");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getAbsolutePath:()Ljava/lang/String;");
        String string = this.getAbsolutePath();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isDirectory:()Z");
        boolean bl2 = this.isDirectory();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.slashify:(Ljava/lang/String;Z)Ljava/lang/String;");
        String string2 = File.slashify(string, bl2);
        RuntimeCostAccounter.recordMethodCall((String)"java/net/URL.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        return new URL("file", "", string2);
    }

    public URI toURI() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getAbsoluteFile:()Ljava/io/File;");
            File file = this.getAbsoluteFile();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
            String string = file.getPath();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isDirectory:()Z");
            boolean bl = file.isDirectory();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.slashify:(Ljava/lang/String;Z)Ljava/lang/String;");
            String string2 = File.slashify(string, bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
            boolean bl2 = string2.startsWith("//");
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("//");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(string2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string2 = stringBuilder3.toString();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/net/URI");
            RuntimeCostAccounter.recordMethodCall((String)"java/net/URI.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
            return new URI("file", null, string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(uRISyntaxException);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
    }

    public boolean canRead() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.checkAccess:(Ljava/io/File;I)Z");
        return fs.checkAccess(this, 4);
    }

    public boolean canWrite() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.checkAccess:(Ljava/io/File;I)Z");
        return fs.checkAccess(this, 2);
    }

    public boolean exists() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl2 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getBooleanAttributes:(Ljava/io/File;)I");
        int n = fs.getBooleanAttributes(this) & 1;
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl2 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getBooleanAttributes:(Ljava/io/File;)I");
        int n = fs.getBooleanAttributes(this) & 4;
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isFile() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl2 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getBooleanAttributes:(Ljava/io/File;)I");
        int n = fs.getBooleanAttributes(this) & 2;
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isHidden() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl2 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getBooleanAttributes:(Ljava/io/File;)I");
        int n = fs.getBooleanAttributes(this) & 8;
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public long lastModified() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return 0L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getLastModifiedTime:(Ljava/io/File;)J");
        return fs.getLastModifiedTime(this);
    }

    public long length() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return 0L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getLength:(Ljava/io/File;)J");
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Invalid file path");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.createFileExclusively:(Ljava/lang/String;)Z");
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkDelete:(Ljava/lang/String;)V");
            securityManager.checkDelete(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.delete:(Ljava/io/File;)Z");
        return fs.delete(this);
    }

    public void deleteOnExit() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkDelete:(Ljava/lang/String;)V");
            securityManager.checkDelete(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DeleteOnExitHook.add:(Ljava/lang/String;)V");
        DeleteOnExitHook.add(this.path);
    }

    public String[] list() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.list:(Ljava/io/File;)[Ljava/lang/String;");
        return fs.list(this);
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray;
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.list:()[Ljava/lang/String;");
                stringArray = this.list();
                RuntimeCostAccounter.recordJump();
                if (stringArray == null) break block5;
                RuntimeCostAccounter.recordJump();
                if (filenameFilter != null) break block6;
            }
            return stringArray;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (true) {
            int n2 = stringArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            String string = stringArray[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilenameFilter.accept:(Ljava/io/File;Ljava/lang/String;)Z");
            boolean bl = filenameFilter.accept(this, string);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                String string2 = stringArray[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
                arrayList.add(string2);
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n3 = arrayList.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        String[] stringArray2 = new String[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return arrayList.toArray(stringArray2);
    }

    public File[] listFiles() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.list:()[Ljava/lang/String;");
        String[] stringArray = this.list();
        RuntimeCostAccounter.recordJump();
        if (stringArray == null) {
            return null;
        }
        int n2 = n = stringArray.length;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        File[] fileArray = new File[n2];
        int n3 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n3 >= n) break;
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            String string = stringArray[n3];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/io/File;)V");
            fileArray[n3] = new File(string, this);
            ++n3;
            RuntimeCostAccounter.recordJump();
        }
        return fileArray;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.list:()[Ljava/lang/String;");
        String[] stringArray = this.list();
        RuntimeCostAccounter.recordJump();
        if (stringArray == null) {
            return null;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (true) {
            block6: {
                String string;
                block5: {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    string = stringArray2[n2];
                    RuntimeCostAccounter.recordJump();
                    if (filenameFilter == null) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FilenameFilter.accept:(Ljava/io/File;Ljava/lang/String;)Z");
                    boolean bl = filenameFilter.accept(this, string);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block6;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/io/File;)V");
                File file = new File(string, this);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                arrayList.add(file);
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
        int n3 = arrayList.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        File[] fileArray = new File[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return arrayList.toArray(fileArray);
    }

    public File[] listFiles(FileFilter fileFilter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.list:()[Ljava/lang/String;");
        String[] stringArray = this.list();
        RuntimeCostAccounter.recordJump();
        if (stringArray == null) {
            return null;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (true) {
            block6: {
                File file;
                block5: {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    String string = stringArray2[n2];
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/io/File;)V");
                    file = new File(string, this);
                    RuntimeCostAccounter.recordJump();
                    if (fileFilter == null) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/FileFilter.accept:(Ljava/io/File;)Z");
                    boolean bl = fileFilter.accept(file);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block6;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
                arrayList.add(file);
            }
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
        int n3 = arrayList.size();
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        File[] fileArray = new File[n3];
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
        return arrayList.toArray(fileArray);
    }

    public boolean mkdir() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.createDirectory:(Ljava/io/File;)Z");
        return fs.createDirectory(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mkdirs() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
        boolean bl = this.exists();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.mkdir:()Z");
        boolean bl2 = this.mkdir();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            return true;
        }
        File file = null;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getCanonicalFile:()Ljava/io/File;");
            file = this.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getParentFile:()Ljava/io/File;");
        File file2 = file.getParentFile();
        RuntimeCostAccounter.recordJump();
        if (file2 == null) return false;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.mkdirs:()Z");
        boolean bl3 = file2.mkdirs();
        RuntimeCostAccounter.recordJump();
        if (!bl3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.exists:()Z");
            boolean bl4 = file2.exists();
            RuntimeCostAccounter.recordJump();
            if (!bl4) return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.mkdir:()Z");
        boolean bl5 = file.mkdir();
        RuntimeCostAccounter.recordJump();
        if (!bl5) return false;
        boolean bl6 = true;
        RuntimeCostAccounter.recordJump();
        return bl6;
    }

    public boolean renameTo(File file) {
        block6: {
            block5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
                SecurityManager securityManager = System.getSecurityManager();
                RuntimeCostAccounter.recordJump();
                if (securityManager != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
                    securityManager.checkWrite(this.path);
                    String string = file.path;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
                    securityManager.checkWrite(string);
                }
                RuntimeCostAccounter.recordJump();
                if (file == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
                boolean bl = this.isInvalid();
                RuntimeCostAccounter.recordJump();
                if (bl) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
                boolean bl2 = file.isInvalid();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break block6;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.rename:(Ljava/io/File;Ljava/io/File;)Z");
        return fs.rename(this, file);
    }

    public boolean setLastModified(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative time");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.setLastModifiedTime:(Ljava/io/File;J)Z");
        return fs.setLastModifiedTime(this, l);
    }

    public boolean setReadOnly() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.setReadOnly:(Ljava/io/File;)Z");
        return fs.setReadOnly(this);
    }

    public boolean setWritable(boolean bl, boolean bl2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl3 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.setPermission:(Ljava/io/File;IZZ)Z");
        return fs.setPermission(this, 2, bl, bl2);
    }

    public boolean setWritable(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.setWritable:(ZZ)Z");
        return this.setWritable(bl, true);
    }

    public boolean setReadable(boolean bl, boolean bl2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl3 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.setPermission:(Ljava/io/File;IZZ)Z");
        return fs.setPermission(this, 4, bl, bl2);
    }

    public boolean setReadable(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.setReadable:(ZZ)Z");
        return this.setReadable(bl, true);
    }

    public boolean setExecutable(boolean bl, boolean bl2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl3 = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.setPermission:(Ljava/io/File;IZZ)Z");
        return fs.setPermission(this, 1, bl, bl2);
    }

    public boolean setExecutable(boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.setExecutable:(ZZ)Z");
        return this.setExecutable(bl, true);
    }

    public boolean canExecute() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkExec:(Ljava/lang/String;)V");
            securityManager.checkExec(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.checkAccess:(Ljava/io/File;I)Z");
        return fs.checkAccess(this, 1);
    }

    public static File[] listRoots() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.listRoots:()[Ljava/io/File;");
        return fs.listRoots();
    }

    public long getTotalSpace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission = new RuntimePermission("getFileSystemAttributes");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)runtimePermission);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return 0L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getSpace:(Ljava/io/File;I)J");
        return fs.getSpace(this, 0);
    }

    public long getFreeSpace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission = new RuntimePermission("getFileSystemAttributes");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)runtimePermission);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return 0L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getSpace:(Ljava/io/File;I)J");
        return fs.getSpace(this, 1);
    }

    public long getUsableSpace() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimePermission");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimePermission.<init>:(Ljava/lang/String;)V");
            RuntimePermission runtimePermission = new RuntimePermission("getFileSystemAttributes");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkPermission:(Ljava/security/Permission;)V");
            securityManager.checkPermission((Permission)runtimePermission);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkRead:(Ljava/lang/String;)V");
            securityManager.checkRead(this.path);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl = this.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return 0L;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getSpace:(Ljava/io/File;I)J");
        return fs.getSpace(this, 2);
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2;
        int n;
        File file3;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n2 = string.length();
        RuntimeCostAccounter.recordJump();
        if (n2 < 3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Prefix string too short");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            string2 = ".tmp";
        }
        RuntimeCostAccounter.recordJump();
        if (file != null) {
            file3 = file;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File$TempDirectory.location:()Ljava/io/File;");
            file3 = TempDirectory.location();
        }
        File file4 = file3;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File$TempDirectory.generateFile:(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)Ljava/io/File;");
            file2 = TempDirectory.generateFile(string, string2, file4);
            RuntimeCostAccounter.recordJump();
            if (securityManager != null) {
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
                    String string3 = file2.getPath();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
                    securityManager.checkWrite(string3);
                }
                catch (SecurityException securityException) {
                    RuntimeCostAccounter.recordJump();
                    if (file == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/SecurityException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityException.<init>:(Ljava/lang/String;)V");
                        SecurityException securityException2 = new SecurityException("Unable to create temporary file");
                        RuntimeCostAccounter.recordThrow();
                        throw securityException2;
                    }
                    RuntimeCostAccounter.recordThrow();
                    throw securityException;
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getBooleanAttributes:(Ljava/io/File;)I");
            n = fs.getBooleanAttributes(file2) & 1;
            RuntimeCostAccounter.recordJump();
        } while (n != 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        String string4 = file2.getPath();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.createFileExclusively:(Ljava/lang/String;)Z");
        boolean bl = fs.createFileExclusively(string4);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Unable to create temporary file");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        return file2;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.createTempFile:(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)Ljava/io/File;");
        return File.createTempFile(string, string2, null);
    }

    @Override
    public int compareTo(File file) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.compare:(Ljava/io/File;Ljava/io/File;)I");
        return fs.compare(this, file);
    }

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object != null) {
            boolean bl = object instanceof File;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                boolean bl2;
                File file = (File)object;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.compareTo:(Ljava/io/File;)I");
                int n = this.compareTo(file);
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    bl2 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    bl2 = false;
                }
                return bl2;
            }
        }
        return false;
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.hashCode:(Ljava/io/File;)I");
        return fs.hashCode(this);
    }

    public String toString() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeChar:(I)V");
        objectOutputStream.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readFields:()Ljava/io/ObjectInputStream$GetField;");
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        String string = (String)getField.get("path", null);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readChar:()C");
        char c = objectInputStream.readChar();
        RuntimeCostAccounter.recordJump();
        if (c != separatorChar) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(CC)Ljava/lang/String;");
            string = string.replace(c, separatorChar);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.normalize:(Ljava/lang/String;)Ljava/lang/String;");
        String string2 = fs.normalize(string);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
        UNSAFE.putObject((Object)this, PATH_OFFSET, (Object)string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.prefixLength:(Ljava/lang/String;)I");
        int n = fs.prefixLength(string2);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putIntVolatile:(Ljava/lang/Object;JI)V");
        UNSAFE.putIntVolatile((Object)this, PREFIX_LENGTH_OFFSET, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path toPath() {
        Path path = this.filePath;
        RuntimeCostAccounter.recordJump();
        if (path == null) {
            block3: {
                File file = this;
                try {
                    path = this.filePath;
                    RuntimeCostAccounter.recordJump();
                    if (path != null) break block3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/FileSystems.getDefault:()Ljava/nio/file/FileSystem;");
                    sandbox.java.nio.file.FileSystem fileSystem = FileSystems.getDefault();
                    RuntimeCostAccounter.recordArrayAllocation((int)0, (int)8);
                    String[] stringArray = new String[]{};
                    RuntimeCostAccounter.recordMethodCall((String)"java/nio/file/FileSystem.getPath:(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;");
                    this.filePath = path = fileSystem.getPath(this.path, stringArray);
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        return path;
    }

    static {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.desiredAssertionStatus:()Z");
        boolean bl2 = File.class.desiredAssertionStatus();
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        $assertionsDisabled = bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DefaultFileSystem.getFileSystem:()Ljava/io/FileSystem;");
        fs = DefaultFileSystem.getFileSystem();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getSeparator:()C");
        separatorChar = fs.getSeparator();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(separatorChar);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        separator = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileSystem.getPathSeparator:()C");
        pathSeparatorChar = fs.getPathSeparator();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder4 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append("");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(pathSeparatorChar);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        pathSeparator = stringBuilder6.toString();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            Unsafe unsafe = Unsafe.getUnsafe();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = File.class.getDeclaredField("path");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PATH_OFFSET = unsafe.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = File.class.getDeclaredField("prefixLength");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PREFIX_LENGTH_OFFSET = unsafe.objectFieldOffset(field2);
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(reflectiveOperationException);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    private static class TempDirectory {
        private static final File tmpdir;
        private static final SecureRandom random;

        private TempDirectory() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        }

        static File location() {
            return tmpdir;
        }

        static File generateFile(String string, String string2, File file) throws IOException {
            File file2;
            block7: {
                block6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/security/SecureRandom.nextLong:()J");
                    long l = random.nextLong();
                    RuntimeCostAccounter.recordJump();
                    if (l == Long.MIN_VALUE) {
                        l = 0L;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
                        l = Math.abs(l);
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
                    File file3 = new File(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getName:()Ljava/lang/String;");
                    string = file3.getName();
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
                    String string3 = Long.toString(l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(string3);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append(string2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string4 = stringBuilder4.toString();
                    RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/io/File;Ljava/lang/String;)V");
                    file2 = new File(file, string4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getName:()Ljava/lang/String;");
                    String string5 = file2.getName();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                    boolean bl = string4.equals(string5);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block6;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
                    boolean bl2 = file2.isInvalid();
                    RuntimeCostAccounter.recordJump();
                    if (!bl2) break block7;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
                SecurityManager securityManager = System.getSecurityManager();
                RuntimeCostAccounter.recordJump();
                if (securityManager != null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                    IOException iOException = new IOException("Unable to create temporary file");
                    RuntimeCostAccounter.recordThrow();
                    throw iOException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder.append("Unable to create temporary file, ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(file2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string6 = stringBuilder6.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException(string6);
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            return file2;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
            RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
            GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
            String string = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
            tmpdir = new File(string);
            RuntimeCostAccounter.recordAllocation((String)"java/security/SecureRandom");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/SecureRandom.<init>:()V");
            random = new SecureRandom();
        }
    }

    private static final class PathStatus
    extends Enum<PathStatus> {
        public static final /* enum */ PathStatus INVALID;
        public static final /* enum */ PathStatus CHECKED;
        private static final /* synthetic */ PathStatus[] $VALUES;

        /*
         * Exception decompiling
         */
        public static PathStatus[] values() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Invalid type string [s
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils.decodeTypeTok(ConstantPoolUtils.java:101)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.convertFromString(ConstantPoolEntryClass.java:52)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.getTypeInstance(ConstantPoolEntryClass.java:61)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef.getMethodPrototype(ConstantPoolEntryMethodRef.java:72)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvoke(Op02WithProcessedDataAndRefs.java:331)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1224)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static PathStatus valueOf(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.valueOf:(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
            return Enum.valueOf(PathStatus.class, string);
        }

        private PathStatus() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.<init>:(Ljava/lang/String;I)V");
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/io/File$PathStatus");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File$PathStatus.<init>:(Ljava/lang/String;I)V");
            INVALID = new PathStatus();
            RuntimeCostAccounter.recordAllocation((String)"java/io/File$PathStatus");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File$PathStatus.<init>:(Ljava/lang/String;I)V");
            CHECKED = new PathStatus();
            RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
            $VALUES = new PathStatus[]{INVALID, CHECKED};
        }
    }
}

