/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for linkis_ps_variable_key_user
-- ----------------------------
DROP TABLE IF EXISTS `linkis_ps_variable_key_user`;
CREATE TABLE `linkis_ps_variable_key_user`
(
    `id`             bigint(20) NOT NULL AUTO_INCREMENT,
    `application_id` bigint(20)   DEFAULT NULL COMMENT 'Reserved word',
    `key_id`         bigint(20)   DEFAULT NULL,
    `user_name`      varchar(50)  DEFAULT NULL,
    `value`          varchar(200) DEFAULT NULL COMMENT 'Value of the global variable',
    PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `linkis_ps_variable_key`;
CREATE TABLE `linkis_ps_variable_key`
(
    `id`             bigint(20) NOT NULL AUTO_INCREMENT,
    `key`            varchar(50)  DEFAULT NULL COMMENT 'Key of the global variable',
    `description`    varchar(200) DEFAULT NULL COMMENT 'Reserved word',
    `name`           varchar(50)  DEFAULT NULL COMMENT 'Reserved word',
    `application_id` bigint(20)   DEFAULT NULL COMMENT 'Reserved word',
    `default_value`  varchar(200) DEFAULT NULL COMMENT 'Reserved word',
    `value_type`     varchar(50)  DEFAULT NULL COMMENT 'Reserved word',
    `value_regex`    varchar(100) DEFAULT NULL COMMENT 'Reserved word',
    PRIMARY KEY (`id`)
);