/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.cli.application.interactor.job.data;

import org.apache.linkis.cli.application.observer.listener.LinkisClientListener;

public interface LinkisLogData extends LinkisJobData, Cloneable {

  void notifyLogListener();

  void registerincLogListener(LinkisClientListener observer);

  String getLogPath();

  Integer getNextLogLineIdx();

  void setHasNextLogLine(Boolean hasNextLog);

  Boolean hasNextLogLine();

  String consumeLog();

  boolean isIncLogMode();

  /*
  incLogMode = true: for sync-submission, wait for job complete while get incremental log
  incLogMode = false: for async-submission, output all log we have currently
  */
  void setIncLogMode(boolean incLogMode);

  void sendLogFin();

  boolean logFinReceived();

  LinkisLogData clone() throws CloneNotSupportedException;
}
