# Generated tests

The tests under the `./generated` directory are auto-generated by translating our internal Object Model test suite from C# (NUnit) to Python (pytest). Therefore, these tests should not be modified manually. If you find an issue with any of these tests, please submit an issue to this repository and it will be addressed upstream on the C# side.

## Running the generated tests

The tests can be run using the [pytest](https://docs.pytest.org/) framework. In addition to the regular `pytest` command line options, you can also specify:
- `--target [StkX|StkXNoGfx|Stk]`: Specifies how STK is run.
   * The `StkX` option starts STK Engine in-process using a `Tkinter` form with a globe and a map. This works on both Windows and Linux.
   * The `StkXNoGfx` option (default) uses STK Engine in-process and in headless mode. This works on both Windows and Linux.
   * The `Stk` option is only available on Windows and starts STK Desktop out-of-process.
- `--include [category]`: Only run a test if it belongs to the specified category. Repeat the option for multiple categories.
- `--exclude [category]`: Skip the test if belongs to the specified category. Repeat the option for multiple categories.

To list the various categories available, use the following command, changing the directory based on the test suite you are interested in (this example lists the categories available in the aviator tests):

```bash
find ./generated/aviator_tests -name *.py -exec grep "@category" {} \; | sed -r 's/.*"(.*)".*/\1/g' | sort --unique
```

To run the tests on Linux, the `ExcludeOnLinux` category needs to be excluded, which can be accomplished using:

```bash
pytest ./generated/aviator_tests --exclude ExcludeOnLinux
```

To exclude graphics tests, there are two categories that need to be excluded:
* Graphics Tests
* VO Tests

This can be accomplished using:

```bash
pytest ./generated/stk_tests --exclude "Graphics Tests" --exclude "VO Tests"
```



