# Copyright (C) 2022 - 2025 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""The following is an overview of the classes, interfaces and enumerations of the STK Object Model."""

__all__ = ["AberrationType", "Access", "AccessAdvancedSettings", "AccessAllowedTimeIntervals", "AccessConstraint",
"AccessConstraintAnalysisWorkbench", "AccessConstraintAnalysisWorkbenchCollection",
"AccessConstraintAnalysisWorkbenchComponent", "AccessConstraintAngle", "AccessConstraintBackground",
"AccessConstraintCentralBodyObstruction", "AccessConstraintCollection", "AccessConstraintCondition",
"AccessConstraintExclZonesCollection", "AccessConstraintGrazingAltitude", "AccessConstraintGroundTrack",
"AccessConstraintIntervals", "AccessConstraintLatitudeLongitudeZone", "AccessConstraintMinMaxBase",
"AccessConstraintObjExAngle", "AccessConstraintPluginMinMax", "AccessConstraintThirdBody",
"AccessConstraintTimeSlipRange", "AccessConstraintType", "AccessEventDetection", "AccessGraphics", "AccessSampling",
"AccessTargetTime", "AccessTargetTimesCollection", "AccessTimePeriod", "AccessTimeType", "ActionType",
"AdditionalGainLoss", "AdditionalGainLossCollection", "AdvCAT", "AdvCATAdvancedEllipsoid", "AdvCATAdvancedSettings",
"AdvCATAvailableObjectCollection", "AdvCATChosenObject", "AdvCATChosenObjectCollection", "AdvCATConjunctionType",
"AdvCATEllipsoidClassType", "AdvCATGraphics3D", "AdvCATPreFilters", "AdvCATSecondaryEllipsoidsVisibilityType",
"Aircraft", "AircraftExportTools", "AircraftGraphics", "AircraftGraphics3D", "AircraftWGS84WarningType",
"AltitudeReferenceType", "AnalysisWorkbenchAccessConstraintType", "AnimationActionType", "AnimationDirectionType",
"AnimationEndTimeMode", "AnimationOptionType", "Antenna", "AntennaBeam", "AntennaBeamCollection",
"AntennaBeamSelectionStrategy", "AntennaBeamSelectionStrategyAggregate", "AntennaBeamSelectionStrategyMaximumGain",
"AntennaBeamSelectionStrategyMinimumBoresightAngle", "AntennaBeamSelectionStrategyScriptPlugin", "AntennaBeamTransmit",
"AntennaContourEIRP", "AntennaContourFluxDensity", "AntennaContourGain", "AntennaContourGraphics",
"AntennaContourLevel", "AntennaContourLevelCollection", "AntennaContourRIP", "AntennaContourSpectralFluxDensity",
"AntennaContourType", "AntennaControl", "AntennaControlReferenceType", "AntennaGraphics", "AntennaGraphics3D",
"AntennaGraphicsCoordinateSystem", "AntennaModel", "AntennaModelANSYSffdFormat", "AntennaModelApertureCircularBessel",
"AntennaModelApertureCircularBesselEnvelope", "AntennaModelApertureCircularCosine",
"AntennaModelApertureCircularCosinePedestal", "AntennaModelApertureCircularCosineSquared",
"AntennaModelApertureCircularCosineSquaredPedestal", "AntennaModelApertureCircularSincIntegerPower",
"AntennaModelApertureCircularSincRealPower", "AntennaModelApertureCircularUniform",
"AntennaModelApertureRectangularCosine", "AntennaModelApertureRectangularCosinePedestal",
"AntennaModelApertureRectangularCosineSquared", "AntennaModelApertureRectangularCosineSquaredPedestal",
"AntennaModelApertureRectangularSincIntegerPower", "AntennaModelApertureRectangularSincRealPower",
"AntennaModelApertureRectangularUniform", "AntennaModelCosecantSquared", "AntennaModelCosecantSquaredSidelobeType",
"AntennaModelDipole", "AntennaModelElevationAzimuthCuts", "AntennaModelExternal", "AntennaModelGIMROC",
"AntennaModelGPSFRPA", "AntennaModelGPSGlobal", "AntennaModelGaussian", "AntennaModelHelix",
"AntennaModelHemispherical", "AntennaModelHfssEepArray", "AntennaModelIEEE1979", "AntennaModelITUBO1213CoPolar",
"AntennaModelITUBO1213CrossPolar", "AntennaModelITUF1245", "AntennaModelITUS1528R12Circular",
"AntennaModelITUS1528R12Rectangular", "AntennaModelITUS1528R13", "AntennaModelITUS465", "AntennaModelITUS580",
"AntennaModelITUS672Circular", "AntennaModelITUS672Rectangular", "AntennaModelITUS731", "AntennaModelInputType",
"AntennaModelIntelSat", "AntennaModelIsotropic", "AntennaModelOpticalGaussian", "AntennaModelOpticalSimple",
"AntennaModelParabolic", "AntennaModelPencilBeam", "AntennaModelPhasedArray", "AntennaModelRectangularPattern",
"AntennaModelRemcomUanFormat", "AntennaModelScriptPlugin", "AntennaModelSquareHorn", "AntennaModelTicraGRASPFormat",
"AntennaModelType", "AntennaNoiseTemperature", "AntennaSystem", "AntennaVolumeGraphics", "AntennaVolumeLevel",
"AntennaVolumeLevelCollection", "AreaTarget", "AreaTargetCommonTasks", "AreaTargetGraphics", "AreaTargetGraphics3D",
"AreaType", "AreaTypeEllipse", "AreaTypePattern", "AreaTypePatternCollection", "Atmosphere",
"AtmosphericAbsorptionModel", "AtmosphericAbsorptionModelCOMPlugin", "AtmosphericAbsorptionModelGraphics3DACAP",
"AtmosphericAbsorptionModelITURP676Version13", "AtmosphericAbsorptionModelITURP676Version9",
"AtmosphericAbsorptionModelScriptPlugin", "AtmosphericAbsorptionModelSimpleSatcom",
"AtmosphericAbsorptionModelTIREM320", "AtmosphericAbsorptionModelTIREM331", "AtmosphericAbsorptionModelTIREM550",
"AtmosphericAbsorptionModelType", "AtmosphericDensityModel", "AtmosphericTurbulenceModel",
"AtmosphericTurbulenceModelConstant", "AtmosphericTurbulenceModelHufnagelValley", "AtmosphericTurbulenceModelType",
"AttitudeCoordinateAxes", "AttitudeInclude", "AttitudeProfile", "AttitudeProfileAlignedAndConstrained",
"AttitudeProfileAlignmentOffset", "AttitudeProfileAviator", "AttitudeProfileConstraintOffset",
"AttitudeProfileCoordinatedTurn", "AttitudeProfileFixedInAxes", "AttitudeProfileGPS", "AttitudeProfileInertial",
"AttitudeProfilePrecessingSpin", "AttitudeProfileSpinAboutSettings", "AttitudeProfileSpinning",
"AttitudeProfileYawToNadir", "AttitudeScheduleTimesCollection", "AttitudeScheduleTimesElement", "AttitudeStandardBasic",
"AttitudeStandardOrbit", "AttitudeStandardRoute", "AttitudeStandardTrajectory", "AttitudeStandardType",
"AttitudeTorque", "AvailableFeatures", "AxisOffset", "AzElMaskType", "BasicAzElMask", "BeamSelectionStrategyType",
"Beamformer", "BeamformerASCIIFile", "BeamformerBlackmanHarris", "BeamformerCosine", "BeamformerCosineX",
"BeamformerCustomTaperFile", "BeamformerDolphChebyshev", "BeamformerHamming", "BeamformerHann", "BeamformerMVDR",
"BeamformerRaisedCosine", "BeamformerRaisedCosineSquared", "BeamformerScript", "BeamformerTaylor", "BeamformerType",
"BeamformerUniform", "BeerBouguerLambertLawLayer", "BeerBouguerLambertLawLayerCollection",
"BorderWallUpperLowerEdgeAltitudeReference", "BoresightType", "BuildHeightReferenceMethod", "BuildingHeightUnit",
"CCSDSDateFormat", "CCSDSEphemerisFormatType", "CCSDSReferenceFrame", "CCSDSTimeSystem", "CentralBody",
"CentralBodyCollection", "CentralBodyEllipsoid", "CentralBodyTerrainCollection", "CentralBodyTerrainCollectionElement",
"Chain", "ChainConnection", "ChainConnectionCollection", "ChainConstellationConstraintsMode", "ChainConstraints",
"ChainCoverageAssetMode", "ChainGraphics", "ChainGraphics2DAnimation", "ChainGraphics2DStatic", "ChainGraphics3D",
"ChainOptimalStrandCalculationScalarMetricType", "ChainOptimalStrandCompareStrandsType",
"ChainOptimalStrandLinkCompareType", "ChainOptimalStrandMetricType", "ChainOptimalStrandOpts",
"ChainParentPlatformRestriction", "ChainTimePeriod", "ChainTimePeriodType", "ChainUserSpecifiedTimePeriod",
"CircularApertureInputType", "ClassicalLocation", "ClassicalLocationArgumentOfLatitude",
"ClassicalLocationEccentricAnomaly", "ClassicalLocationMeanAnomaly", "ClassicalLocationTimePastAscendingNode",
"ClassicalLocationTimePastPerigee", "ClassicalLocationTrueAnomaly", "ClassicalOrientation", "ClassicalSizeShape",
"ClassicalSizeShapeAltitude", "ClassicalSizeShapeMeanMotion", "ClassicalSizeShapePeriod", "ClassicalSizeShapeRadius",
"ClassicalSizeShapeSemimajorAxis", "CloudsAndFogFadingLossModel", "CloudsAndFogFadingLossModelP840Version6",
"CloudsAndFogFadingLossModelP840Version7", "CloudsAndFogFadingLossModelType", "CloudsAndFogLiquidWaterChoiceType",
"CommRadCartesianLocation", "CommRadComplexNumber", "CommRadComplexNumberCollection", "CommRadPluginConfiguration",
"CommSystem", "CommSystemAccessEventDetection", "CommSystemAccessEventDetectionSamplesOnly",
"CommSystemAccessEventDetectionSubsample", "CommSystemAccessEventDetectionType", "CommSystemAccessOptions",
"CommSystemAccessSamplingMethod", "CommSystemAccessSamplingMethodAdaptive", "CommSystemAccessSamplingMethodFixed",
"CommSystemAccessSamplingMethodType", "CommSystemConstrainingRole", "CommSystemGraphics", "CommSystemGraphics3D",
"CommSystemLinkSelectionCriteria", "CommSystemLinkSelectionCriteriaMaximumElevation",
"CommSystemLinkSelectionCriteriaMinimumRange", "CommSystemLinkSelectionCriteriaScriptPlugin",
"CommSystemLinkSelectionCriteriaType", "CommSystemReferenceBandwidth", "CommSystemSaveMode", "Component",
"ComponentAttrLinkEmbedControl", "ComponentDirectory", "ComponentInfo", "ComponentInfoCollection",
"ComponentLinkEmbedControlReferenceType", "ConnectAuthenticationMode", "Constants", "Constellation",
"ConstellationConstraintObjectRestriction", "ConstellationConstraintRestriction",
"ConstellationConstraintRestrictionType", "ConstellationConstraints", "ConstellationFromToParentConstraint",
"ConstellationGraphics", "ConstellationRouting", "ConstraintBackground", "ConstraintGroundTrack", "ConstraintLighting",
"Coverage3dDrawAtAltitudeMode", "CoverageAdvancedSettings", "CoverageAltitudeMethod", "CoverageAreaTargetsCollection",
"CoverageAssetGrouping", "CoverageAssetListCollection", "CoverageAssetListElement", "CoverageAssetStatus",
"CoverageBounds", "CoverageBoundsCustomBoundary", "CoverageBoundsCustomRegions", "CoverageBoundsGlobal",
"CoverageBoundsLatitude", "CoverageBoundsLatitudeLine", "CoverageBoundsLatitudeLongitudeRegion",
"CoverageBoundsLongitudeLine", "CoverageCustomRegionAlgorithm", "CoverageDataRetention", "CoverageDefinition",
"CoverageEllipse", "CoverageEllipseCollection", "CoverageGraphics", "CoverageGraphics2DAnimation",
"CoverageGraphics2DProgress", "CoverageGraphics2DStatic", "CoverageGraphics3D", "CoverageGraphics3DAttributes",
"CoverageGrid", "CoverageGridClass", "CoverageGridInspector", "CoverageGridPointSelection",
"CoverageGroundAltitudeMethod", "CoverageInterval", "CoverageLatLonBox", "CoverageLatLonBoxCollection",
"CoveragePointAltitudeMethod", "CoveragePointDefinition", "CoveragePointFileListCollection",
"CoveragePointLocationMethod", "CoverageRegionAccessAccelerationType", "CoverageRegionFilesCollection",
"CoverageResolution", "CoverageResolutionArea", "CoverageResolutionDistance", "CoverageResolutionLatLon",
"CoverageSatisfactionType", "CoverageSelectedGridPoint", "CustomPropagationModel", "DataProviderCollection",
"DataProviderElement", "DataProviderElementType", "DataProviderElements", "DataProviderFixed", "DataProviderGroup",
"DataProviderInterval", "DataProviderResult", "DataProviderResultCategory", "DataProviderResultDataSet",
"DataProviderResultDataSetCollection", "DataProviderResultInterval", "DataProviderResultIntervalCollection",
"DataProviderResultStatisticResult", "DataProviderResultStatistics", "DataProviderResultSubSection",
"DataProviderResultSubSectionCollection", "DataProviderResultTextMessage", "DataProviderResultTimeArrayElements",
"DataProviderResultTimeVaryingExtremumResult", "DataProviderTimeVarying", "DataProviderType", "DataProviders",
"DataSaveMode", "DelaunayG", "DelaunayGOverSQRTmu", "DelaunayGType", "DelaunayH", "DelaunayHOverSQRTmu",
"DelaunayHType", "DelaunayL", "DelaunayLOverSQRTmu", "DelaunayLType", "DemodulatorModel", "DemodulatorModel16PSK",
"DemodulatorModel8PSK", "DemodulatorModelBOC", "DemodulatorModelBPSK", "DemodulatorModelDPSK",
"DemodulatorModelExternal", "DemodulatorModelExternalSource", "DemodulatorModelFSK", "DemodulatorModelMSK",
"DemodulatorModelNFSK", "DemodulatorModelNarrowbandUniform", "DemodulatorModelOQPSK", "DemodulatorModelPulsedSignal",
"DemodulatorModelQAM1024", "DemodulatorModelQAM128", "DemodulatorModelQAM16", "DemodulatorModelQAM256",
"DemodulatorModelQAM32", "DemodulatorModelQAM64", "DemodulatorModelQPSK", "DemodulatorModelScriptPlugin",
"DemodulatorModelType", "DemodulatorModelWidebandGaussian", "DemodulatorModelWidebandUniform", "DeticPositionType",
"DeticSizeAltitude", "DeticSizeRadius", "DirectionProvider", "DirectionProviderASCIIFile", "DirectionProviderLink",
"DirectionProviderObject", "DirectionProviderScript", "DirectionProviderType", "DisplayTimesDuringAccess",
"DisplayTimesTimeComponent", "DisplayTimesType", "DistanceOnSphere", "DragModel", "EOIR", "EOIRFlightType",
"EOIRMaterialElement", "EOIRMaterialElementCollection", "EOIRShape", "EOIRShapeBox", "EOIRShapeCollection",
"EOIRShapeCone", "EOIRShapeCoupler", "EOIRShapeCustomMesh", "EOIRShapeCylinder", "EOIRShapeGEOComm", "EOIRShapeLEOComm",
"EOIRShapeLEOImaging", "EOIRShapeMaterialSpecificationType", "EOIRShapeNone", "EOIRShapeObject", "EOIRShapePlate",
"EOIRShapeSphere", "EOIRShapeTargetSignature", "EOIRShapeType", "EOIRStage", "EOIRStagePlume", "EOIRThermalModelType",
"Element", "ElementCollection", "ElementConfiguration", "ElementConfigurationASCIIFile", "ElementConfigurationCircular",
"ElementConfigurationHexagon", "ElementConfigurationHfssEepFile", "ElementConfigurationLinear",
"ElementConfigurationPolygon", "ElementConfigurationType", "EphemExportToolFileFormat", "EphemSourceType",
"EphemerisCoordinateSystemType", "EphemerisCovarianceType", "EquinoctialFormulation", "EquinoctialSizeShape",
"EquinoctialSizeShapeMeanMotion", "EquinoctialSizeShapeSemimajorAxis", "ErrorCode", "EventDetection",
"EventDetectionNoSubSampling", "EventDetectionSubSampling", "ExportToolStepSize", "ExportToolStepSizeType",
"ExportToolTimePeriod", "ExportToolTimePeriodType", "ExportToolVersionFormat", "ExternalEphemerisFormatType",
"ExternalFileMessageLevelType", "Facility", "FacilityGraphics", "FacilityGraphics3D", "FigureOfMerit",
"FigureOfMeritAcrossAssets", "FigureOfMeritAssetListCollection", "FigureOfMeritAssetListElement",
"FigureOfMeritCompute", "FigureOfMeritConstraintName", "FigureOfMeritDefinitionAccessConstraint",
"FigureOfMeritDefinitionAccessSeparation", "FigureOfMeritDefinitionAgeOfData", "FigureOfMeritDefinitionCompute",
"FigureOfMeritDefinitionDataBest4", "FigureOfMeritDefinitionDataBestN", "FigureOfMeritDefinitionDataMinimumMaximum",
"FigureOfMeritDefinitionDataMinimumNumberOfAssets", "FigureOfMeritDefinitionDataPercentLevel",
"FigureOfMeritDefinitionDilutionOfPrecision", "FigureOfMeritDefinitionNavigationAccuracy",
"FigureOfMeritDefinitionResponseTime", "FigureOfMeritDefinitionRevisitTime", "FigureOfMeritDefinitionScalarCalculation",
"FigureOfMeritDefinitionSimpleCoverage", "FigureOfMeritDefinitionSystemAgeOfData",
"FigureOfMeritDefinitionSystemResponseTime", "FigureOfMeritDefinitionTimeAverageGap", "FigureOfMeritDefinitionType",
"FigureOfMeritEndGapOption", "FigureOfMeritGraphics", "FigureOfMeritGraphics2DAccumulation",
"FigureOfMeritGraphics2DAttributes", "FigureOfMeritGraphics2DAttributesAnimation", "FigureOfMeritGraphics2DColorMethod",
"FigureOfMeritGraphics2DColorOptions", "FigureOfMeritGraphics2DContourType", "FigureOfMeritGraphics2DContours",
"FigureOfMeritGraphics2DContoursAnimation", "FigureOfMeritGraphics2DDirection",
"FigureOfMeritGraphics2DFloatingPointFormat", "FigureOfMeritGraphics2DLegend", "FigureOfMeritGraphics2DLegendWindow",
"FigureOfMeritGraphics2DLevelAttributesCollection", "FigureOfMeritGraphics2DLevelAttributesElement",
"FigureOfMeritGraphics2DPositionOnMap", "FigureOfMeritGraphics2DRampColor", "FigureOfMeritGraphics2DRangeColorOptions",
"FigureOfMeritGraphics2DTextOptions", "FigureOfMeritGraphics3D", "FigureOfMeritGraphics3DAttributes",
"FigureOfMeritGraphics3DLegendWindow", "FigureOfMeritGridInspector", "FigureOfMeritInvalidValueActionType",
"FigureOfMeritMethod", "FigureOfMeritNavigationAccuracyMethod", "FigureOfMeritNavigationAccuracyMethodConstant",
"FigureOfMeritNavigationAccuracyMethodElevationAngle", "FigureOfMeritNavigationComputeType",
"FigureOfMeritSatisfaction", "FigureOfMeritSatisfactionType", "FigureOfMeritUncertainties",
"FrequencySpecificationType", "GPSAttitudeModelType", "GPSReferenceWeek", "GeodeticSize", "GeometricElementType",
"Graphics2DRangeContours", "Graphics3DACAPCoefficientDataType", "Graphics3DACAPSolarActivityConfigurationType",
"Graphics3DArticulationFile", "Graphics3DAzElMask", "Graphics3DBorderWall", "Graphics3DDataDisplayCollection",
"Graphics3DDataDisplayElement", "Graphics3DDetailThreshold", "Graphics3DFontSize", "Graphics3DFormat",
"Graphics3DLabelSwapDistance", "Graphics3DLabelSwapDistanceType", "Graphics3DLocation", "Graphics3DMarker",
"Graphics3DMarkerFile", "Graphics3DMarkerOrientation", "Graphics3DMarkerOriginType", "Graphics3DMarkerShape",
"Graphics3DModelArticulation", "Graphics3DModelCollection", "Graphics3DModelFile", "Graphics3DModelItem",
"Graphics3DModelPointing", "Graphics3DModelTransformation", "Graphics3DModelTransformationCollection",
"Graphics3DModelglTFImageBased", "Graphics3DOffset", "Graphics3DOffsetAttachment", "Graphics3DOffsetLabel",
"Graphics3DOffsetRotate", "Graphics3DOffsetTransformation", "Graphics3DPointableElementsCollection",
"Graphics3DPointableElementsElement", "Graphics3DRangeContours", "Graphics3DReferenceAngle", "Graphics3DReferenceAxes",
"Graphics3DReferencePlane", "Graphics3DReferencePoint", "Graphics3DReferenceVector",
"Graphics3DReferenceVectorGeometryToolComponentCollection", "Graphics3DVaporTrail", "Graphics3DVector",
"Graphics3DXOrigin", "Graphics3DYOrigin", "GroundVehicle", "GroundVehicleExportTools", "GroundVehicleGraphics",
"GroundVehicleGraphics3D", "HFSSFarFieldDataGainType", "HelpContextIdentifierType", "IAccessAdvanced",
"IAccessConstraint", "IAccessConstraintMinMaxBase", "IAccessInterval", "IAnimation", "IAntennaBeam",
"IAntennaBeamSelectionStrategy", "IAntennaContour", "IAntennaModel", "IAntennaModelOpticalSimple", "IAreaTypeData",
"IAtmosphericAbsorptionModel", "IAtmosphericAbsorptionModelITURP676", "IAtmosphericAbsorptionModelTIREM",
"IAtmosphericTurbulenceModel", "IAzElMaskData", "IBeamformer", "ICelestialBodyInformation",
"ICelestialBodyInformationCollection", "IChainTimePeriod", "IClassicalLocation", "IClassicalSizeShape", "ICloneable",
"ICloudsAndFogFadingLossModel", "ICommSystemAccessEventDetection", "ICommSystemAccessSamplingMethod",
"ICommSystemLinkSelectionCriteria", "IComponentInfo", "IComponentLinkEmbedControl",
"IConstellationConstraintRestriction", "ICoverageBounds", "ICoverageResolution", "IDataProvider", "IDataProviderInfo",
"IDelaunayActionVariable", "IDemodulatorModel", "IDirectionProvider", "IDisplayDistance", "IDisplayTime",
"IDisplayTimesData", "IEOIR", "IEOIRShapeObject", "IElementConfiguration", "IElementConfigurationPolygon",
"IEventDetectionStrategy", "IFigureOfMeritDefinition", "IFigureOfMeritDefinitionCompute",
"IFigureOfMeritDefinitionData", "IFigureOfMeritDefinitionDilutionOfPrecision", "IFigureOfMeritDefinitionResponseTime",
"IFigureOfMeritGraphics2DAttributes", "IFigureOfMeritGraphics2DContours", "IFigureOfMeritNavigationAccuracyMethod",
"IFlightPathAngle", "IGeodeticSize", "IGraphics3DMarkerData", "IGraphics3DModel", "IGraphics3DModelData",
"IGraphics3DReferenceAnalysisWorkbenchComponent", "IGreatArcGraphics", "IGreatArcGraphics3D", "IGreatArcVehicle",
"IIonosphericFadingLossModel", "ILaserAtmosphericLossModel", "ILaserPropagationChannel",
"ILaserTroposphericScintillationLossModel", "ILatitudeLongitudeAltitudePosition", "ILifetimeInformation",
"IModulatorModel", "IModulatorModelScriptPlugin", "IOrbitDisplayData", "IOrientationAscNode", "IPlatformRFEnvironment",
"IPointingStrategy", "IPolarization", "IPolarizationCrossPolLeakage", "IPolarizationElliptical",
"IPolarizationHorizontal", "IPolarizationLinear", "IPolarizationVertical", "IPositionSourceData", "IPropagator",
"IPropagatorSGP4LoadData", "IProvideSpatialInfo", "IRFFilterModel", "IRadarActivity", "IRadarClutterGeometryModel",
"IRadarClutterGeometryModelPlugin", "IRadarClutterMap", "IRadarClutterMapInheritable", "IRadarClutterMapModel",
"IRadarClutterMapModelConstantCoefficient", "IRadarClutterMapModelPlugin", "IRadarContinuousWaveAnalysisMode",
"IRadarCrossSectionComputeStrategy", "IRadarModeBistaticReceiver", "IRadarModeBistaticTransmitter",
"IRadarModeMonostatic", "IRadarModel", "IRadarProbabilityOfDetection", "IRadarProbabilityOfDetectionCFAR",
"IRadarPulseIntegration", "IRadarSTCAttenuation", "IRadarSTCAttenuationMap", "IRadarWaveformSearchTrack",
"IRainLossModel", "IReTransmitterModel", "IReceiverModel", "IReceiverModelScriptPlugin", "IRefractionModelBase",
"ISRPModelBase", "ISTKObject", "ISTKObjectCollection", "ISTKObjectElementCollection", "ISamplingMethodStrategy",
"IScatteringPointModel", "IScatteringPointProvider", "ISensorPattern", "ISensorPointing",
"ISensorPointingTargetedBoresight", "ISensorProjectionDisplayDistance", "ISolarActivityConfiguration",
"ITargetSelectionMethod", "ITerrainNormData", "ITimePeriod", "ITransmitterModel", "ITransmitterModelScriptPlugin",
"ITroposphericScintillationFadingLossModel", "IUrbanTerrestrialLossModel", "IVehicleAttitude",
"IVehicleAttitudeProfile", "IVehicleAttitudeSlewBase", "IVehicleAttitudeStandard", "IVehicleBreakAngle",
"IVehicleCoordinateAxes", "IVehicleGPSAlmanacProperties", "IVehicleGraphics2DAttributes",
"IVehicleGraphics2DAttributesBasic", "IVehicleGraphics2DAttributesDisplayState", "IVehicleGraphics2DElevation",
"IVehicleGraphics2DPass", "IVehicleGraphics2DTimeComponentsElement", "IVehicleGraphics2DTimeEventType",
"IVehicleGraphics3DAttributes", "IVehicleGraphics3DBPlaneTargetPointPosition", "IVehicleGraphics3DProximity",
"IVehicleGraphics3DProximityAreaObject", "IVehicleGraphics3DSigmaScale", "IVehicleGraphics3DSystemsElementBase",
"IVehicleGraphics3DTickData", "IVehicleHPOPDragModel", "IVehicleImpact", "IVehicleImpactLocation", "IVehicleLaunch",
"IVehicleLaunchControl", "IVehicleLeadTrailData", "IVehicleLeadTrailDataFraction", "IVehicleLeadTrailDataTime",
"IVehiclePassNumbering", "IVehiclePointing", "IVehicleSolarFluxGeoMagnitude", "IVehicleWaypointAltitudeReference",
"IVolumetricGridDefinition", "IWaveform", "IWaveformSelectionStrategy", "IntegratorStepSizeControl",
"IntegratorTimeRegularization", "IntersectionType", "IonosphericFadingLossModel",
"IonosphericFadingLossModelP531Version13", "IonosphericFadingLossModelType", "IvClockHost", "IvTimeSense",
"KeyValueCollection", "LOPAtmosphericDensityModel", "LabelNote", "LabelNoteCollection", "LaserAtmosphericLossModel",
"LaserAtmosphericLossModelBeerBouguerLambertLaw", "LaserEnvironment", "LaserPropagationLossModelType",
"LaserPropagationLossModels", "LaserTroposphericScintillationLossModel",
"LaserTroposphericScintillationLossModelITURP1814", "LaserTroposphericScintillationLossModelType",
"LatitudeLongitudeAltitudeCentric", "LatitudeLongitudeAltitudeDetic", "LatitudeLongitudeAltitudePosition",
"LatticeType", "LaunchVehicle", "LaunchVehicleControlFixedApogeeAltitude", "LaunchVehicleControlFixedDeltaV",
"LaunchVehicleControlFixedDeltaVMinimumEccentricity", "LaunchVehicleControlFixedTimeOfFlight",
"LaunchVehicleExportTools", "LaunchVehicleGraphics", "LaunchVehicleGraphics3D", "LaunchVehicleInitialState",
"LaunchVehicleLocationCentric", "LaunchVehicleLocationDetic", "LeadTrailData", "LevelAttribute",
"LevelAttributeCollection", "LightingObstructionModelType", "LimitsExceededBehaviorType", "LineTarget",
"LineTargetGraphics", "LineTargetGraphics3D", "LineTargetPoint", "LineTargetPointCollection", "LineWidth", "LinkMargin",
"LinkMarginType", "LinkToObject", "LoadMethod", "LocationVectorGeometryToolPoint", "LookAheadPropagator",
"LowAltitudeAtmosphericDensityModel", "MODTRANLookupTablePropagationModel", "MODTRANPropagationModel", "MTO",
"MTOAnalysis", "MTOAnalysisFieldOfView", "MTOAnalysisPosition", "MTOAnalysisRange", "MTOAnalysisVisibility",
"MTODefaultGraphics2DTrack", "MTODefaultGraphics3DTrack", "MTODefaultTrack", "MTOEntirety", "MTOGlobalTrackOptions",
"MTOGraphics", "MTOGraphics2DFadeTimes", "MTOGraphics2DGlobalTrackOptions", "MTOGraphics2DLeadTrailTimes",
"MTOGraphics2DLine", "MTOGraphics2DMarker", "MTOGraphics2DTrack", "MTOGraphics2DTrackCollection", "MTOGraphics3D",
"MTOGraphics3DDropLines", "MTOGraphics3DGlobalTrackOptions", "MTOGraphics3DMarker", "MTOGraphics3DModel",
"MTOGraphics3DModelArticulation", "MTOGraphics3DPoint", "MTOGraphics3DSwapDistances", "MTOGraphics3DTrack",
"MTOGraphics3DTrackCollection", "MTOInputDataType", "MTOObjectInterval", "MTORangeMode", "MTOTrack",
"MTOTrackCollection", "MTOTrackEvaluationType", "MTOTrackPoint", "MTOTrackPointCollection", "MTOVisibilityMode",
"MarkerShape3d", "MarkerType", "MethodToComputeSunPosition", "MilitaryStandard2525bSymbols", "Missile", "MissileEOIR",
"MissileExportTools", "MissileGraphics", "MissileGraphics3D", "MixedSphericalFlightPathAngleHorizontal",
"MixedSphericalFlightPathAngleType", "MixedSphericalFlightPathAngleVertical", "ModelGltfReflectionMapType", "ModelType",
"ModtranAerosolModelType", "ModtranCloudModelType", "ModulatorModel", "ModulatorModel16PSK", "ModulatorModel8PSK",
"ModulatorModelBOC", "ModulatorModelBPSK", "ModulatorModelDPSK", "ModulatorModelExternal",
"ModulatorModelExternalSource", "ModulatorModelFSK", "ModulatorModelMSK", "ModulatorModelNFSK",
"ModulatorModelNarrowbandUniform", "ModulatorModelOQPSK", "ModulatorModelPulsedSignal", "ModulatorModelQAM1024",
"ModulatorModelQAM128", "ModulatorModelQAM16", "ModulatorModelQAM256", "ModulatorModelQAM32", "ModulatorModelQAM64",
"ModulatorModelQPSK", "ModulatorModelScriptPluginCustomPSD", "ModulatorModelScriptPluginIdealPSD", "ModulatorModelType",
"ModulatorModelWidebandGaussian", "ModulatorModelWidebandUniform", "NoiseTemperatureComputeType", "NoteShowType",
"NotificationFilterMask", "ObjectCoverage", "ObjectCoverageFigureOfMerit", "ObjectLaserEnvironment", "ObjectLink",
"ObjectLinkCollection", "ObjectRFEnvironment", "OceanTides", "OffsetFrameType", "OnePointAccess",
"OnePointAccessConstraint", "OnePointAccessConstraintCollection", "OnePointAccessResult",
"OnePointAccessResultCollection", "OnePointAccessStatus", "OnePointAccessSummary", "OrbitState", "OrbitStateCartesian",
"OrbitStateClassical", "OrbitStateCoordinateSystem", "OrbitStateDelaunay", "OrbitStateDetic", "OrbitStateEquinoctial",
"OrbitStateMixedSpherical", "OrbitStateSpherical", "OrientationAscNode", "OrientationLongitudeOfAscending",
"OrientationRightAscensionOfAscendingNode", "PRFMode", "PassBreak", "PassBreakNumberingDateOfFirstPass",
"PassBreakNumberingFirstPassNumber", "PathCollection", "Place", "PlaceGraphics", "PlaceGraphics3D", "Planet",
"PlanetCommonTasks", "PlanetGraphics", "PlanetGraphics3D", "PlanetOrbitDisplayTime", "PlanetOrbitDisplayType",
"PlanetPositionCentralBody", "PlanetPositionFile", "PlanetPositionSourceType", "PlatformLaserEnvironment",
"PointTargetGraphics3DModel", "PointingStrategy", "PointingStrategyFixed", "PointingStrategySpinning",
"PointingStrategyTargeted", "PointingStrategyType", "Polarization", "PolarizationElliptical", "PolarizationHorizontal",
"PolarizationLeftHandCircular", "PolarizationLinear", "PolarizationReferenceAxis", "PolarizationRightHandCircular",
"PolarizationType", "PolarizationVertical", "Preferences", "PreferencesConnect", "PreferencesPythonPlugins",
"PreferencesVDF", "Priority", "PriorityCollection", "ProgressBarEventArguments", "ProjectionHorizontalDatumType",
"PropagationChannel", "Propagator11Parameters", "Propagator11ParametersDescriptor",
"Propagator11ParametersDescriptorCollection", "PropagatorAviator", "PropagatorBallistic",
"PropagatorDefinitionExportTool", "PropagatorDisplayCoordinateType", "PropagatorGPS", "PropagatorGreatArc",
"PropagatorHPOP", "PropagatorHPOPStaticForceModelSettings", "PropagatorHPOPThirdBodyGravityCollection",
"PropagatorHPOPThirdBodyGravityElement", "PropagatorJ2Perturbation", "PropagatorJ4Perturbation", "PropagatorLOP",
"PropagatorLOPThirdBodyGravity", "PropagatorRealtime", "PropagatorRealtimeCartesianPoints",
"PropagatorRealtimeDeticPoints", "PropagatorRealtimeHeadingPitch", "PropagatorRealtimePointBuilder",
"PropagatorRealtimeUTMPoints", "PropagatorSGP4", "PropagatorSGP4AutoUpdate", "PropagatorSGP4AutoUpdateFileSource",
"PropagatorSGP4AutoUpdateOnlineSource", "PropagatorSGP4AutoUpdateProperties", "PropagatorSGP4CommonTasks",
"PropagatorSGP4LoadFile", "PropagatorSGP4OnlineAutoLoad", "PropagatorSGP4OnlineLoad",
"PropagatorSGP4PropagatorSettings", "PropagatorSGP4Segment", "PropagatorSGP4SegmentCollection",
"PropagatorSGP4SwitchMethod", "PropagatorSP3", "PropagatorSP3File", "PropagatorSP3FileCollection", "PropagatorSPICE",
"PropagatorSPICESegment", "PropagatorSPICESegmentsCollection", "PropagatorSTKExternal", "PropagatorSimpleAscent",
"PropagatorTwoBody", "PropagatorType", "PropagatorUserExternal", "PulseWidthMode", "RCSComputeStrategy",
"RFEnvironment", "RFFilterModel", "RFFilterModelBessel", "RFFilterModelButterworth", "RFFilterModelChebyshev",
"RFFilterModelCosineWindow", "RFFilterModelElliptic", "RFFilterModelExternal", "RFFilterModelFIR",
"RFFilterModelFIRBoxCar", "RFFilterModelGaussianWindow", "RFFilterModelHammingWindow", "RFFilterModelIIR",
"RFFilterModelRCLowPass", "RFFilterModelRaisedCosine", "RFFilterModelRectangular", "RFFilterModelRootRaisedCosine",
"RFFilterModelScriptPlugin", "RFFilterModelSinc", "RFFilterModelSincEnvelopeSinc", "RFFilterModelType",
"RFInterference", "Radar", "RadarAccessGraphics", "RadarActivity", "RadarActivityAlwaysActive",
"RadarActivityAlwaysInactive", "RadarActivityTimeComponentList", "RadarActivityTimeComponentListCollection",
"RadarActivityTimeComponentListElement", "RadarActivityTimeIntervalList", "RadarActivityTimeIntervalListCollection",
"RadarActivityTimeIntervalListElement", "RadarActivityType", "RadarAntennaBeam", "RadarAntennaBeamCollection",
"RadarClutter", "RadarClutterGeometry", "RadarClutterGeometryModelType", "RadarClutterMapModelType",
"RadarContinuousWaveAnalysisMode", "RadarContinuousWaveAnalysisModeFixedTime", "RadarContinuousWaveAnalysisModeGoalSNR",
"RadarCrossSection", "RadarCrossSectionComputeStrategy", "RadarCrossSectionComputeStrategyAnsysCSVFile",
"RadarCrossSectionComputeStrategyConstantValue", "RadarCrossSectionComputeStrategyExternalFile",
"RadarCrossSectionComputeStrategyPlugin", "RadarCrossSectionComputeStrategyScriptPlugin",
"RadarCrossSectionContourGraphicsPolarization", "RadarCrossSectionContourLevel",
"RadarCrossSectionContourLevelCollection", "RadarCrossSectionFrequencyBand", "RadarCrossSectionFrequencyBandCollection",
"RadarCrossSectionGraphics", "RadarCrossSectionGraphics3D", "RadarCrossSectionInheritable", "RadarCrossSectionModel",
"RadarCrossSectionVolumeGraphics", "RadarCrossSectionVolumeLevel", "RadarCrossSectionVolumeLevelCollection",
"RadarDopplerClutterFilters", "RadarFrequencySpecificationType", "RadarGraphics", "RadarGraphics3D", "RadarJamming",
"RadarMode", "RadarModeBistaticReceiver", "RadarModeBistaticReceiverSAR", "RadarModeBistaticReceiverSearchTrack",
"RadarModeBistaticTransmitter", "RadarModeBistaticTransmitterSAR", "RadarModeBistaticTransmitterSearchTrack",
"RadarModeMonostatic", "RadarModeMonostaticSAR", "RadarModeMonostaticSearchTrack", "RadarModel",
"RadarModelBistaticReceiver", "RadarModelBistaticTransmitter", "RadarModelMonostatic", "RadarModelMultifunction",
"RadarModelType", "RadarModulator", "RadarMultifunctionDetectionProcessing",
"RadarMultifunctionWaveformStrategySettings", "RadarMultipathGraphics", "RadarProbabilityOfDetection",
"RadarProbabilityOfDetectionCFAR", "RadarProbabilityOfDetectionCFARCellAveraging",
"RadarProbabilityOfDetectionCFAROrderedStatistics", "RadarProbabilityOfDetectionNonCFAR",
"RadarProbabilityOfDetectionPlugin", "RadarProbabilityOfDetectionType", "RadarPulseIntegrationFixedNumberOfPulses",
"RadarPulseIntegrationGoalSNR", "RadarPulseIntegrationType", "RadarPulseIntegratorType", "RadarReceiver",
"RadarSARPulseIntegrationAnalysisMode", "RadarSNRContourType", "RadarSTCAttenuation", "RadarSTCAttenuationDecayFactor",
"RadarSTCAttenuationDecaySlope", "RadarSTCAttenuationMapAzimuthRange", "RadarSTCAttenuationMapElevationRange",
"RadarSTCAttenuationMapRange", "RadarSTCAttenuationPlugin", "RadarSTCAttenuationType", "RadarSarPRFMode",
"RadarSarPcrMode", "RadarSarRangeResolutionMode", "RadarSearchTrackPRFMode", "RadarSearchTrackPulseWidthMode",
"RadarSwerlingCase", "RadarTransmitter", "RadarTransmitterMultifunction",
"RadarWaveformBistaticReceiverSearchTrackContinuous", "RadarWaveformBistaticReceiverSearchTrackFixedPRF",
"RadarWaveformBistaticTransmitterSearchTrackContinuous", "RadarWaveformBistaticTransmitterSearchTrackFixedPRF",
"RadarWaveformMonostaticSearchTrackContinuous", "RadarWaveformMonostaticSearchTrackFixedPRF",
"RadarWaveformSarPulseDefinition", "RadarWaveformSarPulseIntegration", "RadarWaveformSearchTrackPulseDefinition",
"RadarWaveformSearchTrackType", "RadiationPressure", "RainLossModel", "RainLossModelCCIR1983", "RainLossModelCrane1982",
"RainLossModelCrane1985", "RainLossModelITURP618Version10", "RainLossModelITURP618Version12",
"RainLossModelITURP618Version13", "RainLossModelScriptPlugin", "RainLossModelType", "ReTransmitterModelComplex",
"ReTransmitterModelMedium", "ReTransmitterModelSimple", "ReTransmitterOpMode", "ReceivePolarizationElliptical",
"ReceivePolarizationHorizontal", "ReceivePolarizationLeftHandCircular", "ReceivePolarizationLinear",
"ReceivePolarizationRightHandCircular", "ReceivePolarizationVertical", "Receiver", "ReceiverGraphics",
"ReceiverGraphics3D", "ReceiverModel", "ReceiverModelCable", "ReceiverModelComplex", "ReceiverModelLaser",
"ReceiverModelMedium", "ReceiverModelMultibeam", "ReceiverModelScriptPluginLaser", "ReceiverModelScriptPluginRF",
"ReceiverModelSimple", "ReceiverModelType", "RectangularApertureInputType", "RefractionCoefficients",
"RefractionModelEffectiveRadiusMethod", "RefractionModelITURP8344", "RefractionModelSCFMethod",
"RepeatGroundTrackNumbering", "RotationRateAndOffset", "RouteGraphics3DMarkerType", "STKObject",
"STKObjectChangedEventArguments", "STKObjectCutCopyPasteEventArguments", "STKObjectModelContext",
"STKObjectPreDeleteEventArguments", "STKObjectRoot", "STKObjectType", "SamplingMethod", "SamplingMethodAdaptive",
"SamplingMethodFixedStep", "Satellite", "SatelliteCollection", "SatelliteExportTools", "SatelliteGraphics",
"SatelliteGraphics3D", "SatelliteGraphics3DModel", "ScatteringPointCollection", "ScatteringPointCollectionElement",
"ScatteringPointModel", "ScatteringPointModelConstantCoefficient", "ScatteringPointModelPlugin",
"ScatteringPointModelType", "ScatteringPointModelWindTurbine", "ScatteringPointProvider",
"ScatteringPointProviderCollection", "ScatteringPointProviderCollectionElement", "ScatteringPointProviderList",
"ScatteringPointProviderListType", "ScatteringPointProviderPlugin", "ScatteringPointProviderPointsFile",
"ScatteringPointProviderRangeOverCFARCells", "ScatteringPointProviderSinglePoint",
"ScatteringPointProviderSmoothOblateEarth", "ScatteringPointProviderType", "Scenario", "Scenario3dFont",
"Scenario3dPointSize", "ScenarioAnimation", "ScenarioAnimationTimePeriod", "ScenarioBeforeSaveEventArguments",
"ScenarioDatabase", "ScenarioDatabaseCollection", "ScenarioEarthData", "ScenarioEndLoopType", "ScenarioGraphics",
"ScenarioGraphics3D", "ScenarioRefreshDeltaType", "ScenarioSpaceEnvironment", "ScenarioTimeStepType", "ScheduleTime",
"ScheduleTimeCollection", "Sensor", "SensorAccessAdvancedSettings", "SensorAltitudeCrossingDirection",
"SensorAltitudeCrossingSideType", "SensorAzElBoresightAxisType", "SensorAzElMaskFile", "SensorCommonTasks",
"SensorComplexConicPattern", "SensorCustomPattern", "SensorEOIRBand", "SensorEOIRBandCollection",
"SensorEOIRBandImageQuality", "SensorEOIRBandOpticalInputMode", "SensorEOIRBandOpticalTransmissionMode",
"SensorEOIRBandQuantizationMode", "SensorEOIRBandQuantumEfficiencyMode", "SensorEOIRBandRadiometricParameterLevelType",
"SensorEOIRBandSaturationMode", "SensorEOIRBandSpatialInputMode",
"SensorEOIRBandSpectralRelativeSystemResponseUnitsType", "SensorEOIRBandSpectralShape", "SensorEOIRBandWavelengthType",
"SensorEOIRJitterType", "SensorEOIRPattern", "SensorEOIRProcessingLevelType", "SensorEOIRRadiometricPair",
"SensorEOIRSaturationCollection", "SensorEOIRScanMode", "SensorEOIRSensitivityCollection", "SensorGraphics",
"SensorGraphics3D", "SensorGraphics3DInheritFrom2D", "SensorGraphics3DOffset", "SensorGraphics3DProjectionElement",
"SensorGraphics3DProjectionTimeDependencyType", "SensorGraphics3DProjectionType", "SensorGraphics3DPulse",
"SensorGraphics3DPulseFrequencyPreset", "SensorGraphics3DPulseStyle", "SensorGraphics3DSpaceProjectionCollection",
"SensorGraphics3DTargetProjectionCollection", "SensorGraphics3DVisualAppearance", "SensorHalfPowerPattern",
"SensorLocation", "SensorPattern", "SensorPointing", "SensorPointing3DModel", "SensorPointingAlongVector",
"SensorPointingExternal", "SensorPointingFixed", "SensorPointingFixedInAxes", "SensorPointingGrazingAltitude",
"SensorPointingSchedule", "SensorPointingSpinning", "SensorPointingTargeted", "SensorPointingTargetedBoresightFixed",
"SensorPointingTargetedBoresightTrack", "SensorPointingTargetedBoresightType", "SensorProjection",
"SensorProjectionConstantAltitude", "SensorProjectionDisplayDistance", "SensorProjectionDistanceType",
"SensorProjectionObjectAltitude", "SensorRectangularPattern", "SensorRefractionType", "SensorSARPattern",
"SensorScanMode", "SensorSimpleConicPattern", "SensorTarget", "SensorTargetCollection", "SensorUnknownPattern", "Ship",
"ShipExportTools", "ShipGraphics", "ShipGraphics3D", "SolarActivityConfiguration",
"SolarActivityConfigurationSolarFlux", "SolarActivityConfigurationSunspotNumber", "SolarFluxGeoMagneticFileSettings",
"SolarFluxGeoMagneticValueSettings", "SolarRadiationPressureModelGPS", "SolarRadiationPressureModelPlugin",
"SolarRadiationPressureModelPluginSettings", "SolarRadiationPressureModelSpherical", "SolarRadiationPressureModelType",
"SolarRadiationPressureShadowModelType", "SolidTide", "SolidTides", "SpaceEnvironment",
"SpaceEnvironmentCrresProtonActivity", "SpaceEnvironmentCrresRadiationActivity", "SpaceEnvironmentGraphics",
"SpaceEnvironmentMagneticExternalField", "SpaceEnvironmentMagneticField", "SpaceEnvironmentMagneticFieldColorMode",
"SpaceEnvironmentMagneticFieldColorScaleType", "SpaceEnvironmentMagneticMainField",
"SpaceEnvironmentMagnitudeFieldGraphics2D", "SpaceEnvironmentMagnitudeFieldLine", "SpaceEnvironmentNasaModelsActivity",
"SpaceEnvironmentParticleFlux", "SpaceEnvironmentRadiation", "SpaceEnvironmentRadiationDoseRateCollection",
"SpaceEnvironmentRadiationDoseRateElement", "SpaceEnvironmentRadiationEnergyMethodEnergies",
"SpaceEnvironmentRadiationEnergyValues", "SpaceEnvironmentRadiationEnvironment", "SpaceEnvironmentSAAChannel",
"SpaceEnvironmentSAAContour", "SpaceEnvironmentSAAFluxLevel", "SpaceEnvironmentScenarioGraphics3D",
"SpaceEnvironmentVehicleTemperature", "SpacingUnit", "SpatialState", "SphericalFlightPathAngleHorizontal",
"SphericalFlightPathAngleVertical", "SphericalFlightPathAzimuthType", "SpiceInterpolation", "Star", "StarCollection",
"StarGraphics", "StarGraphics3D", "StarInformation", "StarReferenceFrame", "StatisticType", "Subset",
"SurfaceReference", "Swath", "SwathComputationalMethod", "SystemNoiseTemperature", "TIREMPolarizationType", "Target",
"TargetGraphics", "TargetGraphics3D", "TargetSelectionMethod", "TargetSelectionMethod",
"TargetSelectionMethodClosingVelocity", "TargetSelectionMethodPriority", "TargetSelectionMethodRange", "Terrain",
"TerrainCollection", "TerrainFileType", "TerrainNormalSlopeAzimuth", "TerrainNormalType", "TextOutlineStyle",
"ThirdBodyGravitySourceType", "TickData", "Tileset3D", "Tileset3DCollection", "Tileset3DSourceType",
"TimeIntervalCollection", "TimeIntervalCollectionReadOnly", "TimePeriod", "TimePeriodValue", "TimePeriodValueType",
"TimeVaryingExtremum", "TrackMode", "TrajectoryType", "TransferFunctionInputBackOffOutputBackOffTable",
"TransferFunctionInputBackOffOutputBackOffTableRow", "TransferFunctionInputBackOffVsCOverImTable",
"TransferFunctionInputBackOffVsCOverImTableRow", "TransferFunctionPolynomialCollection", "TransferFunctionType",
"Transmitter", "TransmitterGraphics", "TransmitterGraphics3D", "TransmitterModel", "TransmitterModelCable",
"TransmitterModelComplex", "TransmitterModelLaser", "TransmitterModelMedium", "TransmitterModelMultibeam",
"TransmitterModelScriptPluginLaser", "TransmitterModelScriptPluginRF", "TransmitterModelSimple", "TransmitterModelType",
"TroposphericScintillationAverageTimeChoiceType", "TroposphericScintillationFadingLossModel",
"TroposphericScintillationFadingLossModelP618Version12", "TroposphericScintillationFadingLossModelP618Version8",
"TroposphericScintillationFadingLossModelType", "UrbanTerrestrialLossModel", "UrbanTerrestrialLossModelTwoRay",
"UrbanTerrestrialLossModelType", "UrbanTerrestrialLossModelWirelessInSite64", "VectorAxesConnectType",
"VehicleAccessAdvancedSettings", "VehicleAltitudeReference", "VehicleAttitude", "VehicleAttitudeExportTool",
"VehicleAttitudeExternal", "VehicleAttitudeMaximumSlewAcceleration", "VehicleAttitudeMaximumSlewRate",
"VehicleAttitudePointing", "VehicleAttitudeRealTime", "VehicleAttitudeRealTimeDataReference",
"VehicleAttitudeSlewConstrained", "VehicleAttitudeSlewFixedRate", "VehicleAttitudeSlewFixedTime",
"VehicleAttitudeTargetSlew", "VehicleAttitudeTrendingControlAviator", "VehicleBreakAngleBreakByLatitude",
"VehicleBreakAngleBreakByLongitude", "VehicleBreakAngleType", "VehicleCentralBodies",
"VehicleConsiderAnalysisCollection", "VehicleConsiderAnalysisCollectionElement", "VehicleConsiderAnalysisType",
"VehicleCoordinateAxesCustom", "VehicleCoordinateSystem", "VehicleCorrelationListCollection",
"VehicleCorrelationListElement", "VehicleCorrelationListType", "VehicleCovariance", "VehicleDefinition",
"VehicleDirection", "VehicleDuration", "VehicleEOIR", "VehicleEclipseBodies", "VehicleEclipsingBodies",
"VehicleEllipseDataCollection", "VehicleEllipseDataElement", "VehicleEllipseOptionType",
"VehicleEphemerisBinaryExportTool", "VehicleEphemerisCCSDSExportTool", "VehicleEphemerisCCSDSv2ExportTool",
"VehicleEphemerisCode500ExportTool", "VehicleEphemerisExportTool", "VehicleEphemerisSPICEExportTool",
"VehicleExponentialDensityModelParameters", "VehicleFrame", "VehicleGPSAlmanacProperties",
"VehicleGPSAlmanacPropertiesSEM", "VehicleGPSAlmanacPropertiesSP3", "VehicleGPSAlmanacPropertiesYUMA",
"VehicleGPSAlmanacType", "VehicleGPSAutoUpdate", "VehicleGPSAutoUpdateFileSource", "VehicleGPSAutoUpdateOnlineSource",
"VehicleGPSAutoUpdateProperties", "VehicleGPSAutomaticUpdateSourceType", "VehicleGPSElement",
"VehicleGPSElementCollection", "VehicleGPSElementSelectionType", "VehicleGPSSpecifyAlmanac", "VehicleGPSSwitchMethod",
"VehicleGeomagneticFluxSourceType", "VehicleGeomagneticFluxUpdateRateType", "VehicleGraphics2DAttributeType",
"VehicleGraphics2DAttributesAccess", "VehicleGraphics2DAttributesCustom", "VehicleGraphics2DAttributesOrbit",
"VehicleGraphics2DAttributesRealtime", "VehicleGraphics2DAttributesRoute", "VehicleGraphics2DAttributesTimeComponents",
"VehicleGraphics2DAttributesTrajectory", "VehicleGraphics2DElevation", "VehicleGraphics2DElevationContours",
"VehicleGraphics2DElevationGroundElevation", "VehicleGraphics2DElevationSwathHalfWidth",
"VehicleGraphics2DElevationVehicleHalfAngle", "VehicleGraphics2DElevationsCollection",
"VehicleGraphics2DElevationsElement", "VehicleGraphics2DGroundEllipsesCollection",
"VehicleGraphics2DGroundEllipsesElement", "VehicleGraphics2DInterval", "VehicleGraphics2DIntervalsCollection",
"VehicleGraphics2DLeadDataFraction", "VehicleGraphics2DLeadDataTime", "VehicleGraphics2DLeadTrailData",
"VehicleGraphics2DLighting", "VehicleGraphics2DLightingElement", "VehicleGraphics2DLine", "VehicleGraphics2DOffset",
"VehicleGraphics2DOptionType", "VehicleGraphics2DOrbitPassData", "VehicleGraphics2DPass",
"VehicleGraphics2DPassResolution", "VehicleGraphics2DPassShowPasses", "VehicleGraphics2DPasses",
"VehicleGraphics2DRoutePassData", "VehicleGraphics2DRouteResolution", "VehicleGraphics2DSAA", "VehicleGraphics2DSwath",
"VehicleGraphics2DTimeComponentsCollection", "VehicleGraphics2DTimeComponentsEventCollectionElement",
"VehicleGraphics2DTimeComponentsEventElement", "VehicleGraphics2DTimeEventType", "VehicleGraphics2DTimeEventTypeLine",
"VehicleGraphics2DTimeEventTypeMarker", "VehicleGraphics2DTimeEventTypeText", "VehicleGraphics2DTimeEventsCollection",
"VehicleGraphics2DTimeEventsElement", "VehicleGraphics2DTrailDataFraction", "VehicleGraphics2DTrailDataTime",
"VehicleGraphics2DTrajectoryPassData", "VehicleGraphics2DTrajectoryResolution", "VehicleGraphics2DVisibleSideType",
"VehicleGraphics2DWaypointMarker", "VehicleGraphics2DWaypointMarkersCollection",
"VehicleGraphics2DWaypointMarkersElement", "VehicleGraphics3DAttributeType", "VehicleGraphics3DAttributesBasic",
"VehicleGraphics3DAttributesIntervals", "VehicleGraphics3DBPlaneEvent", "VehicleGraphics3DBPlaneInstance",
"VehicleGraphics3DBPlaneInstancesCollection", "VehicleGraphics3DBPlanePoint", "VehicleGraphics3DBPlanePointCollection",
"VehicleGraphics3DBPlaneTargetPoint", "VehicleGraphics3DBPlaneTargetPointPosition",
"VehicleGraphics3DBPlaneTargetPointPositionCartesian", "VehicleGraphics3DBPlaneTargetPointPositionPolar",
"VehicleGraphics3DBPlaneTemplate", "VehicleGraphics3DBPlaneTemplateDisplayCollection",
"VehicleGraphics3DBPlaneTemplateDisplayElement", "VehicleGraphics3DBPlaneTemplatesCollection",
"VehicleGraphics3DBPlanes", "VehicleGraphics3DBearingBox", "VehicleGraphics3DBearingEllipse",
"VehicleGraphics3DControlBox", "VehicleGraphics3DCovariance", "VehicleGraphics3DCovariancePointingContour",
"VehicleGraphics3DDataFraction", "VehicleGraphics3DDataTime", "VehicleGraphics3DDefaultAttributes",
"VehicleGraphics3DDropLinePathItem", "VehicleGraphics3DDropLinePathItemCollection",
"VehicleGraphics3DDropLinePositionItem", "VehicleGraphics3DDropLinePositionItemCollection",
"VehicleGraphics3DDropLineType", "VehicleGraphics3DElevationContours", "VehicleGraphics3DEllipsoid",
"VehicleGraphics3DGeoBox", "VehicleGraphics3DIntervalsCollection", "VehicleGraphics3DIntervalsElement",
"VehicleGraphics3DLeadTrailData", "VehicleGraphics3DLineOfBearing", "VehicleGraphics3DModelRoute",
"VehicleGraphics3DModelTrajectory", "VehicleGraphics3DOrbitDropLines", "VehicleGraphics3DOrbitPassData",
"VehicleGraphics3DOrbitProximity", "VehicleGraphics3DOrbitTickMarks", "VehicleGraphics3DOrbitTrackData",
"VehicleGraphics3DPass", "VehicleGraphics3DPathTickMarks", "VehicleGraphics3DRoute", "VehicleGraphics3DRouteDropLines",
"VehicleGraphics3DRouteProximity", "VehicleGraphics3DSAA", "VehicleGraphics3DSigmaScale",
"VehicleGraphics3DSigmaScaleProbability", "VehicleGraphics3DSigmaScaleScale", "VehicleGraphics3DSize",
"VehicleGraphics3DSystemsCollection", "VehicleGraphics3DSystemsElement", "VehicleGraphics3DSystemsSpecialElement",
"VehicleGraphics3DTickDataLine", "VehicleGraphics3DTickDataPoint", "VehicleGraphics3DTrajectory",
"VehicleGraphics3DTrajectoryDropLines", "VehicleGraphics3DTrajectoryPassData", "VehicleGraphics3DTrajectoryProximity",
"VehicleGraphics3DTrajectoryTickMarks", "VehicleGraphics3DTrajectoryTrackData", "VehicleGraphics3DVelocityCovariance",
"VehicleGraphics3DWaypointMarkersCollection", "VehicleGraphics3DWaypointMarkersElement", "VehicleGravity",
"VehicleGroundEllipseElement", "VehicleGroundEllipsesCollection", "VehicleHPOPCentralBodyGravity",
"VehicleHPOPDragModel", "VehicleHPOPDragModelPlugin", "VehicleHPOPDragModelPluginSettings",
"VehicleHPOPDragModelSpherical", "VehicleHPOPForceModel", "VehicleHPOPForceModelDrag",
"VehicleHPOPForceModelDragOptions", "VehicleHPOPForceModelMoreOptions", "VehicleHPOPSolarRadiationPressure",
"VehicleHPOPSolarRadiationPressureModel", "VehicleHPOPSolarRadiationPressureOptions", "VehicleImpact",
"VehicleImpactLocation", "VehicleImpactLocationCentric", "VehicleImpactLocationDetic",
"VehicleImpactLocationLaunchAzEl", "VehicleImpactLocationPoint", "VehicleInertia", "VehicleInitialState",
"VehicleIntegratedAttitude", "VehicleIntegrationModel", "VehicleIntegrator", "VehicleInterpolation",
"VehicleInterpolationMethod", "VehicleLOPCentralBodyGravity", "VehicleLOPDragSettings", "VehicleLOPForceModel",
"VehicleLOPForceModelDrag", "VehicleLOPSolarRadiationPressure", "VehicleLaunch", "VehicleLaunchControl",
"VehicleLookAheadMethod", "VehicleMassProperties", "VehicleMethod", "VehiclePartialPassMeasurement",
"VehiclePassNumbering", "VehiclePhysicalData", "VehiclePluginPropagator", "VehiclePluginSettings",
"VehiclePositionVelocityCollection", "VehiclePositionVelocityElement", "VehiclePredictorCorrectorScheme",
"VehiclePropagationFrame", "VehicleSGP4AutomaticUpdateSourceType", "VehicleSGP4TLESelectionType", "VehicleSlewMode",
"VehicleSlewTimingBetweenTargetType", "VehicleSolarFluxGeomagneticType", "VehicleSpaceEnvironmentApSource",
"VehicleSpaceEnvironmentComputationMode", "VehicleSpaceEnvironmentDetectorGeometry",
"VehicleSpaceEnvironmentDetectorType", "VehicleSpaceEnvironmentDoseChannel", "VehicleSpaceEnvironmentF10P7SourceType",
"VehicleSpaceEnvironmentMaterial", "VehicleSpaceEnvironmentShapeModel", "VehicleSpatialInformation",
"VehicleTargetPointingCollection", "VehicleTargetPointingElement", "VehicleTargetPointingIntervalCollection",
"VehicleTargetTimes", "VehicleVector", "VehicleWaypointAltitudeReference", "VehicleWaypointAltitudeReferenceTerrain",
"VehicleWaypointComputationMethod", "VehicleWaypointInterpolationMethod", "VehicleWaypointsCollection",
"VehicleWaypointsElement", "VehicleZonalPropagatorInitialState", "Volumetric", "VolumetricAdvancedSettings",
"VolumetricAnalysisInterval", "VolumetricDataExportFormatType", "VolumetricDefinitionType",
"VolumetricDisplayQualityType", "VolumetricDisplayVolumeType", "VolumetricExportTool", "VolumetricExternalFile",
"VolumetricGraphics3D", "VolumetricGraphics3DActiveGridPoints", "VolumetricGraphics3DCrossSection",
"VolumetricGraphics3DCrossSectionPlane", "VolumetricGraphics3DCrossSectionPlaneCollection", "VolumetricGraphics3DGrid",
"VolumetricGraphics3DLegend", "VolumetricGraphics3DSpatialCalculationLevel",
"VolumetricGraphics3DSpatialCalculationLevelCollection", "VolumetricGraphics3DSpatialCalculationLevels",
"VolumetricGraphics3DVolume", "VolumetricGridSpatialCalculation", "VolumetricLegendNumericNotationType",
"VolumetricLevelOrder", "VolumetricSaveComputedDataType", "VolumetricSpatialCalculationEvaluationType",
"VolumetricVolumeGridExportType", "Waveform", "WaveformPulseDefinition", "WaveformRectangular",
"WaveformSelectionStrategy", "WaveformSelectionStrategyFixed", "WaveformSelectionStrategyRangeLimits",
"WaveformSelectionStrategyType", "WaveformType", "WirelessInSite64GeometryData"]

from ctypes import POINTER
from enum import IntEnum, IntFlag
import typing

from ..analysis_workbench import (
    IAnalysisWorkbenchComponent,
    ITimeToolTimeArray,
    ITimeToolTimeIntervalList,
    IVectorGeometryToolAxes,
)
from ..internal import coclassutil as agcls, comutil as agcom, dataanalysisutil as agdata, marshall as agmarshall
from ..internal.apiutil import (
    EnumeratorProxy,
    InterfaceProxy,
    OutArg,
    SupportsDeleteCallback,
    get_interface_property,
    initialize_from_source_object,
    set_class_attribute,
    set_interface_attribute,
)
from ..internal.comutil import IDispatch, IUnknown
from ..internal.eventutil import ISTKObjectRootEventHandler
from ..stkutil import (
    AzElAboutBoresight,
    ConversionUtility,
    CoordinateSystem,
    DirectionType,
    DoublesCollection,
    EulerOrientationSequenceType,
    ExecuteCommandResult,
    ExecuteMultipleCommandsMode,
    ExecuteMultipleCommandsResult,
    FillStyle,
    ICartesian3Vector,
    IDirection,
    ILocationData,
    IOrbitState,
    IOrientation,
    IPosition,
    LineStyle,
    YPRAnglesSequence,
)
from ..utilities import colors as agcolor
from ..utilities.exceptions import STKRuntimeError


def _raise_uninitialized_error(*args):
    raise STKRuntimeError("Valid STK object model classes are returned from STK methods and should not be created independently.")

class Constants(IntEnum):
    """Constants contains base IDs for various structures."""

    ERROR_BASE = 0x200
    """Error base."""
    HELP_CONTEXT_BASE = 0x1000
    """Help context base."""

Constants.ERROR_BASE.__doc__ = "Error base."
Constants.HELP_CONTEXT_BASE.__doc__ = "Help context base."

agcls.AgTypeNameMap["Constants"] = Constants

class HelpContextIdentifierType(IntEnum):
    """Help context IDs."""

    STK_OBJECT_COLLECTION = (Constants.HELP_CONTEXT_BASE + 1)

    STK_OBJECT = (Constants.HELP_CONTEXT_BASE + 2)

    APPLICATION = (Constants.HELP_CONTEXT_BASE + 3)

    CO_STK_OBJECT = (Constants.HELP_CONTEXT_BASE + 4)

    CO_APPLICATION = (Constants.HELP_CONTEXT_BASE + 5)

    CO_STK_OBJECT_COLLECTION = (Constants.HELP_CONTEXT_BASE + 6)

    EXECUTE_CMD_RESULT = (Constants.HELP_CONTEXT_BASE + 7)

    STK_OBJECT_ROOT_EVENTS = (Constants.HELP_CONTEXT_BASE + 8)

    LIFETIME_INFORMATION = (Constants.HELP_CONTEXT_BASE + 11)

    DATA_PROVIDER_RESULT_SUB_SECTION = (Constants.HELP_CONTEXT_BASE + 12)

    DATA_PROVIDER_RESULT_INTERVAL_COLLECTION = (Constants.HELP_CONTEXT_BASE + 13)

    DATA_PROVIDER_RESULT_INTERVAL = (Constants.HELP_CONTEXT_BASE + 14)

    DATA_PROVIDER_RESULT_DATA_SET_COLLECTION = (Constants.HELP_CONTEXT_BASE + 15)

    DATA_PROVIDER_RESULT_DATA_SET = (Constants.HELP_CONTEXT_BASE + 16)

    DATA_PROVIDER_RESULT_RESULT = (Constants.HELP_CONTEXT_BASE + 17)

    DATA_PROVIDER_RESULT_SUB_SECTION_COLLECTION = (Constants.HELP_CONTEXT_BASE + 18)

    DATA_PROVIDER_RESULT_TEXT_MESSAGE = (Constants.HELP_CONTEXT_BASE + 19)

    SUPPORT_BATCH_UPDATES = (Constants.HELP_CONTEXT_BASE + 20)

    XML_SERIALIZABLE = (Constants.HELP_CONTEXT_BASE + 21)

    STK_OBJECT_ELEMENT_COLLECTION = (Constants.HELP_CONTEXT_BASE + 22)

    ANIMATION = (Constants.HELP_CONTEXT_BASE + 23)

    STK_OBJECT_XPATH_NAVIGATOR = (Constants.HELP_CONTEXT_BASE + 24)


agcls.AgTypeNameMap["HelpContextIdentifierType"] = HelpContextIdentifierType

class ErrorCode(IntEnum):
    """Error codes."""

    OBJECT_NOT_FOUND = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 1))
    """Object not found."""
    INDEX_OUT_OF_RANGE = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 2))
    """Index out of range."""
    INVALID_ATTRIBUTE = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 3))
    """The attribute is invalid."""
    COMMAND_FAILED = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 4))
    """The command failed."""
    INVALID_ARGUMENT = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 5))
    """Invalid argument."""
    EMPTY_ARGUMENT = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 6))
    """Empty argument."""
    OBJECT_NOT_REMOVED = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 7))
    """Object was not removed."""
    FAILED_TO_RENAME_OBJECT = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 8))
    """Error renaming object."""
    UNKNOWN_CLASS_TYPE = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 9))
    """Unknown class type."""
    FAILED_TO_CREATE_OBJECT = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 10))
    """Failed to create the object."""
    OBJECT_LINK_INVALID_CHOICE = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 11))
    """Invalid choice for object link."""
    OBJECT_LINK_NO_CHOICES = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 12))
    """No choices available."""
    READ_ONLY_ATTRIBUTE = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 13))
    """Read only attribute."""
    INVALID_CONSTRAINT_LIST = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 14))
    """Invalid constraint list."""
    INVALID_CONSTRAINT = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 15))
    """InvalidConstraint."""
    LIST_READ_ONLY = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 16))
    """List if read only."""
    LIST_INSERT_FAILED = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 17))
    """Failed to insert the item into the list."""
    INVALID_LENGTH = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 18))
    """Length is invalid."""
    FAILED_TO_LOAD_FILE = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 19))
    """Error loading a file."""
    INVALID_OPERATION = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 20))
    """Invalid operation."""
    METHOD_INVOKE_FAILED = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 21))
    """Method failed."""
    DEPRECATED = (((1 << 31) | (4 << 16)) | (Constants.ERROR_BASE + 22))
    """Deprecated property or method."""

ErrorCode.OBJECT_NOT_FOUND.__doc__ = "Object not found."
ErrorCode.INDEX_OUT_OF_RANGE.__doc__ = "Index out of range."
ErrorCode.INVALID_ATTRIBUTE.__doc__ = "The attribute is invalid."
ErrorCode.COMMAND_FAILED.__doc__ = "The command failed."
ErrorCode.INVALID_ARGUMENT.__doc__ = "Invalid argument."
ErrorCode.EMPTY_ARGUMENT.__doc__ = "Empty argument."
ErrorCode.OBJECT_NOT_REMOVED.__doc__ = "Object was not removed."
ErrorCode.FAILED_TO_RENAME_OBJECT.__doc__ = "Error renaming object."
ErrorCode.UNKNOWN_CLASS_TYPE.__doc__ = "Unknown class type."
ErrorCode.FAILED_TO_CREATE_OBJECT.__doc__ = "Failed to create the object."
ErrorCode.OBJECT_LINK_INVALID_CHOICE.__doc__ = "Invalid choice for object link."
ErrorCode.OBJECT_LINK_NO_CHOICES.__doc__ = "No choices available."
ErrorCode.READ_ONLY_ATTRIBUTE.__doc__ = "Read only attribute."
ErrorCode.INVALID_CONSTRAINT_LIST.__doc__ = "Invalid constraint list."
ErrorCode.INVALID_CONSTRAINT.__doc__ = "InvalidConstraint."
ErrorCode.LIST_READ_ONLY.__doc__ = "List if read only."
ErrorCode.LIST_INSERT_FAILED.__doc__ = "Failed to insert the item into the list."
ErrorCode.INVALID_LENGTH.__doc__ = "Length is invalid."
ErrorCode.FAILED_TO_LOAD_FILE.__doc__ = "Error loading a file."
ErrorCode.INVALID_OPERATION.__doc__ = "Invalid operation."
ErrorCode.METHOD_INVOKE_FAILED.__doc__ = "Method failed."
ErrorCode.DEPRECATED.__doc__ = "Deprecated property or method."

agcls.AgTypeNameMap["ErrorCode"] = ErrorCode

class AberrationType(IntEnum):
    """The model of aberration to be used in access computations."""

    UNKNOWN = -1
    """Not supported type."""
    TOTAL = 0
    """Total: Apply the full aberration correction, when light time delay is computed."""
    ANNUAL = 1
    """Annual: Consider annual aberration only. Aberration is applied only cases where the light time delay is computed using the solar system barycenter frame."""
    NONE = 2
    """None: Ignore aberration."""

AberrationType.UNKNOWN.__doc__ = "Not supported type."
AberrationType.TOTAL.__doc__ = "Total: Apply the full aberration correction, when light time delay is computed."
AberrationType.ANNUAL.__doc__ = "Annual: Consider annual aberration only. Aberration is applied only cases where the light time delay is computed using the solar system barycenter frame."
AberrationType.NONE.__doc__ = "None: Ignore aberration."

agcls.AgTypeNameMap["AberrationType"] = AberrationType

class AnimationEndTimeMode(IntEnum):
    """Animation modes."""

    UNKNOWN = 0
    """Unknown animation mode."""
    NORMAL = 1
    """Normal animation mode."""
    REAL_TIME = 2
    """Real time animation mode."""
    X_REAL_TIME = 32
    """X times real time animation mode."""
    TIME_ARRAY = 64
    """Time array animation mode."""

AnimationEndTimeMode.UNKNOWN.__doc__ = "Unknown animation mode."
AnimationEndTimeMode.NORMAL.__doc__ = "Normal animation mode."
AnimationEndTimeMode.REAL_TIME.__doc__ = "Real time animation mode."
AnimationEndTimeMode.X_REAL_TIME.__doc__ = "X times real time animation mode."
AnimationEndTimeMode.TIME_ARRAY.__doc__ = "Time array animation mode."

agcls.AgTypeNameMap["AnimationEndTimeMode"] = AnimationEndTimeMode

class AnimationOptionType(IntEnum):
    """Animation Options."""

    CONTINUE = 0
    """Continue animating after the end time is reached."""
    LOOP = 1
    """Loop when end time is reached."""
    STOP = 2
    """End when end time is reached."""

AnimationOptionType.CONTINUE.__doc__ = "Continue animating after the end time is reached."
AnimationOptionType.LOOP.__doc__ = "Loop when end time is reached."
AnimationOptionType.STOP.__doc__ = "End when end time is reached."

agcls.AgTypeNameMap["AnimationOptionType"] = AnimationOptionType

class AnimationActionType(IntEnum):
    """Animation action options."""

    ACTION_PLAY = 0
    """Play."""
    ACTION_START = 1
    """Start."""

AnimationActionType.ACTION_PLAY.__doc__ = "Play."
AnimationActionType.ACTION_START.__doc__ = "Start."

agcls.AgTypeNameMap["AnimationActionType"] = AnimationActionType

class AnimationDirectionType(IntEnum):
    """Animation direction options."""

    NOT_AVAILABLE = 0
    """Not available."""
    FORWARD = 1
    """Forward."""
    BACKWARD = 2
    """Backward."""

AnimationDirectionType.NOT_AVAILABLE.__doc__ = "Not available."
AnimationDirectionType.FORWARD.__doc__ = "Forward."
AnimationDirectionType.BACKWARD.__doc__ = "Backward."

agcls.AgTypeNameMap["AnimationDirectionType"] = AnimationDirectionType

class AzElMaskType(IntEnum):
    """Obscura types of the facility, place or target for AzElMask definition."""

    MASK_FILE = 0x0
    """Use data in an external azimuth-elevation mask (.aem) file."""
    TERRAIN_DATA = 0x1
    """Use terrain data specified at the scenario level to define the azimuth-elevation mask."""
    NONE = 0x2
    """No azimuth-elevation mask is defined."""

AzElMaskType.MASK_FILE.__doc__ = "Use data in an external azimuth-elevation mask (.aem) file."
AzElMaskType.TERRAIN_DATA.__doc__ = "Use terrain data specified at the scenario level to define the azimuth-elevation mask."
AzElMaskType.NONE.__doc__ = "No azimuth-elevation mask is defined."

agcls.AgTypeNameMap["AzElMaskType"] = AzElMaskType

class ActionType(IntEnum):
    """Specify the action type for the Interval Access Constraint."""

    INCLUDE = 0
    """Include time intervals during which the constraint is satisfied."""
    EXCLUDE = 1
    """Exclude time intervals during which the constraint is satisfied."""

ActionType.INCLUDE.__doc__ = "Include time intervals during which the constraint is satisfied."
ActionType.EXCLUDE.__doc__ = "Exclude time intervals during which the constraint is satisfied."

agcls.AgTypeNameMap["ActionType"] = ActionType

class AxisOffset(IntEnum):
    """Specify the axis offset for the sensor 3D Vertex Offset."""

    SENSOR_RADIUS = 0
    """Sensor Radius: offset along the axis of the boresight by a distance calculated by STK using the radius entered."""
    BORESIGHT_OFFSET = 1
    """Boresight Offset: offset along the axis of the boresight by the distance specified."""

AxisOffset.SENSOR_RADIUS.__doc__ = "Sensor Radius: offset along the axis of the boresight by a distance calculated by STK using the radius entered."
AxisOffset.BORESIGHT_OFFSET.__doc__ = "Boresight Offset: offset along the axis of the boresight by the distance specified."

agcls.AgTypeNameMap["AxisOffset"] = AxisOffset

class DataProviderResultCategory(IntEnum):
    """Specify the category of results returned by the data providers."""

    INTERVAL_LIST = 0x0
    """Interval list."""
    SUB_SECTION_LIST = 0x1
    """Subsection list."""
    MESSAGE = 0x2
    """Message."""
    DATA_SET_LIST = 0x3
    """Data set list."""

DataProviderResultCategory.INTERVAL_LIST.__doc__ = "Interval list."
DataProviderResultCategory.SUB_SECTION_LIST.__doc__ = "Subsection list."
DataProviderResultCategory.MESSAGE.__doc__ = "Message."
DataProviderResultCategory.DATA_SET_LIST.__doc__ = "Data set list."

agcls.AgTypeNameMap["DataProviderResultCategory"] = DataProviderResultCategory

class DataProviderType(IntEnum):
    """Specify the type of the result returned by data providers."""

    FIXED = 1
    """Not time dependent, e.g. facility position."""
    TIME_VARYING = 2
    """Time varying, e.g. satellite position."""
    INTERVAL = 4
    """Interval, e.g. lighting data."""
    ALLOW_DUPLICATE_TIMES = 256
    """Allow duplicated times."""
    STAND_ALONE = 512
    """Do not mix data from different data providers."""
    RESULTS_DEPEND_ON_INPUT_INTERVALS = 1024
    """Results depend on evaluation interval(s)."""
    NOT_AVAILABLE_FORDYNAMIC_GRAPHS_AND_STRIP_CHARTS = 2048
    """Make unavailable for dynamic displays and strip charts."""

DataProviderType.FIXED.__doc__ = "Not time dependent, e.g. facility position."
DataProviderType.TIME_VARYING.__doc__ = "Time varying, e.g. satellite position."
DataProviderType.INTERVAL.__doc__ = "Interval, e.g. lighting data."
DataProviderType.ALLOW_DUPLICATE_TIMES.__doc__ = "Allow duplicated times."
DataProviderType.STAND_ALONE.__doc__ = "Do not mix data from different data providers."
DataProviderType.RESULTS_DEPEND_ON_INPUT_INTERVALS.__doc__ = "Results depend on evaluation interval(s)."
DataProviderType.NOT_AVAILABLE_FORDYNAMIC_GRAPHS_AND_STRIP_CHARTS.__doc__ = "Make unavailable for dynamic displays and strip charts."

agcls.AgTypeNameMap["DataProviderType"] = DataProviderType

class DataProviderElementType(IntEnum):
    """Specify the type of data returned by data providers."""

    REAL = 0
    """Real number."""
    INTEGER = 1
    """Integer."""
    STRING = 2
    """Character."""
    STRING_OR_REAL = 3
    """Character or real number."""

DataProviderElementType.REAL.__doc__ = "Real number."
DataProviderElementType.INTEGER.__doc__ = "Integer."
DataProviderElementType.STRING.__doc__ = "Character."
DataProviderElementType.STRING_OR_REAL.__doc__ = "Character or real number."

agcls.AgTypeNameMap["DataProviderElementType"] = DataProviderElementType

class AccessTimeType(IntEnum):
    """The time period to use for the access computation."""

    OBJECT_ACCESS_TIME = 0
    """Use the start and stop time set for the objects involved in the access calculations as a time period for the access computation."""
    SCENARIO_INTERVAL = 1
    """Use the start and stop time set at the scenario level as a time period for the access computation."""
    SPECIFIED_TIME_PERIOD = 2
    """The option is used to select a user-specified start and stop time to define the time period for the access computation."""
    TIME_INTERVALS = 3
    """The option is used to select a collection of intervals to define the time period for the access computation."""
    TIME_INTERVAL_LIST = 4
    """The option is used to select an event interval list to define the time period for the access computation."""

AccessTimeType.OBJECT_ACCESS_TIME.__doc__ = "Use the start and stop time set for the objects involved in the access calculations as a time period for the access computation."
AccessTimeType.SCENARIO_INTERVAL.__doc__ = "Use the start and stop time set at the scenario level as a time period for the access computation."
AccessTimeType.SPECIFIED_TIME_PERIOD.__doc__ = "The option is used to select a user-specified start and stop time to define the time period for the access computation."
AccessTimeType.TIME_INTERVALS.__doc__ = "The option is used to select a collection of intervals to define the time period for the access computation."
AccessTimeType.TIME_INTERVAL_LIST.__doc__ = "The option is used to select an event interval list to define the time period for the access computation."

agcls.AgTypeNameMap["AccessTimeType"] = AccessTimeType

class AltitudeReferenceType(IntEnum):
    """Altitude reference options."""

    MEAN_SEA_LEVEL = 0x0
    """Reference the altitude to Mean Sea Level."""
    TERRAIN = 0x1
    """Reference the altitude to terrain."""
    WGS84 = 0x2
    """WGS84: reference the altitude to the central body's reference ellipsoid."""
    ELLIPSOID = 0x3
    """Ellipsoid: reference the altitude to the central body's reference ellipsoid(non-Earth)."""

AltitudeReferenceType.MEAN_SEA_LEVEL.__doc__ = "Reference the altitude to Mean Sea Level."
AltitudeReferenceType.TERRAIN.__doc__ = "Reference the altitude to terrain."
AltitudeReferenceType.WGS84.__doc__ = "WGS84: reference the altitude to the central body's reference ellipsoid."
AltitudeReferenceType.ELLIPSOID.__doc__ = "Ellipsoid: reference the altitude to the central body's reference ellipsoid(non-Earth)."

agcls.AgTypeNameMap["AltitudeReferenceType"] = AltitudeReferenceType

class TerrainNormalType(IntEnum):
    """Methods of defining the slope of the local terrain for the facility, place or target."""

    SURFACE_NORMAL = 0x0
    """Surface normal: the normal to the terrain is along the local surface normal. This is equivalent to having a slope of zero."""
    SLOPE_AZIMUTH = 0x1
    """Slope/Azimuth: use input values of slope and azimuth to compute normal to the local terrain."""

TerrainNormalType.SURFACE_NORMAL.__doc__ = "Surface normal: the normal to the terrain is along the local surface normal. This is equivalent to having a slope of zero."
TerrainNormalType.SLOPE_AZIMUTH.__doc__ = "Slope/Azimuth: use input values of slope and azimuth to compute normal to the local terrain."

agcls.AgTypeNameMap["TerrainNormalType"] = TerrainNormalType

class LightingObstructionModelType(IntEnum):
    """Obstruction model used in lighting computations."""

    CENTRAL_BODY_SHAPE = 0x0
    """The lighting obstruction model is the surface of the central body ellipsoid."""
    AZ_EL_MASK = 0x1
    """Lighting obstruction is computed using the object's Az-El mask if defined, else uses the object's ground model."""
    TERRAIN = 0x2
    """Lighting obstruction is computed using terrain data."""
    GROUND_MODEL = 0x3
    """The lighting obstruction model is the object's ground model as used in the line-of-sight constraint computation."""

LightingObstructionModelType.CENTRAL_BODY_SHAPE.__doc__ = "The lighting obstruction model is the surface of the central body ellipsoid."
LightingObstructionModelType.AZ_EL_MASK.__doc__ = "Lighting obstruction is computed using the object's Az-El mask if defined, else uses the object's ground model."
LightingObstructionModelType.TERRAIN.__doc__ = "Lighting obstruction is computed using terrain data."
LightingObstructionModelType.GROUND_MODEL.__doc__ = "The lighting obstruction model is the object's ground model as used in the line-of-sight constraint computation."

agcls.AgTypeNameMap["LightingObstructionModelType"] = LightingObstructionModelType

class DisplayTimesType(IntEnum):
    """Display times options for the object."""

    UNKNOWN = -1
    """Unknown display type."""
    ALWAYS_OFF = 0x0
    """Graphics for the object never display."""
    ALWAYS_ON = 0x1
    """Graphics for the object always display."""
    DURING_ACCESS = 0x2
    """Graphics for the object display during access to specified objects."""
    INTERVALS = 0x3
    """Graphics for the object display during user-defined intervals."""
    DURING_CHAIN_ACCESS = 0x4
    """Graphics for the object display during chain access."""
    TIME_COMPONENT = 5
    """Graphics for the object display during the intervals provided by an interval or interval list time component."""

DisplayTimesType.UNKNOWN.__doc__ = "Unknown display type."
DisplayTimesType.ALWAYS_OFF.__doc__ = "Graphics for the object never display."
DisplayTimesType.ALWAYS_ON.__doc__ = "Graphics for the object always display."
DisplayTimesType.DURING_ACCESS.__doc__ = "Graphics for the object display during access to specified objects."
DisplayTimesType.INTERVALS.__doc__ = "Graphics for the object display during user-defined intervals."
DisplayTimesType.DURING_CHAIN_ACCESS.__doc__ = "Graphics for the object display during chain access."
DisplayTimesType.TIME_COMPONENT.__doc__ = "Graphics for the object display during the intervals provided by an interval or interval list time component."

agcls.AgTypeNameMap["DisplayTimesType"] = DisplayTimesType

class AreaType(IntEnum):
    """Methods of defining the area target's boundaries."""

    ELLIPSE = 0x0
    """Define the an elliptical area boundary using semimajor axis, semiminor axis and bearing."""
    PATTERN = 0x1
    """Specify perimeter points to define the boundary."""

AreaType.ELLIPSE.__doc__ = "Define the an elliptical area boundary using semimajor axis, semiminor axis and bearing."
AreaType.PATTERN.__doc__ = "Specify perimeter points to define the boundary."

agcls.AgTypeNameMap["AreaType"] = AreaType

class TrajectoryType(IntEnum):
    """Trajectory type for a point."""

    POINT = 0x0
    """Displays a point at the current animation time."""
    TRACE = 0x1
    """Displays a sampled trajectory of a point. This sampled trajectory displays where the point is over time without animating the scenario."""
    LINE = 0x2
    """Displays a line connecting all sampled points in the trajectory and displays lines from each sampled point in the trajectory to the center of the reference coordinate system in which the trajectory is computed."""

TrajectoryType.POINT.__doc__ = "Displays a point at the current animation time."
TrajectoryType.TRACE.__doc__ = "Displays a sampled trajectory of a point. This sampled trajectory displays where the point is over time without animating the scenario."
TrajectoryType.LINE.__doc__ = "Displays a line connecting all sampled points in the trajectory and displays lines from each sampled point in the trajectory to the center of the reference coordinate system in which the trajectory is computed."

agcls.AgTypeNameMap["TrajectoryType"] = TrajectoryType

class OffsetFrameType(IntEnum):
    """Frame options for label offset."""

    CARTESIAN = 0x0
    """Use cartesian values to offset the label."""
    PIXEL = 0x1
    """Use pixel values to offset the label."""

OffsetFrameType.CARTESIAN.__doc__ = "Use cartesian values to offset the label."
OffsetFrameType.PIXEL.__doc__ = "Use pixel values to offset the label."

agcls.AgTypeNameMap["OffsetFrameType"] = OffsetFrameType

class Scenario3dPointSize(IntEnum):
    """Font size in points."""

    FONT_SIZE_8 = 8
    """Font size: 8 points."""
    FONT_SIZE_9 = 9
    """Font size: 9 points."""
    FONT_SIZE_10 = 10
    """Font size: 10 points."""
    FONT_SIZE_11 = 11
    """Font size: 11 points."""
    FONT_SIZE_12 = 12
    """Font size: 12 points."""
    FONT_SIZE_14 = 14
    """Font size: 14 points."""
    FONT_SIZE_16 = 16
    """Font size: 16 points."""
    FONT_SIZE_18 = 18
    """Font size: 18 points."""
    FONT_SIZE_20 = 20
    """Font size: 20 points."""
    FONT_SIZE_22 = 22
    """Font size: 22 points."""
    FONT_SIZE_24 = 24
    """Font size: 24 points."""
    FONT_SIZE_26 = 26
    """Font size: 26 points."""
    FONT_SIZE_28 = 28
    """Font size: 28 points."""
    FONT_SIZE_36 = 36
    """Font size: 36 points."""
    FONT_SIZE_48 = 48
    """Font size: 48 points."""
    FONT_SIZE_72 = 72
    """Font size: 72 points."""

Scenario3dPointSize.FONT_SIZE_8.__doc__ = "Font size: 8 points."
Scenario3dPointSize.FONT_SIZE_9.__doc__ = "Font size: 9 points."
Scenario3dPointSize.FONT_SIZE_10.__doc__ = "Font size: 10 points."
Scenario3dPointSize.FONT_SIZE_11.__doc__ = "Font size: 11 points."
Scenario3dPointSize.FONT_SIZE_12.__doc__ = "Font size: 12 points."
Scenario3dPointSize.FONT_SIZE_14.__doc__ = "Font size: 14 points."
Scenario3dPointSize.FONT_SIZE_16.__doc__ = "Font size: 16 points."
Scenario3dPointSize.FONT_SIZE_18.__doc__ = "Font size: 18 points."
Scenario3dPointSize.FONT_SIZE_20.__doc__ = "Font size: 20 points."
Scenario3dPointSize.FONT_SIZE_22.__doc__ = "Font size: 22 points."
Scenario3dPointSize.FONT_SIZE_24.__doc__ = "Font size: 24 points."
Scenario3dPointSize.FONT_SIZE_26.__doc__ = "Font size: 26 points."
Scenario3dPointSize.FONT_SIZE_28.__doc__ = "Font size: 28 points."
Scenario3dPointSize.FONT_SIZE_36.__doc__ = "Font size: 36 points."
Scenario3dPointSize.FONT_SIZE_48.__doc__ = "Font size: 48 points."
Scenario3dPointSize.FONT_SIZE_72.__doc__ = "Font size: 72 points."

agcls.AgTypeNameMap["Scenario3dPointSize"] = Scenario3dPointSize

class TerrainFileType(IntEnum):
    """Terrain file type options."""

    USGS_DEM = 0
    """U.S. Geological Survey Digital Elevation Model. Moderate resolution."""
    GTOPO30 = 1
    """GTOPO30 global digital elevation model with horizontal grid spacing of 30 arc seconds. Use this for STK World terrain."""
    NIMA_NGA_TERRAIN_DIRECTORY = 2
    """NGA Digital Terrain Elevation Data (DTED)."""
    MOLA_TERRAIN = 3
    """Mars Orbiter Laser Altimeter (MOLA)terrain data."""
    GEODAS_GRID_DATA = 5
    """GEODAS (GEOphysical DAta System), an interactive database management system developed by the National Geophysical Data Center (NGDC) for use in the assimilation, storage and retrieval of geophysical data."""
    MUSE_RASTER_FILE = 6
    """MUSE Raster File: NGA elevation data that has been converted using the MUSE software raster importer. MUSE terrain files contain position information."""
    NIM0_NIMA_NGA_DTED_LEVEL_0 = 7
    """NIM0 NIMA/NGA DTED Level 0 (.dto)."""
    NIM1_NIMA_NGA_DTED_LEVEL_1 = 8
    """NIM1 NIMA/NGA DTED Level 1 (.dt1)."""
    NIM2_NIMA_NGA_DTED_LEVEL_2 = 9
    """NIM2 NIMA/NGA DTED Level 2 (.dt2)."""
    NIM3_NIMA_NGA_DTED_LEVEL_3 = 10
    """NIM3 NIMA/NGA DTED Level 3 (.dt3)."""
    NIM4_NIMA_NGA_DTED_LEVEL_4 = 11
    """NIM4  NIMA/NGA DTED Level 4 (.dt4)."""
    NIM5_NIMA_NGA_DTED_LEVEL_5 = 12
    """NIM5 NIMA/NGA DTED Level 5 (.dt5)."""
    ARC_INFO_BINARY_GRID = 13
    """Arc/Info Binary Grid Files (.adf)."""
    ARC_INFO_BINARY_GRID_MEAN_SEA_LEVEL = 14
    """Arc/Info Binary Grid - MSL (.adf)."""
    PDTT = 15
    """AGI Terrain File (.pdtt)."""
    AGI_WORLD_TERRAIN = 16
    """AGI World Terrain File (.hdr)."""
    TIFF_TERRAIN_FILE_IN_MEAN_SEA_LEVEL = 17
    """Tagged Image File Format - MSL (.tif)."""
    TIFF_TERRAIN_FILE = 18
    """Tagged Image File Format (.tif)."""
    ARC_INFO_GRID_DEPTH_MEAN_SEA_LEVEL = 19
    """ArcInfo Grid Depth MSL (.adf)."""

TerrainFileType.USGS_DEM.__doc__ = "U.S. Geological Survey Digital Elevation Model. Moderate resolution."
TerrainFileType.GTOPO30.__doc__ = "GTOPO30 global digital elevation model with horizontal grid spacing of 30 arc seconds. Use this for STK World terrain."
TerrainFileType.NIMA_NGA_TERRAIN_DIRECTORY.__doc__ = "NGA Digital Terrain Elevation Data (DTED)."
TerrainFileType.MOLA_TERRAIN.__doc__ = "Mars Orbiter Laser Altimeter (MOLA)terrain data."
TerrainFileType.GEODAS_GRID_DATA.__doc__ = "GEODAS (GEOphysical DAta System), an interactive database management system developed by the National Geophysical Data Center (NGDC) for use in the assimilation, storage and retrieval of geophysical data."
TerrainFileType.MUSE_RASTER_FILE.__doc__ = "MUSE Raster File: NGA elevation data that has been converted using the MUSE software raster importer. MUSE terrain files contain position information."
TerrainFileType.NIM0_NIMA_NGA_DTED_LEVEL_0.__doc__ = "NIM0 NIMA/NGA DTED Level 0 (.dto)."
TerrainFileType.NIM1_NIMA_NGA_DTED_LEVEL_1.__doc__ = "NIM1 NIMA/NGA DTED Level 1 (.dt1)."
TerrainFileType.NIM2_NIMA_NGA_DTED_LEVEL_2.__doc__ = "NIM2 NIMA/NGA DTED Level 2 (.dt2)."
TerrainFileType.NIM3_NIMA_NGA_DTED_LEVEL_3.__doc__ = "NIM3 NIMA/NGA DTED Level 3 (.dt3)."
TerrainFileType.NIM4_NIMA_NGA_DTED_LEVEL_4.__doc__ = "NIM4  NIMA/NGA DTED Level 4 (.dt4)."
TerrainFileType.NIM5_NIMA_NGA_DTED_LEVEL_5.__doc__ = "NIM5 NIMA/NGA DTED Level 5 (.dt5)."
TerrainFileType.ARC_INFO_BINARY_GRID.__doc__ = "Arc/Info Binary Grid Files (.adf)."
TerrainFileType.ARC_INFO_BINARY_GRID_MEAN_SEA_LEVEL.__doc__ = "Arc/Info Binary Grid - MSL (.adf)."
TerrainFileType.PDTT.__doc__ = "AGI Terrain File (.pdtt)."
TerrainFileType.AGI_WORLD_TERRAIN.__doc__ = "AGI World Terrain File (.hdr)."
TerrainFileType.TIFF_TERRAIN_FILE_IN_MEAN_SEA_LEVEL.__doc__ = "Tagged Image File Format - MSL (.tif)."
TerrainFileType.TIFF_TERRAIN_FILE.__doc__ = "Tagged Image File Format (.tif)."
TerrainFileType.ARC_INFO_GRID_DEPTH_MEAN_SEA_LEVEL.__doc__ = "ArcInfo Grid Depth MSL (.adf)."

agcls.AgTypeNameMap["TerrainFileType"] = TerrainFileType

class Tileset3DSourceType(IntEnum):
    """3DTileset source type options."""

    LOCAL_FILE = 0
    """Local File."""
    GCS = 1
    """Geospatial Content Server."""
    CESIUM_ION = 2
    """Cesium ion."""
    GOOGLE_MAPS = 3
    """Google Maps."""

Tileset3DSourceType.LOCAL_FILE.__doc__ = "Local File."
Tileset3DSourceType.GCS.__doc__ = "Geospatial Content Server."
Tileset3DSourceType.CESIUM_ION.__doc__ = "Cesium ion."
Tileset3DSourceType.GOOGLE_MAPS.__doc__ = "Google Maps."

agcls.AgTypeNameMap["Tileset3DSourceType"] = Tileset3DSourceType

class MarkerType(IntEnum):
    """Marker style options for a waypoint."""

    SHAPE = 0x0
    """Marker style is a shape (point, star, circle, etc.)."""
    IMAGE_FILE = 0x1
    """Marker style is an image from a file."""

MarkerType.SHAPE.__doc__ = "Marker style is a shape (point, star, circle, etc.)."
MarkerType.IMAGE_FILE.__doc__ = "Marker style is an image from a file."

agcls.AgTypeNameMap["MarkerType"] = MarkerType

class VectorAxesConnectType(IntEnum):
    """Methods for connecting geometric elements."""

    TRACE = 0x0
    """Trace: a single-line arc represents the path of the element."""
    SWEEP = 0x1
    """Sweep: a continuous band of color represents the path of the element."""
    LINE = 0x2
    """Line: a line is drawn at every time step representing the position of the element."""

VectorAxesConnectType.TRACE.__doc__ = "Trace: a single-line arc represents the path of the element."
VectorAxesConnectType.SWEEP.__doc__ = "Sweep: a continuous band of color represents the path of the element."
VectorAxesConnectType.LINE.__doc__ = "Line: a line is drawn at every time step representing the position of the element."

agcls.AgTypeNameMap["VectorAxesConnectType"] = VectorAxesConnectType

class Graphics3DMarkerOriginType(IntEnum):
    """Options for the Graphics3DMarker X or Y Origin property."""

    LEFT = 0x0
    """X origin: left."""
    RIGHT = 0x1
    """X origin: right."""
    CENTER = 0x2
    """X origin: center."""
    TOP = 0x3
    """Y origin: top."""
    BOTTOM = 0x4
    """Y origin: bottom."""

Graphics3DMarkerOriginType.LEFT.__doc__ = "X origin: left."
Graphics3DMarkerOriginType.RIGHT.__doc__ = "X origin: right."
Graphics3DMarkerOriginType.CENTER.__doc__ = "X origin: center."
Graphics3DMarkerOriginType.TOP.__doc__ = "Y origin: top."
Graphics3DMarkerOriginType.BOTTOM.__doc__ = "Y origin: bottom."

agcls.AgTypeNameMap["Graphics3DMarkerOriginType"] = Graphics3DMarkerOriginType

class Graphics3DLabelSwapDistanceType(IntEnum):
    """Label swap distance options."""

    UNKNOWN = -1
    """Unknown label swap distance option."""
    ALL = 0
    """All."""
    MODEL_LABEL = 1
    """Model Label."""
    MARKER_LABEL = 2
    """Marker Label."""
    MARKER = 3
    """Marker."""
    POINT = 4
    """Point."""
    CUSTOM = 5
    """Indicate that label swap distance is set to custom value."""

Graphics3DLabelSwapDistanceType.UNKNOWN.__doc__ = "Unknown label swap distance option."
Graphics3DLabelSwapDistanceType.ALL.__doc__ = "All."
Graphics3DLabelSwapDistanceType.MODEL_LABEL.__doc__ = "Model Label."
Graphics3DLabelSwapDistanceType.MARKER_LABEL.__doc__ = "Marker Label."
Graphics3DLabelSwapDistanceType.MARKER.__doc__ = "Marker."
Graphics3DLabelSwapDistanceType.POINT.__doc__ = "Point."
Graphics3DLabelSwapDistanceType.CUSTOM.__doc__ = "Indicate that label swap distance is set to custom value."

agcls.AgTypeNameMap["Graphics3DLabelSwapDistanceType"] = Graphics3DLabelSwapDistanceType

class PlanetPositionSourceType(IntEnum):
    """Options for defining a planet."""

    FILE = 0x0
    """Use a planetary ephemeris (.pe) file to define the planet."""
    CENTRAL_BODY = 0x1
    """Specify the name of a central body to define the planet."""

PlanetPositionSourceType.FILE.__doc__ = "Use a planetary ephemeris (.pe) file to define the planet."
PlanetPositionSourceType.CENTRAL_BODY.__doc__ = "Specify the name of a central body to define the planet."

agcls.AgTypeNameMap["PlanetPositionSourceType"] = PlanetPositionSourceType

class EphemSourceType(IntEnum):
    """Central body ephemeris sources."""

    ANALYTIC = 0x0
    """Analytic ephemeris: use an analytic propagator. Available when orbital elements are known for the Central Body about its parent."""
    DEFAULT = 0x2
    """Default: use STK's internal definition of the Central Body to generate ephemeris. By default, STK's internal definition uses the DE file if available."""
    SPICE = 0x3
    """SPICE: use the SPICE toolkit to generate ephemeris. Available only if a SPICE ephemeris file (.bsp) has been loaded for the selected planet."""
    JPL_DEVELOPMENTAL_EPHEMERIS = 0x4
    """Default JPL DE file."""

EphemSourceType.ANALYTIC.__doc__ = "Analytic ephemeris: use an analytic propagator. Available when orbital elements are known for the Central Body about its parent."
EphemSourceType.DEFAULT.__doc__ = "Default: use STK's internal definition of the Central Body to generate ephemeris. By default, STK's internal definition uses the DE file if available."
EphemSourceType.SPICE.__doc__ = "SPICE: use the SPICE toolkit to generate ephemeris. Available only if a SPICE ephemeris file (.bsp) has been loaded for the selected planet."
EphemSourceType.JPL_DEVELOPMENTAL_EPHEMERIS.__doc__ = "Default JPL DE file."

agcls.AgTypeNameMap["EphemSourceType"] = EphemSourceType

class PlanetOrbitDisplayType(IntEnum):
    """Orbit display options for a planet."""

    ONE_ORBIT = 0x0
    """Display one full orbit."""
    ORBIT_DISPLAY_TIME = 0x1
    """Define the displayed orbit segment in terms of the amount of the orbit traversed by the planet during the selected interval, split evenly between trailing and leading portions."""

PlanetOrbitDisplayType.ONE_ORBIT.__doc__ = "Display one full orbit."
PlanetOrbitDisplayType.ORBIT_DISPLAY_TIME.__doc__ = "Define the displayed orbit segment in terms of the amount of the orbit traversed by the planet during the selected interval, split evenly between trailing and leading portions."

agcls.AgTypeNameMap["PlanetOrbitDisplayType"] = PlanetOrbitDisplayType

class ScenarioEndLoopType(IntEnum):
    """Scenario animation cycle options."""

    END_TIME = 0x0
    """Stop animation at the specified time."""
    LOOP_AT_TIME = 0x1
    """Loop and continue the animation at the specified time."""

ScenarioEndLoopType.END_TIME.__doc__ = "Stop animation at the specified time."
ScenarioEndLoopType.LOOP_AT_TIME.__doc__ = "Loop and continue the animation at the specified time."

agcls.AgTypeNameMap["ScenarioEndLoopType"] = ScenarioEndLoopType

class ScenarioRefreshDeltaType(IntEnum):
    """Scenario animation refresh update options."""

    HIGH_SPEED = 0x0
    """High speed: STK refreshes the screen as fast as the system is able."""
    REFRESH_DELTA = 0x1
    """Refresh delta: the amount of time between refresh updates, limited by the minimum time necessary to draw the scenario."""

ScenarioRefreshDeltaType.HIGH_SPEED.__doc__ = "High speed: STK refreshes the screen as fast as the system is able."
ScenarioRefreshDeltaType.REFRESH_DELTA.__doc__ = "Refresh delta: the amount of time between refresh updates, limited by the minimum time necessary to draw the scenario."

agcls.AgTypeNameMap["ScenarioRefreshDeltaType"] = ScenarioRefreshDeltaType

class SensorPattern(IntEnum):
    """Sensor patterns."""

    COMPLEX_CONIC = 0x0
    """Complex conic: defined by specified inner and outer half angles and minimum and maximum clock angles."""
    CUSTOM = 0x1
    """Custom: import a custom sensor pattern file."""
    HALF_POWER = 0x2
    """Half power: models a parabolic antenna."""
    RECTANGULAR = 0x3
    """Rectangular: specify vertical and horizontal half-angles that will be used to model the field of view of an instrument."""
    SAR = 0x4
    """SAR: synthesizes the aperture of a larger antenna than is actually present, using SAR pattern definitions designed to model the field of regard of a SAR sensor onto the surface of the earth."""
    SIMPLE_CONIC = 0x5
    """Simple conic: defined by a specified cone angle."""
    EOIR = 0x6
    """EOIR: defined by Band Properties."""
    UNKNOWN = 0xff
    """Unknown/unsupported sensor pattern."""

SensorPattern.COMPLEX_CONIC.__doc__ = "Complex conic: defined by specified inner and outer half angles and minimum and maximum clock angles."
SensorPattern.CUSTOM.__doc__ = "Custom: import a custom sensor pattern file."
SensorPattern.HALF_POWER.__doc__ = "Half power: models a parabolic antenna."
SensorPattern.RECTANGULAR.__doc__ = "Rectangular: specify vertical and horizontal half-angles that will be used to model the field of view of an instrument."
SensorPattern.SAR.__doc__ = "SAR: synthesizes the aperture of a larger antenna than is actually present, using SAR pattern definitions designed to model the field of regard of a SAR sensor onto the surface of the earth."
SensorPattern.SIMPLE_CONIC.__doc__ = "Simple conic: defined by a specified cone angle."
SensorPattern.EOIR.__doc__ = "EOIR: defined by Band Properties."
SensorPattern.UNKNOWN.__doc__ = "Unknown/unsupported sensor pattern."

agcls.AgTypeNameMap["SensorPattern"] = SensorPattern

class SensorPointing(IntEnum):
    """Sensor pointing options."""

    ELEMENT_OF_3D_MODEL = 0x0
    """3D model: point a sensor along one of the available elements of the selected 3D Model."""
    FILE = 0x1
    """External: import a custom sensor pointing file."""
    FIXED_IN_PARENT_BODY_AXES = 0x2
    """Fixed: model sensors that are fixed in the parent object's body coordinate frame, so that they always point in the same direction relative to the parent."""
    FIXED_IN_AXES = 0x3
    """Fixed in axes: point a sensor with reference to a set of axes, using the selected orientation system."""
    SPINNING = 0x4
    """Spinning: model radars, push broom sensors and other instruments that spin, scan or sweep over time."""
    TARGETED = 0x5
    """Targeted: model sensors that track other objects."""
    BORESIGHT_GRAZING_ALTITUDE = 0x6
    """Grazing altitude: model a sensor so that the boresight vector will graze the central body at a specified altitude."""
    ALONG_VECTOR = 0x7
    """Along Vector: model a sensor so that sensor pointing alignment is controlled by using a pair of vectors defined using the Vector Geometry tool."""
    SCHEDULED = 0x8
    """Schedule: controls scheduled sensor pointing."""

SensorPointing.ELEMENT_OF_3D_MODEL.__doc__ = "3D model: point a sensor along one of the available elements of the selected 3D Model."
SensorPointing.FILE.__doc__ = "External: import a custom sensor pointing file."
SensorPointing.FIXED_IN_PARENT_BODY_AXES.__doc__ = "Fixed: model sensors that are fixed in the parent object's body coordinate frame, so that they always point in the same direction relative to the parent."
SensorPointing.FIXED_IN_AXES.__doc__ = "Fixed in axes: point a sensor with reference to a set of axes, using the selected orientation system."
SensorPointing.SPINNING.__doc__ = "Spinning: model radars, push broom sensors and other instruments that spin, scan or sweep over time."
SensorPointing.TARGETED.__doc__ = "Targeted: model sensors that track other objects."
SensorPointing.BORESIGHT_GRAZING_ALTITUDE.__doc__ = "Grazing altitude: model a sensor so that the boresight vector will graze the central body at a specified altitude."
SensorPointing.ALONG_VECTOR.__doc__ = "Along Vector: model a sensor so that sensor pointing alignment is controlled by using a pair of vectors defined using the Vector Geometry tool."
SensorPointing.SCHEDULED.__doc__ = "Schedule: controls scheduled sensor pointing."

agcls.AgTypeNameMap["SensorPointing"] = SensorPointing

class SensorPointingTargetedBoresightType(IntEnum):
    """Boresight types for sensors of targeted pointing type."""

    TRACKING = 0x0
    """Tracking: the sensor is aimed at one or more selected targets."""
    FIXED = 0x1
    """Fixed: the sensor always points in a fixed direction."""

SensorPointingTargetedBoresightType.TRACKING.__doc__ = "Tracking: the sensor is aimed at one or more selected targets."
SensorPointingTargetedBoresightType.FIXED.__doc__ = "Fixed: the sensor always points in a fixed direction."

agcls.AgTypeNameMap["SensorPointingTargetedBoresightType"] = SensorPointingTargetedBoresightType

class BoresightType(IntEnum):
    """About boresight options for sensors of targeted pointing type."""

    HOLD = 0x0
    """Hold: rotation about the Y axis followed by rotation about the new X-axis."""
    LEVEL = 0x1
    """Level: boresight is aligned with the line of sight to the target, while the sensor's x-axis is constrained to be in the plane parallel to the meridian plane passing through the target."""
    ROTATE = 0x2
    """Rotate: rotation about the sensor's or antenna's Z axis by the azimuth angle, followed by rotation about the new Y axis by 90 degrees minus the elevation angle."""
    UP_VECTOR = 0x3
    """UpVector: boresight is aligned with the line of sight to the target, while the specified constraint direction lies at a specified clock angle about the boresight from the sensor's x-axis."""

BoresightType.HOLD.__doc__ = "Hold: rotation about the Y axis followed by rotation about the new X-axis."
BoresightType.LEVEL.__doc__ = "Level: boresight is aligned with the line of sight to the target, while the sensor's x-axis is constrained to be in the plane parallel to the meridian plane passing through the target."
BoresightType.ROTATE.__doc__ = "Rotate: rotation about the sensor's or antenna's Z axis by the azimuth angle, followed by rotation about the new Y axis by 90 degrees minus the elevation angle."
BoresightType.UP_VECTOR.__doc__ = "UpVector: boresight is aligned with the line of sight to the target, while the specified constraint direction lies at a specified clock angle about the boresight from the sensor's x-axis."

agcls.AgTypeNameMap["BoresightType"] = BoresightType

class TrackMode(IntEnum):
    """Track mode options for tracking boresights."""

    RECEIVE = 0x0
    """Receive: the antenna is oriented slightly behind the current location of the other object."""
    TRANSMIT = 0x1
    """Transmit: the antenna is oriented slightly ahead of the current location of the other object."""
    TRANSPOND = 0x2
    """Transpond: the antenna points to the true location of the target object."""

TrackMode.RECEIVE.__doc__ = "Receive: the antenna is oriented slightly behind the current location of the other object."
TrackMode.TRANSMIT.__doc__ = "Transmit: the antenna is oriented slightly ahead of the current location of the other object."
TrackMode.TRANSPOND.__doc__ = "Transpond: the antenna points to the true location of the target object."

agcls.AgTypeNameMap["TrackMode"] = TrackMode

class SensorAzElBoresightAxisType(IntEnum):
    """Primary boresight axis for Sensor Az-El mask."""

    X_AXIS = 0x0
    """+/-X: calculate the primary boresight axis using the parent's body-fixed X axis."""
    Y_AXIS = 0x1
    """+/-Y: calculate the primary boresight axis using the parent's body-fixed Y axis."""
    Z_AXIS = 0x2
    """+/-Z: calculate the primary boresight axis using the parent's body-fixed Z axis."""

SensorAzElBoresightAxisType.X_AXIS.__doc__ = "+/-X: calculate the primary boresight axis using the parent's body-fixed X axis."
SensorAzElBoresightAxisType.Y_AXIS.__doc__ = "+/-Y: calculate the primary boresight axis using the parent's body-fixed Y axis."
SensorAzElBoresightAxisType.Z_AXIS.__doc__ = "+/-Z: calculate the primary boresight axis using the parent's body-fixed Z axis."

agcls.AgTypeNameMap["SensorAzElBoresightAxisType"] = SensorAzElBoresightAxisType

class SensorRefractionType(IntEnum):
    """Sensor refraction models."""

    EARTH_FOUR_THIRDS_RADIUS_METHOD = 0x0
    """4/3 Earth Radius: computes the apparent elevation due to refraction by assuming an Earth radius 4/3 of its actual value."""
    SCF_METHOD = 0x2
    """SCF Method: an implementation of the Refraction Correction model,which takes as input the surface refractivity at each facility location, based on local temperature, pressure and humidity, correcting elevation and range from apparent to true."""
    ITU_R_P834_4 = 0x3
    """ITU-R P.834-4: Compute the refracted elevation based on the non-refracted elevation angle and the mean sea level (MSL) altitude of the sensor, using empirical criteria that are contained in ITU-R P.834-4."""

SensorRefractionType.EARTH_FOUR_THIRDS_RADIUS_METHOD.__doc__ = "4/3 Earth Radius: computes the apparent elevation due to refraction by assuming an Earth radius 4/3 of its actual value."
SensorRefractionType.SCF_METHOD.__doc__ = "SCF Method: an implementation of the Refraction Correction model,which takes as input the surface refractivity at each facility location, based on local temperature, pressure and humidity, correcting elevation and range from apparent to true."
SensorRefractionType.ITU_R_P834_4.__doc__ = "ITU-R P.834-4: Compute the refracted elevation based on the non-refracted elevation angle and the mean sea level (MSL) altitude of the sensor, using empirical criteria that are contained in ITU-R P.834-4."

agcls.AgTypeNameMap["SensorRefractionType"] = SensorRefractionType

class SensorProjectionDistanceType(IntEnum):
    """Sensor 2D Graphics Projection 'Project To' options."""

    CONSTANT_ALTITUDE = 0x0
    """Constant altitude: projects the sensor to one or more altitudes above the facility/place/target, measured along the normal to the surface of the parent."""
    CONSTANT_RANGE_FROM_PARENT = 0x1
    """Constant range from parent object: projects the sensor to one or more ranges from the parent facility/place/target."""
    OBJECT_ALTITUDE = 0x2
    """Object altitude: projects the sensor to the altitude of a selected vehicle."""
    RANGE_CONSTRAINT = 0x3
    """Range constraint: projects the sensor to a specified range constraint for the facility, place or target."""

SensorProjectionDistanceType.CONSTANT_ALTITUDE.__doc__ = "Constant altitude: projects the sensor to one or more altitudes above the facility/place/target, measured along the normal to the surface of the parent."
SensorProjectionDistanceType.CONSTANT_RANGE_FROM_PARENT.__doc__ = "Constant range from parent object: projects the sensor to one or more ranges from the parent facility/place/target."
SensorProjectionDistanceType.OBJECT_ALTITUDE.__doc__ = "Object altitude: projects the sensor to the altitude of a selected vehicle."
SensorProjectionDistanceType.RANGE_CONSTRAINT.__doc__ = "Range constraint: projects the sensor to a specified range constraint for the facility, place or target."

agcls.AgTypeNameMap["SensorProjectionDistanceType"] = SensorProjectionDistanceType

class SensorLocation(IntEnum):
    """Sensor Location Type options."""

    FIXED = 0x0
    """Fixed: the location of the sensor is defined using a fixed displacement vector with respect to the parent objects body frame."""
    MODEL_3D = 0x1
    """3D Model: the location of the sensor is defined using the sensor's 3D Graphics Vertex Offset properties."""
    MODEL_3D_WITH_SCALE = 0x2
    """3D Model with Scale: the location of the sensor is defined using the sensor's 3D Graphics Vertex Offset properties. Location is computed using the scaled model defined for visualization."""
    CENTER = 0x3
    """Center: the sensor is located at the center of its parent object."""
    POINT = 0x4
    """Point: the sensor's location is based upon a Vector Geometry Tool point."""

SensorLocation.FIXED.__doc__ = "Fixed: the location of the sensor is defined using a fixed displacement vector with respect to the parent objects body frame."
SensorLocation.MODEL_3D.__doc__ = "3D Model: the location of the sensor is defined using the sensor's 3D Graphics Vertex Offset properties."
SensorLocation.MODEL_3D_WITH_SCALE.__doc__ = "3D Model with Scale: the location of the sensor is defined using the sensor's 3D Graphics Vertex Offset properties. Location is computed using the scaled model defined for visualization."
SensorLocation.CENTER.__doc__ = "Center: the sensor is located at the center of its parent object."
SensorLocation.POINT.__doc__ = "Point: the sensor's location is based upon a Vector Geometry Tool point."

agcls.AgTypeNameMap["SensorLocation"] = SensorLocation

class ScenarioTimeStepType(IntEnum):
    """Scenario animation time step options."""

    REAL_TIME = 0x0
    """Real time: the scenario animates in real time in accordance with the computer's internal clock."""
    STEP = 0x1
    """Time step: the time interval that each animation step represents. The greater this value, the greater the distance a vehicle will move in the 2D and 3D windows each time the screen is refreshed."""
    X_REAL_TIME = 0x2
    """X real time: the scenario animates at a specified multiple of real time."""
    ARRAY = 0x3
    """Time array increment: the scenario steps through times in the time array at the specified value."""

ScenarioTimeStepType.REAL_TIME.__doc__ = "Real time: the scenario animates in real time in accordance with the computer's internal clock."
ScenarioTimeStepType.STEP.__doc__ = "Time step: the time interval that each animation step represents. The greater this value, the greater the distance a vehicle will move in the 2D and 3D windows each time the screen is refreshed."
ScenarioTimeStepType.X_REAL_TIME.__doc__ = "X real time: the scenario animates at a specified multiple of real time."
ScenarioTimeStepType.ARRAY.__doc__ = "Time array increment: the scenario steps through times in the time array at the specified value."

agcls.AgTypeNameMap["ScenarioTimeStepType"] = ScenarioTimeStepType

class NoteShowType(IntEnum):
    """Options for specifying when a label note displays."""

    ON = 0x0
    """The label notes display."""
    OFF = 0x1
    """The label notes do not display."""
    INTERVALS = 0x2
    """The label notes display during user-specified intervals."""

NoteShowType.ON.__doc__ = "The label notes display."
NoteShowType.OFF.__doc__ = "The label notes do not display."
NoteShowType.INTERVALS.__doc__ = "The label notes display during user-specified intervals."

agcls.AgTypeNameMap["NoteShowType"] = NoteShowType

class GeometricElementType(IntEnum):
    """Options for the VORefCrdn Type."""

    VECTOR_ELEMENT = 0
    """Vector geometric element."""
    AXES_ELEMENT = 1
    """Axes geometric element."""
    ANGLE_ELEMENT = 2
    """Angle geometric element."""
    POINT_ELEMENT = 3
    """Point geometric element."""
    PLANE_ELEMENT = 4
    """Plane geometric element."""

GeometricElementType.VECTOR_ELEMENT.__doc__ = "Vector geometric element."
GeometricElementType.AXES_ELEMENT.__doc__ = "Axes geometric element."
GeometricElementType.ANGLE_ELEMENT.__doc__ = "Angle geometric element."
GeometricElementType.POINT_ELEMENT.__doc__ = "Point geometric element."
GeometricElementType.PLANE_ELEMENT.__doc__ = "Plane geometric element."

agcls.AgTypeNameMap["GeometricElementType"] = GeometricElementType

class SensorScanMode(IntEnum):
    """Options for the Sensor Spinning Scan Mode."""

    UNIDIRECTIONAL = 0
    """Unidirectional: scan from a specified start angle to a specified stop angle, and then begin again at the start angle."""
    BIDIRECTIONAL = 1
    """Bidirectional: scan in both directions between a specified start angle and stop angle."""
    CONTINUOUS = 2
    """Continuous: uninterrupted motion about the spin axis."""

SensorScanMode.UNIDIRECTIONAL.__doc__ = "Unidirectional: scan from a specified start angle to a specified stop angle, and then begin again at the start angle."
SensorScanMode.BIDIRECTIONAL.__doc__ = "Bidirectional: scan in both directions between a specified start angle and stop angle."
SensorScanMode.CONTINUOUS.__doc__ = "Continuous: uninterrupted motion about the spin axis."

agcls.AgTypeNameMap["SensorScanMode"] = SensorScanMode

class ConstraintBackground(IntEnum):
    """Options for the Background constraint, and Advanced vehicle constraint."""

    GROUND = 0
    """Ground only: constrains accesses when only the ground is in the background."""
    SPACE = 1
    """Space only: constrains accesses when only space is in the background of the other object."""

ConstraintBackground.GROUND.__doc__ = "Ground only: constrains accesses when only the ground is in the background."
ConstraintBackground.SPACE.__doc__ = "Space only: constrains accesses when only space is in the background of the other object."

agcls.AgTypeNameMap["ConstraintBackground"] = ConstraintBackground

class ConstraintGroundTrack(IntEnum):
    """Options for the Ground Track constraint, an Advanced vehicle constraint."""

    ASCENDING = 0
    """Ascending: constrain access to the ascending side of the satellite's ground track, defined as the portions of the ground track where the Earth-fixed latitude increases."""
    DESCENDING = 1
    """Descending: constrain access to the descending side of the satellite's ground track, defined as the portions of the ground track where the Earth-fixed latitude decreases."""

ConstraintGroundTrack.ASCENDING.__doc__ = "Ascending: constrain access to the ascending side of the satellite's ground track, defined as the portions of the ground track where the Earth-fixed latitude increases."
ConstraintGroundTrack.DESCENDING.__doc__ = "Descending: constrain access to the descending side of the satellite's ground track, defined as the portions of the ground track where the Earth-fixed latitude decreases."

agcls.AgTypeNameMap["ConstraintGroundTrack"] = ConstraintGroundTrack

class IntersectionType(IntEnum):
    """Intersection display options for sensor projection."""

    CENTRAL_BODY = 0
    """Central body: modifies the field of view of the sensor to account for its intersections with the central body."""
    NONE = 1
    """None: does not modify the field of view of the sensor by ignoring any possible intersections."""
    TERRAIN = 2
    """Terrain: modifies the field of view of the sensor to account for its intersections with the central body and terrain, defined by its North, South, East and West boundaries."""

IntersectionType.CENTRAL_BODY.__doc__ = "Central body: modifies the field of view of the sensor to account for its intersections with the central body."
IntersectionType.NONE.__doc__ = "None: does not modify the field of view of the sensor by ignoring any possible intersections."
IntersectionType.TERRAIN.__doc__ = "Terrain: modifies the field of view of the sensor to account for its intersections with the central body and terrain, defined by its North, South, East and West boundaries."

agcls.AgTypeNameMap["IntersectionType"] = IntersectionType

class ConstraintLighting(IntEnum):
    """Options for the Lighting access constraint."""

    DIRECT_SUN = 0
    """Direct sun."""
    PENUMBRA = 1
    """Penumbra."""
    PENUMBRA_OR_DIRECT_SUN = 2
    """Penumbra or direct sun."""
    PENUMBRA_OR_UMBRA = 3
    """Penumbra or umbra."""
    UMBRA = 4
    """Umbra."""
    UMBRA_OR_DIRECT_SUN = 5
    """Umbra or direct sun."""

ConstraintLighting.DIRECT_SUN.__doc__ = "Direct sun."
ConstraintLighting.PENUMBRA.__doc__ = "Penumbra."
ConstraintLighting.PENUMBRA_OR_DIRECT_SUN.__doc__ = "Penumbra or direct sun."
ConstraintLighting.PENUMBRA_OR_UMBRA.__doc__ = "Penumbra or umbra."
ConstraintLighting.UMBRA.__doc__ = "Umbra."
ConstraintLighting.UMBRA_OR_DIRECT_SUN.__doc__ = "Umbra or direct sun."

agcls.AgTypeNameMap["ConstraintLighting"] = ConstraintLighting

class SensorGraphics3DProjectionType(IntEnum):
    """Options for a sensor's 3D Graphics Projection Type."""

    ALL_INTERSECTIONS = 0
    """All intersections: the entire sensor projection is displayed."""
    CENTRAL_BODY_INTERSECTIONS = 1
    """Earth intersections: 0nly the portion of the sensor projection that intersects the Earth is displayed."""
    NONE = 2
    """None: no projection is displayed for sensors attached to facilities. For other objects, the part of the sensor projection that does not intersect with the central body is displayed."""

SensorGraphics3DProjectionType.ALL_INTERSECTIONS.__doc__ = "All intersections: the entire sensor projection is displayed."
SensorGraphics3DProjectionType.CENTRAL_BODY_INTERSECTIONS.__doc__ = "Earth intersections: 0nly the portion of the sensor projection that intersects the Earth is displayed."
SensorGraphics3DProjectionType.NONE.__doc__ = "None: no projection is displayed for sensors attached to facilities. For other objects, the part of the sensor projection that does not intersect with the central body is displayed."

agcls.AgTypeNameMap["SensorGraphics3DProjectionType"] = SensorGraphics3DProjectionType

class SensorGraphics3DPulseStyle(IntEnum):
    """Options for a sensor's 3D Graphics Pulse Style."""

    BOX = 0
    """Box style."""
    NEGATIVE_BOX = 1
    """Negative box style."""
    POSITIVE_BOX = 2
    """Positive box style."""
    SINE_WAVE = 3
    """Sine style."""
    NEGATIVE_SINE_WAVE = 4
    """Negative sine style."""
    POSITIVE_SINE_WAVE = 5
    """Positive sine style."""

SensorGraphics3DPulseStyle.BOX.__doc__ = "Box style."
SensorGraphics3DPulseStyle.NEGATIVE_BOX.__doc__ = "Negative box style."
SensorGraphics3DPulseStyle.POSITIVE_BOX.__doc__ = "Positive box style."
SensorGraphics3DPulseStyle.SINE_WAVE.__doc__ = "Sine style."
SensorGraphics3DPulseStyle.NEGATIVE_SINE_WAVE.__doc__ = "Negative sine style."
SensorGraphics3DPulseStyle.POSITIVE_SINE_WAVE.__doc__ = "Positive sine style."

agcls.AgTypeNameMap["SensorGraphics3DPulseStyle"] = SensorGraphics3DPulseStyle

class SensorGraphics3DPulseFrequencyPreset(IntEnum):
    """Options for a sensor's 3D Graphics Pulse Frequency presets."""

    FAST = 0
    """Fast: 0.333 Hz."""
    MEDIUM = 1
    """Medium: 0.167 Hz."""
    SLOW = 2
    """Slow: 0.083 Hz."""
    CUSTOM = 3
    """Custom: user-specified."""

SensorGraphics3DPulseFrequencyPreset.FAST.__doc__ = "Fast: 0.333 Hz."
SensorGraphics3DPulseFrequencyPreset.MEDIUM.__doc__ = "Medium: 0.167 Hz."
SensorGraphics3DPulseFrequencyPreset.SLOW.__doc__ = "Slow: 0.083 Hz."
SensorGraphics3DPulseFrequencyPreset.CUSTOM.__doc__ = "Custom: user-specified."

agcls.AgTypeNameMap["SensorGraphics3DPulseFrequencyPreset"] = SensorGraphics3DPulseFrequencyPreset

class LineWidth(IntEnum):
    """Line widths."""

    WIDTH1 = 0
    """Line width: 1."""
    WIDTH2 = 1
    """Line width: 2."""
    WIDTH3 = 2
    """Line width: 3."""
    WIDTH4 = 3
    """Line width: 4."""
    WIDTH5 = 4
    """Line width: 5."""
    WIDTH6 = 5
    """Line width: 6."""
    WIDTH7 = 6
    """Line width: 7."""
    WIDTH8 = 7
    """Line width: 8."""
    WIDTH9 = 8
    """Line width: 9."""
    WIDTH10 = 9
    """Line width: 10."""

LineWidth.WIDTH1.__doc__ = "Line width: 1."
LineWidth.WIDTH2.__doc__ = "Line width: 2."
LineWidth.WIDTH3.__doc__ = "Line width: 3."
LineWidth.WIDTH4.__doc__ = "Line width: 4."
LineWidth.WIDTH5.__doc__ = "Line width: 5."
LineWidth.WIDTH6.__doc__ = "Line width: 6."
LineWidth.WIDTH7.__doc__ = "Line width: 7."
LineWidth.WIDTH8.__doc__ = "Line width: 8."
LineWidth.WIDTH9.__doc__ = "Line width: 9."
LineWidth.WIDTH10.__doc__ = "Line width: 10."

agcls.AgTypeNameMap["LineWidth"] = LineWidth

class STKObjectType(IntEnum):
    """STK objects."""

    ADVCAT = 0
    """AdvCAT."""
    AIRCRAFT = 1
    """Aircraft."""
    AREA_TARGET = 2
    """Area Target."""
    ATTITUDE_COVERAGE = 3
    """Attitude Coverage."""
    CHAIN = 4
    """Chain."""
    COMM_SYSTEM = 5
    """CommSystem."""
    CONSTELLATION = 6
    """Constellation."""
    COVERAGE_DEFINITION = 7
    """Coverage Definition."""
    FACILITY = 8
    """Facility."""
    GROUND_VEHICLE = 9
    """Ground Vehicle."""
    LAUNCH_VEHICLE = 10
    """Launch Vehicle."""
    LINE_TARGET = 11
    """Line Target."""
    MTO = 12
    """MTO (Multi-Track Object)."""
    MISSILE = 13
    """Missile."""
    MISSILE_SYSTEM = 14
    """Missile System."""
    PLANET = 15
    """Planet."""
    RADAR = 16
    """Radar."""
    RECEIVER = 17
    """Receiver."""
    SATELLITE = 18
    """Satellite."""
    SCENARIO = 19
    """Scenario."""
    SENSOR = 20
    """Sensor."""
    SHIP = 21
    """Ship."""
    STAR = 22
    """Star."""
    TARGET = 23
    """Target."""
    TRANSMITTER = 24
    """Transmitter."""
    FIGURE_OF_MERIT = 25
    """Figure of Merit."""
    ROOT = 26
    """Root."""
    ACCESS = 27
    """Access."""
    OBJECT_COVERAGE = 28
    """Coverage."""
    ATTITUDE_FIGURE_OF_MERIT = 29
    """Attitude Figure of Merit."""
    SUBMARINE = 30
    """Submarine."""
    ANTENNA = 31
    """Antenna."""
    PLACE = 32
    """Place."""
    VOLUMETRIC = 33
    """Volumetric."""
    SATELLITE_COLLECTION = 34
    """SatelliteCollection."""
    SUBSET = 35
    """Subset."""

STKObjectType.ADVCAT.__doc__ = "AdvCAT."
STKObjectType.AIRCRAFT.__doc__ = "Aircraft."
STKObjectType.AREA_TARGET.__doc__ = "Area Target."
STKObjectType.ATTITUDE_COVERAGE.__doc__ = "Attitude Coverage."
STKObjectType.CHAIN.__doc__ = "Chain."
STKObjectType.COMM_SYSTEM.__doc__ = "CommSystem."
STKObjectType.CONSTELLATION.__doc__ = "Constellation."
STKObjectType.COVERAGE_DEFINITION.__doc__ = "Coverage Definition."
STKObjectType.FACILITY.__doc__ = "Facility."
STKObjectType.GROUND_VEHICLE.__doc__ = "Ground Vehicle."
STKObjectType.LAUNCH_VEHICLE.__doc__ = "Launch Vehicle."
STKObjectType.LINE_TARGET.__doc__ = "Line Target."
STKObjectType.MTO.__doc__ = "MTO (Multi-Track Object)."
STKObjectType.MISSILE.__doc__ = "Missile."
STKObjectType.MISSILE_SYSTEM.__doc__ = "Missile System."
STKObjectType.PLANET.__doc__ = "Planet."
STKObjectType.RADAR.__doc__ = "Radar."
STKObjectType.RECEIVER.__doc__ = "Receiver."
STKObjectType.SATELLITE.__doc__ = "Satellite."
STKObjectType.SCENARIO.__doc__ = "Scenario."
STKObjectType.SENSOR.__doc__ = "Sensor."
STKObjectType.SHIP.__doc__ = "Ship."
STKObjectType.STAR.__doc__ = "Star."
STKObjectType.TARGET.__doc__ = "Target."
STKObjectType.TRANSMITTER.__doc__ = "Transmitter."
STKObjectType.FIGURE_OF_MERIT.__doc__ = "Figure of Merit."
STKObjectType.ROOT.__doc__ = "Root."
STKObjectType.ACCESS.__doc__ = "Access."
STKObjectType.OBJECT_COVERAGE.__doc__ = "Coverage."
STKObjectType.ATTITUDE_FIGURE_OF_MERIT.__doc__ = "Attitude Figure of Merit."
STKObjectType.SUBMARINE.__doc__ = "Submarine."
STKObjectType.ANTENNA.__doc__ = "Antenna."
STKObjectType.PLACE.__doc__ = "Place."
STKObjectType.VOLUMETRIC.__doc__ = "Volumetric."
STKObjectType.SATELLITE_COLLECTION.__doc__ = "SatelliteCollection."
STKObjectType.SUBSET.__doc__ = "Subset."

agcls.AgTypeNameMap["STKObjectType"] = STKObjectType

class AccessConstraintType(IntEnum):
    """Available Access Constraint."""

    NONE = 0
    """None. Use interface IAccessConstraint."""
    IMAGE_QUALITY = 1
    """Image quality. Use interface IAccessConstraintMinMaxBase."""
    ALTITUDE = 2
    """Altitude. Use interface IAccessConstraintMinMaxBase."""
    ANGULAR_RATE = 3
    """Angular rate. Use interface IAccessConstraintMinMaxBase."""
    APPARENT_TIME = 4
    """Apparent time. Use interface IAccessConstraintMinMaxBase."""
    AREA_TARGET_CENTROID_ELEVATION_ANGLE = 5
    """Do not use this enumeration, as it is deprecated. Area Target centroid elevation angle. Use interface IAccessConstraintMinMaxBase."""
    AZIMUTH_ANGLE = 6
    """Azimuth angle. Use interface IAccessConstraintMinMaxBase."""
    BACKGROUND = 7
    """Background. Use interface AccessConstraintBackground."""
    BETA_ANGLE = 8
    """Beta angle. Use interface IAccessConstraintMinMaxBase."""
    VECTOR_GEOMETRY_TOOL_ANGLE = 9
    """Angle. Use interface AccessConstraintAnalysisWorkbenchComponent."""
    VECTOR_MAGNITUDE = 10
    """Vector magnitude. Use interface AccessConstraintAnalysisWorkbenchComponent."""
    CROSS_TRACK_RANGE = 11
    """Cross-track range. Use interface IAccessConstraintMinMaxBase."""
    DOPPLER_CONE_ANGLE = 12
    """Doppler cone angle. Use interface IAccessConstraintMinMaxBase."""
    DURATION = 13
    """Duration. Use interface IAccessConstraintMinMaxBase."""
    ELEVATION_ANGLE = 14
    """Elevation angle. Use interface IAccessConstraintMinMaxBase,  AccessConstraintAngle."""
    EXCLUSION_ZONE = 15
    """Exclusion zone. Use interface AccessConstraintExclZonesCollection, AccessConstraintLatitudeLongitudeZone."""
    GMT = 16
    """GMT. Use interface IAccessConstraintMinMaxBase."""
    GRAZING_ALTITUDE = 17
    """Grazing altitude. Use interface IAccessConstraintMinMaxBase."""
    GRAZING_ANGLE = 18
    """Grazing angle. Use interface IAccessConstraintMinMaxBase."""
    GROUND_ELEVATION_ANGLE = 19
    """Ground elevation angle. Use interface IAccessConstraintMinMaxBase."""
    GROUND_TRACK = 20
    """Ground track. Use interface AccessConstraintGroundTrack."""
    INCLUSION_ZONE = 21
    """Inclusion zone. Use interface AccessConstraintLatitudeLongitudeZone."""
    INTERVALS = 22
    """Intervals. Use interface AccessConstraintIntervals."""
    IN_TRACK_RANGE = 23
    """In-track range. Use interface IAccessConstraintMinMaxBase."""
    LATITUDE = 24
    """Latitude. Use interface IAccessConstraintMinMaxBase."""
    LIGHTING = 25
    """Lighting. Use interface AccessConstraintCondition."""
    LINE_OF_SIGHT = 26
    """Line of sight. Use interface IAccessConstraint."""
    LOCAL_TIME = 27
    """Local time. Use interface IAccessConstraintMinMaxBase."""
    LIGHT_OF_SIGHT_LUNAR_EXCLUSION_ANGLE = 28
    """Line of sight lunar exclusion. Use interface AccessConstraintAngle."""
    LIGHT_OF_SIGHT_SOLAR_EXCLUSION_ANGLE = 29
    """Line of sight sun exclusion. Use interface AccessConstraintAngle."""
    LUNAR_ELEVATION_ANGLE = 30
    """Lunar elevation angle. Use interface IAccessConstraintMinMaxBase."""
    MATLAB = 31
    """Matlab. Use interface IAccessConstraintMinMaxBase."""
    OBJECT_EXCLUSION_ANGLE = 32
    """Object exclusion angle. Use interface AccessConstraintObjExAngle."""
    PROPAGATION_DELAY = 33
    """Propagation delay. Use interface IAccessConstraintMinMaxBase."""
    RANGE = 34
    """Range. Use interface IAccessConstraintMinMaxBase."""
    RANGE_RATE = 35
    """Range rate. Use interface IAccessConstraintMinMaxBase."""
    SAR_AREA_RATE = 36
    """SAR area rate. Use interface IAccessConstraintMinMaxBase."""
    SAR_AZIMUTH_RESOLUTION = 37
    """SAR azimuth resolution. Use interface IAccessConstraintMinMaxBase."""
    SAR_CARRIER_TO_NOISE_RATIO = 38
    """SAR clutter-to-noise ratio. Use interface IAccessConstraintMinMaxBase."""
    SAR_EXTERNAL_DATA = 39
    """SAR external data. Use interface IAccessConstraintMinMaxBase."""
    SAR_INTEGRATION_TIME = 40
    """SAR integration time. Use interface IAccessConstraintMinMaxBase."""
    SAR_PTCR = 41
    """SAR point target-to-clutter ratio. Use interface IAccessConstraintMinMaxBase."""
    SAR_SCR = 42
    """SAR signal-to-clutter ratio. Use interface IAccessConstraintMinMaxBase."""
    SAR_SIGMA_N = 43
    """SAR sigma N. Use interface IAccessConstraintMinMaxBase."""
    SAR_SNR = 44
    """SAR signal-to-noise ratio. Use interface IAccessConstraintMinMaxBase."""
    SQUINT_ANGLE = 45
    """Squint angle. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_CLEAR_DOPPLER = 46
    """Search-track clear doppler. Use interface IAccessConstraint."""
    SEARCH_TRACK_DWELL_TIME = 47
    """Search-track dwell time. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION = 48
    """Search-track integrated probability of detection. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATED_PULSES = 49
    """Search-track integrated pulses. Use interface IAccessConstraint."""
    SEARCH_TRACK_INTEGRATED_SNR = 50
    """Search-track integrated signal-to-noise ratio. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATION_TIME = 51
    """Search-track integration time. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_MLC_FILTER = 52
    """Search-track main lobe clutter filter. Use interface IAccessConstraint."""
    SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION = 53
    """Search-track single-pulse probability of detection. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_SINGLE_PULSE_SNR = 54
    """Search-track single-pulse signal-to-noise ratio. Use interface IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_SLC_FILTER = 55
    """Search-track side lobe clutter filter. Use interface IAccessConstraint."""
    SEARCH_TRACK_UNAMBIGUOUS_DOPPLER = 56
    """Search-track unambiguous doppler. Use interface IAccessConstraint."""
    SEARCH_TRACK_UNAMBIGUOUS_RANGE = 57
    """Search-track unambiguous range. Use interface IAccessConstraint."""
    SUN_ELEVATION_ANGLE = 58
    """Sun elevation angle. Use interface IAccessConstraintMinMaxBase."""
    SUN_GROUND_ELEVATION_ANGLE = 59
    """Sun ground angle. Use interface IAccessConstraintMinMaxBase."""
    SUN_SPECULAR_EXCLUSION_ANGLE = 60
    """Sun specular exclusion. Use interface AccessConstraintAngle."""
    THIRD_BODY_OBSTRUCTION = 61
    """Do not use this enumeration, as it is deprecated. Third body obstruction. Use interface AccessConstraintThirdBody."""
    CENTROID_AZIMUTH_ANGLE = 63
    """Do not use this enumeration, as it is deprecated. Centroid azimuth angle. Use interface IAccessConstraintMinMaxBase."""
    CENTROID_RANGE = 64
    """Do not use this enumeration, as it is deprecated. Centroid range. Use interface IAccessConstraintMinMaxBase."""
    CENTROID_SUN_ELEVATION_ANGLE = 65
    """Do not use this enumeration, as it is deprecated. Centroid sun elevation angle. Use interface IAccessConstraintMinMaxBase."""
    COLLECTION_ANGLE = 66
    """Collection angle. Use interface IAccessConstraintMinMaxBase."""
    TERRAIN_MASK = 67
    """Terrain mask. Use interface IAccessConstraint."""
    AZ_EL_MASK = 68
    """Azimuth-elevation mask. Use interface IAccessConstraint."""
    AZIMUTH_RATE = 69
    """Azimuth rate. Use interface IAccessConstraintMinMaxBase."""
    ELEVATION_RATE = 70
    """Elevation rate. Use interface IAccessConstraintMinMaxBase."""
    GEOSYNCHRONOUS_BELT_EXCLUSION_ANGLE = 71
    """Geostationary belt exclusion. Use interface AccessConstraintAngle."""
    GROUND_SAMPLE_DISTANCE = 72
    """Ground sample distance. Use interface IAccessConstraintMinMaxBase."""
    HEIGHT_ABOVE_HORIZON = 73
    """Height above horizon. Use interface IAccessConstraintMinMaxBase."""
    TERRAIN_GRAZING_ANGLE = 74
    """Terrain grazing angle. Use interface IAccessConstraintMinMaxBase."""
    ANGLE_OFF_BORESIGHT = 75
    """Angle off boresight. Use interface IAccessConstraintMinMaxBase."""
    ANGLE_OFF_BORESIGHT_RATE = 76
    """Angle off boresight rate. Use interface IAccessConstraintMinMaxBase."""
    AREA_MASK = 77
    """Area mask. Use interface IAccessConstraint."""
    BORESIGHT_GRAZING_ANGLE = 78
    """Boresight grazing angle. Use interface IAccessConstraintMinMaxBase."""
    BORESIGHT_INTERSECTION_LIGHTING_CONDITION = 79
    """Boresight Intersection lighting condition. Use interface IAccessConstraintMinMaxBase."""
    BORESIGHT_LUNAR_EXCLUSION_ANGLE = 80
    """Boresight lunar exclusion. Use interface AccessConstraintAngle."""
    BORESIGHT_SUN_EXCLUSION_ANGLE = 81
    """Boresight sun exclusion. Use interface AccessConstraintAngle."""
    FIELD_OF_VIEW = 82
    """Field of view. Use interface IAccessConstraint."""
    FIELD_OF_VIEW_SUN_SPECULAR_EXCLUSION_ANGLE = 83
    """Field of view sun specular exclusion. Use interface IAccessConstraint."""
    FIELD_OF_VIEW_SUN_SPECULAR_INCLUSION_ANGLE = 84
    """Field of view sun specular inclusion. Use interface IAccessConstraint."""
    HORIZON_CROSSING = 85
    """Horizon crossing. Use interface IAccessConstraint."""
    SENSOR_AZ_EL_MASK = 89
    """Sensor azimuth-elevation mask. Use interface IAccessConstraint."""
    FOREGROUND = 90
    """Foreground. Use interface IAccessConstraint."""
    CENTRAL_BODY_OBSTRUCTION = 91
    """Central Body Obstruction. Use interface AccessConstraintCentralBodyObstruction."""
    PLUGIN = 92
    """Access plugin constraint. Use AccessConstraintPluginMinMax."""
    DEPTH = 93
    """Depth constraint. Use AccessConstraintPluginMinMax."""
    SEET_MAGNETIC_FIELD_L_SHELL = 95
    """Magnetic Dipole L-Shell. The L value is a measure to indicate a particle's drift shell in a dipole-approximated magnetic field. Use IAccessConstraintMinMaxBase."""
    SEET_MAGNETIC_FIELD_LINE_SEPARATION = 96
    """Magnetic Field Line Separation; the centric angle between the North footprint of the field line containing the vehicle's location and the North footprint of the field line containing the target's location. Use IAccessConstraintMinMaxBase."""
    SEET_IMPACT_FLUX = 97
    """Impact Flux; the total impact flux from all types of meteoroid particles. Use IAccessConstraintMinMaxBase."""
    SEET_DAMAGE_FLUX = 98
    """Damage Flux; the total impact flux from all types of meteoroid particles causing damage. Use IAccessConstraintMinMaxBase."""
    SEET_DAMAGE_MASS_FLUX = 99
    """Damage Mass Flux; the total impact mass flux from all meteoroid particles causing damage. Use IAccessConstraintMinMaxBase."""
    SEET_IMPACT_MASS_FLUX = 100
    """Impact Mass Flux; the total impact mass flux ffrom all types of meteoroid particles. Use IAccessConstraintMinMaxBase."""
    SEET_SAA_FLUX_INTENSITY = 101
    """SAA Flux Intensity; SAA Flux Intensity is determined at the vehicle's location and for specified proton-energy flux threshold channel. Use IAccessConstraintMinMaxBase."""
    SEET_VEHICLE_TEMPERATURE = 102
    """Vehicle Temperature, computed assuming thermal equilibrium. Use IAccessConstraintMinMaxBase."""
    CONDITION = 104
    """Coordinate condition constraint. Use interface AccessConstraintAnalysisWorkbenchComponent."""
    SAR_CARRIER_TO_NOISE_RATIO_JAMIING = 105
    """SAR CNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SAR_J_OVER_S = 106
    """SAR J/S constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_CARRIER_TO_NOISE_RATIO = 107
    """SAR Orthogonal Polar CNR constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_CARRIER_TO_NOISE_RATIO_JAMMING = 108
    """SAR Orthogonal Polar CNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_J_OVER_S = 109
    """SAR Orthogonal Polar J/S constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_PTCR = 110
    """SAR Orthogonal Polar PTCR constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_SCR = 111
    """SAR Orthogonal Polar SCR constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_SCR_JAMMING = 112
    """SAR Orthogonal Polar SCR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_SNR = 113
    """SAR Orthogonal Polar SNR constraint. Use IAccessConstraintMinMaxBase."""
    SAR_ORTHOGONAL_POLARIZATION_SNR_JAMMING = 114
    """SAR Orthogonal Polar SNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SAR_SCR_JAMMING = 115
    """SAR SCR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SAR_SNR_JAMMING = 116
    """SAR SNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_DWELL_TIME_JAMMING = 117
    """Search-Track Dwell Time Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATED_J_OVER_S = 118
    """Search-Track Integrated J/S constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING = 119
    """Search-Track Integrated PDet Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATED_PULSES_JAMMING = 120
    """Search-Track Integrated Pulses Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATED_SNR_JAMMING = 121
    """Search-Track Integrated SNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_INTEGRATION_TIME_JAMMING = 122
    """Search-Track Integration Time Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME = 123
    """Search-Track Orthogonal Polar Dwell Time constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME_JAMMING = 124
    """Search-Track Orthogonal Polar Dwell Time Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_J_OVER_S = 125
    """Search-Track Orthogonal Polar Integrated J/S constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION = 126
    """Search-Track Orthogonal Polar Integrated PDet constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING = 127
    """Search-Track Orthogonal Polar Integrated PDet Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES = 128
    """Search-Track Orthogonal Polar Integrated Pulses constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES_JAMMING = 129
    """Search-Track Orthogonal Polar Integrated Pulses Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR = 130
    """Search-Track Orthogonal Polar Integrated SNR constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR_JAMMING = 131
    """Search-Track Orthogonal Polar Integrated SNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME = 132
    """Search-Track Orthogonal Polar Integration Time constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME_JAMMING = 133
    """Search-Track Orthogonal Polar Integration Time Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_J_OVER_S = 134
    """Search-Track Orthogonal Polar Single Pulse J/S constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION = 135
    """Search-Track Orthogonal Polar Single Pulse PDet constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING = 136
    """Search-Track Orthogonal Polar Single Pulse PDet Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR = 137
    """Search-Track Orthogonal Polar Single Pulse SNR constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR_JAMMING = 138
    """Search-Track Orthogonal Polar Integrated SNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_SINGLE_PULSE_J_OVER_S = 139
    """Search-Track Single Pulse J/S constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING = 140
    """Search-Track Single Pulse PDet Jamming constraint. Use IAccessConstraintMinMaxBase."""
    SEARCH_TRACK_SINGLE_PULSE_SNR_JAMMING = 141
    """Search-Track Single Pulse SNR Jamming constraint. Use IAccessConstraintMinMaxBase."""
    EOIR_SNR = 142
    """EOIR SNR constraint. Use IAccessConstraintMinMaxBase."""
    FIELD_OF_VIEW_CENTRAL_BODY_CENTER = 143
    """Field Of View Central Body Center constraint. Use IAccessConstraint."""
    FIELD_OF_VIEW_CENTRAL_BODY_HORIZON_REFINE = 144
    """Field Of View Central Body Horizon Refine constraint. Use IAccessConstraint."""
    FIELD_OF_VIEW_CENTRAL_BODY_OBSTRUCTION_CROSSSING_INWARD = 145
    """Field Of View Central Body Obstruction Cross In constraint. Use IAccessConstraint."""
    FIELD_OF_VIEW_CENTRAL_BODY_OBSTRUCTION_CROSSING_OUTWARD = 146
    """Field Of View Central Body Obstruction Cross Out constraint. Use IAccessConstraint."""
    SENSOR_RANGE_MASK = 147
    """Sensor Range Mask constraint. Use IAccessConstraint."""
    ATMOSPHERIC_LOSS = 148
    """Atmosphere Absorption Loss constraint. Use IAccessConstraintMinMaxBase."""
    BER_PLUS_I = 149
    """BER+I constraint. Use IAccessConstraintMinMaxBase."""
    BIT_ERROR_RATE = 150
    """Bit Error Rate constraint. Use IAccessConstraintMinMaxBase."""
    C_OVER_I = 151
    """C/I constraint. Use IAccessConstraintMinMaxBase."""
    C_OVER_N = 152
    """C/N constraint. Use IAccessConstraintMinMaxBase."""
    C_OVER_N_PLUS_I = 153
    """C/N+I constraint. Use IAccessConstraintMinMaxBase."""
    C_OVER_N0 = 154
    """C/No constraint. Use IAccessConstraintMinMaxBase."""
    C_OVER_N0_PLUS_I0 = 155
    """C/No+Io constraint. Use IAccessConstraintMinMaxBase."""
    CLOUDS_FOG_LOSS = 156
    """Clouds And Fog Loss constraint. Use IAccessConstraintMinMaxBase."""
    COMM_PLUGIN = 157
    """Comm Plugin constraint. Use IAccessConstraintMinMaxBase."""
    DELTA_T_OVER_T = 158
    """Delta T/T constraint. Use IAccessConstraintMinMaxBase."""
    DOPPLER_SHIFT = 159
    """Doppler Shift constraint. Use IAccessConstraintMinMaxBase."""
    EB_OVER_N0 = 160
    """Energy per bit to noise ratio (Eb/No) constraint. Use IAccessConstraintMinMaxBase."""
    EB_OVER_N0_PLUS_I0 = 161
    """Eb/No+Io constraint. Use IAccessConstraintMinMaxBase."""
    FLUX_DENSITY = 162
    """Flux Density constraint. Use IAccessConstraintMinMaxBase."""
    FREQUENCY = 163
    """Frequency constraint. Use IAccessConstraintMinMaxBase."""
    G_OVER_T = 164
    """G/T constraint. Use IAccessConstraintMinMaxBase."""
    J_OVER_S = 165
    """J/S constraint. Use IAccessConstraintMinMaxBase."""
    LINK_EIRP = 166
    """Link EIRP constraint. Use IAccessConstraintMinMaxBase."""
    LINK_MARGIN = 167
    """Link Margin constraint. Use IAccessConstraintMinMaxBase."""
    NOISE_TEMPERATURE = 168
    """Noise Temperature constraint. Use IAccessConstraintMinMaxBase."""
    POLARIZATION_RELATIVE_ANGLE = 169
    """Polarization Relative Angle constraint. Use IAccessConstraintMinMaxBase."""
    POWER_AT_RECEIVER_INPUT = 170
    """Power at Receiver Input constraint. Use IAccessConstraintMinMaxBase."""
    POWER_FLUX_DENSITY = 171
    """Power Flux Density constraint. Use IAccessConstraintMinMaxBase."""
    RAIN_LOSS = 172
    """Rain Loss constraint. Use IAccessConstraintMinMaxBase."""
    RECEIVED_ISOTROPIC_POWER = 173
    """Received Isotropic Power constraint. Use IAccessConstraintMinMaxBase."""
    USER_CUSTOM_A_LOSS = 174
    """User Custom A Loss constraint. Use IAccessConstraintMinMaxBase."""
    USER_CUSTOM_B_LOSS = 175
    """User Custom B Loss constraint. Use IAccessConstraintMinMaxBase."""
    USER_CUSTOM_C_LOSS = 176
    """User Custom C Loss constraint. Use IAccessConstraintMinMaxBase."""
    FREE_SPACE_LOSS = 177
    """Free Space Loss constraint. Use IAccessConstraintMinMaxBase."""
    PROPAGATION_LOSS = 178
    """Propagation Loss constraint. Use IAccessConstraintMinMaxBase."""
    TOTAL_POWER_AT_RECEIVER_INPUT = 179
    """Total Power At Receiver Input constraint. Use IAccessConstraintMinMaxBase."""
    TOTAL_RECEIVED_REFRACTION_POWER = 180
    """Total Received Rf Power constraint. Use IAccessConstraintMinMaxBase."""
    TROPOSPHERIC_SCINTILLATION_LOSS = 181
    """Troposphere Scintillation Loss constraint. Use IAccessConstraintMinMaxBase."""
    URBAN_TERRES_LOSS = 182
    """Urban Terrestrial Loss constraint. Use IAccessConstraintMinMaxBase."""
    TIME_SLIP_SURFACE_RANGE = 183
    """Time Slip Surface Range constraint. Use IAccessConstraint."""
    CABLE_TRANSFORMATION_DELAY = 184
    """Cable Transmission Delay constraint. Use AccessConstraintIntervals."""
    PROCESS_DELAY = 185
    """Process Delay constraint. Use AccessConstraintIntervals."""
    RADAR_TRANSMITTER_TARGET_ACCESS = 186
    """RdrXmtTgtAccess constraint. Use AccessConstraintIntervals."""
    SUN_ILLUMINATION_ANGLE = 187
    """Sun Illumination angle. Use interface IAccessConstraintMinMaxBase."""
    SPECTRAL_FLUX_DENSITY = 188
    """Spectral Flux Density constraint. Use IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_SNR_MINIMUM = 189
    """Multifunction radar single pulse signal-to-noise ratio minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_SNR_MAXIMUM = 190
    """Multifunction radar single pulse signal-to-noise ratio maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_MINIMUM = 191
    """Multifunction radar single pulse probability of detection minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_MAXIMUM = 192
    """Multifunction radar single pulse probability of detection maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_SNR_MINIMUM = 193
    """Multifunction radar integrated signal-to-noise ratio minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_SNR_MAXIMUM = 194
    """Multifunction radar integrated signal-to-noise ratio maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PROBABILITY_OF_DETECTION_MINIMUM = 195
    """Multifunction radar integrated probability of detection minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PROBABILITY_OF_DETECTION_MAXIMUM = 196
    """Multifunction radar integrated probability of detection maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PULSES_MINIMUM = 197
    """Multifunction radar integrated pulses minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PULSES_MAXIMUM = 198
    """Multifunction radar integrated pulses maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PULSES_JAMMING_MINIMUM = 199
    """Multifunction radar integrated pulses jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PULSES_JAMMING_MAXIMUM = 200
    """Multifunction radar integrated pulses jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATION_TIME_MINIMUM = 201
    """Multifunction radar integration time minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATION_TIME_MAXIMUM = 202
    """Multifunction radar integration time maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATION_TIME_JAMMING_MINIMUM = 203
    """Multifunction radar integration time jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATION_TIME_JAMMING_MAXIMUM = 204
    """Multifunction radar integration time jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_DWELL_TIME_MINIMUM = 205
    """Multifunction radar dwell time minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_DWELL_TIME_MAXIMUM = 206
    """Multifunction radar dwell time maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_DWELL_TIME_JAMMING_MIN = 207
    """Multifunction radar dwell time jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_DWELL_TIME_JAMMING_MAXIMUM = 208
    """Multifunction radar dwell time jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_J_OVER_S_MINIMUM = 209
    """Multifunction radar single pulse J/S minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_J_OVER_S_MAXIMUM = 210
    """Multifunction radar single pulse J/S maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_J_OVER_S_MINIMUM = 211
    """Multifunction radar integrated J/S minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_J_OVER_S_MAXIMUM = 212
    """Multifunction radar integrated J/S maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_SNR_JAMMING_MINIMUM = 213
    """Multifunction radar single pulse signal-to-noise ratio jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_SNR_JAMMING_MAXIMUM = 214
    """Multifunction radar single pulse signal-to-noise ratio jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_SNR_JAMMING_MINIMUM = 215
    """Multifunction radar integrated signal-to-noise ratio jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_SNR_JAMMING_MAXIMUM = 216
    """Multifunction radar integrated signal-to-noise ratio jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING_MINIMUM = 217
    """Multifunction radar single pulse probability of detection jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING_MAXIMUM = 218
    """Multifunction radar single pulse probability of detection jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING_MINIMUM = 219
    """Multifunction radar integrated probability of detection jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    MFR_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING_MAXIMUM = 220
    """Multifunction radar integrated probability of detection jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."""
    TILES_MASK_3D = 221
    """3DTiles mask. Use interface IAccessConstraint."""
    CENTRAL_ANGLE = 222
    """Central angle. Use interface IAccessConstraintMinMaxBase."""
    CENTRAL_DISTANCE = 223
    """Central distance. Use interface IAccessConstraintMinMaxBase."""
    DISTANCE_FROM_AREA_TARGET_BOUNDARY = 224
    """Distance from AreaTarget boundary. Measured along the surface from subPoint to closest point of the boundary. The value is signed: if subPoint is inside the boundary, value is negative else positive. Use interface IAccessConstraintMinMaxBase."""
    CALCULATION_SCALAR = 225
    """Scalar Calculation (Calc Scalar). Use interface AccessConstraintAnalysisWorkbenchComponent."""

AccessConstraintType.NONE.__doc__ = "None. Use interface IAccessConstraint."
AccessConstraintType.IMAGE_QUALITY.__doc__ = "Image quality. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.ALTITUDE.__doc__ = "Altitude. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.ANGULAR_RATE.__doc__ = "Angular rate. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.APPARENT_TIME.__doc__ = "Apparent time. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.AREA_TARGET_CENTROID_ELEVATION_ANGLE.__doc__ = "Do not use this enumeration, as it is deprecated. Area Target centroid elevation angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.AZIMUTH_ANGLE.__doc__ = "Azimuth angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.BACKGROUND.__doc__ = "Background. Use interface AccessConstraintBackground."
AccessConstraintType.BETA_ANGLE.__doc__ = "Beta angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.VECTOR_GEOMETRY_TOOL_ANGLE.__doc__ = "Angle. Use interface AccessConstraintAnalysisWorkbenchComponent."
AccessConstraintType.VECTOR_MAGNITUDE.__doc__ = "Vector magnitude. Use interface AccessConstraintAnalysisWorkbenchComponent."
AccessConstraintType.CROSS_TRACK_RANGE.__doc__ = "Cross-track range. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.DOPPLER_CONE_ANGLE.__doc__ = "Doppler cone angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.DURATION.__doc__ = "Duration. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.ELEVATION_ANGLE.__doc__ = "Elevation angle. Use interface IAccessConstraintMinMaxBase,  AccessConstraintAngle."
AccessConstraintType.EXCLUSION_ZONE.__doc__ = "Exclusion zone. Use interface AccessConstraintExclZonesCollection, AccessConstraintLatitudeLongitudeZone."
AccessConstraintType.GMT.__doc__ = "GMT. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.GRAZING_ALTITUDE.__doc__ = "Grazing altitude. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.GRAZING_ANGLE.__doc__ = "Grazing angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.GROUND_ELEVATION_ANGLE.__doc__ = "Ground elevation angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.GROUND_TRACK.__doc__ = "Ground track. Use interface AccessConstraintGroundTrack."
AccessConstraintType.INCLUSION_ZONE.__doc__ = "Inclusion zone. Use interface AccessConstraintLatitudeLongitudeZone."
AccessConstraintType.INTERVALS.__doc__ = "Intervals. Use interface AccessConstraintIntervals."
AccessConstraintType.IN_TRACK_RANGE.__doc__ = "In-track range. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.LATITUDE.__doc__ = "Latitude. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.LIGHTING.__doc__ = "Lighting. Use interface AccessConstraintCondition."
AccessConstraintType.LINE_OF_SIGHT.__doc__ = "Line of sight. Use interface IAccessConstraint."
AccessConstraintType.LOCAL_TIME.__doc__ = "Local time. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.LIGHT_OF_SIGHT_LUNAR_EXCLUSION_ANGLE.__doc__ = "Line of sight lunar exclusion. Use interface AccessConstraintAngle."
AccessConstraintType.LIGHT_OF_SIGHT_SOLAR_EXCLUSION_ANGLE.__doc__ = "Line of sight sun exclusion. Use interface AccessConstraintAngle."
AccessConstraintType.LUNAR_ELEVATION_ANGLE.__doc__ = "Lunar elevation angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MATLAB.__doc__ = "Matlab. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.OBJECT_EXCLUSION_ANGLE.__doc__ = "Object exclusion angle. Use interface AccessConstraintObjExAngle."
AccessConstraintType.PROPAGATION_DELAY.__doc__ = "Propagation delay. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.RANGE.__doc__ = "Range. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.RANGE_RATE.__doc__ = "Range rate. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_AREA_RATE.__doc__ = "SAR area rate. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_AZIMUTH_RESOLUTION.__doc__ = "SAR azimuth resolution. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_CARRIER_TO_NOISE_RATIO.__doc__ = "SAR clutter-to-noise ratio. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_EXTERNAL_DATA.__doc__ = "SAR external data. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_INTEGRATION_TIME.__doc__ = "SAR integration time. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_PTCR.__doc__ = "SAR point target-to-clutter ratio. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_SCR.__doc__ = "SAR signal-to-clutter ratio. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_SIGMA_N.__doc__ = "SAR sigma N. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_SNR.__doc__ = "SAR signal-to-noise ratio. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SQUINT_ANGLE.__doc__ = "Squint angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_CLEAR_DOPPLER.__doc__ = "Search-track clear doppler. Use interface IAccessConstraint."
AccessConstraintType.SEARCH_TRACK_DWELL_TIME.__doc__ = "Search-track dwell time. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION.__doc__ = "Search-track integrated probability of detection. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_PULSES.__doc__ = "Search-track integrated pulses. Use interface IAccessConstraint."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_SNR.__doc__ = "Search-track integrated signal-to-noise ratio. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATION_TIME.__doc__ = "Search-track integration time. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_MLC_FILTER.__doc__ = "Search-track main lobe clutter filter. Use interface IAccessConstraint."
AccessConstraintType.SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION.__doc__ = "Search-track single-pulse probability of detection. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_SINGLE_PULSE_SNR.__doc__ = "Search-track single-pulse signal-to-noise ratio. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_SLC_FILTER.__doc__ = "Search-track side lobe clutter filter. Use interface IAccessConstraint."
AccessConstraintType.SEARCH_TRACK_UNAMBIGUOUS_DOPPLER.__doc__ = "Search-track unambiguous doppler. Use interface IAccessConstraint."
AccessConstraintType.SEARCH_TRACK_UNAMBIGUOUS_RANGE.__doc__ = "Search-track unambiguous range. Use interface IAccessConstraint."
AccessConstraintType.SUN_ELEVATION_ANGLE.__doc__ = "Sun elevation angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SUN_GROUND_ELEVATION_ANGLE.__doc__ = "Sun ground angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SUN_SPECULAR_EXCLUSION_ANGLE.__doc__ = "Sun specular exclusion. Use interface AccessConstraintAngle."
AccessConstraintType.THIRD_BODY_OBSTRUCTION.__doc__ = "Do not use this enumeration, as it is deprecated. Third body obstruction. Use interface AccessConstraintThirdBody."
AccessConstraintType.CENTROID_AZIMUTH_ANGLE.__doc__ = "Do not use this enumeration, as it is deprecated. Centroid azimuth angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.CENTROID_RANGE.__doc__ = "Do not use this enumeration, as it is deprecated. Centroid range. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.CENTROID_SUN_ELEVATION_ANGLE.__doc__ = "Do not use this enumeration, as it is deprecated. Centroid sun elevation angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.COLLECTION_ANGLE.__doc__ = "Collection angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.TERRAIN_MASK.__doc__ = "Terrain mask. Use interface IAccessConstraint."
AccessConstraintType.AZ_EL_MASK.__doc__ = "Azimuth-elevation mask. Use interface IAccessConstraint."
AccessConstraintType.AZIMUTH_RATE.__doc__ = "Azimuth rate. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.ELEVATION_RATE.__doc__ = "Elevation rate. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.GEOSYNCHRONOUS_BELT_EXCLUSION_ANGLE.__doc__ = "Geostationary belt exclusion. Use interface AccessConstraintAngle."
AccessConstraintType.GROUND_SAMPLE_DISTANCE.__doc__ = "Ground sample distance. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.HEIGHT_ABOVE_HORIZON.__doc__ = "Height above horizon. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.TERRAIN_GRAZING_ANGLE.__doc__ = "Terrain grazing angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.ANGLE_OFF_BORESIGHT.__doc__ = "Angle off boresight. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.ANGLE_OFF_BORESIGHT_RATE.__doc__ = "Angle off boresight rate. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.AREA_MASK.__doc__ = "Area mask. Use interface IAccessConstraint."
AccessConstraintType.BORESIGHT_GRAZING_ANGLE.__doc__ = "Boresight grazing angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.BORESIGHT_INTERSECTION_LIGHTING_CONDITION.__doc__ = "Boresight Intersection lighting condition. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.BORESIGHT_LUNAR_EXCLUSION_ANGLE.__doc__ = "Boresight lunar exclusion. Use interface AccessConstraintAngle."
AccessConstraintType.BORESIGHT_SUN_EXCLUSION_ANGLE.__doc__ = "Boresight sun exclusion. Use interface AccessConstraintAngle."
AccessConstraintType.FIELD_OF_VIEW.__doc__ = "Field of view. Use interface IAccessConstraint."
AccessConstraintType.FIELD_OF_VIEW_SUN_SPECULAR_EXCLUSION_ANGLE.__doc__ = "Field of view sun specular exclusion. Use interface IAccessConstraint."
AccessConstraintType.FIELD_OF_VIEW_SUN_SPECULAR_INCLUSION_ANGLE.__doc__ = "Field of view sun specular inclusion. Use interface IAccessConstraint."
AccessConstraintType.HORIZON_CROSSING.__doc__ = "Horizon crossing. Use interface IAccessConstraint."
AccessConstraintType.SENSOR_AZ_EL_MASK.__doc__ = "Sensor azimuth-elevation mask. Use interface IAccessConstraint."
AccessConstraintType.FOREGROUND.__doc__ = "Foreground. Use interface IAccessConstraint."
AccessConstraintType.CENTRAL_BODY_OBSTRUCTION.__doc__ = "Central Body Obstruction. Use interface AccessConstraintCentralBodyObstruction."
AccessConstraintType.PLUGIN.__doc__ = "Access plugin constraint. Use AccessConstraintPluginMinMax."
AccessConstraintType.DEPTH.__doc__ = "Depth constraint. Use AccessConstraintPluginMinMax."
AccessConstraintType.SEET_MAGNETIC_FIELD_L_SHELL.__doc__ = "Magnetic Dipole L-Shell. The L value is a measure to indicate a particle's drift shell in a dipole-approximated magnetic field. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_MAGNETIC_FIELD_LINE_SEPARATION.__doc__ = "Magnetic Field Line Separation; the centric angle between the North footprint of the field line containing the vehicle's location and the North footprint of the field line containing the target's location. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_IMPACT_FLUX.__doc__ = "Impact Flux; the total impact flux from all types of meteoroid particles. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_DAMAGE_FLUX.__doc__ = "Damage Flux; the total impact flux from all types of meteoroid particles causing damage. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_DAMAGE_MASS_FLUX.__doc__ = "Damage Mass Flux; the total impact mass flux from all meteoroid particles causing damage. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_IMPACT_MASS_FLUX.__doc__ = "Impact Mass Flux; the total impact mass flux ffrom all types of meteoroid particles. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_SAA_FLUX_INTENSITY.__doc__ = "SAA Flux Intensity; SAA Flux Intensity is determined at the vehicle's location and for specified proton-energy flux threshold channel. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEET_VEHICLE_TEMPERATURE.__doc__ = "Vehicle Temperature, computed assuming thermal equilibrium. Use IAccessConstraintMinMaxBase."
AccessConstraintType.CONDITION.__doc__ = "Coordinate condition constraint. Use interface AccessConstraintAnalysisWorkbenchComponent."
AccessConstraintType.SAR_CARRIER_TO_NOISE_RATIO_JAMIING.__doc__ = "SAR CNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_J_OVER_S.__doc__ = "SAR J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_CARRIER_TO_NOISE_RATIO.__doc__ = "SAR Orthogonal Polar CNR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_CARRIER_TO_NOISE_RATIO_JAMMING.__doc__ = "SAR Orthogonal Polar CNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_J_OVER_S.__doc__ = "SAR Orthogonal Polar J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_PTCR.__doc__ = "SAR Orthogonal Polar PTCR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_SCR.__doc__ = "SAR Orthogonal Polar SCR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_SCR_JAMMING.__doc__ = "SAR Orthogonal Polar SCR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_SNR.__doc__ = "SAR Orthogonal Polar SNR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_ORTHOGONAL_POLARIZATION_SNR_JAMMING.__doc__ = "SAR Orthogonal Polar SNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_SCR_JAMMING.__doc__ = "SAR SCR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SAR_SNR_JAMMING.__doc__ = "SAR SNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_DWELL_TIME_JAMMING.__doc__ = "Search-Track Dwell Time Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_J_OVER_S.__doc__ = "Search-Track Integrated J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Integrated PDet Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_PULSES_JAMMING.__doc__ = "Search-Track Integrated Pulses Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATED_SNR_JAMMING.__doc__ = "Search-Track Integrated SNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_INTEGRATION_TIME_JAMMING.__doc__ = "Search-Track Integration Time Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME.__doc__ = "Search-Track Orthogonal Polar Dwell Time constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME_JAMMING.__doc__ = "Search-Track Orthogonal Polar Dwell Time Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_J_OVER_S.__doc__ = "Search-Track Orthogonal Polar Integrated J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION.__doc__ = "Search-Track Orthogonal Polar Integrated PDet constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated PDet Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES.__doc__ = "Search-Track Orthogonal Polar Integrated Pulses constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated Pulses Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR.__doc__ = "Search-Track Orthogonal Polar Integrated SNR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated SNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME.__doc__ = "Search-Track Orthogonal Polar Integration Time constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integration Time Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_J_OVER_S.__doc__ = "Search-Track Orthogonal Polar Single Pulse J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION.__doc__ = "Search-Track Orthogonal Polar Single Pulse PDet constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Orthogonal Polar Single Pulse PDet Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR.__doc__ = "Search-Track Orthogonal Polar Single Pulse SNR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated SNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_SINGLE_PULSE_J_OVER_S.__doc__ = "Search-Track Single Pulse J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Single Pulse PDet Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.SEARCH_TRACK_SINGLE_PULSE_SNR_JAMMING.__doc__ = "Search-Track Single Pulse SNR Jamming constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.EOIR_SNR.__doc__ = "EOIR SNR constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.FIELD_OF_VIEW_CENTRAL_BODY_CENTER.__doc__ = "Field Of View Central Body Center constraint. Use IAccessConstraint."
AccessConstraintType.FIELD_OF_VIEW_CENTRAL_BODY_HORIZON_REFINE.__doc__ = "Field Of View Central Body Horizon Refine constraint. Use IAccessConstraint."
AccessConstraintType.FIELD_OF_VIEW_CENTRAL_BODY_OBSTRUCTION_CROSSSING_INWARD.__doc__ = "Field Of View Central Body Obstruction Cross In constraint. Use IAccessConstraint."
AccessConstraintType.FIELD_OF_VIEW_CENTRAL_BODY_OBSTRUCTION_CROSSING_OUTWARD.__doc__ = "Field Of View Central Body Obstruction Cross Out constraint. Use IAccessConstraint."
AccessConstraintType.SENSOR_RANGE_MASK.__doc__ = "Sensor Range Mask constraint. Use IAccessConstraint."
AccessConstraintType.ATMOSPHERIC_LOSS.__doc__ = "Atmosphere Absorption Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.BER_PLUS_I.__doc__ = "BER+I constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.BIT_ERROR_RATE.__doc__ = "Bit Error Rate constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.C_OVER_I.__doc__ = "C/I constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.C_OVER_N.__doc__ = "C/N constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.C_OVER_N_PLUS_I.__doc__ = "C/N+I constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.C_OVER_N0.__doc__ = "C/No constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.C_OVER_N0_PLUS_I0.__doc__ = "C/No+Io constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.CLOUDS_FOG_LOSS.__doc__ = "Clouds And Fog Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.COMM_PLUGIN.__doc__ = "Comm Plugin constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.DELTA_T_OVER_T.__doc__ = "Delta T/T constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.DOPPLER_SHIFT.__doc__ = "Doppler Shift constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.EB_OVER_N0.__doc__ = "Energy per bit to noise ratio (Eb/No) constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.EB_OVER_N0_PLUS_I0.__doc__ = "Eb/No+Io constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.FLUX_DENSITY.__doc__ = "Flux Density constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.FREQUENCY.__doc__ = "Frequency constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.G_OVER_T.__doc__ = "G/T constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.J_OVER_S.__doc__ = "J/S constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.LINK_EIRP.__doc__ = "Link EIRP constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.LINK_MARGIN.__doc__ = "Link Margin constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.NOISE_TEMPERATURE.__doc__ = "Noise Temperature constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.POLARIZATION_RELATIVE_ANGLE.__doc__ = "Polarization Relative Angle constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.POWER_AT_RECEIVER_INPUT.__doc__ = "Power at Receiver Input constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.POWER_FLUX_DENSITY.__doc__ = "Power Flux Density constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.RAIN_LOSS.__doc__ = "Rain Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.RECEIVED_ISOTROPIC_POWER.__doc__ = "Received Isotropic Power constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.USER_CUSTOM_A_LOSS.__doc__ = "User Custom A Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.USER_CUSTOM_B_LOSS.__doc__ = "User Custom B Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.USER_CUSTOM_C_LOSS.__doc__ = "User Custom C Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.FREE_SPACE_LOSS.__doc__ = "Free Space Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.PROPAGATION_LOSS.__doc__ = "Propagation Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.TOTAL_POWER_AT_RECEIVER_INPUT.__doc__ = "Total Power At Receiver Input constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.TOTAL_RECEIVED_REFRACTION_POWER.__doc__ = "Total Received Rf Power constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.TROPOSPHERIC_SCINTILLATION_LOSS.__doc__ = "Troposphere Scintillation Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.URBAN_TERRES_LOSS.__doc__ = "Urban Terrestrial Loss constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.TIME_SLIP_SURFACE_RANGE.__doc__ = "Time Slip Surface Range constraint. Use IAccessConstraint."
AccessConstraintType.CABLE_TRANSFORMATION_DELAY.__doc__ = "Cable Transmission Delay constraint. Use AccessConstraintIntervals."
AccessConstraintType.PROCESS_DELAY.__doc__ = "Process Delay constraint. Use AccessConstraintIntervals."
AccessConstraintType.RADAR_TRANSMITTER_TARGET_ACCESS.__doc__ = "RdrXmtTgtAccess constraint. Use AccessConstraintIntervals."
AccessConstraintType.SUN_ILLUMINATION_ANGLE.__doc__ = "Sun Illumination angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.SPECTRAL_FLUX_DENSITY.__doc__ = "Spectral Flux Density constraint. Use IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_SNR_MINIMUM.__doc__ = "Multifunction radar single pulse signal-to-noise ratio minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_SNR_MAXIMUM.__doc__ = "Multifunction radar single pulse signal-to-noise ratio maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_MINIMUM.__doc__ = "Multifunction radar single pulse probability of detection minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_MAXIMUM.__doc__ = "Multifunction radar single pulse probability of detection maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_SNR_MINIMUM.__doc__ = "Multifunction radar integrated signal-to-noise ratio minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_SNR_MAXIMUM.__doc__ = "Multifunction radar integrated signal-to-noise ratio maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PROBABILITY_OF_DETECTION_MINIMUM.__doc__ = "Multifunction radar integrated probability of detection minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PROBABILITY_OF_DETECTION_MAXIMUM.__doc__ = "Multifunction radar integrated probability of detection maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PULSES_MINIMUM.__doc__ = "Multifunction radar integrated pulses minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PULSES_MAXIMUM.__doc__ = "Multifunction radar integrated pulses maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PULSES_JAMMING_MINIMUM.__doc__ = "Multifunction radar integrated pulses jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PULSES_JAMMING_MAXIMUM.__doc__ = "Multifunction radar integrated pulses jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATION_TIME_MINIMUM.__doc__ = "Multifunction radar integration time minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATION_TIME_MAXIMUM.__doc__ = "Multifunction radar integration time maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATION_TIME_JAMMING_MINIMUM.__doc__ = "Multifunction radar integration time jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATION_TIME_JAMMING_MAXIMUM.__doc__ = "Multifunction radar integration time jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_DWELL_TIME_MINIMUM.__doc__ = "Multifunction radar dwell time minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_DWELL_TIME_MAXIMUM.__doc__ = "Multifunction radar dwell time maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_DWELL_TIME_JAMMING_MIN.__doc__ = "Multifunction radar dwell time jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_DWELL_TIME_JAMMING_MAXIMUM.__doc__ = "Multifunction radar dwell time jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_J_OVER_S_MINIMUM.__doc__ = "Multifunction radar single pulse J/S minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_J_OVER_S_MAXIMUM.__doc__ = "Multifunction radar single pulse J/S maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_J_OVER_S_MINIMUM.__doc__ = "Multifunction radar integrated J/S minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_J_OVER_S_MAXIMUM.__doc__ = "Multifunction radar integrated J/S maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_SNR_JAMMING_MINIMUM.__doc__ = "Multifunction radar single pulse signal-to-noise ratio jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_SNR_JAMMING_MAXIMUM.__doc__ = "Multifunction radar single pulse signal-to-noise ratio jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_SNR_JAMMING_MINIMUM.__doc__ = "Multifunction radar integrated signal-to-noise ratio jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_SNR_JAMMING_MAXIMUM.__doc__ = "Multifunction radar integrated signal-to-noise ratio jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING_MINIMUM.__doc__ = "Multifunction radar single pulse probability of detection jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING_MAXIMUM.__doc__ = "Multifunction radar single pulse probability of detection jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING_MINIMUM.__doc__ = "Multifunction radar integrated probability of detection jamming minimum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.MFR_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING_MAXIMUM.__doc__ = "Multifunction radar integrated probability of detection jamming maximum across all available beams. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.TILES_MASK_3D.__doc__ = "3DTiles mask. Use interface IAccessConstraint."
AccessConstraintType.CENTRAL_ANGLE.__doc__ = "Central angle. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.CENTRAL_DISTANCE.__doc__ = "Central distance. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.DISTANCE_FROM_AREA_TARGET_BOUNDARY.__doc__ = "Distance from AreaTarget boundary. Measured along the surface from subPoint to closest point of the boundary. The value is signed: if subPoint is inside the boundary, value is negative else positive. Use interface IAccessConstraintMinMaxBase."
AccessConstraintType.CALCULATION_SCALAR.__doc__ = "Scalar Calculation (Calc Scalar). Use interface AccessConstraintAnalysisWorkbenchComponent."

agcls.AgTypeNameMap["AccessConstraintType"] = AccessConstraintType

class BorderWallUpperLowerEdgeAltitudeReference(IntEnum):
    """Border Wall upper and lower edge altitude references."""

    MEAN_SEA_LEVEL = 0
    """Altitude reference: Mean Sea Level."""
    OBJECT = 1
    """Altitude reference: the altitude of the object."""
    TERRAIN = 2
    """Altitude reference: the altitude of the terrain."""
    WGS84 = 3
    """Altitude reference: the altitude of the central body's reference ellipsoid."""

BorderWallUpperLowerEdgeAltitudeReference.MEAN_SEA_LEVEL.__doc__ = "Altitude reference: Mean Sea Level."
BorderWallUpperLowerEdgeAltitudeReference.OBJECT.__doc__ = "Altitude reference: the altitude of the object."
BorderWallUpperLowerEdgeAltitudeReference.TERRAIN.__doc__ = "Altitude reference: the altitude of the terrain."
BorderWallUpperLowerEdgeAltitudeReference.WGS84.__doc__ = "Altitude reference: the altitude of the central body's reference ellipsoid."

agcls.AgTypeNameMap["BorderWallUpperLowerEdgeAltitudeReference"] = BorderWallUpperLowerEdgeAltitudeReference

class SolarRadiationPressureShadowModelType(IntEnum):
    """Shadow model options for solar radiation pressure."""

    CYLINDRICAL = 0
    """Cylindrical: assumes the Sun to be at infinite distance so that all light coming from the Sun moves in a direction parallel to the Sun to satellite vector."""
    DUAL_CONE = 1
    """Dual cone: uses the actual size and distance of the Sun to model regions of full, partial and zero sunlight."""
    NONE = 2
    """None. No shadowing of the satellite is modeled."""

SolarRadiationPressureShadowModelType.CYLINDRICAL.__doc__ = "Cylindrical: assumes the Sun to be at infinite distance so that all light coming from the Sun moves in a direction parallel to the Sun to satellite vector."
SolarRadiationPressureShadowModelType.DUAL_CONE.__doc__ = "Dual cone: uses the actual size and distance of the Sun to model regions of full, partial and zero sunlight."
SolarRadiationPressureShadowModelType.NONE.__doc__ = "None. No shadowing of the satellite is modeled."

agcls.AgTypeNameMap["SolarRadiationPressureShadowModelType"] = SolarRadiationPressureShadowModelType

class MethodToComputeSunPosition(IntEnum):
    """Methods to compute sun position."""

    APPARENT = 0
    """Apparent: takes into account the time required for light to travel from the sun to the position of the spacecraft."""
    APPARENT_TO_TRUE_CENTRAL_BODY_LOCATION = 1
    """Apparent Sun to True Central Body: takes into account the time required for light to travel from the sun to the central body."""
    TRUE = 2
    """True: assumes that light from the sun reaches the spacecraft instantaneously."""

MethodToComputeSunPosition.APPARENT.__doc__ = "Apparent: takes into account the time required for light to travel from the sun to the position of the spacecraft."
MethodToComputeSunPosition.APPARENT_TO_TRUE_CENTRAL_BODY_LOCATION.__doc__ = "Apparent Sun to True Central Body: takes into account the time required for light to travel from the sun to the central body."
MethodToComputeSunPosition.TRUE.__doc__ = "True: assumes that light from the sun reaches the spacecraft instantaneously."

agcls.AgTypeNameMap["MethodToComputeSunPosition"] = MethodToComputeSunPosition

class AtmosphericDensityModel(IntEnum):
    """Atmospheric density models."""

    STANDARD_ATMOSPHERE_MODEL_1976 = 0
    """1976 Standard Atmosphere: look-up model based on the satellite's altitude, with a valid range of 86km - 1000 km."""
    CIRA72 = 1
    """CIRA 1972: empirical model of atmospheric temperature and densities as recommended by the Committee on Space Research (COSPAR). Lower altitude boundary is 90 km."""
    EXPONENTIAL_MODEL = 2
    """Do not use this enumeration, as it is deprecated. Exponential Model: uses equation calculating atmospheric density on basis of a specified altitude, reference density, reference altitude and scale altitude."""
    HARRIS_PRIESTER = 3
    """Harris-Priester: takes into account a 10.7 cm solar flux level and diurnal bulge. Uses density tables. Valid range of 0-1000 km."""
    JACCHIA_ROBERTS = 4
    """Jacchia-Roberts: similar to Jacchia 1971 (below) but uses analytical methods to improve performance. Lower altitude boundary is 90 km."""
    JACCHIA60 = 5
    """Jacchia 1960: outdated atmospheric model provided for making comparisons with other software. Lower altitude boundary is 0 km."""
    JACCHIA70 = 6
    """Jacchia 1970: computes atmospheric density based on the composition of the atmosphere, which depends on altitude as well as seasonal variation. Valid range is 100-2500 km."""
    JACCHIA71 = 7
    """Jacchia 1971: similar to Jacchia 1970 (above), with improved treatment of certain solar effects."""
    MSIS00 = 8
    """NRLMSISE 2000: finds the total density by accounting for the contribution of N, N2, O, O2, He, Ar and H. Includes anomalous oxygen. 2000 version, valid range of 0-1000 km."""
    MSIS86 = 9
    """MSIS 1986: finds the total density by accounting for the contribution of N2, O, O2, He, Ar and H. 1986 version, valid range of 90-1000 km."""
    MSIS90 = 10
    """MSISE 1990: finds the total density by accounting for the contribution of N2, O, O2, He, Ar and H. 1990 version, valid range of 0-1000 km."""
    UNKNOWN = 11
    """Unsupported or unknown atmospheric density model."""
    USER_DEFINED = 12
    """Do not use this enumeration, as it is deprecated. This option is no longer available for VehicleHPOPForceModelDrag. User-defined atmospheric density model."""
    DTM2012 = 13
    """DTM 2012: The Drag Temperature Model (DTM), 2012 version, is a semi-empirical model which computes the temperature, density, and composition of the thermosphere. Developed at CNES. Valid range of 120 - 1500 km."""
    DTM2020 = 14
    """DTM 2020: The Drag Temperature Model (DTM), 2020 version, is a semi-empirical model which computes the temperature, density, and composition of the thermosphere. Developed at CNES. Valid range of 120 - 1500 km."""

AtmosphericDensityModel.STANDARD_ATMOSPHERE_MODEL_1976.__doc__ = "1976 Standard Atmosphere: look-up model based on the satellite's altitude, with a valid range of 86km - 1000 km."
AtmosphericDensityModel.CIRA72.__doc__ = "CIRA 1972: empirical model of atmospheric temperature and densities as recommended by the Committee on Space Research (COSPAR). Lower altitude boundary is 90 km."
AtmosphericDensityModel.EXPONENTIAL_MODEL.__doc__ = "Do not use this enumeration, as it is deprecated. Exponential Model: uses equation calculating atmospheric density on basis of a specified altitude, reference density, reference altitude and scale altitude."
AtmosphericDensityModel.HARRIS_PRIESTER.__doc__ = "Harris-Priester: takes into account a 10.7 cm solar flux level and diurnal bulge. Uses density tables. Valid range of 0-1000 km."
AtmosphericDensityModel.JACCHIA_ROBERTS.__doc__ = "Jacchia-Roberts: similar to Jacchia 1971 (below) but uses analytical methods to improve performance. Lower altitude boundary is 90 km."
AtmosphericDensityModel.JACCHIA60.__doc__ = "Jacchia 1960: outdated atmospheric model provided for making comparisons with other software. Lower altitude boundary is 0 km."
AtmosphericDensityModel.JACCHIA70.__doc__ = "Jacchia 1970: computes atmospheric density based on the composition of the atmosphere, which depends on altitude as well as seasonal variation. Valid range is 100-2500 km."
AtmosphericDensityModel.JACCHIA71.__doc__ = "Jacchia 1971: similar to Jacchia 1970 (above), with improved treatment of certain solar effects."
AtmosphericDensityModel.MSIS00.__doc__ = "NRLMSISE 2000: finds the total density by accounting for the contribution of N, N2, O, O2, He, Ar and H. Includes anomalous oxygen. 2000 version, valid range of 0-1000 km."
AtmosphericDensityModel.MSIS86.__doc__ = "MSIS 1986: finds the total density by accounting for the contribution of N2, O, O2, He, Ar and H. 1986 version, valid range of 90-1000 km."
AtmosphericDensityModel.MSIS90.__doc__ = "MSISE 1990: finds the total density by accounting for the contribution of N2, O, O2, He, Ar and H. 1990 version, valid range of 0-1000 km."
AtmosphericDensityModel.UNKNOWN.__doc__ = "Unsupported or unknown atmospheric density model."
AtmosphericDensityModel.USER_DEFINED.__doc__ = "Do not use this enumeration, as it is deprecated. This option is no longer available for VehicleHPOPForceModelDrag. User-defined atmospheric density model."
AtmosphericDensityModel.DTM2012.__doc__ = "DTM 2012: The Drag Temperature Model (DTM), 2012 version, is a semi-empirical model which computes the temperature, density, and composition of the thermosphere. Developed at CNES. Valid range of 120 - 1500 km."
AtmosphericDensityModel.DTM2020.__doc__ = "DTM 2020: The Drag Temperature Model (DTM), 2020 version, is a semi-empirical model which computes the temperature, density, and composition of the thermosphere. Developed at CNES. Valid range of 120 - 1500 km."

agcls.AgTypeNameMap["AtmosphericDensityModel"] = AtmosphericDensityModel

class MarkerShape3d(IntEnum):
    """3D marker shapes."""

    SHAPE_CIRCLE = 0
    """Marker shape: circle."""
    SHAPE_PLUS = 1
    """Marker shape: plus sign."""
    SHAPE_POINT = 2
    """Marker shape: point."""
    SHAPE_SQUARE = 3
    """Marker shape: square."""
    SHAPE_STAR = 4
    """Marker shape: star."""
    SHAPE_TRIANGLE = 5
    """Marker shape: triangle."""
    SHAPE_X = 6
    """Marker shape: X."""

MarkerShape3d.SHAPE_CIRCLE.__doc__ = "Marker shape: circle."
MarkerShape3d.SHAPE_PLUS.__doc__ = "Marker shape: plus sign."
MarkerShape3d.SHAPE_POINT.__doc__ = "Marker shape: point."
MarkerShape3d.SHAPE_SQUARE.__doc__ = "Marker shape: square."
MarkerShape3d.SHAPE_STAR.__doc__ = "Marker shape: star."
MarkerShape3d.SHAPE_TRIANGLE.__doc__ = "Marker shape: triangle."
MarkerShape3d.SHAPE_X.__doc__ = "Marker shape: X."

agcls.AgTypeNameMap["MarkerShape3d"] = MarkerShape3d

class LeadTrailData(IntEnum):
    """Lead and trail types for track display."""

    UNKNOWN = -1
    """Unknown."""
    NONE = 0
    """None: Display none of the selected portion (leading or trailing) of the track."""
    ALL = 1
    """All: Display the track spanning the entire vehicle ephemeris."""
    FRACTION = 2
    """Fraction: Display the specified fraction of the selected portion (leading or trailing) of the track."""
    FULL = 3
    """Full: Display all of the selected portion (leading or trailing) of the track."""
    HALF = 4
    """Half: Display 1/2 of the selected portion (leading or trailing) of the track."""
    ONE_PASS = 5
    """One pass (satellites only): Display forward to the first pass break. At the pass break, display forward to the next one."""
    QUARTER = 6
    """Quarter:  Display 1/4 of the selected portion (leading or trailing) of the track."""
    TIME = 7
    """Time: Display the segment of the selected portion (leading or trailing) of the vehicle's path that it traverses in the specified amount of time."""
    CURRENT_INTERVAL = 8
    """Current Interval: Display the leading portion of the vehicle's track for the current animation time interval."""

LeadTrailData.UNKNOWN.__doc__ = "Unknown."
LeadTrailData.NONE.__doc__ = "None: Display none of the selected portion (leading or trailing) of the track."
LeadTrailData.ALL.__doc__ = "All: Display the track spanning the entire vehicle ephemeris."
LeadTrailData.FRACTION.__doc__ = "Fraction: Display the specified fraction of the selected portion (leading or trailing) of the track."
LeadTrailData.FULL.__doc__ = "Full: Display all of the selected portion (leading or trailing) of the track."
LeadTrailData.HALF.__doc__ = "Half: Display 1/2 of the selected portion (leading or trailing) of the track."
LeadTrailData.ONE_PASS.__doc__ = "One pass (satellites only): Display forward to the first pass break. At the pass break, display forward to the next one."
LeadTrailData.QUARTER.__doc__ = "Quarter:  Display 1/4 of the selected portion (leading or trailing) of the track."
LeadTrailData.TIME.__doc__ = "Time: Display the segment of the selected portion (leading or trailing) of the vehicle's path that it traverses in the specified amount of time."
LeadTrailData.CURRENT_INTERVAL.__doc__ = "Current Interval: Display the leading portion of the vehicle's track for the current animation time interval."

agcls.AgTypeNameMap["LeadTrailData"] = LeadTrailData

class TickData(IntEnum):
    """Tick mark options. Tick marks represent milestones at specified intervals along a vehicle's track in the 3D Graphics window."""

    UNKNOWN = -1
    """Tick mark option: unknown."""
    CROSS_TRACK = 0
    """Draw tick marks in cross-track direction."""
    POINT = 1
    """Display tick as a point."""
    RADIAL = 2
    """Draw tick marks in radial direction."""
    RADIAL_AND_CROSS_TRACK = 3
    """Draw tick marks in radial and cross-track directions."""

TickData.UNKNOWN.__doc__ = "Tick mark option: unknown."
TickData.CROSS_TRACK.__doc__ = "Draw tick marks in cross-track direction."
TickData.POINT.__doc__ = "Display tick as a point."
TickData.RADIAL.__doc__ = "Draw tick marks in radial direction."
TickData.RADIAL_AND_CROSS_TRACK.__doc__ = "Draw tick marks in radial and cross-track directions."

agcls.AgTypeNameMap["TickData"] = TickData

class LoadMethod(IntEnum):
    """TLE load options."""

    AUTOMATIC_LOAD = 0
    """Auto load: STK automatically loads the TLE sets corresponding to the SSC number of the satellite when the satellite is loaded."""
    FILE_INSERT = 1
    """File insert: adds the selected TLE data but retains TLE data that is currently associated with the satellite."""
    FILE_LOAD = 2
    """File load: loads the selected TLE data and replaces all TLE data that is currently associated with the satellite."""
    ONLINE_AUTOMATIC_LOAD = 3
    """Online auto-load: STK automatically loads the TLE sets corresponding to the SSC number of the satellite from the AGI Web site."""
    ONLINE_LOAD = 4
    """goes directly to the AGI Web site to download the latest TLE sets."""

LoadMethod.AUTOMATIC_LOAD.__doc__ = "Auto load: STK automatically loads the TLE sets corresponding to the SSC number of the satellite when the satellite is loaded."
LoadMethod.FILE_INSERT.__doc__ = "File insert: adds the selected TLE data but retains TLE data that is currently associated with the satellite."
LoadMethod.FILE_LOAD.__doc__ = "File load: loads the selected TLE data and replaces all TLE data that is currently associated with the satellite."
LoadMethod.ONLINE_AUTOMATIC_LOAD.__doc__ = "Online auto-load: STK automatically loads the TLE sets corresponding to the SSC number of the satellite from the AGI Web site."
LoadMethod.ONLINE_LOAD.__doc__ = "goes directly to the AGI Web site to download the latest TLE sets."

agcls.AgTypeNameMap["LoadMethod"] = LoadMethod

class DeticPositionType(IntEnum):
    """LLA Position Types."""

    UNKNOWN = -1
    """Unknown position type."""
    CENTRIC = 0
    """Geocentric position type."""
    DETIC = 1
    """Geodetic position type."""

DeticPositionType.UNKNOWN.__doc__ = "Unknown position type."
DeticPositionType.CENTRIC.__doc__ = "Geocentric position type."
DeticPositionType.DETIC.__doc__ = "Geodetic position type."

agcls.AgTypeNameMap["DeticPositionType"] = DeticPositionType

class VehicleGraphics2DPass(IntEnum):
    """Pass display options."""

    UNKNOWN = -1
    """Unknown pass."""
    SHOW_ALL = 0
    """Show all passes."""
    SHOW_PASSES_IN_RANGE = 1
    """Show passes in a user-specified range."""

VehicleGraphics2DPass.UNKNOWN.__doc__ = "Unknown pass."
VehicleGraphics2DPass.SHOW_ALL.__doc__ = "Show all passes."
VehicleGraphics2DPass.SHOW_PASSES_IN_RANGE.__doc__ = "Show passes in a user-specified range."

agcls.AgTypeNameMap["VehicleGraphics2DPass"] = VehicleGraphics2DPass

class VehicleGraphics2DVisibleSideType(IntEnum):
    """Pass display direction options."""

    ASCENDING = 0
    """Display only the ascending side of each pass."""
    BOTH = 1
    """Display both ascending and descending sides of each pass."""
    SIDES_DESCENDING = 2
    """Display only the descending side of each pass."""
    SIDES_NONE = 3
    """Display neither the ascending nor the descending side of any pass."""

VehicleGraphics2DVisibleSideType.ASCENDING.__doc__ = "Display only the ascending side of each pass."
VehicleGraphics2DVisibleSideType.BOTH.__doc__ = "Display both ascending and descending sides of each pass."
VehicleGraphics2DVisibleSideType.SIDES_DESCENDING.__doc__ = "Display only the descending side of each pass."
VehicleGraphics2DVisibleSideType.SIDES_NONE.__doc__ = "Display neither the ascending nor the descending side of any pass."

agcls.AgTypeNameMap["VehicleGraphics2DVisibleSideType"] = VehicleGraphics2DVisibleSideType

class VehicleGraphics2DOffset(IntEnum):
    """Options for offset direction for 2D time events graphics."""

    UNKNOWN = -1
    """Unknown Offset."""
    OFFSET_LEFT = 0
    """Offset to the left."""
    OFFSET_RIGHT = 1
    """Offset to the right."""

VehicleGraphics2DOffset.UNKNOWN.__doc__ = "Unknown Offset."
VehicleGraphics2DOffset.OFFSET_LEFT.__doc__ = "Offset to the left."
VehicleGraphics2DOffset.OFFSET_RIGHT.__doc__ = "Offset to the right."

agcls.AgTypeNameMap["VehicleGraphics2DOffset"] = VehicleGraphics2DOffset

class VehicleGraphics2DTimeEventType(IntEnum):
    """2D Graphics time event graphics options."""

    UNKNOWN = -1
    """Unknown Time Event Type."""
    LINE = 0
    """Line."""
    MARKER = 1
    """Marker."""
    TEXT = 2
    """Text."""

VehicleGraphics2DTimeEventType.UNKNOWN.__doc__ = "Unknown Time Event Type."
VehicleGraphics2DTimeEventType.LINE.__doc__ = "Line."
VehicleGraphics2DTimeEventType.MARKER.__doc__ = "Marker."
VehicleGraphics2DTimeEventType.TEXT.__doc__ = "Text."

agcls.AgTypeNameMap["VehicleGraphics2DTimeEventType"] = VehicleGraphics2DTimeEventType

class VehicleGraphics2DAttributeType(IntEnum):
    """Criteria for displaying a vehicle's 2D Graphics attributes."""

    UNKNOWN = -1
    """Unknown."""
    ACCESS = 0
    """Display based on access periods."""
    BASIC = 1
    """Basic display."""
    CUSTOM = 2
    """Display based on custom intervals."""
    REAL_TIME = 3
    """Display based on real time data state."""
    TIME_COMPONENTS = 4
    """Display based on Timeline events, intervals, time arrays, interval lists and interval collections."""

VehicleGraphics2DAttributeType.UNKNOWN.__doc__ = "Unknown."
VehicleGraphics2DAttributeType.ACCESS.__doc__ = "Display based on access periods."
VehicleGraphics2DAttributeType.BASIC.__doc__ = "Basic display."
VehicleGraphics2DAttributeType.CUSTOM.__doc__ = "Display based on custom intervals."
VehicleGraphics2DAttributeType.REAL_TIME.__doc__ = "Display based on real time data state."
VehicleGraphics2DAttributeType.TIME_COMPONENTS.__doc__ = "Display based on Timeline events, intervals, time arrays, interval lists and interval collections."

agcls.AgTypeNameMap["VehicleGraphics2DAttributeType"] = VehicleGraphics2DAttributeType

class VehicleGraphics2DElevation(IntEnum):
    """Options for vehicle swath."""

    UNKNOWN = -1
    """Unknown."""
    ELEVATION_GROUND_ELEVATION = 0
    """Ground elevation."""
    ELEVATION_SWATH_HALF_WIDTH = 2
    """Swath half width."""
    ELEVATION_VEHICLE_HALF_ANGLE = 3
    """Vehicle half angle."""
    ELEVATION_GROUND_ELEVATION_ENVELOPE = 4
    """Vehicle ground elevation envelope."""
    ELEVATION_VEHICLE_HALF_ANGLE_ENVELOPE = 5
    """Vehicle half angle envelope."""

VehicleGraphics2DElevation.UNKNOWN.__doc__ = "Unknown."
VehicleGraphics2DElevation.ELEVATION_GROUND_ELEVATION.__doc__ = "Ground elevation."
VehicleGraphics2DElevation.ELEVATION_SWATH_HALF_WIDTH.__doc__ = "Swath half width."
VehicleGraphics2DElevation.ELEVATION_VEHICLE_HALF_ANGLE.__doc__ = "Vehicle half angle."
VehicleGraphics2DElevation.ELEVATION_GROUND_ELEVATION_ENVELOPE.__doc__ = "Vehicle ground elevation envelope."
VehicleGraphics2DElevation.ELEVATION_VEHICLE_HALF_ANGLE_ENVELOPE.__doc__ = "Vehicle half angle envelope."

agcls.AgTypeNameMap["VehicleGraphics2DElevation"] = VehicleGraphics2DElevation

class VehicleGraphics2DOptionType(IntEnum):
    """Display options for vehicle swath."""

    OPTIONS_EDGE_LIMITS = 0
    """Edge limits: displays the swath limits to either side of a center ground track."""
    OPTIONS_FILLED_LIMITS = 1
    """Filled limits: displays a crosstrack pattern to the swath limits at each path point along the ground track."""
    OPTIONS_NO_GRAPHICS = 2
    """No graphics: swath is removed from the 2D Graphics window."""

VehicleGraphics2DOptionType.OPTIONS_EDGE_LIMITS.__doc__ = "Edge limits: displays the swath limits to either side of a center ground track."
VehicleGraphics2DOptionType.OPTIONS_FILLED_LIMITS.__doc__ = "Filled limits: displays a crosstrack pattern to the swath limits at each path point along the ground track."
VehicleGraphics2DOptionType.OPTIONS_NO_GRAPHICS.__doc__ = "No graphics: swath is removed from the 2D Graphics window."

agcls.AgTypeNameMap["VehicleGraphics2DOptionType"] = VehicleGraphics2DOptionType

class ModelType(IntEnum):
    """Display options 3D model."""

    LIST = 0x0
    """Model list: display several models at different times during the animation."""
    FILE = 0x1
    """Model file: display the same model at all times during animation."""

ModelType.LIST.__doc__ = "Model list: display several models at different times during the animation."
ModelType.FILE.__doc__ = "Model file: display the same model at all times during animation."

agcls.AgTypeNameMap["ModelType"] = ModelType

class VehicleGraphics3DDropLineType(IntEnum):
    """Options for where to end drop lines."""

    MEAN_SEA_LEVEL = 0
    """Drop lines to Mean Sea Level."""
    TERRAIN = 1
    """Drop lines to terrain."""
    ELLIPSOID = 2
    """Drop lines to the central body's reference ellipsoid (WGS84)."""

VehicleGraphics3DDropLineType.MEAN_SEA_LEVEL.__doc__ = "Drop lines to Mean Sea Level."
VehicleGraphics3DDropLineType.TERRAIN.__doc__ = "Drop lines to terrain."
VehicleGraphics3DDropLineType.ELLIPSOID.__doc__ = "Drop lines to the central body's reference ellipsoid (WGS84)."

agcls.AgTypeNameMap["VehicleGraphics3DDropLineType"] = VehicleGraphics3DDropLineType

class VehicleGraphics3DSigmaScale(IntEnum):
    """Sigma scale options for sizing covariance pointing contours."""

    UNKNOWN = -1
    """Unknown."""
    PROBABILITY = 0
    """Use probability: the contour is sized indirectly by specifying the probability encompassed by the ellipsoid as a percent."""
    SCALE = 1
    """Use scale: the contour is sized directly by specifying the scale."""

VehicleGraphics3DSigmaScale.UNKNOWN.__doc__ = "Unknown."
VehicleGraphics3DSigmaScale.PROBABILITY.__doc__ = "Use probability: the contour is sized indirectly by specifying the probability encompassed by the ellipsoid as a percent."
VehicleGraphics3DSigmaScale.SCALE.__doc__ = "Use scale: the contour is sized directly by specifying the scale."

agcls.AgTypeNameMap["VehicleGraphics3DSigmaScale"] = VehicleGraphics3DSigmaScale

class VehicleGraphics3DAttributeType(IntEnum):
    """Options for 3D graphics for covariance pointing contours."""

    UNKNOWN = -1
    """Unknown."""
    BASIC = 0
    """Set basic 3D graphics properties."""
    INTERVALS = 1
    """Define 3D graphics properties based on intervals."""

VehicleGraphics3DAttributeType.UNKNOWN.__doc__ = "Unknown."
VehicleGraphics3DAttributeType.BASIC.__doc__ = "Set basic 3D graphics properties."
VehicleGraphics3DAttributeType.INTERVALS.__doc__ = "Define 3D graphics properties based on intervals."

agcls.AgTypeNameMap["VehicleGraphics3DAttributeType"] = VehicleGraphics3DAttributeType

class RouteGraphics3DMarkerType(IntEnum):
    """Waypoint marker options."""

    IMAGE = 0
    """Use image file."""
    MARKER = 1
    """Use marker."""

RouteGraphics3DMarkerType.IMAGE.__doc__ = "Use image file."
RouteGraphics3DMarkerType.MARKER.__doc__ = "Use marker."

agcls.AgTypeNameMap["RouteGraphics3DMarkerType"] = RouteGraphics3DMarkerType

class VehicleEllipseOptionType(IntEnum):
    """Elliptical motion modeling options."""

    OSCULATING = 0
    """Osculating: representative of the particular point on a satellite trajectory, but the actual trajectory differs from its two-body counterpart at other points in time."""
    SECULARLY_PRECESSING = 1
    """Secularly precessing: remains constant in shape and size but changes orientation in a continuous, consistent manner."""

VehicleEllipseOptionType.OSCULATING.__doc__ = "Osculating: representative of the particular point on a satellite trajectory, but the actual trajectory differs from its two-body counterpart at other points in time."
VehicleEllipseOptionType.SECULARLY_PRECESSING.__doc__ = "Secularly precessing: remains constant in shape and size but changes orientation in a continuous, consistent manner."

agcls.AgTypeNameMap["VehicleEllipseOptionType"] = VehicleEllipseOptionType

class PropagatorType(IntEnum):
    """Vehicle propagators (available for vehicle types listed in parentheses)."""

    UNKNOWN = -1
    """Unknown propagator (all vehicles)."""
    HPOP = 0
    """High Precision Orbit Propagator (satellites and missiles): handles circular, elliptical, parabolic and hyperbolic orbits at distances ranging from the surface of the Earth to the orbit of the Moon and beyond."""
    J2_PERTURBATION = 1
    """J2 Perturbation (1st-order) (satellites): accounts for secular variations in the orbit elements due to Earth oblateness, but does not model atmospheric drag or solar or lunar gravitational forces."""
    J4_PERTURBATION = 2
    """J4 Perburbation (2nd order) (satellites): accounts for secular variations in orbit elements due to Earth oblateness, but doesn't model atmos. drag or solar or lunar grav. forces. Includes 1st and 2nd order effects of J2 and 1st order effects of J4."""
    LOP = 3
    """Long-term Orbit Propagator (satellites): allows accurate prediction of the motion of a satellite's orbit over many months or years."""
    SGP4 = 4
    """SGP4 (satellites): a standard AFSPACECOM propagator used with two-line mean element (TLE) sets."""
    SPICE = 5
    """SPICE (satellites): reads ephemeris from binary files that are in a standard format produced by the Jet Propulsion Laboratory (JPL)."""
    STK_EXTERNAL = 6
    """STK external (all vehicles): allows you to read the ephemeris for a satellite from a file."""
    TWO_BODY = 7
    """Two Body(Keplerian motion) propagator (satellites and missiles): considers only the force of gravity from the Earth, which is modeled as a point mass."""
    USER_EXTERNAL = 8
    """User-External propagator."""
    GREAT_ARC = 9
    """Great Arc (aircraft, ships and ground vehicles): defines a point-by-point path over the surface of the Earth with position and altitude defined at each point."""
    BALLISTIC = 10
    """Ballistic (missiles): defines vehicles following an elliptical path that begins and ends at the Earth's surface."""
    SIMPLE_ASCENT = 11
    """Simple Ascent (launch vehicles): creates an ascent trajectory based on launch and insertion parameters."""
    ASTROGATOR = 12
    """Astrogator propagator."""
    REAL_TIME = 13
    """Realtime propagator."""
    GPS = 14
    """GPS propagator."""
    AVIATOR = 15
    """Aviator propagator."""
    PROPAGATOR_11_PARAMETERS = 16
    """The 11-Parameter propagator models geostationary satellites using 11-Parameter files. The propagator uses an algorithm documented in Intelsat Earth Station Standards (IESS) IESS-412 (Rev. 2), available at www.celestrak.com."""
    SP3 = 17
    """The SP3 propagator reads .sp3 files of type 'a' and 'c' and allows you to use multiple files in sequence. These files are used to provide precise GPS orbits from the National Geodetic Survey (NGS)."""

PropagatorType.UNKNOWN.__doc__ = "Unknown propagator (all vehicles)."
PropagatorType.HPOP.__doc__ = "High Precision Orbit Propagator (satellites and missiles): handles circular, elliptical, parabolic and hyperbolic orbits at distances ranging from the surface of the Earth to the orbit of the Moon and beyond."
PropagatorType.J2_PERTURBATION.__doc__ = "J2 Perturbation (1st-order) (satellites): accounts for secular variations in the orbit elements due to Earth oblateness, but does not model atmospheric drag or solar or lunar gravitational forces."
PropagatorType.J4_PERTURBATION.__doc__ = "J4 Perburbation (2nd order) (satellites): accounts for secular variations in orbit elements due to Earth oblateness, but doesn't model atmos. drag or solar or lunar grav. forces. Includes 1st and 2nd order effects of J2 and 1st order effects of J4."
PropagatorType.LOP.__doc__ = "Long-term Orbit Propagator (satellites): allows accurate prediction of the motion of a satellite's orbit over many months or years."
PropagatorType.SGP4.__doc__ = "SGP4 (satellites): a standard AFSPACECOM propagator used with two-line mean element (TLE) sets."
PropagatorType.SPICE.__doc__ = "SPICE (satellites): reads ephemeris from binary files that are in a standard format produced by the Jet Propulsion Laboratory (JPL)."
PropagatorType.STK_EXTERNAL.__doc__ = "STK external (all vehicles): allows you to read the ephemeris for a satellite from a file."
PropagatorType.TWO_BODY.__doc__ = "Two Body(Keplerian motion) propagator (satellites and missiles): considers only the force of gravity from the Earth, which is modeled as a point mass."
PropagatorType.USER_EXTERNAL.__doc__ = "User-External propagator."
PropagatorType.GREAT_ARC.__doc__ = "Great Arc (aircraft, ships and ground vehicles): defines a point-by-point path over the surface of the Earth with position and altitude defined at each point."
PropagatorType.BALLISTIC.__doc__ = "Ballistic (missiles): defines vehicles following an elliptical path that begins and ends at the Earth's surface."
PropagatorType.SIMPLE_ASCENT.__doc__ = "Simple Ascent (launch vehicles): creates an ascent trajectory based on launch and insertion parameters."
PropagatorType.ASTROGATOR.__doc__ = "Astrogator propagator."
PropagatorType.REAL_TIME.__doc__ = "Realtime propagator."
PropagatorType.GPS.__doc__ = "GPS propagator."
PropagatorType.AVIATOR.__doc__ = "Aviator propagator."
PropagatorType.PROPAGATOR_11_PARAMETERS.__doc__ = "The 11-Parameter propagator models geostationary satellites using 11-Parameter files. The propagator uses an algorithm documented in Intelsat Earth Station Standards (IESS) IESS-412 (Rev. 2), available at www.celestrak.com."
PropagatorType.SP3.__doc__ = "The SP3 propagator reads .sp3 files of type 'a' and 'c' and allows you to use multiple files in sequence. These files are used to provide precise GPS orbits from the National Geodetic Survey (NGS)."

agcls.AgTypeNameMap["PropagatorType"] = PropagatorType

class PropagatorSGP4SwitchMethod(IntEnum):
    """TLE Switch method for the SGP4 propagator."""

    EPOCH = 0
    """Epoch: switch between TLE sets based on the epoch of the TLE."""
    MIDPOINT = 1
    """Mid-Point: switch between TLE sets based on the mid-point between two TLE epochs."""
    TIME_OF_CLOSEST_APPROACH = 2
    """TCA: switch between TLE sets based on the time of closest approach."""
    OVERRIDE = 3
    """Override: set the switching time between two TLE sets using the Start Time file."""
    DISABLE = 4
    """Disable: ignore the selected TLE set (if you attempt to disable all of them, STK uses the first in the scenario time period)."""

PropagatorSGP4SwitchMethod.EPOCH.__doc__ = "Epoch: switch between TLE sets based on the epoch of the TLE."
PropagatorSGP4SwitchMethod.MIDPOINT.__doc__ = "Mid-Point: switch between TLE sets based on the mid-point between two TLE epochs."
PropagatorSGP4SwitchMethod.TIME_OF_CLOSEST_APPROACH.__doc__ = "TCA: switch between TLE sets based on the time of closest approach."
PropagatorSGP4SwitchMethod.OVERRIDE.__doc__ = "Override: set the switching time between two TLE sets using the Start Time file."
PropagatorSGP4SwitchMethod.DISABLE.__doc__ = "Disable: ignore the selected TLE set (if you attempt to disable all of them, STK uses the first in the scenario time period)."

agcls.AgTypeNameMap["PropagatorSGP4SwitchMethod"] = PropagatorSGP4SwitchMethod

class VehicleSGP4TLESelectionType(IntEnum):
    """TLE Selection method for the SGP4 propagator."""

    USE_ALL = 0
    """Use all relevant TLEs."""
    USE_FIRST = 1
    """Use first relevant TLE."""

VehicleSGP4TLESelectionType.USE_ALL.__doc__ = "Use all relevant TLEs."
VehicleSGP4TLESelectionType.USE_FIRST.__doc__ = "Use first relevant TLE."

agcls.AgTypeNameMap["VehicleSGP4TLESelectionType"] = VehicleSGP4TLESelectionType

class VehicleSGP4AutomaticUpdateSourceType(IntEnum):
    """The TLE sources where the SGP4 propagator retrieves TLEs from automatically upon propagation."""

    UNKNOWN = -1
    """Unknown or unsupported TLE source."""
    ONLINE = 0
    """Retrieve TLEs from an online source (AGI server)."""
    ONLINE_SPACE_TRACK = 1
    """Retrieve TLEs from the space track. Not currently supported."""
    FILE = 2
    """Retrieve TLEs from a file."""
    NONE = 3
    """Manually specify/import TLEs, no auto-updates will be performed during propagation."""

VehicleSGP4AutomaticUpdateSourceType.UNKNOWN.__doc__ = "Unknown or unsupported TLE source."
VehicleSGP4AutomaticUpdateSourceType.ONLINE.__doc__ = "Retrieve TLEs from an online source (AGI server)."
VehicleSGP4AutomaticUpdateSourceType.ONLINE_SPACE_TRACK.__doc__ = "Retrieve TLEs from the space track. Not currently supported."
VehicleSGP4AutomaticUpdateSourceType.FILE.__doc__ = "Retrieve TLEs from a file."
VehicleSGP4AutomaticUpdateSourceType.NONE.__doc__ = "Manually specify/import TLEs, no auto-updates will be performed during propagation."

agcls.AgTypeNameMap["VehicleSGP4AutomaticUpdateSourceType"] = VehicleSGP4AutomaticUpdateSourceType

class ThirdBodyGravitySourceType(IntEnum):
    """Sources for 3rd body gravitation data."""

    CENTRAL_BODY_FILE = 0
    """Central body file (all bodies): gravitational value from editable central body file shipped with STK."""
    HPOP_HISTORICAL = 1
    """HPOP historical (Sun and Moon only): hard-coded, uneditable value used in prior versions of HPOP."""
    JPL_DEVELOPMENTAL_EPHEMERIS = 2
    """JPL DE (Sun, Moon and planets): DE 405 ephemerides, covering a time span from 1960 to 2060."""
    USER_SPECIFIED = 3
    """User-specified: enter the value directly."""

ThirdBodyGravitySourceType.CENTRAL_BODY_FILE.__doc__ = "Central body file (all bodies): gravitational value from editable central body file shipped with STK."
ThirdBodyGravitySourceType.HPOP_HISTORICAL.__doc__ = "HPOP historical (Sun and Moon only): hard-coded, uneditable value used in prior versions of HPOP."
ThirdBodyGravitySourceType.JPL_DEVELOPMENTAL_EPHEMERIS.__doc__ = "JPL DE (Sun, Moon and planets): DE 405 ephemerides, covering a time span from 1960 to 2060."
ThirdBodyGravitySourceType.USER_SPECIFIED.__doc__ = "User-specified: enter the value directly."

agcls.AgTypeNameMap["ThirdBodyGravitySourceType"] = ThirdBodyGravitySourceType

class VehicleGeomagneticFluxSourceType(IntEnum):
    """GeomagFluxSrc."""

    READ_KP_FROM_FILE = 0
    """Read Kp from file."""
    READ_AP_FROM_FILE = 1
    """Read Ap from file."""

VehicleGeomagneticFluxSourceType.READ_KP_FROM_FILE.__doc__ = "Read Kp from file."
VehicleGeomagneticFluxSourceType.READ_AP_FROM_FILE.__doc__ = "Read Ap from file."

agcls.AgTypeNameMap["VehicleGeomagneticFluxSourceType"] = VehicleGeomagneticFluxSourceType

class VehicleGeomagneticFluxUpdateRateType(IntEnum):
    """Geomagnetic flux update rate options."""

    EVERY_3_HOURS = 0
    """3-Hourly: updates using the eight values measured at three-hour intervals."""
    INTERPOLATE_3_HOURLY_DATA = 1
    """3-Hourly Interpolated: updates by interpolating the three-hour values."""
    DAILY = 2
    """Daily."""
    CUBIC_SPLINE_3_HOURLY_DATA = 3
    """3-Hourly Cubic Spline."""

VehicleGeomagneticFluxUpdateRateType.EVERY_3_HOURS.__doc__ = "3-Hourly: updates using the eight values measured at three-hour intervals."
VehicleGeomagneticFluxUpdateRateType.INTERPOLATE_3_HOURLY_DATA.__doc__ = "3-Hourly Interpolated: updates by interpolating the three-hour values."
VehicleGeomagneticFluxUpdateRateType.DAILY.__doc__ = "Daily."
VehicleGeomagneticFluxUpdateRateType.CUBIC_SPLINE_3_HOURLY_DATA.__doc__ = "3-Hourly Cubic Spline."

agcls.AgTypeNameMap["VehicleGeomagneticFluxUpdateRateType"] = VehicleGeomagneticFluxUpdateRateType

class VehicleSolarFluxGeomagneticType(IntEnum):
    """Options for specifying solar and geomagnetic flux."""

    UNKNOWN = -1
    """Unknown."""
    MANUAL_ENTRY = 0
    """Specify appropriate parameters directly, depending on the selected atmospheric density model."""
    FILE = 1
    """Use a file to specify solar and geomagnetic flux."""

VehicleSolarFluxGeomagneticType.UNKNOWN.__doc__ = "Unknown."
VehicleSolarFluxGeomagneticType.MANUAL_ENTRY.__doc__ = "Specify appropriate parameters directly, depending on the selected atmospheric density model."
VehicleSolarFluxGeomagneticType.FILE.__doc__ = "Use a file to specify solar and geomagnetic flux."

agcls.AgTypeNameMap["VehicleSolarFluxGeomagneticType"] = VehicleSolarFluxGeomagneticType

class VehicleIntegrationModel(IntEnum):
    """Integration methods."""

    BULIRSCH_STOER = 0
    """Bulirsch-Stoer: integration method based on Richardson extrapolation with automatic step size control."""
    GAUSS_JACKSON = 1
    """Gauss-Jackson: 12th order Gauss-Jackson integration method for second order ODEs."""
    RUNGE_KUTTA_4 = 2
    """RK 4: Runge-Kutta integration method of 4th order with no error control for the integration step size."""
    RUNGE_KUTTA_FEHLBERG_78 = 3
    """RKF 7(8): Runge-Kutta-Fehlberg integration method of 7th order with 8th order error control for the integration step size."""
    RUNGE_KUTTA_VERNER_89_EFFICIENT = 4
    """RKV 8(9) Efficient: Runge-Kutta-Verner integration method of 8th order with 9th order error control for the integration step size, using the efficient coefficient set."""

VehicleIntegrationModel.BULIRSCH_STOER.__doc__ = "Bulirsch-Stoer: integration method based on Richardson extrapolation with automatic step size control."
VehicleIntegrationModel.GAUSS_JACKSON.__doc__ = "Gauss-Jackson: 12th order Gauss-Jackson integration method for second order ODEs."
VehicleIntegrationModel.RUNGE_KUTTA_4.__doc__ = "RK 4: Runge-Kutta integration method of 4th order with no error control for the integration step size."
VehicleIntegrationModel.RUNGE_KUTTA_FEHLBERG_78.__doc__ = "RKF 7(8): Runge-Kutta-Fehlberg integration method of 7th order with 8th order error control for the integration step size."
VehicleIntegrationModel.RUNGE_KUTTA_VERNER_89_EFFICIENT.__doc__ = "RKV 8(9) Efficient: Runge-Kutta-Verner integration method of 8th order with 9th order error control for the integration step size, using the efficient coefficient set."

agcls.AgTypeNameMap["VehicleIntegrationModel"] = VehicleIntegrationModel

class VehiclePredictorCorrectorScheme(IntEnum):
    """Predictor Corrector schemes."""

    FULL_CORRECTION = 0
    """Full correction: use a full evaluation of the acceleration model at the end of a Gauss-Jackson integration step."""
    PSEUDOCORRECTION = 1
    """Pseudo correction: use a pseudo-evaluation where only the two body acceleration is updated."""

VehiclePredictorCorrectorScheme.FULL_CORRECTION.__doc__ = "Full correction: use a full evaluation of the acceleration model at the end of a Gauss-Jackson integration step."
VehiclePredictorCorrectorScheme.PSEUDOCORRECTION.__doc__ = "Pseudo correction: use a pseudo-evaluation where only the two body acceleration is updated."

agcls.AgTypeNameMap["VehiclePredictorCorrectorScheme"] = VehiclePredictorCorrectorScheme

class VehicleMethod(IntEnum):
    """Step size control options."""

    FIXED_STEP = 0
    """Fixed step: step size will remain constant throughout the integration of the orbit."""
    RELATIVE_ERROR = 1
    """Relative error: Control the step size based on relative error by providing the error tolerance, and the minimum and maximum integration step sizes to be allowed via relative error control."""

VehicleMethod.FIXED_STEP.__doc__ = "Fixed step: step size will remain constant throughout the integration of the orbit."
VehicleMethod.RELATIVE_ERROR.__doc__ = "Relative error: Control the step size based on relative error by providing the error tolerance, and the minimum and maximum integration step sizes to be allowed via relative error control."

agcls.AgTypeNameMap["VehicleMethod"] = VehicleMethod

class VehicleInterpolationMethod(IntEnum):
    """Interpolation methods."""

    UNKNOWN = -1
    """Unknown or unsupported interpolation method."""
    HERMITIAN = 0
    """Hermitian: uses the position and velocity ephemeris to interpolate position and velocity together."""
    LAGRANGE = 1
    """Lagrange: interpolates position and velocity separately."""
    VOP = 2
    """VOP: a special interpolator that deals well with ephemeris produced at a large step size."""

VehicleInterpolationMethod.UNKNOWN.__doc__ = "Unknown or unsupported interpolation method."
VehicleInterpolationMethod.HERMITIAN.__doc__ = "Hermitian: uses the position and velocity ephemeris to interpolate position and velocity together."
VehicleInterpolationMethod.LAGRANGE.__doc__ = "Lagrange: interpolates position and velocity separately."
VehicleInterpolationMethod.VOP.__doc__ = "VOP: a special interpolator that deals well with ephemeris produced at a large step size."

agcls.AgTypeNameMap["VehicleInterpolationMethod"] = VehicleInterpolationMethod

class VehicleFrame(IntEnum):
    """Frame options for covariance matrix."""

    FRENET = 0
    """Frenet."""
    J2000 = 1
    """J2000."""
    LVLH = 2
    """LVLH."""
    TRUE_OF_DATE = 3
    """True of Date."""

VehicleFrame.FRENET.__doc__ = "Frenet."
VehicleFrame.J2000.__doc__ = "J2000."
VehicleFrame.LVLH.__doc__ = "LVLH."
VehicleFrame.TRUE_OF_DATE.__doc__ = "True of Date."

agcls.AgTypeNameMap["VehicleFrame"] = VehicleFrame

class VehicleCorrelationListType(IntEnum):
    """Correlation List row and column values."""

    DRAG = 0
    """Drag parameter."""
    NONE = 1
    """None."""
    SOLAR_RADIATION_PRESSURE = 2
    """Solar radiation pressure parameter."""

VehicleCorrelationListType.DRAG.__doc__ = "Drag parameter."
VehicleCorrelationListType.NONE.__doc__ = "None."
VehicleCorrelationListType.SOLAR_RADIATION_PRESSURE.__doc__ = "Solar radiation pressure parameter."

agcls.AgTypeNameMap["VehicleCorrelationListType"] = VehicleCorrelationListType

class VehicleConsiderAnalysisType(IntEnum):
    """Consider parameters for HPOP covariance."""

    DRAG = 1
    """Drag: the consider parameter is the ballistic coefficient B, where B = Cd * DragArea/Mass."""
    SOLAR_RADIATION_PRESSURE = 2
    """Solar radiation pressure (SRP): the consider parameter is K, where K = Cr * SRPArea/Mass."""

VehicleConsiderAnalysisType.DRAG.__doc__ = "Drag: the consider parameter is the ballistic coefficient B, where B = Cd * DragArea/Mass."
VehicleConsiderAnalysisType.SOLAR_RADIATION_PRESSURE.__doc__ = "Solar radiation pressure (SRP): the consider parameter is K, where K = Cr * SRPArea/Mass."

agcls.AgTypeNameMap["VehicleConsiderAnalysisType"] = VehicleConsiderAnalysisType

class VehicleWaypointComputationMethod(IntEnum):
    """Methods for computing waypoints."""

    DETERMINE_TIME_ACCELERATION_FROM_VELOCITY = 0
    """Derive time and acceleration from velocity (smooth rate)."""
    DETERMINE_TIME_FROM_VELOCITY_AND_ACCELERATION = 1
    """Derive time from velocity and acceleration."""
    DETERMINE_VELOCITY_FROM_TIME = 2
    """Derive velocity from time (enforces a zero acceleration)."""

VehicleWaypointComputationMethod.DETERMINE_TIME_ACCELERATION_FROM_VELOCITY.__doc__ = "Derive time and acceleration from velocity (smooth rate)."
VehicleWaypointComputationMethod.DETERMINE_TIME_FROM_VELOCITY_AND_ACCELERATION.__doc__ = "Derive time from velocity and acceleration."
VehicleWaypointComputationMethod.DETERMINE_VELOCITY_FROM_TIME.__doc__ = "Derive velocity from time (enforces a zero acceleration)."

agcls.AgTypeNameMap["VehicleWaypointComputationMethod"] = VehicleWaypointComputationMethod

class VehicleAltitudeReference(IntEnum):
    """Reference altitude options for waypoints."""

    UNKNOWN = -1
    """Unknown."""
    MEAN_SEA_LEVEL = 0
    """Referenced to Mean Sea Level."""
    TERRAIN = 1
    """Referenced to the terrain under the vehicle's route (if terrain sources are loaded into the scenario)."""
    WGS84 = 2
    """Referenced to the central body's reference ellipsoid (WGS84)."""
    ELLIPSOID = 3
    """Referenced to the central body's reference ellipsoid."""

VehicleAltitudeReference.UNKNOWN.__doc__ = "Unknown."
VehicleAltitudeReference.MEAN_SEA_LEVEL.__doc__ = "Referenced to Mean Sea Level."
VehicleAltitudeReference.TERRAIN.__doc__ = "Referenced to the terrain under the vehicle's route (if terrain sources are loaded into the scenario)."
VehicleAltitudeReference.WGS84.__doc__ = "Referenced to the central body's reference ellipsoid (WGS84)."
VehicleAltitudeReference.ELLIPSOID.__doc__ = "Referenced to the central body's reference ellipsoid."

agcls.AgTypeNameMap["VehicleAltitudeReference"] = VehicleAltitudeReference

class VehicleWaypointInterpolationMethod(IntEnum):
    """Interpolation methods."""

    ELLIPSOID_HEIGHT = 0
    """Ellipsoid height: interpolate using the greatArc interpolator without considering terrain."""
    TERRAIN_HEIGHT = 1
    """Terrain height: assigns a height above terrain by a linear interpolation between the heights above terrain at the waypoints."""

VehicleWaypointInterpolationMethod.ELLIPSOID_HEIGHT.__doc__ = "Ellipsoid height: interpolate using the greatArc interpolator without considering terrain."
VehicleWaypointInterpolationMethod.TERRAIN_HEIGHT.__doc__ = "Terrain height: assigns a height above terrain by a linear interpolation between the heights above terrain at the waypoints."

agcls.AgTypeNameMap["VehicleWaypointInterpolationMethod"] = VehicleWaypointInterpolationMethod

class VehicleLaunch(IntEnum):
    """Options for launch coordinates."""

    UNKNOWN = -1
    """Unknown."""
    DETIC = 0
    """LLA (geodetic) coordinates."""
    CENTRIC = 1
    """LLR (geocentric) coordinates."""

VehicleLaunch.UNKNOWN.__doc__ = "Unknown."
VehicleLaunch.DETIC.__doc__ = "LLA (geodetic) coordinates."
VehicleLaunch.CENTRIC.__doc__ = "LLR (geocentric) coordinates."

agcls.AgTypeNameMap["VehicleLaunch"] = VehicleLaunch

class VehicleImpact(IntEnum):
    """Impact location options."""

    UNKNOWN = -1
    """Unknown."""
    IMPACT_LOCATION_DETIC = 0
    """LLA (geodetic) impact location."""
    IMPACT_LOCATION_CENTRIC = 1
    """LLR (geocentric) impact location."""

VehicleImpact.UNKNOWN.__doc__ = "Unknown."
VehicleImpact.IMPACT_LOCATION_DETIC.__doc__ = "LLA (geodetic) impact location."
VehicleImpact.IMPACT_LOCATION_CENTRIC.__doc__ = "LLR (geocentric) impact location."

agcls.AgTypeNameMap["VehicleImpact"] = VehicleImpact

class VehicleLaunchControl(IntEnum):
    """Flight parameters for a missile."""

    UNKNOWN = -1
    """Unknown."""
    FIXED_APOGEE_ALTITUDE = 0
    """Fixed apogee altitude."""
    FIXED_DELTA_V = 1
    """Fixed Delta V."""
    FIXED_DELTA_V_MINIMUM_ECCENTRICITY = 2
    """Fixed Delta V minimum eccentricity."""
    FIXED_TIME_OF_FLIGHT = 3
    """Fixed time of flight."""

VehicleLaunchControl.UNKNOWN.__doc__ = "Unknown."
VehicleLaunchControl.FIXED_APOGEE_ALTITUDE.__doc__ = "Fixed apogee altitude."
VehicleLaunchControl.FIXED_DELTA_V.__doc__ = "Fixed Delta V."
VehicleLaunchControl.FIXED_DELTA_V_MINIMUM_ECCENTRICITY.__doc__ = "Fixed Delta V minimum eccentricity."
VehicleLaunchControl.FIXED_TIME_OF_FLIGHT.__doc__ = "Fixed time of flight."

agcls.AgTypeNameMap["VehicleLaunchControl"] = VehicleLaunchControl

class VehicleImpactLocation(IntEnum):
    """Options for specifying missile impact point."""

    UNKNOWN = -1
    """Unknown."""
    LAUNCH_AZ_EL = 0
    """Use azimuth and elevation."""
    POINT = 1
    """Use geodetic or geocentric elements."""

VehicleImpactLocation.UNKNOWN.__doc__ = "Unknown."
VehicleImpactLocation.LAUNCH_AZ_EL.__doc__ = "Use azimuth and elevation."
VehicleImpactLocation.POINT.__doc__ = "Use geodetic or geocentric elements."

agcls.AgTypeNameMap["VehicleImpactLocation"] = VehicleImpactLocation

class VehiclePassNumbering(IntEnum):
    """Pass numbering options."""

    UNKNOWN = -1
    """Represents pass numbering currently not supported by the Object Model."""
    DATE_OF_FIRST_PASS = 0
    """Date of First Pass: override the first pass start time (normally the ephemeris start time)."""
    FIRST_PASS_NUMBER = 1
    """First Pass #: an integer to identify the number at which pass numbering begins."""
    MAINTAIN_PASS_NUMBER = 2
    """Maintain Pass #: STK continues the existing pass numbering sequence when a vehicle is repropagated or the epoch changes."""
    USE_PROPAGATOR_PASS_DATA = 3
    """Use Propagator Pass Data: should be used when the propagator is SGP4, which has its own definition for passes."""

VehiclePassNumbering.UNKNOWN.__doc__ = "Represents pass numbering currently not supported by the Object Model."
VehiclePassNumbering.DATE_OF_FIRST_PASS.__doc__ = "Date of First Pass: override the first pass start time (normally the ephemeris start time)."
VehiclePassNumbering.FIRST_PASS_NUMBER.__doc__ = "First Pass #: an integer to identify the number at which pass numbering begins."
VehiclePassNumbering.MAINTAIN_PASS_NUMBER.__doc__ = "Maintain Pass #: STK continues the existing pass numbering sequence when a vehicle is repropagated or the epoch changes."
VehiclePassNumbering.USE_PROPAGATOR_PASS_DATA.__doc__ = "Use Propagator Pass Data: should be used when the propagator is SGP4, which has its own definition for passes."

agcls.AgTypeNameMap["VehiclePassNumbering"] = VehiclePassNumbering

class VehiclePartialPassMeasurement(IntEnum):
    """Partial Pass Measurement methods (typically used for reporting data)."""

    ANGLE = 0
    """By Angle: angles are used to measure partial passes."""
    MEAN_ARGUMENT_OF_LATITUDE = 1
    """By Mean Argument of Latitude: passes are measured as the difference in the mean argument of latitude at the current time and that at the start of the pass break divided by 2 pi (argument of latitude = mean anomaly plus argument of perigee)."""
    TIME = 2
    """By Time: time is used to measure partial passes."""

VehiclePartialPassMeasurement.ANGLE.__doc__ = "By Angle: angles are used to measure partial passes."
VehiclePartialPassMeasurement.MEAN_ARGUMENT_OF_LATITUDE.__doc__ = "By Mean Argument of Latitude: passes are measured as the difference in the mean argument of latitude at the current time and that at the start of the pass break divided by 2 pi (argument of latitude = mean anomaly plus argument of perigee)."
VehiclePartialPassMeasurement.TIME.__doc__ = "By Time: time is used to measure partial passes."

agcls.AgTypeNameMap["VehiclePartialPassMeasurement"] = VehiclePartialPassMeasurement

class VehicleCoordinateSystem(IntEnum):
    """Coordinate system used for measurement of latitude and longitude."""

    CENTRAL_BODY_FIXED = 0
    """Use a Central Body Fixed coordinate system."""
    INERTIAL = 1
    """Use an Inertial coordinate system."""
    TRUE_OF_DATE = 2
    """Use an True Of Date coordinate system."""
    TRUE_OF_EPOCH = 3
    """Use an True Of Epoch coordinate system."""

VehicleCoordinateSystem.CENTRAL_BODY_FIXED.__doc__ = "Use a Central Body Fixed coordinate system."
VehicleCoordinateSystem.INERTIAL.__doc__ = "Use an Inertial coordinate system."
VehicleCoordinateSystem.TRUE_OF_DATE.__doc__ = "Use an True Of Date coordinate system."
VehicleCoordinateSystem.TRUE_OF_EPOCH.__doc__ = "Use an True Of Epoch coordinate system."

agcls.AgTypeNameMap["VehicleCoordinateSystem"] = VehicleCoordinateSystem

class VehicleBreakAngleType(IntEnum):
    """Definition options for setting pass breaks:."""

    UNKNOWN = -1
    """Represents a type of break angle not supported by the Object Model."""
    BY_LATITUDE = 0
    """Latitude: the Latitude crossing at which a new pass begins. Recommended for non-equatorial orbits. A latitude of 0 deg for an inclined orbit coincides with the ascending or descending node."""
    BY_LONGITUDE = 1
    """Longitude: the Longitude crossing at which a new pass will begin. Not suitable for polar orbits."""

VehicleBreakAngleType.UNKNOWN.__doc__ = "Represents a type of break angle not supported by the Object Model."
VehicleBreakAngleType.BY_LATITUDE.__doc__ = "Latitude: the Latitude crossing at which a new pass begins. Recommended for non-equatorial orbits. A latitude of 0 deg for an inclined orbit coincides with the ascending or descending node."
VehicleBreakAngleType.BY_LONGITUDE.__doc__ = "Longitude: the Longitude crossing at which a new pass will begin. Not suitable for polar orbits."

agcls.AgTypeNameMap["VehicleBreakAngleType"] = VehicleBreakAngleType

class VehicleDirection(IntEnum):
    """Direction of latitude crossing at the beginning of a pass."""

    ASCENDING = 0
    """Ascending: crossing the specified latitude from south to north."""
    DESCENDING = 1
    """Descending: crossing the specified latitude from north to south."""

VehicleDirection.ASCENDING.__doc__ = "Ascending: crossing the specified latitude from south to north."
VehicleDirection.DESCENDING.__doc__ = "Descending: crossing the specified latitude from north to south."

agcls.AgTypeNameMap["VehicleDirection"] = VehicleDirection

class Graphics3DLocation(IntEnum):
    """Location options for the display of textual data in the 3D Graphics window."""

    WINDOW_3D = 0
    """Display in the 3D window."""
    DISPLAY_AREA = 1
    """Display in the data display area."""
    OFFSET_FROM_OBJECT = 2
    """Display at a specified offset from a selected object."""
    OFFSET_FROM_ACCESS_OBJECT = 3
    """Display at a specified offset from the access object."""

Graphics3DLocation.WINDOW_3D.__doc__ = "Display in the 3D window."
Graphics3DLocation.DISPLAY_AREA.__doc__ = "Display in the data display area."
Graphics3DLocation.OFFSET_FROM_OBJECT.__doc__ = "Display at a specified offset from a selected object."
Graphics3DLocation.OFFSET_FROM_ACCESS_OBJECT.__doc__ = "Display at a specified offset from the access object."

agcls.AgTypeNameMap["Graphics3DLocation"] = Graphics3DLocation

class Graphics3DXOrigin(IntEnum):
    """X origin options for positioning data display."""

    X_ORIGIN_LEFT = 0
    """X position offset from the left."""
    X_ORIGIN_RIGHT = 1
    """X position offset from the right."""

Graphics3DXOrigin.X_ORIGIN_LEFT.__doc__ = "X position offset from the left."
Graphics3DXOrigin.X_ORIGIN_RIGHT.__doc__ = "X position offset from the right."

agcls.AgTypeNameMap["Graphics3DXOrigin"] = Graphics3DXOrigin

class Graphics3DYOrigin(IntEnum):
    """Y origin options for positioning data display."""

    Y_ORIGIN_BOTTOM = 0
    """Y position offset from the bottom."""
    Y_ORIGIN_TOP = 1
    """Y position offset from the top."""

Graphics3DYOrigin.Y_ORIGIN_BOTTOM.__doc__ = "Y position offset from the bottom."
Graphics3DYOrigin.Y_ORIGIN_TOP.__doc__ = "Y position offset from the top."

agcls.AgTypeNameMap["Graphics3DYOrigin"] = Graphics3DYOrigin

class Graphics3DFontSize(IntEnum):
    """Font size for data display."""

    LARGE = 0
    """Large font."""
    MEDIUM = 1
    """Medium font."""
    SMALL = 2
    """Small font."""

Graphics3DFontSize.LARGE.__doc__ = "Large font."
Graphics3DFontSize.MEDIUM.__doc__ = "Medium font."
Graphics3DFontSize.SMALL.__doc__ = "Small font."

agcls.AgTypeNameMap["Graphics3DFontSize"] = Graphics3DFontSize

class AircraftWGS84WarningType(IntEnum):
    """Display mode options for aircraft mission modeler WGS84 warning."""

    ALWAYS = 0x0
    """Always display warning."""
    ONLY_ONCE = 0x1
    """Only display the warning once."""
    NEVER = 0x2
    """Never display the warning."""

AircraftWGS84WarningType.ALWAYS.__doc__ = "Always display warning."
AircraftWGS84WarningType.ONLY_ONCE.__doc__ = "Only display the warning once."
AircraftWGS84WarningType.NEVER.__doc__ = "Never display the warning."

agcls.AgTypeNameMap["AircraftWGS84WarningType"] = AircraftWGS84WarningType

class SurfaceReference(IntEnum):
    """Options for surface reference of earth globes."""

    WGS84_ELLIPSOID = 0x0
    """WGS84 Ellipsoid."""
    MEAN_SEA_LEVEL = 0x1
    """Mean Sea Level."""

SurfaceReference.WGS84_ELLIPSOID.__doc__ = "WGS84 Ellipsoid."
SurfaceReference.MEAN_SEA_LEVEL.__doc__ = "Mean Sea Level."

agcls.AgTypeNameMap["SurfaceReference"] = SurfaceReference

class Graphics3DFormat(IntEnum):
    """Font format for data display."""

    HORIZONTAL = 0
    """Horizontal layout."""
    NO_LABELS = 1
    """No label display."""
    VERTICAL = 2
    """Vertical layout."""

Graphics3DFormat.HORIZONTAL.__doc__ = "Horizontal layout."
Graphics3DFormat.NO_LABELS.__doc__ = "No label display."
Graphics3DFormat.VERTICAL.__doc__ = "Vertical layout."

agcls.AgTypeNameMap["Graphics3DFormat"] = Graphics3DFormat

class AttitudeStandardType(IntEnum):
    """AttitudeStandardType tells the user which interface to cast to. eRouteAttitudeStandard -> AttitudeStandardRoute, eTrajectoryAttitudeStandard -> AttitudeStandardTrajectory, eOrbitAttitudeStanard -> IAttitudeStandardOrbit."""

    ROUTE_ATTITUDE_STANDARD = 0
    """Cast to AttitudeStandardRoute interface."""
    TRAJECTORY_ATTITUDE_STANDARD = 1
    """Cast to AttitudeStandardTrajectory interface."""
    ORBIT_ATTITUDE_STANDARD = 2
    """Cast to AttitudeStandardOrbit interface."""

AttitudeStandardType.ROUTE_ATTITUDE_STANDARD.__doc__ = "Cast to AttitudeStandardRoute interface."
AttitudeStandardType.TRAJECTORY_ATTITUDE_STANDARD.__doc__ = "Cast to AttitudeStandardTrajectory interface."
AttitudeStandardType.ORBIT_ATTITUDE_STANDARD.__doc__ = "Cast to AttitudeStandardOrbit interface."

agcls.AgTypeNameMap["AttitudeStandardType"] = AttitudeStandardType

class VehicleAttitude(IntEnum):
    """Available attitude types."""

    UNKNOWN = -1
    """Unsupported attitude option."""
    REAL_TIME = 1
    """Real-time: define the vehicle's attitude profile using near-real time attitude data supplied via Connect."""
    STANDARD = 2
    """Standard: use a basic, targeted or external attitude profile."""

VehicleAttitude.UNKNOWN.__doc__ = "Unsupported attitude option."
VehicleAttitude.REAL_TIME.__doc__ = "Real-time: define the vehicle's attitude profile using near-real time attitude data supplied via Connect."
VehicleAttitude.STANDARD.__doc__ = "Standard: use a basic, targeted or external attitude profile."

agcls.AgTypeNameMap["VehicleAttitude"] = VehicleAttitude

class AttitudeProfile(IntEnum):
    """Predefined attitude profiles."""

    UNKNOWN = -1
    """Non-supported profile."""
    ALIGNED_AND_CONSTRAINED = 0
    """Aligned and Constrained attitude profile."""
    CENTRAL_BODY_FIXED = 1
    """Central Body Fixed attitude profile."""
    FIXED_VELOCITY_ALIGNMENT_WITH_NADIR_CONSTRAINT = 2
    """ECF Velocity Alignment with Nadir Constraint attitude profile."""
    FIXED_VELOCITY_ALIGNMENT_WITH_RADIAL_CONSTRAINT = 3
    """ECF Velocity Alignment with Radial Constraint attitude profile."""
    INERTIAL_VELOCITY_ALIGNMENT_WITH_SUN_CONSTRAINT = 4
    """ECI Velocity Alignment with Sun Constraint attitude profile."""
    INERTIAL_VELOCITY_ALIGNMENT_WITH_NADIR_CONSTRAINT = 5
    """ECI Velocity Alignment with Nadir Constraint attitude profile."""
    FIXED_IN_AXES = 6
    """Fixed in Axes attitude profile."""
    INERTIALLY_FIXED = 7
    """Inertially Fixed attitude profile."""
    NADIR_ALIGNMENT_WITH_FIXED_VELOCITY_CONSTRAINT = 8
    """Nadir Alignment with ECF Velocity Constraint attitude profile."""
    NADIR_ALIGNMENT_WITH_INERTIAL_VELOCITY_CONSTRAINT = 9
    """Nadir Alignment with ECI Velocity Constraint attitude profile."""
    NADIR_ALIGNMENT_WITH_SUN_CONSTRAINT = 10
    """Nadir Alignment with Sun Constraint attitude profile."""
    NADIR_ALIGNMENT_WITH_ORBIT_NORMAL_CONSTRAINT = 11
    """Nadir Alignment with Orbit Normal Constraint attitude profile."""
    PRECESSING_SPIN = 12
    """Precessing Spin attitude profile."""
    SPIN_ALIGNED = 13
    """Spin Aligned attitude profile."""
    SPIN_ABOUT_SUN_VECTOR = 14
    """Spin about Sun Vector attitude profile."""
    SPIN_ABOUT_NADIR = 15
    """Spin about Nadir attitude profile."""
    SPINNING = 16
    """Spinning attitude profile."""
    SUN_ALIGNMENT_OCCULTATION_NORMAL_CONSTRAINT = 17
    """Sun Alignmnent Occultation Normal Constraint attitude profile."""
    SUN_ALIGNMENT_WITH_INERTIAL_Z_AXIS_CONSTRAINT = 18
    """Sun Alignment with ECI Z Axis Constraint attitude profile."""
    SUN_ALIGNMENT_WITH_Z_IN_ORBIT_PLANE = 19
    """Sun Alignment with Z in Orbit Plane attitude profile."""
    SUN_ALIGNMENT_WITH_ECLIPTIC_NORMAL_CONSTRAINT = 20
    """Sun Alignment with Ecliptic Normal Constraint attitude profile."""
    SUN_ALIGNMENT_WITH_NADIR_CONSTRAINT = 21
    """Sun Alignment with Nadir Constraint attitude profile."""
    XPOP_INERTIAL_ATTITUDE = 22
    """XPOP Inertial Attitude attitude profile."""
    YAW_TO_NADIR = 23
    """Yaw to Nadir attitude profile."""
    COORDINATED_TURN = 24
    """Coordinated Turn attitude profile."""
    GPS = 27
    """GPS attitude profile."""
    AVIATOR = 28
    """Aviator attitude profile."""

AttitudeProfile.UNKNOWN.__doc__ = "Non-supported profile."
AttitudeProfile.ALIGNED_AND_CONSTRAINED.__doc__ = "Aligned and Constrained attitude profile."
AttitudeProfile.CENTRAL_BODY_FIXED.__doc__ = "Central Body Fixed attitude profile."
AttitudeProfile.FIXED_VELOCITY_ALIGNMENT_WITH_NADIR_CONSTRAINT.__doc__ = "ECF Velocity Alignment with Nadir Constraint attitude profile."
AttitudeProfile.FIXED_VELOCITY_ALIGNMENT_WITH_RADIAL_CONSTRAINT.__doc__ = "ECF Velocity Alignment with Radial Constraint attitude profile."
AttitudeProfile.INERTIAL_VELOCITY_ALIGNMENT_WITH_SUN_CONSTRAINT.__doc__ = "ECI Velocity Alignment with Sun Constraint attitude profile."
AttitudeProfile.INERTIAL_VELOCITY_ALIGNMENT_WITH_NADIR_CONSTRAINT.__doc__ = "ECI Velocity Alignment with Nadir Constraint attitude profile."
AttitudeProfile.FIXED_IN_AXES.__doc__ = "Fixed in Axes attitude profile."
AttitudeProfile.INERTIALLY_FIXED.__doc__ = "Inertially Fixed attitude profile."
AttitudeProfile.NADIR_ALIGNMENT_WITH_FIXED_VELOCITY_CONSTRAINT.__doc__ = "Nadir Alignment with ECF Velocity Constraint attitude profile."
AttitudeProfile.NADIR_ALIGNMENT_WITH_INERTIAL_VELOCITY_CONSTRAINT.__doc__ = "Nadir Alignment with ECI Velocity Constraint attitude profile."
AttitudeProfile.NADIR_ALIGNMENT_WITH_SUN_CONSTRAINT.__doc__ = "Nadir Alignment with Sun Constraint attitude profile."
AttitudeProfile.NADIR_ALIGNMENT_WITH_ORBIT_NORMAL_CONSTRAINT.__doc__ = "Nadir Alignment with Orbit Normal Constraint attitude profile."
AttitudeProfile.PRECESSING_SPIN.__doc__ = "Precessing Spin attitude profile."
AttitudeProfile.SPIN_ALIGNED.__doc__ = "Spin Aligned attitude profile."
AttitudeProfile.SPIN_ABOUT_SUN_VECTOR.__doc__ = "Spin about Sun Vector attitude profile."
AttitudeProfile.SPIN_ABOUT_NADIR.__doc__ = "Spin about Nadir attitude profile."
AttitudeProfile.SPINNING.__doc__ = "Spinning attitude profile."
AttitudeProfile.SUN_ALIGNMENT_OCCULTATION_NORMAL_CONSTRAINT.__doc__ = "Sun Alignmnent Occultation Normal Constraint attitude profile."
AttitudeProfile.SUN_ALIGNMENT_WITH_INERTIAL_Z_AXIS_CONSTRAINT.__doc__ = "Sun Alignment with ECI Z Axis Constraint attitude profile."
AttitudeProfile.SUN_ALIGNMENT_WITH_Z_IN_ORBIT_PLANE.__doc__ = "Sun Alignment with Z in Orbit Plane attitude profile."
AttitudeProfile.SUN_ALIGNMENT_WITH_ECLIPTIC_NORMAL_CONSTRAINT.__doc__ = "Sun Alignment with Ecliptic Normal Constraint attitude profile."
AttitudeProfile.SUN_ALIGNMENT_WITH_NADIR_CONSTRAINT.__doc__ = "Sun Alignment with Nadir Constraint attitude profile."
AttitudeProfile.XPOP_INERTIAL_ATTITUDE.__doc__ = "XPOP Inertial Attitude attitude profile."
AttitudeProfile.YAW_TO_NADIR.__doc__ = "Yaw to Nadir attitude profile."
AttitudeProfile.COORDINATED_TURN.__doc__ = "Coordinated Turn attitude profile."
AttitudeProfile.GPS.__doc__ = "GPS attitude profile."
AttitudeProfile.AVIATOR.__doc__ = "Aviator attitude profile."

agcls.AgTypeNameMap["AttitudeProfile"] = AttitudeProfile

class VehicleLookAheadMethod(IntEnum):
    """Look ahead duration methods."""

    EXTRAPOLATE = 0
    """Extrapolate: STK uses the last two history points to extrapolate attitude into the Look Ahead window. This method is best if attitude changes slightly over time."""
    HOLD = 1
    """Hold: Attitude remains the same from the last data point. This method is best when fixed attitude is more reliable than an approximate value."""

VehicleLookAheadMethod.EXTRAPOLATE.__doc__ = "Extrapolate: STK uses the last two history points to extrapolate attitude into the Look Ahead window. This method is best if attitude changes slightly over time."
VehicleLookAheadMethod.HOLD.__doc__ = "Hold: Attitude remains the same from the last data point. This method is best when fixed attitude is more reliable than an approximate value."

agcls.AgTypeNameMap["VehicleLookAheadMethod"] = VehicleLookAheadMethod

class VehicleGraphics3DBPlaneTargetPointPosition(IntEnum):
    """Values of the enumeration represent polymorphic object types."""

    CARTESIAN = 0
    """Cartesian Position."""
    POLAR = 1
    """Polar Position."""

VehicleGraphics3DBPlaneTargetPointPosition.CARTESIAN.__doc__ = "Cartesian Position."
VehicleGraphics3DBPlaneTargetPointPosition.POLAR.__doc__ = "Polar Position."

agcls.AgTypeNameMap["VehicleGraphics3DBPlaneTargetPointPosition"] = VehicleGraphics3DBPlaneTargetPointPosition

class SensorAltitudeCrossingSideType(IntEnum):
    """Options for specifying which crossings are computed and displayed in the 2D Graphics window."""

    UNKNOWN = -1
    """Unknown."""
    BOTH_SIDES = 0
    """Both Sides - if the Direction option for altitude crossing permits front and back crossings, both are computed and displayed in the 2D Graphics window."""
    ONE_SIDE = 1
    """One Side - only the first crossing that satisfies the Direction option for altitude crossing is computed and displayed in the 2D Graphics window."""

SensorAltitudeCrossingSideType.UNKNOWN.__doc__ = "Unknown."
SensorAltitudeCrossingSideType.BOTH_SIDES.__doc__ = "Both Sides - if the Direction option for altitude crossing permits front and back crossings, both are computed and displayed in the 2D Graphics window."
SensorAltitudeCrossingSideType.ONE_SIDE.__doc__ = "One Side - only the first crossing that satisfies the Direction option for altitude crossing is computed and displayed in the 2D Graphics window."

agcls.AgTypeNameMap["SensorAltitudeCrossingSideType"] = SensorAltitudeCrossingSideType

class SensorAltitudeCrossingDirection(IntEnum):
    """Options for specifying the direction in which the sensor's field of view crosses the specified altitude."""

    UNKNOWN = -1
    """Unknown."""
    EITHER = 0
    """Either - Crossing can occur in either direction."""
    INSIDE_OUT = 1
    """Inside Out - Crossing occurs from lower altitudes to higher altitudes."""
    OUTSIDE_IN = 2
    """Outside In - Crossing occurs from higher altitudes to lower altitudes."""

SensorAltitudeCrossingDirection.UNKNOWN.__doc__ = "Unknown."
SensorAltitudeCrossingDirection.EITHER.__doc__ = "Either - Crossing can occur in either direction."
SensorAltitudeCrossingDirection.INSIDE_OUT.__doc__ = "Inside Out - Crossing occurs from lower altitudes to higher altitudes."
SensorAltitudeCrossingDirection.OUTSIDE_IN.__doc__ = "Outside In - Crossing occurs from higher altitudes to lower altitudes."

agcls.AgTypeNameMap["SensorAltitudeCrossingDirection"] = SensorAltitudeCrossingDirection

class SensorGraphics3DInheritFrom2D(IntEnum):
    """Options for how projection distances that are computed based on 2D Graphics projection settings are displayed in the 3D Graphics window."""

    UNKNOWN = -1
    """Unknown."""
    NO = 0
    """Crossings and distances defined for the 2D Graphics window are ignored in the 3D Graphics window."""
    YES = 1
    """All crossings and distances defined for the 2D Graphics window are displayed in the 3D Graphics window."""
    EXTENT_ONLY = 2
    """Only the highest altitude/farthest range crossings and distances defined for the 2D Graphics window are displayed in the 3D Graphics window."""

SensorGraphics3DInheritFrom2D.UNKNOWN.__doc__ = "Unknown."
SensorGraphics3DInheritFrom2D.NO.__doc__ = "Crossings and distances defined for the 2D Graphics window are ignored in the 3D Graphics window."
SensorGraphics3DInheritFrom2D.YES.__doc__ = "All crossings and distances defined for the 2D Graphics window are displayed in the 3D Graphics window."
SensorGraphics3DInheritFrom2D.EXTENT_ONLY.__doc__ = "Only the highest altitude/farthest range crossings and distances defined for the 2D Graphics window are displayed in the 3D Graphics window."

agcls.AgTypeNameMap["SensorGraphics3DInheritFrom2D"] = SensorGraphics3DInheritFrom2D

class SensorGraphics3DVisualAppearance(IntEnum):
    """Options optimizing the visual appearance of projections."""

    UNKNOWN = -1
    """Unsupported visual appearance option."""
    ORIGIN = 0
    """Optimize at origin."""
    CENTER = 1
    """Optimize at center."""
    END = 2
    """Optimize at end."""

SensorGraphics3DVisualAppearance.UNKNOWN.__doc__ = "Unsupported visual appearance option."
SensorGraphics3DVisualAppearance.ORIGIN.__doc__ = "Optimize at origin."
SensorGraphics3DVisualAppearance.CENTER.__doc__ = "Optimize at center."
SensorGraphics3DVisualAppearance.END.__doc__ = "Optimize at end."

agcls.AgTypeNameMap["SensorGraphics3DVisualAppearance"] = SensorGraphics3DVisualAppearance

class ChainTimePeriodType(IntEnum):
    """Compute Time Period Type."""

    UNKNOWN = -1
    """Unsupported time period type."""
    OBJECT_TIME_PERIODS = 0
    """The Time Period that you set for objects in the chain is used to compute access. For facilities, places and targets, the scenario Time Period is used."""
    SCENARIO_TIME_PERIOD = 1
    """The Time Period that you set for the scenario is used to compute access."""
    SPECIFIED_TIME_PERIOD = 2
    """Specify the Start and Stop time for access computation."""

ChainTimePeriodType.UNKNOWN.__doc__ = "Unsupported time period type."
ChainTimePeriodType.OBJECT_TIME_PERIODS.__doc__ = "The Time Period that you set for objects in the chain is used to compute access. For facilities, places and targets, the scenario Time Period is used."
ChainTimePeriodType.SCENARIO_TIME_PERIOD.__doc__ = "The Time Period that you set for the scenario is used to compute access."
ChainTimePeriodType.SPECIFIED_TIME_PERIOD.__doc__ = "Specify the Start and Stop time for access computation."

agcls.AgTypeNameMap["ChainTimePeriodType"] = ChainTimePeriodType

class ChainConstellationConstraintsMode(IntEnum):
    """Constellation Constraints Mode."""

    UNKNOWN = -1
    """Unsupported Constellation Constraints mode."""
    STRANDS = 0
    """The Constellation Constraints mode is set to apply constraints across valid strands."""
    OBJECTS = 1
    """The Constellation Constraints mode is set to apply constraints per instance."""

ChainConstellationConstraintsMode.UNKNOWN.__doc__ = "Unsupported Constellation Constraints mode."
ChainConstellationConstraintsMode.STRANDS.__doc__ = "The Constellation Constraints mode is set to apply constraints across valid strands."
ChainConstellationConstraintsMode.OBJECTS.__doc__ = "The Constellation Constraints mode is set to apply constraints per instance."

agcls.AgTypeNameMap["ChainConstellationConstraintsMode"] = ChainConstellationConstraintsMode

class ChainCoverageAssetMode(IntEnum):
    """Chain Cov Asset Mode."""

    UNKNOWN = -1
    """Unsupported Chain Cov Asset mode."""
    APPEND = 0
    """The Chain Cov Asset mode is set to append the Coverage grid instance to the Chain."""
    UPDATE = 1
    """The Chain Cov Asset mode is set to update the Coverage grid instance if the object is inside the Chain."""

ChainCoverageAssetMode.UNKNOWN.__doc__ = "Unsupported Chain Cov Asset mode."
ChainCoverageAssetMode.APPEND.__doc__ = "The Chain Cov Asset mode is set to append the Coverage grid instance to the Chain."
ChainCoverageAssetMode.UPDATE.__doc__ = "The Chain Cov Asset mode is set to update the Coverage grid instance if the object is inside the Chain."

agcls.AgTypeNameMap["ChainCoverageAssetMode"] = ChainCoverageAssetMode

class ChainParentPlatformRestriction(IntEnum):
    """Options for a chain's From and To Parent Platform Restriction."""

    UNKNOWN = -1
    """Unsupported Chain parent platform restriction."""
    NONE = 0
    """No restriction on parent platform relationship."""
    SAME = 1
    """The From and To objects must have a common parent platform."""
    DIFFERENT = 2
    """The From and To objects must have different parent platform."""

ChainParentPlatformRestriction.UNKNOWN.__doc__ = "Unsupported Chain parent platform restriction."
ChainParentPlatformRestriction.NONE.__doc__ = "No restriction on parent platform relationship."
ChainParentPlatformRestriction.SAME.__doc__ = "The From and To objects must have a common parent platform."
ChainParentPlatformRestriction.DIFFERENT.__doc__ = "The From and To objects must have different parent platform."

agcls.AgTypeNameMap["ChainParentPlatformRestriction"] = ChainParentPlatformRestriction

class ChainOptimalStrandMetricType(IntEnum):
    """Chain optimal strand metric type."""

    UNKNOWN = -1
    """Unsupported Chain optimal strand metric type."""
    STRAND_METRIC_DISTANCE = 0
    """Chain optimal strand distance metric."""
    STRAND_METRIC_PROCESSING_DELAY = 1
    """Chain optimal strand processing delay metric."""
    STRAND_METRIC_CALCULATION_SCALAR = 2
    """Chain optimal strand calculation scalar metric."""
    STRAND_METRIC_DURATION = 3
    """Chain optimal strand duration metric."""

ChainOptimalStrandMetricType.UNKNOWN.__doc__ = "Unsupported Chain optimal strand metric type."
ChainOptimalStrandMetricType.STRAND_METRIC_DISTANCE.__doc__ = "Chain optimal strand distance metric."
ChainOptimalStrandMetricType.STRAND_METRIC_PROCESSING_DELAY.__doc__ = "Chain optimal strand processing delay metric."
ChainOptimalStrandMetricType.STRAND_METRIC_CALCULATION_SCALAR.__doc__ = "Chain optimal strand calculation scalar metric."
ChainOptimalStrandMetricType.STRAND_METRIC_DURATION.__doc__ = "Chain optimal strand duration metric."

agcls.AgTypeNameMap["ChainOptimalStrandMetricType"] = ChainOptimalStrandMetricType

class ChainOptimalStrandCalculationScalarMetricType(IntEnum):
    """Chain optimal strand calculation scalar type."""

    UNKNOWN = -1
    """Unsupported Chain optimal strand calculation scalar metric type."""
    STRAND_CALCULATION_SCALAR_METRIC_FILE = 0
    """Chain optimal strand calculation scalar metric using file."""
    STRAND_CALCULATION_SCALAR_METRIC_NAME = 1
    """Chain optimal strand calculation scalar metric using component name."""

ChainOptimalStrandCalculationScalarMetricType.UNKNOWN.__doc__ = "Unsupported Chain optimal strand calculation scalar metric type."
ChainOptimalStrandCalculationScalarMetricType.STRAND_CALCULATION_SCALAR_METRIC_FILE.__doc__ = "Chain optimal strand calculation scalar metric using file."
ChainOptimalStrandCalculationScalarMetricType.STRAND_CALCULATION_SCALAR_METRIC_NAME.__doc__ = "Chain optimal strand calculation scalar metric using component name."

agcls.AgTypeNameMap["ChainOptimalStrandCalculationScalarMetricType"] = ChainOptimalStrandCalculationScalarMetricType

class ChainOptimalStrandLinkCompareType(IntEnum):
    """Chain optimal strand link comparison type."""

    UNKNOWN = -1
    """Unsupported Chain optimal strand link comparison type."""
    STRAND_LINK_COMPARE_TYPE_MIN = 0
    """Chain optimal strand comparison type, use min value of metric across all links in a strand."""
    STRAND_LINK_COMPARE_TYPE_MAX = 1
    """Chain optimal strand comparison type, use max value of metric across all links in a strand."""
    STRAND_LINK_COMPARE_TYPE_SUM = 2
    """Chain optimal strand comparison type, use sum of metric values across all links in a strand."""

ChainOptimalStrandLinkCompareType.UNKNOWN.__doc__ = "Unsupported Chain optimal strand link comparison type."
ChainOptimalStrandLinkCompareType.STRAND_LINK_COMPARE_TYPE_MIN.__doc__ = "Chain optimal strand comparison type, use min value of metric across all links in a strand."
ChainOptimalStrandLinkCompareType.STRAND_LINK_COMPARE_TYPE_MAX.__doc__ = "Chain optimal strand comparison type, use max value of metric across all links in a strand."
ChainOptimalStrandLinkCompareType.STRAND_LINK_COMPARE_TYPE_SUM.__doc__ = "Chain optimal strand comparison type, use sum of metric values across all links in a strand."

agcls.AgTypeNameMap["ChainOptimalStrandLinkCompareType"] = ChainOptimalStrandLinkCompareType

class ChainOptimalStrandCompareStrandsType(IntEnum):
    """Chain optimal strand link comparison type."""

    UNKNOWN = -1
    """Unsupported Chain optimal strand comparison type used to compare strands."""
    STRAND_COMPARE_TYPE_MIN = 0
    """Chain optimal strand comparison type, when comparing strands to determine best strand, use min value of metric between strands."""
    STRAND_COMPARE_TYPE_MAX = 1
    """Chain optimal strand comparison type, when comparing strands to determine best strand, use max value of metric between strands."""

ChainOptimalStrandCompareStrandsType.UNKNOWN.__doc__ = "Unsupported Chain optimal strand comparison type used to compare strands."
ChainOptimalStrandCompareStrandsType.STRAND_COMPARE_TYPE_MIN.__doc__ = "Chain optimal strand comparison type, when comparing strands to determine best strand, use min value of metric between strands."
ChainOptimalStrandCompareStrandsType.STRAND_COMPARE_TYPE_MAX.__doc__ = "Chain optimal strand comparison type, when comparing strands to determine best strand, use max value of metric between strands."

agcls.AgTypeNameMap["ChainOptimalStrandCompareStrandsType"] = ChainOptimalStrandCompareStrandsType

class DataSaveMode(IntEnum):
    """Access Save Mode."""

    UNKNOWN = -1
    """Unsupported mode."""
    DONT_SAVE_ACCESSES = 0
    """Access computations are not saved with the chain."""
    DONT_SAVE_COMPUTE_ON_LOAD = 1
    """Access computations are not saved with the chain, but they are recalculated each time that the chain is opened in STK."""
    SAVE_ACCESSES = 2
    """Access computations are saved with the chain."""

DataSaveMode.UNKNOWN.__doc__ = "Unsupported mode."
DataSaveMode.DONT_SAVE_ACCESSES.__doc__ = "Access computations are not saved with the chain."
DataSaveMode.DONT_SAVE_COMPUTE_ON_LOAD.__doc__ = "Access computations are not saved with the chain, but they are recalculated each time that the chain is opened in STK."
DataSaveMode.SAVE_ACCESSES.__doc__ = "Access computations are saved with the chain."

agcls.AgTypeNameMap["DataSaveMode"] = DataSaveMode

class CoverageBounds(IntEnum):
    """Coverage bounds options: values of the enumeration represent polymorphic object types."""

    CUSTOM_REGIONS = 0
    """Create a grid within regions specified by a combination of user-selected area targets, region list files (.rl) and/or ArcView shapefiles (.shp)."""
    GLOBAL = 1
    """Create a grid that covers the entire globe."""
    LATITUDE = 2
    """Create a grid between the user-specified Minimum and Maximum Latitude boundaries."""
    LATITUDE_LINE = 3
    """Create a set of points along a single latitude line."""
    LONGITUDE_LINE = 4
    """Create a set of points along a single meridian."""
    CUSTOM_BOUNDARY = 5
    """Custom boundary coverage."""
    LATITUDE_LONGITUDE_REGION = 6
    """Create a lat-lon region between the user-specified Minimum and Maximum Latitude/Longitude boundaries."""

CoverageBounds.CUSTOM_REGIONS.__doc__ = "Create a grid within regions specified by a combination of user-selected area targets, region list files (.rl) and/or ArcView shapefiles (.shp)."
CoverageBounds.GLOBAL.__doc__ = "Create a grid that covers the entire globe."
CoverageBounds.LATITUDE.__doc__ = "Create a grid between the user-specified Minimum and Maximum Latitude boundaries."
CoverageBounds.LATITUDE_LINE.__doc__ = "Create a set of points along a single latitude line."
CoverageBounds.LONGITUDE_LINE.__doc__ = "Create a set of points along a single meridian."
CoverageBounds.CUSTOM_BOUNDARY.__doc__ = "Custom boundary coverage."
CoverageBounds.LATITUDE_LONGITUDE_REGION.__doc__ = "Create a lat-lon region between the user-specified Minimum and Maximum Latitude/Longitude boundaries."

agcls.AgTypeNameMap["CoverageBounds"] = CoverageBounds

class CoveragePointLocationMethod(IntEnum):
    """Point location method."""

    UNKNOWN = -1
    """Unknown method."""
    COMPUTE_BASED_ON_RESOLUTION = 0
    """Compute point location on the basis of resolution."""
    SPECIFY_CUSTOM_LOCATIONS = 1
    """Specify custom locations using point files."""

CoveragePointLocationMethod.UNKNOWN.__doc__ = "Unknown method."
CoveragePointLocationMethod.COMPUTE_BASED_ON_RESOLUTION.__doc__ = "Compute point location on the basis of resolution."
CoveragePointLocationMethod.SPECIFY_CUSTOM_LOCATIONS.__doc__ = "Specify custom locations using point files."

agcls.AgTypeNameMap["CoveragePointLocationMethod"] = CoveragePointLocationMethod

class CoveragePointAltitudeMethod(IntEnum):
    """Custom point altitude method."""

    UNKNOWN = -1
    """Unknown method."""
    FILE_VALUES = 0
    """Use the altitude values in the point file."""
    OVERRIDE = 1
    """Override the point altitude with the altitude at a point on terrain."""

CoveragePointAltitudeMethod.UNKNOWN.__doc__ = "Unknown method."
CoveragePointAltitudeMethod.FILE_VALUES.__doc__ = "Use the altitude values in the point file."
CoveragePointAltitudeMethod.OVERRIDE.__doc__ = "Override the point altitude with the altitude at a point on terrain."

agcls.AgTypeNameMap["CoveragePointAltitudeMethod"] = CoveragePointAltitudeMethod

class CoverageGridClass(IntEnum):
    """Classes of objects that can be used as templates to associate access constraints, basic object properties and, in some cases, altitude with points in the grid."""

    UNKNOWN = -1
    """Unknown template class."""
    AIRCRAFT = 0
    """Aircraft class."""
    FACILITY = 1
    """Facility class."""
    RADAR = 2
    """Radar class."""
    RECEIVER = 3
    """Receiver class."""
    SATELLITE = 4
    """Satellite class."""
    SUBMARINE = 5
    """Submarine class."""
    TARGET = 6
    """Target class."""
    TRANSMITTER = 7
    """Transmitter class."""
    GROUND_VEHICLE = 8
    """GroundVehicle class."""
    SHIP = 9
    """Ship class."""
    PLACE = 10
    """Place class."""
    SENSOR = 11
    """Sensor class."""

CoverageGridClass.UNKNOWN.__doc__ = "Unknown template class."
CoverageGridClass.AIRCRAFT.__doc__ = "Aircraft class."
CoverageGridClass.FACILITY.__doc__ = "Facility class."
CoverageGridClass.RADAR.__doc__ = "Radar class."
CoverageGridClass.RECEIVER.__doc__ = "Receiver class."
CoverageGridClass.SATELLITE.__doc__ = "Satellite class."
CoverageGridClass.SUBMARINE.__doc__ = "Submarine class."
CoverageGridClass.TARGET.__doc__ = "Target class."
CoverageGridClass.TRANSMITTER.__doc__ = "Transmitter class."
CoverageGridClass.GROUND_VEHICLE.__doc__ = "GroundVehicle class."
CoverageGridClass.SHIP.__doc__ = "Ship class."
CoverageGridClass.PLACE.__doc__ = "Place class."
CoverageGridClass.SENSOR.__doc__ = "Sensor class."

agcls.AgTypeNameMap["CoverageGridClass"] = CoverageGridClass

class CoverageAltitudeMethod(IntEnum):
    """Method for specifying the altitude of a grid point."""

    UNKNOWN = -1
    """Unknown altitude method."""
    ABOVE_TERRAIN = 0
    """Altitude above terrain."""
    ABOVE_ELLIPSOID = 1
    """Altitude above the surface."""
    RADIUS = 2
    """Radius from the center of the Earth."""
    ABOVE_MEAN_SEA_LEVEL = 3
    """Altitude above MSL of the surface."""
    DEPTH = 4
    """Depth below the surface."""

CoverageAltitudeMethod.UNKNOWN.__doc__ = "Unknown altitude method."
CoverageAltitudeMethod.ABOVE_TERRAIN.__doc__ = "Altitude above terrain."
CoverageAltitudeMethod.ABOVE_ELLIPSOID.__doc__ = "Altitude above the surface."
CoverageAltitudeMethod.RADIUS.__doc__ = "Radius from the center of the Earth."
CoverageAltitudeMethod.ABOVE_MEAN_SEA_LEVEL.__doc__ = "Altitude above MSL of the surface."
CoverageAltitudeMethod.DEPTH.__doc__ = "Depth below the surface."

agcls.AgTypeNameMap["CoverageAltitudeMethod"] = CoverageAltitudeMethod

class CoverageGroundAltitudeMethod(IntEnum):
    """Method for specifying the ground altitude of a grid point."""

    UNKNOWN = -1
    """Unknown ground altitude method."""
    DEPTH = 0
    """Depth below the surface."""
    ALTITUDE = 1
    """Altitude above the surface."""
    ALTITUDE_AT_TERRAIN = 2
    """Altitude at terrain."""
    ALTITUDE_ABOVE_MEAN_SEA_LEVEL = 3
    """Altitude above MSL of the surface."""
    USE_POINT_ALTITUDE = 4
    """Altitude by point type."""

CoverageGroundAltitudeMethod.UNKNOWN.__doc__ = "Unknown ground altitude method."
CoverageGroundAltitudeMethod.DEPTH.__doc__ = "Depth below the surface."
CoverageGroundAltitudeMethod.ALTITUDE.__doc__ = "Altitude above the surface."
CoverageGroundAltitudeMethod.ALTITUDE_AT_TERRAIN.__doc__ = "Altitude at terrain."
CoverageGroundAltitudeMethod.ALTITUDE_ABOVE_MEAN_SEA_LEVEL.__doc__ = "Altitude above MSL of the surface."
CoverageGroundAltitudeMethod.USE_POINT_ALTITUDE.__doc__ = "Altitude by point type."

agcls.AgTypeNameMap["CoverageGroundAltitudeMethod"] = CoverageGroundAltitudeMethod

class CoverageDataRetention(IntEnum):
    """Data retention options."""

    UNKNOWN = -1
    """Unknown data retention method."""
    ALL_DATA = 0
    """All Data - Retains start and stop times for all accesses in virtual memory."""
    STATIC_DATA_ONLY = 1
    """Static Only - As access is computed for each point, STK also computes the static value for each figure of merit. Raw access data is then deleted to minimize memory usage."""

CoverageDataRetention.UNKNOWN.__doc__ = "Unknown data retention method."
CoverageDataRetention.ALL_DATA.__doc__ = "All Data - Retains start and stop times for all accesses in virtual memory."
CoverageDataRetention.STATIC_DATA_ONLY.__doc__ = "Static Only - As access is computed for each point, STK also computes the static value for each figure of merit. Raw access data is then deleted to minimize memory usage."

agcls.AgTypeNameMap["CoverageDataRetention"] = CoverageDataRetention

class CoverageRegionAccessAccelerationType(IntEnum):
    """Regional acceleration options."""

    UNKNOWN = -1
    """Unknown regional acceleration option."""
    AUTOMATIC = 0
    """Automatic - if selected and the grid altitude is 0 with respect to the defining ellipsoid for the central body, visibility to regions' bounding sets of points is computed and used to limit times for computations to enclosed points."""
    OFF = 1
    """Off - should be selected in certain cases, such as the use of a very small or narrow sensor in conjunction with a very narrow coverage region."""

CoverageRegionAccessAccelerationType.UNKNOWN.__doc__ = "Unknown regional acceleration option."
CoverageRegionAccessAccelerationType.AUTOMATIC.__doc__ = "Automatic - if selected and the grid altitude is 0 with respect to the defining ellipsoid for the central body, visibility to regions' bounding sets of points is computed and used to limit times for computations to enclosed points."
CoverageRegionAccessAccelerationType.OFF.__doc__ = "Off - should be selected in certain cases, such as the use of a very small or narrow sensor in conjunction with a very narrow coverage region."

agcls.AgTypeNameMap["CoverageRegionAccessAccelerationType"] = CoverageRegionAccessAccelerationType

class CoverageResolution(IntEnum):
    """Coverage grid resolution options: values of the enumeration represent polymorphic object types."""

    RESOLUTION_AREA = 0
    """Define the location of grid coordinates by using the specified area to determine a latitude/longitude spacing scheme at the equator."""
    RESOLUTION_DISTANCE = 1
    """Define the location of the grid coordinates by using the specified distance to determine a latitude/longitude spacing scheme at the equator."""
    RESOLUTION_LATITUDE_LONGITUDE = 2
    """Determine the location of grid coordinates by applying a user-specified value at the equator. STK stretches grid points in longitude at higher or lower latitudes in an attempt to preserve the area of the grid point."""

CoverageResolution.RESOLUTION_AREA.__doc__ = "Define the location of grid coordinates by using the specified area to determine a latitude/longitude spacing scheme at the equator."
CoverageResolution.RESOLUTION_DISTANCE.__doc__ = "Define the location of the grid coordinates by using the specified distance to determine a latitude/longitude spacing scheme at the equator."
CoverageResolution.RESOLUTION_LATITUDE_LONGITUDE.__doc__ = "Determine the location of grid coordinates by applying a user-specified value at the equator. STK stretches grid points in longitude at higher or lower latitudes in an attempt to preserve the area of the grid point."

agcls.AgTypeNameMap["CoverageResolution"] = CoverageResolution

class CoverageAssetStatus(IntEnum):
    """Coverage asset status."""

    ACTIVE = 0
    """Coverage asset is active."""
    INACTIVE = 1
    """Coverage asset is inactive."""

CoverageAssetStatus.ACTIVE.__doc__ = "Coverage asset is active."
CoverageAssetStatus.INACTIVE.__doc__ = "Coverage asset is inactive."

agcls.AgTypeNameMap["CoverageAssetStatus"] = CoverageAssetStatus

class CoverageAssetGrouping(IntEnum):
    """Coverage asset grouping options."""

    SEPARATE = 0
    """Assets in a chain are treated separately for access purposes."""
    GROUPED = 1
    """Assets in a chain are treated as a group, and are considered to be a single object for the purpose of counting the number of assets providing simultaneous coverage."""

CoverageAssetGrouping.SEPARATE.__doc__ = "Assets in a chain are treated separately for access purposes."
CoverageAssetGrouping.GROUPED.__doc__ = "Assets in a chain are treated as a group, and are considered to be a single object for the purpose of counting the number of assets providing simultaneous coverage."

agcls.AgTypeNameMap["CoverageAssetGrouping"] = CoverageAssetGrouping

class FigureOfMeritDefinitionType(IntEnum):
    """Figure of Merit types: values of the enumeration represent polymorphic object types."""

    ACCESS_CONSTRAINT = 0
    """Access Constraint Figure of Merit."""
    ACCESS_DURATION = 1
    """Access Duration Figure of Merit."""
    ACCESS_SEPARATION = 2
    """Access Separation Figure of Merit."""
    COVERAGE_TIME = 3
    """Coverage Time Figure of Merit."""
    DILUTION_OF_PRECISION = 4
    """Dilution of Precision Figure of Merit."""
    N_ASSET_COVERAGE = 5
    """N Asset Coverage Figure of Merit."""
    NAVIGATION_ACCURACY = 6
    """Navigation Accuracy Figure of Merit."""
    NUMBER_OF_ACCESSES = 7
    """Number of Accesses Figure of Merit."""
    NUMBER_OF_GAPS = 8
    """Number of Gaps Figure of Merit."""
    RESPONSE_TIME = 9
    """Response Time Figure of Merit."""
    REVISIT_TIME = 10
    """Revisit Time Figure of Merit."""
    SIMPLE_COVERAGE = 11
    """Simple Coverage Figure of Merit."""
    TIME_AVERAGE_GAP = 12
    """Time Average Gap Figure of Merit."""
    SYSTEM_RESPONSE_TIME = 13
    """System Response Time Figure of Merit."""
    AGE_OF_DATA = 14
    """Age of Data Figure of Merit."""
    SCALAR_CALCULATION = 15
    """Scalar Calculation Figure of Merit."""
    SYSTEM_AGE_OF_DATA = 16
    """System Age Of Data Figure of Merit."""

FigureOfMeritDefinitionType.ACCESS_CONSTRAINT.__doc__ = "Access Constraint Figure of Merit."
FigureOfMeritDefinitionType.ACCESS_DURATION.__doc__ = "Access Duration Figure of Merit."
FigureOfMeritDefinitionType.ACCESS_SEPARATION.__doc__ = "Access Separation Figure of Merit."
FigureOfMeritDefinitionType.COVERAGE_TIME.__doc__ = "Coverage Time Figure of Merit."
FigureOfMeritDefinitionType.DILUTION_OF_PRECISION.__doc__ = "Dilution of Precision Figure of Merit."
FigureOfMeritDefinitionType.N_ASSET_COVERAGE.__doc__ = "N Asset Coverage Figure of Merit."
FigureOfMeritDefinitionType.NAVIGATION_ACCURACY.__doc__ = "Navigation Accuracy Figure of Merit."
FigureOfMeritDefinitionType.NUMBER_OF_ACCESSES.__doc__ = "Number of Accesses Figure of Merit."
FigureOfMeritDefinitionType.NUMBER_OF_GAPS.__doc__ = "Number of Gaps Figure of Merit."
FigureOfMeritDefinitionType.RESPONSE_TIME.__doc__ = "Response Time Figure of Merit."
FigureOfMeritDefinitionType.REVISIT_TIME.__doc__ = "Revisit Time Figure of Merit."
FigureOfMeritDefinitionType.SIMPLE_COVERAGE.__doc__ = "Simple Coverage Figure of Merit."
FigureOfMeritDefinitionType.TIME_AVERAGE_GAP.__doc__ = "Time Average Gap Figure of Merit."
FigureOfMeritDefinitionType.SYSTEM_RESPONSE_TIME.__doc__ = "System Response Time Figure of Merit."
FigureOfMeritDefinitionType.AGE_OF_DATA.__doc__ = "Age of Data Figure of Merit."
FigureOfMeritDefinitionType.SCALAR_CALCULATION.__doc__ = "Scalar Calculation Figure of Merit."
FigureOfMeritDefinitionType.SYSTEM_AGE_OF_DATA.__doc__ = "System Age Of Data Figure of Merit."

agcls.AgTypeNameMap["FigureOfMeritDefinitionType"] = FigureOfMeritDefinitionType

class FigureOfMeritSatisfactionType(IntEnum):
    """Satisfaction options: determine whether satisfaction is achieved based on the value of the figure of merit."""

    AT_LEAST = 0
    """The figure of merit is greater than or equal to the threshold."""
    AT_MOST = 1
    """The figure of merit is less than or equal to the threshold."""
    EQUAL_TO = 2
    """The figure of merit is equal to the threshold."""
    GREATER_THAN = 3
    """The figure of merit is greater than the threshold."""
    LESS_THAN = 4
    """The figure of merit is less than the threshold."""

FigureOfMeritSatisfactionType.AT_LEAST.__doc__ = "The figure of merit is greater than or equal to the threshold."
FigureOfMeritSatisfactionType.AT_MOST.__doc__ = "The figure of merit is less than or equal to the threshold."
FigureOfMeritSatisfactionType.EQUAL_TO.__doc__ = "The figure of merit is equal to the threshold."
FigureOfMeritSatisfactionType.GREATER_THAN.__doc__ = "The figure of merit is greater than the threshold."
FigureOfMeritSatisfactionType.LESS_THAN.__doc__ = "The figure of merit is less than the threshold."

agcls.AgTypeNameMap["FigureOfMeritSatisfactionType"] = FigureOfMeritSatisfactionType

class FigureOfMeritConstraintName(IntEnum):
    """Available constraints to use for the Access Constraint Figure of Merit."""

    UNKNOWN = -1
    """Unknown constraint."""
    ALTITUDE = 0
    """Altitude constraint."""
    ANGULAR_RATE = 1
    """Angular Rate constraint."""
    APPARENT_TIME = 2
    """Apparent Time constraint."""
    AZIMUTH_ANGLE = 3
    """Azimuth Angle constraint."""
    AZIMUTH_RATE = 4
    """Azimuth Rate constraint."""
    CENTRAL_BODY_OBSTRUCTION = 5
    """Central Body Obstruction constraint."""
    VECTOR_GEOMETRY_TOOL_ANGLE = 6
    """Angle constraint."""
    VECTOR_MAGNITUDE = 7
    """Vector Magnitude constraint."""
    ELEVATION_ANGLE = 8
    """Elevation Angle constraint."""
    ELEVATION_RATE = 9
    """Elevation Rate constraint."""
    ELEVATION_RISE_SET = 10
    """Elevation Rise Set constraint."""
    GEO_EXCLUSION = 11
    """Geo Exclusion constraint."""
    GROUND_SAMPLE_DISTANCE = 12
    """Ground Sample Distance constraint."""
    HEIGHT_ABOVE_HORIZON = 13
    """Height Above Horizon constraint."""
    LINE_OF_SIGHT_LUNAR_EXCLUSION_ANGLE = 14
    """LOS Lunar Exclusion constraint."""
    LINE_OF_SIGHT_SOLAR_EXCLUSION_ANGLE = 15
    """LOS Sun Exclusion constraint."""
    LUNAR_ELEVATION_ANGLE = 16
    """Lunar Elevation Angle constraint."""
    MATLAB = 17
    """Matlab constraint."""
    OBJECT_EXCLUSION_ANGLE = 18
    """Object Exclusion Angle constraint."""
    PROPAGATION_DELAY = 19
    """Propagation Delay constraint."""
    RANGE = 20
    """Range constraint."""
    RANGE_RATE = 21
    """Range Rate constraint."""
    SAR_AREA_RATE = 22
    """SAR Area Rate constraint."""
    SAR_AZIMUTH_RESOLUTION = 23
    """SAR Azimuth Resolution constraint."""
    SAR_CARRIER_TO_NOISE_RATIO = 24
    """SAR Carrier-to-Noise Ratio constraint."""
    SAR_EXTERNAL_DATA = 25
    """SAR External Data constraint."""
    SAR_INTEGRATION_TIME = 26
    """SAR Integration Time constraint."""
    SAR_PTCR = 27
    """SAR Point-Target-to-Clutter Ratio constraint."""
    SAR_SCR = 28
    """SAR Signal-to-Clutter Ratio constraint."""
    SAR_SNR = 29
    """SAR Signal-to-Noise Ratio constraint."""
    SAR_SIGMA_N = 30
    """SAR Sigma N constraint."""
    SEARCH_TRACK_DWELL_TIME = 31
    """Search-Track Dwell Time constraint."""
    SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION = 32
    """Search-Track Integrated Probability of Detection constraint."""
    SEARCH_TRACK_INTEGRATED_SNR = 33
    """Search-Track Integrated Signal-to-Noise Ratio constraint."""
    SEARCH_TRACK_INTEGRATION_TIME = 34
    """Search-Track Integration Time constraint."""
    SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION = 35
    """Search-Track Single Pulse Probability of Detection constraint."""
    SEARCH_TRACK_SINGLE_PULSE_SNR = 36
    """Search-Track Single Pulse Signal-to-Noise Ratio constraint."""
    SUN_ELEVATION_ANGLE = 37
    """Sun Elevation Angle constraint."""
    TERRAIN_GRAZING_ANGLE = 38
    """Terrain Grazing Angle constraint."""
    ANGLE_TO_ASSET = 39
    """Angle To Asset constraint."""
    LINE_OF_SIGHT = 40
    """Line Of Sight constraint."""
    AZ_EL_MASK = 41
    """Azimuth Elevation Mask constraint."""
    DURATION = 42
    """Duration constraint."""
    GMT = 43
    """Greenwich Mean Time constraint."""
    IMAGE_QUALITY = 44
    """Image Quality constraint."""
    INTERVALS = 45
    """Intervals constraint."""
    LIGHTING = 46
    """Light constraint."""
    LOCAL_TIME = 47
    """Local Time constraint."""
    LINE_OF_SIGHT_CENTRAL_BODY_EXCLUSION = 48
    """Loss Of Signal Central Body Exclusion constraint."""
    POINT_METRIC = 49
    """Coordinate Point Metric constraint."""
    CENTROID_AZIMUTH_ANGLE = 50
    """Do not use this enumeration, as it is deprecated. Centroid Azimuth Angle constraint."""
    CENTROID_RANGE = 51
    """Do not use this enumeration, as it is deprecated. Centroid Range constraint."""
    CENTROID_SUN_ELEVATION_ANGLE = 52
    """Do not use this enumeration, as it is deprecated. Centroid Sun Elevation Angle constraint."""
    COLLECTION_ANGLE = 53
    """Collection Angle constraint."""
    DOPPLER_CONE_ANGLE = 54
    """Doppler Cone Angle constraint."""
    LATITUDE = 55
    """Latitude constraint."""
    SUN_GROUND_ELEVATION_ANGLE = 56
    """Sun Ground Elevation Angle constraint."""
    TERRAIN_MASK = 57
    """Terrain Mask constraint."""
    CROSS_TRACK_RANGE = 59
    """Cross Track Range constraint."""
    IN_TRACK_RANGE = 60
    """In Track Range constraint."""
    SQUINT_ANGLE = 61
    """Squinting Angle constraint."""
    BACKGROUND = 62
    """Background constraint."""
    FOREGROUND = 63
    """Foreground constraint."""
    BETA_ANGLE = 64
    """Beta Angle constraint."""
    AREA_TARGET_CENTROID_ELEVATION_ANGLE = 65
    """Do not use this enumeration, as it is deprecated. Area Target Centroid Elevation Angle constraint."""
    EXCLUSION_ZONE = 66
    """Exclusion Zone constraint."""
    GRAZING_ANGLE = 67
    """Grazing Angle constraint."""
    GRAZING_ALTITUDE = 68
    """Grazing Altitude constraint."""
    GROUND_ELEVATION_ANGLE = 69
    """Ground Elevation Angle constraint."""
    GROUND_TRACK = 70
    """Ground Track constraint."""
    INCLUSION_ZONE = 71
    """Inclusion Zone constraint."""
    SUN_SPECULAR_EXCLUSION = 72
    """Sun Specular Exclusion constraint."""
    DEPTH = 73
    """Deptch constraint."""
    FIELD_OF_VIEW = 74
    """Field Of View constraint."""
    ANGLE_OFF_BORESIGHT = 75
    """Angle Of Boresight constraint."""
    ANGLE_OFF_BORESIGHT_RATE = 76
    """Angle Of Boresight Rate constraint."""
    BORESIGHT_GRAZING_ANGLE = 78
    """Boresight Grazing Angle constraint."""
    BORESIGHT_INTERSECTION_LIGHTING_CONDITION = 79
    """BS Intersection Light Condition constraint."""
    FIELD_OF_VIEW_SUN_SPECULAR_EXCLUSION = 80
    """Field Of View Sun Specular Exclusion constraint."""
    FIELD_OF_VIEW_SUN_SPECULAR_INCLUSION = 81
    """Field Of View Sun Specular Inclusion constraint."""
    HORIZON_CROSSING = 82
    """Horizon Crossing constraint."""
    BORESIGHT_LUNAR_EXCLUSION_ANGLE = 83
    """BS Lunar Exclusion constraint."""
    BORESIGHT_SOLAR_EXCLUSION_ANGLE = 84
    """BS Sun Exclusion constraint."""
    BORESIGHT_CENTRAL_BODY_EXCLUSION_ANGLE = 85
    """BS Centray Body Exclusion constraint."""
    CENTRAL_BODY_OBSTRUCTION_CROSS_INWARD = 86
    """Field Of View Central Body Obstruction Cross In constraint."""
    CENTRAL_BODY_OBSTRUCTION_CROSS_OUTWARD = 87
    """Field Of View Central Body Obstruction Cross Out constraint."""
    CENTRAL_BODY_HORIZON_REFINE = 88
    """Field Of View Central Body Horizon Refine constraint."""
    CENTRAL_BODY_CENTER = 89
    """Field Of View Central Body Center constraint."""
    SENSOR_AZ_EL_MASK = 90
    """Sensor Azimuth Elevation Mask constraint."""
    SENSOR_RANGE_MASK = 91
    """Sensor Range Mask constraint."""
    INFRARED_DETECTION = 92
    """Infrared Detection constraint."""
    RADAR_TRANSMITTER_TARGET_ACCESS = 93
    """Radar Xmt Target Access constraint."""
    RADAR_TRANSMITTER_ACCESS = 94
    """Radar Xmt Access constraint."""
    RADAR_ACCESS = 95
    """Radar Access constraint."""
    BISTATIC_ANGLE = 96
    """Bistatic Angle constraint."""
    NOISE_TEMPERATURE = 97
    """Noise Temperature constraint."""
    SEARCH_TRACK_INTEGRATED_PULSES = 98
    """Search-Track Integrated Pulses constraint."""
    SEARCH_TRACK_MLC_FILTER = 99
    """Search-Track MLC Filter constraint."""
    SEARCH_TRACK_SLC_FILTER = 100
    """Search-Track SLC Filter constraint."""
    SEARCH_TRACK_CLEAR_DOPPLER = 101
    """Search-Track Clear Doppler constraint."""
    SEARCH_TRACK_UNAMBIGUOUS_RANGE = 102
    """Search-Track Unambiguous Range constraint."""
    SEARCH_TRACK_UNAMBIGUOUS_DOPPLER = 103
    """Search-Track Unambiguous Doppler constraint."""
    SEARCH_TRACK_SINGLE_PULSE_SNR_JAMMING = 104
    """Search-Track Single Pulse SNR Jamming constraint."""
    SEARCH_TRACK_SINGLE_PULSE_J_OVER_S = 105
    """Search-Track Single Pulse J/S constraint."""
    SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING = 106
    """Search-Track Single Pulse PDet Jamming constraint."""
    SEARCH_TRACK_INTEGRATED_SNR_JAMMING = 107
    """Search-Track Integrated SNR Jamming constraint."""
    SEARCH_TRACK_INTEGRATED_J_OVER_S = 108
    """Search-Track Integrated J/S constraint."""
    SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING = 109
    """Search-Track Integrated PDet Jamming constraint."""
    SEARCH_TRACK_INTEGRATED_PULSES_JAMMING = 110
    """Search-Track Integrated Pulses Jamming constraint."""
    SEARCH_TRACK_INTEGRATION_TIME_JAMMING = 111
    """Search-Track Integration Time Jamming constraint."""
    SEARCH_TRACK_DWELL_TIME_JAMMING = 112
    """Search-Track Dwell Time Jamming constraint."""
    SEARCH_TRACK_CONSTRAINT_PLUGIN = 113
    """Search-Track Constraint Plugin constraint."""
    SAR_SNR_JAMMING = 114
    """SAR SNR Jamming constraint."""
    SAR_CARRIER_TO_NOISE_RATIO_JAMMING = 115
    """SAR CNR Jamming constraint."""
    SAR_SCR_JAMMING = 116
    """SAR SCR Jamming constraint."""
    SAR_J_OVER_S = 117
    """SAR J/S constraint."""
    SAR_CONSTRAINT_PLUGIN = 118
    """SAR Constraint Plugin constraint."""
    SAR_ORTHOGONAL_POLARIZATION_SNR = 119
    """SAR Orthogonal Polar SNR constraint."""
    SAR_ORTHOGONAL_POLARIZATION_CNR = 120
    """SAR Orthogonal Polar CNR constraint."""
    SAR_ORTHOGONAL_POLARIZATION_SCR = 121
    """SAR Orthogonal Polar SCR constraint."""
    SAR_ORTHOGONAL_POLARIZATION_PTCR = 122
    """SAR Orthogonal Polar PTCR constraint."""
    SAR_ORTHOGONAL_POLARIZATION_SNR_JAMMING = 123
    """SAR Orthogonal Polar SNR Jamming constraint."""
    SAR_ORTHOGONAL_POLARIZATION_CNR_JAMMING = 124
    """SAR Orthogonal Polar CNR Jamming constraint."""
    SAR_ORTHOGONAL_POLARIZATION_SCR_JAMMING = 125
    """SAR Orthogonal Polar SCR Jamming constraint."""
    SAR_ORTHOGONAL_POLARIZATION_J_OVER_S = 126
    """SAR Orthogonal Polar J/S constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR = 127
    """Search-Track Orthogonal Polar Single Pulse SNR constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION = 128
    """Search-Track Orthogonal Polar Single Pulse PDet constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR = 129
    """Search-Track Orthogonal Polar Integrated SNR constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION = 130
    """Search-Track Orthogonal Polar Integrated PDet constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES = 131
    """Search-Track Orthogonal Polar Integrated Pulses constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME = 132
    """Search-Track Orthogonal Polar Integration Time constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME = 133
    """Search-Track Orthogonal Polar Dwell Time constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR_JAMMING = 134
    """Search-Track Orthogonal Polar Single Pulse SNR Jamming constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_J_OVER_S = 135
    """Search-Track Orthogonal Polar Single Pulse J/S constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING = 136
    """Search-Track Orthogonal Polar Single Pulse PDet Jamming constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR_JAMMING = 137
    """Search-Track Orthogonal Polar Integrated SNR Jamming constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_J_OVER_S = 138
    """Search-Track Orthogonal Polar Integrated J/S constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING = 139
    """Search-Track Orthogonal Polar Integrated PDet Jamming constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES_JAMMING = 140
    """Search-Track Orthogonal Polar Integrated Pulses Jamming constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME_JAMMING = 141
    """Search-Track Orthogonal Polar Integration Time Jamming constraint."""
    SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME_JAMMING = 142
    """Search-Track Orthogonal Polar Dwell Time Jamming constraint."""
    FREQUENCY = 143
    """Frequency constraint."""
    DOPPLER_SHIFT = 144
    """Doppler Shift constraint."""
    RECEIVED_ISOTROPIC_POWER = 145
    """Received Isotropic Power constraint."""
    POWER_AT_RECEIVER_INPUT = 146
    """Power at Receiver Input constraint."""
    FLUX_DENSITY = 147
    """Flux Density constraint."""
    G_OVER_T = 148
    """G/T constraint."""
    C_OVER_N0 = 149
    """C/No constraint."""
    C_OVER_N = 150
    """C/N constraint."""
    LINK_MARGIN = 151
    """Link Margin constraint."""
    EB_OVER_N0 = 152
    """Energy per bit to noise ratio (Eb/No) constraint."""
    BIT_ERROR_RATE = 153
    """Bit Error Rate constraint."""
    POLARIZATION_RELATIVE_ANGLE = 154
    """Polarization Relative Angle constraint."""
    COMM_PLUGIN = 155
    """Comm Plugin constraint."""
    LINK_EIRP = 156
    """Link EIRP constraint."""
    POWER_FLUX_DENSITY = 157
    """Power Flux Density constraint."""
    TOTAL_RECEIVED_REFRACTION_POWER = 158
    """Total Received Rf Power constraint."""
    C_OVER_N0_PLUS_I0 = 159
    """C/No+Io constraint."""
    C_OVER_N_PLUS_I = 160
    """C/N+I constraint."""
    C_OVER_I = 161
    """C/I constraint."""
    J_OVER_S = 162
    """J/S constraint."""
    DELTA_T_OVER_T = 163
    """Delta T/T constraint."""
    EB_OVER_N0_PLUS_I0 = 164
    """Eb/No+Io constraint."""
    BER_PLUS_I = 165
    """BER+I constraint."""
    FREQUENCY_TRACK = 166
    """Frequency Track constraint."""
    PHASE_TRACK = 167
    """Phase Track constraint."""
    CODE_TRACK = 168
    """Code Track constraint."""
    C_OVER_N0_PLUS_I_GPS_CHANNEL = 169
    """CNoIGPSCh constraint."""
    ACCESS_CONSTRAINT_PLUGIN = 170
    """Access Constraint Plugin constraint."""
    THIRD_BODY_OBS = 171
    """Do not use this enumeration, as it is deprecated. Third Body Obstruction constraint."""
    SPECTRAL_FLUX_DENSITY = 172
    """Spectral Flux Density constraint."""
    CONDITION = 173
    """Crdn Condition constraint."""

FigureOfMeritConstraintName.UNKNOWN.__doc__ = "Unknown constraint."
FigureOfMeritConstraintName.ALTITUDE.__doc__ = "Altitude constraint."
FigureOfMeritConstraintName.ANGULAR_RATE.__doc__ = "Angular Rate constraint."
FigureOfMeritConstraintName.APPARENT_TIME.__doc__ = "Apparent Time constraint."
FigureOfMeritConstraintName.AZIMUTH_ANGLE.__doc__ = "Azimuth Angle constraint."
FigureOfMeritConstraintName.AZIMUTH_RATE.__doc__ = "Azimuth Rate constraint."
FigureOfMeritConstraintName.CENTRAL_BODY_OBSTRUCTION.__doc__ = "Central Body Obstruction constraint."
FigureOfMeritConstraintName.VECTOR_GEOMETRY_TOOL_ANGLE.__doc__ = "Angle constraint."
FigureOfMeritConstraintName.VECTOR_MAGNITUDE.__doc__ = "Vector Magnitude constraint."
FigureOfMeritConstraintName.ELEVATION_ANGLE.__doc__ = "Elevation Angle constraint."
FigureOfMeritConstraintName.ELEVATION_RATE.__doc__ = "Elevation Rate constraint."
FigureOfMeritConstraintName.ELEVATION_RISE_SET.__doc__ = "Elevation Rise Set constraint."
FigureOfMeritConstraintName.GEO_EXCLUSION.__doc__ = "Geo Exclusion constraint."
FigureOfMeritConstraintName.GROUND_SAMPLE_DISTANCE.__doc__ = "Ground Sample Distance constraint."
FigureOfMeritConstraintName.HEIGHT_ABOVE_HORIZON.__doc__ = "Height Above Horizon constraint."
FigureOfMeritConstraintName.LINE_OF_SIGHT_LUNAR_EXCLUSION_ANGLE.__doc__ = "LOS Lunar Exclusion constraint."
FigureOfMeritConstraintName.LINE_OF_SIGHT_SOLAR_EXCLUSION_ANGLE.__doc__ = "LOS Sun Exclusion constraint."
FigureOfMeritConstraintName.LUNAR_ELEVATION_ANGLE.__doc__ = "Lunar Elevation Angle constraint."
FigureOfMeritConstraintName.MATLAB.__doc__ = "Matlab constraint."
FigureOfMeritConstraintName.OBJECT_EXCLUSION_ANGLE.__doc__ = "Object Exclusion Angle constraint."
FigureOfMeritConstraintName.PROPAGATION_DELAY.__doc__ = "Propagation Delay constraint."
FigureOfMeritConstraintName.RANGE.__doc__ = "Range constraint."
FigureOfMeritConstraintName.RANGE_RATE.__doc__ = "Range Rate constraint."
FigureOfMeritConstraintName.SAR_AREA_RATE.__doc__ = "SAR Area Rate constraint."
FigureOfMeritConstraintName.SAR_AZIMUTH_RESOLUTION.__doc__ = "SAR Azimuth Resolution constraint."
FigureOfMeritConstraintName.SAR_CARRIER_TO_NOISE_RATIO.__doc__ = "SAR Carrier-to-Noise Ratio constraint."
FigureOfMeritConstraintName.SAR_EXTERNAL_DATA.__doc__ = "SAR External Data constraint."
FigureOfMeritConstraintName.SAR_INTEGRATION_TIME.__doc__ = "SAR Integration Time constraint."
FigureOfMeritConstraintName.SAR_PTCR.__doc__ = "SAR Point-Target-to-Clutter Ratio constraint."
FigureOfMeritConstraintName.SAR_SCR.__doc__ = "SAR Signal-to-Clutter Ratio constraint."
FigureOfMeritConstraintName.SAR_SNR.__doc__ = "SAR Signal-to-Noise Ratio constraint."
FigureOfMeritConstraintName.SAR_SIGMA_N.__doc__ = "SAR Sigma N constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_DWELL_TIME.__doc__ = "Search-Track Dwell Time constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION.__doc__ = "Search-Track Integrated Probability of Detection constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_SNR.__doc__ = "Search-Track Integrated Signal-to-Noise Ratio constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATION_TIME.__doc__ = "Search-Track Integration Time constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION.__doc__ = "Search-Track Single Pulse Probability of Detection constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_SINGLE_PULSE_SNR.__doc__ = "Search-Track Single Pulse Signal-to-Noise Ratio constraint."
FigureOfMeritConstraintName.SUN_ELEVATION_ANGLE.__doc__ = "Sun Elevation Angle constraint."
FigureOfMeritConstraintName.TERRAIN_GRAZING_ANGLE.__doc__ = "Terrain Grazing Angle constraint."
FigureOfMeritConstraintName.ANGLE_TO_ASSET.__doc__ = "Angle To Asset constraint."
FigureOfMeritConstraintName.LINE_OF_SIGHT.__doc__ = "Line Of Sight constraint."
FigureOfMeritConstraintName.AZ_EL_MASK.__doc__ = "Azimuth Elevation Mask constraint."
FigureOfMeritConstraintName.DURATION.__doc__ = "Duration constraint."
FigureOfMeritConstraintName.GMT.__doc__ = "Greenwich Mean Time constraint."
FigureOfMeritConstraintName.IMAGE_QUALITY.__doc__ = "Image Quality constraint."
FigureOfMeritConstraintName.INTERVALS.__doc__ = "Intervals constraint."
FigureOfMeritConstraintName.LIGHTING.__doc__ = "Light constraint."
FigureOfMeritConstraintName.LOCAL_TIME.__doc__ = "Local Time constraint."
FigureOfMeritConstraintName.LINE_OF_SIGHT_CENTRAL_BODY_EXCLUSION.__doc__ = "Loss Of Signal Central Body Exclusion constraint."
FigureOfMeritConstraintName.POINT_METRIC.__doc__ = "Coordinate Point Metric constraint."
FigureOfMeritConstraintName.CENTROID_AZIMUTH_ANGLE.__doc__ = "Do not use this enumeration, as it is deprecated. Centroid Azimuth Angle constraint."
FigureOfMeritConstraintName.CENTROID_RANGE.__doc__ = "Do not use this enumeration, as it is deprecated. Centroid Range constraint."
FigureOfMeritConstraintName.CENTROID_SUN_ELEVATION_ANGLE.__doc__ = "Do not use this enumeration, as it is deprecated. Centroid Sun Elevation Angle constraint."
FigureOfMeritConstraintName.COLLECTION_ANGLE.__doc__ = "Collection Angle constraint."
FigureOfMeritConstraintName.DOPPLER_CONE_ANGLE.__doc__ = "Doppler Cone Angle constraint."
FigureOfMeritConstraintName.LATITUDE.__doc__ = "Latitude constraint."
FigureOfMeritConstraintName.SUN_GROUND_ELEVATION_ANGLE.__doc__ = "Sun Ground Elevation Angle constraint."
FigureOfMeritConstraintName.TERRAIN_MASK.__doc__ = "Terrain Mask constraint."
FigureOfMeritConstraintName.CROSS_TRACK_RANGE.__doc__ = "Cross Track Range constraint."
FigureOfMeritConstraintName.IN_TRACK_RANGE.__doc__ = "In Track Range constraint."
FigureOfMeritConstraintName.SQUINT_ANGLE.__doc__ = "Squinting Angle constraint."
FigureOfMeritConstraintName.BACKGROUND.__doc__ = "Background constraint."
FigureOfMeritConstraintName.FOREGROUND.__doc__ = "Foreground constraint."
FigureOfMeritConstraintName.BETA_ANGLE.__doc__ = "Beta Angle constraint."
FigureOfMeritConstraintName.AREA_TARGET_CENTROID_ELEVATION_ANGLE.__doc__ = "Do not use this enumeration, as it is deprecated. Area Target Centroid Elevation Angle constraint."
FigureOfMeritConstraintName.EXCLUSION_ZONE.__doc__ = "Exclusion Zone constraint."
FigureOfMeritConstraintName.GRAZING_ANGLE.__doc__ = "Grazing Angle constraint."
FigureOfMeritConstraintName.GRAZING_ALTITUDE.__doc__ = "Grazing Altitude constraint."
FigureOfMeritConstraintName.GROUND_ELEVATION_ANGLE.__doc__ = "Ground Elevation Angle constraint."
FigureOfMeritConstraintName.GROUND_TRACK.__doc__ = "Ground Track constraint."
FigureOfMeritConstraintName.INCLUSION_ZONE.__doc__ = "Inclusion Zone constraint."
FigureOfMeritConstraintName.SUN_SPECULAR_EXCLUSION.__doc__ = "Sun Specular Exclusion constraint."
FigureOfMeritConstraintName.DEPTH.__doc__ = "Deptch constraint."
FigureOfMeritConstraintName.FIELD_OF_VIEW.__doc__ = "Field Of View constraint."
FigureOfMeritConstraintName.ANGLE_OFF_BORESIGHT.__doc__ = "Angle Of Boresight constraint."
FigureOfMeritConstraintName.ANGLE_OFF_BORESIGHT_RATE.__doc__ = "Angle Of Boresight Rate constraint."
FigureOfMeritConstraintName.BORESIGHT_GRAZING_ANGLE.__doc__ = "Boresight Grazing Angle constraint."
FigureOfMeritConstraintName.BORESIGHT_INTERSECTION_LIGHTING_CONDITION.__doc__ = "BS Intersection Light Condition constraint."
FigureOfMeritConstraintName.FIELD_OF_VIEW_SUN_SPECULAR_EXCLUSION.__doc__ = "Field Of View Sun Specular Exclusion constraint."
FigureOfMeritConstraintName.FIELD_OF_VIEW_SUN_SPECULAR_INCLUSION.__doc__ = "Field Of View Sun Specular Inclusion constraint."
FigureOfMeritConstraintName.HORIZON_CROSSING.__doc__ = "Horizon Crossing constraint."
FigureOfMeritConstraintName.BORESIGHT_LUNAR_EXCLUSION_ANGLE.__doc__ = "BS Lunar Exclusion constraint."
FigureOfMeritConstraintName.BORESIGHT_SOLAR_EXCLUSION_ANGLE.__doc__ = "BS Sun Exclusion constraint."
FigureOfMeritConstraintName.BORESIGHT_CENTRAL_BODY_EXCLUSION_ANGLE.__doc__ = "BS Centray Body Exclusion constraint."
FigureOfMeritConstraintName.CENTRAL_BODY_OBSTRUCTION_CROSS_INWARD.__doc__ = "Field Of View Central Body Obstruction Cross In constraint."
FigureOfMeritConstraintName.CENTRAL_BODY_OBSTRUCTION_CROSS_OUTWARD.__doc__ = "Field Of View Central Body Obstruction Cross Out constraint."
FigureOfMeritConstraintName.CENTRAL_BODY_HORIZON_REFINE.__doc__ = "Field Of View Central Body Horizon Refine constraint."
FigureOfMeritConstraintName.CENTRAL_BODY_CENTER.__doc__ = "Field Of View Central Body Center constraint."
FigureOfMeritConstraintName.SENSOR_AZ_EL_MASK.__doc__ = "Sensor Azimuth Elevation Mask constraint."
FigureOfMeritConstraintName.SENSOR_RANGE_MASK.__doc__ = "Sensor Range Mask constraint."
FigureOfMeritConstraintName.INFRARED_DETECTION.__doc__ = "Infrared Detection constraint."
FigureOfMeritConstraintName.RADAR_TRANSMITTER_TARGET_ACCESS.__doc__ = "Radar Xmt Target Access constraint."
FigureOfMeritConstraintName.RADAR_TRANSMITTER_ACCESS.__doc__ = "Radar Xmt Access constraint."
FigureOfMeritConstraintName.RADAR_ACCESS.__doc__ = "Radar Access constraint."
FigureOfMeritConstraintName.BISTATIC_ANGLE.__doc__ = "Bistatic Angle constraint."
FigureOfMeritConstraintName.NOISE_TEMPERATURE.__doc__ = "Noise Temperature constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_PULSES.__doc__ = "Search-Track Integrated Pulses constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_MLC_FILTER.__doc__ = "Search-Track MLC Filter constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_SLC_FILTER.__doc__ = "Search-Track SLC Filter constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_CLEAR_DOPPLER.__doc__ = "Search-Track Clear Doppler constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_UNAMBIGUOUS_RANGE.__doc__ = "Search-Track Unambiguous Range constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_UNAMBIGUOUS_DOPPLER.__doc__ = "Search-Track Unambiguous Doppler constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_SINGLE_PULSE_SNR_JAMMING.__doc__ = "Search-Track Single Pulse SNR Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_SINGLE_PULSE_J_OVER_S.__doc__ = "Search-Track Single Pulse J/S constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Single Pulse PDet Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_SNR_JAMMING.__doc__ = "Search-Track Integrated SNR Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_J_OVER_S.__doc__ = "Search-Track Integrated J/S constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Integrated PDet Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATED_PULSES_JAMMING.__doc__ = "Search-Track Integrated Pulses Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_INTEGRATION_TIME_JAMMING.__doc__ = "Search-Track Integration Time Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_DWELL_TIME_JAMMING.__doc__ = "Search-Track Dwell Time Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_CONSTRAINT_PLUGIN.__doc__ = "Search-Track Constraint Plugin constraint."
FigureOfMeritConstraintName.SAR_SNR_JAMMING.__doc__ = "SAR SNR Jamming constraint."
FigureOfMeritConstraintName.SAR_CARRIER_TO_NOISE_RATIO_JAMMING.__doc__ = "SAR CNR Jamming constraint."
FigureOfMeritConstraintName.SAR_SCR_JAMMING.__doc__ = "SAR SCR Jamming constraint."
FigureOfMeritConstraintName.SAR_J_OVER_S.__doc__ = "SAR J/S constraint."
FigureOfMeritConstraintName.SAR_CONSTRAINT_PLUGIN.__doc__ = "SAR Constraint Plugin constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_SNR.__doc__ = "SAR Orthogonal Polar SNR constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_CNR.__doc__ = "SAR Orthogonal Polar CNR constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_SCR.__doc__ = "SAR Orthogonal Polar SCR constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_PTCR.__doc__ = "SAR Orthogonal Polar PTCR constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_SNR_JAMMING.__doc__ = "SAR Orthogonal Polar SNR Jamming constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_CNR_JAMMING.__doc__ = "SAR Orthogonal Polar CNR Jamming constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_SCR_JAMMING.__doc__ = "SAR Orthogonal Polar SCR Jamming constraint."
FigureOfMeritConstraintName.SAR_ORTHOGONAL_POLARIZATION_J_OVER_S.__doc__ = "SAR Orthogonal Polar J/S constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR.__doc__ = "Search-Track Orthogonal Polar Single Pulse SNR constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION.__doc__ = "Search-Track Orthogonal Polar Single Pulse PDet constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR.__doc__ = "Search-Track Orthogonal Polar Integrated SNR constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION.__doc__ = "Search-Track Orthogonal Polar Integrated PDet constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES.__doc__ = "Search-Track Orthogonal Polar Integrated Pulses constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME.__doc__ = "Search-Track Orthogonal Polar Integration Time constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME.__doc__ = "Search-Track Orthogonal Polar Dwell Time constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_SNR_JAMMING.__doc__ = "Search-Track Orthogonal Polar Single Pulse SNR Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_J_OVER_S.__doc__ = "Search-Track Orthogonal Polar Single Pulse J/S constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_SINGLE_PULSE_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Orthogonal Polar Single Pulse PDet Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_SNR_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated SNR Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_J_OVER_S.__doc__ = "Search-Track Orthogonal Polar Integrated J/S constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PROBABILITY_OF_DETECTION_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated PDet Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATED_PULSES_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integrated Pulses Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_INTEGRATION_TIME_JAMMING.__doc__ = "Search-Track Orthogonal Polar Integration Time Jamming constraint."
FigureOfMeritConstraintName.SEARCH_TRACK_ORTHOGONAL_POLARIZATION_DWELL_TIME_JAMMING.__doc__ = "Search-Track Orthogonal Polar Dwell Time Jamming constraint."
FigureOfMeritConstraintName.FREQUENCY.__doc__ = "Frequency constraint."
FigureOfMeritConstraintName.DOPPLER_SHIFT.__doc__ = "Doppler Shift constraint."
FigureOfMeritConstraintName.RECEIVED_ISOTROPIC_POWER.__doc__ = "Received Isotropic Power constraint."
FigureOfMeritConstraintName.POWER_AT_RECEIVER_INPUT.__doc__ = "Power at Receiver Input constraint."
FigureOfMeritConstraintName.FLUX_DENSITY.__doc__ = "Flux Density constraint."
FigureOfMeritConstraintName.G_OVER_T.__doc__ = "G/T constraint."
FigureOfMeritConstraintName.C_OVER_N0.__doc__ = "C/No constraint."
FigureOfMeritConstraintName.C_OVER_N.__doc__ = "C/N constraint."
FigureOfMeritConstraintName.LINK_MARGIN.__doc__ = "Link Margin constraint."
FigureOfMeritConstraintName.EB_OVER_N0.__doc__ = "Energy per bit to noise ratio (Eb/No) constraint."
FigureOfMeritConstraintName.BIT_ERROR_RATE.__doc__ = "Bit Error Rate constraint."
FigureOfMeritConstraintName.POLARIZATION_RELATIVE_ANGLE.__doc__ = "Polarization Relative Angle constraint."
FigureOfMeritConstraintName.COMM_PLUGIN.__doc__ = "Comm Plugin constraint."
FigureOfMeritConstraintName.LINK_EIRP.__doc__ = "Link EIRP constraint."
FigureOfMeritConstraintName.POWER_FLUX_DENSITY.__doc__ = "Power Flux Density constraint."
FigureOfMeritConstraintName.TOTAL_RECEIVED_REFRACTION_POWER.__doc__ = "Total Received Rf Power constraint."
FigureOfMeritConstraintName.C_OVER_N0_PLUS_I0.__doc__ = "C/No+Io constraint."
FigureOfMeritConstraintName.C_OVER_N_PLUS_I.__doc__ = "C/N+I constraint."
FigureOfMeritConstraintName.C_OVER_I.__doc__ = "C/I constraint."
FigureOfMeritConstraintName.J_OVER_S.__doc__ = "J/S constraint."
FigureOfMeritConstraintName.DELTA_T_OVER_T.__doc__ = "Delta T/T constraint."
FigureOfMeritConstraintName.EB_OVER_N0_PLUS_I0.__doc__ = "Eb/No+Io constraint."
FigureOfMeritConstraintName.BER_PLUS_I.__doc__ = "BER+I constraint."
FigureOfMeritConstraintName.FREQUENCY_TRACK.__doc__ = "Frequency Track constraint."
FigureOfMeritConstraintName.PHASE_TRACK.__doc__ = "Phase Track constraint."
FigureOfMeritConstraintName.CODE_TRACK.__doc__ = "Code Track constraint."
FigureOfMeritConstraintName.C_OVER_N0_PLUS_I_GPS_CHANNEL.__doc__ = "CNoIGPSCh constraint."
FigureOfMeritConstraintName.ACCESS_CONSTRAINT_PLUGIN.__doc__ = "Access Constraint Plugin constraint."
FigureOfMeritConstraintName.THIRD_BODY_OBS.__doc__ = "Do not use this enumeration, as it is deprecated. Third Body Obstruction constraint."
FigureOfMeritConstraintName.SPECTRAL_FLUX_DENSITY.__doc__ = "Spectral Flux Density constraint."
FigureOfMeritConstraintName.CONDITION.__doc__ = "Crdn Condition constraint."

agcls.AgTypeNameMap["FigureOfMeritConstraintName"] = FigureOfMeritConstraintName

class FigureOfMeritCompute(IntEnum):
    """Figure of Merit compute options."""

    UNKNOWN = -1
    """Unknown compute option."""
    AVERAGE = 0
    """Refer to STK Coverage help under the applicable figure of merit."""
    MAXIMUM = 1
    """Refer to STK Coverage help under the applicable figure of merit."""
    MINIMUM = 2
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT_ABOVE = 3
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT_BELOW = 4
    """Refer to STK Coverage help under the applicable figure of merit."""
    STD_DEVIATION = 5
    """Refer to STK Coverage help under the applicable figure of merit."""
    MAXIMUM_PER_DAY = 6
    """Refer to STK Coverage help under the applicable figure of merit."""
    MAXIMUM_PERCENT_PER_DAY = 7
    """Refer to STK Coverage help under the applicable figure of merit."""
    MINIMUM_PER_DAY = 8
    """Refer to STK Coverage help under the applicable figure of merit."""
    MINIMUM_PERCENT_PER_DAY = 9
    """Refer to STK Coverage help under the applicable figure of merit."""
    PER_DAY = 10
    """Refer to STK Coverage help under the applicable figure of merit."""
    PER_DAY_STANDARD_DEVIATION = 11
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT = 12
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT_PER_DAY = 13
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT_PER_DAY_STANDARD_DEVIATION = 14
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT_TIME_ABOVE = 15
    """Refer to STK Coverage help under the applicable figure of merit."""
    TOTAL = 16
    """Refer to STK Coverage help under the applicable figure of merit."""
    TOTAL_TIME_ABOVE = 17
    """Refer to STK Coverage help under the applicable figure of merit."""
    PERCENT_BELOW_GAPS_ONLY = 18
    """Refer to STK Coverage help under the applicable figure of merit."""
    NUMBER_PERCENT_BELOW = 19
    """Refer to STK Coverage help under the applicable figure of merit."""
    AVERAGE_PER_DAY = 20
    """Refer to STK Coverage help under the applicable figure of merit."""
    IN_SPAN = 21
    """Refer to STK Coverage help under the applicable figure of merit."""
    IN_SPAN_PER_DAY = 22
    """Refer to STK Coverage help under the applicable figure of merit."""
    SUM = 23
    """Refer to STK Coverage help under the applicable figure of merit."""
    UNIQUE = 24
    """Refer to STK Coverage help under the applicable figure of merit."""

FigureOfMeritCompute.UNKNOWN.__doc__ = "Unknown compute option."
FigureOfMeritCompute.AVERAGE.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.MAXIMUM.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.MINIMUM.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT_ABOVE.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT_BELOW.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.STD_DEVIATION.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.MAXIMUM_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.MAXIMUM_PERCENT_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.MINIMUM_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.MINIMUM_PERCENT_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PER_DAY_STANDARD_DEVIATION.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT_PER_DAY_STANDARD_DEVIATION.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT_TIME_ABOVE.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.TOTAL.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.TOTAL_TIME_ABOVE.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.PERCENT_BELOW_GAPS_ONLY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.NUMBER_PERCENT_BELOW.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.AVERAGE_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.IN_SPAN.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.IN_SPAN_PER_DAY.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.SUM.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."
FigureOfMeritCompute.UNIQUE.__doc__ = "Refer to STK Coverage help under the applicable figure of merit."

agcls.AgTypeNameMap["FigureOfMeritCompute"] = FigureOfMeritCompute

class FigureOfMeritAcrossAssets(IntEnum):
    """Across Assets options: specify which value of the constraint is to be selected based on all currently available assets."""

    UNKNOWN = -1
    """Unknown."""
    AVERAGE = 0
    """Constraint values are computed for all currently available assets and the average is selected."""
    MAXIMUM = 1
    """Constraint values are computed for all currently available assets and the maximum is selected."""
    MINIMUM = 2
    """Constraint values are computed for all currently available assets and the minimum is selected."""
    SUM = 3
    """Constraint values are computed for all currently available assets and the sum is selected."""

FigureOfMeritAcrossAssets.UNKNOWN.__doc__ = "Unknown."
FigureOfMeritAcrossAssets.AVERAGE.__doc__ = "Constraint values are computed for all currently available assets and the average is selected."
FigureOfMeritAcrossAssets.MAXIMUM.__doc__ = "Constraint values are computed for all currently available assets and the maximum is selected."
FigureOfMeritAcrossAssets.MINIMUM.__doc__ = "Constraint values are computed for all currently available assets and the minimum is selected."
FigureOfMeritAcrossAssets.SUM.__doc__ = "Constraint values are computed for all currently available assets and the sum is selected."

agcls.AgTypeNameMap["FigureOfMeritAcrossAssets"] = FigureOfMeritAcrossAssets

class FigureOfMeritNavigationComputeType(IntEnum):
    """Allowed number of assets for the navigation solution."""

    BEST_4 = 0
    """Compute the navigation accuracy based on the set of four satellites that yields the minimum GDOP."""
    BEST_N = 1
    """Compute the navigation accuracy based on the specified number of satellites that yields the minimum GDOP."""
    OVER_DETERMINED = 2
    """Compute the navigation accuracy based on all of the currently available assets."""
    BEST_4_ACCURACY = 3
    """Compute the navigation accuracy based on the set of the set of four satellites that yields the minimum geometric uncertainty."""
    BEST_N_ACCURACY = 4
    """Compute the navigation accuracy based on the set of the specified number of satellites that yields the minimum geometric uncertainty."""

FigureOfMeritNavigationComputeType.BEST_4.__doc__ = "Compute the navigation accuracy based on the set of four satellites that yields the minimum GDOP."
FigureOfMeritNavigationComputeType.BEST_N.__doc__ = "Compute the navigation accuracy based on the specified number of satellites that yields the minimum GDOP."
FigureOfMeritNavigationComputeType.OVER_DETERMINED.__doc__ = "Compute the navigation accuracy based on all of the currently available assets."
FigureOfMeritNavigationComputeType.BEST_4_ACCURACY.__doc__ = "Compute the navigation accuracy based on the set of the set of four satellites that yields the minimum geometric uncertainty."
FigureOfMeritNavigationComputeType.BEST_N_ACCURACY.__doc__ = "Compute the navigation accuracy based on the set of the specified number of satellites that yields the minimum geometric uncertainty."

agcls.AgTypeNameMap["FigureOfMeritNavigationComputeType"] = FigureOfMeritNavigationComputeType

class FigureOfMeritMethod(IntEnum):
    """Dilution of Precision method."""

    GDOP = 0
    """Geometric Dilution of Precision: Measures the dilution of precision for the entire navigation solution."""
    HDOP = 1
    """Horizontal Dilution of Precision: Measures the dilution of precision for the horizontal (latitude/longitude) components of the positional portion of the navigation solution."""
    HDOP3 = 2
    """Same as HDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    PDOP = 3
    """Position Dilution of Precision: Measures only the dilution of precision associated with the positional portion of the navigation solution."""
    PDOP3 = 4
    """Same as PDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    TDOP = 5
    """Time Dilution of Precision: Measures the dilution of precision of the time portion of the navigation solution."""
    VDOP = 6
    """Vertical Dilution of Precision: Measures the dilution of precision for the vertical (altitude) components of the positional portion of the navigation solution."""
    VDOP3 = 7
    """Same as VDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    GACC = 8
    """Geometric Accuracy: Measures the accuracy of the entire navigation solution."""
    HACC = 9
    """Horizontal Accuracy: Measures the accuracy for the horizontal (latitude/longitude) components of the positional portion of the navigation solution."""
    HACC3 = 10
    """Same as HACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    PACC = 11
    """Position Accuracy: Measures only the accuracy associated with the positional portion of the navigation solution."""
    PACC3 = 12
    """Same as PACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    TACC = 13
    """Time Accuracy: Measures the accuracy of the time portion of the navigation solution."""
    VACC = 14
    """Vertical Accuracy: Measures the accuracy for the vertical (altitude) components of the positional portion of the navigation solution."""
    VACC3 = 15
    """Same as VACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    EDOP = 16
    """East Dilution of Precision: Measures the dilution of precision for the east components of the positional portion of the navigation solution."""
    EDOP3 = 17
    """Same as eEDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    NDOP = 18
    """North Dilution of Precision: Measures the dilution of precision for the east components of the positional portion of the navigation solution."""
    NDOP3 = 19
    """Same as eNDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    EACC = 20
    """East Accuracy: Measures the accuracy for the east components of the positional portion of the navigation solution."""
    EACC3 = 21
    """Same as EACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""
    NACC = 22
    """North Accuracy: Measures the accuracy for the north components of the positional portion of the navigation solution."""
    NACC3 = 23
    """Same as NACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."""

FigureOfMeritMethod.GDOP.__doc__ = "Geometric Dilution of Precision: Measures the dilution of precision for the entire navigation solution."
FigureOfMeritMethod.HDOP.__doc__ = "Horizontal Dilution of Precision: Measures the dilution of precision for the horizontal (latitude/longitude) components of the positional portion of the navigation solution."
FigureOfMeritMethod.HDOP3.__doc__ = "Same as HDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.PDOP.__doc__ = "Position Dilution of Precision: Measures only the dilution of precision associated with the positional portion of the navigation solution."
FigureOfMeritMethod.PDOP3.__doc__ = "Same as PDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.TDOP.__doc__ = "Time Dilution of Precision: Measures the dilution of precision of the time portion of the navigation solution."
FigureOfMeritMethod.VDOP.__doc__ = "Vertical Dilution of Precision: Measures the dilution of precision for the vertical (altitude) components of the positional portion of the navigation solution."
FigureOfMeritMethod.VDOP3.__doc__ = "Same as VDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.GACC.__doc__ = "Geometric Accuracy: Measures the accuracy of the entire navigation solution."
FigureOfMeritMethod.HACC.__doc__ = "Horizontal Accuracy: Measures the accuracy for the horizontal (latitude/longitude) components of the positional portion of the navigation solution."
FigureOfMeritMethod.HACC3.__doc__ = "Same as HACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.PACC.__doc__ = "Position Accuracy: Measures only the accuracy associated with the positional portion of the navigation solution."
FigureOfMeritMethod.PACC3.__doc__ = "Same as PACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.TACC.__doc__ = "Time Accuracy: Measures the accuracy of the time portion of the navigation solution."
FigureOfMeritMethod.VACC.__doc__ = "Vertical Accuracy: Measures the accuracy for the vertical (altitude) components of the positional portion of the navigation solution."
FigureOfMeritMethod.VACC3.__doc__ = "Same as VACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.EDOP.__doc__ = "East Dilution of Precision: Measures the dilution of precision for the east components of the positional portion of the navigation solution."
FigureOfMeritMethod.EDOP3.__doc__ = "Same as eEDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.NDOP.__doc__ = "North Dilution of Precision: Measures the dilution of precision for the east components of the positional portion of the navigation solution."
FigureOfMeritMethod.NDOP3.__doc__ = "Same as eNDOP, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.EACC.__doc__ = "East Accuracy: Measures the accuracy for the east components of the positional portion of the navigation solution."
FigureOfMeritMethod.EACC3.__doc__ = "Same as EACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."
FigureOfMeritMethod.NACC.__doc__ = "North Accuracy: Measures the accuracy for the north components of the positional portion of the navigation solution."
FigureOfMeritMethod.NACC3.__doc__ = "Same as NACC, but the DOP value is computed even if only 3 navigation sources are available, in which case the clock component is ignored."

agcls.AgTypeNameMap["FigureOfMeritMethod"] = FigureOfMeritMethod

class FigureOfMeritEndGapOption(IntEnum):
    """End gap options: control consideration of gaps at ends of analysis intervals."""

    IGNORE = 0
    """Ignore: eliminate gaps at the ends of the analysis interval from the revisit time computations."""
    INCLUDE = 1
    """Include: include gaps at the ends of the analysis interval in the revisit time computations."""

FigureOfMeritEndGapOption.IGNORE.__doc__ = "Ignore: eliminate gaps at the ends of the analysis interval from the revisit time computations."
FigureOfMeritEndGapOption.INCLUDE.__doc__ = "Include: include gaps at the ends of the analysis interval in the revisit time computations."

agcls.AgTypeNameMap["FigureOfMeritEndGapOption"] = FigureOfMeritEndGapOption

class FigureOfMeritGraphics2DContourType(IntEnum):
    """Contour fill options."""

    BLOCK_FILL = 0
    """Block Fill: color is applied to a region that contains points of a certain contour level."""
    SMOOTH_FILL = 1
    """Smooth Fill: color is applied smoothly over all points in the grid to differentiate contour levels. NOTE: Not a valid choice when BoundsType (CoverageGrid) is set to LatLine, LonLine or CustomBoundary."""

FigureOfMeritGraphics2DContourType.BLOCK_FILL.__doc__ = "Block Fill: color is applied to a region that contains points of a certain contour level."
FigureOfMeritGraphics2DContourType.SMOOTH_FILL.__doc__ = "Smooth Fill: color is applied smoothly over all points in the grid to differentiate contour levels. NOTE: Not a valid choice when BoundsType (CoverageGrid) is set to LatLine, LonLine or CustomBoundary."

agcls.AgTypeNameMap["FigureOfMeritGraphics2DContourType"] = FigureOfMeritGraphics2DContourType

class FigureOfMeritGraphics2DColorMethod(IntEnum):
    """Methods for assigning colors to contour levels."""

    COLOR_RAMP = 0
    """Color Ramp: apply a spectrum pattern with selected start and end colors."""
    EXPLICIT = 1
    """Explicit: assign colors individually to contour levels."""

FigureOfMeritGraphics2DColorMethod.COLOR_RAMP.__doc__ = "Color Ramp: apply a spectrum pattern with selected start and end colors."
FigureOfMeritGraphics2DColorMethod.EXPLICIT.__doc__ = "Explicit: assign colors individually to contour levels."

agcls.AgTypeNameMap["FigureOfMeritGraphics2DColorMethod"] = FigureOfMeritGraphics2DColorMethod

class FigureOfMeritGraphics2DFloatingPointFormat(IntEnum):
    """Format options for floating point numbers."""

    FLOATING_POINT = 0
    """Floating point format."""
    SCIENTIFIC_UPPERCASE_E = 1
    """Scientific (E)."""
    SCIENTIFIC_LOWERCASE_E = 2
    """Scientific (e)."""

FigureOfMeritGraphics2DFloatingPointFormat.FLOATING_POINT.__doc__ = "Floating point format."
FigureOfMeritGraphics2DFloatingPointFormat.SCIENTIFIC_UPPERCASE_E.__doc__ = "Scientific (E)."
FigureOfMeritGraphics2DFloatingPointFormat.SCIENTIFIC_LOWERCASE_E.__doc__ = "Scientific (e)."

agcls.AgTypeNameMap["FigureOfMeritGraphics2DFloatingPointFormat"] = FigureOfMeritGraphics2DFloatingPointFormat

class FigureOfMeritGraphics2DDirection(IntEnum):
    """Level order display options for the contour legend."""

    HORIZONTAL_MAXIMUM_TO_MINIMUM = 0
    """Levels are displayed horizontally, in descending order."""
    HORIZONTAL_MINIMUM_TO_MAXIMUM = 1
    """Levels are displayed horizontally, in ascending order."""
    VERTICAL_MAXIMUM_TO_MINIMUM = 2
    """Levels are displayed vertically, in descending order."""
    VERTICAL_MINIMUM_TO_MAXIMUM = 3
    """Levels are displayed vertically, in ascending order."""

FigureOfMeritGraphics2DDirection.HORIZONTAL_MAXIMUM_TO_MINIMUM.__doc__ = "Levels are displayed horizontally, in descending order."
FigureOfMeritGraphics2DDirection.HORIZONTAL_MINIMUM_TO_MAXIMUM.__doc__ = "Levels are displayed horizontally, in ascending order."
FigureOfMeritGraphics2DDirection.VERTICAL_MAXIMUM_TO_MINIMUM.__doc__ = "Levels are displayed vertically, in descending order."
FigureOfMeritGraphics2DDirection.VERTICAL_MINIMUM_TO_MAXIMUM.__doc__ = "Levels are displayed vertically, in ascending order."

agcls.AgTypeNameMap["FigureOfMeritGraphics2DDirection"] = FigureOfMeritGraphics2DDirection

class FigureOfMeritGraphics2DAccumulation(IntEnum):
    """Accumulation options: control the sense and persistence of animation graphics for a Figure of Merit."""

    CURRENT_TIME = 0
    """When animating, grid points that currently meet the satisfaction criterion are highlighted."""
    NOT_CURRENT = 1
    """When animating, grid points that currently do not meet the satisfaction criterion are highlighted."""
    NOT_UP_TO_CURRENT = 2
    """When animating, grid points that have not met the satisfaction criterion based on the dynamic definition of the figure of merit from the start time to the current time are highlighted."""
    UP_TO_CURRENT = 3
    """When animating, grid points that have met the satisfaction criterion based on the dynamic definition of the figure of merit from the start time to the current time are highlighted."""

FigureOfMeritGraphics2DAccumulation.CURRENT_TIME.__doc__ = "When animating, grid points that currently meet the satisfaction criterion are highlighted."
FigureOfMeritGraphics2DAccumulation.NOT_CURRENT.__doc__ = "When animating, grid points that currently do not meet the satisfaction criterion are highlighted."
FigureOfMeritGraphics2DAccumulation.NOT_UP_TO_CURRENT.__doc__ = "When animating, grid points that have not met the satisfaction criterion based on the dynamic definition of the figure of merit from the start time to the current time are highlighted."
FigureOfMeritGraphics2DAccumulation.UP_TO_CURRENT.__doc__ = "When animating, grid points that have met the satisfaction criterion based on the dynamic definition of the figure of merit from the start time to the current time are highlighted."

agcls.AgTypeNameMap["FigureOfMeritGraphics2DAccumulation"] = FigureOfMeritGraphics2DAccumulation

class FigureOfMeritNavigationAccuracyMethod(IntEnum):
    """Options for uncertainty in one-way range measurements for the Navigation Accuracy Figure of Merit."""

    CONSTANT = 0
    """The uncertainty in the one-way range measurements is specified as a constant value."""
    ELEVATION_ANGLE = 1
    """The uncertainty in the one-way range measurements is specified as a function of the elevation angle on a transmitter basis."""

FigureOfMeritNavigationAccuracyMethod.CONSTANT.__doc__ = "The uncertainty in the one-way range measurements is specified as a constant value."
FigureOfMeritNavigationAccuracyMethod.ELEVATION_ANGLE.__doc__ = "The uncertainty in the one-way range measurements is specified as a function of the elevation angle on a transmitter basis."

agcls.AgTypeNameMap["FigureOfMeritNavigationAccuracyMethod"] = FigureOfMeritNavigationAccuracyMethod

class IvClockHost(IntEnum):
    """Clock host options for access. Time values are reported with a clock colocated with the clock host object."""

    BASE = 0
    """Base: Refers to the object from which access is being computed."""
    TARGET = 1
    """Target: Refers to an object to which access is being computed."""

IvClockHost.BASE.__doc__ = "Base: Refers to the object from which access is being computed."
IvClockHost.TARGET.__doc__ = "Target: Refers to an object to which access is being computed."

agcls.AgTypeNameMap["IvClockHost"] = IvClockHost

class IvTimeSense(IntEnum):
    """Mode of signal transmission of the designated clock host."""

    UNKNOWN = -1
    """Unknown time sense option."""
    TRANSMIT = 0
    """Clock host is transmitting."""
    RECEIVE = 1
    """Clock host is receiving."""

IvTimeSense.UNKNOWN.__doc__ = "Unknown time sense option."
IvTimeSense.TRANSMIT.__doc__ = "Clock host is transmitting."
IvTimeSense.RECEIVE.__doc__ = "Clock host is receiving."

agcls.AgTypeNameMap["IvTimeSense"] = IvTimeSense

class GPSAttitudeModelType(IntEnum):
    """GPS attitude profile model types."""

    UNKNOWN = -1
    """Unknown GPS attitude model."""
    GYM95 = 0
    """GYM 95 model."""
    BLOCK_IIA_NOMINAL = 1
    """IIA Nominal model."""
    BLOCK_IIR_NOMINAL = 2
    """IIR Nominal model."""

GPSAttitudeModelType.UNKNOWN.__doc__ = "Unknown GPS attitude model."
GPSAttitudeModelType.GYM95.__doc__ = "GYM 95 model."
GPSAttitudeModelType.BLOCK_IIA_NOMINAL.__doc__ = "IIA Nominal model."
GPSAttitudeModelType.BLOCK_IIR_NOMINAL.__doc__ = "IIR Nominal model."

agcls.AgTypeNameMap["GPSAttitudeModelType"] = GPSAttitudeModelType

class ConstellationConstraintRestrictionType(IntEnum):
    """The values of the enumeration are used to define constellation constraints that allow you to specify the criteria to be used when constellations are combined with other objects in a chain."""

    UNKNOWN = -1
    """Unknown or not supported criterion."""
    ALL_OF = 0
    """AND criterion. The constraint is satisfied if all objects in the constellation meet the conditions for chain access."""
    ANY_OF = 1
    """EITHER/OR criterion. The constraint is satisfied if any one object in the constellation meets the conditions for chain access."""
    AT_LEAST_N = 2
    """AND/OR criterion. The constraint is satisfied if at least the specified number of objects in the constellation meet the conditions for chain access."""
    EXACTLY_N = 3
    """ONLY criterion. This constraint is satisfied if the exact specified number of objects in the constellation meet the conditions for chain access."""
    NONE_OF = 4
    """ONLY criterion. The constraint is satisfied if NO objects in the constellation meet the conditions for chain access."""

ConstellationConstraintRestrictionType.UNKNOWN.__doc__ = "Unknown or not supported criterion."
ConstellationConstraintRestrictionType.ALL_OF.__doc__ = "AND criterion. The constraint is satisfied if all objects in the constellation meet the conditions for chain access."
ConstellationConstraintRestrictionType.ANY_OF.__doc__ = "EITHER/OR criterion. The constraint is satisfied if any one object in the constellation meets the conditions for chain access."
ConstellationConstraintRestrictionType.AT_LEAST_N.__doc__ = "AND/OR criterion. The constraint is satisfied if at least the specified number of objects in the constellation meet the conditions for chain access."
ConstellationConstraintRestrictionType.EXACTLY_N.__doc__ = "ONLY criterion. This constraint is satisfied if the exact specified number of objects in the constellation meet the conditions for chain access."
ConstellationConstraintRestrictionType.NONE_OF.__doc__ = "ONLY criterion. The constraint is satisfied if NO objects in the constellation meet the conditions for chain access."

agcls.AgTypeNameMap["ConstellationConstraintRestrictionType"] = ConstellationConstraintRestrictionType

class EventDetection(IntEnum):
    """Available event detection strategies."""

    UNKNOWN = -1
    """Unknown event detection strategy."""
    NO_SUB_SAMPLING = 0
    """Event detection strategy not using subsampling."""
    USE_SUB_SAMPLING = 1
    """Event detection strategy using subsampling."""

EventDetection.UNKNOWN.__doc__ = "Unknown event detection strategy."
EventDetection.NO_SUB_SAMPLING.__doc__ = "Event detection strategy not using subsampling."
EventDetection.USE_SUB_SAMPLING.__doc__ = "Event detection strategy using subsampling."

agcls.AgTypeNameMap["EventDetection"] = EventDetection

class SamplingMethod(IntEnum):
    """Available sampling methods."""

    UNKNOWN = -1
    """Unknown sampling method."""
    ADAPTIVE = 0
    """Adaptive sampling method."""
    FIXED_STEP = 1
    """Fixed-step sampling method."""

SamplingMethod.UNKNOWN.__doc__ = "Unknown sampling method."
SamplingMethod.ADAPTIVE.__doc__ = "Adaptive sampling method."
SamplingMethod.FIXED_STEP.__doc__ = "Fixed-step sampling method."

agcls.AgTypeNameMap["SamplingMethod"] = SamplingMethod

class CoverageSatisfactionType(IntEnum):
    """The condition on the number of assets covering a grid point that must be satisfied for a valid access."""

    UNKNOWN = -1
    """Unknown satisfaction type."""
    AT_LEAST = 0
    """The number of assets must be At Least N."""
    EQUAL_TO = 1
    """The number of assets must be Exactly N (Equal to N), where N is greater than or equal to 1."""

CoverageSatisfactionType.UNKNOWN.__doc__ = "Unknown satisfaction type."
CoverageSatisfactionType.AT_LEAST.__doc__ = "The number of assets must be At Least N."
CoverageSatisfactionType.EQUAL_TO.__doc__ = "The number of assets must be Exactly N (Equal to N), where N is greater than or equal to 1."

agcls.AgTypeNameMap["CoverageSatisfactionType"] = CoverageSatisfactionType

class CCSDSReferenceFrame(IntEnum):
    """Reference Frame."""

    EME2000 = 0
    """EME2000 reference frame."""
    FIXED = 1
    """Fixed reference frame."""
    ITRF = 2
    """ITRF reference frame, meaning Earth Fixed (valid for Earth only)."""
    TOD = 4
    """TrueOfDate reference frame."""
    MEAN_EARTH = 5
    """MeanEarth reference frame (valid for Moon only)."""
    ICRF = 6
    """ICRF reference frame."""
    TEME_OF_DATE = 7
    """TEMEOfDate reference frame (valid for Earth only)."""
    ITRF2000 = 8
    """ITRF2000 reference frame (valid for Earth only)."""
    ITRF2005 = 9
    """ITRF2005 reference frame (valid for Earth only)."""
    ITRF2008 = 10
    """ITRF2008 reference frame (valid for Earth only)."""
    ITRF2014 = 11
    """ITRF2014 reference frame (valid for Earth only)."""
    ITRF2020 = 12
    """ITRF2020 reference frame (valid for Earth only)."""
    GCRF = 13
    """Another name for the ICRF frame when used for the Earth (valid for Earth only)."""

CCSDSReferenceFrame.EME2000.__doc__ = "EME2000 reference frame."
CCSDSReferenceFrame.FIXED.__doc__ = "Fixed reference frame."
CCSDSReferenceFrame.ITRF.__doc__ = "ITRF reference frame, meaning Earth Fixed (valid for Earth only)."
CCSDSReferenceFrame.TOD.__doc__ = "TrueOfDate reference frame."
CCSDSReferenceFrame.MEAN_EARTH.__doc__ = "MeanEarth reference frame (valid for Moon only)."
CCSDSReferenceFrame.ICRF.__doc__ = "ICRF reference frame."
CCSDSReferenceFrame.TEME_OF_DATE.__doc__ = "TEMEOfDate reference frame (valid for Earth only)."
CCSDSReferenceFrame.ITRF2000.__doc__ = "ITRF2000 reference frame (valid for Earth only)."
CCSDSReferenceFrame.ITRF2005.__doc__ = "ITRF2005 reference frame (valid for Earth only)."
CCSDSReferenceFrame.ITRF2008.__doc__ = "ITRF2008 reference frame (valid for Earth only)."
CCSDSReferenceFrame.ITRF2014.__doc__ = "ITRF2014 reference frame (valid for Earth only)."
CCSDSReferenceFrame.ITRF2020.__doc__ = "ITRF2020 reference frame (valid for Earth only)."
CCSDSReferenceFrame.GCRF.__doc__ = "Another name for the ICRF frame when used for the Earth (valid for Earth only)."

agcls.AgTypeNameMap["CCSDSReferenceFrame"] = CCSDSReferenceFrame

class CCSDSDateFormat(IntEnum):
    """The date format of the file."""

    YDOY = 0
    """(YDOY Date format:  YYYY-DDD:THH:mm:SS.SSS)."""
    YMD = 1
    """(YMD Date format:  YYYY-MM-DDT:HH:mm:SS.SSS)."""

CCSDSDateFormat.YDOY.__doc__ = "(YDOY Date format:  YYYY-DDD:THH:mm:SS.SSS)."
CCSDSDateFormat.YMD.__doc__ = "(YMD Date format:  YYYY-MM-DDT:HH:mm:SS.SSS)."

agcls.AgTypeNameMap["CCSDSDateFormat"] = CCSDSDateFormat

class CCSDSEphemerisFormatType(IntEnum):
    """The ephemeris format of the file."""

    FLOATING_POINT = 0
    """Floating point notation format for representing the position and velocity information."""
    SCIENTIFIC_NOTATION = 1
    """Scientific notation format for representing the position and velocity information."""

CCSDSEphemerisFormatType.FLOATING_POINT.__doc__ = "Floating point notation format for representing the position and velocity information."
CCSDSEphemerisFormatType.SCIENTIFIC_NOTATION.__doc__ = "Scientific notation format for representing the position and velocity information."

agcls.AgTypeNameMap["CCSDSEphemerisFormatType"] = CCSDSEphemerisFormatType

class CCSDSTimeSystem(IntEnum):
    """Time System."""

    UTC = 0
    """UTC time system."""
    TAI = 1
    """TAI time system."""
    GPS = 2
    """GPS time system."""
    TT = 3
    """TT time system."""
    TDB = 4
    """TDB time system."""

CCSDSTimeSystem.UTC.__doc__ = "UTC time system."
CCSDSTimeSystem.TAI.__doc__ = "TAI time system."
CCSDSTimeSystem.GPS.__doc__ = "GPS time system."
CCSDSTimeSystem.TT.__doc__ = "TT time system."
CCSDSTimeSystem.TDB.__doc__ = "TDB time system."

agcls.AgTypeNameMap["CCSDSTimeSystem"] = CCSDSTimeSystem

class EphemerisCoordinateSystemType(IntEnum):
    """The Coordinate System of the file."""

    FIXED = 0
    """Fixed reference frame."""
    INERTIAL = 1
    """Inertial reference frame."""
    J2000 = 2
    """J2000 reference frame."""
    ICRF = 3
    """ICRF reference frame."""
    TRUE_OF_DATE = 4
    """TrueOfDate reference frame."""
    MEAN_EARTH = 5
    """MeanEarth reference frame (valid for Moon only)."""
    TEME_OF_DATE = 6
    """TEMEOfDate reference frame (valid for Earth only)."""
    ITRF2000 = 7
    """ITRF2000 reference frame (valid for Earth only)."""
    ITRF2005 = 8
    """ITRF2005 reference frame (valid for Earth only)."""
    ITRF2008 = 9
    """ITRF2008 reference frame (valid for Earth only)."""
    ITRF2014 = 10
    """ITRF2014 reference frame (valid for Earth only)."""
    ITRF2020 = 11
    """ITRF2020 reference frame (valid for Earth only)."""

EphemerisCoordinateSystemType.FIXED.__doc__ = "Fixed reference frame."
EphemerisCoordinateSystemType.INERTIAL.__doc__ = "Inertial reference frame."
EphemerisCoordinateSystemType.J2000.__doc__ = "J2000 reference frame."
EphemerisCoordinateSystemType.ICRF.__doc__ = "ICRF reference frame."
EphemerisCoordinateSystemType.TRUE_OF_DATE.__doc__ = "TrueOfDate reference frame."
EphemerisCoordinateSystemType.MEAN_EARTH.__doc__ = "MeanEarth reference frame (valid for Moon only)."
EphemerisCoordinateSystemType.TEME_OF_DATE.__doc__ = "TEMEOfDate reference frame (valid for Earth only)."
EphemerisCoordinateSystemType.ITRF2000.__doc__ = "ITRF2000 reference frame (valid for Earth only)."
EphemerisCoordinateSystemType.ITRF2005.__doc__ = "ITRF2005 reference frame (valid for Earth only)."
EphemerisCoordinateSystemType.ITRF2008.__doc__ = "ITRF2008 reference frame (valid for Earth only)."
EphemerisCoordinateSystemType.ITRF2014.__doc__ = "ITRF2014 reference frame (valid for Earth only)."
EphemerisCoordinateSystemType.ITRF2020.__doc__ = "ITRF2020 reference frame (valid for Earth only)."

agcls.AgTypeNameMap["EphemerisCoordinateSystemType"] = EphemerisCoordinateSystemType

class EphemerisCovarianceType(IntEnum):
    """The covariance data export type."""

    NONE = 0
    """No covariance data."""
    POSITION_3_BY_3 = 1
    """Position covariance data."""
    POSITION_VELOCITY_6_BY_6 = 2
    """Position/velocity covariance data."""

EphemerisCovarianceType.NONE.__doc__ = "No covariance data."
EphemerisCovarianceType.POSITION_3_BY_3.__doc__ = "Position covariance data."
EphemerisCovarianceType.POSITION_VELOCITY_6_BY_6.__doc__ = "Position/velocity covariance data."

agcls.AgTypeNameMap["EphemerisCovarianceType"] = EphemerisCovarianceType

class ExportToolVersionFormat(IntEnum):
    """The version format of the file."""

    FORMAT410 = 0
    """STK 4.1 format."""
    FORMAT420 = 1
    """STK 4.2 format."""
    FORMAT430 = 2
    """STK 4.3 format."""
    FORMAT600 = 3
    """STK 6.0 format."""
    FORMAT620 = 4
    """STK 6.2 format."""
    CURRENT = 5
    """The current STK format."""
    FORMAT800 = 6
    """STK 8.0 format."""

ExportToolVersionFormat.FORMAT410.__doc__ = "STK 4.1 format."
ExportToolVersionFormat.FORMAT420.__doc__ = "STK 4.2 format."
ExportToolVersionFormat.FORMAT430.__doc__ = "STK 4.3 format."
ExportToolVersionFormat.FORMAT600.__doc__ = "STK 6.0 format."
ExportToolVersionFormat.FORMAT620.__doc__ = "STK 6.2 format."
ExportToolVersionFormat.CURRENT.__doc__ = "The current STK format."
ExportToolVersionFormat.FORMAT800.__doc__ = "STK 8.0 format."

agcls.AgTypeNameMap["ExportToolVersionFormat"] = ExportToolVersionFormat

class ExportToolTimePeriodType(IntEnum):
    """Values of the enumeration represent polymorphic object types."""

    SPECIFY = 0
    """Create a data file using specified Start and Stop Times."""
    USE_ENTIRE_EPHEMERIS = 1
    """Create a data file using the Start and Stop Time specified in the vehicle's Orbit page."""

ExportToolTimePeriodType.SPECIFY.__doc__ = "Create a data file using specified Start and Stop Times."
ExportToolTimePeriodType.USE_ENTIRE_EPHEMERIS.__doc__ = "Create a data file using the Start and Stop Time specified in the vehicle's Orbit page."

agcls.AgTypeNameMap["ExportToolTimePeriodType"] = ExportToolTimePeriodType

class SpiceInterpolation(IntEnum):
    """The SPICE interpolation type."""

    LAGRANGE_9TH_ORDER = 0
    """Type 9 (LaGrangian)."""
    HERMITE_13TH_ORDER = 1
    """Type 13 (Hermitian)."""

SpiceInterpolation.LAGRANGE_9TH_ORDER.__doc__ = "Type 9 (LaGrangian)."
SpiceInterpolation.HERMITE_13TH_ORDER.__doc__ = "Type 13 (Hermitian)."

agcls.AgTypeNameMap["SpiceInterpolation"] = SpiceInterpolation

class AttitudeCoordinateAxes(IntEnum):
    """Attitude export options."""

    CUSTOM = 0
    """Custom reference axes."""
    FIXED = 1
    """The Fixed frame of a central body is the frame in which its topography is expressed."""
    J2000 = 2
    """Mean Equator and Mean Equinox of the J2000 epoch (JD 2451545.0 TDB which is 1 Jan 2000 12:00:00.000 TDB). The J2000 axes were considered the best realized inertial axes until the development of the ICRF."""
    ICRF = 3
    """International Celestial Reference Frame. The ICRF axes are defined as the inertial (i.e., kinematically non-rotating) axes associated with a general relativity frame centered at the solar system barycenter (often called the BCRF)."""
    INERTIAL = 4
    """Each central body defines its own Inertial frame computed as a constant rotation from the ICRF frame. Earth and Sun both define their Inertial frames as ICRF itself (i.e., no rotation) and do not provide an additional frame named Inertial."""

AttitudeCoordinateAxes.CUSTOM.__doc__ = "Custom reference axes."
AttitudeCoordinateAxes.FIXED.__doc__ = "The Fixed frame of a central body is the frame in which its topography is expressed."
AttitudeCoordinateAxes.J2000.__doc__ = "Mean Equator and Mean Equinox of the J2000 epoch (JD 2451545.0 TDB which is 1 Jan 2000 12:00:00.000 TDB). The J2000 axes were considered the best realized inertial axes until the development of the ICRF."
AttitudeCoordinateAxes.ICRF.__doc__ = "International Celestial Reference Frame. The ICRF axes are defined as the inertial (i.e., kinematically non-rotating) axes associated with a general relativity frame centered at the solar system barycenter (often called the BCRF)."
AttitudeCoordinateAxes.INERTIAL.__doc__ = "Each central body defines its own Inertial frame computed as a constant rotation from the ICRF frame. Earth and Sun both define their Inertial frames as ICRF itself (i.e., no rotation) and do not provide an additional frame named Inertial."

agcls.AgTypeNameMap["AttitudeCoordinateAxes"] = AttitudeCoordinateAxes

class AttitudeInclude(IntEnum):
    """Details to include in an exported Attitude file."""

    QUATERNIONS = 0
    """Include quaternions with the exported data."""
    QUATERNIONS_AND_ANGULAR_VELOCITY = 1
    """Include quaternions and angular velocity with the exported data."""

AttitudeInclude.QUATERNIONS.__doc__ = "Include quaternions with the exported data."
AttitudeInclude.QUATERNIONS_AND_ANGULAR_VELOCITY.__doc__ = "Include quaternions and angular velocity with the exported data."

agcls.AgTypeNameMap["AttitudeInclude"] = AttitudeInclude

class ExportToolStepSizeType(IntEnum):
    """The Step Size type for an attitude file."""

    EPHEMERIS = 0
    """The Step Size specified in the vehicle's Basic properties."""
    SPECIFY = 1
    """A specified Step Size to be used for the vehicle."""
    NATIVE = 2
    """The Step Size specified in the vehicle's Basic properties plus any additional times at which the vehicle's attitude changes abruptly. Creates a more complete attitude file without requiring the use of a very small, performance-reducing step size."""
    TIME_ARRAY = 3
    """The Step Size specified in time array component for the vehicle."""

ExportToolStepSizeType.EPHEMERIS.__doc__ = "The Step Size specified in the vehicle's Basic properties."
ExportToolStepSizeType.SPECIFY.__doc__ = "A specified Step Size to be used for the vehicle."
ExportToolStepSizeType.NATIVE.__doc__ = "The Step Size specified in the vehicle's Basic properties plus any additional times at which the vehicle's attitude changes abruptly. Creates a more complete attitude file without requiring the use of a very small, performance-reducing step size."
ExportToolStepSizeType.TIME_ARRAY.__doc__ = "The Step Size specified in time array component for the vehicle."

agcls.AgTypeNameMap["ExportToolStepSizeType"] = ExportToolStepSizeType

class TextOutlineStyle(IntEnum):
    """The text outline style for 2D graphics display."""

    UNKNOWN = -1
    """Unknown text outline for 2D graphics display."""
    NONE = 0
    """No text outline for 2D graphics display."""
    THICK = 1
    """Thick text outline for 2D graphics display."""
    THIN = 2
    """Thin text outline for 2D graphics display."""

TextOutlineStyle.UNKNOWN.__doc__ = "Unknown text outline for 2D graphics display."
TextOutlineStyle.NONE.__doc__ = "No text outline for 2D graphics display."
TextOutlineStyle.THICK.__doc__ = "Thick text outline for 2D graphics display."
TextOutlineStyle.THIN.__doc__ = "Thin text outline for 2D graphics display."

agcls.AgTypeNameMap["TextOutlineStyle"] = TextOutlineStyle

class MTORangeMode(IntEnum):
    """MTO Range Mode."""

    EACH = 2
    """For every track, returns the track id, 1 (within range) or 0 (not in range), and the range value in Connect distance units."""
    EACH_IN_RANGE = 3
    """Return the Track_id for each track in range, a 1 and the range value in Connect distance units."""
    EACH_NOT_IN_RANGE = 4
    """Return the Track_id for each track not in range, a 0 and the range value in Connect distance units."""

MTORangeMode.EACH.__doc__ = "For every track, returns the track id, 1 (within range) or 0 (not in range), and the range value in Connect distance units."
MTORangeMode.EACH_IN_RANGE.__doc__ = "Return the Track_id for each track in range, a 1 and the range value in Connect distance units."
MTORangeMode.EACH_NOT_IN_RANGE.__doc__ = "Return the Track_id for each track not in range, a 0 and the range value in Connect distance units."

agcls.AgTypeNameMap["MTORangeMode"] = MTORangeMode

class MTOTrackEvaluationType(IntEnum):
    """MTO Track Eval Mode."""

    ALL = 0
    """Return 1 if every track is within range otherwise it returns 0."""
    ANY = 1
    """Return 1 if any track is in range of the Object, (ie, lowerLimit <= range <= upperLimit) else returns 0."""

MTOTrackEvaluationType.ALL.__doc__ = "Return 1 if every track is within range otherwise it returns 0."
MTOTrackEvaluationType.ANY.__doc__ = "Return 1 if any track is in range of the Object, (ie, lowerLimit <= range <= upperLimit) else returns 0."

agcls.AgTypeNameMap["MTOTrackEvaluationType"] = MTOTrackEvaluationType

class MTOEntirety(IntEnum):
    """MTO Entirety Mode."""

    ALL = 0
    """Return 1 if every track is within field of view otherwise it returns 0."""
    PARTIAL = 1
    """Return 1 if any track is within field of view to the Object else returns 0."""

MTOEntirety.ALL.__doc__ = "Return 1 if every track is within field of view otherwise it returns 0."
MTOEntirety.PARTIAL.__doc__ = "Return 1 if any track is within field of view to the Object else returns 0."

agcls.AgTypeNameMap["MTOEntirety"] = MTOEntirety

class MTOVisibilityMode(IntEnum):
    """MTO Visibility Mode."""

    EACH = 2
    """Return the Track_id and 1 or 0 for every track; where 1 indicates the track is visible and 0 indicates it is not."""
    EACH_VISIBLE = 3
    """Return the Track_id and 1 only for those tracks having visibility. If all objects are invisible then the message 'No Visibility' is returned."""
    EACH_NOT_VISIBLE = 4
    """Return the Track_id and 0 for those tracks not having visibility. If all objects are visible then the message 'Complete Visibility' is returned."""

MTOVisibilityMode.EACH.__doc__ = "Return the Track_id and 1 or 0 for every track; where 1 indicates the track is visible and 0 indicates it is not."
MTOVisibilityMode.EACH_VISIBLE.__doc__ = "Return the Track_id and 1 only for those tracks having visibility. If all objects are invisible then the message 'No Visibility' is returned."
MTOVisibilityMode.EACH_NOT_VISIBLE.__doc__ = "Return the Track_id and 0 for those tracks not having visibility. If all objects are visible then the message 'Complete Visibility' is returned."

agcls.AgTypeNameMap["MTOVisibilityMode"] = MTOVisibilityMode

class MTOObjectInterval(IntEnum):
    """MTO object interval type."""

    NORMAL = 0
    """Default visibility interval."""
    EXTENDED = 1
    """Use the last point of the ephemeris span of the object for times past the last point."""

MTOObjectInterval.NORMAL.__doc__ = "Default visibility interval."
MTOObjectInterval.EXTENDED.__doc__ = "Use the last point of the ephemeris span of the object for times past the last point."

agcls.AgTypeNameMap["MTOObjectInterval"] = MTOObjectInterval

class MTOInputDataType(IntEnum):
    """MTO Input Data Type."""

    DETIC = 0
    """Input position data arrays are lat, lon, alt."""
    CARTESIAN_IN_CENTRAL_BODY_FIXED = 1
    """Input position data arrays are cartesian x, y, z in the MTO's central body fixed frame."""
    CARTESIAN_IN_VECTOR_GEOMETRY_TOOL_SYSTEM = 2
    """Input position data arrays are cartesian x, y, z in the MTO's specified data reference system."""

MTOInputDataType.DETIC.__doc__ = "Input position data arrays are lat, lon, alt."
MTOInputDataType.CARTESIAN_IN_CENTRAL_BODY_FIXED.__doc__ = "Input position data arrays are cartesian x, y, z in the MTO's central body fixed frame."
MTOInputDataType.CARTESIAN_IN_VECTOR_GEOMETRY_TOOL_SYSTEM.__doc__ = "Input position data arrays are cartesian x, y, z in the MTO's specified data reference system."

agcls.AgTypeNameMap["MTOInputDataType"] = MTOInputDataType

class SolidTide(IntEnum):
    """The Solid Tide Type for force modeling."""

    FULL = 0
    """Include both time-dependent and time-independent contributions. This option is only available for gravity field models that support a tide model."""
    PERMANENT_ONLY = 1
    """Include only the permanent tide - the time-independent contribution."""
    NONE = 2
    """Exclude solid tide contributions entirely."""

SolidTide.FULL.__doc__ = "Include both time-dependent and time-independent contributions. This option is only available for gravity field models that support a tide model."
SolidTide.PERMANENT_ONLY.__doc__ = "Include only the permanent tide - the time-independent contribution."
SolidTide.NONE.__doc__ = "Exclude solid tide contributions entirely."

agcls.AgTypeNameMap["SolidTide"] = SolidTide

class TimePeriodValueType(IntEnum):
    """Time value types."""

    TODAY = 1
    """The current day."""
    TOMORROW = 2
    """Tomorrow, from the current day."""
    SPECIFY = 3
    """Specified time period."""
    DURATION = 4
    """Time period defined as a duration."""
    NOON_TODAY = 5
    """Noon of the current day."""
    NOON_TOMORROW = 6
    """Noon of tomorrow, from the current day."""

TimePeriodValueType.TODAY.__doc__ = "The current day."
TimePeriodValueType.TOMORROW.__doc__ = "Tomorrow, from the current day."
TimePeriodValueType.SPECIFY.__doc__ = "Specified time period."
TimePeriodValueType.DURATION.__doc__ = "Time period defined as a duration."
TimePeriodValueType.NOON_TODAY.__doc__ = "Noon of the current day."
TimePeriodValueType.NOON_TOMORROW.__doc__ = "Noon of tomorrow, from the current day."

agcls.AgTypeNameMap["TimePeriodValueType"] = TimePeriodValueType

class OnePointAccessStatus(IntEnum):
    """One point access status."""

    MAXIMUM = -10
    """Constraint value violates max limit of the min-max constraint."""
    MINIMUM = -11
    """Constraint value violates min limit of the min-max constraint."""
    ZERO = -20
    """Constraint value violates limit of the zero threshold constraint."""
    LOGICAL = -30
    """Constraint value violates limit of the logical threshold constraint."""
    INCLUSION_INTERVAL = -40
    """Constraint value lies outside inclusion intervals."""
    EXCLUSION_INTERVAL = -41
    """Constraint value lies outside exclusion intervals."""
    OK = 0
    """Constraint value is within the constraint limits."""
    NOT_COMPUTED = -1
    """Constraint value is not computed (may occur for constraints that are not evaluated in Fast mode)."""

OnePointAccessStatus.MAXIMUM.__doc__ = "Constraint value violates max limit of the min-max constraint."
OnePointAccessStatus.MINIMUM.__doc__ = "Constraint value violates min limit of the min-max constraint."
OnePointAccessStatus.ZERO.__doc__ = "Constraint value violates limit of the zero threshold constraint."
OnePointAccessStatus.LOGICAL.__doc__ = "Constraint value violates limit of the logical threshold constraint."
OnePointAccessStatus.INCLUSION_INTERVAL.__doc__ = "Constraint value lies outside inclusion intervals."
OnePointAccessStatus.EXCLUSION_INTERVAL.__doc__ = "Constraint value lies outside exclusion intervals."
OnePointAccessStatus.OK.__doc__ = "Constraint value is within the constraint limits."
OnePointAccessStatus.NOT_COMPUTED.__doc__ = "Constraint value is not computed (may occur for constraints that are not evaluated in Fast mode)."

agcls.AgTypeNameMap["OnePointAccessStatus"] = OnePointAccessStatus

class OnePointAccessSummary(IntEnum):
    """One point access summary type."""

    DETAILED = 0
    """Set Compute to return detailed information about each constraint that is evaluated in addition to the access result."""
    FAST = 1
    """Set Compute to return basic information about each constraint that is evaluated in addition to the access result."""
    RESULT_ONLY = 2
    """Set Compute to return just a Yes or No indicating the constraints are satisfied at the current animation time, or the time specified."""

OnePointAccessSummary.DETAILED.__doc__ = "Set Compute to return detailed information about each constraint that is evaluated in addition to the access result."
OnePointAccessSummary.FAST.__doc__ = "Set Compute to return basic information about each constraint that is evaluated in addition to the access result."
OnePointAccessSummary.RESULT_ONLY.__doc__ = "Set Compute to return just a Yes or No indicating the constraints are satisfied at the current animation time, or the time specified."

agcls.AgTypeNameMap["OnePointAccessSummary"] = OnePointAccessSummary

class LookAheadPropagator(IntEnum):
    """Propagators used for calculating ephemeris for look ahead purposes. The enumeration is used with realtime propagators."""

    UNKNOWN = -1
    """Reserved for look ahead propagators that are not currently supported."""
    HOLD_CENTRAL_BODY_INERTIAL_POSITION = 0
    """The HoldCBIPosition look ahead propagator keeps position and velocity constant in the inertial (i.e., CBI) frame."""
    HOLD_CENTRAL_BODY_FIXED_POSITION = 1
    """The HoldCBFPosition look ahead propagator keeps position and velocity constant in the fixed (i.e., CBF) frame."""
    TWO_BODY = 2
    """Two-Body is an analytical propagator that generates ephemeris by evaluating a formula."""
    J2_PERTURBATION = 3
    """The J2 Perturbation (first-order) propagator accounts for secular variations in the orbit elements due to Earth oblateness."""
    J4_PERTURBATION = 4
    """The J4 Perturbation (second-order) propagator accounts for secular variations in the orbit elements due to Earth oblateness."""
    DEAD_RECKONING = 5
    """The DeadReckon look ahead propagator projects the motion of the vehicle along a straight line, along the last velocity vector."""
    BALLISTIC = 6
    """The Ballistic Propagator defines an elliptical path that begins and ends at the Earth's surface. Specifying a fixed flight time, initial velocity or altitude can further refine the shape of the trajectory."""

LookAheadPropagator.UNKNOWN.__doc__ = "Reserved for look ahead propagators that are not currently supported."
LookAheadPropagator.HOLD_CENTRAL_BODY_INERTIAL_POSITION.__doc__ = "The HoldCBIPosition look ahead propagator keeps position and velocity constant in the inertial (i.e., CBI) frame."
LookAheadPropagator.HOLD_CENTRAL_BODY_FIXED_POSITION.__doc__ = "The HoldCBFPosition look ahead propagator keeps position and velocity constant in the fixed (i.e., CBF) frame."
LookAheadPropagator.TWO_BODY.__doc__ = "Two-Body is an analytical propagator that generates ephemeris by evaluating a formula."
LookAheadPropagator.J2_PERTURBATION.__doc__ = "The J2 Perturbation (first-order) propagator accounts for secular variations in the orbit elements due to Earth oblateness."
LookAheadPropagator.J4_PERTURBATION.__doc__ = "The J4 Perturbation (second-order) propagator accounts for secular variations in the orbit elements due to Earth oblateness."
LookAheadPropagator.DEAD_RECKONING.__doc__ = "The DeadReckon look ahead propagator projects the motion of the vehicle along a straight line, along the last velocity vector."
LookAheadPropagator.BALLISTIC.__doc__ = "The Ballistic Propagator defines an elliptical path that begins and ends at the Earth's surface. Specifying a fixed flight time, initial velocity or altitude can further refine the shape of the trajectory."

agcls.AgTypeNameMap["LookAheadPropagator"] = LookAheadPropagator

class Graphics3DMarkerOrientation(IntEnum):
    """3D graphics marker orientations."""

    NONE = 0
    """Marker does not rotate."""
    ANGLE = 1
    """Counterclockwise rotation of the marker by the specified angle value."""
    FOLLOW_DIRECTION = 2
    """Marker follows the velocity vector."""

Graphics3DMarkerOrientation.NONE.__doc__ = "Marker does not rotate."
Graphics3DMarkerOrientation.ANGLE.__doc__ = "Counterclockwise rotation of the marker by the specified angle value."
Graphics3DMarkerOrientation.FOLLOW_DIRECTION.__doc__ = "Marker follows the velocity vector."

agcls.AgTypeNameMap["Graphics3DMarkerOrientation"] = Graphics3DMarkerOrientation

class SolarRadiationPressureModelType(IntEnum):
    """Solar radiation pressure model types."""

    UNKNOWN = -1
    """Unsupported model."""
    GPS_BLKIIA_AEROSPACE_T20 = 0
    """Aerospace T20 solar radiation pressure model for GPS block IIA."""
    GPS_BLKIIA_GSPM04A = 1
    """Bar-Sever GPS Solar Pressure Model 04a for block IIA."""
    GPS_BLKIIA_GSPM04AE = 2
    """Bar-Sever GPS Solar Pressure Model 04a for block IIA."""
    GPS_BLKIIA_AEROSPACE_T30 = 3
    """Aerospace T30 solar radiation pressure model for GPS block IIR."""
    GPS_BLKIIR_GSPM04A = 4
    """Bar-Sever GPS Solar Pressure Model 04a for block IIR."""
    GPS_BLKIIR_GSPM04AE = 5
    """Bar-Sever GPS Solar Pressure Model 04ae for block IIR."""
    SPHERICAL = 6
    """Solar radiation pressure model that assumes a spherical spacecraft."""
    PLUGIN = 7
    """Plugin light reflection model."""

SolarRadiationPressureModelType.UNKNOWN.__doc__ = "Unsupported model."
SolarRadiationPressureModelType.GPS_BLKIIA_AEROSPACE_T20.__doc__ = "Aerospace T20 solar radiation pressure model for GPS block IIA."
SolarRadiationPressureModelType.GPS_BLKIIA_GSPM04A.__doc__ = "Bar-Sever GPS Solar Pressure Model 04a for block IIA."
SolarRadiationPressureModelType.GPS_BLKIIA_GSPM04AE.__doc__ = "Bar-Sever GPS Solar Pressure Model 04a for block IIA."
SolarRadiationPressureModelType.GPS_BLKIIA_AEROSPACE_T30.__doc__ = "Aerospace T30 solar radiation pressure model for GPS block IIR."
SolarRadiationPressureModelType.GPS_BLKIIR_GSPM04A.__doc__ = "Bar-Sever GPS Solar Pressure Model 04a for block IIR."
SolarRadiationPressureModelType.GPS_BLKIIR_GSPM04AE.__doc__ = "Bar-Sever GPS Solar Pressure Model 04ae for block IIR."
SolarRadiationPressureModelType.SPHERICAL.__doc__ = "Solar radiation pressure model that assumes a spherical spacecraft."
SolarRadiationPressureModelType.PLUGIN.__doc__ = "Plugin light reflection model."

agcls.AgTypeNameMap["SolarRadiationPressureModelType"] = SolarRadiationPressureModelType

class DragModel(IntEnum):
    """Drag model types."""

    UNKNOWN = -1
    """Unsupported model."""
    SPHERICAL = 0
    """Drag model that assumes a spherical spacecraft."""
    PLUGIN = 1
    """Plugin drag model."""

DragModel.UNKNOWN.__doc__ = "Unsupported model."
DragModel.SPHERICAL.__doc__ = "Drag model that assumes a spherical spacecraft."
DragModel.PLUGIN.__doc__ = "Plugin drag model."

agcls.AgTypeNameMap["DragModel"] = DragModel

class VehiclePropagationFrame(IntEnum):
    """Propagation frames used by J2/J4/TwoBody propagators."""

    UNKNOWN = -1
    """Unknown propagation frame."""
    INERTIAL = 0
    """Inertial propagation frame."""
    TRUE_OF_DATE = 1
    """True Of Date propagation frame."""
    TRUE_OF_EPOCH = 2
    """True Of Epoch propagation frame."""

VehiclePropagationFrame.UNKNOWN.__doc__ = "Unknown propagation frame."
VehiclePropagationFrame.INERTIAL.__doc__ = "Inertial propagation frame."
VehiclePropagationFrame.TRUE_OF_DATE.__doc__ = "True Of Date propagation frame."
VehiclePropagationFrame.TRUE_OF_EPOCH.__doc__ = "True Of Epoch propagation frame."

agcls.AgTypeNameMap["VehiclePropagationFrame"] = VehiclePropagationFrame

class StarReferenceFrame(IntEnum):
    """Star reference frame types."""

    ICRF = 0
    """ICRF reference frame."""
    J2000 = 1
    """J2000 reference frame."""

StarReferenceFrame.ICRF.__doc__ = "ICRF reference frame."
StarReferenceFrame.J2000.__doc__ = "J2000 reference frame."

agcls.AgTypeNameMap["StarReferenceFrame"] = StarReferenceFrame

class GPSReferenceWeek(IntEnum):
    """GPS almanac reference week."""

    UNKNOWN = -1
    """Unknown week reference."""
    WEEK22_AUG1999 = 0
    """22 Aug 1999."""
    WEEK06_JAN1980 = 1
    """06 Jan 1980."""
    WEEK07_APR2019 = 2
    """07 Apr 2019."""

GPSReferenceWeek.UNKNOWN.__doc__ = "Unknown week reference."
GPSReferenceWeek.WEEK22_AUG1999.__doc__ = "22 Aug 1999."
GPSReferenceWeek.WEEK06_JAN1980.__doc__ = "06 Jan 1980."
GPSReferenceWeek.WEEK07_APR2019.__doc__ = "07 Apr 2019."

agcls.AgTypeNameMap["GPSReferenceWeek"] = GPSReferenceWeek

class CoverageCustomRegionAlgorithm(IntEnum):
    """The enumerations are used to enable/disable the special gridding algorithms triggered when Custom Region grid includes a single small region (longitude span less than 1 deg)."""

    UNKNOWN = -1
    """Unsupported algorithm."""
    DISABLED = 0
    """Disabled."""
    ANISOTROPIC = 1
    """Anisotropic."""
    ISOTROPIC = 2
    """Isotropic."""

CoverageCustomRegionAlgorithm.UNKNOWN.__doc__ = "Unsupported algorithm."
CoverageCustomRegionAlgorithm.DISABLED.__doc__ = "Disabled."
CoverageCustomRegionAlgorithm.ANISOTROPIC.__doc__ = "Anisotropic."
CoverageCustomRegionAlgorithm.ISOTROPIC.__doc__ = "Isotropic."

agcls.AgTypeNameMap["CoverageCustomRegionAlgorithm"] = CoverageCustomRegionAlgorithm

class VehicleGPSSwitchMethod(IntEnum):
    """GPS Switch method for the GPS propagator."""

    EPOCH = 0
    """Switch between TLE sets based on the epoch of the TLE."""
    MIDPOINT = 1
    """Switch between TLE sets based on the mid-point between two TLE epochs."""
    TIME_OF_CLOSEST_APPROACH = 2
    """Switch between TLE sets based on the time of closest approach, calculated by propagating the first and second TLE sets over the time period between their respective epochs and determining the point at which the two paths are nearest each other."""

VehicleGPSSwitchMethod.EPOCH.__doc__ = "Switch between TLE sets based on the epoch of the TLE."
VehicleGPSSwitchMethod.MIDPOINT.__doc__ = "Switch between TLE sets based on the mid-point between two TLE epochs."
VehicleGPSSwitchMethod.TIME_OF_CLOSEST_APPROACH.__doc__ = "Switch between TLE sets based on the time of closest approach, calculated by propagating the first and second TLE sets over the time period between their respective epochs and determining the point at which the two paths are nearest each other."

agcls.AgTypeNameMap["VehicleGPSSwitchMethod"] = VehicleGPSSwitchMethod

class VehicleGPSElementSelectionType(IntEnum):
    """GPS Selection method for the GPS propagator."""

    USE_ALL = 0
    """Use all relevant TLEs."""
    USE_FIRST = 1
    """Use first relevant TLE."""

VehicleGPSElementSelectionType.USE_ALL.__doc__ = "Use all relevant TLEs."
VehicleGPSElementSelectionType.USE_FIRST.__doc__ = "Use first relevant TLE."

agcls.AgTypeNameMap["VehicleGPSElementSelectionType"] = VehicleGPSElementSelectionType

class VehicleGPSAutomaticUpdateSourceType(IntEnum):
    """The sources to retrieve GPS elements from upon propagation."""

    UNKNOWN = -1
    """Unknown or unsupported TLE source."""
    ONLINE = 0
    """Auto update the GPS propagator with GPS elements from an online source (AGI server)."""
    FILE = 2
    """Auto update the GPS propagator with GPS elements from file."""
    NONE = 3
    """Manually specify the almanac with GPS elements."""

VehicleGPSAutomaticUpdateSourceType.UNKNOWN.__doc__ = "Unknown or unsupported TLE source."
VehicleGPSAutomaticUpdateSourceType.ONLINE.__doc__ = "Auto update the GPS propagator with GPS elements from an online source (AGI server)."
VehicleGPSAutomaticUpdateSourceType.FILE.__doc__ = "Auto update the GPS propagator with GPS elements from file."
VehicleGPSAutomaticUpdateSourceType.NONE.__doc__ = "Manually specify the almanac with GPS elements."

agcls.AgTypeNameMap["VehicleGPSAutomaticUpdateSourceType"] = VehicleGPSAutomaticUpdateSourceType

class VehicleGPSAlmanacType(IntEnum):
    """GPS Almanac types."""

    NONE = -1
    """Almanac is not selected."""
    YUMA = 0
    """YUMA almanac."""
    SEM = 1
    """SEM almanac."""
    SP3 = 2
    """SP3 almanac."""

VehicleGPSAlmanacType.NONE.__doc__ = "Almanac is not selected."
VehicleGPSAlmanacType.YUMA.__doc__ = "YUMA almanac."
VehicleGPSAlmanacType.SEM.__doc__ = "SEM almanac."
VehicleGPSAlmanacType.SP3.__doc__ = "SP3 almanac."

agcls.AgTypeNameMap["VehicleGPSAlmanacType"] = VehicleGPSAlmanacType

class ExternalEphemerisFormatType(IntEnum):
    """Ephemeris file formats supported by the Stk external propagator."""

    UNKNOWN = -1
    """Unsupported ephemeris format."""
    STK = 0
    """ASCII text file formatted for compatibility with STK that ends with '.e' extension."""
    CCSDS = 1
    """CCSDS orbit ephemeris file format that ends with '.oem' extension."""
    ITC = 2
    """Define a file format that ends with '.itc' extension. The file type is utilized by some Air Force entities and requires USGOV license."""
    STK_BINARY = 3
    """STK Binary ephemeris file format that ends with '.be' extension."""
    CODE500 = 4
    """Code500 ephemeris file format that ends with '.EPH' extension."""
    CCSDS_V2 = 5
    """CCSDS v2 orbit ephemeris file format that ends with '.oem' extension."""

ExternalEphemerisFormatType.UNKNOWN.__doc__ = "Unsupported ephemeris format."
ExternalEphemerisFormatType.STK.__doc__ = "ASCII text file formatted for compatibility with STK that ends with '.e' extension."
ExternalEphemerisFormatType.CCSDS.__doc__ = "CCSDS orbit ephemeris file format that ends with '.oem' extension."
ExternalEphemerisFormatType.ITC.__doc__ = "Define a file format that ends with '.itc' extension. The file type is utilized by some Air Force entities and requires USGOV license."
ExternalEphemerisFormatType.STK_BINARY.__doc__ = "STK Binary ephemeris file format that ends with '.be' extension."
ExternalEphemerisFormatType.CODE500.__doc__ = "Code500 ephemeris file format that ends with '.EPH' extension."
ExternalEphemerisFormatType.CCSDS_V2.__doc__ = "CCSDS v2 orbit ephemeris file format that ends with '.oem' extension."

agcls.AgTypeNameMap["ExternalEphemerisFormatType"] = ExternalEphemerisFormatType

class ExternalFileMessageLevelType(IntEnum):
    """Ephemeris file message level used by the Stk external propagator."""

    UNKNOWN = -1
    """Unsupported message level."""
    ERRORS = 0
    """Message level to report only errors found during file loading."""
    WARNINGS = 1
    """Message level to report errors and warnings found during file loading."""
    VERBOSE = 2
    """Message level to report errors and warnings found during file loading and provide a success message when finding no issues."""

ExternalFileMessageLevelType.UNKNOWN.__doc__ = "Unsupported message level."
ExternalFileMessageLevelType.ERRORS.__doc__ = "Message level to report only errors found during file loading."
ExternalFileMessageLevelType.WARNINGS.__doc__ = "Message level to report errors and warnings found during file loading."
ExternalFileMessageLevelType.VERBOSE.__doc__ = "Message level to report errors and warnings found during file loading and provide a success message when finding no issues."

agcls.AgTypeNameMap["ExternalFileMessageLevelType"] = ExternalFileMessageLevelType

class Coverage3dDrawAtAltitudeMode(IntEnum):
    """Coverage definition drawing modes for filled graphics when showing at altitude in 3D Graphics window."""

    FRONT_FACING = 0
    """Draw front facing only."""
    BACK_FACING = 1
    """Draw back facing only."""
    FRONT_AND_BACK_FACING = 2
    """Draw front and back facing."""

Coverage3dDrawAtAltitudeMode.FRONT_FACING.__doc__ = "Draw front facing only."
Coverage3dDrawAtAltitudeMode.BACK_FACING.__doc__ = "Draw back facing only."
Coverage3dDrawAtAltitudeMode.FRONT_AND_BACK_FACING.__doc__ = "Draw front and back facing."

agcls.AgTypeNameMap["Coverage3dDrawAtAltitudeMode"] = Coverage3dDrawAtAltitudeMode

class DistanceOnSphere(IntEnum):
    """Type of line which connects the two points."""

    GREAT_CIRCLE = 0
    """Shortest distance between two points on the globe."""
    RHUMB_LINE = 1
    """Lines of constant bearing."""

DistanceOnSphere.GREAT_CIRCLE.__doc__ = "Shortest distance between two points on the globe."
DistanceOnSphere.RHUMB_LINE.__doc__ = "Lines of constant bearing."

agcls.AgTypeNameMap["DistanceOnSphere"] = DistanceOnSphere

class FigureOfMeritInvalidValueActionType(IntEnum):
    """Invalid Value Action: Controls consideration of time samples usage for computing navigation solution when insufficient number of assets are available at one or more of the time samples used."""

    IGNORE = 0
    """Ignore: Time samples are ignored and not included in the computation of navigation solution."""
    INCLUDE = 1
    """Include: Time samples are included in the computation of navigation solution."""

FigureOfMeritInvalidValueActionType.IGNORE.__doc__ = "Ignore: Time samples are ignored and not included in the computation of navigation solution."
FigureOfMeritInvalidValueActionType.INCLUDE.__doc__ = "Include: Time samples are included in the computation of navigation solution."

agcls.AgTypeNameMap["FigureOfMeritInvalidValueActionType"] = FigureOfMeritInvalidValueActionType

class VehicleSlewTimingBetweenTargetType(IntEnum):
    """Choose an event within the window of opportunity to trigger each slew, or select Optimal to change attitude whenever the slew can be performed most efficiently."""

    UNKNOWN = -1
    """Unsupported or unknown slew option."""
    OPTIMAL = 0
    """Change attitude whenever the slew can be performed most efficiently."""
    SLEW_AFTER_TARGET_ACQUISITION = 1
    """Start slewing toward a new target after it is in view."""
    SLEW_AFTER_TARGET_LOSS = 2
    """Start slewing away from current target after it is out-of-view."""
    SLEW_BEFORE_TARGET_ACQUISITION = 3
    """Finish slewing toward a new target before it is in view."""
    SLEW_BEFORE_TARGET_LOSS = 4
    """Finish slewing away from current target before it is out-of-view."""

VehicleSlewTimingBetweenTargetType.UNKNOWN.__doc__ = "Unsupported or unknown slew option."
VehicleSlewTimingBetweenTargetType.OPTIMAL.__doc__ = "Change attitude whenever the slew can be performed most efficiently."
VehicleSlewTimingBetweenTargetType.SLEW_AFTER_TARGET_ACQUISITION.__doc__ = "Start slewing toward a new target after it is in view."
VehicleSlewTimingBetweenTargetType.SLEW_AFTER_TARGET_LOSS.__doc__ = "Start slewing away from current target after it is out-of-view."
VehicleSlewTimingBetweenTargetType.SLEW_BEFORE_TARGET_ACQUISITION.__doc__ = "Finish slewing toward a new target before it is in view."
VehicleSlewTimingBetweenTargetType.SLEW_BEFORE_TARGET_LOSS.__doc__ = "Finish slewing away from current target before it is out-of-view."

agcls.AgTypeNameMap["VehicleSlewTimingBetweenTargetType"] = VehicleSlewTimingBetweenTargetType

class VehicleSlewMode(IntEnum):
    """Target slew modes."""

    UNKNOWN = -1
    """Unknown or unsupported slew mode."""
    CONSTRAINED_2ND_ORDER_SPLINE = 0
    """2nd order spline interpolation mode."""
    CONSTRAINED_3RD_ORDER_SPLINE = 1
    """3d order spline interpolation mode."""
    FIXED_RATE = 2
    """A fixed rate slew."""
    FIXED_TIME = 3
    """A fixed time slew."""

VehicleSlewMode.UNKNOWN.__doc__ = "Unknown or unsupported slew mode."
VehicleSlewMode.CONSTRAINED_2ND_ORDER_SPLINE.__doc__ = "2nd order spline interpolation mode."
VehicleSlewMode.CONSTRAINED_3RD_ORDER_SPLINE.__doc__ = "3d order spline interpolation mode."
VehicleSlewMode.FIXED_RATE.__doc__ = "A fixed rate slew."
VehicleSlewMode.FIXED_TIME.__doc__ = "A fixed time slew."

agcls.AgTypeNameMap["VehicleSlewMode"] = VehicleSlewMode

class Component(IntEnum):
    """The different types of components in the component browser."""

    ALL = 0
    """Return all components. Currently not implemented."""
    COMMUNICATION = 1
    """Return only communication components."""
    ASTROGATOR = 2
    """Return only astrogator components."""
    RADAR = 3
    """Return only radar components."""
    COLLECTIONS = 4
    """Return collection components."""

Component.ALL.__doc__ = "Return all components. Currently not implemented."
Component.COMMUNICATION.__doc__ = "Return only communication components."
Component.ASTROGATOR.__doc__ = "Return only astrogator components."
Component.RADAR.__doc__ = "Return only radar components."
Component.COLLECTIONS.__doc__ = "Return collection components."

agcls.AgTypeNameMap["Component"] = Component

class VolumetricDefinitionType(IntEnum):
    """Volume grid definition types."""

    UNKNOWN = -1
    """Unknown volumetirc grid option."""
    GRID_SPATIAL_CALCULATION = 0
    """Volumetric : volume grid spatial calculations."""
    FILE = 1
    """Volumetric : volume external file."""

VolumetricDefinitionType.UNKNOWN.__doc__ = "Unknown volumetirc grid option."
VolumetricDefinitionType.GRID_SPATIAL_CALCULATION.__doc__ = "Volumetric : volume grid spatial calculations."
VolumetricDefinitionType.FILE.__doc__ = "Volumetric : volume external file."

agcls.AgTypeNameMap["VolumetricDefinitionType"] = VolumetricDefinitionType

class VolumetricSpatialCalculationEvaluationType(IntEnum):
    """Evaluation of Spatial Calculation types."""

    UNKNOWN = -1
    """Unknown Spatial Calculation evaluation type option."""
    AT_INSTANT_IN_TIME = 0
    """Evaluation of spatial calculation at instant in time."""
    AT_TIMES_FROM_TIME_ARRAY = 1
    """Evaluation of spatial calculation at times from time array."""
    AT_TIMES_AT_STEP_SIZE = 2
    """Evaluation of spatial calculation at times at step size."""

VolumetricSpatialCalculationEvaluationType.UNKNOWN.__doc__ = "Unknown Spatial Calculation evaluation type option."
VolumetricSpatialCalculationEvaluationType.AT_INSTANT_IN_TIME.__doc__ = "Evaluation of spatial calculation at instant in time."
VolumetricSpatialCalculationEvaluationType.AT_TIMES_FROM_TIME_ARRAY.__doc__ = "Evaluation of spatial calculation at times from time array."
VolumetricSpatialCalculationEvaluationType.AT_TIMES_AT_STEP_SIZE.__doc__ = "Evaluation of spatial calculation at times at step size."

agcls.AgTypeNameMap["VolumetricSpatialCalculationEvaluationType"] = VolumetricSpatialCalculationEvaluationType

class VolumetricSaveComputedDataType(IntEnum):
    """Save Computed Data types."""

    UNKNOWN = -1
    """Unknown Save Computed Data type option."""
    NO_SAVE = 0
    """Don't Save the Computed Data."""
    SAVE = 1
    """Save the Computed Data."""
    NO_SAVE_COMPUTE_ON_LOAD = 2
    """Don't Save, Compute on load."""

VolumetricSaveComputedDataType.UNKNOWN.__doc__ = "Unknown Save Computed Data type option."
VolumetricSaveComputedDataType.NO_SAVE.__doc__ = "Don't Save the Computed Data."
VolumetricSaveComputedDataType.SAVE.__doc__ = "Save the Computed Data."
VolumetricSaveComputedDataType.NO_SAVE_COMPUTE_ON_LOAD.__doc__ = "Don't Save, Compute on load."

agcls.AgTypeNameMap["VolumetricSaveComputedDataType"] = VolumetricSaveComputedDataType

class VolumetricDisplayVolumeType(IntEnum):
    """Graphics volume display type."""

    ACTIVE_GRID_POINTS = 0
    """Active Grid Points Volume."""
    SPATIAL_CALCULATION_VALUE_LEVELS = 1
    """Spatial Calculation Levels Volume."""

VolumetricDisplayVolumeType.ACTIVE_GRID_POINTS.__doc__ = "Active Grid Points Volume."
VolumetricDisplayVolumeType.SPATIAL_CALCULATION_VALUE_LEVELS.__doc__ = "Spatial Calculation Levels Volume."

agcls.AgTypeNameMap["VolumetricDisplayVolumeType"] = VolumetricDisplayVolumeType

class VolumetricDisplayQualityType(IntEnum):
    """Quality of the graphics display types."""

    QUALITY_LOW = 0
    """Low graphics display quality."""
    QUALITY_MEDIUM = 1
    """Medium graphics display quality."""
    QUALITY_HIGH = 2
    """High graphics display quality."""
    QUALITY_VERY_HIGH = 3
    """Very high graphics display quality."""

VolumetricDisplayQualityType.QUALITY_LOW.__doc__ = "Low graphics display quality."
VolumetricDisplayQualityType.QUALITY_MEDIUM.__doc__ = "Medium graphics display quality."
VolumetricDisplayQualityType.QUALITY_HIGH.__doc__ = "High graphics display quality."
VolumetricDisplayQualityType.QUALITY_VERY_HIGH.__doc__ = "Very high graphics display quality."

agcls.AgTypeNameMap["VolumetricDisplayQualityType"] = VolumetricDisplayQualityType

class VolumetricLegendNumericNotationType(IntEnum):
    """Legend numeric notation types."""

    FLOATING_POINT = 0
    """Floating point notation."""
    SCIENTIFIC_LOWERCASE_E = 1
    """Scientific notation (e)."""
    SCIENTIFIC_UPPERCASE_E = 2
    """Scientific notation (E)."""

VolumetricLegendNumericNotationType.FLOATING_POINT.__doc__ = "Floating point notation."
VolumetricLegendNumericNotationType.SCIENTIFIC_LOWERCASE_E.__doc__ = "Scientific notation (e)."
VolumetricLegendNumericNotationType.SCIENTIFIC_UPPERCASE_E.__doc__ = "Scientific notation (E)."

agcls.AgTypeNameMap["VolumetricLegendNumericNotationType"] = VolumetricLegendNumericNotationType

class VolumetricLevelOrder(IntEnum):
    """Legend level display order."""

    HORIZONTAL_MINIMUM_TO_MAXIMUM = 0
    """Horizontal Min To Max."""
    HORIZONTAL_MAXIMUM_TO_MINIMUM = 1
    """Horizontal Max To Min."""
    VERTICAL_MINIMUM_TO_MAXIMUM = 2
    """Vertical Min To Max."""
    VERTICAL_MAXIMUM_TO_MINIMUM = 3
    """Vertical Max To Min."""

VolumetricLevelOrder.HORIZONTAL_MINIMUM_TO_MAXIMUM.__doc__ = "Horizontal Min To Max."
VolumetricLevelOrder.HORIZONTAL_MAXIMUM_TO_MINIMUM.__doc__ = "Horizontal Max To Min."
VolumetricLevelOrder.VERTICAL_MINIMUM_TO_MAXIMUM.__doc__ = "Vertical Min To Max."
VolumetricLevelOrder.VERTICAL_MAXIMUM_TO_MINIMUM.__doc__ = "Vertical Max To Min."

agcls.AgTypeNameMap["VolumetricLevelOrder"] = VolumetricLevelOrder

class SensorEOIRProcessingLevelType(IntEnum):
    """EOIR processing levels."""

    GEOMETRIC_INPUT = 0
    """EOIR : Geometric input processing level."""
    RADIOMETRIC_INPUT = 1
    """EOIR : Radiometric input processing level."""
    SENSOR_OUTPUT = 2
    """EOIR : Sensor output processing level."""
    SENSOR_OFF = 3
    """EOIR : Sensor off processing level."""

SensorEOIRProcessingLevelType.GEOMETRIC_INPUT.__doc__ = "EOIR : Geometric input processing level."
SensorEOIRProcessingLevelType.RADIOMETRIC_INPUT.__doc__ = "EOIR : Radiometric input processing level."
SensorEOIRProcessingLevelType.SENSOR_OUTPUT.__doc__ = "EOIR : Sensor output processing level."
SensorEOIRProcessingLevelType.SENSOR_OFF.__doc__ = "EOIR : Sensor off processing level."

agcls.AgTypeNameMap["SensorEOIRProcessingLevelType"] = SensorEOIRProcessingLevelType

class SensorEOIRJitterType(IntEnum):
    """EOIR jitter type."""

    LOS_GAUSSIAN = 0
    """EOIR : LOS Gaussian jitter type specification."""
    POWER_SPECTRUM_DENSITY_FILE = 1
    """EOIR : Power spectrum file type specification."""
    MODULATION_TRANSFER_FUNCTION_FILE = 2
    """EOIR : Frequency modulation transfer function file type specification."""
    POINT_SPREAD_FUNCTION_FILE = 3
    """EOIR : Spatial point spread function file type specification."""

SensorEOIRJitterType.LOS_GAUSSIAN.__doc__ = "EOIR : LOS Gaussian jitter type specification."
SensorEOIRJitterType.POWER_SPECTRUM_DENSITY_FILE.__doc__ = "EOIR : Power spectrum file type specification."
SensorEOIRJitterType.MODULATION_TRANSFER_FUNCTION_FILE.__doc__ = "EOIR : Frequency modulation transfer function file type specification."
SensorEOIRJitterType.POINT_SPREAD_FUNCTION_FILE.__doc__ = "EOIR : Spatial point spread function file type specification."

agcls.AgTypeNameMap["SensorEOIRJitterType"] = SensorEOIRJitterType

class SensorEOIRScanMode(IntEnum):
    """EOIR sensor scan mode."""

    FRAMING_ARRAY = 0
    """EOIR : 2D framing array sensor."""

SensorEOIRScanMode.FRAMING_ARRAY.__doc__ = "EOIR : 2D framing array sensor."

agcls.AgTypeNameMap["SensorEOIRScanMode"] = SensorEOIRScanMode

class SensorEOIRBandImageQuality(IntEnum):
    """EOIR band image quality levels."""

    DIFFRACTION_LIMITED = 0
    """EOIR : Use diffraction limited model."""
    NEGLIGIBLE_ABERRATIONS = 1
    """EOIR : Use the negligible aberrations image quality model."""
    MILD_ABERRATIONS = 2
    """EOIR : Use the mild aberrations image quality model."""
    MODERATE_ABERRATIONS = 3
    """EOIR : Use the Moderate Aberrations image quality model."""
    CUSTOM_WAVEFRONT_ERROR = 4
    """EOIR : Use diffraction limited model."""
    CUSTOM_PUPIL_FUNCTION = 5
    """EOIR : Use a custom wavefront error amount for the image quality model."""
    CUSTOM_PSF = 6
    """EOIR : Use a custom spatial PSF file for the image quality model."""
    CUSTOM_MTF = 7
    """EOIR : Use a custom OTF or MTF file for the image quality model."""

SensorEOIRBandImageQuality.DIFFRACTION_LIMITED.__doc__ = "EOIR : Use diffraction limited model."
SensorEOIRBandImageQuality.NEGLIGIBLE_ABERRATIONS.__doc__ = "EOIR : Use the negligible aberrations image quality model."
SensorEOIRBandImageQuality.MILD_ABERRATIONS.__doc__ = "EOIR : Use the mild aberrations image quality model."
SensorEOIRBandImageQuality.MODERATE_ABERRATIONS.__doc__ = "EOIR : Use the Moderate Aberrations image quality model."
SensorEOIRBandImageQuality.CUSTOM_WAVEFRONT_ERROR.__doc__ = "EOIR : Use diffraction limited model."
SensorEOIRBandImageQuality.CUSTOM_PUPIL_FUNCTION.__doc__ = "EOIR : Use a custom wavefront error amount for the image quality model."
SensorEOIRBandImageQuality.CUSTOM_PSF.__doc__ = "EOIR : Use a custom spatial PSF file for the image quality model."
SensorEOIRBandImageQuality.CUSTOM_MTF.__doc__ = "EOIR : Use a custom OTF or MTF file for the image quality model."

agcls.AgTypeNameMap["SensorEOIRBandImageQuality"] = SensorEOIRBandImageQuality

class SensorEOIRBandSpectralShape(IntEnum):
    """EOIR overall system spectral shape determination."""

    DEFAULT = 0
    """EOIR : Use spectral shape determined by optical and radiometric parameters."""
    SPECIFIED_SYSTEM_RELATIVE_SPECTRAL_RESPONSE = 1
    """EOIR : Use a specified system relative spectral response."""

SensorEOIRBandSpectralShape.DEFAULT.__doc__ = "EOIR : Use spectral shape determined by optical and radiometric parameters."
SensorEOIRBandSpectralShape.SPECIFIED_SYSTEM_RELATIVE_SPECTRAL_RESPONSE.__doc__ = "EOIR : Use a specified system relative spectral response."

agcls.AgTypeNameMap["SensorEOIRBandSpectralShape"] = SensorEOIRBandSpectralShape

class SensorEOIRBandSpatialInputMode(IntEnum):
    """EOIR spatial input parameter specification."""

    FIELD_OF_VIEW_AND_NUMBER_OF_PIXELS = 0
    """EOIR: Use the field-of-view and number of pixels to specify the spatial properties."""
    FIELD_OF_VIEW_AND_PIXEL_PITCH = 1
    """EOIR: Use the field-of-view and the pixel pitch to specify the spatial properties."""
    NUMBER_OF_PIXELS_AND_PIXEL_PITCH = 2
    """EOIR: Use the number of pixels and pixel pitch to specify the spatial properties."""

SensorEOIRBandSpatialInputMode.FIELD_OF_VIEW_AND_NUMBER_OF_PIXELS.__doc__ = "EOIR: Use the field-of-view and number of pixels to specify the spatial properties."
SensorEOIRBandSpatialInputMode.FIELD_OF_VIEW_AND_PIXEL_PITCH.__doc__ = "EOIR: Use the field-of-view and the pixel pitch to specify the spatial properties."
SensorEOIRBandSpatialInputMode.NUMBER_OF_PIXELS_AND_PIXEL_PITCH.__doc__ = "EOIR: Use the number of pixels and pixel pitch to specify the spatial properties."

agcls.AgTypeNameMap["SensorEOIRBandSpatialInputMode"] = SensorEOIRBandSpatialInputMode

class SensorEOIRBandSpectralRelativeSystemResponseUnitsType(IntEnum):
    """EOIR spectral relative system response units specification."""

    ENERGY_UNITS = 0
    """EOIR: Treat the custom RSR function as energy units."""
    QUANTIZED_PARTICLE_UNITS = 1
    """EOIR: Treat the custom RSR function as quantized particle units."""

SensorEOIRBandSpectralRelativeSystemResponseUnitsType.ENERGY_UNITS.__doc__ = "EOIR: Treat the custom RSR function as energy units."
SensorEOIRBandSpectralRelativeSystemResponseUnitsType.QUANTIZED_PARTICLE_UNITS.__doc__ = "EOIR: Treat the custom RSR function as quantized particle units."

agcls.AgTypeNameMap["SensorEOIRBandSpectralRelativeSystemResponseUnitsType"] = SensorEOIRBandSpectralRelativeSystemResponseUnitsType

class SensorEOIRBandOpticalInputMode(IntEnum):
    """EOIR optical input parameter specification."""

    F_NUMBER_AND_FOCAL_LENGTH = 0
    """EOIR: Use the f-number and focal length to specify the optical properties."""
    F_NUMBER_AND_APERTURE_DIAMETER = 1
    """EOIR: Use the f-number and aperture diameter to specify the optical properties."""
    FOCAL_LENGTH_AND_APERTURE_DIAMETER = 2
    """EOIR: Use the focal length and aperture diameter to specify the optical properties."""

SensorEOIRBandOpticalInputMode.F_NUMBER_AND_FOCAL_LENGTH.__doc__ = "EOIR: Use the f-number and focal length to specify the optical properties."
SensorEOIRBandOpticalInputMode.F_NUMBER_AND_APERTURE_DIAMETER.__doc__ = "EOIR: Use the f-number and aperture diameter to specify the optical properties."
SensorEOIRBandOpticalInputMode.FOCAL_LENGTH_AND_APERTURE_DIAMETER.__doc__ = "EOIR: Use the focal length and aperture diameter to specify the optical properties."

agcls.AgTypeNameMap["SensorEOIRBandOpticalInputMode"] = SensorEOIRBandOpticalInputMode

class SensorEOIRBandOpticalTransmissionMode(IntEnum):
    """EOIR optical transmission parameter specification mode."""

    BAND_EFFECTIVE_TRANSMISSION = 0
    """EOIR: Use band effective transmission value."""
    TRANSMISSION_DATA_FILE = 1
    """EOIR: Use spectral transmission data file."""

SensorEOIRBandOpticalTransmissionMode.BAND_EFFECTIVE_TRANSMISSION.__doc__ = "EOIR: Use band effective transmission value."
SensorEOIRBandOpticalTransmissionMode.TRANSMISSION_DATA_FILE.__doc__ = "EOIR: Use spectral transmission data file."

agcls.AgTypeNameMap["SensorEOIRBandOpticalTransmissionMode"] = SensorEOIRBandOpticalTransmissionMode

class SensorEOIRBandRadiometricParameterLevelType(IntEnum):
    """EOIR radiometric detector parameter level of specification."""

    HIGH_LEVEL = 0
    """EOIR: Use high level detector parameters."""
    LOW_LEVEL = 1
    """EOIR: Use low level detector parameters."""

SensorEOIRBandRadiometricParameterLevelType.HIGH_LEVEL.__doc__ = "EOIR: Use high level detector parameters."
SensorEOIRBandRadiometricParameterLevelType.LOW_LEVEL.__doc__ = "EOIR: Use low level detector parameters."

agcls.AgTypeNameMap["SensorEOIRBandRadiometricParameterLevelType"] = SensorEOIRBandRadiometricParameterLevelType

class SensorEOIRBandQuantumEfficiencyMode(IntEnum):
    """EOIR quantum efficiency specification mode."""

    BAND_EFFECTIVE_QUANTUM_EFFICIENCY = 0
    """EOIR: Use band effective quantum efficiency for detector."""
    SPECTRAL_QUANTUM_EFFICIENCY_DATA_FILE = 1
    """EOIR: Provide spectral quantum efficiency data file for detector."""

SensorEOIRBandQuantumEfficiencyMode.BAND_EFFECTIVE_QUANTUM_EFFICIENCY.__doc__ = "EOIR: Use band effective quantum efficiency for detector."
SensorEOIRBandQuantumEfficiencyMode.SPECTRAL_QUANTUM_EFFICIENCY_DATA_FILE.__doc__ = "EOIR: Provide spectral quantum efficiency data file for detector."

agcls.AgTypeNameMap["SensorEOIRBandQuantumEfficiencyMode"] = SensorEOIRBandQuantumEfficiencyMode

class SensorEOIRBandQuantizationMode(IntEnum):
    """EOIR mode of determining quantization step size."""

    FULL_WELL_AND_NOISE = 0
    """EOIR: Use full-well capacity and system level noise for analog-to-digital signal conversion."""
    FULL_WELL_AND_QSS = 1
    """EOIR: Use full-well capacity and quantization step size for analog-to-digital signal conversion."""
    BIT_DEPTH_AND_NOISE = 2
    """EOIR: Use signal bit-depth and system level noise for analog-to-digital signal conversion."""
    BIT_DEPTH_AND_QSS = 3
    """EOIR: Use signal bit-depth and quantization step size for analog-to-digital signal conversion."""

SensorEOIRBandQuantizationMode.FULL_WELL_AND_NOISE.__doc__ = "EOIR: Use full-well capacity and system level noise for analog-to-digital signal conversion."
SensorEOIRBandQuantizationMode.FULL_WELL_AND_QSS.__doc__ = "EOIR: Use full-well capacity and quantization step size for analog-to-digital signal conversion."
SensorEOIRBandQuantizationMode.BIT_DEPTH_AND_NOISE.__doc__ = "EOIR: Use signal bit-depth and system level noise for analog-to-digital signal conversion."
SensorEOIRBandQuantizationMode.BIT_DEPTH_AND_QSS.__doc__ = "EOIR: Use signal bit-depth and quantization step size for analog-to-digital signal conversion."

agcls.AgTypeNameMap["SensorEOIRBandQuantizationMode"] = SensorEOIRBandQuantizationMode

class SensorEOIRBandWavelengthType(IntEnum):
    """EOIR band diffraction wavelength reference type."""

    LOW_BAND_EDGE = 0
    """EOIR : Low Band Edge."""
    BAND_CENTER = 1
    """EOIR : Band Center."""
    HIGH_BAND_EDGE = 2
    """EOIR : High Band Edge."""
    USER_DEFINED_WAVELENGTH = 3
    """EOIR : User Defined."""

SensorEOIRBandWavelengthType.LOW_BAND_EDGE.__doc__ = "EOIR : Low Band Edge."
SensorEOIRBandWavelengthType.BAND_CENTER.__doc__ = "EOIR : Band Center."
SensorEOIRBandWavelengthType.HIGH_BAND_EDGE.__doc__ = "EOIR : High Band Edge."
SensorEOIRBandWavelengthType.USER_DEFINED_WAVELENGTH.__doc__ = "EOIR : User Defined."

agcls.AgTypeNameMap["SensorEOIRBandWavelengthType"] = SensorEOIRBandWavelengthType

class SensorEOIRBandSaturationMode(IntEnum):
    """EOIR band irradiance or radiance reference mode."""

    IRRADIANCE = 0
    """EOIR : Irrandiance Sensitivities Mode."""
    RADIANCE = 1
    """EOIR : Radiance Sensitivities Mode."""

SensorEOIRBandSaturationMode.IRRADIANCE.__doc__ = "EOIR : Irrandiance Sensitivities Mode."
SensorEOIRBandSaturationMode.RADIANCE.__doc__ = "EOIR : Radiance Sensitivities Mode."

agcls.AgTypeNameMap["SensorEOIRBandSaturationMode"] = SensorEOIRBandSaturationMode

class VolumetricVolumeGridExportType(IntEnum):
    """Volumetric data export types."""

    INCLUDE_LINK_TO_VOLUME_GRID = 0
    """Volumetric data export : Include Link To VolumeGrid."""
    EMBED_VOLUME_GRID_DEFINITION = 1
    """Volumetric data export : Embed Volume Grid Definition."""

VolumetricVolumeGridExportType.INCLUDE_LINK_TO_VOLUME_GRID.__doc__ = "Volumetric data export : Include Link To VolumeGrid."
VolumetricVolumeGridExportType.EMBED_VOLUME_GRID_DEFINITION.__doc__ = "Volumetric data export : Embed Volume Grid Definition."

agcls.AgTypeNameMap["VolumetricVolumeGridExportType"] = VolumetricVolumeGridExportType

class VolumetricDataExportFormatType(IntEnum):
    """Volumetric data export format types."""

    HDF5 = 0
    """HDF5 Volumetric data export type."""

VolumetricDataExportFormatType.HDF5.__doc__ = "HDF5 Volumetric data export type."

agcls.AgTypeNameMap["VolumetricDataExportFormatType"] = VolumetricDataExportFormatType

class ConstellationFromToParentConstraint(IntEnum):
    """Options for a chain's From and To Parent Constraints."""

    ANY = 0
    """Constellation constraint: Parent objects can be the same or different."""
    SAME_PARENT = 1
    """Constellation constraint: Parent objects must be the same."""
    DIFFERENT_PARENT = 2
    """Constellation constraint: Parent objects must be different."""

ConstellationFromToParentConstraint.ANY.__doc__ = "Constellation constraint: Parent objects can be the same or different."
ConstellationFromToParentConstraint.SAME_PARENT.__doc__ = "Constellation constraint: Parent objects must be the same."
ConstellationFromToParentConstraint.DIFFERENT_PARENT.__doc__ = "Constellation constraint: Parent objects must be different."

agcls.AgTypeNameMap["ConstellationFromToParentConstraint"] = ConstellationFromToParentConstraint

class AnalysisWorkbenchAccessConstraintType(IntEnum):
    """Available Analysis Workbench Access Constraints."""

    ANGLE = 9
    """Angle. Use interface AccessConstraintAnalysisWorkbench."""
    VECTOR_MAGNITUDE = 10
    """Vector magnitude. Use interface AccessConstraintAnalysisWorkbench."""
    CONDITION = 104
    """Coordinate condition constraint. Use interface AccessConstraintAnalysisWorkbench."""
    CALCULATION_SCALAR = 225
    """Scalar Calculation (Calc Scalar) constraint. Use interface AccessConstraintAnalysisWorkbench."""

AnalysisWorkbenchAccessConstraintType.ANGLE.__doc__ = "Angle. Use interface AccessConstraintAnalysisWorkbench."
AnalysisWorkbenchAccessConstraintType.VECTOR_MAGNITUDE.__doc__ = "Vector magnitude. Use interface AccessConstraintAnalysisWorkbench."
AnalysisWorkbenchAccessConstraintType.CONDITION.__doc__ = "Coordinate condition constraint. Use interface AccessConstraintAnalysisWorkbench."
AnalysisWorkbenchAccessConstraintType.CALCULATION_SCALAR.__doc__ = "Scalar Calculation (Calc Scalar) constraint. Use interface AccessConstraintAnalysisWorkbench."

agcls.AgTypeNameMap["AnalysisWorkbenchAccessConstraintType"] = AnalysisWorkbenchAccessConstraintType

class StatisticType(IntEnum):
    """The different statistics that might be available for a data set."""

    MEAN = 0
    """Mean."""
    PERCENT_INTERVAL = 1
    """Percent Of Interval."""
    PERCENT_NOT_INTERVAL = 2
    """Percent Not Of Interval."""
    STANDARD_DEVIATION = 3
    """Standard Deviation."""
    TOTAL = 4
    """Total."""

StatisticType.MEAN.__doc__ = "Mean."
StatisticType.PERCENT_INTERVAL.__doc__ = "Percent Of Interval."
StatisticType.PERCENT_NOT_INTERVAL.__doc__ = "Percent Not Of Interval."
StatisticType.STANDARD_DEVIATION.__doc__ = "Standard Deviation."
StatisticType.TOTAL.__doc__ = "Total."

agcls.AgTypeNameMap["StatisticType"] = StatisticType

class TimeVaryingExtremum(IntEnum):
    """The different time varying extremum that might be available for a data set."""

    MAXIMUM = 0
    """Max."""
    MAXIMUM_OF_SAMPLES = 1
    """Max Of Samples."""
    MINIMUM = 2
    """Min."""
    MINIMUM_OF_SAMPLES = 3
    """Min Of Samples."""

TimeVaryingExtremum.MAXIMUM.__doc__ = "Max."
TimeVaryingExtremum.MAXIMUM_OF_SAMPLES.__doc__ = "Max Of Samples."
TimeVaryingExtremum.MINIMUM.__doc__ = "Min."
TimeVaryingExtremum.MINIMUM_OF_SAMPLES.__doc__ = "Min Of Samples."

agcls.AgTypeNameMap["TimeVaryingExtremum"] = TimeVaryingExtremum

class ModelGltfReflectionMapType(IntEnum):
    """Settings for glTF Reflection."""

    PROCEDURAL_ENVIRONMENT = 0x0
    """Procedural environment glTF Reflection."""
    IMAGE_BASED = 0x1
    """Image based glTF Reflection."""

ModelGltfReflectionMapType.PROCEDURAL_ENVIRONMENT.__doc__ = "Procedural environment glTF Reflection."
ModelGltfReflectionMapType.IMAGE_BASED.__doc__ = "Image based glTF Reflection."

agcls.AgTypeNameMap["ModelGltfReflectionMapType"] = ModelGltfReflectionMapType

class SensorGraphics3DProjectionTimeDependencyType(IntEnum):
    """The different ways to determine the sensor's space projection distance in the 3D window."""

    CONSTANT = 0
    """Use a constant length at all times. This length can be set with the SpaceProjection or Targeting property on the SensorGraphics3D interface depending on the sensor's pointing settings."""
    TIME_VARYING = 1
    """Use a user provided list of times and lengths. The times and lengths can be set with the ProjectionIntervals or TargetProjectionIntervals property on the SensorGraphics3D interface depending on the sensor's pointing settings."""

SensorGraphics3DProjectionTimeDependencyType.CONSTANT.__doc__ = "Use a constant length at all times. This length can be set with the SpaceProjection or Targeting property on the SensorGraphics3D interface depending on the sensor's pointing settings."
SensorGraphics3DProjectionTimeDependencyType.TIME_VARYING.__doc__ = "Use a user provided list of times and lengths. The times and lengths can be set with the ProjectionIntervals or TargetProjectionIntervals property on the SensorGraphics3D interface depending on the sensor's pointing settings."

agcls.AgTypeNameMap["SensorGraphics3DProjectionTimeDependencyType"] = SensorGraphics3DProjectionTimeDependencyType

class LOPAtmosphericDensityModel(IntEnum):
    """LOP Atmospheric density models."""

    UNKNOWN = -1
    """Unsupported or unknown atmospheric density model."""
    STANDARD_ATMOSPHERE_MODEL_1976 = 0
    """1976 Standard Atmosphere: look-up model based on the satellite's altitude, with a valid range of 86km - 1000 km."""
    EXPONENTIAL = 1
    """Exponential Model: uses equation calculating atmospheric density on basis of a specified altitude, reference density, reference altitude and scale altitude."""

LOPAtmosphericDensityModel.UNKNOWN.__doc__ = "Unsupported or unknown atmospheric density model."
LOPAtmosphericDensityModel.STANDARD_ATMOSPHERE_MODEL_1976.__doc__ = "1976 Standard Atmosphere: look-up model based on the satellite's altitude, with a valid range of 86km - 1000 km."
LOPAtmosphericDensityModel.EXPONENTIAL.__doc__ = "Exponential Model: uses equation calculating atmospheric density on basis of a specified altitude, reference density, reference altitude and scale altitude."

agcls.AgTypeNameMap["LOPAtmosphericDensityModel"] = LOPAtmosphericDensityModel

class LowAltitudeAtmosphericDensityModel(IntEnum):
    """Low Altitude Atmospheric density models."""

    UNKNOWN = -1
    """Unsupported or unknown low altitude atmospheric density model."""
    NONE = 0
    """No atmospheric density model to be used."""
    NRLMSISE2000 = 1
    """NRLMSISE 2000: finds the total density by accounting for the contribution of N, N2, O, O2, He, Ar and H. Includes anomalous oxygen. 2000 version, valid range of 0-1000 km."""
    MSISE1990 = 2
    """MSISE 1990: finds the total density by accounting for the contribution of N2, O, O2, He, Ar and H. 1990 version, valid range of 0-1000 km."""

LowAltitudeAtmosphericDensityModel.UNKNOWN.__doc__ = "Unsupported or unknown low altitude atmospheric density model."
LowAltitudeAtmosphericDensityModel.NONE.__doc__ = "No atmospheric density model to be used."
LowAltitudeAtmosphericDensityModel.NRLMSISE2000.__doc__ = "NRLMSISE 2000: finds the total density by accounting for the contribution of N, N2, O, O2, He, Ar and H. Includes anomalous oxygen. 2000 version, valid range of 0-1000 km."
LowAltitudeAtmosphericDensityModel.MSISE1990.__doc__ = "MSISE 1990: finds the total density by accounting for the contribution of N2, O, O2, He, Ar and H. 1990 version, valid range of 0-1000 km."

agcls.AgTypeNameMap["LowAltitudeAtmosphericDensityModel"] = LowAltitudeAtmosphericDensityModel

class EphemExportToolFileFormat(IntEnum):
    """Ephemeris Export Tool file formats."""

    ORBIT_EPHEMERIS_MESSAGE = 0
    """The Ephemeris Export tool will generate an Orbit Ephemeris Message (.oem) file following the CCSDS Ephemeris v2.0 standard."""
    XML = 1
    """The Ephemeris Export tool will generate an XML file following the CCSDS Ephemeris v2.0 standard."""

EphemExportToolFileFormat.ORBIT_EPHEMERIS_MESSAGE.__doc__ = "The Ephemeris Export tool will generate an Orbit Ephemeris Message (.oem) file following the CCSDS Ephemeris v2.0 standard."
EphemExportToolFileFormat.XML.__doc__ = "The Ephemeris Export tool will generate an XML file following the CCSDS Ephemeris v2.0 standard."

agcls.AgTypeNameMap["EphemExportToolFileFormat"] = EphemExportToolFileFormat

class AdvCATEllipsoidClassType(IntEnum):
    """Method for determining Ellipsoid Sizing method (class)."""

    CLASS_FIXED = 0
    """AdvCAT class type Fixed."""
    CLASS_ORBIT_CLASS = 1
    """AdvCAT class type Fixed Orbit class."""
    CLASS_QUADRATIC_IN_TIME = 2
    """AdvCAT class type Quadratic."""
    CLASS_QUADRATIC_IN_TIME_BY_ORBIT_CLASS = 3
    """AdvCAT class type Quad In Time Orbit Class."""
    CLASS_COVARIANCE = 4
    """AdvCAT class type Covariance."""
    CLASS_COVARIANCE_OFFSET = 5
    """AdvCAT class type Covariance Offset."""

AdvCATEllipsoidClassType.CLASS_FIXED.__doc__ = "AdvCAT class type Fixed."
AdvCATEllipsoidClassType.CLASS_ORBIT_CLASS.__doc__ = "AdvCAT class type Fixed Orbit class."
AdvCATEllipsoidClassType.CLASS_QUADRATIC_IN_TIME.__doc__ = "AdvCAT class type Quadratic."
AdvCATEllipsoidClassType.CLASS_QUADRATIC_IN_TIME_BY_ORBIT_CLASS.__doc__ = "AdvCAT class type Quad In Time Orbit Class."
AdvCATEllipsoidClassType.CLASS_COVARIANCE.__doc__ = "AdvCAT class type Covariance."
AdvCATEllipsoidClassType.CLASS_COVARIANCE_OFFSET.__doc__ = "AdvCAT class type Covariance Offset."

agcls.AgTypeNameMap["AdvCATEllipsoidClassType"] = AdvCATEllipsoidClassType

class AdvCATConjunctionType(IntEnum):
    """Mode for computing events involving conjunction TCA."""

    GLOBAL_ONLY = 0
    """conjunction TCA type Global Only."""
    LOCAL_ONLY = 1
    """conjunction TCA type Local Only."""
    GLOBAL_PLUS_LOCAL = 2
    """conjunction TCA type Global + Local."""
    LOCAL_PLUS_END_POINTS = 3
    """conjunction TCA typeLocal + EndPoints."""

AdvCATConjunctionType.GLOBAL_ONLY.__doc__ = "conjunction TCA type Global Only."
AdvCATConjunctionType.LOCAL_ONLY.__doc__ = "conjunction TCA type Local Only."
AdvCATConjunctionType.GLOBAL_PLUS_LOCAL.__doc__ = "conjunction TCA type Global + Local."
AdvCATConjunctionType.LOCAL_PLUS_END_POINTS.__doc__ = "conjunction TCA typeLocal + EndPoints."

agcls.AgTypeNameMap["AdvCATConjunctionType"] = AdvCATConjunctionType

class AdvCATSecondaryEllipsoidsVisibilityType(IntEnum):
    """Type of visible Secondary Ellipsoids."""

    SHOW_ALL_SECONDARY_ELLIPSOIDS = 0
    """Show all Secondary Ellipsoids."""
    SHOW_SECONDARY_ELLIPSOIDS_WITH_CONJUNCTIONS = 1
    """Show Secondary Ellipsoids with conjunctions."""

AdvCATSecondaryEllipsoidsVisibilityType.SHOW_ALL_SECONDARY_ELLIPSOIDS.__doc__ = "Show all Secondary Ellipsoids."
AdvCATSecondaryEllipsoidsVisibilityType.SHOW_SECONDARY_ELLIPSOIDS_WITH_CONJUNCTIONS.__doc__ = "Show Secondary Ellipsoids with conjunctions."

agcls.AgTypeNameMap["AdvCATSecondaryEllipsoidsVisibilityType"] = AdvCATSecondaryEllipsoidsVisibilityType

class EOIRShapeType(IntEnum):
    """The object geometry which will be rendered in the synthetic scene window."""

    BOX = 0
    """Shape is defined as a Box."""
    CONE = 1
    """Shape is defined as a Cone."""
    SPHERE = 2
    """Shape is defined as a Sphere."""
    CYLINDER = 3
    """Shape is defined as a Cylinder."""
    PLATE = 4
    """Shape is defined as a Plate."""
    NONE = 5
    """Shape is not defined."""
    COUPLER = 6
    """Shape is defined as a Coupler."""
    GEO_COMM_SATELLITE = 7
    """Shape is defined as a representative GEO comm satellite."""
    LEO_COMM_SATELLITE = 8
    """Shape is defined as a representative LEO comm satellite."""
    LEO_IMAGING = 9
    """Shape is defined as a representative LEO imaging satellite."""
    CUSTOM_MESH = 10
    """Shape is defined as a Custom Mesh."""
    TARGET_SIGNATURE = 11
    """Shape is defined as a Target Signature."""

EOIRShapeType.BOX.__doc__ = "Shape is defined as a Box."
EOIRShapeType.CONE.__doc__ = "Shape is defined as a Cone."
EOIRShapeType.SPHERE.__doc__ = "Shape is defined as a Sphere."
EOIRShapeType.CYLINDER.__doc__ = "Shape is defined as a Cylinder."
EOIRShapeType.PLATE.__doc__ = "Shape is defined as a Plate."
EOIRShapeType.NONE.__doc__ = "Shape is not defined."
EOIRShapeType.COUPLER.__doc__ = "Shape is defined as a Coupler."
EOIRShapeType.GEO_COMM_SATELLITE.__doc__ = "Shape is defined as a representative GEO comm satellite."
EOIRShapeType.LEO_COMM_SATELLITE.__doc__ = "Shape is defined as a representative LEO comm satellite."
EOIRShapeType.LEO_IMAGING.__doc__ = "Shape is defined as a representative LEO imaging satellite."
EOIRShapeType.CUSTOM_MESH.__doc__ = "Shape is defined as a Custom Mesh."
EOIRShapeType.TARGET_SIGNATURE.__doc__ = "Shape is defined as a Target Signature."

agcls.AgTypeNameMap["EOIRShapeType"] = EOIRShapeType

class EOIRShapeMaterialSpecificationType(IntEnum):
    """Designation of how material properties are specified."""

    SINGLE = 0
    """Materials specified by a single element."""
    GEOMETRIC_GROUP = 1
    """Materials specified by geometric group."""

EOIRShapeMaterialSpecificationType.SINGLE.__doc__ = "Materials specified by a single element."
EOIRShapeMaterialSpecificationType.GEOMETRIC_GROUP.__doc__ = "Materials specified by geometric group."

agcls.AgTypeNameMap["EOIRShapeMaterialSpecificationType"] = EOIRShapeMaterialSpecificationType

class EOIRThermalModelType(IntEnum):
    """EOIR thermal models."""

    STATIC = 0
    """Thermal model, Constant."""
    TIME_PROFILE = 1
    """Thermal model, Time Profile."""
    DATA_PROVIDER = 2
    """Thermal model, Data provider."""

EOIRThermalModelType.STATIC.__doc__ = "Thermal model, Constant."
EOIRThermalModelType.TIME_PROFILE.__doc__ = "Thermal model, Time Profile."
EOIRThermalModelType.DATA_PROVIDER.__doc__ = "Thermal model, Data provider."

agcls.AgTypeNameMap["EOIRThermalModelType"] = EOIRThermalModelType

class EOIRFlightType(IntEnum):
    """EOIR Flight Types."""

    NONE = 0
    """EOIR Flight Type : None."""
    POWERED = 1
    """EOIR Flight Type : Powered."""
    FALLING = 2
    """EOIR Flight Type : Falling."""

EOIRFlightType.NONE.__doc__ = "EOIR Flight Type : None."
EOIRFlightType.POWERED.__doc__ = "EOIR Flight Type : Powered."
EOIRFlightType.FALLING.__doc__ = "EOIR Flight Type : Falling."

agcls.AgTypeNameMap["EOIRFlightType"] = EOIRFlightType

class PropagatorDisplayCoordinateType(IntEnum):
    """Propagator Display Coordinate Types."""

    CARTESIAN = 0
    """Cartesian Coordinates."""
    CLASSICAL = 1
    """Classical Coordinates."""
    EQUINOCTIAL = 2
    """Equinoctial Coordinates."""
    DELAUNAY_VARIABLES = 3
    """Delaunay Variables Coordinates."""
    MIXED_SPHERICAL = 4
    """Mixed Spherical Coordinates."""
    SPHERICAL = 5
    """Spherical Coordinates."""

PropagatorDisplayCoordinateType.CARTESIAN.__doc__ = "Cartesian Coordinates."
PropagatorDisplayCoordinateType.CLASSICAL.__doc__ = "Classical Coordinates."
PropagatorDisplayCoordinateType.EQUINOCTIAL.__doc__ = "Equinoctial Coordinates."
PropagatorDisplayCoordinateType.DELAUNAY_VARIABLES.__doc__ = "Delaunay Variables Coordinates."
PropagatorDisplayCoordinateType.MIXED_SPHERICAL.__doc__ = "Mixed Spherical Coordinates."
PropagatorDisplayCoordinateType.SPHERICAL.__doc__ = "Spherical Coordinates."

agcls.AgTypeNameMap["PropagatorDisplayCoordinateType"] = PropagatorDisplayCoordinateType

class ConnectAuthenticationMode(IntEnum):
    """Determine the authentication mode for the connect."""

    SINGLE_USER_LOCAL = 0
    """Enforce local single user authentication."""
    MUTUAL_TLS = 1
    """Use MutualTLS for authentication."""
    INSECURE = 2
    """Allow connections without user authentication. Not recommended."""

ConnectAuthenticationMode.SINGLE_USER_LOCAL.__doc__ = "Enforce local single user authentication."
ConnectAuthenticationMode.MUTUAL_TLS.__doc__ = "Use MutualTLS for authentication."
ConnectAuthenticationMode.INSECURE.__doc__ = "Allow connections without user authentication. Not recommended."

agcls.AgTypeNameMap["ConnectAuthenticationMode"] = ConnectAuthenticationMode

class ComponentLinkEmbedControlReferenceType(IntEnum):
    """Component link/embed control reference type."""

    UNLINKED = 0
    """Unlink."""
    LINKED = 1
    """Link."""

ComponentLinkEmbedControlReferenceType.UNLINKED.__doc__ = "Unlink."
ComponentLinkEmbedControlReferenceType.LINKED.__doc__ = "Link."

agcls.AgTypeNameMap["ComponentLinkEmbedControlReferenceType"] = ComponentLinkEmbedControlReferenceType

class SwathComputationalMethod(IntEnum):
    """Computationals methods for generating swaths."""

    UNKNOWN = -1
    """Unknown or unsupported computational method."""
    ANALYTIC = 0
    """The Analytical Computational Method is only valid if the parent of the Sensor is a Satellite and the Satellite has a Circular Orbit and the Satellite uses Nadir ECF Attitude and the Sensor is Nadir (Fixed) Pointing."""
    NUMERIC = 1
    """The Numerical Computational Method is not valid if the Sensor uses a Custom Pattern."""

SwathComputationalMethod.UNKNOWN.__doc__ = "Unknown or unsupported computational method."
SwathComputationalMethod.ANALYTIC.__doc__ = "The Analytical Computational Method is only valid if the parent of the Sensor is a Satellite and the Satellite has a Circular Orbit and the Satellite uses Nadir ECF Attitude and the Sensor is Nadir (Fixed) Pointing."
SwathComputationalMethod.NUMERIC.__doc__ = "The Numerical Computational Method is not valid if the Sensor uses a Custom Pattern."

agcls.AgTypeNameMap["SwathComputationalMethod"] = SwathComputationalMethod

class ClassicalLocation(IntEnum):
    """Classical (Keplerian) element used to specify the spacecraft's location within its orbit at epoch."""

    UNKNOWN = -1
    """Represents unsupported spacecraft location."""
    ARGUMENT_OF_LATITUDE = 0
    """Use Argument of Latitude to specify spacecraft location."""
    ECCENTRIC_ANOMALY = 1
    """Use Eccentric Anomaly to specify spacecraft location."""
    MEAN_ANOMALY = 2
    """Use Mean Anomaly to specify spacecraft location."""
    TIME_PAST_ASCENDING_NODE = 3
    """Use Time Past Ascending Node to specify spacecraft location."""
    TIME_PAST_PERIGEE = 4
    """Use Time Past Perigee to specify spacecraft location."""
    TRUE_ANOMALY = 5
    """Use True Anomaly to specify spacecraft location."""

ClassicalLocation.UNKNOWN.__doc__ = "Represents unsupported spacecraft location."
ClassicalLocation.ARGUMENT_OF_LATITUDE.__doc__ = "Use Argument of Latitude to specify spacecraft location."
ClassicalLocation.ECCENTRIC_ANOMALY.__doc__ = "Use Eccentric Anomaly to specify spacecraft location."
ClassicalLocation.MEAN_ANOMALY.__doc__ = "Use Mean Anomaly to specify spacecraft location."
ClassicalLocation.TIME_PAST_ASCENDING_NODE.__doc__ = "Use Time Past Ascending Node to specify spacecraft location."
ClassicalLocation.TIME_PAST_PERIGEE.__doc__ = "Use Time Past Perigee to specify spacecraft location."
ClassicalLocation.TRUE_ANOMALY.__doc__ = "Use True Anomaly to specify spacecraft location."

agcls.AgTypeNameMap["ClassicalLocation"] = ClassicalLocation

class OrientationAscNode(IntEnum):
    """Ascending node-related options for use in specifying orbit orientation."""

    UNKNOWN = -1
    """Represents ascending node value not supported by the Object Model."""
    LONGITUDE_ASCENDING_NODE = 0
    """Longitude of Ascending Node."""
    RIGHT_ASCENSION_ASCENDING_NODE = 1
    """Right Ascension of Ascending Node."""

OrientationAscNode.UNKNOWN.__doc__ = "Represents ascending node value not supported by the Object Model."
OrientationAscNode.LONGITUDE_ASCENDING_NODE.__doc__ = "Longitude of Ascending Node."
OrientationAscNode.RIGHT_ASCENSION_ASCENDING_NODE.__doc__ = "Right Ascension of Ascending Node."

agcls.AgTypeNameMap["OrientationAscNode"] = OrientationAscNode

class GeodeticSize(IntEnum):
    """Size options for the Geodetic coordinate type."""

    UNKNOWN = -1
    """Represents a value not supported by the Object Model."""
    ALTITUDE = 0
    """Use altitude."""
    RADIUS = 1
    """Use radius."""

GeodeticSize.UNKNOWN.__doc__ = "Represents a value not supported by the Object Model."
GeodeticSize.ALTITUDE.__doc__ = "Use altitude."
GeodeticSize.RADIUS.__doc__ = "Use radius."

agcls.AgTypeNameMap["GeodeticSize"] = GeodeticSize

class DelaunayLType(IntEnum):
    """Select whether to use the default representation of Delaunay L or L/SQRT(mu)."""

    UNKNOWN = -1
    """Represents a value not supported by the Object Model."""
    L = 0
    """Use the default representation of L."""
    L_OVER_SQRT_MU = 1
    """Use L/SQRT(mu)."""

DelaunayLType.UNKNOWN.__doc__ = "Represents a value not supported by the Object Model."
DelaunayLType.L.__doc__ = "Use the default representation of L."
DelaunayLType.L_OVER_SQRT_MU.__doc__ = "Use L/SQRT(mu)."

agcls.AgTypeNameMap["DelaunayLType"] = DelaunayLType

class DelaunayHType(IntEnum):
    """Select whether to use the default representation of Delaunay H or H/SQRT(mu)."""

    UNKNOWN = -1
    """Represents a value not supported by the Object Model."""
    H = 0
    """Use the default representation of H."""
    H_OVER_SQRT_MU = 1
    """H/SQRT(mu)."""

DelaunayHType.UNKNOWN.__doc__ = "Represents a value not supported by the Object Model."
DelaunayHType.H.__doc__ = "Use the default representation of H."
DelaunayHType.H_OVER_SQRT_MU.__doc__ = "H/SQRT(mu)."

agcls.AgTypeNameMap["DelaunayHType"] = DelaunayHType

class DelaunayGType(IntEnum):
    """Select whether to use the default representation of Delaunay G or G/SQRT(mu)."""

    UNKNOWN = -1
    """Represents a value not supported by the Object Model."""
    G = 0
    """Use the default representation of G."""
    G_OVER_SQRT_MU = 1
    """Use G/SQRT(mu)."""

DelaunayGType.UNKNOWN.__doc__ = "Represents a value not supported by the Object Model."
DelaunayGType.G.__doc__ = "Use the default representation of G."
DelaunayGType.G_OVER_SQRT_MU.__doc__ = "Use G/SQRT(mu)."

agcls.AgTypeNameMap["DelaunayGType"] = DelaunayGType

class EquinoctialSizeShape(IntEnum):
    """Opt whether to use Mean Motion or Semimajor Axis to specify the orbit size (Equinoctial coordinate type)."""

    UNKNOWN = -1
    """Represents a value not supported by the Object Model."""
    MEAN_MOTION = 0
    """Use Mean Motion to specify orbit size."""
    SEMIMAJOR_AXIS = 1
    """Use Semimajor Axis to specify orbit size."""

EquinoctialSizeShape.UNKNOWN.__doc__ = "Represents a value not supported by the Object Model."
EquinoctialSizeShape.MEAN_MOTION.__doc__ = "Use Mean Motion to specify orbit size."
EquinoctialSizeShape.SEMIMAJOR_AXIS.__doc__ = "Use Semimajor Axis to specify orbit size."

agcls.AgTypeNameMap["EquinoctialSizeShape"] = EquinoctialSizeShape

class MixedSphericalFlightPathAngleType(IntEnum):
    """Opt whether to use Horizontal or Vertical Flight Path Angle."""

    UNKNOWN = -1
    """Represents a flight path angle not supported by the Object Model."""
    HORIZONTAL = 0
    """Use Horizontal Flight Path Angle."""
    VERTICAL = 1
    """Use Vertical Flight Path Angle."""

MixedSphericalFlightPathAngleType.UNKNOWN.__doc__ = "Represents a flight path angle not supported by the Object Model."
MixedSphericalFlightPathAngleType.HORIZONTAL.__doc__ = "Use Horizontal Flight Path Angle."
MixedSphericalFlightPathAngleType.VERTICAL.__doc__ = "Use Vertical Flight Path Angle."

agcls.AgTypeNameMap["MixedSphericalFlightPathAngleType"] = MixedSphericalFlightPathAngleType

class SphericalFlightPathAzimuthType(IntEnum):
    """Opt whether to use Horizontal or Vertical Flight Path Angle."""

    UNKNOWN = -1
    """Represents unsupported angle type."""
    HORIZONTAL = 0
    """Use Horizontal Flight Path Angle."""
    VERTICAL = 1
    """Use Vertical Flight Path Angle."""

SphericalFlightPathAzimuthType.UNKNOWN.__doc__ = "Represents unsupported angle type."
SphericalFlightPathAzimuthType.HORIZONTAL.__doc__ = "Use Horizontal Flight Path Angle."
SphericalFlightPathAzimuthType.VERTICAL.__doc__ = "Use Vertical Flight Path Angle."

agcls.AgTypeNameMap["SphericalFlightPathAzimuthType"] = SphericalFlightPathAzimuthType

class ClassicalSizeShape(IntEnum):
    """Pairs of Classical (Keplerian) elements used to specify orbit size and shape."""

    UNKNOWN = -1
    """Represents a value unsupported by the Object Model."""
    ALTITUDE = 0
    """Apogee and Perigee Altitude."""
    MEAN_MOTION = 1
    """Mean Motion and Eccentricity."""
    PERIOD = 2
    """Period and Eccentricity."""
    RADIUS = 3
    """Apogee and Perigee Radius."""
    SEMIMAJOR_AXIS = 4
    """Semimajor Axis and Eccentricity."""

ClassicalSizeShape.UNKNOWN.__doc__ = "Represents a value unsupported by the Object Model."
ClassicalSizeShape.ALTITUDE.__doc__ = "Apogee and Perigee Altitude."
ClassicalSizeShape.MEAN_MOTION.__doc__ = "Mean Motion and Eccentricity."
ClassicalSizeShape.PERIOD.__doc__ = "Period and Eccentricity."
ClassicalSizeShape.RADIUS.__doc__ = "Apogee and Perigee Radius."
ClassicalSizeShape.SEMIMAJOR_AXIS.__doc__ = "Semimajor Axis and Eccentricity."

agcls.AgTypeNameMap["ClassicalSizeShape"] = ClassicalSizeShape

class EquinoctialFormulation(IntEnum):
    """Formulation: retrograde or posigrade."""

    POSIGRADE = 0
    """Posigrade, which has its singularity at an inclination of 180 deg."""
    RETROGRADE = 1
    """Retrograde, which has its singularity at an inclination of 0 deg."""

EquinoctialFormulation.POSIGRADE.__doc__ = "Posigrade, which has its singularity at an inclination of 180 deg."
EquinoctialFormulation.RETROGRADE.__doc__ = "Retrograde, which has its singularity at an inclination of 0 deg."

agcls.AgTypeNameMap["EquinoctialFormulation"] = EquinoctialFormulation

class ScatteringPointProviderType(IntEnum):
    """Scattering point provider type."""

    UNKNOWN = -1
    """Unknown."""
    SINGLE_POINT = 0
    """Single point."""
    SMOOTH_OBLATE_EARTH = 1
    """Smooth oblate earth."""
    PLUGIN = 2
    """Plugin."""
    RANGE_OVER_CFAR_CELLS = 3
    """Range Over CFAR Cells."""
    POINTS_FILE = 4
    """Points File."""

ScatteringPointProviderType.UNKNOWN.__doc__ = "Unknown."
ScatteringPointProviderType.SINGLE_POINT.__doc__ = "Single point."
ScatteringPointProviderType.SMOOTH_OBLATE_EARTH.__doc__ = "Smooth oblate earth."
ScatteringPointProviderType.PLUGIN.__doc__ = "Plugin."
ScatteringPointProviderType.RANGE_OVER_CFAR_CELLS.__doc__ = "Range Over CFAR Cells."
ScatteringPointProviderType.POINTS_FILE.__doc__ = "Points File."

agcls.AgTypeNameMap["ScatteringPointProviderType"] = ScatteringPointProviderType

class ScatteringPointModelType(IntEnum):
    """Scattering point model type."""

    UNKNOWN = -1
    """Unknown."""
    PLUGIN = 0
    """Plugin."""
    CONSTANT_COEFFICIENT = 1
    """Constant Coefficient."""
    WIND_TURBINE = 2
    """Constant Coefficient."""

ScatteringPointModelType.UNKNOWN.__doc__ = "Unknown."
ScatteringPointModelType.PLUGIN.__doc__ = "Plugin."
ScatteringPointModelType.CONSTANT_COEFFICIENT.__doc__ = "Constant Coefficient."
ScatteringPointModelType.WIND_TURBINE.__doc__ = "Constant Coefficient."

agcls.AgTypeNameMap["ScatteringPointModelType"] = ScatteringPointModelType

class ScatteringPointProviderListType(IntEnum):
    """Scattering Point Provider List Type."""

    SCATTERING_POINT_PROVIDER_LIST = 0
    """Scattering point provider list."""

ScatteringPointProviderListType.SCATTERING_POINT_PROVIDER_LIST.__doc__ = "Scattering point provider list."

agcls.AgTypeNameMap["ScatteringPointProviderListType"] = ScatteringPointProviderListType

class PolarizationType(IntEnum):
    """Polarization Type."""

    UNKNOWN = -1
    """Unknown."""
    ELLIPTICAL = 0
    """Elliptical."""
    LEFT_HAND_CIRCULAR = 1
    """Lefthand Circular."""
    RIGHT_HAND_CIRCULAR = 2
    """Righthand Circular."""
    LINEAR = 3
    """Linear."""
    HORIZONTAL = 4
    """Horizontal."""
    VERTICAL = 5
    """Vertical."""

PolarizationType.UNKNOWN.__doc__ = "Unknown."
PolarizationType.ELLIPTICAL.__doc__ = "Elliptical."
PolarizationType.LEFT_HAND_CIRCULAR.__doc__ = "Lefthand Circular."
PolarizationType.RIGHT_HAND_CIRCULAR.__doc__ = "Righthand Circular."
PolarizationType.LINEAR.__doc__ = "Linear."
PolarizationType.HORIZONTAL.__doc__ = "Horizontal."
PolarizationType.VERTICAL.__doc__ = "Vertical."

agcls.AgTypeNameMap["PolarizationType"] = PolarizationType

class PolarizationReferenceAxis(IntEnum):
    """Polarization reference axis."""

    X = 0
    """X."""
    Y = 1
    """Y."""
    Z = 2
    """Z."""

PolarizationReferenceAxis.X.__doc__ = "X."
PolarizationReferenceAxis.Y.__doc__ = "Y."
PolarizationReferenceAxis.Z.__doc__ = "Z."

agcls.AgTypeNameMap["PolarizationReferenceAxis"] = PolarizationReferenceAxis

class NoiseTemperatureComputeType(IntEnum):
    """System noise temperature compute type."""

    CONSTANT = 0
    """Constant."""
    CALCULATE = 1
    """Calculated."""

NoiseTemperatureComputeType.CONSTANT.__doc__ = "Constant."
NoiseTemperatureComputeType.CALCULATE.__doc__ = "Calculated."

agcls.AgTypeNameMap["NoiseTemperatureComputeType"] = NoiseTemperatureComputeType

class PointingStrategyType(IntEnum):
    """Pointing strategy type."""

    UNKNOWN = -1
    """Unknown."""
    FIXED = 0
    """Fixed."""
    SPINNING = 1
    """Spinning."""
    TARGETED = 2
    """Targeted."""

PointingStrategyType.UNKNOWN.__doc__ = "Unknown."
PointingStrategyType.FIXED.__doc__ = "Fixed."
PointingStrategyType.SPINNING.__doc__ = "Spinning."
PointingStrategyType.TARGETED.__doc__ = "Targeted."

agcls.AgTypeNameMap["PointingStrategyType"] = PointingStrategyType

class WaveformType(IntEnum):
    """Waveform types."""

    UNKNOWN = -1
    """Unknown waveform type."""
    RECTANGULAR = 0
    """Unknown waveform type."""

WaveformType.UNKNOWN.__doc__ = "Unknown waveform type."
WaveformType.RECTANGULAR.__doc__ = "Unknown waveform type."

agcls.AgTypeNameMap["WaveformType"] = WaveformType

class FrequencySpecificationType(IntEnum):
    """Frequency Specification Type."""

    FREQUENCY = 0
    """Frequency."""
    WAVELENGTH = 1
    """Wavelength."""

FrequencySpecificationType.FREQUENCY.__doc__ = "Frequency."
FrequencySpecificationType.WAVELENGTH.__doc__ = "Wavelength."

agcls.AgTypeNameMap["FrequencySpecificationType"] = FrequencySpecificationType

class PRFMode(IntEnum):
    """Radar search/track prf modes."""

    PRF = 0
    """PRF."""
    UNAMBIGUOUS_RANGE = 1
    """Unambiguous Range."""
    UNAMBIGUOUS_VELOCITY = 2
    """Unambiguous Velocity."""

PRFMode.PRF.__doc__ = "PRF."
PRFMode.UNAMBIGUOUS_RANGE.__doc__ = "Unambiguous Range."
PRFMode.UNAMBIGUOUS_VELOCITY.__doc__ = "Unambiguous Velocity."

agcls.AgTypeNameMap["PRFMode"] = PRFMode

class PulseWidthMode(IntEnum):
    """Radar search/track pulse width modes."""

    PULSE_WIDTH = 0
    """Pulse Width."""
    DUTY_FACTOR = 1
    """Duty Factory."""

PulseWidthMode.PULSE_WIDTH.__doc__ = "Pulse Width."
PulseWidthMode.DUTY_FACTOR.__doc__ = "Duty Factory."

agcls.AgTypeNameMap["PulseWidthMode"] = PulseWidthMode

class WaveformSelectionStrategyType(IntEnum):
    """Waveform selection strategy type."""

    UNKNOWN = -1
    """Unknown."""
    FIXED = 0
    """Fixed."""
    RANGE_LIMITS = 1
    """Range limits."""

WaveformSelectionStrategyType.UNKNOWN.__doc__ = "Unknown."
WaveformSelectionStrategyType.FIXED.__doc__ = "Fixed."
WaveformSelectionStrategyType.RANGE_LIMITS.__doc__ = "Range limits."

agcls.AgTypeNameMap["WaveformSelectionStrategyType"] = WaveformSelectionStrategyType

class AntennaControlReferenceType(IntEnum):
    """Antenna control reference type."""

    LINK = 0
    """Link to an Antenna object."""
    EMBED = 1
    """Use the embedded antenna model."""

AntennaControlReferenceType.LINK.__doc__ = "Link to an Antenna object."
AntennaControlReferenceType.EMBED.__doc__ = "Use the embedded antenna model."

agcls.AgTypeNameMap["AntennaControlReferenceType"] = AntennaControlReferenceType

class AntennaModelType(IntEnum):
    """Antenna model types."""

    UNKNOWN = -1
    """Unknown antenna model type."""
    GAUSSIAN = 0
    """Gaussian antenna model."""
    PARABOLIC = 1
    """Parabolic antenna model."""
    SQUARE_HORN = 2
    """Square horn antenna model."""
    SCRIPT_PLUGIN = 3
    """Script plugin antenna model."""
    EXTERNAL = 4
    """External antenna model."""
    GIMROC = 5
    """GIMROC antenna model."""
    IEEE1979 = 6
    """IEEE 1979 antenna model."""
    DIPOLE = 7
    """Dipole antenna model."""
    HELIX = 8
    """Helix antenna model."""
    COSECANT_SQUARED = 9
    """Cosecant Squared antenna model."""
    HEMISPHERICAL = 10
    """Hemispherical antenna model."""
    ISOTROPIC = 11
    """Isotropic antenna model."""
    PENCIL_BEAM = 12
    """Pencil beam antenna model."""
    INTEL_SAT = 13
    """IntelSat antenna model."""
    RECTANGULAR_PATTERN = 14
    """Rectangular pattern antenna model."""
    GPS_GLOBAL = 15
    """GPS global antenna model."""
    GPS_FRPA = 16
    """GPS FRPA antenna model."""
    ITU_BO1213_COPOLAR = 17
    """ITU-R BO1213 co-polar antenna model."""
    ITU_BO1213_CROSS_POLAR = 18
    """ITU-R BO1213 cross-polar antenna model."""
    ITU_F1245 = 19
    """ITU-R F1245-3 antenna model."""
    ITU_S580 = 20
    """ITU-R S580-6 antenna model."""
    ITU_S465 = 21
    """ITU-R S465-6 antenna model."""
    ITU_S731 = 22
    """ITU-R S731 antenna model."""
    ITU_S1528R12_CIRCULAR = 23
    """ITU-R S1528 1.2 circular antenna model."""
    ITU_S1528R13 = 24
    """ITU-R S1528 1.3 antenna model."""
    ITU_S672_CIRCULAR = 25
    """ITU-R S672-4 circular antenna model."""
    ITU_S1528R12_RECTANGULAR = 26
    """ITU-R S1528 1.2 rectangular antenna model."""
    ITU_S672_RECTANGULAR = 27
    """ITU-R S672-4 rectangular antenna model."""
    CIRCULAR_COSINE = 28
    """Circular cosine aperture antenna model."""
    BESSEL = 29
    """Circular bessel aperture antenna model."""
    BESSEL_ENVELOPE = 30
    """Circular bessel envelope aperture antenna model."""
    CIRCULAR_COSINE_PEDESTAL = 31
    """Circular cosine pedestal aperture antenna model."""
    CIRCULAR_COSINE_SQUARED = 32
    """Circular cosine squared aperture antenna model."""
    CIRCULAR_COSINE_SQUARED_PEDESTAL = 33
    """Circular cosine squared pedestal aperture antenna model."""
    CIRCULAR_SINC_INTEGER_POWER = 34
    """Circular sinc integer power aperture antenna model."""
    CIRCULAR_SINC_REAL_POWER = 35
    """Circular sinc real power aperture antenna model."""
    CIRCULAR_UNIFORM = 36
    """Circular uniform aperture antenna model."""
    RECTANGULAR_COSINE = 37
    """Rectangular cosine aperture antenna model."""
    RECTANGULAR_COSINE_PEDESTAL = 38
    """Rectangular cosine pedestal aperture antenna model."""
    RECTANGULAR_COSINE_SQUARED = 39
    """Rectangular cosine squared aperture antenna model."""
    RECTANGULAR_COSINE_SQUARED_PEDESTAL = 40
    """Rectangular cosine squared pedestal aperture antenna model."""
    RECTANGULAR_SINC_INTEGER_POWER = 41
    """Rectangular sinc integer power aperture antenna model."""
    RECTANGULAR_SINC_REAL_POWER = 42
    """Rectangular sinc real power aperture antenna model."""
    RECTANGULAR_UNIFORM = 43
    """Rectangular uniform aperture antenna model."""
    OPTICAL_SIMPLE = 44
    """Simple optical antenna model."""
    OPTICAL_GAUSSIAN = 45
    """Gaussian optical antenna model."""
    PHASED_ARRAY = 46
    """Phased array antenna model."""
    ELEVATION_AZIMUTH_CUTS = 47
    """Pattern Elevation/Azimuth Cuts antenna model."""
    REMCOM_UAN_FORMAT = 48
    """Pattern Remcom Uan antenna model."""
    ANSYS_FFD_FORMAT = 49
    """Pattern ANSYS ffd antenna model."""
    TICRA_GRASP_FORMAT = 50
    """Pattern Ticra GRASP antenna model."""
    HFSS_EEP_ARRAY = 51
    """HFSS EEP array antenna model."""

AntennaModelType.UNKNOWN.__doc__ = "Unknown antenna model type."
AntennaModelType.GAUSSIAN.__doc__ = "Gaussian antenna model."
AntennaModelType.PARABOLIC.__doc__ = "Parabolic antenna model."
AntennaModelType.SQUARE_HORN.__doc__ = "Square horn antenna model."
AntennaModelType.SCRIPT_PLUGIN.__doc__ = "Script plugin antenna model."
AntennaModelType.EXTERNAL.__doc__ = "External antenna model."
AntennaModelType.GIMROC.__doc__ = "GIMROC antenna model."
AntennaModelType.IEEE1979.__doc__ = "IEEE 1979 antenna model."
AntennaModelType.DIPOLE.__doc__ = "Dipole antenna model."
AntennaModelType.HELIX.__doc__ = "Helix antenna model."
AntennaModelType.COSECANT_SQUARED.__doc__ = "Cosecant Squared antenna model."
AntennaModelType.HEMISPHERICAL.__doc__ = "Hemispherical antenna model."
AntennaModelType.ISOTROPIC.__doc__ = "Isotropic antenna model."
AntennaModelType.PENCIL_BEAM.__doc__ = "Pencil beam antenna model."
AntennaModelType.INTEL_SAT.__doc__ = "IntelSat antenna model."
AntennaModelType.RECTANGULAR_PATTERN.__doc__ = "Rectangular pattern antenna model."
AntennaModelType.GPS_GLOBAL.__doc__ = "GPS global antenna model."
AntennaModelType.GPS_FRPA.__doc__ = "GPS FRPA antenna model."
AntennaModelType.ITU_BO1213_COPOLAR.__doc__ = "ITU-R BO1213 co-polar antenna model."
AntennaModelType.ITU_BO1213_CROSS_POLAR.__doc__ = "ITU-R BO1213 cross-polar antenna model."
AntennaModelType.ITU_F1245.__doc__ = "ITU-R F1245-3 antenna model."
AntennaModelType.ITU_S580.__doc__ = "ITU-R S580-6 antenna model."
AntennaModelType.ITU_S465.__doc__ = "ITU-R S465-6 antenna model."
AntennaModelType.ITU_S731.__doc__ = "ITU-R S731 antenna model."
AntennaModelType.ITU_S1528R12_CIRCULAR.__doc__ = "ITU-R S1528 1.2 circular antenna model."
AntennaModelType.ITU_S1528R13.__doc__ = "ITU-R S1528 1.3 antenna model."
AntennaModelType.ITU_S672_CIRCULAR.__doc__ = "ITU-R S672-4 circular antenna model."
AntennaModelType.ITU_S1528R12_RECTANGULAR.__doc__ = "ITU-R S1528 1.2 rectangular antenna model."
AntennaModelType.ITU_S672_RECTANGULAR.__doc__ = "ITU-R S672-4 rectangular antenna model."
AntennaModelType.CIRCULAR_COSINE.__doc__ = "Circular cosine aperture antenna model."
AntennaModelType.BESSEL.__doc__ = "Circular bessel aperture antenna model."
AntennaModelType.BESSEL_ENVELOPE.__doc__ = "Circular bessel envelope aperture antenna model."
AntennaModelType.CIRCULAR_COSINE_PEDESTAL.__doc__ = "Circular cosine pedestal aperture antenna model."
AntennaModelType.CIRCULAR_COSINE_SQUARED.__doc__ = "Circular cosine squared aperture antenna model."
AntennaModelType.CIRCULAR_COSINE_SQUARED_PEDESTAL.__doc__ = "Circular cosine squared pedestal aperture antenna model."
AntennaModelType.CIRCULAR_SINC_INTEGER_POWER.__doc__ = "Circular sinc integer power aperture antenna model."
AntennaModelType.CIRCULAR_SINC_REAL_POWER.__doc__ = "Circular sinc real power aperture antenna model."
AntennaModelType.CIRCULAR_UNIFORM.__doc__ = "Circular uniform aperture antenna model."
AntennaModelType.RECTANGULAR_COSINE.__doc__ = "Rectangular cosine aperture antenna model."
AntennaModelType.RECTANGULAR_COSINE_PEDESTAL.__doc__ = "Rectangular cosine pedestal aperture antenna model."
AntennaModelType.RECTANGULAR_COSINE_SQUARED.__doc__ = "Rectangular cosine squared aperture antenna model."
AntennaModelType.RECTANGULAR_COSINE_SQUARED_PEDESTAL.__doc__ = "Rectangular cosine squared pedestal aperture antenna model."
AntennaModelType.RECTANGULAR_SINC_INTEGER_POWER.__doc__ = "Rectangular sinc integer power aperture antenna model."
AntennaModelType.RECTANGULAR_SINC_REAL_POWER.__doc__ = "Rectangular sinc real power aperture antenna model."
AntennaModelType.RECTANGULAR_UNIFORM.__doc__ = "Rectangular uniform aperture antenna model."
AntennaModelType.OPTICAL_SIMPLE.__doc__ = "Simple optical antenna model."
AntennaModelType.OPTICAL_GAUSSIAN.__doc__ = "Gaussian optical antenna model."
AntennaModelType.PHASED_ARRAY.__doc__ = "Phased array antenna model."
AntennaModelType.ELEVATION_AZIMUTH_CUTS.__doc__ = "Pattern Elevation/Azimuth Cuts antenna model."
AntennaModelType.REMCOM_UAN_FORMAT.__doc__ = "Pattern Remcom Uan antenna model."
AntennaModelType.ANSYS_FFD_FORMAT.__doc__ = "Pattern ANSYS ffd antenna model."
AntennaModelType.TICRA_GRASP_FORMAT.__doc__ = "Pattern Ticra GRASP antenna model."
AntennaModelType.HFSS_EEP_ARRAY.__doc__ = "HFSS EEP array antenna model."

agcls.AgTypeNameMap["AntennaModelType"] = AntennaModelType

class AntennaContourType(IntEnum):
    """Antenna contour types."""

    GAIN = 0
    """Gain."""
    EIRP = 1
    """EIRP."""
    RIP = 2
    """RIP."""
    FLUX_DENSITY = 3
    """Flux Density."""
    SPECTRAL_FLUX_DENSITY = 4
    """Spectral Flux Density."""

AntennaContourType.GAIN.__doc__ = "Gain."
AntennaContourType.EIRP.__doc__ = "EIRP."
AntennaContourType.RIP.__doc__ = "RIP."
AntennaContourType.FLUX_DENSITY.__doc__ = "Flux Density."
AntennaContourType.SPECTRAL_FLUX_DENSITY.__doc__ = "Spectral Flux Density."

agcls.AgTypeNameMap["AntennaContourType"] = AntennaContourType

class CircularApertureInputType(IntEnum):
    """Circular aperture antenna input type."""

    BEAMWIDTH = 0
    """Beamwidth."""
    DIAMETER = 1
    """Diameter."""

CircularApertureInputType.BEAMWIDTH.__doc__ = "Beamwidth."
CircularApertureInputType.DIAMETER.__doc__ = "Diameter."

agcls.AgTypeNameMap["CircularApertureInputType"] = CircularApertureInputType

class RectangularApertureInputType(IntEnum):
    """Rectangular aperture antenna input type."""

    BEAMWIDTHS = 0
    """Beamwidth."""
    DIMENSIONS = 1
    """Diameter."""

RectangularApertureInputType.BEAMWIDTHS.__doc__ = "Beamwidth."
RectangularApertureInputType.DIMENSIONS.__doc__ = "Diameter."

agcls.AgTypeNameMap["RectangularApertureInputType"] = RectangularApertureInputType

class DirectionProviderType(IntEnum):
    """Direction Provider types."""

    UNKNOWN = -1
    """Unknown direction provider type."""
    ASCII_FILE = 0
    """Ascii file direction provider type."""
    OBJECT = 1
    """Object direction provider type."""
    LINK = 2
    """Link direction provider type."""
    SCRIPT = 3
    """Script plugin direction provider type."""

DirectionProviderType.UNKNOWN.__doc__ = "Unknown direction provider type."
DirectionProviderType.ASCII_FILE.__doc__ = "Ascii file direction provider type."
DirectionProviderType.OBJECT.__doc__ = "Object direction provider type."
DirectionProviderType.LINK.__doc__ = "Link direction provider type."
DirectionProviderType.SCRIPT.__doc__ = "Script plugin direction provider type."

agcls.AgTypeNameMap["DirectionProviderType"] = DirectionProviderType

class BeamformerType(IntEnum):
    """Beamformer types."""

    UNKNOWN = -1
    """Unknown beamformer type."""
    MVDR = 0
    """Mvdr beamformer type."""
    SCRIPT = 1
    """Script plugin beamformer type."""
    ASCII_FILE = 2
    """Ascrii file beamformer type."""
    UNIFORM = 3
    """Uniform type."""
    BLACKMAN_HARRIS = 4
    """Blackman-Harris type."""
    COSINE = 5
    """Cosine type."""
    COSINE_X = 6
    """Cosine^X type."""
    CUSTOM_TAPER_FILE = 7
    """Custom Taper File type."""
    DOLPH_CHEBYSHEV = 8
    """Dolph-Chebyshev type."""
    HAMMING = 9
    """Hamming type."""
    HANN = 10
    """Hann type."""
    RAISED_COSINE = 11
    """Raised Cosine type."""
    RAISED_COSINE_SQUARED = 12
    """Raised Cosine^2 type."""
    TAYLOR = 13
    """Taylor type."""

BeamformerType.UNKNOWN.__doc__ = "Unknown beamformer type."
BeamformerType.MVDR.__doc__ = "Mvdr beamformer type."
BeamformerType.SCRIPT.__doc__ = "Script plugin beamformer type."
BeamformerType.ASCII_FILE.__doc__ = "Ascrii file beamformer type."
BeamformerType.UNIFORM.__doc__ = "Uniform type."
BeamformerType.BLACKMAN_HARRIS.__doc__ = "Blackman-Harris type."
BeamformerType.COSINE.__doc__ = "Cosine type."
BeamformerType.COSINE_X.__doc__ = "Cosine^X type."
BeamformerType.CUSTOM_TAPER_FILE.__doc__ = "Custom Taper File type."
BeamformerType.DOLPH_CHEBYSHEV.__doc__ = "Dolph-Chebyshev type."
BeamformerType.HAMMING.__doc__ = "Hamming type."
BeamformerType.HANN.__doc__ = "Hann type."
BeamformerType.RAISED_COSINE.__doc__ = "Raised Cosine type."
BeamformerType.RAISED_COSINE_SQUARED.__doc__ = "Raised Cosine^2 type."
BeamformerType.TAYLOR.__doc__ = "Taylor type."

agcls.AgTypeNameMap["BeamformerType"] = BeamformerType

class ElementConfigurationType(IntEnum):
    """Element configuration types."""

    UNKNOWN = -1
    """Unknown element configuration type."""
    CIRCULAR = 0
    """Circular element configuration type."""
    HEXAGON = 1
    """Hexagon plugin element configuration type."""
    LINEAR = 2
    """Linear element configuration type."""
    POLYGON = 3
    """Polygon element configuration type."""
    ASCII_FILE = 4
    """Ascii file element configuration type."""
    HFSS_EEP_FILE = 5
    """HFSS EEP element configuration type."""

ElementConfigurationType.UNKNOWN.__doc__ = "Unknown element configuration type."
ElementConfigurationType.CIRCULAR.__doc__ = "Circular element configuration type."
ElementConfigurationType.HEXAGON.__doc__ = "Hexagon plugin element configuration type."
ElementConfigurationType.LINEAR.__doc__ = "Linear element configuration type."
ElementConfigurationType.POLYGON.__doc__ = "Polygon element configuration type."
ElementConfigurationType.ASCII_FILE.__doc__ = "Ascii file element configuration type."
ElementConfigurationType.HFSS_EEP_FILE.__doc__ = "HFSS EEP element configuration type."

agcls.AgTypeNameMap["ElementConfigurationType"] = ElementConfigurationType

class LatticeType(IntEnum):
    """Lattice types."""

    TRIANGULAR = 0
    """Triangular lattice type."""
    RECTANGULAR = 1
    """Rectangular lattice type."""

LatticeType.TRIANGULAR.__doc__ = "Triangular lattice type."
LatticeType.RECTANGULAR.__doc__ = "Rectangular lattice type."

agcls.AgTypeNameMap["LatticeType"] = LatticeType

class SpacingUnit(IntEnum):
    """Spacing Units."""

    WAVELENGTH_RATIO = 0
    """Specify element spacing as a Wavelength Ratio."""
    DISTANCE = 1
    """Specify element spacing as a Distance."""

SpacingUnit.WAVELENGTH_RATIO.__doc__ = "Specify element spacing as a Wavelength Ratio."
SpacingUnit.DISTANCE.__doc__ = "Specify element spacing as a Distance."

agcls.AgTypeNameMap["SpacingUnit"] = SpacingUnit

class LimitsExceededBehaviorType(IntEnum):
    """Limits Exceeded Behavior types."""

    CLAMP_TO_LIMIT = 0
    """Clamp-To-Limit limits exceeded behavior type."""
    IGNORE_OBJECT = 1
    """Ignore Object limits exceeded behavior type."""

LimitsExceededBehaviorType.CLAMP_TO_LIMIT.__doc__ = "Clamp-To-Limit limits exceeded behavior type."
LimitsExceededBehaviorType.IGNORE_OBJECT.__doc__ = "Ignore Object limits exceeded behavior type."

agcls.AgTypeNameMap["LimitsExceededBehaviorType"] = LimitsExceededBehaviorType

class TargetSelectionMethod(IntEnum):
    """Target Selection Method types."""

    RANGE = 0
    """Select a target based on the minimum range."""
    CLOSING_VELOCITY = 1
    """Select a target based on the maximum closing velocity."""
    PRIORITY = 2
    """Select an target based a user defined priority."""

TargetSelectionMethod.RANGE.__doc__ = "Select a target based on the minimum range."
TargetSelectionMethod.CLOSING_VELOCITY.__doc__ = "Select a target based on the maximum closing velocity."
TargetSelectionMethod.PRIORITY.__doc__ = "Select an target based a user defined priority."

agcls.AgTypeNameMap["TargetSelectionMethod"] = TargetSelectionMethod

class AntennaGraphicsCoordinateSystem(IntEnum):
    """Coordinate system for defining antenna graphics resolution."""

    POLAR = 0
    """Polar."""
    RECTANGULAR = 1
    """Rectangular."""
    SPHERICAL_AZ_EL = 2
    """Spherical Az/El."""

AntennaGraphicsCoordinateSystem.POLAR.__doc__ = "Polar."
AntennaGraphicsCoordinateSystem.RECTANGULAR.__doc__ = "Rectangular."
AntennaGraphicsCoordinateSystem.SPHERICAL_AZ_EL.__doc__ = "Spherical Az/El."

agcls.AgTypeNameMap["AntennaGraphicsCoordinateSystem"] = AntennaGraphicsCoordinateSystem

class AntennaModelInputType(IntEnum):
    """Diameter computation input type."""

    BEAMWIDTH = 0
    """Beamwidth input type."""
    DIAMETER = 1
    """Diameter input type."""
    MAINLOBE_GAIN = 2
    """Main-lobe gain input type."""

AntennaModelInputType.BEAMWIDTH.__doc__ = "Beamwidth input type."
AntennaModelInputType.DIAMETER.__doc__ = "Diameter input type."
AntennaModelInputType.MAINLOBE_GAIN.__doc__ = "Main-lobe gain input type."

agcls.AgTypeNameMap["AntennaModelInputType"] = AntennaModelInputType

class HFSSFarFieldDataGainType(IntEnum):
    """Gain type."""

    TOTAL_GAIN = 0
    """Total Gain."""
    REALIZED_GAIN = 1
    """Realized Gain."""

HFSSFarFieldDataGainType.TOTAL_GAIN.__doc__ = "Total Gain."
HFSSFarFieldDataGainType.REALIZED_GAIN.__doc__ = "Realized Gain."

agcls.AgTypeNameMap["HFSSFarFieldDataGainType"] = HFSSFarFieldDataGainType

class AntennaModelCosecantSquaredSidelobeType(IntEnum):
    """Cosecant Squared antenna sidelobe selection types."""

    CONSTANT = 0
    """Cosecant Squared Sidelobe Value Constant."""
    SINC = 1
    """Cosecant Squared Sidelobe type Sinc."""
    GAUSSIAN = 2
    """Cosecant Squared Sidelobe type Gaussian."""
    PARABOLIC = 3
    """Cosecant Squared Sidelobe type Parabolic."""
    SQUARE_HORN = 4
    """Cosecant Squared Sidelobe type Square Horn."""

AntennaModelCosecantSquaredSidelobeType.CONSTANT.__doc__ = "Cosecant Squared Sidelobe Value Constant."
AntennaModelCosecantSquaredSidelobeType.SINC.__doc__ = "Cosecant Squared Sidelobe type Sinc."
AntennaModelCosecantSquaredSidelobeType.GAUSSIAN.__doc__ = "Cosecant Squared Sidelobe type Gaussian."
AntennaModelCosecantSquaredSidelobeType.PARABOLIC.__doc__ = "Cosecant Squared Sidelobe type Parabolic."
AntennaModelCosecantSquaredSidelobeType.SQUARE_HORN.__doc__ = "Cosecant Squared Sidelobe type Square Horn."

agcls.AgTypeNameMap["AntennaModelCosecantSquaredSidelobeType"] = AntennaModelCosecantSquaredSidelobeType

class BeamSelectionStrategyType(IntEnum):
    """Beam selection strategy types."""

    UNKNOWN = -1
    """Unknown."""
    AGGREGATE = 0
    """Aggregate."""
    MAXIMUM_GAIN = 1
    """Maximum gain."""
    MINIMUM_BORESIGHT_ANGLE = 2
    """Minimum boresight angle."""
    SCRIPT_PLUGIN = 3
    """Script plugin."""

BeamSelectionStrategyType.UNKNOWN.__doc__ = "Unknown."
BeamSelectionStrategyType.AGGREGATE.__doc__ = "Aggregate."
BeamSelectionStrategyType.MAXIMUM_GAIN.__doc__ = "Maximum gain."
BeamSelectionStrategyType.MINIMUM_BORESIGHT_ANGLE.__doc__ = "Minimum boresight angle."
BeamSelectionStrategyType.SCRIPT_PLUGIN.__doc__ = "Script plugin."

agcls.AgTypeNameMap["BeamSelectionStrategyType"] = BeamSelectionStrategyType

class TransmitterModelType(IntEnum):
    """Transmitter model types."""

    UNKNOWN = -1
    """Unknown transmitter model type."""
    SIMPLE = 0
    """Simple transmitter model."""
    MEDIUM = 1
    """Medium transmitter model."""
    COMPLEX = 2
    """Complex transmitter model."""
    RETRANSMITTER_MODEL_TYPE_SIMPLE = 3
    """Simple re-transmitter model."""
    RETRANSMITTER_MODEL_TYPE_MEDIUM = 4
    """Medium re-transmitter model."""
    RETRANSMITTER_MODEL_TYPE_COMPLEX = 5
    """Complex re-transmitter model."""
    SCRIPT_PLUGIN_RF = 6
    """RF script plugin transmitter model."""
    SCRIPT_PLUGIN_LASER = 7
    """Laser script plugin transmitter model."""
    LASER = 8
    """Laser script plugin transmitter model."""
    CABLE = 9
    """Cable transmitter model."""
    MULTIBEAM = 10
    """Multibeam transmitter model."""

TransmitterModelType.UNKNOWN.__doc__ = "Unknown transmitter model type."
TransmitterModelType.SIMPLE.__doc__ = "Simple transmitter model."
TransmitterModelType.MEDIUM.__doc__ = "Medium transmitter model."
TransmitterModelType.COMPLEX.__doc__ = "Complex transmitter model."
TransmitterModelType.RETRANSMITTER_MODEL_TYPE_SIMPLE.__doc__ = "Simple re-transmitter model."
TransmitterModelType.RETRANSMITTER_MODEL_TYPE_MEDIUM.__doc__ = "Medium re-transmitter model."
TransmitterModelType.RETRANSMITTER_MODEL_TYPE_COMPLEX.__doc__ = "Complex re-transmitter model."
TransmitterModelType.SCRIPT_PLUGIN_RF.__doc__ = "RF script plugin transmitter model."
TransmitterModelType.SCRIPT_PLUGIN_LASER.__doc__ = "Laser script plugin transmitter model."
TransmitterModelType.LASER.__doc__ = "Laser script plugin transmitter model."
TransmitterModelType.CABLE.__doc__ = "Cable transmitter model."
TransmitterModelType.MULTIBEAM.__doc__ = "Multibeam transmitter model."

agcls.AgTypeNameMap["TransmitterModelType"] = TransmitterModelType

class TransferFunctionType(IntEnum):
    """Transmitter model types."""

    POLYNOMIAL = 0
    """Polynomial."""
    TABLE_DATA = 1
    """Medium transmitter model."""

TransferFunctionType.POLYNOMIAL.__doc__ = "Polynomial."
TransferFunctionType.TABLE_DATA.__doc__ = "Medium transmitter model."

agcls.AgTypeNameMap["TransferFunctionType"] = TransferFunctionType

class ReTransmitterOpMode(IntEnum):
    """Re-Transmitter operational mode."""

    UNADJUSTED_RECEIVE_FLUX_DENSITY = 0
    """Use unadjusted receive flux density."""
    RECEIVER_ANTENNA_GAIN_DELTA_ADJUSTED_FLUX_DENSITY = 1
    """Use receiver antenna gain delta adjusted flux density."""
    CONSTANT_OUTPUT_POWER = 2
    """Use constant output power."""

ReTransmitterOpMode.UNADJUSTED_RECEIVE_FLUX_DENSITY.__doc__ = "Use unadjusted receive flux density."
ReTransmitterOpMode.RECEIVER_ANTENNA_GAIN_DELTA_ADJUSTED_FLUX_DENSITY.__doc__ = "Use receiver antenna gain delta adjusted flux density."
ReTransmitterOpMode.CONSTANT_OUTPUT_POWER.__doc__ = "Use constant output power."

agcls.AgTypeNameMap["ReTransmitterOpMode"] = ReTransmitterOpMode

class ReceiverModelType(IntEnum):
    """Receiver model types."""

    UNKNOWN = -1
    """Unknown receiver model type."""
    SIMPLE = 0
    """Simple receiver model."""
    MEDIUM = 1
    """Medium receiver model."""
    COMPLEX = 2
    """Complex transmitter model."""
    SCRIPT_PLUGIN_RF = 3
    """RF script plugin receiver model."""
    SCRIPT_PLUGIN_LASER = 4
    """Laser script plugin receiver model."""
    CABLE = 5
    """Cable receiver model."""
    LASER = 6
    """Laser receiver model."""
    MULTIBEAM = 7
    """Multibeam receiver model."""

ReceiverModelType.UNKNOWN.__doc__ = "Unknown receiver model type."
ReceiverModelType.SIMPLE.__doc__ = "Simple receiver model."
ReceiverModelType.MEDIUM.__doc__ = "Medium receiver model."
ReceiverModelType.COMPLEX.__doc__ = "Complex transmitter model."
ReceiverModelType.SCRIPT_PLUGIN_RF.__doc__ = "RF script plugin receiver model."
ReceiverModelType.SCRIPT_PLUGIN_LASER.__doc__ = "Laser script plugin receiver model."
ReceiverModelType.CABLE.__doc__ = "Cable receiver model."
ReceiverModelType.LASER.__doc__ = "Laser receiver model."
ReceiverModelType.MULTIBEAM.__doc__ = "Multibeam receiver model."

agcls.AgTypeNameMap["ReceiverModelType"] = ReceiverModelType

class LinkMarginType(IntEnum):
    """Link margin types."""

    BIT_ERROR_RATE = 0
    """BER."""
    EB_OVER_N0 = 1
    """Eb/No."""
    C_OVER_N = 2
    """C/N."""
    C_OVER_N0 = 3
    """C/No."""
    FLUX_DENSITY = 4
    """Flux Density."""
    RECEIVED_CARRIER_POWER = 5
    """Rcvd Carrier Power."""
    RECEIVED_ISOTROPIC_POWER = 6
    """RIP."""

LinkMarginType.BIT_ERROR_RATE.__doc__ = "BER."
LinkMarginType.EB_OVER_N0.__doc__ = "Eb/No."
LinkMarginType.C_OVER_N.__doc__ = "C/N."
LinkMarginType.C_OVER_N0.__doc__ = "C/No."
LinkMarginType.FLUX_DENSITY.__doc__ = "Flux Density."
LinkMarginType.RECEIVED_CARRIER_POWER.__doc__ = "Rcvd Carrier Power."
LinkMarginType.RECEIVED_ISOTROPIC_POWER.__doc__ = "RIP."

agcls.AgTypeNameMap["LinkMarginType"] = LinkMarginType

class RadarSTCAttenuationType(IntEnum):
    """Stc Attenuation Type."""

    UNKNOWN = -1
    """Unknown STC type."""
    DECAY_FACTOR = 0
    """Decay Factor."""
    DECAY_SLOPE = 1
    """Decay Slope."""
    MAP_RANGE = 2
    """Map Range."""
    MAP_AZIMUTH_RANGE = 3
    """Map Azimuth-Range."""
    MAP_ELEVATION_RANGE = 4
    """Map Elevation-Range."""
    PLUGIN = 5
    """STC COM Plugin."""

RadarSTCAttenuationType.UNKNOWN.__doc__ = "Unknown STC type."
RadarSTCAttenuationType.DECAY_FACTOR.__doc__ = "Decay Factor."
RadarSTCAttenuationType.DECAY_SLOPE.__doc__ = "Decay Slope."
RadarSTCAttenuationType.MAP_RANGE.__doc__ = "Map Range."
RadarSTCAttenuationType.MAP_AZIMUTH_RANGE.__doc__ = "Map Azimuth-Range."
RadarSTCAttenuationType.MAP_ELEVATION_RANGE.__doc__ = "Map Elevation-Range."
RadarSTCAttenuationType.PLUGIN.__doc__ = "STC COM Plugin."

agcls.AgTypeNameMap["RadarSTCAttenuationType"] = RadarSTCAttenuationType

class RadarFrequencySpecificationType(IntEnum):
    """SNR Contour Type."""

    FREQUENCY = 0
    """Frequency."""
    WAVELENGTH = 1
    """Wavelength."""

RadarFrequencySpecificationType.FREQUENCY.__doc__ = "Frequency."
RadarFrequencySpecificationType.WAVELENGTH.__doc__ = "Wavelength."

agcls.AgTypeNameMap["RadarFrequencySpecificationType"] = RadarFrequencySpecificationType

class RadarSNRContourType(IntEnum):
    """SNR Contour Type."""

    SINGLE_PULSE = 0
    """Single Pulse SNR."""
    INTEGRATED = 1
    """Integrated SNR."""

RadarSNRContourType.SINGLE_PULSE.__doc__ = "Single Pulse SNR."
RadarSNRContourType.INTEGRATED.__doc__ = "Integrated SNR."

agcls.AgTypeNameMap["RadarSNRContourType"] = RadarSNRContourType

class RadarModelType(IntEnum):
    """Radar system types."""

    UNKNOWN = -1
    """Unknown radar system type."""
    MONOSTATIC = 0
    """Monostatic radar system."""
    BISTATIC_TRANSMITTER = 1
    """Bistatic transmitter radar system."""
    BISTATIC_RECEIVER = 2
    """Bistatic receiver radar system."""
    MULTIFUNCTION = 3
    """Multtifunction radar system."""

RadarModelType.UNKNOWN.__doc__ = "Unknown radar system type."
RadarModelType.MONOSTATIC.__doc__ = "Monostatic radar system."
RadarModelType.BISTATIC_TRANSMITTER.__doc__ = "Bistatic transmitter radar system."
RadarModelType.BISTATIC_RECEIVER.__doc__ = "Bistatic receiver radar system."
RadarModelType.MULTIFUNCTION.__doc__ = "Multtifunction radar system."

agcls.AgTypeNameMap["RadarModelType"] = RadarModelType

class RadarMode(IntEnum):
    """Radar mode types."""

    UNKNOWN = -1
    """Unknown radar mode type."""
    SEARCH_TRACK = 0
    """Search/Track."""
    SAR = 1
    """SAR."""

RadarMode.UNKNOWN.__doc__ = "Unknown radar mode type."
RadarMode.SEARCH_TRACK.__doc__ = "Search/Track."
RadarMode.SAR.__doc__ = "SAR."

agcls.AgTypeNameMap["RadarMode"] = RadarMode

class RadarWaveformSearchTrackType(IntEnum):
    """Radar search/track waveform types."""

    FIXED_PRF = 0
    """Fixed PRF."""
    CONTINUOUS = 1
    """Continuous."""

RadarWaveformSearchTrackType.FIXED_PRF.__doc__ = "Fixed PRF."
RadarWaveformSearchTrackType.CONTINUOUS.__doc__ = "Continuous."

agcls.AgTypeNameMap["RadarWaveformSearchTrackType"] = RadarWaveformSearchTrackType

class RadarSearchTrackPRFMode(IntEnum):
    """Radar search/track prf modes."""

    PRF = 0
    """PRF."""
    UNAMBIGUOUS_RANGE = 1
    """Unambiguous Range."""
    UNAMBIGUOUS_VELOCITY = 2
    """Unambiguous Velocity."""

RadarSearchTrackPRFMode.PRF.__doc__ = "PRF."
RadarSearchTrackPRFMode.UNAMBIGUOUS_RANGE.__doc__ = "Unambiguous Range."
RadarSearchTrackPRFMode.UNAMBIGUOUS_VELOCITY.__doc__ = "Unambiguous Velocity."

agcls.AgTypeNameMap["RadarSearchTrackPRFMode"] = RadarSearchTrackPRFMode

class RadarSearchTrackPulseWidthMode(IntEnum):
    """Radar search/track pulse width modes."""

    PULSE_WIDTH = 0
    """Pulse Width."""
    DUTY_FACTOR = 1
    """Duty Factory."""

RadarSearchTrackPulseWidthMode.PULSE_WIDTH.__doc__ = "Pulse Width."
RadarSearchTrackPulseWidthMode.DUTY_FACTOR.__doc__ = "Duty Factory."

agcls.AgTypeNameMap["RadarSearchTrackPulseWidthMode"] = RadarSearchTrackPulseWidthMode

class RadarSarPRFMode(IntEnum):
    """Radar SAR prf modes."""

    PRF = 0
    """PRF."""
    UNAMBIGUOUS_RANGE = 1
    """Unambiguous Range."""

RadarSarPRFMode.PRF.__doc__ = "PRF."
RadarSarPRFMode.UNAMBIGUOUS_RANGE.__doc__ = "Unambiguous Range."

agcls.AgTypeNameMap["RadarSarPRFMode"] = RadarSarPRFMode

class RadarSarRangeResolutionMode(IntEnum):
    """Radar SAR range resolution modes."""

    RANGE_RESOLUTION = 0
    """Range Resolution."""
    BANDWIDTH = 1
    """Bandwidth."""

RadarSarRangeResolutionMode.RANGE_RESOLUTION.__doc__ = "Range Resolution."
RadarSarRangeResolutionMode.BANDWIDTH.__doc__ = "Bandwidth."

agcls.AgTypeNameMap["RadarSarRangeResolutionMode"] = RadarSarRangeResolutionMode

class RadarSarPcrMode(IntEnum):
    """Radar SAR pulse compression ratio modes."""

    PULSE_COMPRESSION_RATIO = 0
    """Pulse compression ratio."""
    PULSE_WIDTH = 1
    """Pulse Width."""
    SCENE_DEPTH = 2
    """Scene Depth."""
    FM_CHIRP_RATE = 3
    """FM Chirp Rate."""

RadarSarPcrMode.PULSE_COMPRESSION_RATIO.__doc__ = "Pulse compression ratio."
RadarSarPcrMode.PULSE_WIDTH.__doc__ = "Pulse Width."
RadarSarPcrMode.SCENE_DEPTH.__doc__ = "Scene Depth."
RadarSarPcrMode.FM_CHIRP_RATE.__doc__ = "FM Chirp Rate."

agcls.AgTypeNameMap["RadarSarPcrMode"] = RadarSarPcrMode

class RadarSARPulseIntegrationAnalysisMode(IntEnum):
    """Radar sar pulse integration mode."""

    FIXED_AZIMUTH_RESOLUTION = 0
    """Fixed azimuth resolution."""
    FIXED_INTEGRATION_TIME = 1
    """Fixed integration time."""

RadarSARPulseIntegrationAnalysisMode.FIXED_AZIMUTH_RESOLUTION.__doc__ = "Fixed azimuth resolution."
RadarSARPulseIntegrationAnalysisMode.FIXED_INTEGRATION_TIME.__doc__ = "Fixed integration time."

agcls.AgTypeNameMap["RadarSARPulseIntegrationAnalysisMode"] = RadarSARPulseIntegrationAnalysisMode

class RadarProbabilityOfDetectionType(IntEnum):
    """Radar probability of detection type."""

    UNKNOWN = -1
    """Unknown radar mode type."""
    CFAR = 0
    """CFAR."""
    NON_CFAR = 1
    """Non-CFAR."""
    CFAR_CELL_AVERAGING = 2
    """Cell Averaging CFAR."""
    CFAR_ORDERED_STATISTICS = 3
    """Ordered Statistics CFAR."""
    PLUGIN = 4
    """Plugin."""

RadarProbabilityOfDetectionType.UNKNOWN.__doc__ = "Unknown radar mode type."
RadarProbabilityOfDetectionType.CFAR.__doc__ = "CFAR."
RadarProbabilityOfDetectionType.NON_CFAR.__doc__ = "Non-CFAR."
RadarProbabilityOfDetectionType.CFAR_CELL_AVERAGING.__doc__ = "Cell Averaging CFAR."
RadarProbabilityOfDetectionType.CFAR_ORDERED_STATISTICS.__doc__ = "Ordered Statistics CFAR."
RadarProbabilityOfDetectionType.PLUGIN.__doc__ = "Plugin."

agcls.AgTypeNameMap["RadarProbabilityOfDetectionType"] = RadarProbabilityOfDetectionType

class RadarPulseIntegrationType(IntEnum):
    """Radar pulse integration type."""

    GOAL_SNR = 0
    """Goal SNR."""
    FIXED_NUMBER_OF_PULSES = 1
    """Fixed number of pulses."""

RadarPulseIntegrationType.GOAL_SNR.__doc__ = "Goal SNR."
RadarPulseIntegrationType.FIXED_NUMBER_OF_PULSES.__doc__ = "Fixed number of pulses."

agcls.AgTypeNameMap["RadarPulseIntegrationType"] = RadarPulseIntegrationType

class RadarPulseIntegratorType(IntEnum):
    """Radar pulse integrator type."""

    PERFECT = 0
    """Perfect."""
    CONSTANT_EFFICIENCY = 1
    """Constant efficiency."""
    EXPONENT_ON_PULSE_NUMBER = 2
    """Exponent on pulse number."""
    INTEGRATION_FILE = 3
    """Integration File."""

RadarPulseIntegratorType.PERFECT.__doc__ = "Perfect."
RadarPulseIntegratorType.CONSTANT_EFFICIENCY.__doc__ = "Constant efficiency."
RadarPulseIntegratorType.EXPONENT_ON_PULSE_NUMBER.__doc__ = "Exponent on pulse number."
RadarPulseIntegratorType.INTEGRATION_FILE.__doc__ = "Integration File."

agcls.AgTypeNameMap["RadarPulseIntegratorType"] = RadarPulseIntegratorType

class RadarContinuousWaveAnalysisMode(IntEnum):
    """Radar continuous wave analysis mode."""

    GOAL_SNR = 0
    """Goal SNR."""
    FIXED_TIME = 1
    """Fixed time."""

RadarContinuousWaveAnalysisMode.GOAL_SNR.__doc__ = "Goal SNR."
RadarContinuousWaveAnalysisMode.FIXED_TIME.__doc__ = "Fixed time."

agcls.AgTypeNameMap["RadarContinuousWaveAnalysisMode"] = RadarContinuousWaveAnalysisMode

class RadarClutterGeometryModelType(IntEnum):
    """Radar clutter geometry model type."""

    UNKNOWN = -1
    """Unknown."""
    SINGLE_POINT = 0
    """Single point."""
    SMOOTH_OBLATE_EARTH = 1
    """Smooth oblate earth."""
    PLUGIN = 2
    """Plugin."""
    RANGE_OVER_CFAR_CELLS = 3
    """Range Over CFAR Cells."""

RadarClutterGeometryModelType.UNKNOWN.__doc__ = "Unknown."
RadarClutterGeometryModelType.SINGLE_POINT.__doc__ = "Single point."
RadarClutterGeometryModelType.SMOOTH_OBLATE_EARTH.__doc__ = "Smooth oblate earth."
RadarClutterGeometryModelType.PLUGIN.__doc__ = "Plugin."
RadarClutterGeometryModelType.RANGE_OVER_CFAR_CELLS.__doc__ = "Range Over CFAR Cells."

agcls.AgTypeNameMap["RadarClutterGeometryModelType"] = RadarClutterGeometryModelType

class RadarClutterMapModelType(IntEnum):
    """Radar clutter map model type."""

    UNKNOWN = -1
    """Unknown."""
    PLUGIN = 0
    """Plugin."""
    CONSTANT_COEFFICIENT = 1
    """Constant Coefficient."""

RadarClutterMapModelType.UNKNOWN.__doc__ = "Unknown."
RadarClutterMapModelType.PLUGIN.__doc__ = "Plugin."
RadarClutterMapModelType.CONSTANT_COEFFICIENT.__doc__ = "Constant Coefficient."

agcls.AgTypeNameMap["RadarClutterMapModelType"] = RadarClutterMapModelType

class RadarSwerlingCase(IntEnum):
    """Radar swerling case."""

    CASE_0 = 0
    """0."""
    CASE_I = 1
    """I."""
    CASE_II = 2
    """II."""
    CASE_III = 3
    """III."""
    CASE_IV = 4
    """IV."""

RadarSwerlingCase.CASE_0.__doc__ = "0."
RadarSwerlingCase.CASE_I.__doc__ = "I."
RadarSwerlingCase.CASE_II.__doc__ = "II."
RadarSwerlingCase.CASE_III.__doc__ = "III."
RadarSwerlingCase.CASE_IV.__doc__ = "IV."

agcls.AgTypeNameMap["RadarSwerlingCase"] = RadarSwerlingCase

class RCSComputeStrategy(IntEnum):
    """Radar cross section compute strategy."""

    UNKNOWN = -1
    """Unknown."""
    PLUGIN = 0
    """Plugin."""
    CONSTANT_VALUE = 1
    """Constant Value."""
    SCRIPT_PLUGIN = 2
    """Script Plugin."""
    EXTERNAL_FILE = 3
    """External File."""
    ANSYS_CSV_FILE = 4
    """Ansys HFSS CSV File."""

RCSComputeStrategy.UNKNOWN.__doc__ = "Unknown."
RCSComputeStrategy.PLUGIN.__doc__ = "Plugin."
RCSComputeStrategy.CONSTANT_VALUE.__doc__ = "Constant Value."
RCSComputeStrategy.SCRIPT_PLUGIN.__doc__ = "Script Plugin."
RCSComputeStrategy.EXTERNAL_FILE.__doc__ = "External File."
RCSComputeStrategy.ANSYS_CSV_FILE.__doc__ = "Ansys HFSS CSV File."

agcls.AgTypeNameMap["RCSComputeStrategy"] = RCSComputeStrategy

class RadarActivityType(IntEnum):
    """Radar activity times strategy."""

    UNKNOWN = -1
    """Unknown."""
    ALWAYS_ACTIVE = 0
    """Always active."""
    ALWAYS_INACTIVE = 1
    """Always inactive."""
    TIME_COMPONENT_LIST = 2
    """Time components list."""
    TIME_INTERVAL_LIST = 3
    """Explicit interval list."""

RadarActivityType.UNKNOWN.__doc__ = "Unknown."
RadarActivityType.ALWAYS_ACTIVE.__doc__ = "Always active."
RadarActivityType.ALWAYS_INACTIVE.__doc__ = "Always inactive."
RadarActivityType.TIME_COMPONENT_LIST.__doc__ = "Time components list."
RadarActivityType.TIME_INTERVAL_LIST.__doc__ = "Explicit interval list."

agcls.AgTypeNameMap["RadarActivityType"] = RadarActivityType

class RadarCrossSectionContourGraphicsPolarization(IntEnum):
    """Radar cross section contour graphics polarization."""

    PRIMARY = 0
    """Primary Polarization."""
    ORTHOGONAL = 1
    """Orthogonal Polarization."""

RadarCrossSectionContourGraphicsPolarization.PRIMARY.__doc__ = "Primary Polarization."
RadarCrossSectionContourGraphicsPolarization.ORTHOGONAL.__doc__ = "Orthogonal Polarization."

agcls.AgTypeNameMap["RadarCrossSectionContourGraphicsPolarization"] = RadarCrossSectionContourGraphicsPolarization

class RFFilterModelType(IntEnum):
    """RF filter model types."""

    UNKNOWN = -1
    """Unknown."""
    BESSEL = 0
    """Bessel."""
    BUTTERWORTH = 1
    """Butterworth."""
    SINC_ENVELOPE_SINC = 2
    """Sinc Envelope Sinc."""
    ELLIPTIC = 3
    """Elliptic."""
    CHEBYSHEV = 4
    """Chebyshev."""
    COSINE_WINDOW = 5
    """Cosine Window."""
    GAUSSIAN_WINDOW = 6
    """Gaussian Window."""
    HAMMING_WINDOW = 7
    """Hamming Window."""
    EXTERNAL = 8
    """External."""
    SCRIPT_PLUGIN = 9
    """Script Plugin."""
    SINC = 10
    """Sinc."""
    RECTANGULAR = 11
    """Rectangular."""
    RAISED_COSINE = 12
    """Raised Cosine."""
    ROOT_RAISED_COSINE = 13
    """Root Raised Cosine."""
    RC_LOW_PASS = 14
    """Rc Low Pass."""
    FIR_BOX_CAR = 15
    """FIR Box Car."""
    FIR = 16
    """FIR."""
    IIR = 17
    """FIR."""

RFFilterModelType.UNKNOWN.__doc__ = "Unknown."
RFFilterModelType.BESSEL.__doc__ = "Bessel."
RFFilterModelType.BUTTERWORTH.__doc__ = "Butterworth."
RFFilterModelType.SINC_ENVELOPE_SINC.__doc__ = "Sinc Envelope Sinc."
RFFilterModelType.ELLIPTIC.__doc__ = "Elliptic."
RFFilterModelType.CHEBYSHEV.__doc__ = "Chebyshev."
RFFilterModelType.COSINE_WINDOW.__doc__ = "Cosine Window."
RFFilterModelType.GAUSSIAN_WINDOW.__doc__ = "Gaussian Window."
RFFilterModelType.HAMMING_WINDOW.__doc__ = "Hamming Window."
RFFilterModelType.EXTERNAL.__doc__ = "External."
RFFilterModelType.SCRIPT_PLUGIN.__doc__ = "Script Plugin."
RFFilterModelType.SINC.__doc__ = "Sinc."
RFFilterModelType.RECTANGULAR.__doc__ = "Rectangular."
RFFilterModelType.RAISED_COSINE.__doc__ = "Raised Cosine."
RFFilterModelType.ROOT_RAISED_COSINE.__doc__ = "Root Raised Cosine."
RFFilterModelType.RC_LOW_PASS.__doc__ = "Rc Low Pass."
RFFilterModelType.FIR_BOX_CAR.__doc__ = "FIR Box Car."
RFFilterModelType.FIR.__doc__ = "FIR."
RFFilterModelType.IIR.__doc__ = "FIR."

agcls.AgTypeNameMap["RFFilterModelType"] = RFFilterModelType

class ModulatorModelType(IntEnum):
    """Modulator model types."""

    UNKNOWN = -1
    """Unknown."""
    BPSK = 0
    """BPSK."""
    QPSK = 1
    """QPSK."""
    EXTERNAL_SOURCE = 2
    """External source."""
    EXTERNAL = 3
    """External."""
    QAM1024 = 4
    """QAM 1024."""
    QAM128 = 5
    """QAM 128."""
    QAM16 = 6
    """QAM 16."""
    QAM256 = 7
    """QAM 256."""
    QAM32 = 8
    """QAM 32."""
    QAM64 = 9
    """QAM 64."""
    TYPE8_PSK = 10
    """8PSK."""
    TYPE16_PSK = 11
    """16PSK."""
    MSK = 12
    """MSK."""
    BOC = 13
    """BOC."""
    DPSK = 14
    """DPSK."""
    FSK = 15
    """FSK."""
    NFSK = 16
    """NFSK."""
    OQPSK = 17
    """OQPSK."""
    NARROWBAND_UNIFORM = 18
    """Narrowband uniform."""
    WIDEBAND_UNIFORM = 19
    """Wideband uniform."""
    WIDEBAND_GAUSSIAN = 20
    """Wideband gaussian."""
    PULSED_SIGNAL = 21
    """Pulsed signal."""
    SCRIPT_PLUGIN_CUSTOM_PSD = 22
    """Custom PSD script plugin."""
    SCRIPT_PLUGIN_IDEAL_PSD = 23
    """Ideal PSD script plugin."""

ModulatorModelType.UNKNOWN.__doc__ = "Unknown."
ModulatorModelType.BPSK.__doc__ = "BPSK."
ModulatorModelType.QPSK.__doc__ = "QPSK."
ModulatorModelType.EXTERNAL_SOURCE.__doc__ = "External source."
ModulatorModelType.EXTERNAL.__doc__ = "External."
ModulatorModelType.QAM1024.__doc__ = "QAM 1024."
ModulatorModelType.QAM128.__doc__ = "QAM 128."
ModulatorModelType.QAM16.__doc__ = "QAM 16."
ModulatorModelType.QAM256.__doc__ = "QAM 256."
ModulatorModelType.QAM32.__doc__ = "QAM 32."
ModulatorModelType.QAM64.__doc__ = "QAM 64."
ModulatorModelType.TYPE8_PSK.__doc__ = "8PSK."
ModulatorModelType.TYPE16_PSK.__doc__ = "16PSK."
ModulatorModelType.MSK.__doc__ = "MSK."
ModulatorModelType.BOC.__doc__ = "BOC."
ModulatorModelType.DPSK.__doc__ = "DPSK."
ModulatorModelType.FSK.__doc__ = "FSK."
ModulatorModelType.NFSK.__doc__ = "NFSK."
ModulatorModelType.OQPSK.__doc__ = "OQPSK."
ModulatorModelType.NARROWBAND_UNIFORM.__doc__ = "Narrowband uniform."
ModulatorModelType.WIDEBAND_UNIFORM.__doc__ = "Wideband uniform."
ModulatorModelType.WIDEBAND_GAUSSIAN.__doc__ = "Wideband gaussian."
ModulatorModelType.PULSED_SIGNAL.__doc__ = "Pulsed signal."
ModulatorModelType.SCRIPT_PLUGIN_CUSTOM_PSD.__doc__ = "Custom PSD script plugin."
ModulatorModelType.SCRIPT_PLUGIN_IDEAL_PSD.__doc__ = "Ideal PSD script plugin."

agcls.AgTypeNameMap["ModulatorModelType"] = ModulatorModelType

class DemodulatorModelType(IntEnum):
    """Demodulator model types."""

    UNKNOWN = -1
    """Unknown."""
    BPSK = 0
    """BPSK."""
    QPSK = 1
    """QPSK."""
    EXTERNAL_SOURCE = 2
    """External source."""
    EXTERNAL = 3
    """External."""
    QAM1024 = 4
    """QAM 1024."""
    QAM128 = 5
    """QAM 128."""
    QAM16 = 6
    """QAM 16."""
    QAM256 = 7
    """QAM 256."""
    QAM32 = 8
    """QAM 32."""
    QAM64 = 9
    """QAM 64."""
    TYPE8_PSK = 10
    """8PSK."""
    TYPE16_PSK = 11
    """16PSK."""
    MSK = 12
    """MSK."""
    BOC = 13
    """BOC."""
    DPSK = 14
    """DPSK."""
    FSK = 15
    """FSK."""
    NFSK = 16
    """NFSK."""
    OQPSK = 17
    """OQPSK."""
    NARROWBAND_UNIFORM = 18
    """Narrowband uniform."""
    WIDEBAND_UNIFORM = 19
    """Wideband uniform."""
    WIDEBAND_GAUSSIAN = 20
    """Wideband gaussian."""
    PULSED_SIGNAL = 21
    """Pulsed signal."""
    SCRIPT_PLUGIN = 22
    """Script plugin."""

DemodulatorModelType.UNKNOWN.__doc__ = "Unknown."
DemodulatorModelType.BPSK.__doc__ = "BPSK."
DemodulatorModelType.QPSK.__doc__ = "QPSK."
DemodulatorModelType.EXTERNAL_SOURCE.__doc__ = "External source."
DemodulatorModelType.EXTERNAL.__doc__ = "External."
DemodulatorModelType.QAM1024.__doc__ = "QAM 1024."
DemodulatorModelType.QAM128.__doc__ = "QAM 128."
DemodulatorModelType.QAM16.__doc__ = "QAM 16."
DemodulatorModelType.QAM256.__doc__ = "QAM 256."
DemodulatorModelType.QAM32.__doc__ = "QAM 32."
DemodulatorModelType.QAM64.__doc__ = "QAM 64."
DemodulatorModelType.TYPE8_PSK.__doc__ = "8PSK."
DemodulatorModelType.TYPE16_PSK.__doc__ = "16PSK."
DemodulatorModelType.MSK.__doc__ = "MSK."
DemodulatorModelType.BOC.__doc__ = "BOC."
DemodulatorModelType.DPSK.__doc__ = "DPSK."
DemodulatorModelType.FSK.__doc__ = "FSK."
DemodulatorModelType.NFSK.__doc__ = "NFSK."
DemodulatorModelType.OQPSK.__doc__ = "OQPSK."
DemodulatorModelType.NARROWBAND_UNIFORM.__doc__ = "Narrowband uniform."
DemodulatorModelType.WIDEBAND_UNIFORM.__doc__ = "Wideband uniform."
DemodulatorModelType.WIDEBAND_GAUSSIAN.__doc__ = "Wideband gaussian."
DemodulatorModelType.PULSED_SIGNAL.__doc__ = "Pulsed signal."
DemodulatorModelType.SCRIPT_PLUGIN.__doc__ = "Script plugin."

agcls.AgTypeNameMap["DemodulatorModelType"] = DemodulatorModelType

class RainLossModelType(IntEnum):
    """Rain loss model types."""

    UNKNOWN = -1
    """Unknown rain loss model type."""
    ITU_R_P618_10 = 0
    """ITU-R P618-10 rain loss model type."""
    CRANE1985 = 1
    """Crane 1985 rain loss model type."""
    CRANE1982 = 2
    """Crane 1982 rain loss model type."""
    CCIR1983 = 3
    """CCIR 1983 rain loss model type."""
    SCRIPT_PLUGIN = 4
    """Script plugin rain loss model type."""
    ITU_R_P618_12 = 5
    """ITU-R P618-12 rain loss model type."""
    ITU_R_P618_13 = 6
    """ITU-R P618-13 rain loss model type."""

RainLossModelType.UNKNOWN.__doc__ = "Unknown rain loss model type."
RainLossModelType.ITU_R_P618_10.__doc__ = "ITU-R P618-10 rain loss model type."
RainLossModelType.CRANE1985.__doc__ = "Crane 1985 rain loss model type."
RainLossModelType.CRANE1982.__doc__ = "Crane 1982 rain loss model type."
RainLossModelType.CCIR1983.__doc__ = "CCIR 1983 rain loss model type."
RainLossModelType.SCRIPT_PLUGIN.__doc__ = "Script plugin rain loss model type."
RainLossModelType.ITU_R_P618_12.__doc__ = "ITU-R P618-12 rain loss model type."
RainLossModelType.ITU_R_P618_13.__doc__ = "ITU-R P618-13 rain loss model type."

agcls.AgTypeNameMap["RainLossModelType"] = RainLossModelType

class AtmosphericAbsorptionModelType(IntEnum):
    """Atmospheric absorption model types."""

    UNKNOWN = -1
    """Unknown atmospheric absorption model type."""
    ITURP676_9 = 0
    """ITU-R P676-9 atmospheric absorption model type."""
    TIREM331 = 1
    """TIREM 3.31 atmospheric absorption model type."""
    TIREM320 = 2
    """TIREM 3.20 atmospheric absorption model type."""
    SIMPLE_SATCOM = 3
    """Simple Satcom atmospheric absorption model type."""
    SCRIPT_PLUGIN = 4
    """Script plugin atmospheric absorption model type."""
    TIREM550 = 5
    """TIREM 5.50 atmospheric absorption model type."""
    GRAPHICS_3D_ACAP = 6
    """Voacap atmospheric absorption model type."""
    COM_PLUGIN = 7
    """COM Plugin atmospheric absorption model type."""
    ITURP676_13 = 8
    """ITU-R P676-13 atmospheric absorption model type."""

AtmosphericAbsorptionModelType.UNKNOWN.__doc__ = "Unknown atmospheric absorption model type."
AtmosphericAbsorptionModelType.ITURP676_9.__doc__ = "ITU-R P676-9 atmospheric absorption model type."
AtmosphericAbsorptionModelType.TIREM331.__doc__ = "TIREM 3.31 atmospheric absorption model type."
AtmosphericAbsorptionModelType.TIREM320.__doc__ = "TIREM 3.20 atmospheric absorption model type."
AtmosphericAbsorptionModelType.SIMPLE_SATCOM.__doc__ = "Simple Satcom atmospheric absorption model type."
AtmosphericAbsorptionModelType.SCRIPT_PLUGIN.__doc__ = "Script plugin atmospheric absorption model type."
AtmosphericAbsorptionModelType.TIREM550.__doc__ = "TIREM 5.50 atmospheric absorption model type."
AtmosphericAbsorptionModelType.GRAPHICS_3D_ACAP.__doc__ = "Voacap atmospheric absorption model type."
AtmosphericAbsorptionModelType.COM_PLUGIN.__doc__ = "COM Plugin atmospheric absorption model type."
AtmosphericAbsorptionModelType.ITURP676_13.__doc__ = "ITU-R P676-13 atmospheric absorption model type."

agcls.AgTypeNameMap["AtmosphericAbsorptionModelType"] = AtmosphericAbsorptionModelType

class UrbanTerrestrialLossModelType(IntEnum):
    """urban/terrestrial loss model types."""

    UNKNOWN = -1
    """Unknown urban/terrestrial loss model type."""
    TWO_RAY = 0
    """urban/terrestrial loss model two ray type."""
    WIRELESS_INSITE_REAL_TIME = 1
    """urban/terrestrial loss model REMCOM Wireless InSite Real Time type."""
    WIRELESS_INSITE_64 = 2
    """urban/terrestrial loss model REMCOM Wireless InSite 64 type."""

UrbanTerrestrialLossModelType.UNKNOWN.__doc__ = "Unknown urban/terrestrial loss model type."
UrbanTerrestrialLossModelType.TWO_RAY.__doc__ = "urban/terrestrial loss model two ray type."
UrbanTerrestrialLossModelType.WIRELESS_INSITE_REAL_TIME.__doc__ = "urban/terrestrial loss model REMCOM Wireless InSite Real Time type."
UrbanTerrestrialLossModelType.WIRELESS_INSITE_64.__doc__ = "urban/terrestrial loss model REMCOM Wireless InSite 64 type."

agcls.AgTypeNameMap["UrbanTerrestrialLossModelType"] = UrbanTerrestrialLossModelType

class CloudsAndFogFadingLossModelType(IntEnum):
    """Clouds and Fog loss model types."""

    UNKNOWN = -1
    """Unknown Clouds and Fog loss model type."""
    P_840_6_TYPE = 0
    """Clouds and Fog loss model P. 840-6."""
    P_840_7_TYPE = 1
    """Clouds and Fog loss model P. 840-7."""

CloudsAndFogFadingLossModelType.UNKNOWN.__doc__ = "Unknown Clouds and Fog loss model type."
CloudsAndFogFadingLossModelType.P_840_6_TYPE.__doc__ = "Clouds and Fog loss model P. 840-6."
CloudsAndFogFadingLossModelType.P_840_7_TYPE.__doc__ = "Clouds and Fog loss model P. 840-7."

agcls.AgTypeNameMap["CloudsAndFogFadingLossModelType"] = CloudsAndFogFadingLossModelType

class CloudsAndFogLiquidWaterChoiceType(IntEnum):
    """Clouds and Fog loss model liquid water content choices."""

    UNKNOWN = -1
    """Unknown Clouds and Fog liquid water choice."""
    DENSITY_VALUE = 0
    """Clouds and Fog liquid water content density value."""
    ANNUAL_EXCEEDED = 1
    """Clouds and Fog liquid water % Annual exceeded."""
    MONTHLY_EXCEEDED = 2
    """Clouds and Fog liquid water % Monthly exceeded."""

CloudsAndFogLiquidWaterChoiceType.UNKNOWN.__doc__ = "Unknown Clouds and Fog liquid water choice."
CloudsAndFogLiquidWaterChoiceType.DENSITY_VALUE.__doc__ = "Clouds and Fog liquid water content density value."
CloudsAndFogLiquidWaterChoiceType.ANNUAL_EXCEEDED.__doc__ = "Clouds and Fog liquid water % Annual exceeded."
CloudsAndFogLiquidWaterChoiceType.MONTHLY_EXCEEDED.__doc__ = "Clouds and Fog liquid water % Monthly exceeded."

agcls.AgTypeNameMap["CloudsAndFogLiquidWaterChoiceType"] = CloudsAndFogLiquidWaterChoiceType

class IonosphericFadingLossModelType(IntEnum):
    """Ionospheric loss model types."""

    UNKNOWN = -1
    """Unknown Ionospheric loss model type."""
    P_531_13 = 1
    """Ionospheric loss model P. 531-13."""

IonosphericFadingLossModelType.UNKNOWN.__doc__ = "Unknown Ionospheric loss model type."
IonosphericFadingLossModelType.P_531_13.__doc__ = "Ionospheric loss model P. 531-13."

agcls.AgTypeNameMap["IonosphericFadingLossModelType"] = IonosphericFadingLossModelType

class TroposphericScintillationFadingLossModelType(IntEnum):
    """TropoScintillation loss model types."""

    UNKNOWN = -1
    """Unknown TropoScintillation loss model type."""
    P_618_8 = 0
    """TropoScintillation loss model P. 618-8."""
    P_618_12 = 1
    """TropoScintillation loss model P. 618-12."""

TroposphericScintillationFadingLossModelType.UNKNOWN.__doc__ = "Unknown TropoScintillation loss model type."
TroposphericScintillationFadingLossModelType.P_618_8.__doc__ = "TropoScintillation loss model P. 618-8."
TroposphericScintillationFadingLossModelType.P_618_12.__doc__ = "TropoScintillation loss model P. 618-12."

agcls.AgTypeNameMap["TroposphericScintillationFadingLossModelType"] = TroposphericScintillationFadingLossModelType

class TroposphericScintillationAverageTimeChoiceType(IntEnum):
    """TroposphericScintillation loss model average time choices."""

    UNKNOWN = -1
    """Unknown TropoScintillation average time choice."""
    YEAR = 0
    """TropoScintillation fade depth for average year."""
    WORST_MONTH = 1
    """TropoScintillation fade depth for average annual worst month."""

TroposphericScintillationAverageTimeChoiceType.UNKNOWN.__doc__ = "Unknown TropoScintillation average time choice."
TroposphericScintillationAverageTimeChoiceType.YEAR.__doc__ = "TropoScintillation fade depth for average year."
TroposphericScintillationAverageTimeChoiceType.WORST_MONTH.__doc__ = "TropoScintillation fade depth for average annual worst month."

agcls.AgTypeNameMap["TroposphericScintillationAverageTimeChoiceType"] = TroposphericScintillationAverageTimeChoiceType

class ProjectionHorizontalDatumType(IntEnum):
    """REMCOM Wireless InSite RT project/horizontal datum type."""

    WGS84_LATITUDE_LONGITUDE = 0
    """Lat/Lon WGS84."""
    WGS84_UTM = 1
    """UTM WGS94."""

ProjectionHorizontalDatumType.WGS84_LATITUDE_LONGITUDE.__doc__ = "Lat/Lon WGS84."
ProjectionHorizontalDatumType.WGS84_UTM.__doc__ = "UTM WGS94."

agcls.AgTypeNameMap["ProjectionHorizontalDatumType"] = ProjectionHorizontalDatumType

class BuildHeightReferenceMethod(IntEnum):
    """REMCOM Wireless InSite RT building height reference method."""

    HEIGHT_ABOVE_TERRAIN = 0
    """Height above terrain."""
    HEIGHT_ABOVE_SEA_LEVEL = 1
    """Height above sea level."""

BuildHeightReferenceMethod.HEIGHT_ABOVE_TERRAIN.__doc__ = "Height above terrain."
BuildHeightReferenceMethod.HEIGHT_ABOVE_SEA_LEVEL.__doc__ = "Height above sea level."

agcls.AgTypeNameMap["BuildHeightReferenceMethod"] = BuildHeightReferenceMethod

class BuildingHeightUnit(IntEnum):
    """REMCOM Wireless InSite RT building height unit."""

    FEET = 0
    """Feet."""
    METERS = 1
    """Meters."""

BuildingHeightUnit.FEET.__doc__ = "Feet."
BuildingHeightUnit.METERS.__doc__ = "Meters."

agcls.AgTypeNameMap["BuildingHeightUnit"] = BuildingHeightUnit

class TIREMPolarizationType(IntEnum):
    """TIREM polarization type."""

    VERTICAL = 0
    """V."""
    HORIZONTAL = 1
    """H."""

TIREMPolarizationType.VERTICAL.__doc__ = "V."
TIREMPolarizationType.HORIZONTAL.__doc__ = "H."

agcls.AgTypeNameMap["TIREMPolarizationType"] = TIREMPolarizationType

class Graphics3DACAPSolarActivityConfigurationType(IntEnum):
    """VOACAP solar activity configuration type."""

    UNKNOWN = -1
    """Unknown solar activity configuration type."""
    SUNSPOT_NUMBER = 0
    """SunspotNumber."""
    SOLAR_FLUX = 1
    """SolarFlux."""

Graphics3DACAPSolarActivityConfigurationType.UNKNOWN.__doc__ = "Unknown solar activity configuration type."
Graphics3DACAPSolarActivityConfigurationType.SUNSPOT_NUMBER.__doc__ = "SunspotNumber."
Graphics3DACAPSolarActivityConfigurationType.SOLAR_FLUX.__doc__ = "SolarFlux."

agcls.AgTypeNameMap["Graphics3DACAPSolarActivityConfigurationType"] = Graphics3DACAPSolarActivityConfigurationType

class Graphics3DACAPCoefficientDataType(IntEnum):
    """VOACAP coefficient data type."""

    CCIR = 0
    """CCIR."""
    URSI = 1
    """URSI."""

Graphics3DACAPCoefficientDataType.CCIR.__doc__ = "CCIR."
Graphics3DACAPCoefficientDataType.URSI.__doc__ = "URSI."

agcls.AgTypeNameMap["Graphics3DACAPCoefficientDataType"] = Graphics3DACAPCoefficientDataType

class LaserPropagationLossModelType(IntEnum):
    """Laser propagation loss model types."""

    UNKNOWN = -1
    """Unknown laser propagation loss model type."""
    BEER_BOUGUER_LAMBERT_LAW = 0
    """Beer-Bouguer-Lambert law laser propagation loss model type."""
    MODTRAN_LOOKUP_TABLE = 1
    """MODTRAN lookup table laser propagation model type."""
    MODTRAN = 2
    """MODTRAN propagation model type."""

LaserPropagationLossModelType.UNKNOWN.__doc__ = "Unknown laser propagation loss model type."
LaserPropagationLossModelType.BEER_BOUGUER_LAMBERT_LAW.__doc__ = "Beer-Bouguer-Lambert law laser propagation loss model type."
LaserPropagationLossModelType.MODTRAN_LOOKUP_TABLE.__doc__ = "MODTRAN lookup table laser propagation model type."
LaserPropagationLossModelType.MODTRAN.__doc__ = "MODTRAN propagation model type."

agcls.AgTypeNameMap["LaserPropagationLossModelType"] = LaserPropagationLossModelType

class LaserTroposphericScintillationLossModelType(IntEnum):
    """Laser tropospheric scintillation loss model types."""

    UNKNOWN = -1
    """Unknown laser tropospheric scintillation loss model type."""
    ITURP_1814 = 0
    """ITU-R P.1814 laser tropospheric scintillation loss model type."""

LaserTroposphericScintillationLossModelType.UNKNOWN.__doc__ = "Unknown laser tropospheric scintillation loss model type."
LaserTroposphericScintillationLossModelType.ITURP_1814.__doc__ = "ITU-R P.1814 laser tropospheric scintillation loss model type."

agcls.AgTypeNameMap["LaserTroposphericScintillationLossModelType"] = LaserTroposphericScintillationLossModelType

class AtmosphericTurbulenceModelType(IntEnum):
    """Refractive index structure parameter model types."""

    UNKNOWN = -1
    """Unknown atmospheric turbulence model type."""
    CONSTANT = 0
    """Constant atmospheric turbulence model type."""
    HUFNAGEL_VALLEY = 1
    """Hufnagel Valley atmospheric turbulence model type."""

AtmosphericTurbulenceModelType.UNKNOWN.__doc__ = "Unknown atmospheric turbulence model type."
AtmosphericTurbulenceModelType.CONSTANT.__doc__ = "Constant atmospheric turbulence model type."
AtmosphericTurbulenceModelType.HUFNAGEL_VALLEY.__doc__ = "Hufnagel Valley atmospheric turbulence model type."

agcls.AgTypeNameMap["AtmosphericTurbulenceModelType"] = AtmosphericTurbulenceModelType

class ModtranAerosolModelType(IntEnum):
    """MODTRAN-derived lookup table aerosol model extinction types."""

    RURAL_HIGH_VISIBILITY = 1
    """Rural High Visibility."""
    RURAL_LOW_VISIBILITY = 2
    """Rural Low Visibility."""
    NAVY_MARITIME = 3
    """Navy Maritime."""
    MARITIME = 4
    """Maritime."""
    URBAN = 5
    """Urban."""
    TROPOSPHERIC = 6
    """Tropospheric."""
    FOG_LOW_VISIBILITY = 8
    """Fog Low Visibility."""
    FOG_HIGH_VISIBILITY = 9
    """Fog High Visibility."""
    DESERT = 10
    """Desert."""

ModtranAerosolModelType.RURAL_HIGH_VISIBILITY.__doc__ = "Rural High Visibility."
ModtranAerosolModelType.RURAL_LOW_VISIBILITY.__doc__ = "Rural Low Visibility."
ModtranAerosolModelType.NAVY_MARITIME.__doc__ = "Navy Maritime."
ModtranAerosolModelType.MARITIME.__doc__ = "Maritime."
ModtranAerosolModelType.URBAN.__doc__ = "Urban."
ModtranAerosolModelType.TROPOSPHERIC.__doc__ = "Tropospheric."
ModtranAerosolModelType.FOG_LOW_VISIBILITY.__doc__ = "Fog Low Visibility."
ModtranAerosolModelType.FOG_HIGH_VISIBILITY.__doc__ = "Fog High Visibility."
ModtranAerosolModelType.DESERT.__doc__ = "Desert."

agcls.AgTypeNameMap["ModtranAerosolModelType"] = ModtranAerosolModelType

class ModtranCloudModelType(IntEnum):
    """MODTRAN Cloud model types."""

    NONE = 0
    """None."""
    CUMULUS = 1
    """Cumulus."""
    ALTOSTRATUS = 2
    """Altostratus."""
    STRATUS = 3
    """Stratus."""
    STRATOCUMULUS = 4
    """Stratocumulus."""
    NIMBOSTRATUS = 5
    """Nimbostratus."""
    RAIN_DRIZZLE = 6
    """Rain Drizzle."""
    RAIN_LIGHT = 7
    """Rain Light."""
    RAIN_MODERATE = 8
    """Rain Moderate."""
    RAIN_EXTREME = 9
    """Rain Extreme."""
    CIRRUS = 18
    """Cirrus."""
    CIRRUS_THIN = 19
    """Cirrus Thin."""

ModtranCloudModelType.NONE.__doc__ = "None."
ModtranCloudModelType.CUMULUS.__doc__ = "Cumulus."
ModtranCloudModelType.ALTOSTRATUS.__doc__ = "Altostratus."
ModtranCloudModelType.STRATUS.__doc__ = "Stratus."
ModtranCloudModelType.STRATOCUMULUS.__doc__ = "Stratocumulus."
ModtranCloudModelType.NIMBOSTRATUS.__doc__ = "Nimbostratus."
ModtranCloudModelType.RAIN_DRIZZLE.__doc__ = "Rain Drizzle."
ModtranCloudModelType.RAIN_LIGHT.__doc__ = "Rain Light."
ModtranCloudModelType.RAIN_MODERATE.__doc__ = "Rain Moderate."
ModtranCloudModelType.RAIN_EXTREME.__doc__ = "Rain Extreme."
ModtranCloudModelType.CIRRUS.__doc__ = "Cirrus."
ModtranCloudModelType.CIRRUS_THIN.__doc__ = "Cirrus Thin."

agcls.AgTypeNameMap["ModtranCloudModelType"] = ModtranCloudModelType

class CommSystemReferenceBandwidth(IntEnum):
    """CommSystem reference bandwidth."""

    BANDWIDTH_1_HZ = 0
    """1 Hz."""
    BANDWIDTH_4_KHZ = 1
    """4 kHz."""
    BANDWIDTH_40_KHZ = 2
    """40 kHz."""
    BANDWIDTH_1_MHZ = 3
    """1 MHz."""
    BANDWIDTH_10_MHZ = 4
    """10 MHz."""
    BANDWIDTH_20_MHZ = 5
    """20 MHz."""
    BANDWIDTH_40_MHZ = 6
    """40 MHz."""

CommSystemReferenceBandwidth.BANDWIDTH_1_HZ.__doc__ = "1 Hz."
CommSystemReferenceBandwidth.BANDWIDTH_4_KHZ.__doc__ = "4 kHz."
CommSystemReferenceBandwidth.BANDWIDTH_40_KHZ.__doc__ = "40 kHz."
CommSystemReferenceBandwidth.BANDWIDTH_1_MHZ.__doc__ = "1 MHz."
CommSystemReferenceBandwidth.BANDWIDTH_10_MHZ.__doc__ = "10 MHz."
CommSystemReferenceBandwidth.BANDWIDTH_20_MHZ.__doc__ = "20 MHz."
CommSystemReferenceBandwidth.BANDWIDTH_40_MHZ.__doc__ = "40 MHz."

agcls.AgTypeNameMap["CommSystemReferenceBandwidth"] = CommSystemReferenceBandwidth

class CommSystemConstrainingRole(IntEnum):
    """CommSystem constraining role."""

    TRANSMIT = 0
    """Transmit."""
    RECEIVE = 1
    """Receive."""

CommSystemConstrainingRole.TRANSMIT.__doc__ = "Transmit."
CommSystemConstrainingRole.RECEIVE.__doc__ = "Receive."

agcls.AgTypeNameMap["CommSystemConstrainingRole"] = CommSystemConstrainingRole

class CommSystemSaveMode(IntEnum):
    """CommSystem save mode."""

    DO_NOT_SAVE_COMPUTED_DATA = 0
    """Don't save compute data."""
    COMPUTE_DATA_ON_LOAD = 1
    """Don't save, but compute on load."""
    SAVE_COMPUTED_DATA = 2
    """Save compute data."""

CommSystemSaveMode.DO_NOT_SAVE_COMPUTED_DATA.__doc__ = "Don't save compute data."
CommSystemSaveMode.COMPUTE_DATA_ON_LOAD.__doc__ = "Don't save, but compute on load."
CommSystemSaveMode.SAVE_COMPUTED_DATA.__doc__ = "Save compute data."

agcls.AgTypeNameMap["CommSystemSaveMode"] = CommSystemSaveMode

class CommSystemAccessEventDetectionType(IntEnum):
    """CommSystem access options event detection type."""

    UNKNOWN = -1
    """Unknown."""
    SUB_SAMPLE = 0
    """Sub-sample."""
    SAMPLES_ONLY = 1
    """No sub-sample."""

CommSystemAccessEventDetectionType.UNKNOWN.__doc__ = "Unknown."
CommSystemAccessEventDetectionType.SUB_SAMPLE.__doc__ = "Sub-sample."
CommSystemAccessEventDetectionType.SAMPLES_ONLY.__doc__ = "No sub-sample."

agcls.AgTypeNameMap["CommSystemAccessEventDetectionType"] = CommSystemAccessEventDetectionType

class CommSystemAccessSamplingMethodType(IntEnum):
    """CommSystem access options sampling method type."""

    UNKNOWN = -1
    """Unknown."""
    FIXED = 0
    """Fixed."""
    ADAPTIVE = 1
    """Adaptive."""

CommSystemAccessSamplingMethodType.UNKNOWN.__doc__ = "Unknown."
CommSystemAccessSamplingMethodType.FIXED.__doc__ = "Fixed."
CommSystemAccessSamplingMethodType.ADAPTIVE.__doc__ = "Adaptive."

agcls.AgTypeNameMap["CommSystemAccessSamplingMethodType"] = CommSystemAccessSamplingMethodType

class CommSystemLinkSelectionCriteriaType(IntEnum):
    """Link selection strategy types."""

    UNKNOWN = -1
    """Unknown."""
    MINIMUM_RANGE = 0
    """Minimum range."""
    MAXIMUM_ELEVATION = 1
    """Maximum elevation."""
    SCRIPT_PLUGIN = 2
    """Script plugin."""

CommSystemLinkSelectionCriteriaType.UNKNOWN.__doc__ = "Unknown."
CommSystemLinkSelectionCriteriaType.MINIMUM_RANGE.__doc__ = "Minimum range."
CommSystemLinkSelectionCriteriaType.MAXIMUM_ELEVATION.__doc__ = "Maximum elevation."
CommSystemLinkSelectionCriteriaType.SCRIPT_PLUGIN.__doc__ = "Script plugin."

agcls.AgTypeNameMap["CommSystemLinkSelectionCriteriaType"] = CommSystemLinkSelectionCriteriaType

class SpaceEnvironmentNasaModelsActivity(IntEnum):
    """Activity level for the NASA models NASAELE and NASAPRO."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentNasaModelsActivity value."""
    SOLAR_MINIMUM = 0
    """Set the NASA models to use values appropriate for the minimum of the solar cycle."""
    SOLAR_MAXIMUM = 1
    """Set the NASA models to use values appropriate for the maximum of the solar cycle."""

SpaceEnvironmentNasaModelsActivity.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentNasaModelsActivity value."
SpaceEnvironmentNasaModelsActivity.SOLAR_MINIMUM.__doc__ = "Set the NASA models to use values appropriate for the minimum of the solar cycle."
SpaceEnvironmentNasaModelsActivity.SOLAR_MAXIMUM.__doc__ = "Set the NASA models to use values appropriate for the maximum of the solar cycle."

agcls.AgTypeNameMap["SpaceEnvironmentNasaModelsActivity"] = SpaceEnvironmentNasaModelsActivity

class SpaceEnvironmentCrresProtonActivity(IntEnum):
    """Activity level for CRRESPRO model."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentCrresProtonActivity value."""
    ACTIVE = 0
    """Models an enhanced geomagnetic flux environment."""
    QUIET = 1
    """Models a quiet geomagnetic flux environment."""

SpaceEnvironmentCrresProtonActivity.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentCrresProtonActivity value."
SpaceEnvironmentCrresProtonActivity.ACTIVE.__doc__ = "Models an enhanced geomagnetic flux environment."
SpaceEnvironmentCrresProtonActivity.QUIET.__doc__ = "Models a quiet geomagnetic flux environment."

agcls.AgTypeNameMap["SpaceEnvironmentCrresProtonActivity"] = SpaceEnvironmentCrresProtonActivity

class SpaceEnvironmentCrresRadiationActivity(IntEnum):
    """Activity level for CRRESRAD model."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentCrresProtonActivity value."""
    ACTIVE = 0
    """Models an enhanced geomagnetic flux environment."""
    AVERAGE = 1
    """Models an average geomagnetic flux environment."""
    QUIET = 2
    """Models a quiet geomagnetic flux environment."""

SpaceEnvironmentCrresRadiationActivity.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentCrresProtonActivity value."
SpaceEnvironmentCrresRadiationActivity.ACTIVE.__doc__ = "Models an enhanced geomagnetic flux environment."
SpaceEnvironmentCrresRadiationActivity.AVERAGE.__doc__ = "Models an average geomagnetic flux environment."
SpaceEnvironmentCrresRadiationActivity.QUIET.__doc__ = "Models a quiet geomagnetic flux environment."

agcls.AgTypeNameMap["SpaceEnvironmentCrresRadiationActivity"] = SpaceEnvironmentCrresRadiationActivity

class SpaceEnvironmentMagneticFieldColorMode(IntEnum):
    """Mode by which color is assigned."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentMagneticFieldColorMode value."""
    FIELD_MAGNITUDE = 0
    """Color field lines according to the magnitude of the magnetic field."""
    LATITUDE_LINE = 1
    """Color field lines according to the originating latitude of the field line."""

SpaceEnvironmentMagneticFieldColorMode.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentMagneticFieldColorMode value."
SpaceEnvironmentMagneticFieldColorMode.FIELD_MAGNITUDE.__doc__ = "Color field lines according to the magnitude of the magnetic field."
SpaceEnvironmentMagneticFieldColorMode.LATITUDE_LINE.__doc__ = "Color field lines according to the originating latitude of the field line."

agcls.AgTypeNameMap["SpaceEnvironmentMagneticFieldColorMode"] = SpaceEnvironmentMagneticFieldColorMode

class SpaceEnvironmentMagneticFieldColorScaleType(IntEnum):
    """Scaling of magnetic field to use when assigning color/translucency."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentMagneticFieldColorScaleType value."""
    LINEAR = 0
    """Assign colors based upon a linear scaling from minimum to maximum value."""
    LOG = 1
    """Assign colors based upon a linear scaling from log10(minimum) to log10(maximum) value. Ignores 0.0 values."""

SpaceEnvironmentMagneticFieldColorScaleType.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentMagneticFieldColorScaleType value."
SpaceEnvironmentMagneticFieldColorScaleType.LINEAR.__doc__ = "Assign colors based upon a linear scaling from minimum to maximum value."
SpaceEnvironmentMagneticFieldColorScaleType.LOG.__doc__ = "Assign colors based upon a linear scaling from log10(minimum) to log10(maximum) value. Ignores 0.0 values."

agcls.AgTypeNameMap["SpaceEnvironmentMagneticFieldColorScaleType"] = SpaceEnvironmentMagneticFieldColorScaleType

class SpaceEnvironmentMagneticMainField(IntEnum):
    """Main magnetic field."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentMagneticMainField value."""
    IGRF = 1
    """Models the main geomagnetic field using the IGRF model."""
    OFFSET_DIPOLE = 2
    """Models the main geomagnetic field using a dipole offset from the Earth center."""
    FAST_IGRF = 3
    """Models the main geomagnetic field using the Fast IGRF model."""
    TILTED_DIPOLE = 4
    """Models the main geomagnetic field using a tilted dipole centered at the Earth center."""

SpaceEnvironmentMagneticMainField.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentMagneticMainField value."
SpaceEnvironmentMagneticMainField.IGRF.__doc__ = "Models the main geomagnetic field using the IGRF model."
SpaceEnvironmentMagneticMainField.OFFSET_DIPOLE.__doc__ = "Models the main geomagnetic field using a dipole offset from the Earth center."
SpaceEnvironmentMagneticMainField.FAST_IGRF.__doc__ = "Models the main geomagnetic field using the Fast IGRF model."
SpaceEnvironmentMagneticMainField.TILTED_DIPOLE.__doc__ = "Models the main geomagnetic field using a tilted dipole centered at the Earth center."

agcls.AgTypeNameMap["SpaceEnvironmentMagneticMainField"] = SpaceEnvironmentMagneticMainField

class SpaceEnvironmentMagneticExternalField(IntEnum):
    """External magnetic field."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentMagneticExternalField value."""
    NONE = 0
    """Indicate that no external field is modeled."""
    OLSON_PFITZER = 1
    """Models the Olson-Pfitzer external field."""

SpaceEnvironmentMagneticExternalField.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentMagneticExternalField value."
SpaceEnvironmentMagneticExternalField.NONE.__doc__ = "Indicate that no external field is modeled."
SpaceEnvironmentMagneticExternalField.OLSON_PFITZER.__doc__ = "Models the Olson-Pfitzer external field."

agcls.AgTypeNameMap["SpaceEnvironmentMagneticExternalField"] = SpaceEnvironmentMagneticExternalField

class SpaceEnvironmentSAAChannel(IntEnum):
    """Energy level for SAA protons."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentSAAChannel value."""
    CHANNEL_23_MEV = 0
    """Models proton energies > 23 MeV."""
    CHANNEL_38_MEV = 1
    """Models proton energies > 38 MeV."""
    CHANNEL_66_MEV = 2
    """Models proton energies > 66 MeV."""
    CHANNEL_94_MEV = 3
    """Models proton energies > 94 MeV."""

SpaceEnvironmentSAAChannel.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentSAAChannel value."
SpaceEnvironmentSAAChannel.CHANNEL_23_MEV.__doc__ = "Models proton energies > 23 MeV."
SpaceEnvironmentSAAChannel.CHANNEL_38_MEV.__doc__ = "Models proton energies > 38 MeV."
SpaceEnvironmentSAAChannel.CHANNEL_66_MEV.__doc__ = "Models proton energies > 66 MeV."
SpaceEnvironmentSAAChannel.CHANNEL_94_MEV.__doc__ = "Models proton energies > 94 MeV."

agcls.AgTypeNameMap["SpaceEnvironmentSAAChannel"] = SpaceEnvironmentSAAChannel

class SpaceEnvironmentSAAFluxLevel(IntEnum):
    """Flux level for SAA contour."""

    UNKNOWN = -1
    """An invalid SpaceEnvironmentSAAFluxLevel value."""
    GREATER_THAN_BACKGROUND_BY_3_SIGMA = 0
    """Represents flux values greater than the background environment by 3 sigma."""
    HALF_OF_PEAK = 1
    """Represents flux values of about half the peak flux value at the given altitude."""
    TENTH_OF_PEAK = 2
    """Represents flux values of about one-tenth the peak flux value at the given altitude."""

SpaceEnvironmentSAAFluxLevel.UNKNOWN.__doc__ = "An invalid SpaceEnvironmentSAAFluxLevel value."
SpaceEnvironmentSAAFluxLevel.GREATER_THAN_BACKGROUND_BY_3_SIGMA.__doc__ = "Represents flux values greater than the background environment by 3 sigma."
SpaceEnvironmentSAAFluxLevel.HALF_OF_PEAK.__doc__ = "Represents flux values of about half the peak flux value at the given altitude."
SpaceEnvironmentSAAFluxLevel.TENTH_OF_PEAK.__doc__ = "Represents flux values of about one-tenth the peak flux value at the given altitude."

agcls.AgTypeNameMap["SpaceEnvironmentSAAFluxLevel"] = SpaceEnvironmentSAAFluxLevel

class VehicleSpaceEnvironmentShapeModel(IntEnum):
    """Thermal shape model."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentShapeModel value."""
    PLATE = 0
    """Models the thermal properties of the vehicle using a plate."""
    SPHERE = 1
    """Models the thermal properties of the vehicle using a sphere."""

VehicleSpaceEnvironmentShapeModel.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentShapeModel value."
VehicleSpaceEnvironmentShapeModel.PLATE.__doc__ = "Models the thermal properties of the vehicle using a plate."
VehicleSpaceEnvironmentShapeModel.SPHERE.__doc__ = "Models the thermal properties of the vehicle using a sphere."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentShapeModel"] = VehicleSpaceEnvironmentShapeModel

class VehicleSpaceEnvironmentF10P7SourceType(IntEnum):
    """Mode for computing 13-month average F10.7."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentF10P7SourceType value."""
    FILE = 0
    """Set the F10.7 flux source to use a flux file."""
    SPECIFY = 1
    """Set the F10.7 flux source to be a static value."""

VehicleSpaceEnvironmentF10P7SourceType.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentF10P7SourceType value."
VehicleSpaceEnvironmentF10P7SourceType.FILE.__doc__ = "Set the F10.7 flux source to use a flux file."
VehicleSpaceEnvironmentF10P7SourceType.SPECIFY.__doc__ = "Set the F10.7 flux source to be a static value."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentF10P7SourceType"] = VehicleSpaceEnvironmentF10P7SourceType

class VehicleSpaceEnvironmentMaterial(IntEnum):
    """Material."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentMaterial value."""
    ALUMINUM = 0
    """Uses aluminum for particle impact computations."""
    BERYLIUM_COPPER = 1
    """Uses berylium copper for particle impact computations."""
    COPPER = 2
    """Usescopper for particle impact computations."""
    GLASS = 3
    """Uses glass for particle impact computations."""
    GOLD = 4
    """Uses gold for particle impact computations."""
    IRON = 5
    """Uses iron for particle impact computations."""
    MYLAR = 6
    """Uses mylar for particle impact computations."""
    PLATINUM = 7
    """Uses platinum for particle impact computations."""
    SILVER = 8
    """Uses silver for particle impact computations."""
    STAINLESS_STEEL = 9
    """Uses stainless steel for particle impact computations."""
    TITANIUM = 10
    """Uses titanium for particle impact computations."""
    USER_DEFINED = 11
    """Uses a user-defined material for particle impact computations. Must specify density and tensile strength."""

VehicleSpaceEnvironmentMaterial.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentMaterial value."
VehicleSpaceEnvironmentMaterial.ALUMINUM.__doc__ = "Uses aluminum for particle impact computations."
VehicleSpaceEnvironmentMaterial.BERYLIUM_COPPER.__doc__ = "Uses berylium copper for particle impact computations."
VehicleSpaceEnvironmentMaterial.COPPER.__doc__ = "Usescopper for particle impact computations."
VehicleSpaceEnvironmentMaterial.GLASS.__doc__ = "Uses glass for particle impact computations."
VehicleSpaceEnvironmentMaterial.GOLD.__doc__ = "Uses gold for particle impact computations."
VehicleSpaceEnvironmentMaterial.IRON.__doc__ = "Uses iron for particle impact computations."
VehicleSpaceEnvironmentMaterial.MYLAR.__doc__ = "Uses mylar for particle impact computations."
VehicleSpaceEnvironmentMaterial.PLATINUM.__doc__ = "Uses platinum for particle impact computations."
VehicleSpaceEnvironmentMaterial.SILVER.__doc__ = "Uses silver for particle impact computations."
VehicleSpaceEnvironmentMaterial.STAINLESS_STEEL.__doc__ = "Uses stainless steel for particle impact computations."
VehicleSpaceEnvironmentMaterial.TITANIUM.__doc__ = "Uses titanium for particle impact computations."
VehicleSpaceEnvironmentMaterial.USER_DEFINED.__doc__ = "Uses a user-defined material for particle impact computations. Must specify density and tensile strength."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentMaterial"] = VehicleSpaceEnvironmentMaterial

class VehicleSpaceEnvironmentComputationMode(IntEnum):
    """Models that are to be included when modeling radiation."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentComputationMode value."""
    NASA = 0
    """Uses only NASAELE and NASAPRO models."""
    CRRES = 1
    """Uses only CRRESELE and CRRESPRO models."""
    RADIATION_ONLY = 2
    """Uses only APEXRAD and CRRESRAD models."""
    APEXRAD = 3
    """Uses only the APEXRAD model."""
    CRRESRAD = 4
    """Uses only the CRRESRAD model."""

VehicleSpaceEnvironmentComputationMode.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentComputationMode value."
VehicleSpaceEnvironmentComputationMode.NASA.__doc__ = "Uses only NASAELE and NASAPRO models."
VehicleSpaceEnvironmentComputationMode.CRRES.__doc__ = "Uses only CRRESELE and CRRESPRO models."
VehicleSpaceEnvironmentComputationMode.RADIATION_ONLY.__doc__ = "Uses only APEXRAD and CRRESRAD models."
VehicleSpaceEnvironmentComputationMode.APEXRAD.__doc__ = "Uses only the APEXRAD model."
VehicleSpaceEnvironmentComputationMode.CRRESRAD.__doc__ = "Uses only the CRRESRAD model."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentComputationMode"] = VehicleSpaceEnvironmentComputationMode

class VehicleSpaceEnvironmentDoseChannel(IntEnum):
    """Dose channel."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentDoseChannel value."""
    HIGH_LINEAR_ENERGY_TRANSPORT = 0
    """Characterizes high linear energy transport."""
    LOW_LINEAR_ENERGY_TRANSPORT = 1
    """Characterizes low linear energy transport."""
    TOTAL = 2
    """Considers all linear energy transport."""

VehicleSpaceEnvironmentDoseChannel.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentDoseChannel value."
VehicleSpaceEnvironmentDoseChannel.HIGH_LINEAR_ENERGY_TRANSPORT.__doc__ = "Characterizes high linear energy transport."
VehicleSpaceEnvironmentDoseChannel.LOW_LINEAR_ENERGY_TRANSPORT.__doc__ = "Characterizes low linear energy transport."
VehicleSpaceEnvironmentDoseChannel.TOTAL.__doc__ = "Considers all linear energy transport."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentDoseChannel"] = VehicleSpaceEnvironmentDoseChannel

class VehicleSpaceEnvironmentDetectorGeometry(IntEnum):
    """Detector geometry."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentDetectorGeometry value."""
    SEMI_INFINITE_SLAB = 0
    """Uses semi-infinite slab model."""
    FINITE_SLAB = 1
    """Uses finite slab model."""
    SPHERICAL = 2
    """Uses spherical model."""

VehicleSpaceEnvironmentDetectorGeometry.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentDetectorGeometry value."
VehicleSpaceEnvironmentDetectorGeometry.SEMI_INFINITE_SLAB.__doc__ = "Uses semi-infinite slab model."
VehicleSpaceEnvironmentDetectorGeometry.FINITE_SLAB.__doc__ = "Uses finite slab model."
VehicleSpaceEnvironmentDetectorGeometry.SPHERICAL.__doc__ = "Uses spherical model."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentDetectorGeometry"] = VehicleSpaceEnvironmentDetectorGeometry

class VehicleSpaceEnvironmentDetectorType(IntEnum):
    """Detector material."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentDetectorType value."""
    AIR = 0
    """Uses air as the shielding material for radiation dose computations."""
    ALUMINUM = 1
    """Uses aluminum as the shielding material for radiation dose computations."""
    BONE = 2
    """Uses bone as the shielding material for radiation dose computations."""
    CALCIUM = 3
    """Uses calcium as the shielding material for radiation dose computations."""
    GALLIUM = 4
    """Uses gallium as the shielding material for radiation dose computations."""
    GRAPHITE = 5
    """Uses graphite as the shielding material for radiation dose computations."""
    LITHIUM = 6
    """Uses lithium as the shielding material for radiation dose computations."""
    SILICON = 7
    """Uses silicon as the shielding material for radiation dose computations."""
    SILICON_DIOXIDE = 8
    """Uses silicon dioxide as the shielding material for radiation dose computations."""
    TISSUE = 9
    """Uses tissue as the shielding material for radiation dose computations."""
    WATER = 10
    """Uses water as the shielding material for radiation dose computations."""

VehicleSpaceEnvironmentDetectorType.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentDetectorType value."
VehicleSpaceEnvironmentDetectorType.AIR.__doc__ = "Uses air as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.ALUMINUM.__doc__ = "Uses aluminum as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.BONE.__doc__ = "Uses bone as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.CALCIUM.__doc__ = "Uses calcium as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.GALLIUM.__doc__ = "Uses gallium as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.GRAPHITE.__doc__ = "Uses graphite as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.LITHIUM.__doc__ = "Uses lithium as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.SILICON.__doc__ = "Uses silicon as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.SILICON_DIOXIDE.__doc__ = "Uses silicon dioxide as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.TISSUE.__doc__ = "Uses tissue as the shielding material for radiation dose computations."
VehicleSpaceEnvironmentDetectorType.WATER.__doc__ = "Uses water as the shielding material for radiation dose computations."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentDetectorType"] = VehicleSpaceEnvironmentDetectorType

class VehicleSpaceEnvironmentApSource(IntEnum):
    """Mode for computing 15 day average Ap."""

    UNKNOWN = -1
    """An invalid VehicleSpaceEnvironmentApSource value."""
    FILE = 0
    """Set the Ap flux source to use a flux file."""
    SPECIFY = 1
    """Set the Ap flux source to be a static value."""

VehicleSpaceEnvironmentApSource.UNKNOWN.__doc__ = "An invalid VehicleSpaceEnvironmentApSource value."
VehicleSpaceEnvironmentApSource.FILE.__doc__ = "Set the Ap flux source to use a flux file."
VehicleSpaceEnvironmentApSource.SPECIFY.__doc__ = "Set the Ap flux source to be a static value."

agcls.AgTypeNameMap["VehicleSpaceEnvironmentApSource"] = VehicleSpaceEnvironmentApSource

class NotificationFilterMask(IntFlag):
    """The notification flags are used to enable/disable STK Object Model event notifications."""

    NO_EVENTS = 0x0000
    """Disable all events."""
    ANIMATION_EVENTS = 0x0001
    """Clients are notified upon occurrence of any of the available animation events. Animation events include OnAnimUpdate, OnAnimationRewind, etc."""
    SCENARIO_EVENTS = 0x0002
    """Clients are notified upon occurrence of any of the available scenario events. Scenario events include OnScenarioNew, OnScenarioLoad, OnScenarioBeforeClose, OnScenarioClose, etc."""
    LOGGING_EVENTS = 0x0004
    """Clients are notified upon occurrence of OnLogMessage event."""
    OBJECT_EVENTS = 0x0008
    """Clients are notified upon occurrence of an event affecting the object hierarchy (OnStkObjectAdded, OnStkObjectDeleted and OnStkObjectPreDelete)."""
    OBJECT_CHANGED_EVENTS = 0x0010
    """Clients are notified upon occurrence of OnStkObjectChanged event."""
    PERCENT_COMPLETE_EVENTS = 0x0020
    """Clients are notified upon occurrence of any of the available percent complete events (OnPercentComplete*)."""
    OBJECT_RENAME_EVENTS = 0x0040
    """Clients are notified upon occurrence of an STK object renaming event."""
    ENABLE_ALL_EVENTS = 0xFFFF
    """Enable all events."""
    STK_OBJECT_3D_EDITING_EVENTS = 0x0080
    """Clients are notified upon occurrence of any of the available object editing events. Object editing events include OnStkObjectStart3dEditing, OnStkObjectStop3dEditing, OnStkObjectApply3dEditing, OnStkObjectCancel3dEditing etc."""
    STK_OBJECT_CUT_COPY_PASTE_EVENTS = 0x0100
    """Clients are notified upon occurrence of any of the available STK object Cut, Copy and Paste events."""

NotificationFilterMask.NO_EVENTS.__doc__ = "Disable all events."
NotificationFilterMask.ANIMATION_EVENTS.__doc__ = "Clients are notified upon occurrence of any of the available animation events. Animation events include OnAnimUpdate, OnAnimationRewind, etc."
NotificationFilterMask.SCENARIO_EVENTS.__doc__ = "Clients are notified upon occurrence of any of the available scenario events. Scenario events include OnScenarioNew, OnScenarioLoad, OnScenarioBeforeClose, OnScenarioClose, etc."
NotificationFilterMask.LOGGING_EVENTS.__doc__ = "Clients are notified upon occurrence of OnLogMessage event."
NotificationFilterMask.OBJECT_EVENTS.__doc__ = "Clients are notified upon occurrence of an event affecting the object hierarchy (OnStkObjectAdded, OnStkObjectDeleted and OnStkObjectPreDelete)."
NotificationFilterMask.OBJECT_CHANGED_EVENTS.__doc__ = "Clients are notified upon occurrence of OnStkObjectChanged event."
NotificationFilterMask.PERCENT_COMPLETE_EVENTS.__doc__ = "Clients are notified upon occurrence of any of the available percent complete events (OnPercentComplete*)."
NotificationFilterMask.OBJECT_RENAME_EVENTS.__doc__ = "Clients are notified upon occurrence of an STK object renaming event."
NotificationFilterMask.ENABLE_ALL_EVENTS.__doc__ = "Enable all events."
NotificationFilterMask.STK_OBJECT_3D_EDITING_EVENTS.__doc__ = "Clients are notified upon occurrence of any of the available object editing events. Object editing events include OnStkObjectStart3dEditing, OnStkObjectStop3dEditing, OnStkObjectApply3dEditing, OnStkObjectCancel3dEditing etc."
NotificationFilterMask.STK_OBJECT_CUT_COPY_PASTE_EVENTS.__doc__ = "Clients are notified upon occurrence of any of the available STK object Cut, Copy and Paste events."

agcls.AgTypeNameMap["NotificationFilterMask"] = NotificationFilterMask


class IDataProviderInfo(object):
    """Provide methods for retrieving the information about data providers."""

    _num_methods = 3
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _is_group_method_offset = 3
    _metadata = {
        "iid_data" : (4807813637529739857, 8845812768069019545),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDataProviderInfo."""
        initialize_from_source_object(self, source_object, IDataProviderInfo)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDataProviderInfo)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDataProviderInfo, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Return a name of the data provider."""
        return self._intf.get_property(IDataProviderInfo._metadata, IDataProviderInfo._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(DataProviderType),) }
    @property
    def type(self) -> "DataProviderType":
        """Return a type of the data provider."""
        return self._intf.get_property(IDataProviderInfo._metadata, IDataProviderInfo._get_type_metadata)

    _is_group_metadata = { "offset" : _is_group_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    def is_group(self) -> bool:
        """Determine if the data provider represents a group."""
        return self._intf.invoke(IDataProviderInfo._metadata, IDataProviderInfo._is_group_metadata, OutArg())

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4807813637529739857, 8845812768069019545), IDataProviderInfo)
agcls.AgTypeNameMap["IDataProviderInfo"] = IDataProviderInfo

class IDataProvider(object):
    """Represents the Sub Data Provider (i.e. ``Fixed`` in ``Cartesian Position`` group on satellites, or ``Cartesian Position`` on facilities)."""

    _num_methods = 10
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_elements_method_offset = 1
    _get_pre_data_method_offset = 2
    _set_pre_data_method_offset = 3
    _get_allow_user_interface_for_pre_data_method_offset = 4
    _set_allow_user_interface_for_pre_data_method_offset = 5
    _get_is_valid_method_offset = 6
    _get_pre_data_required_method_offset = 7
    _is_statistic_available_method_offset = 8
    _is_time_varying_extremum_available_method_offset = 9
    _get_pre_data_description_method_offset = 10
    _metadata = {
        "iid_data" : (5155632021552283324, 2376779169503638968),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDataProvider."""
        initialize_from_source_object(self, source_object, IDataProvider)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDataProvider)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDataProvider, None)

    _get_elements_metadata = { "offset" : _get_elements_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def elements(self) -> "DataProviderElements":
        """Return a collection of elements associated with a DataProvider or a SubDataProvider."""
        return self._intf.get_property(IDataProvider._metadata, IDataProvider._get_elements_metadata)

    _get_pre_data_metadata = { "offset" : _get_pre_data_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def pre_data(self) -> str:
        """The string associated with the current PreData parameter."""
        return self._intf.get_property(IDataProvider._metadata, IDataProvider._get_pre_data_metadata)

    _set_pre_data_metadata = { "offset" : _set_pre_data_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @pre_data.setter
    def pre_data(self, value:str) -> None:
        return self._intf.set_property(IDataProvider._metadata, IDataProvider._set_pre_data_metadata, value)

    _get_allow_user_interface_for_pre_data_metadata = { "offset" : _get_allow_user_interface_for_pre_data_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def allow_user_interface_for_pre_data(self) -> bool:
        """When set to true the data provider will display a user interface to select/enter the pre-data required."""
        return self._intf.get_property(IDataProvider._metadata, IDataProvider._get_allow_user_interface_for_pre_data_metadata)

    _set_allow_user_interface_for_pre_data_metadata = { "offset" : _set_allow_user_interface_for_pre_data_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @allow_user_interface_for_pre_data.setter
    def allow_user_interface_for_pre_data(self, value:bool) -> None:
        return self._intf.set_property(IDataProvider._metadata, IDataProvider._set_allow_user_interface_for_pre_data_metadata, value)

    _get_is_valid_metadata = { "offset" : _get_is_valid_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def is_valid(self) -> bool:
        """Return whether the data provider is valid."""
        return self._intf.get_property(IDataProvider._metadata, IDataProvider._get_is_valid_metadata)

    _get_pre_data_required_metadata = { "offset" : _get_pre_data_required_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def pre_data_required(self) -> bool:
        """Return whether the data provider requires pre data."""
        return self._intf.get_property(IDataProvider._metadata, IDataProvider._get_pre_data_required_metadata)

    _is_statistic_available_metadata = { "offset" : _is_statistic_available_method_offset,
            "arg_types" : (agcom.LONG, agcom.BSTR, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(StatisticType), agmarshall.BStrArg, agmarshall.VariantBoolArg,) }
    def is_statistic_available(self, statistic:"StatisticType", element_name:str) -> bool:
        """Is the supplied statistic available for the provided element name?"""
        return self._intf.invoke(IDataProvider._metadata, IDataProvider._is_statistic_available_metadata, statistic, element_name, OutArg())

    _is_time_varying_extremum_available_metadata = { "offset" : _is_time_varying_extremum_available_method_offset,
            "arg_types" : (agcom.LONG, agcom.BSTR, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(TimeVaryingExtremum), agmarshall.BStrArg, agmarshall.VariantBoolArg,) }
    def is_time_varying_extremum_available(self, time_var_extremum:"TimeVaryingExtremum", element_name:str) -> bool:
        """Is the supplied time varying extremum available for the provided element name?"""
        return self._intf.invoke(IDataProvider._metadata, IDataProvider._is_time_varying_extremum_available_metadata, time_var_extremum, element_name, OutArg())

    _get_pre_data_description_metadata = { "offset" : _get_pre_data_description_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def pre_data_description(self) -> str:
        """Return a description of the required pre data."""
        return self._intf.get_property(IDataProvider._metadata, IDataProvider._get_pre_data_description_metadata)

    _property_names[elements] = "elements"
    _property_names[pre_data] = "pre_data"
    _property_names[allow_user_interface_for_pre_data] = "allow_user_interface_for_pre_data"
    _property_names[is_valid] = "is_valid"
    _property_names[pre_data_required] = "pre_data_required"
    _property_names[pre_data_description] = "pre_data_description"


agcls.AgClassCatalog.add_catalog_entry((5155632021552283324, 2376779169503638968), IDataProvider)
agcls.AgTypeNameMap["IDataProvider"] = IDataProvider

class ISTKObject(object):
    """
    Represents the instance of STK object.

    Examples
    --------
    Create a New AdvCAT Object:
    >>> # Scenario scenario: Scenario object
    >>> advCAT = scenario.children.new(STKObjectType.ADVCAT, "MyAdvCAT")
    """

    _num_methods = 29
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_parent_method_offset = 1
    _get_path_method_offset = 2
    _get_instance_name_method_offset = 3
    _set_instance_name_method_offset = 4
    _get_class_type_method_offset = 5
    _get_class_name_method_offset = 6
    _get_children_method_offset = 7
    _export_method_offset = 8
    _get_root_method_offset = 9
    _get_data_providers_method_offset = 10
    _get_short_description_method_offset = 11
    _set_short_description_method_offset = 12
    _get_long_description_method_offset = 13
    _set_long_description_method_offset = 14
    _get_has_children_method_offset = 15
    _is_object_coverage_supported_method_offset = 16
    _get_object_coverage_method_offset = 17
    _is_access_supported_method_offset = 18
    _get_access_method_offset = 19
    _get_access_to_object_method_offset = 20
    _get_access_constraints_method_offset = 21
    _create_one_point_access_method_offset = 22
    _get_object_files_method_offset = 23
    _unload_method_offset = 24
    _supports_analysis_workbench_method_offset = 25
    _get_analysis_workbench_components_method_offset = 26
    _copy_object_method_offset = 27
    _get_central_body_name_method_offset = 28
    _get_metadata_method_offset = 29
    _metadata = {
        "iid_data" : (5684331285240064776, 682992631032012709),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISTKObject."""
        initialize_from_source_object(self, source_object, ISTKObject)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISTKObject)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISTKObject, None)

    _get_parent_metadata = { "offset" : _get_parent_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def parent(self) -> "ISTKObject":
        """Return the parent object or null if the object has become orphaned. The exception is STKObjectRoot object which is a topmost element and does not have a parent."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_parent_metadata)

    _get_path_metadata = { "offset" : _get_path_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def path(self) -> str:
        """Return the object path."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_path_metadata)

    _get_instance_name_metadata = { "offset" : _get_instance_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def instance_name(self) -> str:
        """A name of the object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_instance_name_metadata)

    _set_instance_name_metadata = { "offset" : _set_instance_name_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @instance_name.setter
    def instance_name(self, value:str) -> None:
        return self._intf.set_property(ISTKObject._metadata, ISTKObject._set_instance_name_metadata, value)

    _get_class_type_metadata = { "offset" : _get_class_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(STKObjectType),) }
    @property
    def class_type(self) -> "STKObjectType":
        """Return a class type of the object (i.e. eAircraft, eFacility etc.)."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_class_type_metadata)

    _get_class_name_metadata = { "offset" : _get_class_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def class_name(self) -> str:
        """Return a class name of the object (i.e. Aircraft, Facility.)."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_class_name_metadata)

    _get_children_metadata = { "offset" : _get_children_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def children(self) -> "ISTKObjectCollection":
        """Return a collection of direct descendants of the current object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_children_metadata)

    _export_metadata = { "offset" : _export_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    def export(self, filename:str) -> None:
        """Export the object to a file."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._export_metadata, filename)

    _get_root_metadata = { "offset" : _get_root_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def root(self) -> "STKObjectRoot":
        """Return the Root object or null."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_root_metadata)

    _get_data_providers_metadata = { "offset" : _get_data_providers_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def data_providers(self) -> "DataProviderCollection":
        """Return the object representing a list of available data providers for the object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_data_providers_metadata)

    _get_short_description_metadata = { "offset" : _get_short_description_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def short_description(self) -> str:
        """The short description of the object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_short_description_metadata)

    _set_short_description_metadata = { "offset" : _set_short_description_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @short_description.setter
    def short_description(self, short_desc:str) -> None:
        return self._intf.set_property(ISTKObject._metadata, ISTKObject._set_short_description_metadata, short_desc)

    _get_long_description_metadata = { "offset" : _get_long_description_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def long_description(self) -> str:
        """A long description of the object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_long_description_metadata)

    _set_long_description_metadata = { "offset" : _set_long_description_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @long_description.setter
    def long_description(self, long_desc:str) -> None:
        return self._intf.set_property(ISTKObject._metadata, ISTKObject._set_long_description_metadata, long_desc)

    _get_has_children_metadata = { "offset" : _get_has_children_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def has_children(self) -> bool:
        """Return true if the object has direct descendants."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_has_children_metadata)

    _is_object_coverage_supported_metadata = { "offset" : _is_object_coverage_supported_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    def is_object_coverage_supported(self) -> bool:
        """Determine whether or not the object supports ObjectCoverage."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._is_object_coverage_supported_metadata, OutArg())

    _get_object_coverage_metadata = { "offset" : _get_object_coverage_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def object_coverage(self) -> "ObjectCoverage":
        """Return an ObjectCoverage object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_object_coverage_metadata)

    _is_access_supported_metadata = { "offset" : _is_access_supported_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    def is_access_supported(self) -> bool:
        """Determine whether or not the object supports Access."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._is_access_supported_metadata, OutArg())

    _get_access_metadata = { "offset" : _get_access_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def get_access(self, object_path:str) -> "Access":
        """Return an Access object associated with this STK object and another STK object specified using its path. The path can be fully-qualified or truncated."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._get_access_metadata, object_path, OutArg())

    _get_access_to_object_metadata = { "offset" : _get_access_to_object_method_offset,
            "arg_types" : (agcom.PVOID, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceInArg("ISTKObject"), agmarshall.InterfaceOutArg,) }
    def get_access_to_object(self, object:"ISTKObject") -> "Access":
        """Return an Access object associated with this STK object and another STK object."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._get_access_to_object_metadata, object, OutArg())

    _get_access_constraints_metadata = { "offset" : _get_access_constraints_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def access_constraints(self) -> "AccessConstraintCollection":
        """Get the constraints imposed on the object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_access_constraints_metadata)

    _create_one_point_access_metadata = { "offset" : _create_one_point_access_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def create_one_point_access(self, path_to_object:str) -> "OnePointAccess":
        """Create one point access to the supplied object name. The Remove method in OnePointAccess should be called when you are done with the data."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._create_one_point_access_metadata, path_to_object, OutArg())

    _get_object_files_metadata = { "offset" : _get_object_files_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def object_files(self) -> list:
        """Return the list of files that constitute an object."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_object_files_metadata)

    _unload_metadata = { "offset" : _unload_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def unload(self) -> None:
        """Remove the object from the scenario."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._unload_metadata, )

    _supports_analysis_workbench_metadata = { "offset" : _supports_analysis_workbench_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    def supports_analysis_workbench(self) -> bool:
        """Return whether the object supports Vector Geometry."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._supports_analysis_workbench_metadata, OutArg())

    _get_analysis_workbench_components_metadata = { "offset" : _get_analysis_workbench_components_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def analysis_workbench_components(self) -> "IAnalysisWorkbenchComponentProvider":
        """Return an instance of Vector Geometry Tool provider."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_analysis_workbench_components_metadata)

    _copy_object_metadata = { "offset" : _copy_object_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def copy_object(self, new_object_name:str) -> "ISTKObject":
        """Copy and paste the current instance of STK Object. The copied object will be pasted as the sibling of the instance being copied."""
        return self._intf.invoke(ISTKObject._metadata, ISTKObject._copy_object_metadata, new_object_name, OutArg())

    _get_central_body_name_metadata = { "offset" : _get_central_body_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def central_body_name(self) -> str:
        """The object's central body."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_central_body_name_metadata)

    _get_metadata_metadata = { "offset" : _get_metadata_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def metadata(self) -> "KeyValueCollection":
        """Get the object's metadata. Metadata is a collection of keys and their associated values."""
        return self._intf.get_property(ISTKObject._metadata, ISTKObject._get_metadata_metadata)

    _property_names[parent] = "parent"
    _property_names[path] = "path"
    _property_names[instance_name] = "instance_name"
    _property_names[class_type] = "class_type"
    _property_names[class_name] = "class_name"
    _property_names[children] = "children"
    _property_names[root] = "root"
    _property_names[data_providers] = "data_providers"
    _property_names[short_description] = "short_description"
    _property_names[long_description] = "long_description"
    _property_names[has_children] = "has_children"
    _property_names[object_coverage] = "object_coverage"
    _property_names[access_constraints] = "access_constraints"
    _property_names[object_files] = "object_files"
    _property_names[analysis_workbench_components] = "analysis_workbench_components"
    _property_names[central_body_name] = "central_body_name"
    _property_names[metadata] = "metadata"


agcls.AgClassCatalog.add_catalog_entry((5684331285240064776, 682992631032012709), ISTKObject)
agcls.AgTypeNameMap["ISTKObject"] = ISTKObject

class IAccessInterval(object):
    """Base interface for ITimePeriod and TimeIntervalCollection."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4978520745393007291, 368973114715273407),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAccessInterval."""
        initialize_from_source_object(self, source_object, IAccessInterval)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAccessInterval)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAccessInterval, None)



agcls.AgClassCatalog.add_catalog_entry((4978520745393007291, 368973114715273407), IAccessInterval)
agcls.AgTypeNameMap["IAccessInterval"] = IAccessInterval

class IFigureOfMeritDefinition(object):
    """Figure of Merit definition."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_satisfaction_method_offset = 1
    _metadata = {
        "iid_data" : (5619442526477316564, 18283544942267320979),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IFigureOfMeritDefinition."""
        initialize_from_source_object(self, source_object, IFigureOfMeritDefinition)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IFigureOfMeritDefinition)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IFigureOfMeritDefinition, None)

    _get_satisfaction_metadata = { "offset" : _get_satisfaction_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def satisfaction(self) -> "FigureOfMeritSatisfaction":
        """Satisfaction criteria for the Figure of Merit."""
        return self._intf.get_property(IFigureOfMeritDefinition._metadata, IFigureOfMeritDefinition._get_satisfaction_metadata)

    _property_names[satisfaction] = "satisfaction"


agcls.AgClassCatalog.add_catalog_entry((5619442526477316564, 18283544942267320979), IFigureOfMeritDefinition)
agcls.AgTypeNameMap["IFigureOfMeritDefinition"] = IFigureOfMeritDefinition

class IFigureOfMeritDefinitionCompute(IFigureOfMeritDefinition):
    """Compute options for navigation accuracy."""

    _num_methods = 5
    _vtable_offset = IFigureOfMeritDefinition._vtable_offset + IFigureOfMeritDefinition._num_methods
    _get_compute_type_method_offset = 1
    _set_compute_type_method_offset = 2
    _is_compute_type_supported_method_offset = 3
    _get_compute_supported_types_method_offset = 4
    _get_compute_method_offset = 5
    _metadata = {
        "iid_data" : (5466845781897018838, 3334443694100846508),
        "vtable_reference" : IFigureOfMeritDefinition._vtable_offset + IFigureOfMeritDefinition._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IFigureOfMeritDefinitionCompute."""
        initialize_from_source_object(self, source_object, IFigureOfMeritDefinitionCompute)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
        IFigureOfMeritDefinition._private_init(self, intf)
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IFigureOfMeritDefinitionCompute)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IFigureOfMeritDefinitionCompute, IFigureOfMeritDefinition)

    _get_compute_type_metadata = { "offset" : _get_compute_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(FigureOfMeritCompute),) }
    @property
    def compute_type(self) -> "FigureOfMeritCompute":
        """Type of compute option to be used for navigation accuracy."""
        return self._intf.get_property(IFigureOfMeritDefinitionCompute._metadata, IFigureOfMeritDefinitionCompute._get_compute_type_metadata)

    _set_compute_type_metadata = { "offset" : _set_compute_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(FigureOfMeritCompute),) }
    def set_compute_type(self, compute_type:"FigureOfMeritCompute") -> None:
        """Set the type of compute option."""
        return self._intf.invoke(IFigureOfMeritDefinitionCompute._metadata, IFigureOfMeritDefinitionCompute._set_compute_type_metadata, compute_type)

    _is_compute_type_supported_metadata = { "offset" : _is_compute_type_supported_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(FigureOfMeritCompute), agmarshall.VariantBoolArg,) }
    def is_compute_type_supported(self, compute_type:"FigureOfMeritCompute") -> bool:
        """Is the type of compute option supported?"""
        return self._intf.invoke(IFigureOfMeritDefinitionCompute._metadata, IFigureOfMeritDefinitionCompute._is_compute_type_supported_metadata, compute_type, OutArg())

    _get_compute_supported_types_metadata = { "offset" : _get_compute_supported_types_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def compute_supported_types(self) -> list:
        """Compute supported types."""
        return self._intf.get_property(IFigureOfMeritDefinitionCompute._metadata, IFigureOfMeritDefinitionCompute._get_compute_supported_types_metadata)

    _get_compute_metadata = { "offset" : _get_compute_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def compute(self) -> "IFigureOfMeritDefinitionData":
        """Compute."""
        return self._intf.get_property(IFigureOfMeritDefinitionCompute._metadata, IFigureOfMeritDefinitionCompute._get_compute_metadata)

    _property_names[compute_type] = "compute_type"
    _property_names[compute_supported_types] = "compute_supported_types"
    _property_names[compute] = "compute"


agcls.AgClassCatalog.add_catalog_entry((5466845781897018838, 3334443694100846508), IFigureOfMeritDefinitionCompute)
agcls.AgTypeNameMap["IFigureOfMeritDefinitionCompute"] = IFigureOfMeritDefinitionCompute

class ISTKObjectElementCollection(object):
    """Represents a collection of STK objects."""

    _num_methods = 6
    _vtable_offset = IDispatch._vtable_offset + IDispatch._num_methods
    _get_count_method_offset = 1
    _item_method_offset = 2
    _get__new_enum_method_offset = 3
    _contains_method_offset = 4
    _get_item_by_index_method_offset = 5
    _get_item_by_name_method_offset = 6
    _metadata = {
        "iid_data" : (5096702068244902831, 8096268259154586774),
        "vtable_reference" : IDispatch._vtable_offset + IDispatch._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISTKObjectElementCollection."""
        initialize_from_source_object(self, source_object, ISTKObjectElementCollection)
        self.__dict__["_enumerator"] = None
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISTKObjectElementCollection)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISTKObjectElementCollection, None)
    def __iter__(self):
        """Create an iterator for the ISTKObjectElementCollection object."""
        self.__dict__["_enumerator"] = self._new_enum
        self._enumerator.reset()
        return self
    def __next__(self) -> "ISTKObject":
        """Return the next element in the collection."""
        if self._enumerator is None:
            raise StopIteration
        nextval = self._enumerator.next()
        if nextval is None:
            raise StopIteration
        return nextval

    _get_count_metadata = { "offset" : _get_count_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.LongArg,) }
    @property
    def count(self) -> int:
        """Return the number of elements in a collection."""
        return self._intf.get_property(ISTKObjectElementCollection._metadata, ISTKObjectElementCollection._get_count_metadata)

    _item_metadata = { "offset" : _item_method_offset,
            "arg_types" : (agcom.Variant, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.VariantArg, agmarshall.InterfaceOutArg,) }
    def item(self, index_or_name:typing.Any) -> "ISTKObject":
        """Given an index, returns an element in the collection. If the index is an integer, then the method returns the element in the collection at the given position. If the index is a string, then the method returns the element with the specified name."""
        return self._intf.invoke(ISTKObjectElementCollection._metadata, ISTKObjectElementCollection._item_metadata, index_or_name, OutArg())

    _get__new_enum_metadata = { "offset" : _get__new_enum_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.IEnumVariantArg,) }
    @property
    def _new_enum(self) -> EnumeratorProxy:
        """Return an enumerator that can iterate through the collection."""
        return self._intf.get_property(ISTKObjectElementCollection._metadata, ISTKObjectElementCollection._get__new_enum_metadata)

    _contains_metadata = { "offset" : _contains_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.VariantBoolArg,) }
    def contains(self, inst_name:str) -> bool:
        """Check whether an object with the given name exists."""
        return self._intf.invoke(ISTKObjectElementCollection._metadata, ISTKObjectElementCollection._contains_metadata, inst_name, OutArg())

    _get_item_by_index_metadata = { "offset" : _get_item_by_index_method_offset,
            "arg_types" : (agcom.INT, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.IntArg, agmarshall.InterfaceOutArg,) }
    def get_item_by_index(self, index:int) -> "ISTKObject":
        """Retrieve an Stk object element from the collection by index."""
        return self._intf.invoke(ISTKObjectElementCollection._metadata, ISTKObjectElementCollection._get_item_by_index_metadata, index, OutArg())

    _get_item_by_name_metadata = { "offset" : _get_item_by_name_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def get_item_by_name(self, name:str) -> "ISTKObject":
        """Retrieve an Stk object element from the collection by name."""
        return self._intf.invoke(ISTKObjectElementCollection._metadata, ISTKObjectElementCollection._get_item_by_name_metadata, name, OutArg())

    __getitem__ = item


    _property_names[count] = "count"
    _property_names[_new_enum] = "_new_enum"


agcls.AgClassCatalog.add_catalog_entry((5096702068244902831, 8096268259154586774), ISTKObjectElementCollection)
agcls.AgTypeNameMap["ISTKObjectElementCollection"] = ISTKObjectElementCollection

class ISTKObjectCollection(object):
    """Represents a collection of STK objects."""

    _num_methods = 13
    _vtable_offset = IDispatch._vtable_offset + IDispatch._num_methods
    _get_count_method_offset = 1
    _item_method_offset = 2
    _get__new_enum_method_offset = 3
    _new_method_offset = 4
    _unload_method_offset = 5
    _get_elements_method_offset = 6
    _new_on_central_body_method_offset = 7
    _get_supported_child_types_method_offset = 8
    _contains_method_offset = 9
    _import_object_method_offset = 10
    _copy_object_method_offset = 11
    _get_item_by_index_method_offset = 12
    _get_item_by_name_method_offset = 13
    _metadata = {
        "iid_data" : (5198092366622301019, 13565157834551497125),
        "vtable_reference" : IDispatch._vtable_offset + IDispatch._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISTKObjectCollection."""
        initialize_from_source_object(self, source_object, ISTKObjectCollection)
        self.__dict__["_enumerator"] = None
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISTKObjectCollection)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISTKObjectCollection, None)
    def __iter__(self):
        """Create an iterator for the ISTKObjectCollection object."""
        self.__dict__["_enumerator"] = self._new_enum
        self._enumerator.reset()
        return self
    def __next__(self) -> "ISTKObject":
        """Return the next element in the collection."""
        if self._enumerator is None:
            raise StopIteration
        nextval = self._enumerator.next()
        if nextval is None:
            raise StopIteration
        return nextval

    _get_count_metadata = { "offset" : _get_count_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.LongArg,) }
    @property
    def count(self) -> int:
        """Return the number of elements in the collection."""
        return self._intf.get_property(ISTKObjectCollection._metadata, ISTKObjectCollection._get_count_metadata)

    _item_metadata = { "offset" : _item_method_offset,
            "arg_types" : (agcom.Variant, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.VariantArg, agmarshall.InterfaceOutArg,) }
    def item(self, index_or_name:typing.Any) -> "ISTKObject":
        """Given an index, returns the element in the collection. If the index is an integer, then method returns the element in the collection at the given position. If the index is a string, then the method returns the element with the specified name."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._item_metadata, index_or_name, OutArg())

    _get__new_enum_metadata = { "offset" : _get__new_enum_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.IEnumVariantArg,) }
    @property
    def _new_enum(self) -> EnumeratorProxy:
        """Return an enumerator for the collection."""
        return self._intf.get_property(ISTKObjectCollection._metadata, ISTKObjectCollection._get__new_enum_metadata)

    _new_metadata = { "offset" : _new_method_offset,
            "arg_types" : (agcom.LONG, agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.EnumArg(STKObjectType), agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def new(self, class_type:"STKObjectType", inst_name:str) -> "ISTKObject":
        """Create an STK object using specified class and instance name."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._new_metadata, class_type, inst_name, OutArg())

    _unload_metadata = { "offset" : _unload_method_offset,
            "arg_types" : (agcom.LONG, agcom.BSTR,),
            "marshallers" : (agmarshall.EnumArg(STKObjectType), agmarshall.BStrArg,) }
    def unload(self, class_type:"STKObjectType", inst_name:str) -> None:
        """Remove an STK object using specified object's type and name."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._unload_metadata, class_type, inst_name)

    _get_elements_metadata = { "offset" : _get_elements_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.EnumArg(STKObjectType), agmarshall.InterfaceOutArg,) }
    def get_elements(self, class_type:"STKObjectType") -> "ISTKObjectElementCollection":
        """Return a collection of objects of specified type."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._get_elements_metadata, class_type, OutArg())

    _new_on_central_body_metadata = { "offset" : _new_on_central_body_method_offset,
            "arg_types" : (agcom.LONG, agcom.BSTR, agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.EnumArg(STKObjectType), agmarshall.BStrArg, agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def new_on_central_body(self, class_type:"STKObjectType", inst_name:str, central_body_name:str) -> "ISTKObject":
        """Create an STK object using specified class, instance name and the central body."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._new_on_central_body_metadata, class_type, inst_name, central_body_name, OutArg())

    _get_supported_child_types_metadata = { "offset" : _get_supported_child_types_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def supported_child_types(self) -> list:
        """Return the available objects that can be added to this object."""
        return self._intf.get_property(ISTKObjectCollection._metadata, ISTKObjectCollection._get_supported_child_types_metadata)

    _contains_metadata = { "offset" : _contains_method_offset,
            "arg_types" : (agcom.LONG, agcom.BSTR, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(STKObjectType), agmarshall.BStrArg, agmarshall.VariantBoolArg,) }
    def contains(self, class_type:"STKObjectType", inst_name:str) -> bool:
        """Check whether the collection contains an object with the given type and name."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._contains_metadata, class_type, inst_name, OutArg())

    _import_object_metadata = { "offset" : _import_object_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def import_object(self, file_path:str) -> "ISTKObject":
        """Import object from external file and returns the pointer to the object."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._import_object_metadata, file_path, OutArg())

    _copy_object_metadata = { "offset" : _copy_object_method_offset,
            "arg_types" : (agcom.PVOID, agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceInArg("ISTKObject"), agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def copy_object(self, object_to_clone:"ISTKObject", new_object_name:str) -> "ISTKObject":
        """Copy and paste the specified object."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._copy_object_metadata, object_to_clone, new_object_name, OutArg())

    _get_item_by_index_metadata = { "offset" : _get_item_by_index_method_offset,
            "arg_types" : (agcom.INT, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.IntArg, agmarshall.InterfaceOutArg,) }
    def get_item_by_index(self, index:int) -> "ISTKObject":
        """Retrieve an Stk object from the collection by index."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._get_item_by_index_metadata, index, OutArg())

    _get_item_by_name_metadata = { "offset" : _get_item_by_name_method_offset,
            "arg_types" : (agcom.BSTR, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.BStrArg, agmarshall.InterfaceOutArg,) }
    def get_item_by_name(self, name:str) -> "ISTKObject":
        """Retrieve an Stk object from the collection by name."""
        return self._intf.invoke(ISTKObjectCollection._metadata, ISTKObjectCollection._get_item_by_name_metadata, name, OutArg())

    __getitem__ = item


    _property_names[count] = "count"
    _property_names[_new_enum] = "_new_enum"
    _property_names[supported_child_types] = "supported_child_types"


agcls.AgClassCatalog.add_catalog_entry((5198092366622301019, 13565157834551497125), ISTKObjectCollection)
agcls.AgTypeNameMap["ISTKObjectCollection"] = ISTKObjectCollection

class IAnimation(object):
    """
    Provide methods to control scenario animation.

    Examples
    --------
    Reset the scenario time:
    >>> # STKObjectRoot root: STK Object Model Root
    >>> root.rewind()

    Change animation mode:
    >>> # STKObjectRoot root: STK Object Model Root
    >>> scenario = root.current_scenario
    >>> root.animation_options = AnimationOptionType.STOP
    >>> root.mode = AnimationEndTimeMode.X_REAL_TIME
    >>> scenario.animation_settings.animation_step_value = 1  # second
    >>> scenario.animation_settings.refresh_delta = 0.03  # second
    """

    _num_methods = 17
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _play_forward_method_offset = 1
    _play_backward_method_offset = 2
    _pause_method_offset = 3
    _rewind_method_offset = 4
    _step_forward_method_offset = 5
    _step_backward_method_offset = 6
    _faster_method_offset = 7
    _slower_method_offset = 8
    _get_mode_method_offset = 9
    _set_mode_method_offset = 10
    _get_current_time_method_offset = 11
    _set_current_time_method_offset = 12
    _get_step_method_offset = 13
    _get_animation_options_method_offset = 14
    _set_animation_options_method_offset = 15
    _get_high_speed_method_offset = 16
    _set_high_speed_method_offset = 17
    _metadata = {
        "iid_data" : (4711865524792687706, 3558234660740142237),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAnimation."""
        initialize_from_source_object(self, source_object, IAnimation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAnimation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAnimation, None)

    _play_forward_metadata = { "offset" : _play_forward_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def play_forward(self) -> None:
        """Animate forward."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._play_forward_metadata, )

    _play_backward_metadata = { "offset" : _play_backward_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def play_backward(self) -> None:
        """Animate backward."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._play_backward_metadata, )

    _pause_metadata = { "offset" : _pause_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def pause(self) -> None:
        """Pause the animation."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._pause_metadata, )

    _rewind_metadata = { "offset" : _rewind_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def rewind(self) -> None:
        """Stop and reset the animation."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._rewind_metadata, )

    _step_forward_metadata = { "offset" : _step_forward_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def step_forward(self) -> None:
        """Advance the animation one step forward."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._step_forward_metadata, )

    _step_backward_metadata = { "offset" : _step_backward_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def step_backward(self) -> None:
        """Reverse the animation one step backward."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._step_backward_metadata, )

    _faster_metadata = { "offset" : _faster_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def faster(self) -> None:
        """Increase the speed of the animation."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._faster_metadata, )

    _slower_metadata = { "offset" : _slower_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def slower(self) -> None:
        """Decrease the speed of the animation."""
        return self._intf.invoke(IAnimation._metadata, IAnimation._slower_metadata, )

    _get_mode_metadata = { "offset" : _get_mode_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AnimationEndTimeMode),) }
    @property
    def mode(self) -> "AnimationEndTimeMode":
        """Animation mode."""
        return self._intf.get_property(IAnimation._metadata, IAnimation._get_mode_metadata)

    _set_mode_metadata = { "offset" : _set_mode_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(AnimationEndTimeMode),) }
    @mode.setter
    def mode(self, return_value:"AnimationEndTimeMode") -> None:
        return self._intf.set_property(IAnimation._metadata, IAnimation._set_mode_metadata, return_value)

    _get_current_time_metadata = { "offset" : _get_current_time_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def current_time(self) -> float:
        """Current animation time. In Epoch seconds."""
        return self._intf.get_property(IAnimation._metadata, IAnimation._get_current_time_metadata)

    _set_current_time_metadata = { "offset" : _set_current_time_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @current_time.setter
    def current_time(self, double_val:float) -> None:
        return self._intf.set_property(IAnimation._metadata, IAnimation._set_current_time_metadata, double_val)

    _get_step_metadata = { "offset" : _get_step_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def step(self) -> str:
        """Get animation time step."""
        return self._intf.get_property(IAnimation._metadata, IAnimation._get_step_metadata)

    _get_animation_options_metadata = { "offset" : _get_animation_options_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AnimationOptionType),) }
    @property
    def animation_options(self) -> "AnimationOptionType":
        """Animation options."""
        return self._intf.get_property(IAnimation._metadata, IAnimation._get_animation_options_metadata)

    _set_animation_options_metadata = { "offset" : _set_animation_options_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(AnimationOptionType),) }
    @animation_options.setter
    def animation_options(self, ani_options:"AnimationOptionType") -> None:
        return self._intf.set_property(IAnimation._metadata, IAnimation._set_animation_options_metadata, ani_options)

    _get_high_speed_metadata = { "offset" : _get_high_speed_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def high_speed(self) -> bool:
        """Control the animation speed."""
        return self._intf.get_property(IAnimation._metadata, IAnimation._get_high_speed_metadata)

    _set_high_speed_metadata = { "offset" : _set_high_speed_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @high_speed.setter
    def high_speed(self, high_speed:bool) -> None:
        return self._intf.set_property(IAnimation._metadata, IAnimation._set_high_speed_metadata, high_speed)

    _property_names[mode] = "mode"
    _property_names[current_time] = "current_time"
    _property_names[step] = "step"
    _property_names[animation_options] = "animation_options"
    _property_names[high_speed] = "high_speed"


agcls.AgClassCatalog.add_catalog_entry((4711865524792687706, 3558234660740142237), IAnimation)
agcls.AgTypeNameMap["IAnimation"] = IAnimation

class IComponentInfo(object):
    """Interface for a component."""

    _num_methods = 8
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _set_name_method_offset = 2
    _get_user_comment_method_offset = 3
    _set_user_comment_method_offset = 4
    _get_description_method_offset = 5
    _is_read_only_method_offset = 6
    _export_method_offset = 7
    _export_with_filename_path_method_offset = 8
    _metadata = {
        "iid_data" : (5393285516956947082, 17285868292206954116),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IComponentInfo."""
        initialize_from_source_object(self, source_object, IComponentInfo)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IComponentInfo)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IComponentInfo, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get or set the component name."""
        return self._intf.get_property(IComponentInfo._metadata, IComponentInfo._get_name_metadata)

    _set_name_metadata = { "offset" : _set_name_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @name.setter
    def name(self, name:str) -> None:
        return self._intf.set_property(IComponentInfo._metadata, IComponentInfo._set_name_metadata, name)

    _get_user_comment_metadata = { "offset" : _get_user_comment_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def user_comment(self) -> str:
        """Get or set the user comment for this component."""
        return self._intf.get_property(IComponentInfo._metadata, IComponentInfo._get_user_comment_metadata)

    _set_user_comment_metadata = { "offset" : _set_user_comment_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @user_comment.setter
    def user_comment(self, user_comment:str) -> None:
        return self._intf.set_property(IComponentInfo._metadata, IComponentInfo._set_user_comment_metadata, user_comment)

    _get_description_metadata = { "offset" : _get_description_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def description(self) -> str:
        """Get the description for this component."""
        return self._intf.get_property(IComponentInfo._metadata, IComponentInfo._get_description_metadata)

    _is_read_only_metadata = { "offset" : _is_read_only_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    def is_read_only(self) -> bool:
        """Return true if the component is read-only."""
        return self._intf.invoke(IComponentInfo._metadata, IComponentInfo._is_read_only_metadata, OutArg())

    _export_metadata = { "offset" : _export_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def export(self) -> None:
        """Export the component with default component name as file name and component type as file extension to the scenario directory."""
        return self._intf.invoke(IComponentInfo._metadata, IComponentInfo._export_metadata, )

    _export_with_filename_path_metadata = { "offset" : _export_with_filename_path_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    def export_with_filename_path(self, filename_path:str) -> None:
        """Export the component with specified file name and location."""
        return self._intf.invoke(IComponentInfo._metadata, IComponentInfo._export_with_filename_path_metadata, filename_path)

    _property_names[name] = "name"
    _property_names[user_comment] = "user_comment"
    _property_names[description] = "description"


agcls.AgClassCatalog.add_catalog_entry((5393285516956947082, 17285868292206954116), IComponentInfo)
agcls.AgTypeNameMap["IComponentInfo"] = IComponentInfo

class ICloneable(object):
    """Interface for a component."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _clone_object_method_offset = 1
    _metadata = {
        "iid_data" : (5266199410648796167, 6078109941845782692),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICloneable."""
        initialize_from_source_object(self, source_object, ICloneable)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICloneable)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICloneable, None)

    _clone_object_metadata = { "offset" : _clone_object_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    def clone_object(self) -> typing.Any:
        """Make a clone of this component."""
        return self._intf.invoke(ICloneable._metadata, ICloneable._clone_object_metadata, OutArg())



agcls.AgClassCatalog.add_catalog_entry((5266199410648796167, 6078109941845782692), ICloneable)
agcls.AgTypeNameMap["ICloneable"] = ICloneable

class IComponentLinkEmbedControl(object):
    """Interface for a control which manages the linking or embedding of a component from the component browser."""

    _num_methods = 5
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_reference_type_method_offset = 1
    _set_reference_type_method_offset = 2
    _get_component_method_offset = 3
    _get_supported_components_method_offset = 4
    _set_component_method_offset = 5
    _metadata = {
        "iid_data" : (5602718486014656526, 8140965578869473943),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IComponentLinkEmbedControl."""
        initialize_from_source_object(self, source_object, IComponentLinkEmbedControl)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IComponentLinkEmbedControl)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IComponentLinkEmbedControl, None)

    _get_reference_type_metadata = { "offset" : _get_reference_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ComponentLinkEmbedControlReferenceType),) }
    @property
    def reference_type(self) -> "ComponentLinkEmbedControlReferenceType":
        """Get or set the component reference type."""
        return self._intf.get_property(IComponentLinkEmbedControl._metadata, IComponentLinkEmbedControl._get_reference_type_metadata)

    _set_reference_type_metadata = { "offset" : _set_reference_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(ComponentLinkEmbedControlReferenceType),) }
    @reference_type.setter
    def reference_type(self, value:"ComponentLinkEmbedControlReferenceType") -> None:
        return self._intf.set_property(IComponentLinkEmbedControl._metadata, IComponentLinkEmbedControl._set_reference_type_metadata, value)

    _get_component_metadata = { "offset" : _get_component_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def component(self) -> "IComponentInfo":
        """Get the component interface."""
        return self._intf.get_property(IComponentLinkEmbedControl._metadata, IComponentLinkEmbedControl._get_component_metadata)

    _get_supported_components_metadata = { "offset" : _get_supported_components_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def supported_components(self) -> list:
        """Get the list of supported component names."""
        return self._intf.get_property(IComponentLinkEmbedControl._metadata, IComponentLinkEmbedControl._get_supported_components_metadata)

    _set_component_metadata = { "offset" : _set_component_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    def set_component(self, component_name:str) -> None:
        """Set the component by name."""
        return self._intf.invoke(IComponentLinkEmbedControl._metadata, IComponentLinkEmbedControl._set_component_metadata, component_name)

    _property_names[reference_type] = "reference_type"
    _property_names[component] = "component"
    _property_names[supported_components] = "supported_components"


agcls.AgClassCatalog.add_catalog_entry((5602718486014656526, 8140965578869473943), IComponentLinkEmbedControl)
agcls.AgTypeNameMap["IComponentLinkEmbedControl"] = IComponentLinkEmbedControl

class IDisplayTimesData(object):
    """Base Interface IDisplayTimesData. TimeIntervalCollection, DisplayTimesDuringAccess and DisplayTimesTimeComponent derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5237363789436860483, 10153003140195176627),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDisplayTimesData."""
        initialize_from_source_object(self, source_object, IDisplayTimesData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDisplayTimesData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDisplayTimesData, None)



agcls.AgClassCatalog.add_catalog_entry((5237363789436860483, 10153003140195176627), IDisplayTimesData)
agcls.AgTypeNameMap["IDisplayTimesData"] = IDisplayTimesData

class IDisplayTime(object):
    """The display time interface."""

    _num_methods = 5
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_display_status_type_method_offset = 1
    _set_display_status_type_method_offset = 2
    _is_display_status_type_supported_method_offset = 3
    _get_display_status_supported_types_method_offset = 4
    _get_display_times_data_method_offset = 5
    _metadata = {
        "iid_data" : (4985255360035361613, 2214963519927515811),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDisplayTime."""
        initialize_from_source_object(self, source_object, IDisplayTime)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDisplayTime)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDisplayTime, None)

    _get_display_status_type_metadata = { "offset" : _get_display_status_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(DisplayTimesType),) }
    @property
    def display_status_type(self) -> "DisplayTimesType":
        """Return the Display Status type."""
        return self._intf.get_property(IDisplayTime._metadata, IDisplayTime._get_display_status_type_metadata)

    _set_display_status_type_metadata = { "offset" : _set_display_status_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(DisplayTimesType),) }
    def set_display_status_type(self, display_status:"DisplayTimesType") -> None:
        """Set the display status type."""
        return self._intf.invoke(IDisplayTime._metadata, IDisplayTime._set_display_status_type_metadata, display_status)

    _is_display_status_type_supported_metadata = { "offset" : _is_display_status_type_supported_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(DisplayTimesType), agmarshall.VariantBoolArg,) }
    def is_display_status_type_supported(self, display_status:"DisplayTimesType") -> bool:
        """Get a value indicating whether the specified type can be used."""
        return self._intf.invoke(IDisplayTime._metadata, IDisplayTime._is_display_status_type_supported_metadata, display_status, OutArg())

    _get_display_status_supported_types_metadata = { "offset" : _get_display_status_supported_types_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def display_status_supported_types(self) -> list:
        """Return an array of valid choices."""
        return self._intf.get_property(IDisplayTime._metadata, IDisplayTime._get_display_status_supported_types_metadata)

    _get_display_times_data_metadata = { "offset" : _get_display_times_data_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def display_times_data(self) -> "IDisplayTimesData":
        """Return the display times data."""
        return self._intf.get_property(IDisplayTime._metadata, IDisplayTime._get_display_times_data_metadata)

    _property_names[display_status_type] = "display_status_type"
    _property_names[display_status_supported_types] = "display_status_supported_types"
    _property_names[display_times_data] = "display_times_data"


agcls.AgClassCatalog.add_catalog_entry((4985255360035361613, 2214963519927515811), IDisplayTime)
agcls.AgTypeNameMap["IDisplayTime"] = IDisplayTime

class ITerrainNormData(object):
    """Base Interface ITerrainNormData. TerrainNormalSlopeAzimuth derives from this interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4710761608362925757, 5921492890169715082),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ITerrainNormData."""
        initialize_from_source_object(self, source_object, ITerrainNormData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ITerrainNormData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ITerrainNormData, None)



agcls.AgClassCatalog.add_catalog_entry((4710761608362925757, 5921492890169715082), ITerrainNormData)
agcls.AgTypeNameMap["ITerrainNormData"] = ITerrainNormData

class ILifetimeInformation(object):
    """Provide the information about the lifetime of the object."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_has_been_deleted_method_offset = 1
    _metadata = {
        "iid_data" : (5322228758688290418, 11325260168605084063),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ILifetimeInformation."""
        initialize_from_source_object(self, source_object, ILifetimeInformation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ILifetimeInformation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ILifetimeInformation, None)

    _get_has_been_deleted_metadata = { "offset" : _get_has_been_deleted_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def has_been_deleted(self) -> bool:
        """Determine if the object has been deleted or has become invalid due to some other modifications to its internal state."""
        return self._intf.get_property(ILifetimeInformation._metadata, ILifetimeInformation._get_has_been_deleted_metadata)

    _property_names[has_been_deleted] = "has_been_deleted"


agcls.AgClassCatalog.add_catalog_entry((5322228758688290418, 11325260168605084063), ILifetimeInformation)
agcls.AgTypeNameMap["ILifetimeInformation"] = ILifetimeInformation

class IVehicleLeadTrailData(object):
    """Base interface IVehicleLeadTrailData."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5133290017253705720, 1818322219394130334),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleLeadTrailData."""
        initialize_from_source_object(self, source_object, IVehicleLeadTrailData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleLeadTrailData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleLeadTrailData, None)



agcls.AgClassCatalog.add_catalog_entry((5133290017253705720, 1818322219394130334), IVehicleLeadTrailData)
agcls.AgTypeNameMap["IVehicleLeadTrailData"] = IVehicleLeadTrailData

class IVehicleLeadTrailDataFraction(object):
    """The percentage of the leading or trailing portion of a vehicle's path that will display in the 2D or 3D window."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_fraction_method_offset = 1
    _set_fraction_method_offset = 2
    _metadata = {
        "iid_data" : (5228725570332796246, 5815275610829201051),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleLeadTrailDataFraction."""
        initialize_from_source_object(self, source_object, IVehicleLeadTrailDataFraction)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleLeadTrailDataFraction)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleLeadTrailDataFraction, None)

    _get_fraction_metadata = { "offset" : _get_fraction_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def fraction(self) -> float:
        """Fraction of single leading or trailing vehicle pass to display. Dimensionless."""
        return self._intf.get_property(IVehicleLeadTrailDataFraction._metadata, IVehicleLeadTrailDataFraction._get_fraction_metadata)

    _set_fraction_metadata = { "offset" : _set_fraction_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @fraction.setter
    def fraction(self, value:float) -> None:
        return self._intf.set_property(IVehicleLeadTrailDataFraction._metadata, IVehicleLeadTrailDataFraction._set_fraction_metadata, value)

    _property_names[fraction] = "fraction"


agcls.AgClassCatalog.add_catalog_entry((5228725570332796246, 5815275610829201051), IVehicleLeadTrailDataFraction)
agcls.AgTypeNameMap["IVehicleLeadTrailDataFraction"] = IVehicleLeadTrailDataFraction

class IVehicleLeadTrailDataTime(object):
    """Configure the amount of time to display the vehicle's path in 2D or 3D window."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_time_method_offset = 1
    _set_time_method_offset = 2
    _metadata = {
        "iid_data" : (5543876989805598204, 12572793620716963986),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleLeadTrailDataTime."""
        initialize_from_source_object(self, source_object, IVehicleLeadTrailDataTime)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleLeadTrailDataTime)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleLeadTrailDataTime, None)

    _get_time_metadata = { "offset" : _get_time_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def time(self) -> float:
        """Amount of leading or trailing vehicle pass to display, in terms of time required to traverse it. Uses Time Dimension."""
        return self._intf.get_property(IVehicleLeadTrailDataTime._metadata, IVehicleLeadTrailDataTime._get_time_metadata)

    _set_time_metadata = { "offset" : _set_time_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @time.setter
    def time(self, value:float) -> None:
        return self._intf.set_property(IVehicleLeadTrailDataTime._metadata, IVehicleLeadTrailDataTime._set_time_metadata, value)

    _property_names[time] = "time"


agcls.AgClassCatalog.add_catalog_entry((5543876989805598204, 12572793620716963986), IVehicleLeadTrailDataTime)
agcls.AgTypeNameMap["IVehicleLeadTrailDataTime"] = IVehicleLeadTrailDataTime

class IAccessConstraint(object):
    """
    AccessConstraint used to access the AccessConstraint attributes.

    Examples
    --------
    Get access between objects by path using the existing accesses:
    >>> # STKObjectRoot root: STK Object Model root
    >>> scenario = root.current_scenario
    >>> accesses = scenario.get_existing_accesses()
    >>>
    >>> size = len(accesses)  # number of accesses
    >>>
    >>> object1 = accesses[0][0]  # e.g. "Satellite/MySatellite"
    >>> object2 = accesses[0][1]  # e.g.  "Facility/MyFacility"
    >>> computed = accesses[0][2]  # e.g. True  (if access has been computed)
    >>>
    >>> access = scenario.get_access_between_objects_by_path(object1, object2)

    Configure the access interval to the availability time span of the object where access is being computed to:
    >>> # STKObjectRoot root: STK Object Model root
    >>>
    >>> satellite = root.get_object_from_path("Satellite/MySatellite")
    >>> facility = root.get_object_from_path("Facility/MyFacility")
    >>> access = satellite.get_access_to_object(facility)
    >>>
    >>> access.access_time_period = AccessTimeType.SPECIFIED_TIME_PERIOD
    >>> accessTimePeriod = access.access_time_period_data
    >>>
    >>> if satellite.analysis_workbench_components.time_intervals.contains("AvailabilityTimeSpan"):
    >>>     availabilityTimeSpan = satellite.analysis_workbench_components.time_intervals.item("AvailabilityTimeSpan")
    >>>     accessTimePeriod.access_interval.set_implicit_interval(availabilityTimeSpan)

    Remove all access constraints except for Line Of Sight:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>> for i in range(accessConstraints.count - 1, 0, -1):
    >>>     constraint = accessConstraints.Item(i).ConstraintName
    >>>
    >>>     if (constraint == "LineOfSight") is False:
    >>>         if constraint == "ThirdBodyObstruction":
    >>>             thirdBodyConstraint = accessConstraints.GetActiveNamedConstraint("ThirdBodyObstruction")
    >>>             assignedArray = thirdBodyConstraint.AssignedObstructions
    >>>
    >>>             for j in range(0, len(assignedArray)):
    >>>                 thirdBodyConstraint.RemoveObstruction(assignedArray[j])
    >>>
    >>>         elif constraint == "ExclusionZone":
    >>>             accessConstraints.GetActiveNamedConstraint("ExclusionZone").RemoveAll()
    >>>
    >>>         else:
    >>>             accessConstraints.RemoveNamedConstraint(constraint)

    Add an Exclusion Zone access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>> excludeZone = accessConstraints.add_named_constraint("ExclusionZone")
    >>> excludeZone.maximum_latitude = 45
    >>> excludeZone.minimum_latitude = 15
    >>> excludeZone.minimum_longitude = -75
    >>> excludeZone.maximum_longitude = -35

    Add multiple access constraints of the same type to an STK Object:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>>
    >>> # Add constraints
    >>> # Only the eCstrApparentTime (4), eCstrDuration (13), eCstrGMT (16), eCstrIntervals (22), eCstrLocalTime (27) constraint
    >>> # types can be added multiple times to the constraint collection.
    >>> time1 = accessConstraints.add_constraint(AccessConstraintType.LOCAL_TIME)
    >>> time1.minimum = "00:00:00.000"
    >>> time1.maximum = "23:00:00.000"

    Add and configure an altitude access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>>
    >>> # To make this more efficient, wrap this method between calls to root.BeginUpdate() and root.EndUpdate()
    >>> # Attitude constraint
    >>> altitude = accessConstraints.add_constraint(AccessConstraintType.ALTITUDE)
    >>> altitude.enable_minimum = True
    >>> altitude.minimum = 20.5  # km

    Add and configure a central body obstruction access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>> # Get IAgAccessCnstrCbObstruction interface
    >>> cbObstrConstraint = accessConstraints.add_constraint(AccessConstraintType.CENTRAL_BODY_OBSTRUCTION)
    >>>
    >>> # AvailableObstructions returns a one dimensional array of obstruction paths
    >>> availableArray = cbObstrConstraint.available_obstructions
    >>>
    >>> # In this example add all available obstructions
    >>> print("Available obstructions")
    >>> for i in range(0, len(availableArray)):
    >>>     print(availableArray[i])
    >>>     if availableArray[i] != "Sun":  # Sun is enabled by default
    >>>         cbObstrConstraint.add_obstruction(availableArray[i])
    >>>
    >>> # AssignedObstructions returns a one dimensional array of obstruction paths
    >>> assignedArray = cbObstrConstraint.assigned_obstructions
    >>>
    >>> print("Assigned obstructions")
    >>> for i in range(0, len(assignedArray)):
    >>>     print(assignedArray[i])

    Add and configure a sun elevation angle access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>>
    >>> # To make this more efficient, wrap this method between calls to root.BeginUpdate() and root.EndUpdate()
    >>> minmax = accessConstraints.add_constraint(AccessConstraintType.SUN_ELEVATION_ANGLE)
    >>> minmax.enable_minimum = True
    >>> minmax.minimum = 22.2
    >>> minmax.enable_maximum = True
    >>> minmax.maximum = 77.7

    Add and configure a lunar elevation angle access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>>
    >>> # To make this more efficient, wrap this method between calls to root.BeginUpdate() and root.EndUpdate()
    >>> minmax = accessConstraints.add_constraint(AccessConstraintType.LUNAR_ELEVATION_ANGLE)
    >>> minmax.enable_minimum = True
    >>> minmax.minimum = 11.1
    >>> minmax.enable_maximum = True
    >>> minmax.maximum = 88.8

    Add and configure a Line Of Sight sun exclusion access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>>
    >>> # Angle constraint
    >>> cnstrAngle = accessConstraints.add_constraint(AccessConstraintType.LIGHT_OF_SIGHT_SOLAR_EXCLUSION_ANGLE)
    >>> cnstrAngle.angle = 176.0

    Add and configure a lighting condition access constraint:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>>
    >>> # Condition constraint
    >>> light = accessConstraints.add_constraint(AccessConstraintType.LIGHTING)
    >>> light.condition = ConstraintLighting.DIRECT_SUN

    Return a list of available constraints:
    >>> # AccessConstraintCollection accessConstraints: Access Constraint collection
    >>> constraintArray = accessConstraints.available_constraints()
    >>>
    >>> print("List of Available Constraints:")
    >>> for i in range(0, len(constraintArray)):
    >>>     print(constraintArray[i])
    """

    _num_methods = 9
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_constraint_name_method_offset = 1
    _get_is_plugin_method_offset = 2
    _get_exclusion_interval_method_offset = 3
    _set_exclusion_interval_method_offset = 4
    _get_constraint_type_method_offset = 5
    _get_maximum_time_step_method_offset = 6
    _set_maximum_time_step_method_offset = 7
    _get_maximum_relative_motion_method_offset = 8
    _set_maximum_relative_motion_method_offset = 9
    _metadata = {
        "iid_data" : (5475738984353902352, 14451817793207909765),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAccessConstraint."""
        initialize_from_source_object(self, source_object, IAccessConstraint)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAccessConstraint)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAccessConstraint, None)

    _get_constraint_name_metadata = { "offset" : _get_constraint_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def constraint_name(self) -> str:
        """Property used to access the constraint name."""
        return self._intf.get_property(IAccessConstraint._metadata, IAccessConstraint._get_constraint_name_metadata)

    _get_is_plugin_metadata = { "offset" : _get_is_plugin_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def is_plugin(self) -> bool:
        """Return true if the access constraint is a plugin."""
        return self._intf.get_property(IAccessConstraint._metadata, IAccessConstraint._get_is_plugin_metadata)

    _get_exclusion_interval_metadata = { "offset" : _get_exclusion_interval_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def exclusion_interval(self) -> bool:
        """Exclude Time Intervals."""
        return self._intf.get_property(IAccessConstraint._metadata, IAccessConstraint._get_exclusion_interval_metadata)

    _set_exclusion_interval_metadata = { "offset" : _set_exclusion_interval_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @exclusion_interval.setter
    def exclusion_interval(self, excl:bool) -> None:
        return self._intf.set_property(IAccessConstraint._metadata, IAccessConstraint._set_exclusion_interval_metadata, excl)

    _get_constraint_type_metadata = { "offset" : _get_constraint_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AccessConstraintType),) }
    @property
    def constraint_type(self) -> "AccessConstraintType":
        """Property used to access the constraint type."""
        return self._intf.get_property(IAccessConstraint._metadata, IAccessConstraint._get_constraint_type_metadata)

    _get_maximum_time_step_metadata = { "offset" : _get_maximum_time_step_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def maximum_time_step(self) -> float:
        """Maximum time step used in adaptive sampling."""
        return self._intf.get_property(IAccessConstraint._metadata, IAccessConstraint._get_maximum_time_step_metadata)

    _set_maximum_time_step_metadata = { "offset" : _set_maximum_time_step_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @maximum_time_step.setter
    def maximum_time_step(self, value:float) -> None:
        return self._intf.set_property(IAccessConstraint._metadata, IAccessConstraint._set_maximum_time_step_metadata, value)

    _get_maximum_relative_motion_metadata = { "offset" : _get_maximum_relative_motion_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def maximum_relative_motion(self) -> float:
        """Maximum relative motion used in adaptive sampling."""
        return self._intf.get_property(IAccessConstraint._metadata, IAccessConstraint._get_maximum_relative_motion_metadata)

    _set_maximum_relative_motion_metadata = { "offset" : _set_maximum_relative_motion_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @maximum_relative_motion.setter
    def maximum_relative_motion(self, value:float) -> None:
        return self._intf.set_property(IAccessConstraint._metadata, IAccessConstraint._set_maximum_relative_motion_metadata, value)

    _property_names[constraint_name] = "constraint_name"
    _property_names[is_plugin] = "is_plugin"
    _property_names[exclusion_interval] = "exclusion_interval"
    _property_names[constraint_type] = "constraint_type"
    _property_names[maximum_time_step] = "maximum_time_step"
    _property_names[maximum_relative_motion] = "maximum_relative_motion"


agcls.AgClassCatalog.add_catalog_entry((5475738984353902352, 14451817793207909765), IAccessConstraint)
agcls.AgTypeNameMap["IAccessConstraint"] = IAccessConstraint

class IAccessConstraintMinMaxBase(IAccessConstraint):
    """Access Constraint used for min/max constraints."""

    _num_methods = 8
    _vtable_offset = IAccessConstraint._vtable_offset + IAccessConstraint._num_methods
    _get_enable_minimum_method_offset = 1
    _set_enable_minimum_method_offset = 2
    _get_enable_maximum_method_offset = 3
    _set_enable_maximum_method_offset = 4
    _get_minimum_method_offset = 5
    _set_minimum_method_offset = 6
    _get_maximum_method_offset = 7
    _set_maximum_method_offset = 8
    _metadata = {
        "iid_data" : (5169408938295385610, 3074927429574054843),
        "vtable_reference" : IAccessConstraint._vtable_offset + IAccessConstraint._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAccessConstraintMinMaxBase."""
        initialize_from_source_object(self, source_object, IAccessConstraintMinMaxBase)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
        IAccessConstraint._private_init(self, intf)
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAccessConstraintMinMaxBase)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAccessConstraintMinMaxBase, IAccessConstraint)

    _get_enable_minimum_metadata = { "offset" : _get_enable_minimum_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_minimum(self) -> bool:
        """Enable the Min property."""
        return self._intf.get_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._get_enable_minimum_metadata)

    _set_enable_minimum_metadata = { "offset" : _set_enable_minimum_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_minimum.setter
    def enable_minimum(self, value:bool) -> None:
        return self._intf.set_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._set_enable_minimum_metadata, value)

    _get_enable_maximum_metadata = { "offset" : _get_enable_maximum_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_maximum(self) -> bool:
        """Enable the Max property."""
        return self._intf.get_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._get_enable_maximum_metadata)

    _set_enable_maximum_metadata = { "offset" : _set_enable_maximum_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_maximum.setter
    def enable_maximum(self, value:bool) -> None:
        return self._intf.set_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._set_enable_maximum_metadata, value)

    _get_minimum_metadata = { "offset" : _get_minimum_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def minimum(self) -> typing.Any:
        """Min value for the access constraint."""
        return self._intf.get_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._get_minimum_metadata)

    _set_minimum_metadata = { "offset" : _set_minimum_method_offset,
            "arg_types" : (agcom.Variant,),
            "marshallers" : (agmarshall.VariantArg,) }
    @minimum.setter
    def minimum(self, value:typing.Any) -> None:
        return self._intf.set_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._set_minimum_metadata, value)

    _get_maximum_metadata = { "offset" : _get_maximum_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def maximum(self) -> typing.Any:
        """Max value for the access constrain."""
        return self._intf.get_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._get_maximum_metadata)

    _set_maximum_metadata = { "offset" : _set_maximum_method_offset,
            "arg_types" : (agcom.Variant,),
            "marshallers" : (agmarshall.VariantArg,) }
    @maximum.setter
    def maximum(self, value:typing.Any) -> None:
        return self._intf.set_property(IAccessConstraintMinMaxBase._metadata, IAccessConstraintMinMaxBase._set_maximum_metadata, value)

    _property_names[enable_minimum] = "enable_minimum"
    _property_names[enable_maximum] = "enable_maximum"
    _property_names[minimum] = "minimum"
    _property_names[maximum] = "maximum"


agcls.AgClassCatalog.add_catalog_entry((5169408938295385610, 3074927429574054843), IAccessConstraintMinMaxBase)
agcls.AgTypeNameMap["IAccessConstraintMinMaxBase"] = IAccessConstraintMinMaxBase

class IGraphics3DMarkerData(object):
    """Base Interface IGraphics3DMarkerData."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4717643828216549729, 6823134375722684837),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGraphics3DMarkerData."""
        initialize_from_source_object(self, source_object, IGraphics3DMarkerData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGraphics3DMarkerData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGraphics3DMarkerData, None)



agcls.AgClassCatalog.add_catalog_entry((4717643828216549729, 6823134375722684837), IGraphics3DMarkerData)
agcls.AgTypeNameMap["IGraphics3DMarkerData"] = IGraphics3DMarkerData

class IGraphics3DModelData(object):
    """IGraphics3DModelData base interface. IGraphics3DModelFile and Graphics3DModelCollection derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4666640754645996290, 15571154125827486100),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGraphics3DModelData."""
        initialize_from_source_object(self, source_object, IGraphics3DModelData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGraphics3DModelData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGraphics3DModelData, None)



agcls.AgClassCatalog.add_catalog_entry((4666640754645996290, 15571154125827486100), IGraphics3DModelData)
agcls.AgTypeNameMap["IGraphics3DModelData"] = IGraphics3DModelData

class IGraphics3DModel(object):
    """IGraphics3DModel used to access the 3D model attributes."""

    _num_methods = 9
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_visible_method_offset = 1
    _set_visible_method_offset = 2
    _get_scale_value_method_offset = 3
    _set_scale_value_method_offset = 4
    _get_detail_threshold_method_offset = 5
    _get_model_data_method_offset = 6
    _get_model_type_method_offset = 7
    _set_model_type_method_offset = 8
    _get_articulation_method_offset = 9
    _metadata = {
        "iid_data" : (5018649763518820411, 5200106272048187566),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGraphics3DModel."""
        initialize_from_source_object(self, source_object, IGraphics3DModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGraphics3DModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGraphics3DModel, None)

    _get_visible_metadata = { "offset" : _get_visible_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def visible(self) -> bool:
        """Display one or several models in the 3D Graphics window."""
        return self._intf.get_property(IGraphics3DModel._metadata, IGraphics3DModel._get_visible_metadata)

    _set_visible_metadata = { "offset" : _set_visible_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @visible.setter
    def visible(self, show:bool) -> None:
        return self._intf.set_property(IGraphics3DModel._metadata, IGraphics3DModel._set_visible_metadata, show)

    _get_scale_value_metadata = { "offset" : _get_scale_value_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def scale_value(self) -> float:
        """Specify the absolute scaling value for the object. The model scale is an exponential scale. Dimensionless."""
        return self._intf.get_property(IGraphics3DModel._metadata, IGraphics3DModel._get_scale_value_metadata)

    _set_scale_value_metadata = { "offset" : _set_scale_value_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @scale_value.setter
    def scale_value(self, scale:float) -> None:
        return self._intf.set_property(IGraphics3DModel._metadata, IGraphics3DModel._set_scale_value_metadata, scale)

    _get_detail_threshold_metadata = { "offset" : _get_detail_threshold_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def detail_threshold(self) -> "Graphics3DDetailThreshold":
        """Get the detail threshold attributes."""
        return self._intf.get_property(IGraphics3DModel._metadata, IGraphics3DModel._get_detail_threshold_metadata)

    _get_model_data_metadata = { "offset" : _get_model_data_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def model_data(self) -> "IGraphics3DModelData":
        """Get the model data property."""
        return self._intf.get_property(IGraphics3DModel._metadata, IGraphics3DModel._get_model_data_metadata)

    _get_model_type_metadata = { "offset" : _get_model_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ModelType),) }
    @property
    def model_type(self) -> "ModelType":
        """Get or set the model type property. A member of the ModelType enumeration."""
        return self._intf.get_property(IGraphics3DModel._metadata, IGraphics3DModel._get_model_type_metadata)

    _set_model_type_metadata = { "offset" : _set_model_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(ModelType),) }
    @model_type.setter
    def model_type(self, type:"ModelType") -> None:
        return self._intf.set_property(IGraphics3DModel._metadata, IGraphics3DModel._set_model_type_metadata, type)

    _get_articulation_metadata = { "offset" : _get_articulation_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def articulation(self) -> "Graphics3DModelArticulation":
        """Articulation property."""
        return self._intf.get_property(IGraphics3DModel._metadata, IGraphics3DModel._get_articulation_metadata)

    _property_names[visible] = "visible"
    _property_names[scale_value] = "scale_value"
    _property_names[detail_threshold] = "detail_threshold"
    _property_names[model_data] = "model_data"
    _property_names[model_type] = "model_type"
    _property_names[articulation] = "articulation"


agcls.AgClassCatalog.add_catalog_entry((5018649763518820411, 5200106272048187566), IGraphics3DModel)
agcls.AgTypeNameMap["IGraphics3DModel"] = IGraphics3DModel

class IGraphics3DReferenceAnalysisWorkbenchComponent(object):
    """IGraphics3DReferenceAnalysisWorkbenchComponent used to access the shared properties of all 3D RefCrdn."""

    _num_methods = 8
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_identifier_method_offset = 1
    _get_name_method_offset = 2
    _get_visible_method_offset = 3
    _set_visible_method_offset = 4
    _get_color_method_offset = 5
    _set_color_method_offset = 6
    _get_show_label_method_offset = 7
    _set_show_label_method_offset = 8
    _metadata = {
        "iid_data" : (5071062409309917739, 11212184571157187722),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGraphics3DReferenceAnalysisWorkbenchComponent."""
        initialize_from_source_object(self, source_object, IGraphics3DReferenceAnalysisWorkbenchComponent)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGraphics3DReferenceAnalysisWorkbenchComponent)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGraphics3DReferenceAnalysisWorkbenchComponent, None)

    _get_type_identifier_metadata = { "offset" : _get_type_identifier_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(GeometricElementType),) }
    @property
    def type_identifier(self) -> "GeometricElementType":
        """Type of component (vector, axes, angle, plane, point). A member of the GeometricElementType enumeration."""
        return self._intf.get_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._get_type_identifier_metadata)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the name of the component."""
        return self._intf.get_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._get_name_metadata)

    _get_visible_metadata = { "offset" : _get_visible_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def visible(self) -> bool:
        """Whether component is visible."""
        return self._intf.get_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._get_visible_metadata)

    _set_visible_metadata = { "offset" : _set_visible_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @visible.setter
    def visible(self, visible:bool) -> None:
        return self._intf.set_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._set_visible_metadata, visible)

    _get_color_metadata = { "offset" : _get_color_method_offset,
            "arg_types" : (POINTER(agcom.OLE_COLOR),),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @property
    def color(self) -> agcolor.Color:
        """Color of the component."""
        return self._intf.get_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._get_color_metadata)

    _set_color_metadata = { "offset" : _set_color_method_offset,
            "arg_types" : (agcom.OLE_COLOR,),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @color.setter
    def color(self, visible:agcolor.Color) -> None:
        return self._intf.set_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._set_color_metadata, visible)

    _get_show_label_metadata = { "offset" : _get_show_label_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_label(self) -> bool:
        """Is the label for the component visible?"""
        return self._intf.get_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._get_show_label_metadata)

    _set_show_label_metadata = { "offset" : _set_show_label_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_label.setter
    def show_label(self, value:bool) -> None:
        return self._intf.set_property(IGraphics3DReferenceAnalysisWorkbenchComponent._metadata, IGraphics3DReferenceAnalysisWorkbenchComponent._set_show_label_metadata, value)

    _property_names[type_identifier] = "type_identifier"
    _property_names[name] = "name"
    _property_names[visible] = "visible"
    _property_names[color] = "color"
    _property_names[show_label] = "show_label"


agcls.AgClassCatalog.add_catalog_entry((5071062409309917739, 11212184571157187722), IGraphics3DReferenceAnalysisWorkbenchComponent)
agcls.AgTypeNameMap["IGraphics3DReferenceAnalysisWorkbenchComponent"] = IGraphics3DReferenceAnalysisWorkbenchComponent

class ILatitudeLongitudeAltitudePosition(object):
    """Interface to set and retrieve the LLA position type."""

    _num_methods = 5
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _convert_to_method_offset = 1
    _get_type_method_offset = 2
    _assign_method_offset = 3
    _assign_centric_method_offset = 4
    _assign_detic_method_offset = 5
    _metadata = {
        "iid_data" : (4938339597828829007, 10893460557548459451),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ILatitudeLongitudeAltitudePosition."""
        initialize_from_source_object(self, source_object, ILatitudeLongitudeAltitudePosition)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ILatitudeLongitudeAltitudePosition)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ILatitudeLongitudeAltitudePosition, None)

    _convert_to_metadata = { "offset" : _convert_to_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.EnumArg(DeticPositionType), agmarshall.InterfaceOutArg,) }
    def convert_to(self, type:"DeticPositionType") -> "ILatitudeLongitudeAltitudePosition":
        """Change the position representation."""
        return self._intf.invoke(ILatitudeLongitudeAltitudePosition._metadata, ILatitudeLongitudeAltitudePosition._convert_to_metadata, type, OutArg())

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(DeticPositionType),) }
    @property
    def type(self) -> "DeticPositionType":
        """Return the position type currently being used."""
        return self._intf.get_property(ILatitudeLongitudeAltitudePosition._metadata, ILatitudeLongitudeAltitudePosition._get_type_metadata)

    _assign_metadata = { "offset" : _assign_method_offset,
            "arg_types" : (agcom.PVOID,),
            "marshallers" : (agmarshall.InterfaceInArg("ILatitudeLongitudeAltitudePosition"),) }
    def assign(self, pos:"ILatitudeLongitudeAltitudePosition") -> None:
        """Assign a new position."""
        return self._intf.invoke(ILatitudeLongitudeAltitudePosition._metadata, ILatitudeLongitudeAltitudePosition._assign_metadata, pos)

    _assign_centric_metadata = { "offset" : _assign_centric_method_offset,
            "arg_types" : (agcom.DOUBLE, agcom.DOUBLE, agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg, agmarshall.DoubleArg, agmarshall.DoubleArg,) }
    def assign_centric(self, lat:float, lon:float, rad:float) -> None:
        """Assign the position using geocentric representation. Lat uses Latitude Dimension. Lon Uses Longitude Dimension. Rad uses Distance Dimension."""
        return self._intf.invoke(ILatitudeLongitudeAltitudePosition._metadata, ILatitudeLongitudeAltitudePosition._assign_centric_metadata, lat, lon, rad)

    _assign_detic_metadata = { "offset" : _assign_detic_method_offset,
            "arg_types" : (agcom.DOUBLE, agcom.DOUBLE, agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg, agmarshall.DoubleArg, agmarshall.DoubleArg,) }
    def assign_detic(self, lat:float, lon:float, alt:float) -> None:
        """Assign the position using geodetic representation.  Lat uses Latitude Dimension. Lon Uses Longitude Dimension. Alt uses Distance Dimension."""
        return self._intf.invoke(ILatitudeLongitudeAltitudePosition._metadata, ILatitudeLongitudeAltitudePosition._assign_detic_metadata, lat, lon, alt)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4938339597828829007, 10893460557548459451), ILatitudeLongitudeAltitudePosition)
agcls.AgTypeNameMap["ILatitudeLongitudeAltitudePosition"] = ILatitudeLongitudeAltitudePosition

class IClassicalSizeShape(object):
    """Base Interface for SizeShape property. ClassicalSizeShapeAltitude, ClassicalSizeShapeMeanMotion, ClassicalSizeShapePeriod, IClassicalSizeShapeRadius and ClassicalSizeShapeSemimajorAxis derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4730643798439028108, 12397902977405054860),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IClassicalSizeShape."""
        initialize_from_source_object(self, source_object, IClassicalSizeShape)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IClassicalSizeShape)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IClassicalSizeShape, None)



agcls.AgClassCatalog.add_catalog_entry((4730643798439028108, 12397902977405054860), IClassicalSizeShape)
agcls.AgTypeNameMap["IClassicalSizeShape"] = IClassicalSizeShape

class IOrientationAscNode(object):
    """Base Interface to OrientationLongitudeOfAscending and OrientationRightAscensionOfAscendingNode."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5241219906470719617, 6656593870488189359),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IOrientationAscNode."""
        initialize_from_source_object(self, source_object, IOrientationAscNode)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IOrientationAscNode)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IOrientationAscNode, None)



agcls.AgClassCatalog.add_catalog_entry((5241219906470719617, 6656593870488189359), IOrientationAscNode)
agcls.AgTypeNameMap["IOrientationAscNode"] = IOrientationAscNode

class IClassicalLocation(object):
    """Base Interface of all IClassicalLocation* interfaces."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5574855203244913327, 960360588506921877),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IClassicalLocation."""
        initialize_from_source_object(self, source_object, IClassicalLocation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IClassicalLocation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IClassicalLocation, None)



agcls.AgClassCatalog.add_catalog_entry((5574855203244913327, 960360588506921877), IClassicalLocation)
agcls.AgTypeNameMap["IClassicalLocation"] = IClassicalLocation

class IGeodeticSize(object):
    """Base Interface IGeodeticSize. DeticSizeAltitude and DeticSizeRadius derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4669588592286829500, 12590540741910118846),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGeodeticSize."""
        initialize_from_source_object(self, source_object, IGeodeticSize)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGeodeticSize)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGeodeticSize, None)



agcls.AgClassCatalog.add_catalog_entry((4669588592286829500, 12590540741910118846), IGeodeticSize)
agcls.AgTypeNameMap["IGeodeticSize"] = IGeodeticSize

class IDelaunayActionVariable(object):
    """Interface for Delaunay Variable L, which is related to the two-body orbital energy."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5170299042433857379, 18005220533706112395),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDelaunayActionVariable."""
        initialize_from_source_object(self, source_object, IDelaunayActionVariable)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDelaunayActionVariable)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDelaunayActionVariable, None)



agcls.AgClassCatalog.add_catalog_entry((5170299042433857379, 18005220533706112395), IDelaunayActionVariable)
agcls.AgTypeNameMap["IDelaunayActionVariable"] = IDelaunayActionVariable

class IFlightPathAngle(object):
    """Base Interface IFlightPathAngle. MixedSphericalFlightPathAngleHorizontal, MixedSphericalFlightPathAngleVertical, SphericalFlightPathAngleHorizontal and SphericalFlightPathAngleVertical derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5260724130063239265, 3447438162362475703),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IFlightPathAngle."""
        initialize_from_source_object(self, source_object, IFlightPathAngle)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IFlightPathAngle)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IFlightPathAngle, None)



agcls.AgClassCatalog.add_catalog_entry((5260724130063239265, 3447438162362475703), IFlightPathAngle)
agcls.AgTypeNameMap["IFlightPathAngle"] = IFlightPathAngle

class IProvideSpatialInfo(object):
    """Provide methods for accessing spatial information for an object."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_spatial_information_method_offset = 1
    _metadata = {
        "iid_data" : (5519258181714874179, 17068623591288616338),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IProvideSpatialInfo."""
        initialize_from_source_object(self, source_object, IProvideSpatialInfo)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IProvideSpatialInfo)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IProvideSpatialInfo, None)

    _get_spatial_information_metadata = { "offset" : _get_spatial_information_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.VariantBoolArg, agmarshall.InterfaceOutArg,) }
    def get_spatial_information(self, recycle:bool) -> "VehicleSpatialInformation":
        """Return the spatial information for an object."""
        return self._intf.invoke(IProvideSpatialInfo._metadata, IProvideSpatialInfo._get_spatial_information_metadata, recycle, OutArg())



agcls.AgClassCatalog.add_catalog_entry((5519258181714874179, 17068623591288616338), IProvideSpatialInfo)
agcls.AgTypeNameMap["IProvideSpatialInfo"] = IProvideSpatialInfo

class IRadarClutterMap(object):
    """Do not use this interface, as it is deprecated. This interface is no longer used and there is no alternative. Provides access to the properties and methods defining a radar clutter map."""

    _num_methods = 3
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_supported_models_method_offset = 1
    _set_model_method_offset = 2
    _get_model_method_offset = 3
    _metadata = {
        "iid_data" : (5222375290930092897, 12043255858453081752),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterMap."""
        initialize_from_source_object(self, source_object, IRadarClutterMap)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterMap)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterMap, None)

    _get_supported_models_metadata = { "offset" : _get_supported_models_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def supported_models(self) -> list:
        """Get an array of supported model names."""
        return self._intf.get_property(IRadarClutterMap._metadata, IRadarClutterMap._get_supported_models_metadata)

    _set_model_metadata = { "offset" : _set_model_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    def set_model(self, model_name:str) -> None:
        """Set the current clutter map model by name."""
        return self._intf.invoke(IRadarClutterMap._metadata, IRadarClutterMap._set_model_metadata, model_name)

    _get_model_metadata = { "offset" : _get_model_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def model(self) -> "IRadarClutterMapModel":
        """Get the current clutter map model."""
        return self._intf.get_property(IRadarClutterMap._metadata, IRadarClutterMap._get_model_metadata)

    _property_names[supported_models] = "supported_models"
    _property_names[model] = "model"


agcls.AgClassCatalog.add_catalog_entry((5222375290930092897, 12043255858453081752), IRadarClutterMap)
agcls.AgTypeNameMap["IRadarClutterMap"] = IRadarClutterMap

class ITimePeriod(object):
    """Provide methods and properties to configure start and stop times."""

    _num_methods = 4
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_start_time_method_offset = 1
    _get_stop_time_method_offset = 2
    _get_duration_method_offset = 3
    _set_duration_method_offset = 4
    _metadata = {
        "iid_data" : (5028400110984901840, 16655259043950189749),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ITimePeriod."""
        initialize_from_source_object(self, source_object, ITimePeriod)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ITimePeriod)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ITimePeriod, None)

    _get_start_time_metadata = { "offset" : _get_start_time_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def start_time(self) -> "TimePeriodValue":
        """Get a start time. Uses DateFormat Dimension."""
        return self._intf.get_property(ITimePeriod._metadata, ITimePeriod._get_start_time_metadata)

    _get_stop_time_metadata = { "offset" : _get_stop_time_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def stop_time(self) -> "TimePeriodValue":
        """Get a stop time. Uses DateFormat Dimension."""
        return self._intf.get_property(ITimePeriod._metadata, ITimePeriod._get_stop_time_metadata)

    _get_duration_metadata = { "offset" : _get_duration_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def duration(self) -> typing.Any:
        """A time duration. The value is a relative duration (i.e. ``+1 day``, ``+1 hour``)."""
        return self._intf.get_property(ITimePeriod._metadata, ITimePeriod._get_duration_metadata)

    _set_duration_metadata = { "offset" : _set_duration_method_offset,
            "arg_types" : (agcom.Variant,),
            "marshallers" : (agmarshall.VariantArg,) }
    @duration.setter
    def duration(self, duration:typing.Any) -> None:
        return self._intf.set_property(ITimePeriod._metadata, ITimePeriod._set_duration_metadata, duration)

    _property_names[start_time] = "start_time"
    _property_names[stop_time] = "stop_time"
    _property_names[duration] = "duration"


agcls.AgClassCatalog.add_catalog_entry((5028400110984901840, 16655259043950189749), ITimePeriod)
agcls.AgTypeNameMap["ITimePeriod"] = ITimePeriod

class ICelestialBodyInformation(object):
    """The interface represents information associated with a celestial body."""

    _num_methods = 11
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_identifier_method_offset = 1
    _get_catalog_name_method_offset = 2
    _get_right_ascension_method_offset = 3
    _get_declination_method_offset = 4
    _get_parallax_method_offset = 5
    _get_velocity_method_offset = 6
    _get_visual_magnitude_method_offset = 7
    _get_b_minus_v_method_offset = 8
    _get_effective_temperature_method_offset = 9
    _get_magnitude_to_irradiance_conversion_factor_method_offset = 10
    _get_last_computed_direction_in_icrf_method_offset = 11
    _metadata = {
        "iid_data" : (5316967365545587076, 5301002228354090117),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICelestialBodyInformation."""
        initialize_from_source_object(self, source_object, ICelestialBodyInformation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICelestialBodyInformation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICelestialBodyInformation, None)

    _get_identifier_metadata = { "offset" : _get_identifier_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def identifier(self) -> str:
        """Get the identification of the star as per star catalog."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_identifier_metadata)

    _get_catalog_name_metadata = { "offset" : _get_catalog_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def catalog_name(self) -> str:
        """Get a name of the star catalog."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_catalog_name_metadata)

    _get_right_ascension_metadata = { "offset" : _get_right_ascension_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def right_ascension(self) -> float:
        """Right ascention. Use the ``Angle`` dimension."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_right_ascension_metadata)

    _get_declination_metadata = { "offset" : _get_declination_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def declination(self) -> float:
        """Declination. Use the ``Angle`` dimension."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_declination_metadata)

    _get_parallax_metadata = { "offset" : _get_parallax_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def parallax(self) -> float:
        """Trigonometric parallax. Use the ``Angle`` dimension."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_parallax_metadata)

    _get_velocity_metadata = { "offset" : _get_velocity_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def velocity(self) -> float:
        """Radial velocity."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_velocity_metadata)

    _get_visual_magnitude_metadata = { "offset" : _get_visual_magnitude_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def visual_magnitude(self) -> float:
        """Visual magnitude."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_visual_magnitude_metadata)

    _get_b_minus_v_metadata = { "offset" : _get_b_minus_v_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def b_minus_v(self) -> float:
        """Johnson B-V color index."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_b_minus_v_metadata)

    _get_effective_temperature_metadata = { "offset" : _get_effective_temperature_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def effective_temperature(self) -> float:
        """Star's effective temperature. Use the ``Temperature`` dimension."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_effective_temperature_metadata)

    _get_magnitude_to_irradiance_conversion_factor_metadata = { "offset" : _get_magnitude_to_irradiance_conversion_factor_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def magnitude_to_irradiance_conversion_factor(self) -> float:
        """Magnitude to irradiance conversion factor is not given directly in any catalog. This factor converts the Planck function radiance to a rescaled irradiance at Earth's distance from the star. Unitless."""
        return self._intf.get_property(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_magnitude_to_irradiance_conversion_factor_metadata)

    _get_last_computed_direction_in_icrf_metadata = { "offset" : _get_last_computed_direction_in_icrf_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    def get_last_computed_direction_in_icrf(self) -> "ICartesian3Vector":
        """Return the last computed direction vector in ICRF."""
        return self._intf.invoke(ICelestialBodyInformation._metadata, ICelestialBodyInformation._get_last_computed_direction_in_icrf_metadata, OutArg())

    _property_names[identifier] = "identifier"
    _property_names[catalog_name] = "catalog_name"
    _property_names[right_ascension] = "right_ascension"
    _property_names[declination] = "declination"
    _property_names[parallax] = "parallax"
    _property_names[velocity] = "velocity"
    _property_names[visual_magnitude] = "visual_magnitude"
    _property_names[b_minus_v] = "b_minus_v"
    _property_names[effective_temperature] = "effective_temperature"
    _property_names[magnitude_to_irradiance_conversion_factor] = "magnitude_to_irradiance_conversion_factor"


agcls.AgClassCatalog.add_catalog_entry((5316967365545587076, 5301002228354090117), ICelestialBodyInformation)
agcls.AgTypeNameMap["ICelestialBodyInformation"] = ICelestialBodyInformation

class ICelestialBodyInformationCollection(object):
    """Represents a collection of celestial bodies."""

    _num_methods = 5
    _vtable_offset = IDispatch._vtable_offset + IDispatch._num_methods
    _get_count_method_offset = 1
    _item_method_offset = 2
    _get__new_enum_method_offset = 3
    _get_recycle_method_offset = 4
    _set_recycle_method_offset = 5
    _metadata = {
        "iid_data" : (4773543347010503356, 16742073454930722438),
        "vtable_reference" : IDispatch._vtable_offset + IDispatch._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICelestialBodyInformationCollection."""
        initialize_from_source_object(self, source_object, ICelestialBodyInformationCollection)
        self.__dict__["_enumerator"] = None
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICelestialBodyInformationCollection)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICelestialBodyInformationCollection, None)
    def __iter__(self):
        """Create an iterator for the ICelestialBodyInformationCollection object."""
        self.__dict__["_enumerator"] = self._new_enum
        self._enumerator.reset()
        return self
    def __next__(self) -> "ICelestialBodyInformation":
        """Return the next element in the collection."""
        if self._enumerator is None:
            raise StopIteration
        nextval = self._enumerator.next()
        if nextval is None:
            raise StopIteration
        return nextval

    _get_count_metadata = { "offset" : _get_count_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.LongArg,) }
    @property
    def count(self) -> int:
        """Return the number of elements in a collection."""
        return self._intf.get_property(ICelestialBodyInformationCollection._metadata, ICelestialBodyInformationCollection._get_count_metadata)

    _item_metadata = { "offset" : _item_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.LongArg, agmarshall.InterfaceOutArg,) }
    def item(self, index:int) -> "ICelestialBodyInformation":
        """Given an index, returns an element in the collection."""
        return self._intf.invoke(ICelestialBodyInformationCollection._metadata, ICelestialBodyInformationCollection._item_metadata, index, OutArg())

    _get__new_enum_metadata = { "offset" : _get__new_enum_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.IEnumVariantArg,) }
    @property
    def _new_enum(self) -> EnumeratorProxy:
        """Return an enumerator that can iterate through the collection."""
        return self._intf.get_property(ICelestialBodyInformationCollection._metadata, ICelestialBodyInformationCollection._get__new_enum_metadata)

    _get_recycle_metadata = { "offset" : _get_recycle_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def recycle(self) -> bool:
        """Control whether to reuse the same celestial info object when accessing the elements of the collection."""
        return self._intf.get_property(ICelestialBodyInformationCollection._metadata, ICelestialBodyInformationCollection._get_recycle_metadata)

    _set_recycle_metadata = { "offset" : _set_recycle_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @recycle.setter
    def recycle(self, recycle:bool) -> None:
        return self._intf.set_property(ICelestialBodyInformationCollection._metadata, ICelestialBodyInformationCollection._set_recycle_metadata, recycle)

    __getitem__ = item


    _property_names[count] = "count"
    _property_names[_new_enum] = "_new_enum"
    _property_names[recycle] = "recycle"


agcls.AgClassCatalog.add_catalog_entry((4773543347010503356, 16742073454930722438), ICelestialBodyInformationCollection)
agcls.AgTypeNameMap["ICelestialBodyInformationCollection"] = ICelestialBodyInformationCollection

class IAccessAdvanced(object):
    """Interface for configuring advanced targeting access computation properties."""

    _num_methods = 6
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_aberration_type_method_offset = 1
    _set_aberration_type_method_offset = 2
    _get_time_delay_convergence_method_offset = 3
    _set_time_delay_convergence_method_offset = 4
    _get_event_detection_method_offset = 5
    _get_sampling_method_offset = 6
    _metadata = {
        "iid_data" : (4742667574011760443, 9745610038801979301),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAccessAdvanced."""
        initialize_from_source_object(self, source_object, IAccessAdvanced)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAccessAdvanced)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAccessAdvanced, None)

    _get_aberration_type_metadata = { "offset" : _get_aberration_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AberrationType),) }
    @property
    def aberration_type(self) -> "AberrationType":
        """Model used for including aberration in apparent direction computations."""
        return self._intf.get_property(IAccessAdvanced._metadata, IAccessAdvanced._get_aberration_type_metadata)

    _set_aberration_type_metadata = { "offset" : _set_aberration_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(AberrationType),) }
    @aberration_type.setter
    def aberration_type(self, aberration_type:"AberrationType") -> None:
        return self._intf.set_property(IAccessAdvanced._metadata, IAccessAdvanced._set_aberration_type_metadata, aberration_type)

    _get_time_delay_convergence_metadata = { "offset" : _get_time_delay_convergence_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def time_delay_convergence(self) -> float:
        """Time delay convergence tolerance. Uses Time Dimension."""
        return self._intf.get_property(IAccessAdvanced._metadata, IAccessAdvanced._get_time_delay_convergence_metadata)

    _set_time_delay_convergence_metadata = { "offset" : _set_time_delay_convergence_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @time_delay_convergence.setter
    def time_delay_convergence(self, time_delay_convergence:float) -> None:
        return self._intf.set_property(IAccessAdvanced._metadata, IAccessAdvanced._set_time_delay_convergence_metadata, time_delay_convergence)

    _get_event_detection_metadata = { "offset" : _get_event_detection_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def event_detection(self) -> "AccessEventDetection":
        """Event detection strategy used in access calculations."""
        return self._intf.get_property(IAccessAdvanced._metadata, IAccessAdvanced._get_event_detection_metadata)

    _get_sampling_metadata = { "offset" : _get_sampling_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def sampling(self) -> "AccessSampling":
        """Sampling method used in access calculations."""
        return self._intf.get_property(IAccessAdvanced._metadata, IAccessAdvanced._get_sampling_metadata)

    _property_names[aberration_type] = "aberration_type"
    _property_names[time_delay_convergence] = "time_delay_convergence"
    _property_names[event_detection] = "event_detection"
    _property_names[sampling] = "sampling"


agcls.AgClassCatalog.add_catalog_entry((4742667574011760443, 9745610038801979301), IAccessAdvanced)
agcls.AgTypeNameMap["IAccessAdvanced"] = IAccessAdvanced

class IRefractionModelBase(object):
    """A base interface for the Refraction Models."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5518298169939898931, 11346666359500385188),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRefractionModelBase."""
        initialize_from_source_object(self, source_object, IRefractionModelBase)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRefractionModelBase)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRefractionModelBase, None)



agcls.AgClassCatalog.add_catalog_entry((5518298169939898931, 11346666359500385188), IRefractionModelBase)
agcls.AgTypeNameMap["IRefractionModelBase"] = IRefractionModelBase

class IDisplayDistance(object):
    """Base interface IDisplayDistance. ISensorProjectionDisplayDistance, SensorProjectionConstantAltitude and ISensorProjectionObjectAltitude derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5408704985411414065, 6891047350164697747),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDisplayDistance."""
        initialize_from_source_object(self, source_object, IDisplayDistance)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDisplayDistance)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDisplayDistance, None)



agcls.AgClassCatalog.add_catalog_entry((5408704985411414065, 6891047350164697747), IDisplayDistance)
agcls.AgTypeNameMap["IDisplayDistance"] = IDisplayDistance

class ISensorProjectionDisplayDistance(object):
    """ISensorProjectionDisplayDistance Interface for setting projection altitude options for a sensor."""

    _num_methods = 12
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_minimum_method_offset = 1
    _set_minimum_method_offset = 2
    _get_maximum_method_offset = 3
    _set_maximum_method_offset = 4
    _get_number_of_steps_method_offset = 5
    _set_number_of_steps_method_offset = 6
    _get_projects_thru_crossing_method_offset = 7
    _set_projects_thru_crossing_method_offset = 8
    _get_altitude_crossing_sides_method_offset = 9
    _set_altitude_crossing_sides_method_offset = 10
    _get_direction_method_offset = 11
    _set_direction_method_offset = 12
    _metadata = {
        "iid_data" : (4953315966664432405, 4968517206403938974),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISensorProjectionDisplayDistance."""
        initialize_from_source_object(self, source_object, ISensorProjectionDisplayDistance)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISensorProjectionDisplayDistance)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISensorProjectionDisplayDistance, None)

    _get_minimum_metadata = { "offset" : _get_minimum_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def minimum(self) -> float:
        """Minimum altitude above the facility, place or target from which the sensor projects. Uses Distance Dimension."""
        return self._intf.get_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._get_minimum_metadata)

    _set_minimum_metadata = { "offset" : _set_minimum_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @minimum.setter
    def minimum(self, value:float) -> None:
        return self._intf.set_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._set_minimum_metadata, value)

    _get_maximum_metadata = { "offset" : _get_maximum_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def maximum(self) -> float:
        """Maximum altitude above the facility, place or target from which the sensor projects. Uses Distance Dimension."""
        return self._intf.get_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._get_maximum_metadata)

    _set_maximum_metadata = { "offset" : _set_maximum_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @maximum.setter
    def maximum(self, value:float) -> None:
        return self._intf.set_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._set_maximum_metadata, value)

    _get_number_of_steps_metadata = { "offset" : _get_number_of_steps_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.LongArg,) }
    @property
    def number_of_steps(self) -> int:
        """Step count. Determines the interval between sensor projections. For a specified min/max altitude: the step count determines the number and altitude of projections to be displayed. Dimensionless."""
        return self._intf.get_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._get_number_of_steps_metadata)

    _set_number_of_steps_metadata = { "offset" : _set_number_of_steps_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.LongArg,) }
    @number_of_steps.setter
    def number_of_steps(self, value:int) -> None:
        return self._intf.set_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._set_number_of_steps_metadata, value)

    _get_projects_thru_crossing_metadata = { "offset" : _get_projects_thru_crossing_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def projects_thru_crossing(self) -> bool:
        """Specify whether the sensor's field-of-view will extend beyond specified crossings."""
        return self._intf.get_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._get_projects_thru_crossing_metadata)

    _set_projects_thru_crossing_metadata = { "offset" : _set_projects_thru_crossing_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @projects_thru_crossing.setter
    def projects_thru_crossing(self, show_ground_crossing:bool) -> None:
        return self._intf.set_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._set_projects_thru_crossing_metadata, show_ground_crossing)

    _get_altitude_crossing_sides_metadata = { "offset" : _get_altitude_crossing_sides_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(SensorAltitudeCrossingSideType),) }
    @property
    def altitude_crossing_sides(self) -> "SensorAltitudeCrossingSideType":
        """Indicate which crossings are computed and displayed in the 2D Graphics window."""
        return self._intf.get_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._get_altitude_crossing_sides_metadata)

    _set_altitude_crossing_sides_metadata = { "offset" : _set_altitude_crossing_sides_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(SensorAltitudeCrossingSideType),) }
    @altitude_crossing_sides.setter
    def altitude_crossing_sides(self, alt_crossing_sides:"SensorAltitudeCrossingSideType") -> None:
        return self._intf.set_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._set_altitude_crossing_sides_metadata, alt_crossing_sides)

    _get_direction_metadata = { "offset" : _get_direction_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(SensorAltitudeCrossingDirection),) }
    @property
    def direction(self) -> "SensorAltitudeCrossingDirection":
        """Indicate the direction in which the sensor's field of view crosses the specified altitude."""
        return self._intf.get_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._get_direction_metadata)

    _set_direction_metadata = { "offset" : _set_direction_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(SensorAltitudeCrossingDirection),) }
    @direction.setter
    def direction(self, direction:"SensorAltitudeCrossingDirection") -> None:
        return self._intf.set_property(ISensorProjectionDisplayDistance._metadata, ISensorProjectionDisplayDistance._set_direction_metadata, direction)

    _property_names[minimum] = "minimum"
    _property_names[maximum] = "maximum"
    _property_names[number_of_steps] = "number_of_steps"
    _property_names[projects_thru_crossing] = "projects_thru_crossing"
    _property_names[altitude_crossing_sides] = "altitude_crossing_sides"
    _property_names[direction] = "direction"


agcls.AgClassCatalog.add_catalog_entry((4953315966664432405, 4968517206403938974), ISensorProjectionDisplayDistance)
agcls.AgTypeNameMap["ISensorProjectionDisplayDistance"] = ISensorProjectionDisplayDistance

class ISensorPattern(object):
    """Base interface ISensorPattern. SensorComplexConicPattern, SensorCustomPattern, SensorHalfPowerPattern, SensorRectangularPattern, SensorSARPattern, SensorEOIRPattern and ISensorSimpleConicPattern implement this interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4822074903610663257, 670794337477858212),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISensorPattern."""
        initialize_from_source_object(self, source_object, ISensorPattern)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISensorPattern)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISensorPattern, None)



agcls.AgClassCatalog.add_catalog_entry((4822074903610663257, 670794337477858212), ISensorPattern)
agcls.AgTypeNameMap["ISensorPattern"] = ISensorPattern

class ISensorPointingTargetedBoresight(object):
    """Base interface ISensorPointingTargetedBoresight. SensorPointingTargetedBoresightFixed and ISensorPointingTargetedBoresightTrack derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5520308939413169285, 2414484971931353535),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISensorPointingTargetedBoresight."""
        initialize_from_source_object(self, source_object, ISensorPointingTargetedBoresight)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISensorPointingTargetedBoresight)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISensorPointingTargetedBoresight, None)



agcls.AgClassCatalog.add_catalog_entry((5520308939413169285, 2414484971931353535), ISensorPointingTargetedBoresight)
agcls.AgTypeNameMap["ISensorPointingTargetedBoresight"] = ISensorPointingTargetedBoresight

class ISensorPointing(object):
    """Base interface ISensorPointing. ISensorPointing3DModel, SensorPointingExternal, ISensorPointingFixed, SensorPointingFixedInAxes, SensorPointingGrazingAltitude, IAgSnPtTargeted, SensorPointingAlongVector and IAgSnPtSchedule implement this interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4916161629126725326, 4167207342323185846),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISensorPointing."""
        initialize_from_source_object(self, source_object, ISensorPointing)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISensorPointing)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISensorPointing, None)



agcls.AgClassCatalog.add_catalog_entry((4916161629126725326, 4167207342323185846), ISensorPointing)
agcls.AgTypeNameMap["ISensorPointing"] = ISensorPointing

class IAzElMaskData(object):
    """Base interface IAzElMaskData. SensorAzElMaskFile implements this interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5484583649368958181, 10363226351646093733),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAzElMaskData."""
        initialize_from_source_object(self, source_object, IAzElMaskData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAzElMaskData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAzElMaskData, None)



agcls.AgClassCatalog.add_catalog_entry((5484583649368958181, 10363226351646093733), IAzElMaskData)
agcls.AgTypeNameMap["IAzElMaskData"] = IAzElMaskData

class IRadarClutterMapInheritable(object):
    """Do not use this interface, as it is deprecated. This interface is no longer used and there is no alternative. Provides access to the properties and methods defining a radar inheritable clutter map."""

    _num_methods = 3
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_inherit_method_offset = 1
    _set_inherit_method_offset = 2
    _get_clutter_map_method_offset = 3
    _metadata = {
        "iid_data" : (5644681324895647268, 18226136145008367515),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterMapInheritable."""
        initialize_from_source_object(self, source_object, IRadarClutterMapInheritable)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterMapInheritable)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterMapInheritable, None)

    _get_inherit_metadata = { "offset" : _get_inherit_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def inherit(self) -> bool:
        """Get or set the option to inherit the clutter map from the scenario object."""
        return self._intf.get_property(IRadarClutterMapInheritable._metadata, IRadarClutterMapInheritable._get_inherit_metadata)

    _set_inherit_metadata = { "offset" : _set_inherit_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @inherit.setter
    def inherit(self, value:bool) -> None:
        return self._intf.set_property(IRadarClutterMapInheritable._metadata, IRadarClutterMapInheritable._set_inherit_metadata, value)

    _get_clutter_map_metadata = { "offset" : _get_clutter_map_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def clutter_map(self) -> "IRadarClutterMap":
        """Get the radar clutter map."""
        return self._intf.get_property(IRadarClutterMapInheritable._metadata, IRadarClutterMapInheritable._get_clutter_map_metadata)

    _property_names[inherit] = "inherit"
    _property_names[clutter_map] = "clutter_map"


agcls.AgClassCatalog.add_catalog_entry((5644681324895647268, 18226136145008367515), IRadarClutterMapInheritable)
agcls.AgTypeNameMap["IRadarClutterMapInheritable"] = IRadarClutterMapInheritable

class IPlatformRFEnvironment(object):
    """Provide access to the properties and methods defining the platform RF environment."""

    _num_methods = 9
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_enable_local_rain_data_method_offset = 1
    _set_enable_local_rain_data_method_offset = 2
    _get_local_rain_height_method_offset = 3
    _set_local_rain_height_method_offset = 4
    _get_local_rain_rate_method_offset = 5
    _set_local_rain_rate_method_offset = 6
    _get_local_surface_temperature_method_offset = 7
    _set_local_surface_temperature_method_offset = 8
    _get_propagation_channel_method_offset = 9
    _metadata = {
        "iid_data" : (5460182035440078467, 11199460751244848043),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPlatformRFEnvironment."""
        initialize_from_source_object(self, source_object, IPlatformRFEnvironment)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPlatformRFEnvironment)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPlatformRFEnvironment, None)

    _get_enable_local_rain_data_metadata = { "offset" : _get_enable_local_rain_data_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_local_rain_data(self) -> bool:
        """Get or set the option for enabling local rain data."""
        return self._intf.get_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._get_enable_local_rain_data_metadata)

    _set_enable_local_rain_data_metadata = { "offset" : _set_enable_local_rain_data_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_local_rain_data.setter
    def enable_local_rain_data(self, value:bool) -> None:
        return self._intf.set_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._set_enable_local_rain_data_metadata, value)

    _get_local_rain_height_metadata = { "offset" : _get_local_rain_height_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def local_rain_height(self) -> float:
        """Get or set the local rain iso height."""
        return self._intf.get_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._get_local_rain_height_metadata)

    _set_local_rain_height_metadata = { "offset" : _set_local_rain_height_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @local_rain_height.setter
    def local_rain_height(self, value:float) -> None:
        return self._intf.set_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._set_local_rain_height_metadata, value)

    _get_local_rain_rate_metadata = { "offset" : _get_local_rain_rate_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def local_rain_rate(self) -> float:
        """Get or set the local rain rate."""
        return self._intf.get_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._get_local_rain_rate_metadata)

    _set_local_rain_rate_metadata = { "offset" : _set_local_rain_rate_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @local_rain_rate.setter
    def local_rain_rate(self, value:float) -> None:
        return self._intf.set_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._set_local_rain_rate_metadata, value)

    _get_local_surface_temperature_metadata = { "offset" : _get_local_surface_temperature_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def local_surface_temperature(self) -> float:
        """Get or set the local surface temperature."""
        return self._intf.get_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._get_local_surface_temperature_metadata)

    _set_local_surface_temperature_metadata = { "offset" : _set_local_surface_temperature_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @local_surface_temperature.setter
    def local_surface_temperature(self, value:float) -> None:
        return self._intf.set_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._set_local_surface_temperature_metadata, value)

    _get_propagation_channel_metadata = { "offset" : _get_propagation_channel_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def propagation_channel(self) -> "PropagationChannel":
        """Get the propagation channel."""
        return self._intf.get_property(IPlatformRFEnvironment._metadata, IPlatformRFEnvironment._get_propagation_channel_metadata)

    _property_names[enable_local_rain_data] = "enable_local_rain_data"
    _property_names[local_rain_height] = "local_rain_height"
    _property_names[local_rain_rate] = "local_rain_rate"
    _property_names[local_surface_temperature] = "local_surface_temperature"
    _property_names[propagation_channel] = "propagation_channel"


agcls.AgClassCatalog.add_catalog_entry((5460182035440078467, 11199460751244848043), IPlatformRFEnvironment)
agcls.AgTypeNameMap["IPlatformRFEnvironment"] = IPlatformRFEnvironment

class IAreaTypeData(object):
    """Base interface IAreaTypeData. AreaTypePatternCollection and AreaTypeEllipse derive from it."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5664566626614236498, 14474624381359299515),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAreaTypeData."""
        initialize_from_source_object(self, source_object, IAreaTypeData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAreaTypeData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAreaTypeData, None)



agcls.AgClassCatalog.add_catalog_entry((5664566626614236498, 14474624381359299515), IAreaTypeData)
agcls.AgTypeNameMap["IAreaTypeData"] = IAreaTypeData

class IPositionSourceData(object):
    """Base interface to PlanetPositionCentralBody and PlanetPositionFile."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4944781973044139013, 9561431264782681733),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPositionSourceData."""
        initialize_from_source_object(self, source_object, IPositionSourceData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPositionSourceData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPositionSourceData, None)



agcls.AgClassCatalog.add_catalog_entry((4944781973044139013, 9561431264782681733), IPositionSourceData)
agcls.AgTypeNameMap["IPositionSourceData"] = IPositionSourceData

class IOrbitDisplayData(object):
    """IOrbitDisplayData Interface. PlanetOrbitDisplayTime derives from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5221333333925059073, 1713820497602169998),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IOrbitDisplayData."""
        initialize_from_source_object(self, source_object, IOrbitDisplayData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IOrbitDisplayData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IOrbitDisplayData, None)



agcls.AgClassCatalog.add_catalog_entry((5221333333925059073, 1713820497602169998), IOrbitDisplayData)
agcls.AgTypeNameMap["IOrbitDisplayData"] = IOrbitDisplayData

class IPolarization(object):
    """Provide the base interface for the a polarization object."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5345158656874615605, 10854876898822590373),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPolarization."""
        initialize_from_source_object(self, source_object, IPolarization)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPolarization)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPolarization, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PolarizationType),) }
    @property
    def type(self) -> "PolarizationType":
        """Get the polarization type."""
        return self._intf.get_property(IPolarization._metadata, IPolarization._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5345158656874615605, 10854876898822590373), IPolarization)
agcls.AgTypeNameMap["IPolarization"] = IPolarization

class IPolarizationElliptical(object):
    """Provide the interface for elliptical polarization."""

    _num_methods = 6
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_reference_axis_method_offset = 1
    _set_reference_axis_method_offset = 2
    _get_tilt_angle_method_offset = 3
    _set_tilt_angle_method_offset = 4
    _get_axial_ratio_method_offset = 5
    _set_axial_ratio_method_offset = 6
    _metadata = {
        "iid_data" : (4696269047906975590, 8205225471499450812),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPolarizationElliptical."""
        initialize_from_source_object(self, source_object, IPolarizationElliptical)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPolarizationElliptical)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPolarizationElliptical, None)

    _get_reference_axis_metadata = { "offset" : _get_reference_axis_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @property
    def reference_axis(self) -> "PolarizationReferenceAxis":
        """Get or set the polarization reference axis."""
        return self._intf.get_property(IPolarizationElliptical._metadata, IPolarizationElliptical._get_reference_axis_metadata)

    _set_reference_axis_metadata = { "offset" : _set_reference_axis_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @reference_axis.setter
    def reference_axis(self, value:"PolarizationReferenceAxis") -> None:
        return self._intf.set_property(IPolarizationElliptical._metadata, IPolarizationElliptical._set_reference_axis_metadata, value)

    _get_tilt_angle_metadata = { "offset" : _get_tilt_angle_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def tilt_angle(self) -> typing.Any:
        """Get or set the polarization tilt angle."""
        return self._intf.get_property(IPolarizationElliptical._metadata, IPolarizationElliptical._get_tilt_angle_metadata)

    _set_tilt_angle_metadata = { "offset" : _set_tilt_angle_method_offset,
            "arg_types" : (agcom.Variant,),
            "marshallers" : (agmarshall.VariantArg,) }
    @tilt_angle.setter
    def tilt_angle(self, value:typing.Any) -> None:
        return self._intf.set_property(IPolarizationElliptical._metadata, IPolarizationElliptical._set_tilt_angle_metadata, value)

    _get_axial_ratio_metadata = { "offset" : _get_axial_ratio_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def axial_ratio(self) -> float:
        """Get or set the polarization axial ratio."""
        return self._intf.get_property(IPolarizationElliptical._metadata, IPolarizationElliptical._get_axial_ratio_metadata)

    _set_axial_ratio_metadata = { "offset" : _set_axial_ratio_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @axial_ratio.setter
    def axial_ratio(self, value:float) -> None:
        return self._intf.set_property(IPolarizationElliptical._metadata, IPolarizationElliptical._set_axial_ratio_metadata, value)

    _property_names[reference_axis] = "reference_axis"
    _property_names[tilt_angle] = "tilt_angle"
    _property_names[axial_ratio] = "axial_ratio"


agcls.AgClassCatalog.add_catalog_entry((4696269047906975590, 8205225471499450812), IPolarizationElliptical)
agcls.AgTypeNameMap["IPolarizationElliptical"] = IPolarizationElliptical

class IPolarizationCrossPolLeakage(object):
    """Provide the interface for polarization cross pol leakage."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_cross_polarization_leakage_method_offset = 1
    _set_cross_polarization_leakage_method_offset = 2
    _metadata = {
        "iid_data" : (5146923506495716281, 6991895547169696948),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPolarizationCrossPolLeakage."""
        initialize_from_source_object(self, source_object, IPolarizationCrossPolLeakage)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPolarizationCrossPolLeakage)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPolarizationCrossPolLeakage, None)

    _get_cross_polarization_leakage_metadata = { "offset" : _get_cross_polarization_leakage_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def cross_polarization_leakage(self) -> float:
        """Get or set the polarization cross pol leakage."""
        return self._intf.get_property(IPolarizationCrossPolLeakage._metadata, IPolarizationCrossPolLeakage._get_cross_polarization_leakage_metadata)

    _set_cross_polarization_leakage_metadata = { "offset" : _set_cross_polarization_leakage_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @cross_polarization_leakage.setter
    def cross_polarization_leakage(self, value:float) -> None:
        return self._intf.set_property(IPolarizationCrossPolLeakage._metadata, IPolarizationCrossPolLeakage._set_cross_polarization_leakage_metadata, value)

    _property_names[cross_polarization_leakage] = "cross_polarization_leakage"


agcls.AgClassCatalog.add_catalog_entry((5146923506495716281, 6991895547169696948), IPolarizationCrossPolLeakage)
agcls.AgTypeNameMap["IPolarizationCrossPolLeakage"] = IPolarizationCrossPolLeakage

class IPolarizationLinear(object):
    """Provide the interface for linear polarization."""

    _num_methods = 4
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_reference_axis_method_offset = 1
    _set_reference_axis_method_offset = 2
    _get_tilt_angle_method_offset = 3
    _set_tilt_angle_method_offset = 4
    _metadata = {
        "iid_data" : (5075030604204446319, 1127214944361484169),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPolarizationLinear."""
        initialize_from_source_object(self, source_object, IPolarizationLinear)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPolarizationLinear)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPolarizationLinear, None)

    _get_reference_axis_metadata = { "offset" : _get_reference_axis_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @property
    def reference_axis(self) -> "PolarizationReferenceAxis":
        """Get or set the polarization reference axis."""
        return self._intf.get_property(IPolarizationLinear._metadata, IPolarizationLinear._get_reference_axis_metadata)

    _set_reference_axis_metadata = { "offset" : _set_reference_axis_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @reference_axis.setter
    def reference_axis(self, value:"PolarizationReferenceAxis") -> None:
        return self._intf.set_property(IPolarizationLinear._metadata, IPolarizationLinear._set_reference_axis_metadata, value)

    _get_tilt_angle_metadata = { "offset" : _get_tilt_angle_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def tilt_angle(self) -> typing.Any:
        """Get or set the polarization tilt angle."""
        return self._intf.get_property(IPolarizationLinear._metadata, IPolarizationLinear._get_tilt_angle_metadata)

    _set_tilt_angle_metadata = { "offset" : _set_tilt_angle_method_offset,
            "arg_types" : (agcom.Variant,),
            "marshallers" : (agmarshall.VariantArg,) }
    @tilt_angle.setter
    def tilt_angle(self, value:typing.Any) -> None:
        return self._intf.set_property(IPolarizationLinear._metadata, IPolarizationLinear._set_tilt_angle_metadata, value)

    _property_names[reference_axis] = "reference_axis"
    _property_names[tilt_angle] = "tilt_angle"


agcls.AgClassCatalog.add_catalog_entry((5075030604204446319, 1127214944361484169), IPolarizationLinear)
agcls.AgTypeNameMap["IPolarizationLinear"] = IPolarizationLinear

class IPolarizationHorizontal(object):
    """Provide the interface for linear polarization."""

    _num_methods = 3
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_reference_axis_method_offset = 1
    _set_reference_axis_method_offset = 2
    _get_tilt_angle_method_offset = 3
    _metadata = {
        "iid_data" : (5113008820318405253, 3721014887644194443),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPolarizationHorizontal."""
        initialize_from_source_object(self, source_object, IPolarizationHorizontal)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPolarizationHorizontal)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPolarizationHorizontal, None)

    _get_reference_axis_metadata = { "offset" : _get_reference_axis_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @property
    def reference_axis(self) -> "PolarizationReferenceAxis":
        """Get or set the polarization reference axis."""
        return self._intf.get_property(IPolarizationHorizontal._metadata, IPolarizationHorizontal._get_reference_axis_metadata)

    _set_reference_axis_metadata = { "offset" : _set_reference_axis_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @reference_axis.setter
    def reference_axis(self, value:"PolarizationReferenceAxis") -> None:
        return self._intf.set_property(IPolarizationHorizontal._metadata, IPolarizationHorizontal._set_reference_axis_metadata, value)

    _get_tilt_angle_metadata = { "offset" : _get_tilt_angle_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def tilt_angle(self) -> typing.Any:
        """Get the polarization tilt angle."""
        return self._intf.get_property(IPolarizationHorizontal._metadata, IPolarizationHorizontal._get_tilt_angle_metadata)

    _property_names[reference_axis] = "reference_axis"
    _property_names[tilt_angle] = "tilt_angle"


agcls.AgClassCatalog.add_catalog_entry((5113008820318405253, 3721014887644194443), IPolarizationHorizontal)
agcls.AgTypeNameMap["IPolarizationHorizontal"] = IPolarizationHorizontal

class IPolarizationVertical(object):
    """Provide the interface for linear polarization."""

    _num_methods = 3
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_reference_axis_method_offset = 1
    _set_reference_axis_method_offset = 2
    _get_tilt_angle_method_offset = 3
    _metadata = {
        "iid_data" : (4688580435089806816, 9730430946210584966),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPolarizationVertical."""
        initialize_from_source_object(self, source_object, IPolarizationVertical)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPolarizationVertical)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPolarizationVertical, None)

    _get_reference_axis_metadata = { "offset" : _get_reference_axis_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @property
    def reference_axis(self) -> "PolarizationReferenceAxis":
        """Get or set the polarization reference axis."""
        return self._intf.get_property(IPolarizationVertical._metadata, IPolarizationVertical._get_reference_axis_metadata)

    _set_reference_axis_metadata = { "offset" : _set_reference_axis_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(PolarizationReferenceAxis),) }
    @reference_axis.setter
    def reference_axis(self, value:"PolarizationReferenceAxis") -> None:
        return self._intf.set_property(IPolarizationVertical._metadata, IPolarizationVertical._set_reference_axis_metadata, value)

    _get_tilt_angle_metadata = { "offset" : _get_tilt_angle_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def tilt_angle(self) -> typing.Any:
        """Get the polarization tilt angle."""
        return self._intf.get_property(IPolarizationVertical._metadata, IPolarizationVertical._get_tilt_angle_metadata)

    _property_names[reference_axis] = "reference_axis"
    _property_names[tilt_angle] = "tilt_angle"


agcls.AgClassCatalog.add_catalog_entry((4688580435089806816, 9730430946210584966), IPolarizationVertical)
agcls.AgTypeNameMap["IPolarizationVertical"] = IPolarizationVertical

class IPointingStrategy(object):
    """Provide the base interface for a pointing strategy."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5759398571514398171, 12684185655943868585),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPointingStrategy."""
        initialize_from_source_object(self, source_object, IPointingStrategy)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPointingStrategy)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPointingStrategy, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PointingStrategyType),) }
    @property
    def type(self) -> "PointingStrategyType":
        """Get the pointing strategy type."""
        return self._intf.get_property(IPointingStrategy._metadata, IPointingStrategy._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5759398571514398171, 12684185655943868585), IPointingStrategy)
agcls.AgTypeNameMap["IPointingStrategy"] = IPointingStrategy

class IWaveform(object):
    """Provide access to the properties and methods defining an antenna model."""

    _num_methods = 10
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _get_frequency_specification_method_offset = 3
    _set_frequency_specification_method_offset = 4
    _get_frequency_method_offset = 5
    _set_frequency_method_offset = 6
    _get_wavelength_method_offset = 7
    _set_wavelength_method_offset = 8
    _get_power_method_offset = 9
    _set_power_method_offset = 10
    _metadata = {
        "iid_data" : (5687517008246973263, 10742001917010752406),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IWaveform."""
        initialize_from_source_object(self, source_object, IWaveform)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IWaveform)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IWaveform, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the waveform name."""
        return self._intf.get_property(IWaveform._metadata, IWaveform._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(WaveformType),) }
    @property
    def type(self) -> "WaveformType":
        """Get the waveform type enumeration."""
        return self._intf.get_property(IWaveform._metadata, IWaveform._get_type_metadata)

    _get_frequency_specification_metadata = { "offset" : _get_frequency_specification_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(FrequencySpecificationType),) }
    @property
    def frequency_specification(self) -> "FrequencySpecificationType":
        """Get or set the frequency specification."""
        return self._intf.get_property(IWaveform._metadata, IWaveform._get_frequency_specification_metadata)

    _set_frequency_specification_metadata = { "offset" : _set_frequency_specification_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(FrequencySpecificationType),) }
    @frequency_specification.setter
    def frequency_specification(self, value:"FrequencySpecificationType") -> None:
        return self._intf.set_property(IWaveform._metadata, IWaveform._set_frequency_specification_metadata, value)

    _get_frequency_metadata = { "offset" : _get_frequency_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def frequency(self) -> float:
        """Get or set the frequency."""
        return self._intf.get_property(IWaveform._metadata, IWaveform._get_frequency_metadata)

    _set_frequency_metadata = { "offset" : _set_frequency_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @frequency.setter
    def frequency(self, value:float) -> None:
        return self._intf.set_property(IWaveform._metadata, IWaveform._set_frequency_metadata, value)

    _get_wavelength_metadata = { "offset" : _get_wavelength_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def wavelength(self) -> float:
        """Get or set the wavelength."""
        return self._intf.get_property(IWaveform._metadata, IWaveform._get_wavelength_metadata)

    _set_wavelength_metadata = { "offset" : _set_wavelength_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @wavelength.setter
    def wavelength(self, value:float) -> None:
        return self._intf.set_property(IWaveform._metadata, IWaveform._set_wavelength_metadata, value)

    _get_power_metadata = { "offset" : _get_power_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def power(self) -> float:
        """Get the power."""
        return self._intf.get_property(IWaveform._metadata, IWaveform._get_power_metadata)

    _set_power_metadata = { "offset" : _set_power_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @power.setter
    def power(self, power:float) -> None:
        """Set the power."""
        return self._intf.set_property(IWaveform._metadata, IWaveform._set_power_metadata, power)

    _property_names[name] = "name"
    _property_names[type] = "type"
    _property_names[frequency_specification] = "frequency_specification"
    _property_names[frequency] = "frequency"
    _property_names[wavelength] = "wavelength"
    _property_names[power] = "power"


agcls.AgClassCatalog.add_catalog_entry((5687517008246973263, 10742001917010752406), IWaveform)
agcls.AgTypeNameMap["IWaveform"] = IWaveform

class IWaveformSelectionStrategy(object):
    """Provide the base interface for a waveform selection strategy."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (4742759297577063839, 1658392309505849478),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IWaveformSelectionStrategy."""
        initialize_from_source_object(self, source_object, IWaveformSelectionStrategy)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IWaveformSelectionStrategy)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IWaveformSelectionStrategy, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(WaveformSelectionStrategyType),) }
    @property
    def type(self) -> "WaveformSelectionStrategyType":
        """Get the waveform selection strategy type."""
        return self._intf.get_property(IWaveformSelectionStrategy._metadata, IWaveformSelectionStrategy._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4742759297577063839, 1658392309505849478), IWaveformSelectionStrategy)
agcls.AgTypeNameMap["IWaveformSelectionStrategy"] = IWaveformSelectionStrategy

class IScatteringPointProvider(object):
    """Provide access to the properties and methods defining a scattering point provider."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_point_provider_type_method_offset = 2
    _metadata = {
        "iid_data" : (5665591179565422222, 8071005272408887452),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IScatteringPointProvider."""
        initialize_from_source_object(self, source_object, IScatteringPointProvider)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IScatteringPointProvider)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IScatteringPointProvider, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the scattering point provider name."""
        return self._intf.get_property(IScatteringPointProvider._metadata, IScatteringPointProvider._get_name_metadata)

    _get_point_provider_type_metadata = { "offset" : _get_point_provider_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ScatteringPointProviderType),) }
    @property
    def point_provider_type(self) -> "ScatteringPointProviderType":
        """Get the scattering point provider type enumeration."""
        return self._intf.get_property(IScatteringPointProvider._metadata, IScatteringPointProvider._get_point_provider_type_metadata)

    _property_names[name] = "name"
    _property_names[point_provider_type] = "point_provider_type"


agcls.AgClassCatalog.add_catalog_entry((5665591179565422222, 8071005272408887452), IScatteringPointProvider)
agcls.AgTypeNameMap["IScatteringPointProvider"] = IScatteringPointProvider

class IScatteringPointModel(object):
    """Provide access to the properties and methods defining a scattering point model model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5087163638513298695, 4166810130017342357),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IScatteringPointModel."""
        initialize_from_source_object(self, source_object, IScatteringPointModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IScatteringPointModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IScatteringPointModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar clutter map model name."""
        return self._intf.get_property(IScatteringPointModel._metadata, IScatteringPointModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ScatteringPointModelType),) }
    @property
    def type(self) -> "ScatteringPointModelType":
        """Get the radar clutter map model type enumeration."""
        return self._intf.get_property(IScatteringPointModel._metadata, IScatteringPointModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5087163638513298695, 4166810130017342357), IScatteringPointModel)
agcls.AgTypeNameMap["IScatteringPointModel"] = IScatteringPointModel

class IAntennaModel(object):
    """Provide access to the properties and methods defining an antenna model."""

    _num_methods = 4
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _get_design_frequency_method_offset = 3
    _set_design_frequency_method_offset = 4
    _metadata = {
        "iid_data" : (5365902589649152657, 16999847558138990507),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAntennaModel."""
        initialize_from_source_object(self, source_object, IAntennaModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAntennaModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAntennaModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the antenna model name."""
        return self._intf.get_property(IAntennaModel._metadata, IAntennaModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AntennaModelType),) }
    @property
    def type(self) -> "AntennaModelType":
        """Get the antenna model type enumeration."""
        return self._intf.get_property(IAntennaModel._metadata, IAntennaModel._get_type_metadata)

    _get_design_frequency_metadata = { "offset" : _get_design_frequency_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def design_frequency(self) -> float:
        """Get the antenna design frequency."""
        return self._intf.get_property(IAntennaModel._metadata, IAntennaModel._get_design_frequency_metadata)

    _set_design_frequency_metadata = { "offset" : _set_design_frequency_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @design_frequency.setter
    def design_frequency(self, design_freq:float) -> None:
        """Set the antenna design frequency."""
        return self._intf.set_property(IAntennaModel._metadata, IAntennaModel._set_design_frequency_metadata, design_freq)

    _property_names[name] = "name"
    _property_names[type] = "type"
    _property_names[design_frequency] = "design_frequency"


agcls.AgClassCatalog.add_catalog_entry((5365902589649152657, 16999847558138990507), IAntennaModel)
agcls.AgTypeNameMap["IAntennaModel"] = IAntennaModel

class IElementConfiguration(object):
    """Provide access to the properties and methods defining an element configuration."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (4943613592835937335, 17694237556676747419),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IElementConfiguration."""
        initialize_from_source_object(self, source_object, IElementConfiguration)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IElementConfiguration)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IElementConfiguration, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ElementConfigurationType),) }
    @property
    def type(self) -> "ElementConfigurationType":
        """Get the element configuration type enumeration."""
        return self._intf.get_property(IElementConfiguration._metadata, IElementConfiguration._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4943613592835937335, 17694237556676747419), IElementConfiguration)
agcls.AgTypeNameMap["IElementConfiguration"] = IElementConfiguration

class IElementConfigurationPolygon(object):
    """Provide access to the properties and methods defining a polygon element configuration."""

    _num_methods = 18
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_lattice_type_method_offset = 1
    _set_lattice_type_method_offset = 2
    _get_number_of_sides_method_offset = 3
    _set_number_of_sides_method_offset = 4
    _get_equilateral_method_offset = 5
    _set_equilateral_method_offset = 6
    _get_number_of_x_elements_method_offset = 7
    _set_number_of_x_elements_method_offset = 8
    _get_number_of_y_elements_method_offset = 9
    _set_number_of_y_elements_method_offset = 10
    _get_spacing_x_method_offset = 11
    _set_spacing_x_method_offset = 12
    _get_spacing_y_method_offset = 13
    _set_spacing_y_method_offset = 14
    _get_maximum_look_angle_elevation_method_offset = 15
    _get_maximum_look_angle_azimuth_method_offset = 16
    _get_spacing_unit_method_offset = 17
    _set_spacing_unit_method_offset = 18
    _metadata = {
        "iid_data" : (5541671416868424088, 1719543556508628147),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IElementConfigurationPolygon."""
        initialize_from_source_object(self, source_object, IElementConfigurationPolygon)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IElementConfigurationPolygon)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IElementConfigurationPolygon, None)

    _get_lattice_type_metadata = { "offset" : _get_lattice_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(LatticeType),) }
    @property
    def lattice_type(self) -> "LatticeType":
        """Get or set the lattice type."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_lattice_type_metadata)

    _set_lattice_type_metadata = { "offset" : _set_lattice_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(LatticeType),) }
    @lattice_type.setter
    def lattice_type(self, value:"LatticeType") -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_lattice_type_metadata, value)

    _get_number_of_sides_metadata = { "offset" : _get_number_of_sides_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def number_of_sides(self) -> int:
        """Get or set the number of polygon sides."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_number_of_sides_metadata)

    _set_number_of_sides_metadata = { "offset" : _set_number_of_sides_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @number_of_sides.setter
    def number_of_sides(self, value:int) -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_number_of_sides_metadata, value)

    _get_equilateral_metadata = { "offset" : _get_equilateral_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def equilateral(self) -> bool:
        """Get or set the option for evenly spacing adjacent elements."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_equilateral_metadata)

    _set_equilateral_metadata = { "offset" : _set_equilateral_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @equilateral.setter
    def equilateral(self, value:bool) -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_equilateral_metadata, value)

    _get_number_of_x_elements_metadata = { "offset" : _get_number_of_x_elements_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def number_of_x_elements(self) -> int:
        """Get or set the number of elements in the x direction."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_number_of_x_elements_metadata)

    _set_number_of_x_elements_metadata = { "offset" : _set_number_of_x_elements_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @number_of_x_elements.setter
    def number_of_x_elements(self, value:int) -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_number_of_x_elements_metadata, value)

    _get_number_of_y_elements_metadata = { "offset" : _get_number_of_y_elements_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def number_of_y_elements(self) -> int:
        """Get or set the number of elements in the y direction."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_number_of_y_elements_metadata)

    _set_number_of_y_elements_metadata = { "offset" : _set_number_of_y_elements_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @number_of_y_elements.setter
    def number_of_y_elements(self, value:int) -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_number_of_y_elements_metadata, value)

    _get_spacing_x_metadata = { "offset" : _get_spacing_x_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def spacing_x(self) -> float:
        """Get or set the spacing of the elements in the x direction, in wavelengths."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_spacing_x_metadata)

    _set_spacing_x_metadata = { "offset" : _set_spacing_x_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @spacing_x.setter
    def spacing_x(self, value:float) -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_spacing_x_metadata, value)

    _get_spacing_y_metadata = { "offset" : _get_spacing_y_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def spacing_y(self) -> float:
        """Get or set the spacing of the elements in the y direction, in wavelengths."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_spacing_y_metadata)

    _set_spacing_y_metadata = { "offset" : _set_spacing_y_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @spacing_y.setter
    def spacing_y(self, value:float) -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_spacing_y_metadata, value)

    _get_maximum_look_angle_elevation_metadata = { "offset" : _get_maximum_look_angle_elevation_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def maximum_look_angle_elevation(self) -> typing.Any:
        """Get the maximum look angle in the x direction."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_maximum_look_angle_elevation_metadata)

    _get_maximum_look_angle_azimuth_metadata = { "offset" : _get_maximum_look_angle_azimuth_method_offset,
            "arg_types" : (POINTER(agcom.Variant),),
            "marshallers" : (agmarshall.VariantArg,) }
    @property
    def maximum_look_angle_azimuth(self) -> typing.Any:
        """Get the maximum look angle in the y direction."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_maximum_look_angle_azimuth_metadata)

    _get_spacing_unit_metadata = { "offset" : _get_spacing_unit_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(SpacingUnit),) }
    @property
    def spacing_unit(self) -> "SpacingUnit":
        """Get or set the spacing unit."""
        return self._intf.get_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._get_spacing_unit_metadata)

    _set_spacing_unit_metadata = { "offset" : _set_spacing_unit_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(SpacingUnit),) }
    @spacing_unit.setter
    def spacing_unit(self, value:"SpacingUnit") -> None:
        return self._intf.set_property(IElementConfigurationPolygon._metadata, IElementConfigurationPolygon._set_spacing_unit_metadata, value)

    _property_names[lattice_type] = "lattice_type"
    _property_names[number_of_sides] = "number_of_sides"
    _property_names[equilateral] = "equilateral"
    _property_names[number_of_x_elements] = "number_of_x_elements"
    _property_names[number_of_y_elements] = "number_of_y_elements"
    _property_names[spacing_x] = "spacing_x"
    _property_names[spacing_y] = "spacing_y"
    _property_names[maximum_look_angle_elevation] = "maximum_look_angle_elevation"
    _property_names[maximum_look_angle_azimuth] = "maximum_look_angle_azimuth"
    _property_names[spacing_unit] = "spacing_unit"


agcls.AgClassCatalog.add_catalog_entry((5541671416868424088, 1719543556508628147), IElementConfigurationPolygon)
agcls.AgTypeNameMap["IElementConfigurationPolygon"] = IElementConfigurationPolygon

class IBeamformer(object):
    """Provide access to the properties and methods defining a beamformer."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5600508114360893412, 11209552837748337067),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IBeamformer."""
        initialize_from_source_object(self, source_object, IBeamformer)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IBeamformer)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IBeamformer, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(BeamformerType),) }
    @property
    def type(self) -> "BeamformerType":
        """Get the beamformer type enumeration."""
        return self._intf.get_property(IBeamformer._metadata, IBeamformer._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5600508114360893412, 11209552837748337067), IBeamformer)
agcls.AgTypeNameMap["IBeamformer"] = IBeamformer

class ITargetSelectionMethod(object):
    """Provide access to the properties and methods defining a target selection method."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5260835428325420654, 13083385363619395751),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ITargetSelectionMethod."""
        initialize_from_source_object(self, source_object, ITargetSelectionMethod)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ITargetSelectionMethod)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ITargetSelectionMethod, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(TargetSelectionMethod),) }
    @property
    def type(self) -> "TargetSelectionMethod":
        """Get the target selection method type enumeration."""
        return self._intf.get_property(ITargetSelectionMethod._metadata, ITargetSelectionMethod._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5260835428325420654, 13083385363619395751), ITargetSelectionMethod)
agcls.AgTypeNameMap["ITargetSelectionMethod"] = ITargetSelectionMethod

class IDirectionProvider(object):
    """Provide access to the properties and methods defining an direction provider."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5599564535202356048, 8305471409985746306),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDirectionProvider."""
        initialize_from_source_object(self, source_object, IDirectionProvider)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDirectionProvider)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDirectionProvider, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(DirectionProviderType),) }
    @property
    def type(self) -> "DirectionProviderType":
        """Get the direction provider type enumeration."""
        return self._intf.get_property(IDirectionProvider._metadata, IDirectionProvider._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5599564535202356048, 8305471409985746306), IDirectionProvider)
agcls.AgTypeNameMap["IDirectionProvider"] = IDirectionProvider

class IAntennaModelOpticalSimple(object):
    """Provide access to the properties and methods defining a simple optical antenna model."""

    _num_methods = 8
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_compute_gain_method_offset = 1
    _set_compute_gain_method_offset = 2
    _get_maximum_gain_method_offset = 3
    _set_maximum_gain_method_offset = 4
    _get_area_method_offset = 5
    _set_area_method_offset = 6
    _get_efficiency_method_offset = 7
    _set_efficiency_method_offset = 8
    _metadata = {
        "iid_data" : (5216476642350706303, 1653965811619943064),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAntennaModelOpticalSimple."""
        initialize_from_source_object(self, source_object, IAntennaModelOpticalSimple)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAntennaModelOpticalSimple)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAntennaModelOpticalSimple, None)

    _get_compute_gain_metadata = { "offset" : _get_compute_gain_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def compute_gain(self) -> bool:
        """Get or set the option for computing gain."""
        return self._intf.get_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._get_compute_gain_metadata)

    _set_compute_gain_metadata = { "offset" : _set_compute_gain_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @compute_gain.setter
    def compute_gain(self, value:bool) -> None:
        return self._intf.set_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._set_compute_gain_metadata, value)

    _get_maximum_gain_metadata = { "offset" : _get_maximum_gain_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def maximum_gain(self) -> float:
        """Get or set the maximum gain."""
        return self._intf.get_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._get_maximum_gain_metadata)

    _set_maximum_gain_metadata = { "offset" : _set_maximum_gain_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @maximum_gain.setter
    def maximum_gain(self, value:float) -> None:
        return self._intf.set_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._set_maximum_gain_metadata, value)

    _get_area_metadata = { "offset" : _get_area_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def area(self) -> float:
        """Get or set the area."""
        return self._intf.get_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._get_area_metadata)

    _set_area_metadata = { "offset" : _set_area_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @area.setter
    def area(self, value:float) -> None:
        return self._intf.set_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._set_area_metadata, value)

    _get_efficiency_metadata = { "offset" : _get_efficiency_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def efficiency(self) -> float:
        """Get or set the area."""
        return self._intf.get_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._get_efficiency_metadata)

    _set_efficiency_metadata = { "offset" : _set_efficiency_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @efficiency.setter
    def efficiency(self, value:float) -> None:
        return self._intf.set_property(IAntennaModelOpticalSimple._metadata, IAntennaModelOpticalSimple._set_efficiency_metadata, value)

    _property_names[compute_gain] = "compute_gain"
    _property_names[maximum_gain] = "maximum_gain"
    _property_names[area] = "area"
    _property_names[efficiency] = "efficiency"


agcls.AgClassCatalog.add_catalog_entry((5216476642350706303, 1653965811619943064), IAntennaModelOpticalSimple)
agcls.AgTypeNameMap["IAntennaModelOpticalSimple"] = IAntennaModelOpticalSimple

class IAntennaContour(object):
    """IAntennaContour Interface for a antenna's contour properties."""

    _num_methods = 20
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_show_at_altitude_method_offset = 1
    _set_show_at_altitude_method_offset = 2
    _get_altitude_method_offset = 3
    _set_altitude_method_offset = 4
    _get_relative_to_maximum_gain_method_offset = 5
    _set_relative_to_maximum_gain_method_offset = 6
    _get_show_labels_method_offset = 7
    _set_show_labels_method_offset = 8
    _get_number_of_label_decimal_digits_method_offset = 9
    _set_number_of_label_decimal_digits_method_offset = 10
    _get_line_width_method_offset = 11
    _set_line_width_method_offset = 12
    _get_color_method_method_offset = 13
    _set_color_method_method_offset = 14
    _get_start_color_method_offset = 15
    _set_start_color_method_offset = 16
    _get_stop_color_method_offset = 17
    _set_stop_color_method_offset = 18
    _get_type_method_offset = 19
    _get_levels_method_offset = 20
    _metadata = {
        "iid_data" : (5613976015755720505, 12727280771050595774),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAntennaContour."""
        initialize_from_source_object(self, source_object, IAntennaContour)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAntennaContour)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAntennaContour, None)

    _get_show_at_altitude_metadata = { "offset" : _get_show_at_altitude_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_at_altitude(self) -> bool:
        """Enable the ability to view the contours at a set altitude."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_show_at_altitude_metadata)

    _set_show_at_altitude_metadata = { "offset" : _set_show_at_altitude_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_at_altitude.setter
    def show_at_altitude(self, value:bool) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_show_at_altitude_metadata, value)

    _get_altitude_metadata = { "offset" : _get_altitude_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def altitude(self) -> float:
        """Get or set the altitude to view the contours."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_altitude_metadata)

    _set_altitude_metadata = { "offset" : _set_altitude_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @altitude.setter
    def altitude(self, value:float) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_altitude_metadata, value)

    _get_relative_to_maximum_gain_metadata = { "offset" : _get_relative_to_maximum_gain_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def relative_to_maximum_gain(self) -> bool:
        """The contours value represents the gain value relative to the maximum."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_relative_to_maximum_gain_metadata)

    _set_relative_to_maximum_gain_metadata = { "offset" : _set_relative_to_maximum_gain_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @relative_to_maximum_gain.setter
    def relative_to_maximum_gain(self, value:bool) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_relative_to_maximum_gain_metadata, value)

    _get_show_labels_metadata = { "offset" : _get_show_labels_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_labels(self) -> bool:
        """Get or set the option for showing contour labels."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_show_labels_metadata)

    _set_show_labels_metadata = { "offset" : _set_show_labels_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_labels.setter
    def show_labels(self, value:bool) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_show_labels_metadata, value)

    _get_number_of_label_decimal_digits_metadata = { "offset" : _get_number_of_label_decimal_digits_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def number_of_label_decimal_digits(self) -> int:
        """Get or set the integer number of decimal places to display in the contour label."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_number_of_label_decimal_digits_metadata)

    _set_number_of_label_decimal_digits_metadata = { "offset" : _set_number_of_label_decimal_digits_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @number_of_label_decimal_digits.setter
    def number_of_label_decimal_digits(self, value:int) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_number_of_label_decimal_digits_metadata, value)

    _get_line_width_metadata = { "offset" : _get_line_width_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(LineWidth),) }
    @property
    def line_width(self) -> "LineWidth":
        """Select the line width in which antenna 2D graphics display from the LineWidth enumeration."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_line_width_metadata)

    _set_line_width_metadata = { "offset" : _set_line_width_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(LineWidth),) }
    @line_width.setter
    def line_width(self, value:"LineWidth") -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_line_width_metadata, value)

    _get_color_method_metadata = { "offset" : _get_color_method_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(FigureOfMeritGraphics2DColorMethod),) }
    @property
    def color_method(self) -> "FigureOfMeritGraphics2DColorMethod":
        """Color method for contours (color ramp or explicit)."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_color_method_metadata)

    _set_color_method_metadata = { "offset" : _set_color_method_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(FigureOfMeritGraphics2DColorMethod),) }
    @color_method.setter
    def color_method(self, value:"FigureOfMeritGraphics2DColorMethod") -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_color_method_metadata, value)

    _get_start_color_metadata = { "offset" : _get_start_color_method_offset,
            "arg_types" : (POINTER(agcom.OLE_COLOR),),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @property
    def start_color(self) -> agcolor.Color:
        """The color ramp start color."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_start_color_metadata)

    _set_start_color_metadata = { "offset" : _set_start_color_method_offset,
            "arg_types" : (agcom.OLE_COLOR,),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @start_color.setter
    def start_color(self, value:agcolor.Color) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_start_color_metadata, value)

    _get_stop_color_metadata = { "offset" : _get_stop_color_method_offset,
            "arg_types" : (POINTER(agcom.OLE_COLOR),),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @property
    def stop_color(self) -> agcolor.Color:
        """The color ramp stop color."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_stop_color_metadata)

    _set_stop_color_metadata = { "offset" : _set_stop_color_method_offset,
            "arg_types" : (agcom.OLE_COLOR,),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @stop_color.setter
    def stop_color(self, value:agcolor.Color) -> None:
        return self._intf.set_property(IAntennaContour._metadata, IAntennaContour._set_stop_color_metadata, value)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AntennaContourType),) }
    @property
    def type(self) -> "AntennaContourType":
        """Get the contour type."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_type_metadata)

    _get_levels_metadata = { "offset" : _get_levels_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def levels(self) -> "AntennaContourLevelCollection":
        """Get the collection of contour levels."""
        return self._intf.get_property(IAntennaContour._metadata, IAntennaContour._get_levels_metadata)

    _property_names[show_at_altitude] = "show_at_altitude"
    _property_names[altitude] = "altitude"
    _property_names[relative_to_maximum_gain] = "relative_to_maximum_gain"
    _property_names[show_labels] = "show_labels"
    _property_names[number_of_label_decimal_digits] = "number_of_label_decimal_digits"
    _property_names[line_width] = "line_width"
    _property_names[color_method] = "color_method"
    _property_names[start_color] = "start_color"
    _property_names[stop_color] = "stop_color"
    _property_names[type] = "type"
    _property_names[levels] = "levels"


agcls.AgClassCatalog.add_catalog_entry((5613976015755720505, 12727280771050595774), IAntennaContour)
agcls.AgTypeNameMap["IAntennaContour"] = IAntennaContour

class IAntennaBeamSelectionStrategy(object):
    """Provide access to a beam selection strategy."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5591626761758379284, 7060707251130740102),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAntennaBeamSelectionStrategy."""
        initialize_from_source_object(self, source_object, IAntennaBeamSelectionStrategy)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAntennaBeamSelectionStrategy)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAntennaBeamSelectionStrategy, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(BeamSelectionStrategyType),) }
    @property
    def type(self) -> "BeamSelectionStrategyType":
        """Get the beam selection strategy type."""
        return self._intf.get_property(IAntennaBeamSelectionStrategy._metadata, IAntennaBeamSelectionStrategy._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5591626761758379284, 7060707251130740102), IAntennaBeamSelectionStrategy)
agcls.AgTypeNameMap["IAntennaBeamSelectionStrategy"] = IAntennaBeamSelectionStrategy

class IAntennaBeam(object):
    """Provide access to an antenna beam."""

    _num_methods = 16
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_identifier_method_offset = 1
    _set_identifier_method_offset = 2
    _get_is_active_method_offset = 3
    _set_is_active_method_offset = 4
    _get_frequency_method_offset = 5
    _set_frequency_method_offset = 6
    _get_supported_antenna_models_method_offset = 7
    _get_antenna_model_name_method_offset = 8
    _set_antenna_model_name_method_offset = 9
    _get_antenna_model_method_offset = 10
    _get_orientation_method_offset = 11
    _set_orientation_method_offset = 12
    _get_enable_polarization_method_offset = 13
    _set_enable_polarization_method_offset = 14
    _set_polarization_type_method_offset = 15
    _get_polarization_method_offset = 16
    _metadata = {
        "iid_data" : (5354342656616650177, 907097282141540752),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAntennaBeam."""
        initialize_from_source_object(self, source_object, IAntennaBeam)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAntennaBeam)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAntennaBeam, None)

    _get_identifier_metadata = { "offset" : _get_identifier_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def identifier(self) -> str:
        """Get or set the antenna beam identifier."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_identifier_metadata)

    _set_identifier_metadata = { "offset" : _set_identifier_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @identifier.setter
    def identifier(self, value:str) -> None:
        return self._intf.set_property(IAntennaBeam._metadata, IAntennaBeam._set_identifier_metadata, value)

    _get_is_active_metadata = { "offset" : _get_is_active_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def is_active(self) -> bool:
        """Get or set the beam active flag."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_is_active_metadata)

    _set_is_active_metadata = { "offset" : _set_is_active_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @is_active.setter
    def is_active(self, value:bool) -> None:
        return self._intf.set_property(IAntennaBeam._metadata, IAntennaBeam._set_is_active_metadata, value)

    _get_frequency_metadata = { "offset" : _get_frequency_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def frequency(self) -> float:
        """Get or set the beam frequency."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_frequency_metadata)

    _set_frequency_metadata = { "offset" : _set_frequency_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @frequency.setter
    def frequency(self, value:float) -> None:
        return self._intf.set_property(IAntennaBeam._metadata, IAntennaBeam._set_frequency_metadata, value)

    _get_supported_antenna_models_metadata = { "offset" : _get_supported_antenna_models_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def supported_antenna_models(self) -> list:
        """Get an array of supported antenna model names."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_supported_antenna_models_metadata)

    _get_antenna_model_name_metadata = { "offset" : _get_antenna_model_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def antenna_model_name(self) -> str:
        """Get or set the current antenna model by name."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_antenna_model_name_metadata)

    _set_antenna_model_name_metadata = { "offset" : _set_antenna_model_name_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @antenna_model_name.setter
    def antenna_model_name(self, model_name:str) -> None:
        return self._intf.set_property(IAntennaBeam._metadata, IAntennaBeam._set_antenna_model_name_metadata, model_name)

    _get_antenna_model_metadata = { "offset" : _get_antenna_model_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def antenna_model(self) -> "IAntennaModel":
        """Get the current antenna model."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_antenna_model_metadata)

    _get_orientation_metadata = { "offset" : _get_orientation_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def orientation(self) -> "IOrientation":
        """Get the antenna orientation."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_orientation_metadata)

    _set_orientation_metadata = { "offset" : _set_orientation_method_offset,
            "arg_types" : (agcom.PVOID,),
            "marshallers" : (agmarshall.InterfaceInArg("IOrientation"),) }
    @orientation.setter
    def orientation(self, orientation:"IOrientation") -> None:
        """Set the antenna orientation."""
        return self._intf.set_property(IAntennaBeam._metadata, IAntennaBeam._set_orientation_metadata, orientation)

    _get_enable_polarization_metadata = { "offset" : _get_enable_polarization_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_polarization(self) -> bool:
        """Get or set the enable polarization option."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_enable_polarization_metadata)

    _set_enable_polarization_metadata = { "offset" : _set_enable_polarization_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_polarization.setter
    def enable_polarization(self, value:bool) -> None:
        return self._intf.set_property(IAntennaBeam._metadata, IAntennaBeam._set_enable_polarization_metadata, value)

    _set_polarization_type_metadata = { "offset" : _set_polarization_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(PolarizationType),) }
    def set_polarization_type(self, value:"PolarizationType") -> None:
        """Set the current polarization type."""
        return self._intf.invoke(IAntennaBeam._metadata, IAntennaBeam._set_polarization_type_metadata, value)

    _get_polarization_metadata = { "offset" : _get_polarization_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def polarization(self) -> "IPolarization":
        """Get the polarization."""
        return self._intf.get_property(IAntennaBeam._metadata, IAntennaBeam._get_polarization_metadata)

    _property_names[identifier] = "identifier"
    _property_names[is_active] = "is_active"
    _property_names[frequency] = "frequency"
    _property_names[supported_antenna_models] = "supported_antenna_models"
    _property_names[antenna_model_name] = "antenna_model_name"
    _property_names[antenna_model] = "antenna_model"
    _property_names[orientation] = "orientation"
    _property_names[enable_polarization] = "enable_polarization"
    _property_names[polarization] = "polarization"


agcls.AgClassCatalog.add_catalog_entry((5354342656616650177, 907097282141540752), IAntennaBeam)
agcls.AgTypeNameMap["IAntennaBeam"] = IAntennaBeam

class IRFFilterModel(object):
    """Provide access to the properties and methods defining an RF filter model."""

    _num_methods = 9
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _get_upper_bandwidth_limit_method_offset = 3
    _set_upper_bandwidth_limit_method_offset = 4
    _get_lower_bandwidth_limit_method_offset = 5
    _set_lower_bandwidth_limit_method_offset = 6
    _get_bandwidth_method_offset = 7
    _get_insertion_loss_method_offset = 8
    _set_insertion_loss_method_offset = 9
    _metadata = {
        "iid_data" : (4907294956379547208, 9786742639172018312),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRFFilterModel."""
        initialize_from_source_object(self, source_object, IRFFilterModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRFFilterModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRFFilterModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the filter model name."""
        return self._intf.get_property(IRFFilterModel._metadata, IRFFilterModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RFFilterModelType),) }
    @property
    def type(self) -> "RFFilterModelType":
        """Get the filter model type enumeration."""
        return self._intf.get_property(IRFFilterModel._metadata, IRFFilterModel._get_type_metadata)

    _get_upper_bandwidth_limit_metadata = { "offset" : _get_upper_bandwidth_limit_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def upper_bandwidth_limit(self) -> float:
        """Get or set the upper bandwidth limit."""
        return self._intf.get_property(IRFFilterModel._metadata, IRFFilterModel._get_upper_bandwidth_limit_metadata)

    _set_upper_bandwidth_limit_metadata = { "offset" : _set_upper_bandwidth_limit_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @upper_bandwidth_limit.setter
    def upper_bandwidth_limit(self, value:float) -> None:
        return self._intf.set_property(IRFFilterModel._metadata, IRFFilterModel._set_upper_bandwidth_limit_metadata, value)

    _get_lower_bandwidth_limit_metadata = { "offset" : _get_lower_bandwidth_limit_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def lower_bandwidth_limit(self) -> float:
        """Get or set the lower bandwidth limit."""
        return self._intf.get_property(IRFFilterModel._metadata, IRFFilterModel._get_lower_bandwidth_limit_metadata)

    _set_lower_bandwidth_limit_metadata = { "offset" : _set_lower_bandwidth_limit_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @lower_bandwidth_limit.setter
    def lower_bandwidth_limit(self, value:float) -> None:
        return self._intf.set_property(IRFFilterModel._metadata, IRFFilterModel._set_lower_bandwidth_limit_metadata, value)

    _get_bandwidth_metadata = { "offset" : _get_bandwidth_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def bandwidth(self) -> float:
        """Get the filter bandwidth."""
        return self._intf.get_property(IRFFilterModel._metadata, IRFFilterModel._get_bandwidth_metadata)

    _get_insertion_loss_metadata = { "offset" : _get_insertion_loss_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def insertion_loss(self) -> float:
        """Get or set the insertion loss."""
        return self._intf.get_property(IRFFilterModel._metadata, IRFFilterModel._get_insertion_loss_metadata)

    _set_insertion_loss_metadata = { "offset" : _set_insertion_loss_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @insertion_loss.setter
    def insertion_loss(self, value:float) -> None:
        return self._intf.set_property(IRFFilterModel._metadata, IRFFilterModel._set_insertion_loss_metadata, value)

    _property_names[name] = "name"
    _property_names[type] = "type"
    _property_names[upper_bandwidth_limit] = "upper_bandwidth_limit"
    _property_names[lower_bandwidth_limit] = "lower_bandwidth_limit"
    _property_names[bandwidth] = "bandwidth"
    _property_names[insertion_loss] = "insertion_loss"


agcls.AgClassCatalog.add_catalog_entry((4907294956379547208, 9786742639172018312), IRFFilterModel)
agcls.AgTypeNameMap["IRFFilterModel"] = IRFFilterModel

class IModulatorModel(object):
    """Provide access to the properties and methods defining a modulator model."""

    _num_methods = 21
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _get_enable_signal_psd_method_offset = 3
    _set_enable_signal_psd_method_offset = 4
    _get_psd_limit_multiplier_method_offset = 5
    _set_psd_limit_multiplier_method_offset = 6
    _get_enable_cdma_spread_method_offset = 7
    _set_enable_cdma_spread_method_offset = 8
    _get_chips_per_bit_method_offset = 9
    _set_chips_per_bit_method_offset = 10
    _get_spreading_gain_method_offset = 11
    _get_scale_bandwidth_automatically_method_offset = 12
    _set_scale_bandwidth_automatically_method_offset = 13
    _get_symmetric_bandwidth_method_offset = 14
    _set_symmetric_bandwidth_method_offset = 15
    _get_upper_bandwidth_limit_method_offset = 16
    _set_upper_bandwidth_limit_method_offset = 17
    _get_lower_bandwidth_limit_method_offset = 18
    _set_lower_bandwidth_limit_method_offset = 19
    _get_bandwidth_method_offset = 20
    _set_bandwidth_method_offset = 21
    _metadata = {
        "iid_data" : (5327966248334401329, 13464101353373673877),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IModulatorModel."""
        initialize_from_source_object(self, source_object, IModulatorModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IModulatorModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IModulatorModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the modulator model name."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ModulatorModelType),) }
    @property
    def type(self) -> "ModulatorModelType":
        """Get the modulator model type enumeration."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_type_metadata)

    _get_enable_signal_psd_metadata = { "offset" : _get_enable_signal_psd_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_signal_psd(self) -> bool:
        """Get or set the option for modeling signal PSD."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_enable_signal_psd_metadata)

    _set_enable_signal_psd_metadata = { "offset" : _set_enable_signal_psd_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_signal_psd.setter
    def enable_signal_psd(self, value:bool) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_enable_signal_psd_metadata, value)

    _get_psd_limit_multiplier_metadata = { "offset" : _get_psd_limit_multiplier_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def psd_limit_multiplier(self) -> int:
        """Get or set the PSD limit multiplier."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_psd_limit_multiplier_metadata)

    _set_psd_limit_multiplier_metadata = { "offset" : _set_psd_limit_multiplier_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @psd_limit_multiplier.setter
    def psd_limit_multiplier(self, value:int) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_psd_limit_multiplier_metadata, value)

    _get_enable_cdma_spread_metadata = { "offset" : _get_enable_cdma_spread_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_cdma_spread(self) -> bool:
        """Get or set the option for modeling CDMA spread."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_enable_cdma_spread_metadata)

    _set_enable_cdma_spread_metadata = { "offset" : _set_enable_cdma_spread_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_cdma_spread.setter
    def enable_cdma_spread(self, value:bool) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_enable_cdma_spread_metadata, value)

    _get_chips_per_bit_metadata = { "offset" : _get_chips_per_bit_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def chips_per_bit(self) -> int:
        """Get or set the chips per bit."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_chips_per_bit_metadata)

    _set_chips_per_bit_metadata = { "offset" : _set_chips_per_bit_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @chips_per_bit.setter
    def chips_per_bit(self, value:int) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_chips_per_bit_metadata, value)

    _get_spreading_gain_metadata = { "offset" : _get_spreading_gain_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def spreading_gain(self) -> float:
        """Get the spreading gain."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_spreading_gain_metadata)

    _get_scale_bandwidth_automatically_metadata = { "offset" : _get_scale_bandwidth_automatically_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def scale_bandwidth_automatically(self) -> bool:
        """Get or set the option for auto scaling the bandwidth."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_scale_bandwidth_automatically_metadata)

    _set_scale_bandwidth_automatically_metadata = { "offset" : _set_scale_bandwidth_automatically_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @scale_bandwidth_automatically.setter
    def scale_bandwidth_automatically(self, value:bool) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_scale_bandwidth_automatically_metadata, value)

    _get_symmetric_bandwidth_metadata = { "offset" : _get_symmetric_bandwidth_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def symmetric_bandwidth(self) -> bool:
        """Get or set the option for specifying symmetric bandwidth."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_symmetric_bandwidth_metadata)

    _set_symmetric_bandwidth_metadata = { "offset" : _set_symmetric_bandwidth_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @symmetric_bandwidth.setter
    def symmetric_bandwidth(self, value:bool) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_symmetric_bandwidth_metadata, value)

    _get_upper_bandwidth_limit_metadata = { "offset" : _get_upper_bandwidth_limit_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def upper_bandwidth_limit(self) -> float:
        """Get or set the upper bandwidth limit."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_upper_bandwidth_limit_metadata)

    _set_upper_bandwidth_limit_metadata = { "offset" : _set_upper_bandwidth_limit_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @upper_bandwidth_limit.setter
    def upper_bandwidth_limit(self, value:float) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_upper_bandwidth_limit_metadata, value)

    _get_lower_bandwidth_limit_metadata = { "offset" : _get_lower_bandwidth_limit_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def lower_bandwidth_limit(self) -> float:
        """Get or set the lower bandwidth limit."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_lower_bandwidth_limit_metadata)

    _set_lower_bandwidth_limit_metadata = { "offset" : _set_lower_bandwidth_limit_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @lower_bandwidth_limit.setter
    def lower_bandwidth_limit(self, value:float) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_lower_bandwidth_limit_metadata, value)

    _get_bandwidth_metadata = { "offset" : _get_bandwidth_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def bandwidth(self) -> float:
        """Get or set the filter bandwidth."""
        return self._intf.get_property(IModulatorModel._metadata, IModulatorModel._get_bandwidth_metadata)

    _set_bandwidth_metadata = { "offset" : _set_bandwidth_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @bandwidth.setter
    def bandwidth(self, value:float) -> None:
        return self._intf.set_property(IModulatorModel._metadata, IModulatorModel._set_bandwidth_metadata, value)

    _property_names[name] = "name"
    _property_names[type] = "type"
    _property_names[enable_signal_psd] = "enable_signal_psd"
    _property_names[psd_limit_multiplier] = "psd_limit_multiplier"
    _property_names[enable_cdma_spread] = "enable_cdma_spread"
    _property_names[chips_per_bit] = "chips_per_bit"
    _property_names[spreading_gain] = "spreading_gain"
    _property_names[scale_bandwidth_automatically] = "scale_bandwidth_automatically"
    _property_names[symmetric_bandwidth] = "symmetric_bandwidth"
    _property_names[upper_bandwidth_limit] = "upper_bandwidth_limit"
    _property_names[lower_bandwidth_limit] = "lower_bandwidth_limit"
    _property_names[bandwidth] = "bandwidth"


agcls.AgClassCatalog.add_catalog_entry((5327966248334401329, 13464101353373673877), IModulatorModel)
agcls.AgTypeNameMap["IModulatorModel"] = IModulatorModel

class ITransmitterModel(object):
    """Provide access to the properties and methods defining a transmitter model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5036050268365048800, 10293930725737946517),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ITransmitterModel."""
        initialize_from_source_object(self, source_object, ITransmitterModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ITransmitterModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ITransmitterModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the transmitter model name."""
        return self._intf.get_property(ITransmitterModel._metadata, ITransmitterModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(TransmitterModelType),) }
    @property
    def type(self) -> "TransmitterModelType":
        """Get the transmitter model type enumeration."""
        return self._intf.get_property(ITransmitterModel._metadata, ITransmitterModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5036050268365048800, 10293930725737946517), ITransmitterModel)
agcls.AgTypeNameMap["ITransmitterModel"] = ITransmitterModel

class ITransmitterModelScriptPlugin(object):
    """Provide access to the properties and methods defining a script plugin transmitter model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_filename_method_offset = 1
    _set_filename_method_offset = 2
    _metadata = {
        "iid_data" : (5724399052933185051, 15496035660765097359),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ITransmitterModelScriptPlugin."""
        initialize_from_source_object(self, source_object, ITransmitterModelScriptPlugin)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ITransmitterModelScriptPlugin)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ITransmitterModelScriptPlugin, None)

    _get_filename_metadata = { "offset" : _get_filename_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def filename(self) -> str:
        """Get or set the script plugin filename."""
        return self._intf.get_property(ITransmitterModelScriptPlugin._metadata, ITransmitterModelScriptPlugin._get_filename_metadata)

    _set_filename_metadata = { "offset" : _set_filename_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @filename.setter
    def filename(self, filename:str) -> None:
        return self._intf.set_property(ITransmitterModelScriptPlugin._metadata, ITransmitterModelScriptPlugin._set_filename_metadata, filename)

    _property_names[filename] = "filename"


agcls.AgClassCatalog.add_catalog_entry((5724399052933185051, 15496035660765097359), ITransmitterModelScriptPlugin)
agcls.AgTypeNameMap["ITransmitterModelScriptPlugin"] = ITransmitterModelScriptPlugin

class IReTransmitterModel(object):
    """Provide access to the properties and methods defining a re-transmitter model."""

    _num_methods = 19
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_frequency_transfer_function_polynomial_method_offset = 1
    _get_power_back_off_transfer_function_type_method_offset = 2
    _set_power_back_off_transfer_function_type_method_offset = 3
    _get_power_back_off_linear_scale_method_offset = 4
    _set_power_back_off_linear_scale_method_offset = 5
    _get_power_back_off_transfer_function_polynomial_method_offset = 6
    _get_power_back_off_transfer_function_table_method_offset = 7
    _get_enable_c_over_im_method_offset = 8
    _set_enable_c_over_im_method_offset = 9
    _get_c_over_im_transfer_function_type_method_offset = 10
    _set_c_over_im_transfer_function_type_method_offset = 11
    _get_c_over_im_linear_scale_method_offset = 12
    _set_c_over_im_linear_scale_method_offset = 13
    _get_c_over_im_transfer_function_polynomial_method_offset = 14
    _get_c_over_im_transfer_function_table_method_offset = 15
    _get_saturated_flux_density_method_offset = 16
    _set_saturated_flux_density_method_offset = 17
    _get_operational_mode_method_offset = 18
    _set_operational_mode_method_offset = 19
    _metadata = {
        "iid_data" : (5169917944113376101, 5744647544785366406),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IReTransmitterModel."""
        initialize_from_source_object(self, source_object, IReTransmitterModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IReTransmitterModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IReTransmitterModel, None)

    _get_frequency_transfer_function_polynomial_metadata = { "offset" : _get_frequency_transfer_function_polynomial_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def frequency_transfer_function_polynomial(self) -> "TransferFunctionPolynomialCollection":
        """Get the frequency transfer function polynomial collection."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_frequency_transfer_function_polynomial_metadata)

    _get_power_back_off_transfer_function_type_metadata = { "offset" : _get_power_back_off_transfer_function_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(TransferFunctionType),) }
    @property
    def power_back_off_transfer_function_type(self) -> "TransferFunctionType":
        """Get or set the power back off transfer function type."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_power_back_off_transfer_function_type_metadata)

    _set_power_back_off_transfer_function_type_metadata = { "offset" : _set_power_back_off_transfer_function_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(TransferFunctionType),) }
    @power_back_off_transfer_function_type.setter
    def power_back_off_transfer_function_type(self, value:"TransferFunctionType") -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_power_back_off_transfer_function_type_metadata, value)

    _get_power_back_off_linear_scale_metadata = { "offset" : _get_power_back_off_linear_scale_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def power_back_off_linear_scale(self) -> bool:
        """Get or set the option to enable power back off linear scale."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_power_back_off_linear_scale_metadata)

    _set_power_back_off_linear_scale_metadata = { "offset" : _set_power_back_off_linear_scale_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @power_back_off_linear_scale.setter
    def power_back_off_linear_scale(self, value:bool) -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_power_back_off_linear_scale_metadata, value)

    _get_power_back_off_transfer_function_polynomial_metadata = { "offset" : _get_power_back_off_transfer_function_polynomial_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def power_back_off_transfer_function_polynomial(self) -> "TransferFunctionPolynomialCollection":
        """Get the power back off transfer function polynomial collection."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_power_back_off_transfer_function_polynomial_metadata)

    _get_power_back_off_transfer_function_table_metadata = { "offset" : _get_power_back_off_transfer_function_table_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def power_back_off_transfer_function_table(self) -> "TransferFunctionInputBackOffOutputBackOffTable":
        """Get the power back off transfer function table."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_power_back_off_transfer_function_table_metadata)

    _get_enable_c_over_im_metadata = { "offset" : _get_enable_c_over_im_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_c_over_im(self) -> bool:
        """Get or set the option to enable C/Im."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_enable_c_over_im_metadata)

    _set_enable_c_over_im_metadata = { "offset" : _set_enable_c_over_im_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_c_over_im.setter
    def enable_c_over_im(self, value:bool) -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_enable_c_over_im_metadata, value)

    _get_c_over_im_transfer_function_type_metadata = { "offset" : _get_c_over_im_transfer_function_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(TransferFunctionType),) }
    @property
    def c_over_im_transfer_function_type(self) -> "TransferFunctionType":
        """Get or set the C/Im transfer function type."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_c_over_im_transfer_function_type_metadata)

    _set_c_over_im_transfer_function_type_metadata = { "offset" : _set_c_over_im_transfer_function_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(TransferFunctionType),) }
    @c_over_im_transfer_function_type.setter
    def c_over_im_transfer_function_type(self, value:"TransferFunctionType") -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_c_over_im_transfer_function_type_metadata, value)

    _get_c_over_im_linear_scale_metadata = { "offset" : _get_c_over_im_linear_scale_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def c_over_im_linear_scale(self) -> bool:
        """Get or set the option to enable C/Im linear scale."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_c_over_im_linear_scale_metadata)

    _set_c_over_im_linear_scale_metadata = { "offset" : _set_c_over_im_linear_scale_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @c_over_im_linear_scale.setter
    def c_over_im_linear_scale(self, value:bool) -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_c_over_im_linear_scale_metadata, value)

    _get_c_over_im_transfer_function_polynomial_metadata = { "offset" : _get_c_over_im_transfer_function_polynomial_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def c_over_im_transfer_function_polynomial(self) -> "TransferFunctionPolynomialCollection":
        """Get the C/Im transfer function polynomial collection."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_c_over_im_transfer_function_polynomial_metadata)

    _get_c_over_im_transfer_function_table_metadata = { "offset" : _get_c_over_im_transfer_function_table_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def c_over_im_transfer_function_table(self) -> "TransferFunctionInputBackOffVsCOverImTable":
        """Get the C/Im transfer function table."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_c_over_im_transfer_function_table_metadata)

    _get_saturated_flux_density_metadata = { "offset" : _get_saturated_flux_density_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def saturated_flux_density(self) -> float:
        """Get or set the saturated flux density."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_saturated_flux_density_metadata)

    _set_saturated_flux_density_metadata = { "offset" : _set_saturated_flux_density_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @saturated_flux_density.setter
    def saturated_flux_density(self, value:float) -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_saturated_flux_density_metadata, value)

    _get_operational_mode_metadata = { "offset" : _get_operational_mode_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ReTransmitterOpMode),) }
    @property
    def operational_mode(self) -> "ReTransmitterOpMode":
        """Get or set the operational mode."""
        return self._intf.get_property(IReTransmitterModel._metadata, IReTransmitterModel._get_operational_mode_metadata)

    _set_operational_mode_metadata = { "offset" : _set_operational_mode_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(ReTransmitterOpMode),) }
    @operational_mode.setter
    def operational_mode(self, value:"ReTransmitterOpMode") -> None:
        return self._intf.set_property(IReTransmitterModel._metadata, IReTransmitterModel._set_operational_mode_metadata, value)

    _property_names[frequency_transfer_function_polynomial] = "frequency_transfer_function_polynomial"
    _property_names[power_back_off_transfer_function_type] = "power_back_off_transfer_function_type"
    _property_names[power_back_off_linear_scale] = "power_back_off_linear_scale"
    _property_names[power_back_off_transfer_function_polynomial] = "power_back_off_transfer_function_polynomial"
    _property_names[power_back_off_transfer_function_table] = "power_back_off_transfer_function_table"
    _property_names[enable_c_over_im] = "enable_c_over_im"
    _property_names[c_over_im_transfer_function_type] = "c_over_im_transfer_function_type"
    _property_names[c_over_im_linear_scale] = "c_over_im_linear_scale"
    _property_names[c_over_im_transfer_function_polynomial] = "c_over_im_transfer_function_polynomial"
    _property_names[c_over_im_transfer_function_table] = "c_over_im_transfer_function_table"
    _property_names[saturated_flux_density] = "saturated_flux_density"
    _property_names[operational_mode] = "operational_mode"


agcls.AgClassCatalog.add_catalog_entry((5169917944113376101, 5744647544785366406), IReTransmitterModel)
agcls.AgTypeNameMap["IReTransmitterModel"] = IReTransmitterModel

class IDemodulatorModel(object):
    """Provide access to the properties and methods defining a demodulator model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5522501506257373046, 7120154331200164015),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IDemodulatorModel."""
        initialize_from_source_object(self, source_object, IDemodulatorModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IDemodulatorModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IDemodulatorModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the demodulator model name."""
        return self._intf.get_property(IDemodulatorModel._metadata, IDemodulatorModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(DemodulatorModelType),) }
    @property
    def type(self) -> "DemodulatorModelType":
        """Get the demodulator model type enumeration."""
        return self._intf.get_property(IDemodulatorModel._metadata, IDemodulatorModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5522501506257373046, 7120154331200164015), IDemodulatorModel)
agcls.AgTypeNameMap["IDemodulatorModel"] = IDemodulatorModel

class IReceiverModel(object):
    """Provide access to the properties and methods defining a receiver model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5030432353077524693, 13078406473886298541),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IReceiverModel."""
        initialize_from_source_object(self, source_object, IReceiverModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IReceiverModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IReceiverModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the receiver model name."""
        return self._intf.get_property(IReceiverModel._metadata, IReceiverModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ReceiverModelType),) }
    @property
    def type(self) -> "ReceiverModelType":
        """Get the receiver model type enumeration."""
        return self._intf.get_property(IReceiverModel._metadata, IReceiverModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5030432353077524693, 13078406473886298541), IReceiverModel)
agcls.AgTypeNameMap["IReceiverModel"] = IReceiverModel

class IReceiverModelScriptPlugin(object):
    """Provide access to the properties and methods defining a script plugin receiver model."""

    _num_methods = 3
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_filename_method_offset = 1
    _set_filename_method_offset = 2
    _get_link_margin_method_offset = 3
    _metadata = {
        "iid_data" : (4939806786916530743, 12745909696803957916),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IReceiverModelScriptPlugin."""
        initialize_from_source_object(self, source_object, IReceiverModelScriptPlugin)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IReceiverModelScriptPlugin)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IReceiverModelScriptPlugin, None)

    _get_filename_metadata = { "offset" : _get_filename_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def filename(self) -> str:
        """Get or set the script plugin filename."""
        return self._intf.get_property(IReceiverModelScriptPlugin._metadata, IReceiverModelScriptPlugin._get_filename_metadata)

    _set_filename_metadata = { "offset" : _set_filename_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @filename.setter
    def filename(self, filename:str) -> None:
        return self._intf.set_property(IReceiverModelScriptPlugin._metadata, IReceiverModelScriptPlugin._set_filename_metadata, filename)

    _get_link_margin_metadata = { "offset" : _get_link_margin_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def link_margin(self) -> "LinkMargin":
        """Get the interface for configuring the link margin computation parameters."""
        return self._intf.get_property(IReceiverModelScriptPlugin._metadata, IReceiverModelScriptPlugin._get_link_margin_metadata)

    _property_names[filename] = "filename"
    _property_names[link_margin] = "link_margin"


agcls.AgClassCatalog.add_catalog_entry((4939806786916530743, 12745909696803957916), IReceiverModelScriptPlugin)
agcls.AgTypeNameMap["IReceiverModelScriptPlugin"] = IReceiverModelScriptPlugin

class IRadarActivity(object):
    """Provide access to the properties and methods defining radar activity."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5673149103926043042, 9174540520485228417),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarActivity."""
        initialize_from_source_object(self, source_object, IRadarActivity)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarActivity)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarActivity, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarActivityType),) }
    @property
    def type(self) -> "RadarActivityType":
        """Get the activity times type."""
        return self._intf.get_property(IRadarActivity._metadata, IRadarActivity._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5673149103926043042, 9174540520485228417), IRadarActivity)
agcls.AgTypeNameMap["IRadarActivity"] = IRadarActivity

class IRadarSTCAttenuation(object):
    """Provide access to the properties and methods defining a radar STC attenuation."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _get_name_method_offset = 2
    _metadata = {
        "iid_data" : (4637318822904733215, 4654656499523741582),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarSTCAttenuation."""
        initialize_from_source_object(self, source_object, IRadarSTCAttenuation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarSTCAttenuation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarSTCAttenuation, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarSTCAttenuationType),) }
    @property
    def type(self) -> "RadarSTCAttenuationType":
        """Get the STC type."""
        return self._intf.get_property(IRadarSTCAttenuation._metadata, IRadarSTCAttenuation._get_type_metadata)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar STC string name."""
        return self._intf.get_property(IRadarSTCAttenuation._metadata, IRadarSTCAttenuation._get_name_metadata)

    _property_names[type] = "type"
    _property_names[name] = "name"


agcls.AgClassCatalog.add_catalog_entry((4637318822904733215, 4654656499523741582), IRadarSTCAttenuation)
agcls.AgTypeNameMap["IRadarSTCAttenuation"] = IRadarSTCAttenuation

class IRadarSTCAttenuationMap(object):
    """Provide access to the properties and methods defining a radar STC attenuation map."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_filename_method_offset = 1
    _set_filename_method_offset = 2
    _metadata = {
        "iid_data" : (5339880582747996706, 2107294806854631070),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarSTCAttenuationMap."""
        initialize_from_source_object(self, source_object, IRadarSTCAttenuationMap)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarSTCAttenuationMap)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarSTCAttenuationMap, None)

    _get_filename_metadata = { "offset" : _get_filename_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def filename(self) -> str:
        """Get or set the map filename."""
        return self._intf.get_property(IRadarSTCAttenuationMap._metadata, IRadarSTCAttenuationMap._get_filename_metadata)

    _set_filename_metadata = { "offset" : _set_filename_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @filename.setter
    def filename(self, value:str) -> None:
        return self._intf.set_property(IRadarSTCAttenuationMap._metadata, IRadarSTCAttenuationMap._set_filename_metadata, value)

    _property_names[filename] = "filename"


agcls.AgClassCatalog.add_catalog_entry((5339880582747996706, 2107294806854631070), IRadarSTCAttenuationMap)
agcls.AgTypeNameMap["IRadarSTCAttenuationMap"] = IRadarSTCAttenuationMap

class IRadarClutterGeometryModel(object):
    """Do not use this interface, as it is deprecated. Use IScatteringPointProvider interface instead. Provides access to the properties and methods defining a radar clutter geometry model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4780141874124802821, 16664795639668072616),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterGeometryModel."""
        initialize_from_source_object(self, source_object, IRadarClutterGeometryModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterGeometryModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterGeometryModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Do not use this property, as it is deprecated. Use Name on IScatteringPointProvider instead. Gets the radar clutter geometry model name."""
        return self._intf.get_property(IRadarClutterGeometryModel._metadata, IRadarClutterGeometryModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarClutterGeometryModelType),) }
    @property
    def type(self) -> "RadarClutterGeometryModelType":
        """Do not use this property, as it is deprecated. Use PointProviderType on IScatteringPointProvider instead. Gets the radar clutter geometry model type enumeration."""
        return self._intf.get_property(IRadarClutterGeometryModel._metadata, IRadarClutterGeometryModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4780141874124802821, 16664795639668072616), IRadarClutterGeometryModel)
agcls.AgTypeNameMap["IRadarClutterGeometryModel"] = IRadarClutterGeometryModel

class IRadarClutterGeometryModelPlugin(object):
    """Do not use this interface, as it is deprecated. Use ScatteringPointProviderPlugin interface instead. Provides access to the properties and methods defining a radar clutter geometry plugin model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_plugin_configuration_method_offset = 1
    _get_raw_plugin_object_method_offset = 2
    _metadata = {
        "iid_data" : (5413178837078390304, 15857632865236011159),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterGeometryModelPlugin."""
        initialize_from_source_object(self, source_object, IRadarClutterGeometryModelPlugin)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterGeometryModelPlugin)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterGeometryModelPlugin, None)

    _get_plugin_configuration_metadata = { "offset" : _get_plugin_configuration_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def plugin_configuration(self) -> "CommRadPluginConfiguration":
        """Do not use this property, as it is deprecated. Use PluginConfiguration on ScatteringPointProviderPlugin instead. Gets the plugin configuration interface."""
        return self._intf.get_property(IRadarClutterGeometryModelPlugin._metadata, IRadarClutterGeometryModelPlugin._get_plugin_configuration_metadata)

    _get_raw_plugin_object_metadata = { "offset" : _get_raw_plugin_object_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def raw_plugin_object(self) -> typing.Any:
        """Do not use this property, as it is deprecated. Use RawPluginObject on ScatteringPointProviderPlugin instead. Gets the raw plugin IUnknown interface."""
        return self._intf.get_property(IRadarClutterGeometryModelPlugin._metadata, IRadarClutterGeometryModelPlugin._get_raw_plugin_object_metadata)

    _property_names[plugin_configuration] = "plugin_configuration"
    _property_names[raw_plugin_object] = "raw_plugin_object"


agcls.AgClassCatalog.add_catalog_entry((5413178837078390304, 15857632865236011159), IRadarClutterGeometryModelPlugin)
agcls.AgTypeNameMap["IRadarClutterGeometryModelPlugin"] = IRadarClutterGeometryModelPlugin

class IRadarContinuousWaveAnalysisMode(object):
    """Interface which defines an continuous wave analysis."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5544844341919634966, 10734830335434562445),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarContinuousWaveAnalysisMode."""
        initialize_from_source_object(self, source_object, IRadarContinuousWaveAnalysisMode)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarContinuousWaveAnalysisMode)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarContinuousWaveAnalysisMode, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarContinuousWaveAnalysisMode),) }
    @property
    def type(self) -> "RadarContinuousWaveAnalysisMode":
        """Get the analysis type enumeration."""
        return self._intf.get_property(IRadarContinuousWaveAnalysisMode._metadata, IRadarContinuousWaveAnalysisMode._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5544844341919634966, 10734830335434562445), IRadarContinuousWaveAnalysisMode)
agcls.AgTypeNameMap["IRadarContinuousWaveAnalysisMode"] = IRadarContinuousWaveAnalysisMode

class IRadarPulseIntegration(object):
    """Interface which defines an integration method."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5447986119186401375, 10307065544363588263),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarPulseIntegration."""
        initialize_from_source_object(self, source_object, IRadarPulseIntegration)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarPulseIntegration)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarPulseIntegration, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarPulseIntegrationType),) }
    @property
    def type(self) -> "RadarPulseIntegrationType":
        """Get the waveform type enumeration."""
        return self._intf.get_property(IRadarPulseIntegration._metadata, IRadarPulseIntegration._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5447986119186401375, 10307065544363588263), IRadarPulseIntegration)
agcls.AgTypeNameMap["IRadarPulseIntegration"] = IRadarPulseIntegration

class IRadarWaveformSearchTrack(object):
    """Interface which is implemented by a search/track waveform."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5753753179627114310, 278545085356401816),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarWaveformSearchTrack."""
        initialize_from_source_object(self, source_object, IRadarWaveformSearchTrack)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarWaveformSearchTrack)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarWaveformSearchTrack, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarWaveformSearchTrackType),) }
    @property
    def type(self) -> "RadarWaveformSearchTrackType":
        """Get the waveform type enumeration."""
        return self._intf.get_property(IRadarWaveformSearchTrack._metadata, IRadarWaveformSearchTrack._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5753753179627114310, 278545085356401816), IRadarWaveformSearchTrack)
agcls.AgTypeNameMap["IRadarWaveformSearchTrack"] = IRadarWaveformSearchTrack

class IRadarProbabilityOfDetection(object):
    """Provide access to the properties and methods for configuring probability of detection parameters."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5189198921495265684, 7977279480523186580),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarProbabilityOfDetection."""
        initialize_from_source_object(self, source_object, IRadarProbabilityOfDetection)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarProbabilityOfDetection)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarProbabilityOfDetection, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the probability of detection algorithm name."""
        return self._intf.get_property(IRadarProbabilityOfDetection._metadata, IRadarProbabilityOfDetection._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarProbabilityOfDetectionType),) }
    @property
    def type(self) -> "RadarProbabilityOfDetectionType":
        """Get the probability of detection type."""
        return self._intf.get_property(IRadarProbabilityOfDetection._metadata, IRadarProbabilityOfDetection._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5189198921495265684, 7977279480523186580), IRadarProbabilityOfDetection)
agcls.AgTypeNameMap["IRadarProbabilityOfDetection"] = IRadarProbabilityOfDetection

class IRadarProbabilityOfDetectionCFAR(object):
    """Provide access to the properties and methods for configuring probability of detection parameters."""

    _num_methods = 4
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_probability_of_false_alarm_method_offset = 1
    _set_probability_of_false_alarm_method_offset = 2
    _get_number_of_cfar_reference_cells_method_offset = 3
    _set_number_of_cfar_reference_cells_method_offset = 4
    _metadata = {
        "iid_data" : (4986222255691422839, 12453471900594749348),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarProbabilityOfDetectionCFAR."""
        initialize_from_source_object(self, source_object, IRadarProbabilityOfDetectionCFAR)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarProbabilityOfDetectionCFAR)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarProbabilityOfDetectionCFAR, None)

    _get_probability_of_false_alarm_metadata = { "offset" : _get_probability_of_false_alarm_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def probability_of_false_alarm(self) -> float:
        """Get or set the probability of false alarm."""
        return self._intf.get_property(IRadarProbabilityOfDetectionCFAR._metadata, IRadarProbabilityOfDetectionCFAR._get_probability_of_false_alarm_metadata)

    _set_probability_of_false_alarm_metadata = { "offset" : _set_probability_of_false_alarm_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @probability_of_false_alarm.setter
    def probability_of_false_alarm(self, value:float) -> None:
        return self._intf.set_property(IRadarProbabilityOfDetectionCFAR._metadata, IRadarProbabilityOfDetectionCFAR._set_probability_of_false_alarm_metadata, value)

    _get_number_of_cfar_reference_cells_metadata = { "offset" : _get_number_of_cfar_reference_cells_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def number_of_cfar_reference_cells(self) -> int:
        """Get or set the number of CFAR reference cells."""
        return self._intf.get_property(IRadarProbabilityOfDetectionCFAR._metadata, IRadarProbabilityOfDetectionCFAR._get_number_of_cfar_reference_cells_metadata)

    _set_number_of_cfar_reference_cells_metadata = { "offset" : _set_number_of_cfar_reference_cells_method_offset,
            "arg_types" : (agcom.INT,),
            "marshallers" : (agmarshall.IntArg,) }
    @number_of_cfar_reference_cells.setter
    def number_of_cfar_reference_cells(self, value:int) -> None:
        return self._intf.set_property(IRadarProbabilityOfDetectionCFAR._metadata, IRadarProbabilityOfDetectionCFAR._set_number_of_cfar_reference_cells_metadata, value)

    _property_names[probability_of_false_alarm] = "probability_of_false_alarm"
    _property_names[number_of_cfar_reference_cells] = "number_of_cfar_reference_cells"


agcls.AgClassCatalog.add_catalog_entry((4986222255691422839, 12453471900594749348), IRadarProbabilityOfDetectionCFAR)
agcls.AgTypeNameMap["IRadarProbabilityOfDetectionCFAR"] = IRadarProbabilityOfDetectionCFAR

class IRadarModel(object):
    """Provide access to the properties and methods defining a radar model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5418642130520373873, 16084217176399402660),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarModel."""
        initialize_from_source_object(self, source_object, IRadarModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar model name."""
        return self._intf.get_property(IRadarModel._metadata, IRadarModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarModelType),) }
    @property
    def type(self) -> "RadarModelType":
        """Get the radar model type enumeration."""
        return self._intf.get_property(IRadarModel._metadata, IRadarModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5418642130520373873, 16084217176399402660), IRadarModel)
agcls.AgTypeNameMap["IRadarModel"] = IRadarModel

class IRadarModeMonostatic(object):
    """Provide access to the properties and methods defining a monostatic mode."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4970187702558133423, 12901576956408262036),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarModeMonostatic."""
        initialize_from_source_object(self, source_object, IRadarModeMonostatic)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarModeMonostatic)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarModeMonostatic, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar mode name."""
        return self._intf.get_property(IRadarModeMonostatic._metadata, IRadarModeMonostatic._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarMode),) }
    @property
    def type(self) -> "RadarMode":
        """Get the radar mode type enumeration."""
        return self._intf.get_property(IRadarModeMonostatic._metadata, IRadarModeMonostatic._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4970187702558133423, 12901576956408262036), IRadarModeMonostatic)
agcls.AgTypeNameMap["IRadarModeMonostatic"] = IRadarModeMonostatic

class IRadarModeBistaticTransmitter(object):
    """Provide access to the properties and methods defining a bistatic transmitter mode."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4908438291715703619, 13162977304684557480),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarModeBistaticTransmitter."""
        initialize_from_source_object(self, source_object, IRadarModeBistaticTransmitter)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarModeBistaticTransmitter)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarModeBistaticTransmitter, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar mode name."""
        return self._intf.get_property(IRadarModeBistaticTransmitter._metadata, IRadarModeBistaticTransmitter._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarMode),) }
    @property
    def type(self) -> "RadarMode":
        """Get the radar mode type enumeration."""
        return self._intf.get_property(IRadarModeBistaticTransmitter._metadata, IRadarModeBistaticTransmitter._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4908438291715703619, 13162977304684557480), IRadarModeBistaticTransmitter)
agcls.AgTypeNameMap["IRadarModeBistaticTransmitter"] = IRadarModeBistaticTransmitter

class IRadarModeBistaticReceiver(object):
    """Provide access to the properties and methods defining a bistatic receiver mode."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5331367138186186022, 506597589450112659),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarModeBistaticReceiver."""
        initialize_from_source_object(self, source_object, IRadarModeBistaticReceiver)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarModeBistaticReceiver)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarModeBistaticReceiver, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar mode name."""
        return self._intf.get_property(IRadarModeBistaticReceiver._metadata, IRadarModeBistaticReceiver._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarMode),) }
    @property
    def type(self) -> "RadarMode":
        """Get the radar mode type enumeration."""
        return self._intf.get_property(IRadarModeBistaticReceiver._metadata, IRadarModeBistaticReceiver._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5331367138186186022, 506597589450112659), IRadarModeBistaticReceiver)
agcls.AgTypeNameMap["IRadarModeBistaticReceiver"] = IRadarModeBistaticReceiver

class IRadarClutterMapModel(object):
    """Do not use this interface, as it is deprecated. Use IScatteringPointModel interface instead. Provides access to the properties and methods defining a radar clutter map model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4867807712446108131, 12387101423791785602),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterMapModel."""
        initialize_from_source_object(self, source_object, IRadarClutterMapModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterMapModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterMapModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Do not use this property, as it is deprecated. Use Name on IScatteringPointModel instead. Gets the radar clutter map model name."""
        return self._intf.get_property(IRadarClutterMapModel._metadata, IRadarClutterMapModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RadarClutterMapModelType),) }
    @property
    def type(self) -> "RadarClutterMapModelType":
        """Do not use this property, as it is deprecated. Use Type on IScatteringPointModel instead. Gets the radar clutter map model type enumeration."""
        return self._intf.get_property(IRadarClutterMapModel._metadata, IRadarClutterMapModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4867807712446108131, 12387101423791785602), IRadarClutterMapModel)
agcls.AgTypeNameMap["IRadarClutterMapModel"] = IRadarClutterMapModel

class IRadarClutterMapModelPlugin(object):
    """Do not use this interface, as it is deprecated. Use ScatteringPointModelPlugin interface instead. Provides access to the properties and methods defining a radar clutter map plugin model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_plugin_configuration_method_offset = 1
    _get_raw_plugin_object_method_offset = 2
    _metadata = {
        "iid_data" : (5031692082348415792, 11922441730988338606),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterMapModelPlugin."""
        initialize_from_source_object(self, source_object, IRadarClutterMapModelPlugin)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterMapModelPlugin)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterMapModelPlugin, None)

    _get_plugin_configuration_metadata = { "offset" : _get_plugin_configuration_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def plugin_configuration(self) -> "CommRadPluginConfiguration":
        """Do not use this property, as it is deprecated. Use PluginConfiguration on ScatteringPointModelPlugin instead. Gets the plugin configuration interface."""
        return self._intf.get_property(IRadarClutterMapModelPlugin._metadata, IRadarClutterMapModelPlugin._get_plugin_configuration_metadata)

    _get_raw_plugin_object_metadata = { "offset" : _get_raw_plugin_object_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def raw_plugin_object(self) -> typing.Any:
        """Do not use this property, as it is deprecated. Use RawPluginObject on ScatteringPointModelPlugin instead. Gets the raw plugin IUnknown interface."""
        return self._intf.get_property(IRadarClutterMapModelPlugin._metadata, IRadarClutterMapModelPlugin._get_raw_plugin_object_metadata)

    _property_names[plugin_configuration] = "plugin_configuration"
    _property_names[raw_plugin_object] = "raw_plugin_object"


agcls.AgClassCatalog.add_catalog_entry((5031692082348415792, 11922441730988338606), IRadarClutterMapModelPlugin)
agcls.AgTypeNameMap["IRadarClutterMapModelPlugin"] = IRadarClutterMapModelPlugin

class IRadarClutterMapModelConstantCoefficient(object):
    """Do not use this interface, as it is deprecated. Use ScatteringPointModelConstantCoefficient interface instead. Provides access to the properties and methods defining a radar clutter map constant coefficient model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_constant_coefficient_method_offset = 1
    _set_constant_coefficient_method_offset = 2
    _metadata = {
        "iid_data" : (4936125184131881973, 17663348557034948027),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarClutterMapModelConstantCoefficient."""
        initialize_from_source_object(self, source_object, IRadarClutterMapModelConstantCoefficient)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarClutterMapModelConstantCoefficient)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarClutterMapModelConstantCoefficient, None)

    _get_constant_coefficient_metadata = { "offset" : _get_constant_coefficient_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def constant_coefficient(self) -> float:
        """Do not use this property, as it is deprecated. Use ConstantCoefficient on ScatteringPointModelConstantCoefficient instead. Gets the constant coefficient value."""
        return self._intf.get_property(IRadarClutterMapModelConstantCoefficient._metadata, IRadarClutterMapModelConstantCoefficient._get_constant_coefficient_metadata)

    _set_constant_coefficient_metadata = { "offset" : _set_constant_coefficient_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @constant_coefficient.setter
    def constant_coefficient(self, value:float) -> None:
        return self._intf.set_property(IRadarClutterMapModelConstantCoefficient._metadata, IRadarClutterMapModelConstantCoefficient._set_constant_coefficient_metadata, value)

    _property_names[constant_coefficient] = "constant_coefficient"


agcls.AgClassCatalog.add_catalog_entry((4936125184131881973, 17663348557034948027), IRadarClutterMapModelConstantCoefficient)
agcls.AgTypeNameMap["IRadarClutterMapModelConstantCoefficient"] = IRadarClutterMapModelConstantCoefficient

class IRadarCrossSectionComputeStrategy(object):
    """Provide access to the properties and methods defining a radar cross section compute Strategy."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5710528816396277778, 13397989219346869431),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRadarCrossSectionComputeStrategy."""
        initialize_from_source_object(self, source_object, IRadarCrossSectionComputeStrategy)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRadarCrossSectionComputeStrategy)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRadarCrossSectionComputeStrategy, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the radar cross section compute strategy name."""
        return self._intf.get_property(IRadarCrossSectionComputeStrategy._metadata, IRadarCrossSectionComputeStrategy._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RCSComputeStrategy),) }
    @property
    def type(self) -> "RCSComputeStrategy":
        """Get the radar cross section compute strategy enumeration."""
        return self._intf.get_property(IRadarCrossSectionComputeStrategy._metadata, IRadarCrossSectionComputeStrategy._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5710528816396277778, 13397989219346869431), IRadarCrossSectionComputeStrategy)
agcls.AgTypeNameMap["IRadarCrossSectionComputeStrategy"] = IRadarCrossSectionComputeStrategy

class IModulatorModelScriptPlugin(object):
    """Provide access to the properties and methods defining an script plugin modulator model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_filename_method_offset = 1
    _set_filename_method_offset = 2
    _metadata = {
        "iid_data" : (5073384229586334400, 241928354667072433),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IModulatorModelScriptPlugin."""
        initialize_from_source_object(self, source_object, IModulatorModelScriptPlugin)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IModulatorModelScriptPlugin)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IModulatorModelScriptPlugin, None)

    _get_filename_metadata = { "offset" : _get_filename_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def filename(self) -> str:
        """Get or set the external filename."""
        return self._intf.get_property(IModulatorModelScriptPlugin._metadata, IModulatorModelScriptPlugin._get_filename_metadata)

    _set_filename_metadata = { "offset" : _set_filename_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @filename.setter
    def filename(self, value:str) -> None:
        return self._intf.set_property(IModulatorModelScriptPlugin._metadata, IModulatorModelScriptPlugin._set_filename_metadata, value)

    _property_names[filename] = "filename"


agcls.AgClassCatalog.add_catalog_entry((5073384229586334400, 241928354667072433), IModulatorModelScriptPlugin)
agcls.AgTypeNameMap["IModulatorModelScriptPlugin"] = IModulatorModelScriptPlugin

class IRainLossModel(object):
    """Provide access to the properties and methods a rain loss model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4903217322202960801, 14250600675292157853),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IRainLossModel."""
        initialize_from_source_object(self, source_object, IRainLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IRainLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IRainLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the rain loss model name."""
        return self._intf.get_property(IRainLossModel._metadata, IRainLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(RainLossModelType),) }
    @property
    def type(self) -> "RainLossModelType":
        """Get the rain loss model type enumeration."""
        return self._intf.get_property(IRainLossModel._metadata, IRainLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4903217322202960801, 14250600675292157853), IRainLossModel)
agcls.AgTypeNameMap["IRainLossModel"] = IRainLossModel

class IUrbanTerrestrialLossModel(object):
    """Provide access to the properties and methods for an urban/terrestrial loss model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4761953284863665641, 18179120095316283294),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IUrbanTerrestrialLossModel."""
        initialize_from_source_object(self, source_object, IUrbanTerrestrialLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IUrbanTerrestrialLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IUrbanTerrestrialLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the Urban Terrestrial loss model name."""
        return self._intf.get_property(IUrbanTerrestrialLossModel._metadata, IUrbanTerrestrialLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(UrbanTerrestrialLossModelType),) }
    @property
    def type(self) -> "UrbanTerrestrialLossModelType":
        """Get the Urban Terrestrial loss model type enumeration."""
        return self._intf.get_property(IUrbanTerrestrialLossModel._metadata, IUrbanTerrestrialLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4761953284863665641, 18179120095316283294), IUrbanTerrestrialLossModel)
agcls.AgTypeNameMap["IUrbanTerrestrialLossModel"] = IUrbanTerrestrialLossModel

class ITroposphericScintillationFadingLossModel(object):
    """Provide access to the properties and methods for a TropoSpheric Scintillation Fading loss model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5208680887154461530, 2261905771175173548),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ITroposphericScintillationFadingLossModel."""
        initialize_from_source_object(self, source_object, ITroposphericScintillationFadingLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ITroposphericScintillationFadingLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ITroposphericScintillationFadingLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the TropoSpheric Scintillation Fading loss model name."""
        return self._intf.get_property(ITroposphericScintillationFadingLossModel._metadata, ITroposphericScintillationFadingLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(TroposphericScintillationFadingLossModelType),) }
    @property
    def type(self) -> "TroposphericScintillationFadingLossModelType":
        """Get the TropoSpheric Scintillation Fading loss model type enumeration."""
        return self._intf.get_property(ITroposphericScintillationFadingLossModel._metadata, ITroposphericScintillationFadingLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5208680887154461530, 2261905771175173548), ITroposphericScintillationFadingLossModel)
agcls.AgTypeNameMap["ITroposphericScintillationFadingLossModel"] = ITroposphericScintillationFadingLossModel

class IIonosphericFadingLossModel(object):
    """Provide access to the properties and methods for an Ionospheric Fading loss model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5501767177780066856, 6554038788432725376),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IIonosphericFadingLossModel."""
        initialize_from_source_object(self, source_object, IIonosphericFadingLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IIonosphericFadingLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IIonosphericFadingLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the IonoSpheric Fading loss model name."""
        return self._intf.get_property(IIonosphericFadingLossModel._metadata, IIonosphericFadingLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(IonosphericFadingLossModelType),) }
    @property
    def type(self) -> "IonosphericFadingLossModelType":
        """Get the IonoSpheric Fading loss model type enumeration."""
        return self._intf.get_property(IIonosphericFadingLossModel._metadata, IIonosphericFadingLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5501767177780066856, 6554038788432725376), IIonosphericFadingLossModel)
agcls.AgTypeNameMap["IIonosphericFadingLossModel"] = IIonosphericFadingLossModel

class ICloudsAndFogFadingLossModel(object):
    """Provide access to the properties and methods for Clouds and Fog loss models."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5611568552580796800, 533580683375654285),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICloudsAndFogFadingLossModel."""
        initialize_from_source_object(self, source_object, ICloudsAndFogFadingLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICloudsAndFogFadingLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICloudsAndFogFadingLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the Clouds and Fog loss model name."""
        return self._intf.get_property(ICloudsAndFogFadingLossModel._metadata, ICloudsAndFogFadingLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(CloudsAndFogFadingLossModelType),) }
    @property
    def type(self) -> "CloudsAndFogFadingLossModelType":
        """Get the Clouds and Fog loss model type enumeration."""
        return self._intf.get_property(ICloudsAndFogFadingLossModel._metadata, ICloudsAndFogFadingLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5611568552580796800, 533580683375654285), ICloudsAndFogFadingLossModel)
agcls.AgTypeNameMap["ICloudsAndFogFadingLossModel"] = ICloudsAndFogFadingLossModel

class IAtmosphericAbsorptionModel(object):
    """Provide access to the properties and methods an atmospheric absorption model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (4639354891994271970, 8676637918239658657),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAtmosphericAbsorptionModel."""
        initialize_from_source_object(self, source_object, IAtmosphericAbsorptionModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAtmosphericAbsorptionModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAtmosphericAbsorptionModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the atmospheric absorption model name."""
        return self._intf.get_property(IAtmosphericAbsorptionModel._metadata, IAtmosphericAbsorptionModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AtmosphericAbsorptionModelType),) }
    @property
    def type(self) -> "AtmosphericAbsorptionModelType":
        """Get the atmospheric absorption model type enumeration."""
        return self._intf.get_property(IAtmosphericAbsorptionModel._metadata, IAtmosphericAbsorptionModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4639354891994271970, 8676637918239658657), IAtmosphericAbsorptionModel)
agcls.AgTypeNameMap["IAtmosphericAbsorptionModel"] = IAtmosphericAbsorptionModel

class IAtmosphericAbsorptionModelITURP676(object):
    """Provide access to the properties and methods of the ITU-R P676 atmospheric absorption model."""

    _num_methods = 4
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_fast_approximation_method_method_offset = 1
    _set_fast_approximation_method_method_offset = 2
    _get_seasonal_regional_method_method_offset = 3
    _set_seasonal_regional_method_method_offset = 4
    _metadata = {
        "iid_data" : (5038272657251594510, 10434970451019938704),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAtmosphericAbsorptionModelITURP676."""
        initialize_from_source_object(self, source_object, IAtmosphericAbsorptionModelITURP676)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAtmosphericAbsorptionModelITURP676)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAtmosphericAbsorptionModelITURP676, None)

    _get_fast_approximation_method_metadata = { "offset" : _get_fast_approximation_method_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def fast_approximation_method(self) -> bool:
        """Get or set the option for using the fast approximation method."""
        return self._intf.get_property(IAtmosphericAbsorptionModelITURP676._metadata, IAtmosphericAbsorptionModelITURP676._get_fast_approximation_method_metadata)

    _set_fast_approximation_method_metadata = { "offset" : _set_fast_approximation_method_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @fast_approximation_method.setter
    def fast_approximation_method(self, value:bool) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelITURP676._metadata, IAtmosphericAbsorptionModelITURP676._set_fast_approximation_method_metadata, value)

    _get_seasonal_regional_method_metadata = { "offset" : _get_seasonal_regional_method_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def seasonal_regional_method(self) -> bool:
        """Get or set the option for using the seasonal/regional method."""
        return self._intf.get_property(IAtmosphericAbsorptionModelITURP676._metadata, IAtmosphericAbsorptionModelITURP676._get_seasonal_regional_method_metadata)

    _set_seasonal_regional_method_metadata = { "offset" : _set_seasonal_regional_method_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @seasonal_regional_method.setter
    def seasonal_regional_method(self, value:bool) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelITURP676._metadata, IAtmosphericAbsorptionModelITURP676._set_seasonal_regional_method_metadata, value)

    _property_names[fast_approximation_method] = "fast_approximation_method"
    _property_names[seasonal_regional_method] = "seasonal_regional_method"


agcls.AgClassCatalog.add_catalog_entry((5038272657251594510, 10434970451019938704), IAtmosphericAbsorptionModelITURP676)
agcls.AgTypeNameMap["IAtmosphericAbsorptionModelITURP676"] = IAtmosphericAbsorptionModelITURP676

class IAtmosphericAbsorptionModelTIREM(object):
    """Provide access to the properties and methods of the TIREM atmospheric absorption model."""

    _num_methods = 16
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_surface_temperature_method_offset = 1
    _set_surface_temperature_method_offset = 2
    _get_surface_humidity_method_offset = 3
    _set_surface_humidity_method_offset = 4
    _get_surface_conductivity_method_offset = 5
    _set_surface_conductivity_method_offset = 6
    _get_surface_refractivity_method_offset = 7
    _set_surface_refractivity_method_offset = 8
    _get_relative_permittivity_method_offset = 9
    _set_relative_permittivity_method_offset = 10
    _get_override_terrain_sample_resolution_method_offset = 11
    _set_override_terrain_sample_resolution_method_offset = 12
    _get_terrain_sample_resolution_method_offset = 13
    _set_terrain_sample_resolution_method_offset = 14
    _get_polarization_type_method_offset = 15
    _set_polarization_type_method_offset = 16
    _metadata = {
        "iid_data" : (5274156196296289459, 6922873188154417292),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAtmosphericAbsorptionModelTIREM."""
        initialize_from_source_object(self, source_object, IAtmosphericAbsorptionModelTIREM)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAtmosphericAbsorptionModelTIREM)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAtmosphericAbsorptionModelTIREM, None)

    _get_surface_temperature_metadata = { "offset" : _get_surface_temperature_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def surface_temperature(self) -> float:
        """Get or set the surface temperature."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_surface_temperature_metadata)

    _set_surface_temperature_metadata = { "offset" : _set_surface_temperature_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @surface_temperature.setter
    def surface_temperature(self, value:float) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_surface_temperature_metadata, value)

    _get_surface_humidity_metadata = { "offset" : _get_surface_humidity_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def surface_humidity(self) -> float:
        """Get or set the surface humidity."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_surface_humidity_metadata)

    _set_surface_humidity_metadata = { "offset" : _set_surface_humidity_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @surface_humidity.setter
    def surface_humidity(self, value:float) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_surface_humidity_metadata, value)

    _get_surface_conductivity_metadata = { "offset" : _get_surface_conductivity_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def surface_conductivity(self) -> float:
        """Get or set the surface conductivity."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_surface_conductivity_metadata)

    _set_surface_conductivity_metadata = { "offset" : _set_surface_conductivity_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @surface_conductivity.setter
    def surface_conductivity(self, value:float) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_surface_conductivity_metadata, value)

    _get_surface_refractivity_metadata = { "offset" : _get_surface_refractivity_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def surface_refractivity(self) -> float:
        """Get or set the surface refractivity."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_surface_refractivity_metadata)

    _set_surface_refractivity_metadata = { "offset" : _set_surface_refractivity_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @surface_refractivity.setter
    def surface_refractivity(self, value:float) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_surface_refractivity_metadata, value)

    _get_relative_permittivity_metadata = { "offset" : _get_relative_permittivity_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def relative_permittivity(self) -> float:
        """Get or set the relative permittivity."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_relative_permittivity_metadata)

    _set_relative_permittivity_metadata = { "offset" : _set_relative_permittivity_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @relative_permittivity.setter
    def relative_permittivity(self, value:float) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_relative_permittivity_metadata, value)

    _get_override_terrain_sample_resolution_metadata = { "offset" : _get_override_terrain_sample_resolution_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def override_terrain_sample_resolution(self) -> bool:
        """Get or set the option for overriding available terrain sample resolution."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_override_terrain_sample_resolution_metadata)

    _set_override_terrain_sample_resolution_metadata = { "offset" : _set_override_terrain_sample_resolution_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @override_terrain_sample_resolution.setter
    def override_terrain_sample_resolution(self, value:bool) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_override_terrain_sample_resolution_metadata, value)

    _get_terrain_sample_resolution_metadata = { "offset" : _get_terrain_sample_resolution_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def terrain_sample_resolution(self) -> float:
        """Get or set the terrain sample resolution."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_terrain_sample_resolution_metadata)

    _set_terrain_sample_resolution_metadata = { "offset" : _set_terrain_sample_resolution_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @terrain_sample_resolution.setter
    def terrain_sample_resolution(self, value:float) -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_terrain_sample_resolution_metadata, value)

    _get_polarization_type_metadata = { "offset" : _get_polarization_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(TIREMPolarizationType),) }
    @property
    def polarization_type(self) -> "TIREMPolarizationType":
        """Get or set the polarization type."""
        return self._intf.get_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._get_polarization_type_metadata)

    _set_polarization_type_metadata = { "offset" : _set_polarization_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(TIREMPolarizationType),) }
    @polarization_type.setter
    def polarization_type(self, value:"TIREMPolarizationType") -> None:
        return self._intf.set_property(IAtmosphericAbsorptionModelTIREM._metadata, IAtmosphericAbsorptionModelTIREM._set_polarization_type_metadata, value)

    _property_names[surface_temperature] = "surface_temperature"
    _property_names[surface_humidity] = "surface_humidity"
    _property_names[surface_conductivity] = "surface_conductivity"
    _property_names[surface_refractivity] = "surface_refractivity"
    _property_names[relative_permittivity] = "relative_permittivity"
    _property_names[override_terrain_sample_resolution] = "override_terrain_sample_resolution"
    _property_names[terrain_sample_resolution] = "terrain_sample_resolution"
    _property_names[polarization_type] = "polarization_type"


agcls.AgClassCatalog.add_catalog_entry((5274156196296289459, 6922873188154417292), IAtmosphericAbsorptionModelTIREM)
agcls.AgTypeNameMap["IAtmosphericAbsorptionModelTIREM"] = IAtmosphericAbsorptionModelTIREM

class ISolarActivityConfiguration(object):
    """Provide access to the properties and methods defining the solar activity configuration."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (4933389110832147333, 11535893757759372938),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISolarActivityConfiguration."""
        initialize_from_source_object(self, source_object, ISolarActivityConfiguration)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISolarActivityConfiguration)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISolarActivityConfiguration, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(Graphics3DACAPSolarActivityConfigurationType),) }
    @property
    def type(self) -> "Graphics3DACAPSolarActivityConfigurationType":
        """Get the solar activity configuration enumeration."""
        return self._intf.get_property(ISolarActivityConfiguration._metadata, ISolarActivityConfiguration._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4933389110832147333, 11535893757759372938), ISolarActivityConfiguration)
agcls.AgTypeNameMap["ISolarActivityConfiguration"] = ISolarActivityConfiguration

class ILaserAtmosphericLossModel(object):
    """Provide access to the properties and methods for a laser atmospheric absorption loss model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5377332082888097657, 3475573334162558896),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ILaserAtmosphericLossModel."""
        initialize_from_source_object(self, source_object, ILaserAtmosphericLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ILaserAtmosphericLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ILaserAtmosphericLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the model name."""
        return self._intf.get_property(ILaserAtmosphericLossModel._metadata, ILaserAtmosphericLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(LaserPropagationLossModelType),) }
    @property
    def type(self) -> "LaserPropagationLossModelType":
        """Get the model type enumeration."""
        return self._intf.get_property(ILaserAtmosphericLossModel._metadata, ILaserAtmosphericLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5377332082888097657, 3475573334162558896), ILaserAtmosphericLossModel)
agcls.AgTypeNameMap["ILaserAtmosphericLossModel"] = ILaserAtmosphericLossModel

class ILaserTroposphericScintillationLossModel(object):
    """Provide access to the properties and methods for a laser tropospheric scintillation loss model."""

    _num_methods = 2
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_name_method_offset = 1
    _get_type_method_offset = 2
    _metadata = {
        "iid_data" : (5619117213023705426, 16106002562257095815),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ILaserTroposphericScintillationLossModel."""
        initialize_from_source_object(self, source_object, ILaserTroposphericScintillationLossModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ILaserTroposphericScintillationLossModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ILaserTroposphericScintillationLossModel, None)

    _get_name_metadata = { "offset" : _get_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def name(self) -> str:
        """Get the model name."""
        return self._intf.get_property(ILaserTroposphericScintillationLossModel._metadata, ILaserTroposphericScintillationLossModel._get_name_metadata)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(LaserTroposphericScintillationLossModelType),) }
    @property
    def type(self) -> "LaserTroposphericScintillationLossModelType":
        """Get the model type enumeration."""
        return self._intf.get_property(ILaserTroposphericScintillationLossModel._metadata, ILaserTroposphericScintillationLossModel._get_type_metadata)

    _property_names[name] = "name"
    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5619117213023705426, 16106002562257095815), ILaserTroposphericScintillationLossModel)
agcls.AgTypeNameMap["ILaserTroposphericScintillationLossModel"] = ILaserTroposphericScintillationLossModel

class IAtmosphericTurbulenceModel(object):
    """Provide access to a refractive index structure parameter model."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (4934895858531787826, 15005049333499468937),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IAtmosphericTurbulenceModel."""
        initialize_from_source_object(self, source_object, IAtmosphericTurbulenceModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IAtmosphericTurbulenceModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IAtmosphericTurbulenceModel, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AtmosphericTurbulenceModelType),) }
    @property
    def type(self) -> "AtmosphericTurbulenceModelType":
        """Get the model type enumeration."""
        return self._intf.get_property(IAtmosphericTurbulenceModel._metadata, IAtmosphericTurbulenceModel._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4934895858531787826, 15005049333499468937), IAtmosphericTurbulenceModel)
agcls.AgTypeNameMap["IAtmosphericTurbulenceModel"] = IAtmosphericTurbulenceModel

class ILaserPropagationChannel(object):
    """Provide access to laser propagation loss models."""

    _num_methods = 10
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_enable_atmospheric_loss_model_method_offset = 1
    _set_enable_atmospheric_loss_model_method_offset = 2
    _set_atmospheric_loss_model_method_offset = 3
    _get_atmospheric_loss_model_method_offset = 4
    _get_enable_tropospheric_scintillation_loss_model_method_offset = 5
    _set_enable_tropospheric_scintillation_loss_model_method_offset = 6
    _set_tropospheric_scintillation_loss_model_method_offset = 7
    _get_tropospheric_scintillation_loss_model_method_offset = 8
    _get_atmospheric_loss_model_component_linking_method_offset = 9
    _get_tropospheric_scintillation_loss_model_component_linking_method_offset = 10
    _metadata = {
        "iid_data" : (5405068464516701808, 8818527412348089472),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ILaserPropagationChannel."""
        initialize_from_source_object(self, source_object, ILaserPropagationChannel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ILaserPropagationChannel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ILaserPropagationChannel, None)

    _get_enable_atmospheric_loss_model_metadata = { "offset" : _get_enable_atmospheric_loss_model_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_atmospheric_loss_model(self) -> bool:
        """Get or set the option for computing atmospheric absorption propagation loss."""
        return self._intf.get_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._get_enable_atmospheric_loss_model_metadata)

    _set_enable_atmospheric_loss_model_metadata = { "offset" : _set_enable_atmospheric_loss_model_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_atmospheric_loss_model.setter
    def enable_atmospheric_loss_model(self, value:bool) -> None:
        return self._intf.set_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._set_enable_atmospheric_loss_model_metadata, value)

    _set_atmospheric_loss_model_metadata = { "offset" : _set_atmospheric_loss_model_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    def set_atmospheric_loss_model(self, model_name:str) -> None:
        """Do not use this method, as it is deprecated. Use AtmosphericLossModelComponentLinking on ILaserPropagationChannel instead. Sets the current atmospheric absorption loss model by name."""
        return self._intf.invoke(ILaserPropagationChannel._metadata, ILaserPropagationChannel._set_atmospheric_loss_model_metadata, model_name)

    _get_atmospheric_loss_model_metadata = { "offset" : _get_atmospheric_loss_model_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def atmospheric_loss_model(self) -> "ILaserAtmosphericLossModel":
        """Do not use this property, as it is deprecated. Use AtmosphericLossModelComponentLinking on ILaserPropagationChannel instead. Gets the laser atmospheric absorption loss model."""
        return self._intf.get_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._get_atmospheric_loss_model_metadata)

    _get_enable_tropospheric_scintillation_loss_model_metadata = { "offset" : _get_enable_tropospheric_scintillation_loss_model_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def enable_tropospheric_scintillation_loss_model(self) -> bool:
        """Get or set the option for computing tropospheric scintillation propagation loss."""
        return self._intf.get_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._get_enable_tropospheric_scintillation_loss_model_metadata)

    _set_enable_tropospheric_scintillation_loss_model_metadata = { "offset" : _set_enable_tropospheric_scintillation_loss_model_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @enable_tropospheric_scintillation_loss_model.setter
    def enable_tropospheric_scintillation_loss_model(self, value:bool) -> None:
        return self._intf.set_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._set_enable_tropospheric_scintillation_loss_model_metadata, value)

    _set_tropospheric_scintillation_loss_model_metadata = { "offset" : _set_tropospheric_scintillation_loss_model_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    def set_tropospheric_scintillation_loss_model(self, model_name:str) -> None:
        """Do not use this method, as it is deprecated. Use TroposphericScintillationLossModelComponentLinking on ILaserPropagationChannel instead. Sets the current tropospheric scintillation loss model by name."""
        return self._intf.invoke(ILaserPropagationChannel._metadata, ILaserPropagationChannel._set_tropospheric_scintillation_loss_model_metadata, model_name)

    _get_tropospheric_scintillation_loss_model_metadata = { "offset" : _get_tropospheric_scintillation_loss_model_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def tropospheric_scintillation_loss_model(self) -> "ILaserTroposphericScintillationLossModel":
        """Do not use this property, as it is deprecated. Use TroposphericScintillationLossModelComponentLinking on ILaserPropagationChannel instead. Gets the laser propagation loss model."""
        return self._intf.get_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._get_tropospheric_scintillation_loss_model_metadata)

    _get_atmospheric_loss_model_component_linking_metadata = { "offset" : _get_atmospheric_loss_model_component_linking_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def atmospheric_loss_model_component_linking(self) -> "IComponentLinkEmbedControl":
        """Get the link/embed controller for managing the atmospheric loss model component."""
        return self._intf.get_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._get_atmospheric_loss_model_component_linking_metadata)

    _get_tropospheric_scintillation_loss_model_component_linking_metadata = { "offset" : _get_tropospheric_scintillation_loss_model_component_linking_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def tropospheric_scintillation_loss_model_component_linking(self) -> "IComponentLinkEmbedControl":
        """Get the link/embed controller for managing the tropospheric scintillation loss model component."""
        return self._intf.get_property(ILaserPropagationChannel._metadata, ILaserPropagationChannel._get_tropospheric_scintillation_loss_model_component_linking_metadata)

    _property_names[enable_atmospheric_loss_model] = "enable_atmospheric_loss_model"
    _property_names[atmospheric_loss_model] = "atmospheric_loss_model"
    _property_names[enable_tropospheric_scintillation_loss_model] = "enable_tropospheric_scintillation_loss_model"
    _property_names[tropospheric_scintillation_loss_model] = "tropospheric_scintillation_loss_model"
    _property_names[atmospheric_loss_model_component_linking] = "atmospheric_loss_model_component_linking"
    _property_names[tropospheric_scintillation_loss_model_component_linking] = "tropospheric_scintillation_loss_model_component_linking"


agcls.AgClassCatalog.add_catalog_entry((5405068464516701808, 8818527412348089472), ILaserPropagationChannel)
agcls.AgTypeNameMap["ILaserPropagationChannel"] = ILaserPropagationChannel

class ICommSystemLinkSelectionCriteria(object):
    """Provide access to a link selection criteria."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (4677210225164506469, 6443323360222069394),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICommSystemLinkSelectionCriteria."""
        initialize_from_source_object(self, source_object, ICommSystemLinkSelectionCriteria)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICommSystemLinkSelectionCriteria)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICommSystemLinkSelectionCriteria, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(CommSystemLinkSelectionCriteriaType),) }
    @property
    def type(self) -> "CommSystemLinkSelectionCriteriaType":
        """Get the link selection criteria type."""
        return self._intf.get_property(ICommSystemLinkSelectionCriteria._metadata, ICommSystemLinkSelectionCriteria._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4677210225164506469, 6443323360222069394), ICommSystemLinkSelectionCriteria)
agcls.AgTypeNameMap["ICommSystemLinkSelectionCriteria"] = ICommSystemLinkSelectionCriteria

class ICommSystemAccessEventDetection(object):
    """Provide access to the properties an access event detection algorithm."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5208341045069386558, 3088738700208561563),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICommSystemAccessEventDetection."""
        initialize_from_source_object(self, source_object, ICommSystemAccessEventDetection)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICommSystemAccessEventDetection)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICommSystemAccessEventDetection, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(CommSystemAccessEventDetectionType),) }
    @property
    def type(self) -> "CommSystemAccessEventDetectionType":
        """Get the access event detection type."""
        return self._intf.get_property(ICommSystemAccessEventDetection._metadata, ICommSystemAccessEventDetection._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5208341045069386558, 3088738700208561563), ICommSystemAccessEventDetection)
agcls.AgTypeNameMap["ICommSystemAccessEventDetection"] = ICommSystemAccessEventDetection

class ICommSystemAccessSamplingMethod(object):
    """Provide access to the properties for the sampling method."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (4674942315843519248, 13441377460609190050),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICommSystemAccessSamplingMethod."""
        initialize_from_source_object(self, source_object, ICommSystemAccessSamplingMethod)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICommSystemAccessSamplingMethod)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICommSystemAccessSamplingMethod, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(CommSystemAccessSamplingMethodType),) }
    @property
    def type(self) -> "CommSystemAccessSamplingMethodType":
        """Get the access sampling method type."""
        return self._intf.get_property(ICommSystemAccessSamplingMethod._metadata, ICommSystemAccessSamplingMethod._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((4674942315843519248, 13441377460609190050), ICommSystemAccessSamplingMethod)
agcls.AgTypeNameMap["ICommSystemAccessSamplingMethod"] = ICommSystemAccessSamplingMethod

class ISRPModelBase(object):
    """A base interface for solar radiation pressure models."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5737677571023715874, 3567370799694821533),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ISRPModelBase."""
        initialize_from_source_object(self, source_object, ISRPModelBase)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ISRPModelBase)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ISRPModelBase, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(SolarRadiationPressureModelType),) }
    @property
    def type(self) -> "SolarRadiationPressureModelType":
        """Return the type of the solar radiation pressure model."""
        return self._intf.get_property(ISRPModelBase._metadata, ISRPModelBase._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5737677571023715874, 3567370799694821533), ISRPModelBase)
agcls.AgTypeNameMap["ISRPModelBase"] = ISRPModelBase

class IVehicleHPOPDragModel(object):
    """A base interface for drag models."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5150607289378482806, 3589177186674435468),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleHPOPDragModel."""
        initialize_from_source_object(self, source_object, IVehicleHPOPDragModel)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleHPOPDragModel)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleHPOPDragModel, None)



agcls.AgClassCatalog.add_catalog_entry((5150607289378482806, 3589177186674435468), IVehicleHPOPDragModel)
agcls.AgTypeNameMap["IVehicleHPOPDragModel"] = IVehicleHPOPDragModel

class IPropagatorSGP4LoadData(object):
    """Load Method Data interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5657081851075772385, 5899130106963592070),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPropagatorSGP4LoadData."""
        initialize_from_source_object(self, source_object, IPropagatorSGP4LoadData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPropagatorSGP4LoadData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPropagatorSGP4LoadData, None)



agcls.AgClassCatalog.add_catalog_entry((5657081851075772385, 5899130106963592070), IPropagatorSGP4LoadData)
agcls.AgTypeNameMap["IPropagatorSGP4LoadData"] = IPropagatorSGP4LoadData

class IVehicleSolarFluxGeoMagnitude(object):
    """Base Interface IVehicleSolarFluxGeoMagnitude. SolarFluxGeoMagneticValueSettings and SolarFluxGeoMagneticFileSettings derive from this interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5663764114058169289, 5585639902224213913),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleSolarFluxGeoMagnitude."""
        initialize_from_source_object(self, source_object, IVehicleSolarFluxGeoMagnitude)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleSolarFluxGeoMagnitude)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleSolarFluxGeoMagnitude, None)



agcls.AgClassCatalog.add_catalog_entry((5663764114058169289, 5585639902224213913), IVehicleSolarFluxGeoMagnitude)
agcls.AgTypeNameMap["IVehicleSolarFluxGeoMagnitude"] = IVehicleSolarFluxGeoMagnitude

class IPropagator(object):
    """Base vehicle propagator interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5504648384907297615, 12129420499141611952),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IPropagator."""
        initialize_from_source_object(self, source_object, IPropagator)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IPropagator)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IPropagator, None)



agcls.AgClassCatalog.add_catalog_entry((5504648384907297615, 12129420499141611952), IPropagator)
agcls.AgTypeNameMap["IPropagator"] = IPropagator

class IVehicleWaypointAltitudeReference(object):
    """Base interface for the altitude references."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5721554599985946437, 14209732357360914588),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleWaypointAltitudeReference."""
        initialize_from_source_object(self, source_object, IVehicleWaypointAltitudeReference)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleWaypointAltitudeReference)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleWaypointAltitudeReference, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(VehicleAltitudeReference),) }
    @property
    def type(self) -> "VehicleAltitudeReference":
        """Get the altitude reference type."""
        return self._intf.get_property(IVehicleWaypointAltitudeReference._metadata, IVehicleWaypointAltitudeReference._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5721554599985946437, 14209732357360914588), IVehicleWaypointAltitudeReference)
agcls.AgTypeNameMap["IVehicleWaypointAltitudeReference"] = IVehicleWaypointAltitudeReference

class IVehicleImpact(object):
    """Base Interface IVehicleImpact. VehicleImpactLocationDetic and IVehicleImpactLocationCentric derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4832445116390211078, 7809417337291873412),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleImpact."""
        initialize_from_source_object(self, source_object, IVehicleImpact)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleImpact)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleImpact, None)



agcls.AgClassCatalog.add_catalog_entry((4832445116390211078, 7809417337291873412), IVehicleImpact)
agcls.AgTypeNameMap["IVehicleImpact"] = IVehicleImpact

class IVehicleLaunchControl(object):
    """Base Interface IVehicleLaunchControl. LaunchVehicleControlFixedApogeeAltitude, LaunchVehicleControlFixedDeltaV, IVehicleLaunchControlDixedDeltaVMinEcc and IAgVeLaunchControlTimeOfFlight derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5180842658582628008, 3423034990240912026),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleLaunchControl."""
        initialize_from_source_object(self, source_object, IVehicleLaunchControl)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleLaunchControl)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleLaunchControl, None)



agcls.AgClassCatalog.add_catalog_entry((5180842658582628008, 3423034990240912026), IVehicleLaunchControl)
agcls.AgTypeNameMap["IVehicleLaunchControl"] = IVehicleLaunchControl

class IVehicleLaunch(object):
    """Base interface IVehicleLaunch. LaunchVehicleLocationDetic and ILaunchVehicleLocationCentric derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5351964125400055779, 4055263661803858079),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleLaunch."""
        initialize_from_source_object(self, source_object, IVehicleLaunch)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleLaunch)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleLaunch, None)



agcls.AgClassCatalog.add_catalog_entry((5351964125400055779, 4055263661803858079), IVehicleLaunch)
agcls.AgTypeNameMap["IVehicleLaunch"] = IVehicleLaunch

class IVehicleImpactLocation(object):
    """Base interface IVehicleImpactLocation. VehicleImpactLocationLaunchAzEl and VehicleImpactLocationPoint derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5574567871368957423, 5632221821773033149),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleImpactLocation."""
        initialize_from_source_object(self, source_object, IVehicleImpactLocation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleImpactLocation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleImpactLocation, None)



agcls.AgClassCatalog.add_catalog_entry((5574567871368957423, 5632221821773033149), IVehicleImpactLocation)
agcls.AgTypeNameMap["IVehicleImpactLocation"] = IVehicleImpactLocation

class IVehicleGPSAlmanacProperties(object):
    """A common base interface for GPS almanac properties."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5138238116490604522, 3979978333503839397),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGPSAlmanacProperties."""
        initialize_from_source_object(self, source_object, IVehicleGPSAlmanacProperties)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGPSAlmanacProperties)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGPSAlmanacProperties, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(VehicleGPSAlmanacType),) }
    @property
    def type(self) -> "VehicleGPSAlmanacType":
        """Get a type of the almanac."""
        return self._intf.get_property(IVehicleGPSAlmanacProperties._metadata, IVehicleGPSAlmanacProperties._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5138238116490604522, 3979978333503839397), IVehicleGPSAlmanacProperties)
agcls.AgTypeNameMap["IVehicleGPSAlmanacProperties"] = IVehicleGPSAlmanacProperties

class IVehicleAttitudeProfile(object):
    """The base interface that all vehicle attitude profiles are derived from."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5490912438345647069, 1340453343981047969),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleAttitudeProfile."""
        initialize_from_source_object(self, source_object, IVehicleAttitudeProfile)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleAttitudeProfile)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleAttitudeProfile, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def type(self) -> str:
        """Get profile type."""
        return self._intf.get_property(IVehicleAttitudeProfile._metadata, IVehicleAttitudeProfile._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5490912438345647069, 1340453343981047969), IVehicleAttitudeProfile)
agcls.AgTypeNameMap["IVehicleAttitudeProfile"] = IVehicleAttitudeProfile

class IVehiclePointing(object):
    """Interface for target pointing attitude profiles, which override the basic attitude profile for a satellite and have a selected axis point in the direction of one or more selected targets, subject to applicable access constraints."""

    _num_methods = 4
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_use_target_pointing_method_offset = 1
    _set_use_target_pointing_method_offset = 2
    _get_targets_method_offset = 3
    _get_target_times_method_offset = 4
    _metadata = {
        "iid_data" : (5643160664876148404, 12925423194043504537),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehiclePointing."""
        initialize_from_source_object(self, source_object, IVehiclePointing)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehiclePointing)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehiclePointing, None)

    _get_use_target_pointing_metadata = { "offset" : _get_use_target_pointing_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def use_target_pointing(self) -> bool:
        """Opt whether to use a target pointing attitude."""
        return self._intf.get_property(IVehiclePointing._metadata, IVehiclePointing._get_use_target_pointing_metadata)

    _set_use_target_pointing_metadata = { "offset" : _set_use_target_pointing_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @use_target_pointing.setter
    def use_target_pointing(self, use_target_pointing:bool) -> None:
        return self._intf.set_property(IVehiclePointing._metadata, IVehiclePointing._set_use_target_pointing_metadata, use_target_pointing)

    _get_targets_metadata = { "offset" : _get_targets_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def targets(self) -> "VehicleTargetPointingCollection":
        """Get the targets used for the attitude profile."""
        return self._intf.get_property(IVehiclePointing._metadata, IVehiclePointing._get_targets_metadata)

    _get_target_times_metadata = { "offset" : _get_target_times_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def target_times(self) -> "VehicleTargetTimes":
        """Get the target times."""
        return self._intf.get_property(IVehiclePointing._metadata, IVehiclePointing._get_target_times_metadata)

    _property_names[use_target_pointing] = "use_target_pointing"
    _property_names[targets] = "targets"
    _property_names[target_times] = "target_times"


agcls.AgClassCatalog.add_catalog_entry((5643160664876148404, 12925423194043504537), IVehiclePointing)
agcls.AgTypeNameMap["IVehiclePointing"] = IVehiclePointing

class IVehicleAttitude(object):
    """Base interface for vehicle attitude options."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5037685547370727970, 17771839035887661243),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleAttitude."""
        initialize_from_source_object(self, source_object, IVehicleAttitude)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleAttitude)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleAttitude, None)



agcls.AgClassCatalog.add_catalog_entry((5037685547370727970, 17771839035887661243), IVehicleAttitude)
agcls.AgTypeNameMap["IVehicleAttitude"] = IVehicleAttitude

class IVehicleAttitudeStandard(IVehicleAttitude):
    """Standard attitude profile."""

    _num_methods = 1
    _vtable_offset = IVehicleAttitude._vtable_offset + IVehicleAttitude._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5431937810667330261, 2828467013878475399),
        "vtable_reference" : IVehicleAttitude._vtable_offset + IVehicleAttitude._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleAttitudeStandard."""
        initialize_from_source_object(self, source_object, IVehicleAttitudeStandard)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
        IVehicleAttitude._private_init(self, intf)
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleAttitudeStandard)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleAttitudeStandard, IVehicleAttitude)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(AttitudeStandardType),) }
    @property
    def type(self) -> "AttitudeStandardType":
        """Get the standard attitude profile type."""
        return self._intf.get_property(IVehicleAttitudeStandard._metadata, IVehicleAttitudeStandard._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5431937810667330261, 2828467013878475399), IVehicleAttitudeStandard)
agcls.AgTypeNameMap["IVehicleAttitudeStandard"] = IVehicleAttitudeStandard

class IVehicleGraphics2DPass(object):
    """interface IVehicleGraphics2DPass. VehicleGraphics2DPassShowPasses and IVehicleGraphics2DPassResolution derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5311915477281129694, 9226485923864577470),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DPass."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DPass)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DPass)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DPass, None)



agcls.AgClassCatalog.add_catalog_entry((5311915477281129694, 9226485923864577470), IVehicleGraphics2DPass)
agcls.AgTypeNameMap["IVehicleGraphics2DPass"] = IVehicleGraphics2DPass

class IVehicleGraphics2DTimeEventType(object):
    """Base Interface IVehicleGraphics2DTimeEventType. VehicleGraphics2DTimeEventTypeLine, VehicleGraphics2DTimeEventTypeMarker and IVehicleGraphics2DTimeEventTypeText derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5025294780258769292, 9041894382540971193),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DTimeEventType."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DTimeEventType)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DTimeEventType)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DTimeEventType, None)



agcls.AgClassCatalog.add_catalog_entry((5025294780258769292, 9041894382540971193), IVehicleGraphics2DTimeEventType)
agcls.AgTypeNameMap["IVehicleGraphics2DTimeEventType"] = IVehicleGraphics2DTimeEventType

class IVehicleGraphics2DAttributes(object):
    """Base Interface for Vehicle 2D Graphics Attributes."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5630724632594214322, 3054352712622501550),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DAttributes."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DAttributes)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DAttributes)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DAttributes, None)



agcls.AgClassCatalog.add_catalog_entry((5630724632594214322, 3054352712622501550), IVehicleGraphics2DAttributes)
agcls.AgTypeNameMap["IVehicleGraphics2DAttributes"] = IVehicleGraphics2DAttributes

class IVehicleGraphics2DAttributesBasic(IVehicleGraphics2DAttributes):
    r"""
    Basic 2D Graphics Attributes for a vehicle.

    Examples
    --------
    Set 2D Graphics display properties:
    >>> # STKObjectRoot root: STK Object Model root
    >>> # Satellite satellite: Satellite object
    >>> # Change the line width, style, color and marker
    >>>
    >>> graphics = satellite.graphics
    >>> graphics.set_attributes_type(VehicleGraphics2DAttributeType.BASIC)
    >>> attributes = graphics.attributes
    >>> attributes.inherit = False
    >>> attributes.line.width = LineWidth.WIDTH4
    >>> attributes.line.style = LineStyle.LONG_DASH
    >>> attributes.color = Colors.Lime
    >>> if os.name == "nt":
    >>>     installPath = r"C:\Program Files\AGI\STK 12"
    >>> else:
    >>>     installPath = os.environ["STK_INSTALL_DIR"]
    >>> attributes.marker_style = os.path.join(installPath, "STKData", "Pixmaps", "MarkersWin", "m010Satellite.bmp")
    """

    _num_methods = 11
    _vtable_offset = IVehicleGraphics2DAttributes._vtable_offset + IVehicleGraphics2DAttributes._num_methods
    _get_inherit_method_offset = 1
    _set_inherit_method_offset = 2
    _get_show_graphics_method_offset = 3
    _set_show_graphics_method_offset = 4
    _get_color_method_offset = 5
    _set_color_method_offset = 6
    _get_marker_style_method_offset = 7
    _set_marker_style_method_offset = 8
    _get_show_label_method_offset = 9
    _set_show_label_method_offset = 10
    _get_line_method_offset = 11
    _metadata = {
        "iid_data" : (5480623769893779252, 2957098088799866781),
        "vtable_reference" : IVehicleGraphics2DAttributes._vtable_offset + IVehicleGraphics2DAttributes._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DAttributesBasic."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DAttributesBasic)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
        IVehicleGraphics2DAttributes._private_init(self, intf)
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DAttributesBasic)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DAttributesBasic, IVehicleGraphics2DAttributes)

    _get_inherit_metadata = { "offset" : _get_inherit_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def inherit(self) -> bool:
        """Inherit certain 2D graphics settings from the scenario level."""
        return self._intf.get_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._get_inherit_metadata)

    _set_inherit_metadata = { "offset" : _set_inherit_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @inherit.setter
    def inherit(self, inherit:bool) -> None:
        return self._intf.set_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._set_inherit_metadata, inherit)

    _get_show_graphics_metadata = { "offset" : _get_show_graphics_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_graphics(self) -> bool:
        """Show 2D Graphics for the vehicle."""
        return self._intf.get_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._get_show_graphics_metadata)

    _set_show_graphics_metadata = { "offset" : _set_show_graphics_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_graphics.setter
    def show_graphics(self, is_visible:bool) -> None:
        return self._intf.set_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._set_show_graphics_metadata, is_visible)

    _get_color_metadata = { "offset" : _get_color_method_offset,
            "arg_types" : (POINTER(agcom.OLE_COLOR),),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @property
    def color(self) -> agcolor.Color:
        """Color in which vehicle marker, label and tracks are displayed."""
        return self._intf.get_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._get_color_metadata)

    _set_color_metadata = { "offset" : _set_color_method_offset,
            "arg_types" : (agcom.OLE_COLOR,),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @color.setter
    def color(self, color:agcolor.Color) -> None:
        return self._intf.set_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._set_color_metadata, color)

    _get_marker_style_metadata = { "offset" : _get_marker_style_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def marker_style(self) -> str:
        """Style of marker used to represent vehicle."""
        return self._intf.get_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._get_marker_style_metadata)

    _set_marker_style_metadata = { "offset" : _set_marker_style_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @marker_style.setter
    def marker_style(self, bstr:str) -> None:
        return self._intf.set_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._set_marker_style_metadata, bstr)

    _get_show_label_metadata = { "offset" : _get_show_label_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_label(self) -> bool:
        """Opt whether to display the vehicle's label."""
        return self._intf.get_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._get_show_label_metadata)

    _set_show_label_metadata = { "offset" : _set_show_label_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_label.setter
    def show_label(self, value:bool) -> None:
        return self._intf.set_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._set_show_label_metadata, value)

    _get_line_metadata = { "offset" : _get_line_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def line(self) -> "VehicleGraphics2DLine":
        """Get the line display properties for the vehicle."""
        return self._intf.get_property(IVehicleGraphics2DAttributesBasic._metadata, IVehicleGraphics2DAttributesBasic._get_line_metadata)

    _property_names[inherit] = "inherit"
    _property_names[show_graphics] = "show_graphics"
    _property_names[color] = "color"
    _property_names[marker_style] = "marker_style"
    _property_names[show_label] = "show_label"
    _property_names[line] = "line"


agcls.AgClassCatalog.add_catalog_entry((5480623769893779252, 2957098088799866781), IVehicleGraphics2DAttributesBasic)
agcls.AgTypeNameMap["IVehicleGraphics2DAttributesBasic"] = IVehicleGraphics2DAttributesBasic

class IVehicleGraphics2DAttributesDisplayState(object):
    """Provide access to non-trivial properties of 2D vehicle attributes."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_display_intervals_method_offset = 1
    _metadata = {
        "iid_data" : (5066551902426933770, 13961717558826846128),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DAttributesDisplayState."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DAttributesDisplayState)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DAttributesDisplayState)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DAttributesDisplayState, None)

    _get_display_intervals_metadata = { "offset" : _get_display_intervals_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    def get_display_intervals(self) -> "VehicleGraphics2DIntervalsCollection":
        """Get a read-only collection of computed display intervals."""
        return self._intf.invoke(IVehicleGraphics2DAttributesDisplayState._metadata, IVehicleGraphics2DAttributesDisplayState._get_display_intervals_metadata, OutArg())



agcls.AgClassCatalog.add_catalog_entry((5066551902426933770, 13961717558826846128), IVehicleGraphics2DAttributesDisplayState)
agcls.AgTypeNameMap["IVehicleGraphics2DAttributesDisplayState"] = IVehicleGraphics2DAttributesDisplayState

class IVehicleGraphics2DElevation(object):
    """Base Interface IVehicleGraphics2DElevation. VehicleGraphics2DElevationGroundElevation, IAgVeGfxElevationsSwathHalfWidth and IAgVeGfxElevationsSwathHalfAngle derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4992558730722716931, 16770144538786824586),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DElevation."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DElevation)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DElevation)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DElevation, None)



agcls.AgClassCatalog.add_catalog_entry((4992558730722716931, 16770144538786824586), IVehicleGraphics2DElevation)
agcls.AgTypeNameMap["IVehicleGraphics2DElevation"] = IVehicleGraphics2DElevation

class IVehicleGraphics2DTimeComponentsElement(object):
    """Provide properties to configure the vehicle's appearance in 2D and 3D views."""

    _num_methods = 6
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_qualified_path_method_offset = 1
    _get_priority_method_offset = 2
    _increase_priority_method_offset = 3
    _decrease_priority_method_offset = 4
    _set_highest_priority_method_offset = 5
    _set_lowest_priority_method_offset = 6
    _metadata = {
        "iid_data" : (5365391812913111040, 4103492805061713310),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics2DTimeComponentsElement."""
        initialize_from_source_object(self, source_object, IVehicleGraphics2DTimeComponentsElement)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics2DTimeComponentsElement)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics2DTimeComponentsElement, None)

    _get_qualified_path_metadata = { "offset" : _get_qualified_path_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def qualified_path(self) -> str:
        """A fully qualified path of a time component."""
        return self._intf.get_property(IVehicleGraphics2DTimeComponentsElement._metadata, IVehicleGraphics2DTimeComponentsElement._get_qualified_path_metadata)

    _get_priority_metadata = { "offset" : _get_priority_method_offset,
            "arg_types" : (POINTER(agcom.INT),),
            "marshallers" : (agmarshall.IntArg,) }
    @property
    def priority(self) -> int:
        """Priority indicates the order of a time component when resolving the overlapping intervals during rendering."""
        return self._intf.get_property(IVehicleGraphics2DTimeComponentsElement._metadata, IVehicleGraphics2DTimeComponentsElement._get_priority_metadata)

    _increase_priority_metadata = { "offset" : _increase_priority_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def increase_priority(self) -> None:
        """Increase the time component's rendering priority."""
        return self._intf.invoke(IVehicleGraphics2DTimeComponentsElement._metadata, IVehicleGraphics2DTimeComponentsElement._increase_priority_metadata, )

    _decrease_priority_metadata = { "offset" : _decrease_priority_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def decrease_priority(self) -> None:
        """Decrease the time component's rendering priority."""
        return self._intf.invoke(IVehicleGraphics2DTimeComponentsElement._metadata, IVehicleGraphics2DTimeComponentsElement._decrease_priority_metadata, )

    _set_highest_priority_metadata = { "offset" : _set_highest_priority_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def set_highest_priority(self) -> None:
        """Set the highest time component's rendering priority."""
        return self._intf.invoke(IVehicleGraphics2DTimeComponentsElement._metadata, IVehicleGraphics2DTimeComponentsElement._set_highest_priority_metadata, )

    _set_lowest_priority_metadata = { "offset" : _set_lowest_priority_method_offset,
            "arg_types" : (),
            "marshallers" : () }
    def set_lowest_priority(self) -> None:
        """Set the lowest time component's rendering priority."""
        return self._intf.invoke(IVehicleGraphics2DTimeComponentsElement._metadata, IVehicleGraphics2DTimeComponentsElement._set_lowest_priority_metadata, )

    _property_names[qualified_path] = "qualified_path"
    _property_names[priority] = "priority"


agcls.AgClassCatalog.add_catalog_entry((5365391812913111040, 4103492805061713310), IVehicleGraphics2DTimeComponentsElement)
agcls.AgTypeNameMap["IVehicleGraphics2DTimeComponentsElement"] = IVehicleGraphics2DTimeComponentsElement

class IVehicleGraphics3DSystemsElementBase(object):
    """Define methods and properties used to configure the 3D properties of a reference system used for displaying vehicle orbits and trajectories."""

    _num_methods = 9
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_inherit_method_offset = 1
    _set_inherit_method_offset = 2
    _get_color_method_offset = 3
    _set_color_method_offset = 4
    _get_graphics_3d_window_method_offset = 5
    _set_graphics_3d_window_method_offset = 6
    _get_available_graphics_3d_windows_method_offset = 7
    _get_persist_for_all_passes_method_offset = 8
    _set_persist_for_all_passes_method_offset = 9
    _metadata = {
        "iid_data" : (5652880855108379770, 18064717504486947231),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DSystemsElementBase."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DSystemsElementBase)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DSystemsElementBase)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DSystemsElementBase, None)

    _get_inherit_metadata = { "offset" : _get_inherit_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def inherit(self) -> bool:
        """Inherit color from 2D graphics."""
        return self._intf.get_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._get_inherit_metadata)

    _set_inherit_metadata = { "offset" : _set_inherit_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @inherit.setter
    def inherit(self, inherit:bool) -> None:
        return self._intf.set_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._set_inherit_metadata, inherit)

    _get_color_metadata = { "offset" : _get_color_method_offset,
            "arg_types" : (POINTER(agcom.OLE_COLOR),),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @property
    def color(self) -> agcolor.Color:
        """Specify a custom color."""
        return self._intf.get_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._get_color_metadata)

    _set_color_metadata = { "offset" : _set_color_method_offset,
            "arg_types" : (agcom.OLE_COLOR,),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @color.setter
    def color(self, color:agcolor.Color) -> None:
        return self._intf.set_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._set_color_metadata, color)

    _get_graphics_3d_window_metadata = { "offset" : _get_graphics_3d_window_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def graphics_3d_window(self) -> str:
        """Get or set the selected 3D Graphics window."""
        return self._intf.get_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._get_graphics_3d_window_metadata)

    _set_graphics_3d_window_metadata = { "offset" : _set_graphics_3d_window_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @graphics_3d_window.setter
    def graphics_3d_window(self, window3d:str) -> None:
        return self._intf.set_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._set_graphics_3d_window_metadata, window3d)

    _get_available_graphics_3d_windows_metadata = { "offset" : _get_available_graphics_3d_windows_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def available_graphics_3d_windows(self) -> list:
        """3D Graphics Windows available to display the reference system."""
        return self._intf.get_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._get_available_graphics_3d_windows_metadata)

    _get_persist_for_all_passes_metadata = { "offset" : _get_persist_for_all_passes_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def persist_for_all_passes(self) -> bool:
        """Persistent the reference system when all passes are displayed."""
        return self._intf.get_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._get_persist_for_all_passes_metadata)

    _set_persist_for_all_passes_metadata = { "offset" : _set_persist_for_all_passes_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @persist_for_all_passes.setter
    def persist_for_all_passes(self, value:bool) -> None:
        return self._intf.set_property(IVehicleGraphics3DSystemsElementBase._metadata, IVehicleGraphics3DSystemsElementBase._set_persist_for_all_passes_metadata, value)

    _property_names[inherit] = "inherit"
    _property_names[color] = "color"
    _property_names[graphics_3d_window] = "graphics_3d_window"
    _property_names[available_graphics_3d_windows] = "available_graphics_3d_windows"
    _property_names[persist_for_all_passes] = "persist_for_all_passes"


agcls.AgClassCatalog.add_catalog_entry((5652880855108379770, 18064717504486947231), IVehicleGraphics3DSystemsElementBase)
agcls.AgTypeNameMap["IVehicleGraphics3DSystemsElementBase"] = IVehicleGraphics3DSystemsElementBase

class IVehicleGraphics3DProximityAreaObject(object):
    """A base class that defines methods and properties common to all proximity area objects."""

    _num_methods = 14
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_show_graphics_method_offset = 1
    _set_show_graphics_method_offset = 2
    _get_color_method_offset = 3
    _set_color_method_offset = 4
    _get_line_width_method_offset = 5
    _set_line_width_method_offset = 6
    _get_show_label_method_offset = 7
    _set_show_label_method_offset = 8
    _get_show_text_method_offset = 9
    _set_show_text_method_offset = 10
    _get_text_method_offset = 11
    _set_text_method_offset = 12
    _get_line_style_method_offset = 13
    _set_line_style_method_offset = 14
    _metadata = {
        "iid_data" : (5188900544332703262, 18083370273956676540),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DProximityAreaObject."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DProximityAreaObject)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DProximityAreaObject)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DProximityAreaObject, None)

    _get_show_graphics_metadata = { "offset" : _get_show_graphics_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_graphics(self) -> bool:
        """Specify whether to show the proximity area object."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_show_graphics_metadata)

    _set_show_graphics_metadata = { "offset" : _set_show_graphics_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_graphics.setter
    def show_graphics(self, is_visible:bool) -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_show_graphics_metadata, is_visible)

    _get_color_metadata = { "offset" : _get_color_method_offset,
            "arg_types" : (POINTER(agcom.OLE_COLOR),),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @property
    def color(self) -> agcolor.Color:
        """Specify a line color."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_color_metadata)

    _set_color_metadata = { "offset" : _set_color_method_offset,
            "arg_types" : (agcom.OLE_COLOR,),
            "marshallers" : (agmarshall.OLEColorArg,) }
    @color.setter
    def color(self, color:agcolor.Color) -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_color_metadata, color)

    _get_line_width_metadata = { "offset" : _get_line_width_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(LineWidth),) }
    @property
    def line_width(self) -> "LineWidth":
        """Specify a line width."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_line_width_metadata)

    _set_line_width_metadata = { "offset" : _set_line_width_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(LineWidth),) }
    @line_width.setter
    def line_width(self, line_width:"LineWidth") -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_line_width_metadata, line_width)

    _get_show_label_metadata = { "offset" : _get_show_label_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_label(self) -> bool:
        """Specify whether to display a label."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_show_label_metadata)

    _set_show_label_metadata = { "offset" : _set_show_label_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_label.setter
    def show_label(self, show_label:bool) -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_show_label_metadata, show_label)

    _get_show_text_metadata = { "offset" : _get_show_text_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_text(self) -> bool:
        """Specify whether to display a text."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_show_text_metadata)

    _set_show_text_metadata = { "offset" : _set_show_text_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_text.setter
    def show_text(self, show_text:bool) -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_show_text_metadata, show_text)

    _get_text_metadata = { "offset" : _get_text_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def text(self) -> str:
        """Specify a text."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_text_metadata)

    _set_text_metadata = { "offset" : _set_text_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @text.setter
    def text(self, text:str) -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_text_metadata, text)

    _get_line_style_metadata = { "offset" : _get_line_style_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(LineStyle),) }
    @property
    def line_style(self) -> "LineStyle":
        """Specify a line style type."""
        return self._intf.get_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._get_line_style_metadata)

    _set_line_style_metadata = { "offset" : _set_line_style_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(LineStyle),) }
    @line_style.setter
    def line_style(self, line_style:"LineStyle") -> None:
        return self._intf.set_property(IVehicleGraphics3DProximityAreaObject._metadata, IVehicleGraphics3DProximityAreaObject._set_line_style_metadata, line_style)

    _property_names[show_graphics] = "show_graphics"
    _property_names[color] = "color"
    _property_names[line_width] = "line_width"
    _property_names[show_label] = "show_label"
    _property_names[show_text] = "show_text"
    _property_names[text] = "text"
    _property_names[line_style] = "line_style"


agcls.AgClassCatalog.add_catalog_entry((5188900544332703262, 18083370273956676540), IVehicleGraphics3DProximityAreaObject)
agcls.AgTypeNameMap["IVehicleGraphics3DProximityAreaObject"] = IVehicleGraphics3DProximityAreaObject

class IVehicleGraphics3DProximity(object):
    """Base Proximity graphics interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5490361507773927852, 8106375085866449845),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DProximity."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DProximity)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DProximity)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DProximity, None)



agcls.AgClassCatalog.add_catalog_entry((5490361507773927852, 8106375085866449845), IVehicleGraphics3DProximity)
agcls.AgTypeNameMap["IVehicleGraphics3DProximity"] = IVehicleGraphics3DProximity

class IVehicleGraphics3DSigmaScale(object):
    """Base Interface IVehicleGraphics3DSigmaScale. VehicleGraphics3DSigmaScaleScale and VehicleGraphics3DSigmaScaleProbability derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5196941435489636404, 13597946803055151802),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DSigmaScale."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DSigmaScale)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DSigmaScale)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DSigmaScale, None)



agcls.AgClassCatalog.add_catalog_entry((5196941435489636404, 13597946803055151802), IVehicleGraphics3DSigmaScale)
agcls.AgTypeNameMap["IVehicleGraphics3DSigmaScale"] = IVehicleGraphics3DSigmaScale

class IVehicleGraphics3DAttributes(object):
    """Base Interface IVehicleGraphics3DAttributes. VehicleGraphics3DAttributesBasic and VehicleGraphics3DAttributesIntervals derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5620786374833848697, 2758767996263707820),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DAttributes."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DAttributes)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DAttributes)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DAttributes, None)



agcls.AgClassCatalog.add_catalog_entry((5620786374833848697, 2758767996263707820), IVehicleGraphics3DAttributes)
agcls.AgTypeNameMap["IVehicleGraphics3DAttributes"] = IVehicleGraphics3DAttributes

class IVehicleGraphics3DTickData(object):
    """Base interface IVehicleGraphics3DTickData. VehicleGraphics3DTickDataLine and VehicleGraphics3DTickDataPoint derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5621580583188411286, 864090969697721496),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DTickData."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DTickData)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DTickData)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DTickData, None)



agcls.AgClassCatalog.add_catalog_entry((5621580583188411286, 864090969697721496), IVehicleGraphics3DTickData)
agcls.AgTypeNameMap["IVehicleGraphics3DTickData"] = IVehicleGraphics3DTickData

class IGreatArcGraphics(object):
    """2D Graphics common for all Great Arc Vehicles."""

    _num_methods = 18
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_attributes_type_method_offset = 1
    _set_attributes_type_method_offset = 2
    _is_attributes_type_supported_method_offset = 3
    _get_attributes_supported_types_method_offset = 4
    _get_attributes_method_offset = 5
    _get_pass_data_method_offset = 6
    _get_waypoint_marker_method_offset = 7
    _get_resolution_method_offset = 8
    _get_range_contours_method_offset = 9
    _get_lighting_method_offset = 10
    _get_ground_ellipses_method_offset = 11
    _get_label_notes_method_offset = 12
    _get_use_instance_name_label_method_offset = 13
    _set_use_instance_name_label_method_offset = 14
    _get_label_name_method_offset = 15
    _set_label_name_method_offset = 16
    _get_show_graphics_method_offset = 17
    _set_show_graphics_method_offset = 18
    _metadata = {
        "iid_data" : (5303736710526434346, 12151474888660363417),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGreatArcGraphics."""
        initialize_from_source_object(self, source_object, IGreatArcGraphics)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGreatArcGraphics)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGreatArcGraphics, None)

    _get_attributes_type_metadata = { "offset" : _get_attributes_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(VehicleGraphics2DAttributeType),) }
    @property
    def attributes_type(self) -> "VehicleGraphics2DAttributeType":
        """Get the 2D Graphics attributes type for the vehicle: basic, access intervals, custom intervals, or real time."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_attributes_type_metadata)

    _set_attributes_type_metadata = { "offset" : _set_attributes_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(VehicleGraphics2DAttributeType),) }
    def set_attributes_type(self, attributes:"VehicleGraphics2DAttributeType") -> None:
        """Set the 2D Graphics attributes type for the vehicle."""
        return self._intf.invoke(IGreatArcGraphics._metadata, IGreatArcGraphics._set_attributes_type_metadata, attributes)

    _is_attributes_type_supported_metadata = { "offset" : _is_attributes_type_supported_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(VehicleGraphics2DAttributeType), agmarshall.VariantBoolArg,) }
    def is_attributes_type_supported(self, attributes:"VehicleGraphics2DAttributeType") -> bool:
        """Get a value indicating whether the specified type can be used."""
        return self._intf.invoke(IGreatArcGraphics._metadata, IGreatArcGraphics._is_attributes_type_supported_metadata, attributes, OutArg())

    _get_attributes_supported_types_metadata = { "offset" : _get_attributes_supported_types_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def attributes_supported_types(self) -> list:
        """Return an array of valid choices."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_attributes_supported_types_metadata)

    _get_attributes_metadata = { "offset" : _get_attributes_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def attributes(self) -> "IVehicleGraphics2DAttributes":
        """Get the vehicle's 2D Graphics attributes."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_attributes_metadata)

    _get_pass_data_metadata = { "offset" : _get_pass_data_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def pass_data(self) -> "VehicleGraphics2DRoutePassData":
        """Get the vehicle's 2D route graphics."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_pass_data_metadata)

    _get_waypoint_marker_metadata = { "offset" : _get_waypoint_marker_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def waypoint_marker(self) -> "VehicleGraphics2DWaypointMarker":
        """Get the vehicle's 2D waypoint marker graphics."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_waypoint_marker_metadata)

    _get_resolution_metadata = { "offset" : _get_resolution_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def resolution(self) -> "VehicleGraphics2DRouteResolution":
        """Get the vehicle's 2D resolution graphics."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_resolution_metadata)

    _get_range_contours_metadata = { "offset" : _get_range_contours_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def range_contours(self) -> "Graphics2DRangeContours":
        """Get the vehicle's 2D range contour graphics."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_range_contours_metadata)

    _get_lighting_metadata = { "offset" : _get_lighting_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def lighting(self) -> "VehicleGraphics2DLighting":
        """Get the vehicle's 2D lighting graphics."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_lighting_metadata)

    _get_ground_ellipses_metadata = { "offset" : _get_ground_ellipses_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def ground_ellipses(self) -> "VehicleGraphics2DGroundEllipsesCollection":
        """Get the vehicle's 2D ground ellipses graphics."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_ground_ellipses_metadata)

    _get_label_notes_metadata = { "offset" : _get_label_notes_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def label_notes(self) -> "LabelNoteCollection":
        """Notes attached to the object and displayed in the 2D and 3D Graphics windows."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_label_notes_metadata)

    _get_use_instance_name_label_metadata = { "offset" : _get_use_instance_name_label_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def use_instance_name_label(self) -> bool:
        """Specify whether to use the name of the vehicle (as shown in the Object Browser) as its label."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_use_instance_name_label_metadata)

    _set_use_instance_name_label_metadata = { "offset" : _set_use_instance_name_label_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @use_instance_name_label.setter
    def use_instance_name_label(self, use_inst_name:bool) -> None:
        return self._intf.set_property(IGreatArcGraphics._metadata, IGreatArcGraphics._set_use_instance_name_label_metadata, use_inst_name)

    _get_label_name_metadata = { "offset" : _get_label_name_method_offset,
            "arg_types" : (POINTER(agcom.BSTR),),
            "marshallers" : (agmarshall.BStrArg,) }
    @property
    def label_name(self) -> str:
        """The user-specified name to use as a label for the vehicle."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_label_name_metadata)

    _set_label_name_metadata = { "offset" : _set_label_name_method_offset,
            "arg_types" : (agcom.BSTR,),
            "marshallers" : (agmarshall.BStrArg,) }
    @label_name.setter
    def label_name(self, value:str) -> None:
        return self._intf.set_property(IGreatArcGraphics._metadata, IGreatArcGraphics._set_label_name_metadata, value)

    _get_show_graphics_metadata = { "offset" : _get_show_graphics_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def show_graphics(self) -> bool:
        """Specify whether graphics attributes of the vehicle are visible."""
        return self._intf.get_property(IGreatArcGraphics._metadata, IGreatArcGraphics._get_show_graphics_metadata)

    _set_show_graphics_metadata = { "offset" : _set_show_graphics_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @show_graphics.setter
    def show_graphics(self, is_visible:bool) -> None:
        return self._intf.set_property(IGreatArcGraphics._metadata, IGreatArcGraphics._set_show_graphics_metadata, is_visible)

    _property_names[attributes_type] = "attributes_type"
    _property_names[attributes_supported_types] = "attributes_supported_types"
    _property_names[attributes] = "attributes"
    _property_names[pass_data] = "pass_data"
    _property_names[waypoint_marker] = "waypoint_marker"
    _property_names[resolution] = "resolution"
    _property_names[range_contours] = "range_contours"
    _property_names[lighting] = "lighting"
    _property_names[ground_ellipses] = "ground_ellipses"
    _property_names[label_notes] = "label_notes"
    _property_names[use_instance_name_label] = "use_instance_name_label"
    _property_names[label_name] = "label_name"
    _property_names[show_graphics] = "show_graphics"


agcls.AgClassCatalog.add_catalog_entry((5303736710526434346, 12151474888660363417), IGreatArcGraphics)
agcls.AgTypeNameMap["IGreatArcGraphics"] = IGreatArcGraphics

class IGreatArcGraphics3D(object):
    """3D Graphics common for all Great Arc Vehicles."""

    _num_methods = 9
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_model_method_offset = 1
    _get_route_method_offset = 2
    _get_offsets_method_offset = 3
    _get_range_contours_method_offset = 4
    _get_covariance_method_offset = 5
    _get_vector_method_offset = 6
    _get_data_display_method_offset = 7
    _get_model_pointing_method_offset = 8
    _get_velocity_covariance_method_offset = 9
    _metadata = {
        "iid_data" : (4654794006484014352, 7168301143859717287),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGreatArcGraphics3D."""
        initialize_from_source_object(self, source_object, IGreatArcGraphics3D)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGreatArcGraphics3D)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGreatArcGraphics3D, None)

    _get_model_metadata = { "offset" : _get_model_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def model(self) -> "VehicleGraphics3DModelRoute":
        """Get the vehicle's 3D model properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_model_metadata)

    _get_route_metadata = { "offset" : _get_route_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def route(self) -> "VehicleGraphics3DRoute":
        """Get the vehicle's 3D route properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_route_metadata)

    _get_offsets_metadata = { "offset" : _get_offsets_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def offsets(self) -> "Graphics3DOffset":
        """Get the vehicle's 3D offsets properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_offsets_metadata)

    _get_range_contours_metadata = { "offset" : _get_range_contours_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def range_contours(self) -> "Graphics3DRangeContours":
        """Get the vehicle's 3D range contour properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_range_contours_metadata)

    _get_covariance_metadata = { "offset" : _get_covariance_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def covariance(self) -> "VehicleGraphics3DCovariance":
        """Get the vehicle's 3D covariance properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_covariance_metadata)

    _get_vector_metadata = { "offset" : _get_vector_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def vector(self) -> "Graphics3DVector":
        """Get the vehicle's 3D vector properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_vector_metadata)

    _get_data_display_metadata = { "offset" : _get_data_display_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def data_display(self) -> "Graphics3DDataDisplayCollection":
        """Get the vehicle's 3D data display properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_data_display_metadata)

    _get_model_pointing_metadata = { "offset" : _get_model_pointing_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def model_pointing(self) -> "Graphics3DModelPointing":
        """Use to point parts of a facility or vehicle model toward a target, such as the Sun or Earth."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_model_pointing_metadata)

    _get_velocity_covariance_metadata = { "offset" : _get_velocity_covariance_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def velocity_covariance(self) -> "VehicleGraphics3DVelocityCovariance":
        """Get the vehicle's 3D velocity covariance properties."""
        return self._intf.get_property(IGreatArcGraphics3D._metadata, IGreatArcGraphics3D._get_velocity_covariance_metadata)

    _property_names[model] = "model"
    _property_names[route] = "route"
    _property_names[offsets] = "offsets"
    _property_names[range_contours] = "range_contours"
    _property_names[covariance] = "covariance"
    _property_names[vector] = "vector"
    _property_names[data_display] = "data_display"
    _property_names[model_pointing] = "model_pointing"
    _property_names[velocity_covariance] = "velocity_covariance"


agcls.AgClassCatalog.add_catalog_entry((4654794006484014352, 7168301143859717287), IGreatArcGraphics3D)
agcls.AgTypeNameMap["IGreatArcGraphics3D"] = IGreatArcGraphics3D

class IGreatArcVehicle(object):
    """A base interface for all Great Arc Vehicles."""

    _num_methods = 17
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_route_type_method_offset = 1
    _set_route_type_method_offset = 2
    _is_route_type_supported_method_offset = 3
    _get_route_supported_types_method_offset = 4
    _get_route_method_offset = 5
    _get_attitude_type_method_offset = 6
    _set_attitude_type_method_offset = 7
    _is_attitude_type_supported_method_offset = 8
    _get_attitude_supported_types_method_offset = 9
    _get_attitude_method_offset = 10
    _get_ground_ellipses_method_offset = 11
    _get_access_constraints_method_offset = 12
    _get_eclipse_bodies_method_offset = 13
    _get_use_terrain_in_lighting_computations_method_offset = 14
    _set_use_terrain_in_lighting_computations_method_offset = 15
    _get_lighting_maximum_step_method_offset = 16
    _set_lighting_maximum_step_method_offset = 17
    _metadata = {
        "iid_data" : (5279504316049954210, 15594367786580511107),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IGreatArcVehicle."""
        initialize_from_source_object(self, source_object, IGreatArcVehicle)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IGreatArcVehicle)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IGreatArcVehicle, None)

    _get_route_type_metadata = { "offset" : _get_route_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(PropagatorType),) }
    @property
    def route_type(self) -> "PropagatorType":
        """Get the propagator type."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_route_type_metadata)

    _set_route_type_metadata = { "offset" : _set_route_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(PropagatorType),) }
    def set_route_type(self, route:"PropagatorType") -> None:
        """Set the propagator type."""
        return self._intf.invoke(IGreatArcVehicle._metadata, IGreatArcVehicle._set_route_type_metadata, route)

    _is_route_type_supported_metadata = { "offset" : _is_route_type_supported_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(PropagatorType), agmarshall.VariantBoolArg,) }
    def is_route_type_supported(self, route:"PropagatorType") -> bool:
        """Get a value indicating whether the specified type can be used."""
        return self._intf.invoke(IGreatArcVehicle._metadata, IGreatArcVehicle._is_route_type_supported_metadata, route, OutArg())

    _get_route_supported_types_metadata = { "offset" : _get_route_supported_types_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def route_supported_types(self) -> list:
        """Return an array of valid choices."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_route_supported_types_metadata)

    _get_route_metadata = { "offset" : _get_route_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def route(self) -> "IPropagator":
        """Get the route properties."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_route_metadata)

    _get_attitude_type_metadata = { "offset" : _get_attitude_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(VehicleAttitude),) }
    @property
    def attitude_type(self) -> "VehicleAttitude":
        """Get the type of attitude profile."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_attitude_type_metadata)

    _set_attitude_type_metadata = { "offset" : _set_attitude_type_method_offset,
            "arg_types" : (agcom.LONG,),
            "marshallers" : (agmarshall.EnumArg(VehicleAttitude),) }
    def set_attitude_type(self, attitude:"VehicleAttitude") -> None:
        """Set the type of attitude profile."""
        return self._intf.invoke(IGreatArcVehicle._metadata, IGreatArcVehicle._set_attitude_type_metadata, attitude)

    _is_attitude_type_supported_metadata = { "offset" : _is_attitude_type_supported_method_offset,
            "arg_types" : (agcom.LONG, POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.EnumArg(VehicleAttitude), agmarshall.VariantBoolArg,) }
    def is_attitude_type_supported(self, attitude:"VehicleAttitude") -> bool:
        """Get a value indicating whether the specified type can be used."""
        return self._intf.invoke(IGreatArcVehicle._metadata, IGreatArcVehicle._is_attitude_type_supported_metadata, attitude, OutArg())

    _get_attitude_supported_types_metadata = { "offset" : _get_attitude_supported_types_method_offset,
            "arg_types" : (POINTER(agcom.LPSAFEARRAY),),
            "marshallers" : (agmarshall.LPSafearrayArg,) }
    @property
    def attitude_supported_types(self) -> list:
        """Return an array of valid choices."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_attitude_supported_types_metadata)

    _get_attitude_metadata = { "offset" : _get_attitude_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def attitude(self) -> "IVehicleAttitude":
        """Get the  attitude profile."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_attitude_metadata)

    _get_ground_ellipses_metadata = { "offset" : _get_ground_ellipses_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def ground_ellipses(self) -> "VehicleGroundEllipsesCollection":
        """Get the  ground ellipses properties."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_ground_ellipses_metadata)

    _get_access_constraints_metadata = { "offset" : _get_access_constraints_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def access_constraints(self) -> "AccessConstraintCollection":
        """Get the constraints imposed on the vehicle."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_access_constraints_metadata)

    _get_eclipse_bodies_metadata = { "offset" : _get_eclipse_bodies_method_offset,
            "arg_types" : (POINTER(agcom.PVOID),),
            "marshallers" : (agmarshall.InterfaceOutArg,) }
    @property
    def eclipse_bodies(self) -> "VehicleEclipseBodies":
        """Get the customized list of Eclipse Bodies, which are central bodies used in lighting computations."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_eclipse_bodies_metadata)

    _get_use_terrain_in_lighting_computations_metadata = { "offset" : _get_use_terrain_in_lighting_computations_method_offset,
            "arg_types" : (POINTER(agcom.VARIANT_BOOL),),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @property
    def use_terrain_in_lighting_computations(self) -> bool:
        """Opt whether to compute lighting using terrain data."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_use_terrain_in_lighting_computations_metadata)

    _set_use_terrain_in_lighting_computations_metadata = { "offset" : _set_use_terrain_in_lighting_computations_method_offset,
            "arg_types" : (agcom.VARIANT_BOOL,),
            "marshallers" : (agmarshall.VariantBoolArg,) }
    @use_terrain_in_lighting_computations.setter
    def use_terrain_in_lighting_computations(self, value:bool) -> None:
        return self._intf.set_property(IGreatArcVehicle._metadata, IGreatArcVehicle._set_use_terrain_in_lighting_computations_metadata, value)

    _get_lighting_maximum_step_metadata = { "offset" : _get_lighting_maximum_step_method_offset,
            "arg_types" : (POINTER(agcom.DOUBLE),),
            "marshallers" : (agmarshall.DoubleArg,) }
    @property
    def lighting_maximum_step(self) -> float:
        """Do not use this property, as it is deprecated. Use LightingMaxStepTerrain or LightingMaxStepCbShape as appropriate. The maximum step size to use when computing lighting when UseTerrainInLightingComputations is true. Uses Time Dimension."""
        return self._intf.get_property(IGreatArcVehicle._metadata, IGreatArcVehicle._get_lighting_maximum_step_metadata)

    _set_lighting_maximum_step_metadata = { "offset" : _set_lighting_maximum_step_method_offset,
            "arg_types" : (agcom.DOUBLE,),
            "marshallers" : (agmarshall.DoubleArg,) }
    @lighting_maximum_step.setter
    def lighting_maximum_step(self, max_step:float) -> None:
        return self._intf.set_property(IGreatArcVehicle._metadata, IGreatArcVehicle._set_lighting_maximum_step_metadata, max_step)

    _property_names[route_type] = "route_type"
    _property_names[route_supported_types] = "route_supported_types"
    _property_names[route] = "route"
    _property_names[attitude_type] = "attitude_type"
    _property_names[attitude_supported_types] = "attitude_supported_types"
    _property_names[attitude] = "attitude"
    _property_names[ground_ellipses] = "ground_ellipses"
    _property_names[access_constraints] = "access_constraints"
    _property_names[eclipse_bodies] = "eclipse_bodies"
    _property_names[use_terrain_in_lighting_computations] = "use_terrain_in_lighting_computations"
    _property_names[lighting_maximum_step] = "lighting_maximum_step"


agcls.AgClassCatalog.add_catalog_entry((5279504316049954210, 15594367786580511107), IGreatArcVehicle)
agcls.AgTypeNameMap["IGreatArcVehicle"] = IGreatArcVehicle

class IVehicleGraphics3DBPlaneTargetPointPosition(object):
    """A base class for BPlane target point position interfaces."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4945646807221379868, 9716763658900496770),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleGraphics3DBPlaneTargetPointPosition."""
        initialize_from_source_object(self, source_object, IVehicleGraphics3DBPlaneTargetPointPosition)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleGraphics3DBPlaneTargetPointPosition)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleGraphics3DBPlaneTargetPointPosition, None)



agcls.AgClassCatalog.add_catalog_entry((4945646807221379868, 9716763658900496770), IVehicleGraphics3DBPlaneTargetPointPosition)
agcls.AgTypeNameMap["IVehicleGraphics3DBPlaneTargetPointPosition"] = IVehicleGraphics3DBPlaneTargetPointPosition

class IEOIR(object):
    """Property used to access IEOIR interface."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4997054115735588989, 10978269664136040866),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IEOIR."""
        initialize_from_source_object(self, source_object, IEOIR)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IEOIR)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IEOIR, None)



agcls.AgClassCatalog.add_catalog_entry((4997054115735588989, 10978269664136040866), IEOIR)
agcls.AgTypeNameMap["IEOIR"] = IEOIR

class IVehicleBreakAngle(object):
    """Base Interface IVehicleBreakAngle. VehicleBreakAngleBreakByLatitude and VehicleBreakAngleBreakByLongitude derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (4988134996306585048, 9407320597422388622),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleBreakAngle."""
        initialize_from_source_object(self, source_object, IVehicleBreakAngle)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleBreakAngle)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleBreakAngle, None)



agcls.AgClassCatalog.add_catalog_entry((4988134996306585048, 9407320597422388622), IVehicleBreakAngle)
agcls.AgTypeNameMap["IVehicleBreakAngle"] = IVehicleBreakAngle

class IVehiclePassNumbering(object):
    """Base Interaface IVehiclePassNumbering. PassBreakNumberingDateOfFirstPass and PassBreakNumberingFirstPassNumber derive from this."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5398552838798370779, 18042157829268078765),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehiclePassNumbering."""
        initialize_from_source_object(self, source_object, IVehiclePassNumbering)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehiclePassNumbering)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehiclePassNumbering, None)



agcls.AgClassCatalog.add_catalog_entry((5398552838798370779, 18042157829268078765), IVehiclePassNumbering)
agcls.AgTypeNameMap["IVehiclePassNumbering"] = IVehiclePassNumbering

class IVehicleCoordinateAxes(object):
    """IVehicleCoordinateAxes."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5572439643719372335, 9216755239166683788),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IVehicleCoordinateAxes."""
        initialize_from_source_object(self, source_object, IVehicleCoordinateAxes)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IVehicleCoordinateAxes)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IVehicleCoordinateAxes, None)



agcls.AgClassCatalog.add_catalog_entry((5572439643719372335, 9216755239166683788), IVehicleCoordinateAxes)
agcls.AgTypeNameMap["IVehicleCoordinateAxes"] = IVehicleCoordinateAxes

class IChainTimePeriod(object):
    """Chain time period options."""

    _num_methods = 1
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_type_method_offset = 1
    _metadata = {
        "iid_data" : (5709704128622212135, 13013663028119115678),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type IChainTimePeriod."""
        initialize_from_source_object(self, source_object, IChainTimePeriod)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, IChainTimePeriod)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, IChainTimePeriod, None)

    _get_type_metadata = { "offset" : _get_type_method_offset,
            "arg_types" : (POINTER(agcom.LONG),),
            "marshallers" : (agmarshall.EnumArg(ChainTimePeriodType),) }
    @property
    def type(self) -> "ChainTimePeriodType":
        """Get the option used for setting the chain's time period."""
        return self._intf.get_property(IChainTimePeriod._metadata, IChainTimePeriod._get_type_metadata)

    _property_names[type] = "type"


agcls.AgClassCatalog.add_catalog_entry((5709704128622212135, 13013663028119115678), IChainTimePeriod)
agcls.AgTypeNameMap["IChainTimePeriod"] = IChainTimePeriod

class ICoverageBounds(object):
    """Base interface for ICoverageBoundsCustom, CoverageBoundsGlobal, CoverageBoundsLatitude, CoverageBoundsLatitudeLines, IAgCvBoundsLonLines, CoverageBoundsCustomBoundary."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5367377918736334076, 11585881449721349005),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICoverageBounds."""
        initialize_from_source_object(self, source_object, ICoverageBounds)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICoverageBounds)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICoverageBounds, None)



agcls.AgClassCatalog.add_catalog_entry((5367377918736334076, 11585881449721349005), ICoverageBounds)
agcls.AgTypeNameMap["ICoverageBounds"] = ICoverageBounds

class ICoverageResolution(object):
    """Base interface for CoverageResolutionArea, CoverageResolutionDistance and CoverageResolutionLatLon, used to define coverage resolution (spacing between grid points)."""

    _num_methods = 0
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _metadata = {
        "iid_data" : (5117993917188865935, 4486992342774042278),
        "vtable_reference" : IUnknown._vtable_offset + IUnknown._num_methods - 1,
    }
    _property_names = {}
    def __init__(self, source_object=None):
        """Construct an object of type ICoverageResolution."""
        initialize_from_source_object(self, source_object, ICoverageResolution)
    def _private_init(self, intf:InterfaceProxy):
        self.__dict__["_intf"] = intf
    def __eq__(self, other):
        """Check equality of the underlying STK references."""
        return agcls.compare_com_objects(self, other)
    def _get_property(self, attrname):
        return get_interface_property(attrname, ICoverageResolution)
    def __setattr__(self, attrname, value):
        """Attempt to assign an attribute."""
        set_interface_attribute(self, attrname, value, ICoverageResolution, None)



agcls.AgClassCatalog.add_catalog_entry((5117993917188865935, 4486992342774042278), ICoverageResolution)
agcls.AgTypeNameMap["ICoverageResolution"] = ICoverageResolution

class IFigureOfMeritGraphics2DContours(object):
    """Coverage contours."""

    _num_methods = 19
    _vtable_offset = IUnknown._vtable_offset + IUnknown._num_methods
    _get_show_graphics_method_offset = 1
    _set_show_graphics_method_offset = 2
    _get_contour_type_method_offset = 3
    _set_contour_type_method_offset = 4
    _get_color_method_method_offset = 5
    _set_color_method_method_offset = 6
    _get_ramp_color_method_offset = 7
    _get_level_attributes_method_offset = 8
    _get_legend_method_offset = 9
    _get_show_up_to_maximum_only_method_offset