import { Service } from "../service.ts";
export class Users extends Service {
    async list(search = '', limit = 25, offset = 0, orderType = 'ASC') {
        let path = '/users';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'search': search,
            'limit': limit,
            'offset': offset,
            'orderType': orderType
        });
    }
    async create(email, password, name = '') {
        let path = '/users';
        return await this.client.call('post', path, {
            'content-type': 'application/json',
        }, {
            'email': email,
            'password': password,
            'name': name
        });
    }
    async get(userId) {
        let path = '/users/{userId}'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getLogs(userId) {
        let path = '/users/{userId}/logs'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getPrefs(userId) {
        let path = '/users/{userId}/prefs'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async updatePrefs(userId, prefs) {
        let path = '/users/{userId}/prefs'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('patch', path, {
            'content-type': 'application/json',
        }, {
            'prefs': prefs
        });
    }
    async getSessions(userId) {
        let path = '/users/{userId}/sessions'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async deleteSessions(userId) {
        let path = '/users/{userId}/sessions'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
    async deleteSession(userId, sessionId) {
        let path = '/users/{userId}/sessions/{sessionId}'.replace(new RegExp('{userId}', 'g'), userId).replace(new RegExp('{sessionId}', 'g'), sessionId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
    async updateStatus(userId, status) {
        let path = '/users/{userId}/status'.replace(new RegExp('{userId}', 'g'), userId);
        return await this.client.call('patch', path, {
            'content-type': 'application/json',
        }, {
            'status': status
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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