# Welcome to kube-local documentation page

- [Welcome to kube-local documentation page](#welcome-to-kube-local-documentation-page)
  * [About](#about)
  * [Demos](#demos)
  * [Supported distros](#supported-distros)
  * [Supported runtime](#supported-runtime)
  * [Supported container orchestration](#supported-container-orchestration)
  * [How it works?](#how-it-works-)
  * [Examples](#Examples)
  * [Running](#running)
    + [Manual run](#manual-run)
    + [Automatic run](#automatic-run)
  * [About kube-local.profile](#about-kube-localprofile)
    + [General options](#general-options)
    + [Autoinstall](#autoinstall)
    + [Logging](#logging)
    + [Operational System](#operational-system)
    + [Golang](#golang)
    + [Runtime](#runtime)
    + [Runtime Client](#runtime-client)
    + [Runtime Monitor](#runtime-monitor)
    + [Container Orchestration](#container-orchestration)
    + [Container Network](#container-network)
    + [Additional info for the cluster](#additional-info-for-the-cluster)

## About
kube-local is a build tool helper based on [local-up-cluster.sh](https://github.com/kubernetes/kubernetes/blob/master/hack/local-up-cluster.sh). It helps developers set their local Kubernetes environment as either a traditional installer or an automated installer.

**Use cases**:
   - Setup development environment
   - Matrix testing
   - Continuous Integration (CI)
   - Compare outputs from different components
   - *[Add your use case here....]*

## Demos

### Demo 1 - Auto-install in quiet mode and execute kubectl commands
Auto-installing kubernetes and it's requirements with CRI-O as runtime, conmon as runtime monitor and container network with network plugins.
[![asciicast](https://asciinema.org/a/307812.png)](https://asciinema.org/a/307812)

### Demo 2 - Continuous Integration use case
An example for Continuous Integration use case. **Set kubernetes and CRI-O to version 1.13** and execute a script to validate the environment. After execution, remove every file/dir generated by kube-local using **-r option**.
[![asciicast](https://asciinema.org/a/307815.png)](https://asciinema.org/a/307815)

### Demo 3 - Manual Install
Installing a devel environment manually.
[![asciicast](https://asciinema.org/a/307825.png)](https://asciinema.org/a/307825)

## Supported distros
  - [Fedora Linux](https://getfedora.org/)
  - [CentOS](https://www.centos.org/)
  - [Red Hat Enterprise Linux](https://redhat.com) *(needs help/testers)*
  - [openSUSE](https://www.opensuse.org/) *(needs help/testers)*
  - [Debian GNU/Linux](https://www.debian.org/) *(needs help/testers)*
  - [Ubuntu](https://www.ubuntu.com)  (needs help/testers)

## Supported runtime
  - [CRI-O](https://github.com/cri-o/cri-o) - Open Container Initiative-based implementation of Kubernetes Container Runtime Interface

## Supported container orchestration
  - [Kubernetes](https://github.com/kubernetes/kubernetes) - Production-Grade Container Scheduling and Management

## How it works?
   kube-local is based on **bash** as most of the code in kubernetes/hack. There is a configuration file called **kube-local.profile** which specifies all the configurations.

```sh
$ ./kube-local -h
Usage: ./kube-local [OPTION]...

./kube-local - A script for helping deploy a local  cluster

 -a, --autoinstall                      Autoinstall mode, don't ask questions during deploy.
                                        See profile file for additional info and options
                                        regarding autoinstall.

 -p, --profile=FILENAME                 A profile to be loaded and used during execution.
 -c, --command=[FILENAME]               Execute a command(s) in the cluster (requires -o).
 -h, --help                             Display this message and exit.
 -o, --output                           Output (requires -c).
 -r, --run-service-once                 Run the command and stop kubernetes service.
                                        Cleanup env after command execution. (requires -c and -o).

 -q, --quiet                            Quiet mode. Do not print any message into stdout.
                                        Messages can be read from log file.

 -u, --uninstall                        Uninstall all files/dirs generated from this script.
 -s, --container-orchestration-version  Specify the container ORCHESTRATION version.
 -k, --container-runtime-version        Specify the container RUNTIME version.
```

## Examples

## Example 1
Run **Kubernetes 1.13** and **CRI-O 1.13** executing a shell script with kubectl calls.
```
	$ ./kube-local \
            --autoinstall \
            --command /home/myuser/project/kube-local/examples/script \
            --run-service-once \
            --output /tmp/output.kube-local."$(date +"%Y_%m_%d_%I_%M_%p")".log \
            --container-orchestration-version "1.13" \
            --container-runtime-version "1.13"
```

See the output log generated:
```
        $ cat /tmp/output.kube-local.*.log
        ##################### kube-local section begins #################
        Distro: fedora
        Distro version: 31
        Golang version: 1.13.7

        Container Orchestration: kubernetes
        Container Orchestration Version: 1.13

        Container Network: containernetworking
        Container Network Tag: v0.8.1

        Runtime name: cri-o
        Runtime version: 1.13
        Runtime client: cri-tools
        Runtime client version: master
        Runtime monitor: conmon
        Runtime monitor version: master
        ##################### kube-local section ends #################

        ###### kubectl get cs output #######
        NAME                 STATUS    MESSAGE             ERROR
        scheduler            Healthy   ok
        controller-manager   Healthy   ok
        etcd-0               Healthy   {"health":"true"}
        ###### kubectl get cs output #######

        ###### kubectl get pods -A output #######
        NAMESPACE     NAME                                    READY   STATUS    RESTARTS   AGE
        kube-system   kube-dns-74b889989-qdznv                0/3     Pending   0          8s
        kube-system   kubernetes-dashboard-7444f5cff8-xgtzh   0/1     Pending   0          8s
        ###### kubectl get pods -A output #######
```

### Example 2
Execute several kubectl commands via shell script and terminate the service after execution.
```
	$ ./kube-local \
              --autoinstall \
              --command /home/myuser/projects/kube-local/examples/script \
              --run-service-once \
              --output /tmp/output.kube-local."$(date +"%Y_%m_%d_%I_%M_%p")".log

```
See the output log generated:
```
        $ cat /tmp/output.kube-local.*.log
          ##################### kube-local section begins #################
          Distro: fedora
          Distro version: 31
          Golang version: 1.13.7

          Container Orchestration: kubernetes
          Container Orchestration Version: master

          Container Network: containernetworking
          Container Network Tag: v0.8.1

          Runtime name: cri-o
          Runtime version: master
          Runtime client: cri-tools
          Runtime client version: master
          Runtime monitor: conmon
          Runtime monitor version: master
          ##################### kube-local section ends #################


          ###### kubectl get cs output #######
          NAME                 STATUS    MESSAGE             ERROR
          controller-manager   Healthy   ok
          etcd-0               Healthy   {"health":"true"}
          scheduler            Healthy   ok
          ###### kubectl get cs output #######


          ###### kubectl get pods -A output #######
          NAMESPACE     NAME                                    READY   STATUS    RESTARTS   AGE
          kube-system   kube-dns-74b889989-phf5b                0/3     Pending   0          7s
          kube-system   kubernetes-dashboard-7444f5cff8-qptr8   0/1     Pending   0          7s
          ###### kubectl get pods -A output #######
```
### Example 3
Execute kubectl get services command and keep the service alive.
```
	$ ./kube-local \
	      -c "kubectl get services" \
	      -o /tmp/output.kube-local."$(date +"%Y_%m_%d_%I_%M_%p")".log
```

See the output log generated:
```
        $ cat /tmp/output.kube-local.*.log
         ##################### kube-local section begins #################
         Distro: fedora
         Distro version: 31
         Golang version: 1.13.7

         Container Orchestration: kubernetes
         Container Orchestrationi Version: master

         Container Network: containernetworking
         Container Network Tag: v0.8.1

         Runtime name: cri-o
         Runtime version: master
         Runtime client: cri-tools
         Runtime client version: master
         Runtime monitor: conmon
         Runtime monitor version: master
         ##################### kube-local section begin #################

         NAME         TYPE        CLUSTER-IP   EXTERNAL-IP   PORT(S)   AGE
         kubernetes   ClusterIP   10.0.0.1     <none>        443/TCP   16s
```

Service still alive, let's trigger others commands..
```
         $ source /etc/profile
         $ kubectl get cs
```
## Running

### Manual run

Manual Install might query about the environment.

```sh
$ ./kube-local
```

### Automatic run

Use **-a for autoinstall** or change the profile file as described below.

1. Make a backup of original profile file
```sh
$ cp kube-local.profile kube-local.profile.orig
```

2. Change AUTOINSTALL option via sed
```
$ sed -i 's/AUTOINSTALL=false/AUTOINSTALL=true/g' kube-local.profile
```
3. Execute kube-local
```
$ ./kube-local
```

## About kube-local.profile

kube-local.profile is a configuration file, all options described below.

### General options
|  Name| Description |
| ------ | ------ |
| PRINT_DEBUG_ENABLED | Enable debug messages be printed (**true** or **false**) |
| MAKE_NUMBER_OF_JOBS | The number of jobs for **make** command. |
| EEXIST | A macro to define if the project which is about to be git cloned already exists |
| CONFIG_HEADER | Define where the config section begins |
| CONFIG_HEADER_END | Define where the config section ends |
| KUBECTL_SCRIPT | A kubectl script or command to be executed |
| OUTPUT_FILENAME | Output file (please specify full path) |

### Autoinstall
| Name | Description |
| ------ | ------ |
| AUTOINSTALL | Install without prompting user for input - **auto deploy mode** |
| AUTO_UPDATE_SYSTEM | Automatically update the system via (dnf/apt-get/etc) before making a new install. (**use: -y or comment this option**) |
| AUTO_INSTALL_PACKAGES | Automatically install required packages via (dnf/apt-get/etc) before making a new install. (**use: -y or comment this option**) |
| AUTO_REBOOT | Automatically reboot the system - (*ONLY required when changing kernel params from cgroupv2 to cgroupv1*) (**true** or **false**) |
| AUTO_CLEAN | Automatically clean all files/dirs generated by this script (**true** or **false**)
| AUTO_REMOVE_EXISTING_GOLANG_FROM_DISTRO_PACKAGING | Distros can ship via packaging system (rpm/deb/etc) golang and having multiple verions of golang installed can generate conflicts. This option (if enabled) try to detect the golang package installed and remove it for installing new golang version. (**true** or **false**)
| AUTO_REMOVE_GOLANG_DIR | If detected a existing golang dir from previous installation, remove it. (**true** or **false**)

### Logging
| Name | Description |
| ------ | ------ |
| LOGGING |  Enable logging (**true** or **false**) For path, see: ${LOGDIR}/${LOGFILE} |
| LOGDIR | Directory for storing the logs. Default: **/tmp** |
| LOGFILE | The log file
| LOGGING_FILTER | A filter for the type of message to be displayed in the log file. Default: DEBUG INFO WARNING FAIL OK|

### Operational System
| Name | Description |
| ------ | ------ |
| DISTRO_NAME | The OS Distribution name. **Automatically filled in the script** via /etc/os-release
| DISTRO_CMD_TOOL | The OS Distribuition command name. **Automatically filled in the script**. Example dnf, apt-get, etc
| DISTRO_PKG_MANAGER | The OS Distribution package manager. **Automatically filled in the script**. Example: dpkg, rpm, etc.
| DISTRO_VERSION_ID | The OS Distribution version. **Automatically filled in the script** via /etc/os-release. Example: 8 (from RHEL 8)

### Golang
| Name | Description |
| ------ | ------ |
| GOLANG_ARCH |  Golang arch. Default: **linux-amd64**
| GOLANG_VERSION |  Golang version. Example: **1.13.7**
| GOLANG_TAG |  Speficy a Golang tag name
| GOLANG_TAR_FILENAME | Golang tar file name
| GOLANG_TAR_URL | Golang tar URL
| GOLANG_HASH |  Algo for hash verification. Default: **sha256**
| GOLANG_HASH_FILENAME | Golang hash file name
| GOLANG_HASH_URL | Golang hash URL
| GOLANG_DIR_INSTALL | Path for installing Golang. Default: **/usr/local**
| GOLANG_DIR_PATH | Golang path. Default: **/usr/local/go**
| GOLANG_DIR_PATH_BIN | Golang bin path. Default: **/usr/local/go/bin**
| GOLANG_PROJECT_HOME| Golang project **home** dir. Default: **${HOME}/go**
| GOLANG_PROJECT_HOME_SRC| Golang project **src** dir. Default: **${GOLANG_PROJECT_HOME}/go/src**
| GOLANG_PROJECT_HOME_SRC_GITHUB| Golang project **src** for **github.com** dir. Default: **${GOLANG_PROJECT_HOME_SRC}/github.com**
| GOLANG_PROJECT_HOME_BIN| Golang project **bin** dir. Default: **${GOLANG_PROJECT_HOME}/go/bin**"
| GOLANG_BIN| Path to Golang binary. Default: **${GOLANG_DIR_INSTALL}/go/bin/go**
| GO_ENV_VARS| Path where to storing Golang variables. Default (available to all users): **/etc/profile**

### Runtime
| Name | Description |
| ------ | ------ |
| RUNTIME_NAME| Runtime name. Default: **cri-o**
| RUNTIME_GITHUB_URL | Runtime github URL
| RUNTIME_OPTIONAL_PACKAGES | Optional packages for the runtime. This option is <br>**filled automatically inside the script** as dependent on the detected distro.
| RUNTIME_VERSION | Runtime version. Example: master, release-1.13, etc
| RUNTIME_TAG | Runtime specific tag
| RUNTIME_GOLANG_SRC_GITHUB | Runtime Golang src github dir. Default: **github.com**
| RUNTIME_GOLANG_DIR | Runtime Golang project dir.
| RUNTIME_ENDPOINT | Runtim endpoint. Default: **/var/run/crio/crio.sock**

### Runtime Client
| Name | Description |
| ------ | ------ |
| RUNTIME_CLIENT_NAME| Runtime client name. Default: **cri-tools**
| RUNTIME_CLIENT_GITHUB_URL| Runtime client github URL.<br> Default: **https://github.com/kubernetes-sigs/cri-tools**
| RUNTIME_CLIENT_VERSION| Runtime client version. Example: master, release-1.13, etc
| RUNTIME_CLIENT_TAG|  Runtime client specific tag
| RUNTIME_CLIENT_GOLANG_SRC_GITHUB|  Runtime Client Golang src github dir. Default: **github.com**
| RUNTIME_CLIENT_GOLANG_DIR| Runtime Client Golang project dir.

### Runtime Monitor
| Name | Description |
| ------ | ------ |
| RUNTIME_MONITOR| Runtime monitor. Default **conmon**
| RUNTIME_MONITOR_GITHUB_URL|  Runtime monitor github URL.<br> Default: **https://github.com/containers/conmon**
| RUNTIME_MONITOR_VERSION| Runtime monitor version. Example: master
| RUNTIME_MONITOR_TAG| Runtime monitor specific tag
| RUNTIME_MONITOR_GOLANG_SRC_GITHUB| Runtime monitor Golang src github dir. Default: **github.com**
| RUNTIME_MONITOR_GOLANG_DIR| Runtime Client Golang project dir.

### Container Orchestration
| Name | Description |
| ------ | ------ |
| CONTAINER_ORCHESTRATION_NAME| Container Orchestration name. Default **kubernetes**
| CONTAINER_ORCHESTRATION_GITHUB_URL| Container Orchestration github URL.
| CONTAINER_ORCHESTRATION_VERSION| Container Orchestration version. <br>Example: master, release-1.13, etc
| CONTAINER_ORCHESTRATION_TAG| Container Orchestration tag
| CONTAINER_ORCHESTRATION_GOLANG_SRC_GITHUB| Container Orchestration Golang src github dir
| CONTAINER_ORCHESTRATION_GOLANG_DIR| Container Orchestration  Golang dir
| CONTAINER_ORCHESTRATION_KUBECONFIG_NAME| Kubeconfig filename.
| CONTAINER_ORCHESTRATION_KUBECONFIG_PATH| Full path for Kubeconfig
| CONTAINER_ORCHESTRATION_OUTPUT_DIR| Container Orchestration output dir.
| CONTAINER_ORCHESTRATION_ETCD| Etcd path.
| CONTAINER_ORCHESTRATION_SERVICES| Container Orchestration services.

### Container Network
| Name | Description |
| ------ | ------ |
| CONTAINER_NETWORK_REPO_NAME| Container Network repo name. Default **containernetworking**
| CONTAINER_NETWORK_REPO_PLUGIN_DIR| Container Network plugin dir **plugins**
| CONTAINER_NETWORK_GOLANG_SRC_GITHUB| Container Network Golang src github dir
| CONTAINER_NETWORK_GOLANG_DIR| Container Network Golang dir.
| CONTAINER_NETWORK_GITHUB_URL| Container Network Github URL.
| CONTAINER_NETWORK_VERSION| Container Network version. Example: master.<br> Please note: No need to assign if using tag
| CONTAINER_NETWORK_TAG| Container Network tag. Example: **v0.8.1**
| CONTAINER_NETWORK_CNI_PATH| Container Network CNI path. Default: **/opt/cni**
| CONTAINER_NETWORK_CNI_PATH_BIN| Container Network CNI Bin path.
| CONTAINER_NETWORK_PLUGINS| Container Network plugins.

### Additional info for the cluster
| Name | Description |
| ------ | ------ |
| IP_LOCALHOST| Local IP address.
| FEATURE_GATES| Feature gates are a set of key=value pairs that describe Kubernetes features. Default: **AllAlpha=false,RunAsGroup=true**
| PATH_PROJECTS| Add additional path to ${PATH} env var.
| CONTAINER_RUNTIME| The container runtime to use. Default: **remote**
| CGROUP_DRIVER| Cgroup driver. Default: **systemd**
| CONTAINER_RUNTIME_ENDPOINT| Container runtime endpoint. Default: **${RUNTIME_ENDPOINT}**
| ALLOW_SECURITY_CONTEXT| Allow Security Context. Default: **","**
| ALLOW_PRIVILEGED| Allow privileged process. Default: **1**
| DNS_SERVER_IP| DNS Server IP. Default: **${IP_LOCALHOST}**
| API_HOST| API Host. Default: **${IP_LOCALHOST}**
| API_HOST_IP| API Host IP. Default: **${IP_LOCALHOST}**
| KUBE_ENABLE_CLUSTER_DNS| Default: **true**
| ENABLE_HOSTPATH_PROVISIONER| Default: **true**
| KUBE_ENABLE_CLUSTER_DASHBOARD| Default: **true**
| KUBECONFIG | Path for the Kubeconfig. Default: **${CONTAINER_ORCHESTRATION_KUBECONFIG_PATH}**
| KUBERNETES_PROVIDER | Default: **local**
