# Contributing

In an effort to keep the library small and stable, please keep contributions limited to bug fixes, documentation improvements, and test improvements.

Issues that are tagged as [help wanted](https://github.com/coil-kt/coil/labels/help%20wanted) are great issues to get started contributing to Coil.

If you have a new feature idea, please [create an enhancement request](https://github.com/coil-kt/coil/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=) so it can be discussed or build it in an external library.

If you’ve found a bug, please contribute a failing test case so we can study and fix it.

If you would like to contribute code you can do so through GitHub by forking the repository and sending a pull request.

When submitting code, please make every effort to follow existing conventions and style in order to keep the code as readable as possible. Please also make sure your code passes all tests by running `./test.sh`.

If you are making an API change, run `./gradlew apiDump` and include any changed files in your pull request.

*Modified from OkHttp's [Contributing](https://square.github.io/okhttp/contributing/) section.*
