---
Number: 4
Title: JSON-Schema As Specification
Category: General
Status: accepted
---

<!-- ADR template adapted from Michael Nygard's -->

## Context

<!-- What is the issue that we're seeing that is motivating this decision or change? -->

Ogmios' interface is JSON-based and quite large since it covers the **entire** Cardano eco-system (200+ type definitions). Documenting such a large interface is challenging. In addition, we want to make it easy for clients to integrate with the interface. 

## Decision(s)

<!-- What is the change that we're proposing and/or doing? -->

We will write and use JSON-schema to specify the entire application interface. Said differently, we want this schema to be **written by hand** (as opposed to generated by some tool). This also means that the application should be tested against the schema (and not the other way around) to control the concordance of the implementation with the specification.

## Consequences

<!-- What becomes easier or more difficult to do because of this change? -->

- We can control that it looks right an make sure that it is easy to consume by programs / clients. 

- The specification provides an immense tool for testing and verifying the correctness of JSON instances. 

- We can easily add description, examples and additional bits to the schema to enhance it for human consumption. It serves as a central source of truth for both specification and documentation. 

- It is possible to generate clients (or at least, typed interfaces for clients) from the specification. There are a few gotchas to manually control in the generation process to make sure that the generated output is okay (e.g. properly naming models and be careful about conflicting names).

- Similarly, we can automatically generate documentation from the specification, which thanks to the tests is kept in sync with the implementation.
