/* tslint:disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

export type PointOrOrigin = Point | Origin;
/**
 * An absolute slot number.
 */
export type Slot = number;
/**
 * A Blake2b 32-byte hash digest, encoded in base16.
 */
export type DigestBlake2B256 = string;
/**
 * The origin of the blockchain. This point is special in the sense that it doesn't point to any existing slots, but is preceding any existing other point.
 */
export type Origin = "origin";
export type TipOrOrigin = Tip | Origin;
/**
 * A block number, the i-th block to be minted is number i.
 */
export type BlockHeight = number;
export type Block = BlockEBB | BlockBFT | BlockPraos;
export type Int64 = number;
/**
 * A Blake2b 32-byte hash digest of a transaction body
 */
export type TransactionId = string;
export type UInt32 = number;
/**
 * A Cardano address (either legacy format or new format).
 */
export type Address = string;
/**
 * A number of asset, can be negative went burning assets.
 */
export type AssetQuantity = bigint;
export type Datum = string;
export type Script = Native | Plutus;
/**
 * A phase-1 monetary script. Timelocks constraints are only supported since Allegra.
 */
export type ScriptNative = ClauseSignature | ClauseAny | ClauseAll | ClauseSome | ClauseBefore | ClauseAfter;
/**
 * A Blake2b 28-byte hash digest, encoded in base16.
 */
export type DigestBlake2B224 = string;
export type Certificate =
  | StakeDelegation
  | StakeCredentialRegistration
  | StakeCredentialDeregistration
  | StakePoolRegistration
  | StakePoolRetirement
  | GenesisDelegation;
/**
 * A Blake2b 32-byte hash digest of a pool's verification key.
 */
export type StakePoolId = string;
export type DelegateRepresentative =
  | DelegateRepresentativeRegistered
  | DelegateRepresentativeNoConfidence
  | DelegateRepresentativeAbstain;
/**
 * A special delegate representative which always vote no, except on votes of no-confidence.
 */
export type DelegateRepresentativeNoConfidence = "noConfidence";
/**
 * A special delegate representative which always abstain.
 */
export type DelegateRepresentativeAbstain = "abstain";
/**
 * A ratio of two integers, to express exact fractions.
 */
export type Ratio = string;
/**
 * A reward account, also known as 'stake address'.
 */
export type RewardAccount = string;
/**
 * A hash digest from an unspecified algorithm and length.
 */
export type DigestAny = string;
export type Relay = RelayByAddress | RelayByName;
/**
 * An epoch number or length.
 */
export type Epoch = number;
/**
 * A network target, as defined since the Shelley era.
 */
export type Network = "mainnet" | "testnet";
export type UInt64 = number;
export type Nonce = Neutral | DigestBlake2B256;
export type Neutral = "neutral";
export type CostModel = Int64[];
export type Metadatum = Integer | String | ArrayMetadatum | ObjectMetadatum;
export type Integer = bigint;
export type String = string;
export type ArrayMetadatum = Metadatum[];
/**
 * An Ed25519 verification key.
 */
export type VerificationKey = string;
/**
 * An EdDSA signature.
 */
export type Signature = string;
/**
 * An Ed25519-BIP32 chain-code for key deriviation.
 */
export type ChainCode = string;
/**
 * Extra attributes carried by Byron addresses (network magic and/or HD payload).
 */
export type AddressAttributes = string;
/**
 * Plutus data, CBOR-serialised.
 */
export type RedeemerData = string;
export type BootstrapProtocolId = number;
/**
 * An Ed25519-BIP32 Byron genesis delegate verification key with chain-code.
 */
export type ExtendedVerificationKey = string;
export type GenesisHash = "genesis";
export type VrfProof = string;
export type VrfOutput = string;
export type KesVerificationKey = string;
export type SubmitTransactionFailure =
  | SubmitTransactionFailureEraMismatch
  | SubmitTransactionFailureInvalidSignatories
  | SubmitTransactionFailureMissingSignatories
  | SubmitTransactionFailureMissingScripts
  | SubmitTransactionFailureFailingNativeScript
  | SubmitTransactionFailureExtraneousScripts
  | SubmitTransactionFailureMissingMetadataHash
  | SubmitTransactionFailureMissingMetadata
  | SubmitTransactionFailureMetadataHashMismatch
  | SubmitTransactionFailureInvalidMetadata
  | SubmitTransactionFailureMissingRedeemers
  | SubmitTransactionFailureExtraneousRedeemers
  | SubmitTransactionFailureMissingDatums
  | SubmitTransactionFailureExtraneousDatums
  | SubmitTransactionFailureScriptIntegrityHashMismatch
  | SubmitTransactionFailureOrphanScriptInputs
  | SubmitTransactionFailureMissingCostModels
  | SubmitTransactionFailureMalformedScripts
  | SubmitTransactionFailureUnknownOutputReferences
  | SubmitTransactionFailureOutsideOfValidityInterval
  | SubmitTransactionFailureTransactionTooLarge
  | SubmitTransactionFailureValueTooLarge
  | SubmitTransactionFailureEmptyInputSet
  | SubmitTransactionFailureTransactionFeeTooSmall
  | SubmitTransactionFailureValueNotConserved
  | SubmitTransactionFailureNetworkMismatch
  | SubmitTransactionFailureInsufficientlyFundedOutputs
  | SubmitTransactionFailureBootstrapAttributesTooLarge
  | SubmitTransactionFailureMintingOrBurningAda
  | SubmitTransactionFailureInsufficientCollateral
  | SubmitTransactionFailureCollateralLockedByScript
  | SubmitTransactionFailureUnforeseeableSlot
  | SubmitTransactionFailureTooManyCollateralInputs
  | SubmitTransactionFailureMissingCollateralInputs
  | SubmitTransactionFailureNonAdaCollateral
  | SubmitTransactionFailureExecutionUnitsTooLarge
  | SubmitTransactionFailureTotalCollateralMismatch
  | SubmitTransactionFailureSpendsMismatch
  | SubmitTransactionFailureUnauthorizedVote
  | SubmitTransactionFailureUnknownGovernanceProposal
  | SubmitTransactionFailureInvalidProtocolParametersUpdate
  | SubmitTransactionFailureUnknownStakePool
  | SubmitTransactionFailureIncompleteWithdrawals
  | SubmitTransactionFailureRetirementTooLate
  | SubmitTransactionFailureStakePoolCostTooLow
  | SubmitTransactionFailureMetadataHashTooLarge
  | SubmitTransactionFailureCredentialAlreadyRegistered
  | SubmitTransactionFailureUnknownCredential
  | SubmitTransactionFailureNonEmptyRewardAccount
  | SubmitTransactionFailureInvalidGenesisDelegation
  | SubmitTransactionFailureInvalidMIRTransfer
  | SubmitTransactionFailureUnrecognizedCertificateType
  | SubmitTransactionFailureInternalLedgerTypeConversionError;
export type Era = "byron" | "shelley" | "allegra" | "mary" | "alonzo" | "babbage" | "conway";
export type ScriptPurpose = ScriptPurposeSpend | ScriptPurposeMint | ScriptPurposePublish | ScriptPurposeWithdraw;
/**
 * A Blake2b 28-byte hash digest, encoded in base16.
 */
export type PolicyId = string;
export type RedeemerPointer = string;
export type Language = "plutus:v1" | "plutus:v2" | "plutus:v3";
export type VoterRole = "constitutionalCommittee" | "delegateRepresentative" | "stakePoolOperator";
export type Utxo = {
  transaction: {
    id: TransactionId;
  };
  index: UInt32;
  address: Address;
  value: Value;
  datumHash?: DigestBlake2B256;
  datum?: Datum;
  script?: Script;
}[];
export type EvaluateTransactionFailure =
  | EvaluateTransactionFailureIncompatibleEra
  | EvaluateTransactionFailureUnsupportedEra
  | EvaluateTransactionFailureOverlappingAdditionalUtxo
  | EvaluateTransactionFailureNodeTipTooOld
  | EvaluateTransactionFailureCannotCreateEvaluationContext
  | EvaluateTransactionFailureScriptExecutionFailure;
export type ScriptExecutionFailure =
  | ScriptExecutionFailureMissingScript
  | ScriptExecutionFailureValidationFailure
  | ScriptExecutionFailureUnsuitableOutputReference
  | SubmitTransactionFailureExtraneousRedeemers
  | SubmitTransactionFailureMissingDatums
  | SubmitTransactionFailureUnknownOutputReferences
  | SubmitTransactionFailureMissingCostModels
  | SubmitTransactionFailureInternalLedgerTypeConversionError;
/**
 * Number of slots from the tip of the ledger in which it is guaranteed that no hard fork can take place. This should be (at least) the number of slots in which we are guaranteed to have k blocks.
 */
export type SafeZone = number;
export type AnyStakeCredential = Base16 | Bech32 | StakeAddress;
/**
 * A stake key or script hash in base16.
 */
export type Base16 = string;
/**
 * A Blake2b 28-byte hash digest of a verification key or script.
 */
export type Bech32 = string;
/**
 * A stake address (a.k.a reward account)
 */
export type StakeAddress = string;
export type EraWithGenesis = "byron" | "shelley" | "alonzo" | "conway";
export type UtcTime = string;
/**
 * A magic number for telling networks apart. (e.g. 764824073)
 */
export type NetworkMagic = number;
export type InitialDelegates = {
  issuer: {
    id: DigestBlake2B224;
  };
  delegate: GenesisDelegate;
}[];

export interface Ogmios {
  FindIntersection: FindIntersection;
  FindIntersectionResponse: IntersectionFound | IntersectionNotFound | IntersectionInterleaved;
  NextBlock: NextBlock;
  NextBlockResponse: NextBlockResponse;
  SubmitTransaction: SubmitTransaction;
  SubmitTransactionResponse: SubmitTransactionSuccess | SubmitTransactionError | SubmitTransactionDeserialisationError;
  EvaluateTransaction: EvaluateTransaction;
  EvaluateTransactionResponse:
    | EvaluateTransactionSuccess
    | EvaluateTransactionError
    | EvaluateTransactionDeserialisationError;
  AcquireLedgerState: AcquireLedgerState;
  AcquireLedgerStateFailure?: AcquireLedgerStateFailure;
  AcquireLedgerStateResponse: AcquireLedgerStateSuccess | AcquireLedgerStateFailure;
  ReleaseLedgerState: ReleaseLedgerState;
  ReleaseLedgerStateResponse: ReleaseLedgerStateResponse;
  QueryLedgerStateEraMismatch?: QueryLedgerStateEraMismatch;
  QueryLedgerStateUnavailableInCurrentEra?: QueryLedgerStateUnavailableInCurrentEra;
  QueryLedgerStateAcquiredExpire?: QueryLedgerStateAcquiredExpired;
  QueryLedgerStateEpoch: QueryLedgerStateEpoch;
  QueryLedgerStateEpochResponse:
    | QueryLedgerStateEpochResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateEraStart: QueryLedgerStateEraStart;
  QueryLedgerStateEraStartResponse:
    | QueryLedgerStateEraStartResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateEraSummaries: QueryLedgerStateEraSummaries;
  QueryLedgerStateEraSummariesResponse:
    | QueryLedgerStateEraSummariesResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateLiveStakeDistribution: QueryLedgerStateLiveStakeDistribution;
  QueryLedgerStateLiveStakeDistributionResponse:
    | QueryLedgerStateLiveStakeDistributionResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateProjectedRewards: QueryLedgerStateProjectedRewards;
  QueryLedgerStateProjectedRewardsResponse:
    | QueryLedgerStateProjectedRewardsResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateProposedProtocolParameters: QueryLedgerStateProposedProtocolParameters;
  QueryLedgerStateProposedProtocolParametersResponse:
    | QueryLedgerStateProposedProtocolParametersResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateProtocolParameters: QueryLedgerStateProtocolParameters;
  QueryLedgerStateProtocolParametersResponse:
    | QueryLedgerStateProtocolParametersResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateRewardAccountSummaries: QueryLedgerStateRewardAccountSummaries;
  QueryLedgerStateRewardAccountSummariesResponse:
    | QueryLedgerStateRewardAccountSummariesResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateRewardsProvenance: QueryLedgerStateRewardsProvenance;
  QueryLedgerStateRewardsProvenanceResponse:
    | QueryLedgerStateRewardsProvenanceResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateStakePools: QueryLedgerStateStakePools;
  QueryLedgerStateStakePoolsResponse:
    | QueryLedgerStateStakePoolsResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateTip: QueryLedgerStateTip;
  QueryLedgerStateTipResponse:
    | QueryLedgerStateTipResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryLedgerStateUtxo: QueryLedgerStateUtxo;
  QueryLedgerStateUtxoResponse:
    | QueryLedgerStateUtxoResponse
    | QueryLedgerStateEraMismatch
    | QueryLedgerStateUnavailableInCurrentEra
    | QueryLedgerStateAcquiredExpired;
  QueryNetworkBlockHeight: QueryNetworkBlockHeight;
  QueryNetworkBlockHeightResponse: QueryNetworkBlockHeightResponse;
  QueryNetworkGenesisConfiguration: QueryNetworkGenesisConfiguration;
  QueryNetworkGenesisConfigurationResponse: QueryNetworkGenesisConfigurationResponse;
  QueryNetworkStartTime: QueryNetworkStartTime;
  QueryNetworkStartTimeResponse: QueryNetworkStartTimeResponse;
  QueryNetworkTip: QueryNetworkTip;
  QueryNetworkTipResponse: QueryNetworkTipResponse;
  AcquireMempool: AcquireMempool;
  AcquireMempoolResponse: AcquireMempoolResponse;
  NextTransaction: NextTransaction;
  MustAcquireMempoolFirst?: MustAcquireMempoolFirst;
  NextTransactionResponse: NextTransactionResponse | MustAcquireMempoolFirst;
  HasTransaction: HasTransaction;
  HasTransactionResponse: HasTransactionResponse | MustAcquireMempoolFirst;
  SizeOfMempool: SizeOfMempool;
  SizeOfMempoolResponse?: SizeOfMempoolResponse | MustAcquireMempoolFirst;
  ReleaseMempool: ReleaseMempool;
  ReleaseMempoolResponse: ReleaseMempoolResponse | MustAcquireMempoolFirst;
  RpcError: RpcError;
}
/**
 * Ask cardano-node to find an intersection between its local chain and the given points.
 */
export interface FindIntersection {
  jsonrpc: "2.0";
  method: "findIntersection";
  params: {
    points?: PointOrOrigin[];
  };
  id?: unknown;
}
/**
 * A point on the chain, identified by a slot and a block header hash.
 */
export interface Point {
  slot: Slot;
  id: DigestBlake2B256;
}
export interface IntersectionFound {
  jsonrpc: "2.0";
  method: "findIntersection";
  result: {
    intersection: PointOrOrigin;
    tip: TipOrOrigin;
  };
  id?: unknown;
}
export interface Tip {
  slot: Slot;
  id: DigestBlake2B256;
  height: BlockHeight;
}
export interface IntersectionNotFound {
  jsonrpc: "2.0";
  method: "findIntersection";
  /**
   * No intersection found with the requested points.
   */
  error: {
    code: 1000;
    message: string;
    data: {
      tip: TipOrOrigin;
    };
  };
  id?: unknown;
}
export interface IntersectionInterleaved {
  jsonrpc: "2.0";
  method: "findIntersection";
  /**
   * An internal error indicating that requests were interleaved in an unexpected way. Shouldn't ever happen.
   */
  error: {
    code: 1001;
    message: string;
  };
  id?: unknown;
}
/**
 * Request next block from the current cardano-node's cursor.
 */
export interface NextBlock {
  jsonrpc: "2.0";
  method: "nextBlock";
  id?: unknown;
}
/**
 * Response to a 'nextBlock' request.
 */
export interface NextBlockResponse {
  jsonrpc: "2.0";
  method: "nextBlock";
  result: RollForward | RollBackward;
  id?: unknown;
}
export interface RollForward {
  direction: "forward";
  tip: Tip;
  block: Block;
}
export interface BlockEBB {
  type: "ebb";
  era: "byron";
  id: DigestBlake2B256;
  ancestor: DigestBlake2B256;
  height: BlockHeight;
}
export interface BlockBFT {
  type: "bft";
  era: "byron";
  id: DigestBlake2B256;
  ancestor: DigestBlake2B256;
  height: BlockHeight;
  slot: Slot;
  size: {
    bytes: Int64;
  };
  transactions?: Transaction[];
  operationalCertificates?: BootstrapOperationalCertificate[];
  protocol: {
    id: BootstrapProtocolId;
    version: ProtocolVersion;
    software: SoftwareVersion;
    update?: BootstrapProtocolUpdate;
  };
  issuer: {
    verificationKey: ExtendedVerificationKey;
  };
  delegate: {
    verificationKey: ExtendedVerificationKey;
  };
}
export interface Transaction {
  id: DigestBlake2B256;
  spends: "inputs" | "collaterals";
  inputs: TransactionOutputReference[];
  references?: TransactionOutputReference[];
  collaterals?: TransactionOutputReference[];
  totalCollateral?: Lovelace;
  collateralReturn?: TransactionOutput;
  outputs: TransactionOutput[];
  certificates?: Certificate[];
  withdrawals?: Withdrawals;
  fee?: Lovelace;
  validityInterval?: ValidityInterval;
  mint?: Assets;
  network?: Network;
  scriptIntegrityHash?: DigestBlake2B256;
  requiredExtraSignatories?: DigestBlake2B224[];
  requiredExtraScripts?: DigestBlake2B224[];
  proposals?: GovernanceProposal[];
  votes?: GovernanceVote[];
  metadata?: Metadata;
  signatories: Signatory[];
  scripts?: {
    [k: string]: Script;
  };
  datums?: {
    [k: string]: Datum;
  };
  redeemers?: {
    [k: string]: Redeemer;
  };
  /**
   * The raw serialized (CBOR) transaction, as found on-chain.
   */
  cbor?: string;
}
export interface TransactionOutputReference {
  transaction: {
    id: TransactionId;
  };
  index: UInt32;
}
export interface Lovelace {
  /**
   * A number of lovelace, possibly large when summed up.
   */
  lovelace: bigint;
}
/**
 * A transaction output. 'datum' and 'datumHash' are never present together.
 */
export interface TransactionOutput {
  address: Address;
  value: Value;
  datumHash?: DigestBlake2B256;
  datum?: Datum;
  script?: Script;
}
export interface Value {
  ada: {
    lovelace: bigint;
  };
  [k: string]: {
    [k: string]: AssetQuantity;
  };
}
export interface Native {
  language: "native";
  json: ScriptNative;
  cbor?: string;
}
export interface ClauseSignature {
  clause: "signature";
  from: DigestBlake2B224;
}
export interface ClauseAny {
  clause: "any";
  from: ScriptNative[];
}
export interface ClauseAll {
  clause: "all";
  from: ScriptNative[];
}
export interface ClauseSome {
  clause: "some";
  atLeast: bigint;
  from: ScriptNative[];
}
export interface ClauseBefore {
  clause: "before";
  slot: Slot;
}
export interface ClauseAfter {
  clause: "after";
  slot: Slot;
}
export interface Plutus {
  language: "plutus:v1" | "plutus:v2" | "plutus:v3";
  cbor: string;
}
/**
 * A stake delegation certificate, from a delegator to a stake pool.
 */
export interface StakeDelegation {
  type: "stakeDelegation";
  credential: DigestBlake2B224;
  stakePool?: {
    id: StakePoolId;
  };
  delegateRepresentative?: DelegateRepresentative;
}
export interface DelegateRepresentativeRegistered {
  id: DigestBlake2B224;
}
/**
 * A stake credential (key or script) registration certificate. The field 'deposit' is only present in Conway onwards.
 */
export interface StakeCredentialRegistration {
  type: "stakeCredentialRegistration";
  credential: DigestBlake2B224;
  deposit?: Lovelace;
}
/**
 * A stake key de-registration certificate. The field 'deposit' is only present in Conway onwards.
 */
export interface StakeCredentialDeregistration {
  type: "stakeCredentialDeregistration";
  credential: DigestBlake2B224;
  deposit?: Lovelace;
}
/**
 * A stake pool registration certificate.
 */
export interface StakePoolRegistration {
  type: "stakePoolRegistration";
  stakePool: StakePool;
}
export interface StakePool {
  id: StakePoolId;
  vrfVerificationKeyHash: DigestBlake2B256;
  owners: DigestBlake2B224[];
  cost: Lovelace;
  margin: Ratio;
  pledge: Lovelace;
  rewardAccount: RewardAccount;
  metadata?: Anchor;
  relays: Relay[];
}
export interface Anchor {
  hash: DigestAny;
  url: string;
}
export interface RelayByAddress {
  type: "ipAddress";
  ipv4?: string;
  ipv6?: string;
  port?: number;
}
export interface RelayByName {
  type: "hostname";
  hostname: string;
  port?: number;
}
/**
 * A stake pool retirement certificate.
 */
export interface StakePoolRetirement {
  type: "stakePoolRetirement";
  stakePool: {
    retirementEpoch: Epoch;
    id: StakePoolId;
  };
}
export interface GenesisDelegation {
  type: "genesisDelegation";
  delegate: {
    id: DigestBlake2B224;
  };
  issuer: {
    id: DigestBlake2B224;
    vrfVerificationKeyHash: DigestBlake2B256;
  };
}
export interface Withdrawals {
  [k: string]: Lovelace;
}
export interface ValidityInterval {
  invalidBefore?: Slot;
  invalidAfter?: Slot;
}
export interface Assets {
  [k: string]: {
    [k: string]: AssetQuantity;
  };
}
export interface GovernanceProposal {
  deposit?: Lovelace;
  returnAccount?: DigestBlake2B224;
  anchor?: Anchor;
  action:
    | GovernanceActionProtocolParametersUpdate
    | GovernanceActionHardForkInitiation
    | GovernanceActionTreasuryTransfer
    | GovernanceActionTreasuryWithdrawals
    | GovernanceActionConstitutionalCommittee
    | GovernanceActionConstitution
    | GovernanceActionNoConfidence;
}
export interface GovernanceActionProtocolParametersUpdate {
  type: "protocolParametersUpdate";
  parameters: ProposedProtocolParameters;
}
export interface ProposedProtocolParameters {
  minFeeCoefficient?: UInt64;
  minFeeConstant?: Lovelace;
  minUtxoDepositCoefficient?: UInt64;
  minUtxoDepositConstant?: Lovelace;
  maxBlockBodySize?: {
    bytes: Int64;
  };
  maxBlockHeaderSize?: {
    bytes: Int64;
  };
  maxTransactionSize?: {
    bytes: Int64;
  };
  maxValueSize?: {
    bytes: Int64;
  };
  extraEntropy?: Nonce;
  stakeCredentialDeposit?: Lovelace;
  stakePoolDeposit?: Lovelace;
  stakePoolRetirementEpochBound?: UInt64;
  stakePoolPledgeInfluence?: Ratio;
  minStakePoolCost?: Lovelace;
  desiredNumberOfStakePools?: UInt64;
  federatedBlockProductionRatio?: Ratio;
  monetaryExpansion?: Ratio;
  treasuryExpansion?: Ratio;
  collateralPercentage?: UInt64;
  maxCollateralInputs?: UInt64;
  plutusCostModels?: CostModels;
  scriptExecutionPrices?: ScriptExecutionPrices;
  maxExecutionUnitsPerTransaction?: ExecutionUnits;
  maxExecutionUnitsPerBlock?: ExecutionUnits;
  version?: ProtocolVersion;
}
export interface CostModels {
  [k: string]: CostModel;
}
export interface ScriptExecutionPrices {
  memory: Ratio;
  cpu: Ratio;
}
export interface ExecutionUnits {
  memory: UInt64;
  cpu: UInt64;
}
export interface ProtocolVersion {
  major: UInt32;
  minor: UInt32;
  patch?: UInt32;
}
export interface GovernanceActionHardForkInitiation {
  type: "hardForkInitiation";
  version: ProtocolVersion;
}
/**
 * A transfer from or to the treasury / reserves authored by genesis delegates.
 */
export interface GovernanceActionTreasuryTransfer {
  type: "treasuryTransfer";
  source: "reserves" | "treasury";
  target: "reserves" | "treasury";
  value: Lovelace;
}
/**
 * One of more withdrawals from the treasury.
 */
export interface GovernanceActionTreasuryWithdrawals {
  type: "treasuryWithdrawals";
  withdrawals: RewardTransfer;
}
export interface RewardTransfer {
  [k: string]: LovelaceDelta;
}
export interface LovelaceDelta {
  /**
   * An amount, possibly negative, in Lovelace (1e6 Lovelace = 1 Ada).
   */
  lovelace: number;
}
/**
 * A change (partial or total) in the constitutional committee.
 */
export interface GovernanceActionConstitutionalCommittee {
  type: "constitutionalCommittee";
  members: RewardTransfer;
  quorum: Ratio;
}
/**
 * A change in the constitution. Only its hash is recorded on-chain.
 */
export interface GovernanceActionConstitution {
  type: "constitution";
  hash: DigestBlake2B256;
}
/**
 * A motion of no-confidence, indicate a lack of trust in the constitutional committee.
 */
export interface GovernanceActionNoConfidence {
  type: "noConfidence";
}
/**
 * A vote on a governance proposal. The 'anchor' is optional and 'proposal' is only present from Conway onwards. Before Conway, a vote would always refer to all proposals part of the same transaction.
 */
export interface GovernanceVote {
  issuer: VoterGenesisDelegate | VoterConstitutionalCommittee | VoterDelegateRepresentative | VoterStakePoolOperator;
  anchor?: Anchor;
  vote: "yes" | "no" | "abstain";
  proposal?: GovernanceProposalReference;
}
export interface VoterGenesisDelegate {
  role: "genesisDelegate";
  id: DigestBlake2B224;
}
export interface VoterConstitutionalCommittee {
  role: "constitutionalCommittee";
  id: DigestBlake2B224;
}
export interface VoterDelegateRepresentative {
  role: "delegateRepresentative";
  id: DigestBlake2B224;
}
export interface VoterStakePoolOperator {
  role: "stakePoolOperator";
  id?: StakePoolId;
}
export interface GovernanceProposalReference {
  transaction: {
    id: TransactionId;
  };
  index: UInt32;
}
export interface Metadata {
  hash: DigestBlake2B256;
  labels: MetadataLabels;
}
export interface MetadataLabels {
  /**
   * An associated metadatum, as a CBOR bytestring or a JSON object if possible. Some binary representations cannot be represented in plain JSON and the 'json' field is therefore omitted.
   */
  [k: string]: {
    cbor?: string;
    json?: Metadatum;
  };
}
export interface ObjectMetadatum {
  [k: string]: Metadatum;
}
export interface Signatory {
  key: VerificationKey;
  signature: Signature;
  chainCode?: ChainCode;
  addressAttributes?: AddressAttributes;
}
export interface Redeemer {
  redeemer: RedeemerData;
  executionUnits: ExecutionUnits;
}
/**
 * A (Byron) delegation certificate.
 */
export interface BootstrapOperationalCertificate {
  issuer: {
    verificationKey: VerificationKey;
  };
  delegate: {
    verificationKey: VerificationKey;
  };
}
export interface SoftwareVersion {
  appName: string;
  number: UInt32;
}
export interface BootstrapProtocolUpdate {
  proposal?: {
    version: ProtocolVersion;
    software: SoftwareVersion;
    parameters: BootstrapProtocolParameters;
    metadata: {
      [k: string]: string;
    };
  };
  votes: BootstrapVote[];
}
export interface BootstrapProtocolParameters {
  heavyDelegationThreshold?: Ratio;
  maxBlockBodySize?: {
    bytes: Int64;
  };
  maxBlockHeaderSize?: {
    bytes: Int64;
  };
  maxUpdateProposalSize?: {
    bytes: Int64;
  };
  maxTransactionSize?: {
    bytes: Int64;
  };
  multiPartyComputationThreshold?: Ratio;
  scriptVersion?: UInt64;
  slotDuration?: UInt64;
  unlockStakeEpoch?: UInt64;
  updateProposalThreshold?: Ratio;
  updateProposalTimeToLive?: UInt64;
  updateVoteThreshold?: Ratio;
  softForkInitThreshold?: Ratio;
  softForkMinThreshold?: Ratio;
  softForkDecrementThreshold?: Ratio;
  minFeeCoefficient?: UInt64;
  minFeeConstant?: Lovelace;
}
export interface BootstrapVote {
  voter: {
    verificationKey: VerificationKey;
  };
  proposal: {
    id: DigestBlake2B256;
  };
}
export interface BlockPraos {
  type: "praos";
  era: "shelley" | "allegra" | "mary" | "alonzo" | "babbage";
  id: DigestBlake2B256;
  ancestor: DigestBlake2B256 | GenesisHash;
  nonce?: CertifiedVrf;
  height: BlockHeight;
  size: {
    bytes: Int64;
  };
  slot: Slot;
  transactions?: Transaction[];
  protocol: {
    version: ProtocolVersion;
  };
  issuer: {
    verificationKey: VerificationKey;
    vrfVerificationKey: VerificationKey;
    operationalCertificate: OperationalCertificate;
    leaderValue: CertifiedVrf;
  };
}
export interface CertifiedVrf {
  proof?: VrfProof;
  output?: VrfOutput;
}
/**
 * Certificate identifying a stake pool operator.
 */
export interface OperationalCertificate {
  count: UInt64;
  kes: {
    period: UInt64;
    verificationKey: KesVerificationKey;
  };
}
export interface RollBackward {
  direction: "backward";
  tip: TipOrOrigin;
  point: PointOrOrigin;
}
/**
 * Submit a signed and serialized transaction to the network.
 */
export interface SubmitTransaction {
  jsonrpc: "2.0";
  method: "submitTransaction";
  params: {
    transaction: {
      /**
       * CBOR-serialized signed transaction (base16)
       */
      cbor: string;
    };
  };
  id?: unknown;
}
export interface SubmitTransactionSuccess {
  jsonrpc: "2.0";
  method: "submitTransaction";
  result: {
    transaction: {
      id: TransactionId;
    };
  };
  id?: unknown;
}
export interface SubmitTransactionError {
  jsonrpc: "2.0";
  method: "submitTransaction";
  error: SubmitTransactionFailure;
  id?: unknown;
}
/**
 * Failed to submit the transaction in the current era. This may happen when trying to submit a transaction near an era boundary (i.e. at the moment of a hard-fork).
 */
export interface SubmitTransactionFailureEraMismatch {
  code: 3005;
  message: string;
  data: EraMismatch;
}
export interface EraMismatch {
  queryEra: Era;
  ledgerEra: Era;
}
/**
 * Some signatures are invalid. Only the serialised transaction *body*, without metadata or witnesses, must be signed.
 */
export interface SubmitTransactionFailureInvalidSignatories {
  code: 3100;
  message: string;
  data: {
    invalidSignatories: VerificationKey[];
  };
}
/**
 * Some signatures are missing. A signed transaction must carry signatures for all inputs locked by verification keys or a native script. Transaction may also need signatures for each required extra signatories often required by Plutus Scripts.
 */
export interface SubmitTransactionFailureMissingSignatories {
  code: 3101;
  message: string;
  data: {
    missingSignatories: DigestBlake2B224[];
  };
}
/**
 * Some script witnesses are missing. Indeed, any script used in a transaction (when spending, minting, withdrawing or publishing certificates) must be provided in full with the transaction. Scripts must therefore be added either to the witness set or provided as a reference inputs should you use Plutus V2+ and a format from Babbage and beyond.
 */
export interface SubmitTransactionFailureMissingScripts {
  code: 3102;
  message: string;
  data: {
    missingScripts: DigestBlake2B224[];
  };
}
/**
 * The transaction contains failing phase-1 monetary scripts (a.k.a. native scripts). This can be due to either a missing or invalid signature, or because of a time validity issue. The field 'data.failingNativeScripts' contains a list of hash digests of all failing native scripts found in the transaction.
 */
export interface SubmitTransactionFailureFailingNativeScript {
  code: 3103;
  message: string;
  data: {
    failingNativeScripts: DigestBlake2B224[];
  };
}
/**
 * Extraneous (i.e. non-required) scripts found in the transaction. A transaction must not contain scripts that aren't strictly needed for validation, that are present in metadata or that are published in an output. Perhaps you have used provided a wrong script for a validator? Anyway, the 'data.extraneousScripts' field lists hash digests of scripts found to be extraneous.
 */
export interface SubmitTransactionFailureExtraneousScripts {
  code: 3104;
  message: string;
  data: {
    extraneousScripts: DigestBlake2B224[];
  };
}
/**
 * Missing required metadata hash in the transaction body. If the transaction includes metadata, then it must also include a hash digest of these serialised metadata in its body to prevent malicious actors from tempering with the data. The field 'data.metadata.hash' contains the expected missing hash digest of the metadata found in the transaction.
 */
export interface SubmitTransactionFailureMissingMetadataHash {
  code: 3105;
  message: string;
  data: {
    metadata: {
      hash: DigestBlake2B256;
    };
  };
}
/**
 * No metadata corresponding to a specified metadata hash. It appears that you might have forgotten to attach metadata to a transaction, yet included a hash digest of them in the transaction body? The field 'data.metadata.hash' contains the orphan hash found in the body.
 */
export interface SubmitTransactionFailureMissingMetadata {
  code: 3106;
  message: string;
  data: {
    metadata: {
      hash: DigestBlake2B256;
    };
  };
}
/**
 * There's a mismatch between the provided metadata hash digest and the one computed from the actual metadata. The two must match exactly. The field 'data.provided.hash' references the provided hash as found in the transaction body, whereas 'data.computed.hash' contains the one the ledger computed from the actual metadata.
 */
export interface SubmitTransactionFailureMetadataHashMismatch {
  code: 3107;
  message: string;
  data: {
    provided: {
      hash: DigestBlake2B256;
    };
    computed: {
      hash: DigestBlake2B256;
    };
  };
}
/**
 * Invalid metadatum found in transaction metadata. Metadata byte strings must be no longer than 64-bytes and text strings must be no longer than 64 bytes once UTF-8-encoded. Some metadatum in the transaction infringe this rule.
 */
export interface SubmitTransactionFailureInvalidMetadata {
  code: 3108;
  message: string;
}
/**
 * Missing required redeemer(s) for Plutus scripts. There are validators needed for the transaction that do not have an associated redeemer. Redeemer are provided when trying to execute the validation logic of a script (e.g. when spending from an input locked by a script, or minting assets from a Plutus monetary policy. The field 'data.missingRedeemers' lists the different purposes for which a redeemer hasn't been provided.
 */
export interface SubmitTransactionFailureMissingRedeemers {
  code: 3109;
  message: string;
  data: {
    missingRedeemers: ScriptPurpose[];
  };
}
export interface ScriptPurposeSpend {
  purpose: "spend";
  outputReference: TransactionOutputReference;
}
export interface ScriptPurposeMint {
  purpose: "mint";
  policy: PolicyId;
}
export interface ScriptPurposePublish {
  purpose: "publish";
  certificate: Certificate;
}
export interface ScriptPurposeWithdraw {
  purpose: "withdraw";
  rewardAccount: RewardAccount;
}
/**
 * Extraneous (non-required) redeemers found in the transaction. There are some redeemers that aren't pointing to any script. This could be because you've left some orphan redeemer behind, because they are pointing at the wrong thing or because you forgot to include their associated validator. Either way, the field 'data.extraneousRedeemers' lists the different orphan redeemer pointers.
 */
export interface SubmitTransactionFailureExtraneousRedeemers {
  code: 3110;
  message: string;
  data: {
    extraneousRedeemers: RedeemerPointer[];
  };
}
/**
 * Transaction failed because some Plutus scripts are missing their associated datums. 'data.missingDatums' contains a set of data hashes for the missing datums. Ensure all Plutus scripts have an associated datum in the transaction's witness set or, are provided through inline datums in reference inputs.
 */
export interface SubmitTransactionFailureMissingDatums {
  code: 3111;
  message: string;
  data: {
    missingDatums: DigestBlake2B256[];
  };
}
/**
 * The transaction failed because it contains datums not associated with any script or output. This could be because you've left some orphan datum behind, because you've listed the wrong inputs in the transaction or because you've just forgotten to include a datum associated with an input. Either way, the field 'data.extraneousDatums' contains a set of data hashes for these extraneous datums.
 */
export interface SubmitTransactionFailureExtraneousDatums {
  code: 3112;
  message: string;
  data: {
    extraneousDatums: DigestBlake2B256[];
  };
}
/**
 * The transaction failed because the provided script integrity hash doesn't match the computed one. This is crucial for ensuring the integrity of cost models and Plutus version used during script execution. The field 'data.providedScriptIntegrity' correspond to what was given, if any, and 'data.computedScriptIntegrity' is what was expected. If the latter is null, this means you shouldn't have included a script integrity hash to begin with.
 */
export interface SubmitTransactionFailureScriptIntegrityHashMismatch {
  code: 3113;
  message: string;
  data: {
    providedScriptIntegrity: DigestBlake2B256 | null;
    computedScriptIntegrity: DigestBlake2B256 | null;
  };
}
/**
 * This is bad, you're trying to spend inputs that are locked by Plutus scripts, but have no associated datums. Those inputs are so-to-speak unspendable (at least with the current ledger rules). There's nothing you can do apart from re-creating these UTxOs but with a corresponding datum this time. The field 'data.orphanInputs' lists all such inputs found in the transaction.
 */
export interface SubmitTransactionFailureOrphanScriptInputs {
  code: 3114;
  message: string;
  data: {
    orphanInputs?: TransactionOutputReference[];
  };
}
/**
 * It seems like the transaction is using a Plutus version for which there's no available cost model yet. This could be because that language version is known of the ledger but hasn't yet been enabled through hard-fork. The field 'data.missingCostModels' lists all the languages for which a cost model is missing.
 */
export interface SubmitTransactionFailureMissingCostModels {
  code: 3115;
  message: string;
  data: {
    missingCostModels: Language[];
  };
}
/**
 * Some Plutus scripts in the witness set or in an output are invalid. Scripts must be well-formed flat-encoded Plutus scripts, CBOR-encoded. Yes, there's a double binary encoding. The outer-most encoding is therefore just a plain CBOR bytestring. Note that some tools such as the cardano-cli triple encode scripts for some reasons, resulting in a double outer-most CBOR encoding. Make sure that your script are correctly encoded. The field 'data.malformedScripts' lists the hash digests of all the problematic scripts.
 */
export interface SubmitTransactionFailureMalformedScripts {
  code: 3116;
  message: string;
  data: {
    malformedScripts: DigestBlake2B224[];
  };
}
/**
 * The transaction contains unknown UTxO references as inputs. This can happen if the inputs you're trying to spend have already been spent, or if you've simply referred to non-existing UTxO altogether. The field 'data.unknownOutputReferences' indicates all unknown inputs.
 */
export interface SubmitTransactionFailureUnknownOutputReferences {
  code: 3117;
  message: string;
  data: {
    unknownOutputReferences: TransactionOutputReference[];
  };
}
/**
 * The transaction is outside of its validity interval. It was either submitted too early or too late. A transaction that has a lower validity bound can only be accepted by the ledger (and make it to the mempool) if the ledger's current slot is greater than the specified bound. The upper bound works similarly, as a time to live. The field 'data.currentSlot' contains the current slot as known of the ledger (this may be different from the current network slot if the ledger is still catching up). The field 'data.validityInterval' is a reminder of the validity interval provided with the transaction.
 */
export interface SubmitTransactionFailureOutsideOfValidityInterval {
  code: 3118;
  message: string;
  data: {
    validityInterval: ValidityInterval;
    currentSlot: Slot;
  };
}
/**
 * The transaction exceeds the maximum size allowed by the protocol. Indeed, once serialized, transactions must be under a bytes limit specified by a protocol parameter. The field 'data.measuredTransactionSize' indicates the actual measured size of your serialized transaction, whereas 'data.maximumTransactionSize' indicates the current maximum size enforced by the ledger.
 */
export interface SubmitTransactionFailureTransactionTooLarge {
  code: 3119;
  message: string;
  data: {
    measuredTransactionSize: {
      bytes: Int64;
    };
    maximumTransactionSize: {
      bytes: Int64;
    };
  };
}
/**
 * Some output values in the transaction are too large. Once serialized, values must be below a certain threshold. That threshold sits around 4 KB during the Mary era, and was then made configurable as a protocol parameter in later era. The field 'data.excessivelyLargeOutputs' lists all transaction outputs with values that are above the limit.
 */
export interface SubmitTransactionFailureValueTooLarge {
  code: 3120;
  message: string;
  data: {
    excessivelyLargeOutputs: TransactionOutput[];
  };
}
/**
 * Transaction must have at least one input, but this one has an empty input set. One input is necessary to prevent replayability of transactions, as it piggybacks on the unique spendable property of UTxO.
 */
export interface SubmitTransactionFailureEmptyInputSet {
  code: 3121;
  message: string;
}
/**
 * Insufficient fee! The transaction doesn't not contain enough fee to cover the minimum required by the protocol. Note that fee depends on (a) a flat cost fixed by the protocol, (b) the size of the serialized transaction, (c) the budget allocated for Plutus script execution. The field 'data.minimumRequiredFee' indicates the minimum required fee whereas 'data.providedFee' refers to the fee currently supplied with the transaction.
 */
export interface SubmitTransactionFailureTransactionFeeTooSmall {
  code: 3122;
  message: string;
  data: {
    minimumRequiredFee: Lovelace;
    providedFee: Lovelace;
  };
}
/**
 * In and out value not conserved. The transaction must *exactly* balance: every input must be accounted for. There are various things counting as 'in balance': (a) the total value locked by inputs (or collateral inputs in case of a failing script), (b) rewards coming from withdrawals and (c) return deposits from stake credential or pool de-registration. In a similar fashion, various things count towards the 'out balance': (a) the total value assigned to each transaction output, (b) the fee and (c) any deposit for stake credential or pool registration. The field 'data.valueConsumed' contains the total 'in balance', and 'data.valueProduced' indicates the total amount counting as 'out balance'.
 */
export interface SubmitTransactionFailureValueNotConserved {
  code: 3123;
  message: string;
  data: {
    valueConsumed: Value;
    valueProduced: Value;
  };
}
/**
 * Some discriminated entities in the transaction are configured for another network. In fact, payment addresses, stake addresses and stake pool registration certificates are bound to a specific network identifier. This identifier must match the network you're trying to submit them to. Since the Alonzo era, transactions themselves may also contain a network identifier. The field 'data.expectedNetwork' indicates what is the currrently expected network. The field 'data.discriminatedType' indicates what type of entity is causing an issue here. And 'data.invalidEntities' lists all the culprits found in the transaction. The latter isn't present when the transaction's network identifier itself is wrong.
 */
export interface SubmitTransactionFailureNetworkMismatch {
  code: 3124;
  message: string;
  data:
    | {
        expectedNetwork: Network;
        discriminatedType: "address";
        invalidEntities: Address[];
      }
    | {
        expectedNetwork: Network;
        discriminatedType: "rewardAccount";
        invalidEntities: RewardAccount[];
      }
    | {
        expectedNetwork: Network;
        discriminatedType: "stakePoolCertificate";
        invalidEntities: StakePoolId[];
      }
    | {
        expectedNetwork: Network;
        discriminatedType: "transaction";
      };
}
/**
 * Some outputs have an insufficient amount of Ada attached to them. In fact, any new output created in a system must pay for the resources it occupies. Because user-created assets are worthless (from the point of view of the protocol), those resources must be paid in the form of a Ada deposit. The exact depends on the size of the serialized output: the more assets, the higher the amount. The field 'data.insufficientlyFundedOutputs.[].output' contains a list of all transaction outputs that are insufficiently funded. Starting from the Babbage era, the field 'data.insufficientlyFundedOutputs.[].minimumRequiredValue' indicates the required amount of Lovelace (1e6 Lovelace = 1 Ada) needed for each output.
 */
export interface SubmitTransactionFailureInsufficientlyFundedOutputs {
  code: 3125;
  message: string;
  data: {
    insufficientlyFundedOutputs: {
      output: TransactionOutput;
      minimumRequiredValue?: Lovelace;
    }[];
  };
}
/**
 * Some output associated with legacy / bootstrap (a.k.a. Byron) addresses have attributes that are too large. The field 'data.bootstrapOutputs' lists all affected outputs.
 */
export interface SubmitTransactionFailureBootstrapAttributesTooLarge {
  code: 3126;
  message: string;
  data: {
    bootstrapOutputs: TransactionOutput[];
  };
}
/**
 * The transaction is attempting to mint or burn Ada tokens. That is, fortunately, not allowed by the ledger.
 */
export interface SubmitTransactionFailureMintingOrBurningAda {
  code: 3127;
  message: string;
}
/**
 * Insufficient collateral value for Plutus scripts in the transaction. Indeed, when executing scripts, you must provide a collateral amount which minimum is a percentage of the total execution budget for the transaction. The exact percentage is given by a protocol parameter. The field 'data.providedCollateral' indicates the amount currently provided as collateral in the transaction, whereas 'data.minimumRequiredCollateral' indicates the minimum amount expected by the ledger
 */
export interface SubmitTransactionFailureInsufficientCollateral {
  code: 3128;
  message: string;
  data: {
    providedCollateral: Lovelace;
    minimumRequiredCollateral: Lovelace;
  };
}
/**
 * Invalid choice of collateral: an input provided for collateral is locked by script. Collateral inputs must be spendable, and the ledger must be able to assert their validity during the first phase of validations (a.k.a phase-1). This discards any input locked by a Plutus script to be used as collateral. Note that for some reason inputs locked by native scripts are also excluded from candidates collateral. The field 'data.unsuitableCollateralInputs' lists all the problematic output references.
 */
export interface SubmitTransactionFailureCollateralLockedByScript {
  code: 3129;
  message: string;
  data: {
    unsuitableCollateralInputs: TransactionOutputReference[];
  };
}
/**
 * One of the transaction validity bound is outside any foreseeable future. The vision of the ledger in the future is limited because the ledger cannot guarantee that the chain will not hard-fork into a version of the protocol working with a different set of parameters (or even, working with the same consensus protocol). However, the protocol cannot fork in less than `k` blocks, where `k` is the security parameter of the chain. Plus, Ouroboros Praos ensures that there are at least `k` blocks produced in a window of 3 * k / f slots, where `f` is the density parameter, also known as the active slot coefficient. Short story short, you can only set validity interval in a short timespan, which is around ~36h in the future on Mainnet at the moment of writing this error message. The field 'data.unforeseeableSlot' indicates the slot which couldn't be converted to a POSIX time due to hard fork uncertainty.
 */
export interface SubmitTransactionFailureUnforeseeableSlot {
  code: 3130;
  message: string;
  data: {
    unforeseeableSlot: Slot;
  };
}
/**
 * The transaction contains too many collateral inputs. The maximum number of collateral inputs is constrained by a protocol parameter. The field 'data.maximumCollateralInputs' contains the current value of that parameter, and 'data.countedCollateralInputs' indicates how many inputs were actually found in your transaction.
 */
export interface SubmitTransactionFailureTooManyCollateralInputs {
  code: 3131;
  message: string;
  data: {
    maximumCollateralInputs: UInt32;
    countedCollateralInputs: UInt32;
  };
}
/**
 * The transaction doesn't provide any collateral inputs but it must. Indeed, when executing scripts, you must provide a collateral amount which is collected by the ledger in case of script execution failure. That collateral serves as a compensation for nodes that aren't thus able to collect normal fees set on the transaction. Note that ledger validations are split in two phases. The first phase regards pretty much every validation outside of script executions. Anything from the first phase doesn't require a collateral and will not consume the collateral in case of failure because they require little computing resources. Besides, in principle, any client application or wallet will prevent you from submitting an invalid transaction to begin with.
 */
export interface SubmitTransactionFailureMissingCollateralInputs {
  code: 3132;
  message: string;
}
/**
 * One of the input provided as collateral carries something else than Ada tokens. Only Ada can be used as collateral. Since the Babbage era, you also have the option to set a 'collateral return' or 'collateral change' output in order to send the surplus non-Ada tokens to it. Regardless, the field 'data.unsuitableCollateralValue' indicates the actual collateral value found by the ledger
 */
export interface SubmitTransactionFailureNonAdaCollateral {
  code: 3133;
  message: string;
  data: {
    "unsuitableCollateralValue'"?: Value;
  };
}
/**
 * The transaction execution budget for scripts execution is above the allowed limit. The protocol limits the amount of execution that a single transaction can do. This limit is set by a protocol parameter. The field 'data.maximumExecutionUnits' indicates the current limit and the field 'data.providedExecutionUnits' indicates how much the transaction requires.
 */
export interface SubmitTransactionFailureExecutionUnitsTooLarge {
  code: 3134;
  message: string;
  data: {
    providedExecutionUnits: ExecutionUnits;
    maximumExecutionUnits: ExecutionUnits;
  };
}
/**
 * There's a mismatch between the declared total collateral amount, and the value computed from the inputs and outputs. These must match exactly. The field 'data.declaredTotalCollateral' reports the amount declared in the transaction whereas 'data.computedTotalCollateral' refers to the amount actually computed.
 */
export interface SubmitTransactionFailureTotalCollateralMismatch {
  code: 3135;
  message: string;
  data: {
    declaredTotalCollateral: Lovelace;
    computedTotalCollateral: Lovelace;
  };
}
/**
 * Invalid transaction submitted as valid, or vice-versa. Since Alonzo, the ledger may allow invalid transactions to be submitted and included on-chain, provided that they leave a collateral value as compensation. This prevent certain class of attacks. As a consequence, transactions now have a validity tag with them. Your transaction did not match what that validity tag is stating. The field 'data.declaredSpending' indicates what the transaction is supposed to consume (collaterals or inputs) and the field 'data.mismatchReason' provides more information about the mismatch.
 */
export interface SubmitTransactionFailureSpendsMismatch {
  code: 3136;
  message: string;
  data: {
    declaredSpending?: "inputs" | "collaterals";
    mismatchReason: string;
  };
}
/**
 * The transaction contains vote from a voter that is unauthorized for that vote action. The field 'data.unauthorizedVoter' indicates the voter's credential and 'data.requiredRole' documents the role that the voter should have but don't.
 */
export interface SubmitTransactionFailureUnauthorizedVote {
  code: 3137;
  message: string;
  data: {
    unauthorizedVoter: DigestBlake2B224;
    requiredRole: VoterRole;
  };
}
/**
 * Unknown governance proposal found in transaction. This may be because you've indicated a wrong identifier or because the governance proposal hasn't yet been submitted on-chain. Note that the order in which transactions are submitted matters. The field 'data.unknownProposal' tells you about the governance proposal's identifier.
 */
export interface SubmitTransactionFailureUnknownGovernanceProposal {
  code: 3138;
  message: string;
  data: {
    unknownProposal: GovernanceProposalReference;
  };
}
/**
 * The transaction contains an invalid or unauthorized protocol parameters update. This operation is reserved to genesis key holders.
 */
export interface SubmitTransactionFailureInvalidProtocolParametersUpdate {
  code: 3139;
  message: string;
}
/**
 * The transaction references an unknown stake pool as a target for delegation or update. Double-check the pool id mentioned in 'data.unknownStakePool'. Note also that order in which transactions are submitted matters; if you're trying to register a pool and delegate to it in one go, make sure to submit transactions in the right order.
 */
export interface SubmitTransactionFailureUnknownStakePool {
  code: 3140;
  message: string;
  data: {
    unknownStakePool: StakePoolId;
  };
}
/**
 * The transaction contains incomplete or invalid rewards withdrawals. When present, rewards withdrawals must consume rewards in full, there cannot be any leftover. The field 'data.incompleteWithdrawals' contains a map of withdrawals and their current rewards balance.
 */
export interface SubmitTransactionFailureIncompleteWithdrawals {
  code: 3141;
  message: string;
  data: {
    incompleteWithdrawals: Withdrawals;
  };
}
/**
 * A stake pool retirement certificate is trying to retire too late in the future. Indeed, there's a maximum delay for stake pool retirement, controlled by a protocol parameter. The field 'data.currentEpoch' indicates the current epoch known of the ledger, 'data.declaredEpoch' refers to the epoch declared in the retirement certificate and 'data.firstInvalidEpoch' is the first epoch considered invalid (too far) for retirement
 */
export interface SubmitTransactionFailureRetirementTooLate {
  code: 3142;
  message: string;
  data: {
    currentEpoch: Epoch;
    declaredEpoch: Epoch;
    firstInvalidEpoch: Epoch;
  };
}
/**
 * Stake pool cost declared in a registration or update certificate are below the allowed minimum. The minimum cost of a stake pool is fixed by a protocol parameter. The 'data.minimumStakePoolCost' field holds the current value of that parameter whereas 'data.declaredStakePoolCost' indicates which amount was declared.
 */
export interface SubmitTransactionFailureStakePoolCostTooLow {
  code: 3143;
  message: string;
  data: {
    minimumStakePoolCost: Lovelace;
    declaredStakePoolCost: Lovelace;
  };
}
/**
 * Some hash digest of (optional) stake pool metadata is too long. When registering, stake pools can supply an external metadata file and a hash digest of the content. The hashing algorithm is left open but the output digest must be smaller than 32 bytes. The field 'data.infringingStakePool' indicates which stake pool has an invalid metadata hash and 'data.computedMetadataHashSize' documents the computed hash size.
 */
export interface SubmitTransactionFailureMetadataHashTooLarge {
  code: 3144;
  message: string;
  data: {
    infringingStakePool: {
      id: StakePoolId;
    };
    computedMetadataHashSize: {
      bytes: Int64;
    };
  };
}
/**
 * Trying to re-register some already known credentials. Stake credentials can only be registered once. This is true for both keys and scripts. The field 'data.knownCredential' points to an already known credential that's being re-registered by this transaction.
 */
export interface SubmitTransactionFailureCredentialAlreadyRegistered {
  code: 3145;
  message: string;
  data: {
    knownCredential: DigestBlake2B224;
  };
}
/**
 * The transaction references an unknown stake credential. For example, to delegate to a stake pool, you must first register the stake key or script used for delegation. This may be done in the same transaction or in an earlier transaction but cannot happen retro-actively. The field 'data.unknownCredential' indicates what credential is used without being registered.
 */
export interface SubmitTransactionFailureUnknownCredential {
  code: 3146;
  message: string;
  data: {
    unknownCredential: DigestBlake2B224;
  };
}
/**
 * Trying to unregister stake credentials associated to a non empty reward account. You must empty the reward account first (or do it as part of the same transaction) to proceed. The field 'data.nonEmptyRewardAccountBalance' indicates how much Lovelace is left in the account.
 */
export interface SubmitTransactionFailureNonEmptyRewardAccount {
  code: 3147;
  message: string;
  data: {
    nonEmptyRewardAccountBalance: Lovelace;
  };
}
/**
 * Invalid or unauthorized genesis delegation. The genesis delegate is unknown, invalid or already in use.
 */
export interface SubmitTransactionFailureInvalidGenesisDelegation {
  code: 3148;
  message: string;
}
/**
 * Invalid MIR transfer. The resulting delta is likely negative.
 */
export interface SubmitTransactionFailureInvalidMIRTransfer {
  code: 3149;
  message: string;
}
/**
 * Unrecognized certificate type. This error is a placeholder due to how internal data-types are modeled. If you ever run into this, please report the issue as you've likely discoverd a critical bug...
 */
export interface SubmitTransactionFailureUnrecognizedCertificateType {
  code: 3998;
  message: string;
}
/**
 * Whoopsie, the ledger failed to upgrade an data-type from an earlier era into data of a newer era. If you ever run into this, please report the issue as you've likely discoverd a critical bug...
 */
export interface SubmitTransactionFailureInternalLedgerTypeConversionError {
  code: 3999;
  message: string;
}
export interface SubmitTransactionDeserialisationError {
  jsonrpc: "2.0";
  method: "submitTransaction";
  error: DeserialisationFailure;
  id?: unknown;
}
/**
 * The input failed to deserialize in any of the known era.
 */
export interface DeserialisationFailure {
  code: -32602;
  message: string;
  data: {
    shelley: string;
    allegra: string;
    mary: string;
    alonzo: string;
    babbage: string;
    conway: string;
  };
}
/**
 * Evaluate execution units for which redeemers's budget hasn't yet been set.
 */
export interface EvaluateTransaction {
  jsonrpc: "2.0";
  method: "evaluateTransaction";
  params: {
    transaction: {
      /**
       * CBOR-serialized signed transaction (base16)
       */
      cbor: string;
    };
    additionalUtxo?: Utxo;
  };
  id?: unknown;
}
export interface EvaluateTransactionSuccess {
  jsonrpc: "2.0";
  method: "evaluateTransaction";
  result: {
    validator: RedeemerPointer;
    budget: ExecutionUnits;
  }[];
  id?: unknown;
}
/**
 * Happens when attempting to evaluate execution units on a node that isn't enough synchronized.
 */
export interface EvaluateTransactionError {
  jsonrpc: "2.0";
  method: "evaluateTransaction";
  error: EvaluateTransactionFailure;
  id?: unknown;
}
/**
 * Returned when trying to evaluate execution units of a pre-Alonzo transaction. Note that this isn't possible with Ogmios because transactions are always de-serialized as Alonzo transactions.
 */
export interface EvaluateTransactionFailureIncompatibleEra {
  code: 3000;
  message: string;
  /**
   * The era in which the transaction has been identified.
   */
  data: {
    incompatibleEra: Era;
  };
}
/**
 * Returned when trying to evaluate execution units of an era that is now considered too old and is no longer supported. This can solved by using a more recent transaction format.
 */
export interface EvaluateTransactionFailureUnsupportedEra {
  code: 3001;
  message: string;
  /**
   * The era in which the transaction has been identified.
   */
  data: {
    unsupportedEra: Era;
  };
}
/**
 * Happens when providing an additional UTXO set which overlaps with the UTXO on-chain.
 */
export interface EvaluateTransactionFailureOverlappingAdditionalUtxo {
  code: 3002;
  message: string;
  data: {
    overlappingOutputReferences: TransactionOutputReference[];
  };
}
/**
 * Happens when attempting to evaluate execution units on a node that isn't enough synchronized.
 */
export interface EvaluateTransactionFailureNodeTipTooOld {
  code: 3003;
  message: string;
  data: {
    minimumRequiredEra: Era;
    currentNodeEra: Era;
  };
}
/**
 * The transaction is malformed or missing information; making evaluation impossible.
 */
export interface EvaluateTransactionFailureCannotCreateEvaluationContext {
  code: 3004;
  message: string;
  data: {
    reason: string;
  };
}
/**
 * One or more script execution terminated with an error.
 */
export interface EvaluateTransactionFailureScriptExecutionFailure {
  code: 3010;
  message: string;
  data: {
    validator: RedeemerPointer;
    error: ScriptExecutionFailure;
  }[];
}
/**
 * An associated script witness is missing. Indeed, any script used in a transaction (when spending, minting, withdrawing or publishing certificates) must be provided in full with the transaction. Scripts must therefore be added either to the witness set or provided as a reference inputs should you use Plutus V2+ and a format from Babbage and beyond.
 */
export interface ScriptExecutionFailureMissingScript {
  code: 3011;
  message: string;
}
/**
 * Some of the (V1) scripts failed to evaluate to a positive outcome.
 */
export interface ScriptExecutionFailureValidationFailure {
  code: 3012;
  message: string;
  data: {
    validationError: string;
    traces: string[];
  };
}
/**
 * Some of the (V2) scripts failed to evaluate to a positive outcome.
 */
export interface ScriptExecutionFailureUnsuitableOutputReference {
  code: 3013;
  message: string;
  data: {
    unsuitableOutputReference: TransactionOutputReference;
  };
}
export interface EvaluateTransactionDeserialisationError {
  jsonrpc: "2.0";
  method: "evaluateTransaction";
  error: DeserialisationFailure;
  id?: unknown;
}
/**
 * Acquire a point on chain from which to run ledger-state queries.
 */
export interface AcquireLedgerState {
  jsonrpc: "2.0";
  method: "acquireLedgerState";
  params: {
    point: PointOrOrigin;
  };
  id?: unknown;
}
export interface AcquireLedgerStateFailure {
  jsonrpc: "2.0";
  method: "acquireLedgerState";
  /**
   * Unable to acquire the ledger state at the request point.
   */
  error: {
    code: 2000;
    message: string;
    /**
     * A reason for the failure.
     */
    data: string;
  };
  id?: unknown;
}
/**
 * Response to an 'acquireLedgerState' request.
 */
export interface AcquireLedgerStateSuccess {
  jsonrpc: "2.0";
  method: "acquireLedgerState";
  result: {
    acquired: "ledgerState";
    point: PointOrOrigin;
  };
  id?: unknown;
}
/**
 * Release a previously acquired ledger state.
 */
export interface ReleaseLedgerState {
  jsonrpc: "2.0";
  method: "releaseLedgerState";
  id?: unknown;
}
/**
 * Response to a 'releaseLedgerState' request.
 */
export interface ReleaseLedgerStateResponse {
  jsonrpc: "2.0";
  method: "releaseLedgerState";
  result: {
    released: "ledgerState";
  };
  id?: unknown;
}
export interface QueryLedgerStateEraMismatch {
  jsonrpc: "2.0";
  method:
    | "queryLedgerState/epoch"
    | "queryLedgerState/eraStart"
    | "queryLedgerState/eraSummaries"
    | "queryLedgerState/liveStakeDistribution"
    | "queryLedgerState/projectedRewards"
    | "queryLedgerState/protocolParameters"
    | "queryLedgerState/proposedProtocolParameters"
    | "queryLedgerState/rewardAccountSummaries"
    | "queryLedgerState/rewardsProvenance"
    | "queryLedgerState/stakePools"
    | "queryLedgerState/utxo"
    | "queryLedgerState/tip";
  /**
   * An era mismatch between a client request and the era the ledger is in. This may occur when running queries on a syncing node and/or when the node is crossing an era.
   */
  error: {
    code: 2001;
    message: string;
    data: EraMismatch;
  };
  id?: unknown;
}
export interface QueryLedgerStateUnavailableInCurrentEra {
  jsonrpc: "2.0";
  method:
    | "queryLedgerState/epoch"
    | "queryLedgerState/eraStart"
    | "queryLedgerState/eraSummaries"
    | "queryLedgerState/liveStakeDistribution"
    | "queryLedgerState/projectedRewards"
    | "queryLedgerState/protocolParameters"
    | "queryLedgerState/proposedProtocolParameters"
    | "queryLedgerState/rewardAccountSummaries"
    | "queryLedgerState/rewardsProvenance"
    | "queryLedgerState/stakePools"
    | "queryLedgerState/utxo"
    | "queryLedgerState/tip";
  /**
   * Some query is not available for the requested ledger era.
   */
  error: {
    code: 2002;
    message: string;
  };
  id?: unknown;
}
export interface QueryLedgerStateAcquiredExpired {
  jsonrpc: "2.0";
  method:
    | "queryLedgerState/epoch"
    | "queryLedgerState/eraStart"
    | "queryLedgerState/eraSummaries"
    | "queryLedgerState/liveStakeDistribution"
    | "queryLedgerState/projectedRewards"
    | "queryLedgerState/protocolParameters"
    | "queryLedgerState/proposedProtocolParameters"
    | "queryLedgerState/rewardAccountSummaries"
    | "queryLedgerState/rewardsProvenance"
    | "queryLedgerState/stakePools"
    | "queryLedgerState/utxo"
    | "queryLedgerState/tip";
  /**
   * Previously acquired ledger state is no longer available.
   */
  error: {
    code: 2003;
    message: string;
    /**
     * A reason for the failure.
     */
    data: string;
  };
  id?: unknown;
}
/**
 * Query the current epoch number the ledger is at.
 */
export interface QueryLedgerStateEpoch {
  jsonrpc: "2.0";
  method: "queryLedgerState/epoch";
  id?: unknown;
}
export interface QueryLedgerStateEpochResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/epoch";
  result: Epoch;
  id?: unknown;
}
/**
 * Query the start of the current ledger era.
 */
export interface QueryLedgerStateEraStart {
  jsonrpc: "2.0";
  method: "queryLedgerState/eraStart";
  id?: unknown;
}
export interface QueryLedgerStateEraStartResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/eraStart";
  result: Bound;
  id?: unknown;
}
/**
 * An era bound which captures the time, slot and epoch at which the era start. The time is relative to the start time of the network.
 */
export interface Bound {
  time: RelativeTime;
  slot: Slot;
  epoch: Epoch;
}
/**
 * A time in seconds relative to another one (typically, system start or era start).
 */
export interface RelativeTime {
  seconds: bigint;
}
/**
 * Query a summary of the slotting parameters and boundaries for each known era. Useful for doing slot-arithmetic and time conversions.
 */
export interface QueryLedgerStateEraSummaries {
  jsonrpc: "2.0";
  method: "queryLedgerState/eraSummaries";
  id?: unknown;
}
export interface QueryLedgerStateEraSummariesResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/eraSummaries";
  result: EraSummary[];
  id?: unknown;
}
/**
 * Summary of the confirmed parts of the ledger.
 */
export interface EraSummary {
  start: Bound;
  end?: Bound;
  parameters: EraParameters;
}
/**
 * Parameters that can vary across hard forks.
 */
export interface EraParameters {
  epochLength: Epoch;
  slotLength: SlotLength;
  safeZone: SafeZone | null;
}
/**
 * A slot length in milliseconds
 */
export interface SlotLength {
  milliseconds: bigint;
}
/**
 * Query the current distribution of the stake across all known stake pools, relative to the TOTAL stake in the network.
 */
export interface QueryLedgerStateLiveStakeDistribution {
  jsonrpc: "2.0";
  method: "queryLedgerState/liveStakeDistribution";
  id?: unknown;
}
export interface QueryLedgerStateLiveStakeDistributionResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/liveStakeDistribution";
  result: LiveStakeDistribution;
  id?: unknown;
}
/**
 * Distribution of stake across registered stake pools. Each key in the map corresponds to a pool id.
 */
export interface LiveStakeDistribution {
  [k: string]: {
    stake: Ratio;
    vrf: DigestBlake2B256;
  };
}
/**
 * Query the projected rewards of an account in a context where the top stake pools are fully saturated. This projection gives, in principle, a ranking of stake pools that maximizes delegator rewards.
 */
export interface QueryLedgerStateProjectedRewards {
  jsonrpc: "2.0";
  method: "queryLedgerState/projectedRewards";
  params: {
    stake?: Lovelace[];
    scripts?: AnyStakeCredential[];
    keys?: AnyStakeCredential[];
  };
  id?: unknown;
}
export interface QueryLedgerStateProjectedRewardsResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/projectedRewards";
  result: ProjectedRewards;
  id?: unknown;
}
/**
 * Rewards that can be expected assuming a pool is fully saturated. Such rewards are said non-myopic, in opposition to short-sighted rewards looking at immediate benefits. Keys of the map can be either Lovelace amounts or account credentials depending on the query.
 */
export interface ProjectedRewards {
  [k: string]: {
    [k: string]: Lovelace;
  };
}
/**
 * Query the last update proposal w.r.t. protocol parameters, if any.
 */
export interface QueryLedgerStateProposedProtocolParameters {
  jsonrpc: "2.0";
  method: "queryLedgerState/proposedProtocolParameters";
  id?: unknown;
}
export interface QueryLedgerStateProposedProtocolParametersResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/proposedProtocolParameters";
  result: ProposedProtocolParameters[];
  id?: unknown;
}
/**
 * Query the current protocol parameters.
 */
export interface QueryLedgerStateProtocolParameters {
  jsonrpc: "2.0";
  method: "queryLedgerState/protocolParameters";
  id?: unknown;
}
export interface QueryLedgerStateProtocolParametersResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/protocolParameters";
  result: ProtocolParameters;
  id?: unknown;
}
export interface ProtocolParameters {
  minFeeCoefficient: UInt64;
  minFeeConstant: Lovelace;
  minUtxoDepositCoefficient: UInt64;
  minUtxoDepositConstant: Lovelace;
  maxBlockBodySize: {
    bytes: Int64;
  };
  maxBlockHeaderSize: {
    bytes: Int64;
  };
  maxTransactionSize?: {
    bytes: Int64;
  };
  maxValueSize?: {
    bytes: Int64;
  };
  extraEntropy?: Nonce;
  stakeCredentialDeposit: Lovelace;
  stakePoolDeposit: Lovelace;
  stakePoolRetirementEpochBound: UInt64;
  stakePoolPledgeInfluence: Ratio;
  minStakePoolCost: Lovelace;
  desiredNumberOfStakePools: UInt64;
  federatedBlockProductionRatio?: Ratio;
  monetaryExpansion: Ratio;
  treasuryExpansion: Ratio;
  collateralPercentage?: UInt64;
  maxCollateralInputs?: UInt64;
  plutusCostModels?: CostModels;
  scriptExecutionPrices?: ScriptExecutionPrices;
  maxExecutionUnitsPerTransaction?: ExecutionUnits;
  maxExecutionUnitsPerBlock?: ExecutionUnits;
  version: ProtocolVersion;
}
/**
 * Query current delegation settings and rewards of some given reward accounts.
 */
export interface QueryLedgerStateRewardAccountSummaries {
  jsonrpc: "2.0";
  method: "queryLedgerState/rewardAccountSummaries";
  params: {
    scripts?: AnyStakeCredential[];
    keys?: AnyStakeCredential[];
  };
  id?: unknown;
}
export interface QueryLedgerStateRewardAccountSummariesResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/rewardAccountSummaries";
  result: RewardAccountSummaries;
  id?: unknown;
}
export interface RewardAccountSummaries {
  [k: string]: RewardAccountSummary;
}
export interface RewardAccountSummary {
  delegate?: {
    id: StakePoolId;
  };
  rewards?: Lovelace;
}
/**
 * Query details about rewards calculation for the ongoing epoch.
 */
export interface QueryLedgerStateRewardsProvenance {
  jsonrpc: "2.0";
  method: "queryLedgerState/rewardsProvenance";
  id?: unknown;
}
export interface QueryLedgerStateRewardsProvenanceResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/rewardsProvenance";
  result: RewardsProvenance;
  id?: unknown;
}
/**
 * Details about how rewards are calculated for the ongoing epoch.
 */
export interface RewardsProvenance {
  /**
   * Desired number of stake pools.
   */
  desiredNumberOfStakePools: number;
  /**
   * Influence of the pool owner's pledge on rewards, as a ratio of two integers.
   */
  stakePoolPledgeInfluence: string;
  /**
   * Total rewards available for the given epoch.
   */
  totalRewardsInEpoch: {
    lovelace: bigint;
  };
  /**
   * The total amount of staked Lovelace during this epoch.
   */
  activeStakeInEpoch: {
    lovelace: bigint;
  };
  stakePools: {
    [k: string]: StakePoolSummary;
  };
}
export interface StakePoolSummary {
  id: StakePoolId;
  stake: Lovelace;
  ownerStake: Lovelace;
  /**
   * Number of blocks produced divided by expected number of blocks (based on stake and epoch progress). Can be larger than 1.0 for pools that get lucky.
   */
  approximatePerformance: number;
  /**
   * Some of the pool parameters relevant for the reward calculation.
   */
  parameters: {
    cost: Lovelace;
    margin: Ratio;
    pledge: Lovelace;
  };
}
/**
 * Query the list of all stake pools currently registered and active, optionally filtered by ids.
 */
export interface QueryLedgerStateStakePools {
  jsonrpc: "2.0";
  method: "queryLedgerState/stakePools";
  params?: {
    stakePools: {
      id: StakePoolId;
    }[];
  };
  id?: unknown;
}
export interface QueryLedgerStateStakePoolsResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/stakePools";
  result: {
    [k: string]: StakePool;
  };
  id?: unknown;
}
/**
 * Query the current tip the ledger is at. Said differently, the slot number and header hash of the last block that has been processed by the ledger.
 */
export interface QueryLedgerStateTip {
  jsonrpc: "2.0";
  method: "queryLedgerState/tip";
  id?: unknown;
}
export interface QueryLedgerStateTipResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/tip";
  result: PointOrOrigin;
  id?: unknown;
}
/**
 * Query the current Utxo set, restricted to some output references or addresses.
 */
export interface QueryLedgerStateUtxo {
  jsonrpc: "2.0";
  method: "queryLedgerState/utxo";
  params?: UtxoByOutputReferences | UtxoByAddresses | WholeUtxo;
  id?: unknown;
}
export interface UtxoByOutputReferences {
  outputReferences: TransactionOutputReference[];
}
export interface UtxoByAddresses {
  addresses: Address[];
}
export interface WholeUtxo {}
export interface QueryLedgerStateUtxoResponse {
  jsonrpc: "2.0";
  method: "queryLedgerState/utxo";
  result: Utxo;
  id?: unknown;
}
/**
 * Query the network’s highest block number.
 */
export interface QueryNetworkBlockHeight {
  jsonrpc: "2.0";
  method: "queryNetwork/blockHeight";
  id?: unknown;
}
export interface QueryNetworkBlockHeightResponse {
  jsonrpc: "2.0";
  method: "queryNetwork/blockHeight";
  result: BlockHeight | Origin;
  id?: unknown;
}
/**
 * Query the genesis configuration of a given era.
 */
export interface QueryNetworkGenesisConfiguration {
  jsonrpc: "2.0";
  method: "queryNetwork/genesisConfiguration";
  params: {
    era: EraWithGenesis;
  };
  id?: unknown;
}
export interface QueryNetworkGenesisConfigurationResponse {
  jsonrpc: "2.0";
  method: "queryNetwork/genesisConfiguration";
  result: GenesisByron | GenesisShelley | GenesisAlonzo | GenesisConway;
  id?: unknown;
}
/**
 * A Byron genesis configuration, with information used to bootstrap the era. Some parameters are also updatable across the era.
 */
export interface GenesisByron {
  era: "byron";
  genesisKeyHashes: DigestBlake2B224[];
  genesisDelegations: {
    [k: string]: BootstrapOperationalCertificate;
  };
  startTime: UtcTime;
  initialFunds: {
    [k: string]: Lovelace;
  };
  initialVouchers: {
    [k: string]: Lovelace;
  };
  securityParameter: UInt64;
  networkMagic: NetworkMagic;
  updatableParameters?: ProtocolParameters;
}
/**
 * A Shelley genesis configuration, with information used to bootstrap the era. Some parameters are also updatable across the era.
 */
export interface GenesisShelley {
  era: "shelley";
  startTime: UtcTime;
  networkMagic: NetworkMagic;
  network: Network;
  activeSlotsCoefficient: Ratio;
  securityParameter: UInt64;
  epochLength: Epoch;
  slotsPerKesPeriod: UInt64;
  maxKesEvolutions: UInt64;
  slotLength: SlotLength;
  updateQuorum: UInt64;
  maxLovelaceSupply: UInt64;
  initialParameters: ProtocolParameters;
  initialDelegates: InitialDelegates;
  initialFunds: InitialFunds;
  initialStakePools: GenesisStakePools;
}
/**
 * A Genesis delegate, in charge of Cardano's governance.
 */
export interface GenesisDelegate {
  id: DigestBlake2B224;
  vrfVerificationKeyHash: DigestBlake2B256;
}
export interface InitialFunds {
  [k: string]: Lovelace;
}
/**
 * A Genesis stake pools configuration; primarily used for bootstrapping test networks.
 */
export interface GenesisStakePools {
  stakePools: {
    [k: string]: StakePool;
  };
  delegators: {
    [k: string]: StakePoolId;
  };
}
/**
 * An Alonzo genesis configuration, with information used to bootstrap the era. Some parameters are also updatable across the era.
 */
export interface GenesisAlonzo {
  era: "alonzo";
  initialParameters: {
    minUtxoDepositCoefficient: UInt64;
    collateralPercentage: UInt64;
    plutusCostModels: CostModels;
    maxCollateralInputs: UInt64;
    maxExecutionUnitsPerBlock: ExecutionUnits;
    maxExecutionUnitsPerTransaction: ExecutionUnits;
    maxValueSize: {
      bytes: Int64;
    };
    scriptExecutionPrices: ScriptExecutionPrices;
  };
}
/**
 * An Conway genesis configuration, with information used to bootstrap the era. Some parameters are also updatable across the era.
 */
export interface GenesisConway {
  era: "conway";
  initialDelegates: InitialDelegates;
}
/**
 * Query the network start time.
 */
export interface QueryNetworkStartTime {
  jsonrpc: "2.0";
  method: "queryNetwork/startTime";
  id?: unknown;
}
export interface QueryNetworkStartTimeResponse {
  jsonrpc: "2.0";
  method: "queryNetwork/startTime";
  result: UtcTime;
  id?: unknown;
}
/**
 * Get the current network tip. Said differently, this is the most recent slot and block header hash that the node it aware of.
 */
export interface QueryNetworkTip {
  jsonrpc: "2.0";
  method: "queryNetwork/tip";
  id?: unknown;
}
export interface QueryNetworkTipResponse {
  jsonrpc: "2.0";
  method: "queryNetwork/tip";
  result: PointOrOrigin;
  id?: unknown;
}
/**
 * Acquire a mempool snapshot. This is blocking until a new (i.e different) snapshot is available.
 */
export interface AcquireMempool {
  jsonrpc: "2.0";
  method: "acquireMempool";
  id?: unknown;
}
/**
 * Response to a 'acquireMempool' request.
 */
export interface AcquireMempoolResponse {
  jsonrpc: "2.0";
  method: "acquireMempool";
  result: {
    acquired: "mempool";
    slot: Slot;
  };
  id?: unknown;
}
/**
 * Request the next transaction from an acquired mempools napshot.
 */
export interface NextTransaction {
  jsonrpc: "2.0";
  method: "nextTransaction";
  params?: {
    fields?: "all";
  };
  id?: unknown;
}
export interface MustAcquireMempoolFirst {
  jsonrpc: "2.0";
  method: "hasTransaction" | "nextTransaction" | "sizeOfMempool" | "releaseMempool";
  /**
   * Must acquire a mempool snapshot prior to performing any query.
   */
  error: {
    code: 4000;
    message: string;
  };
  id?: unknown;
}
/**
 * Response to a 'nextTransaction' request.
 */
export interface NextTransactionResponse {
  jsonrpc: "2.0";
  method: "nextTransaction";
  /**
   * A transaction (or id) or an empty object if there's no more transactions.
   */
  result: {
    transaction:
      | {
          id: TransactionId;
        }
      | Transaction
      | null;
  };
  id?: unknown;
}
/**
 * Ask whether a given transaction is present in the acquired mempool snapshot.
 */
export interface HasTransaction {
  jsonrpc: "2.0";
  method: "hasTransaction";
  params: {
    id: TransactionId;
  };
  id?: unknown;
}
/**
 * Response to a 'HasTransaction' request.
 */
export interface HasTransactionResponse {
  jsonrpc: "2.0";
  method: "hasTransaction";
  result: boolean;
  id?: unknown;
}
/**
 * Get size and capacities of the mempool (acquired snapshot).
 */
export interface SizeOfMempool {
  jsonrpc: "2.0";
  method: "sizeOfMempool";
  id?: unknown;
}
/**
 * Response to a 'sizeOfMempool' request.
 */
export interface SizeOfMempoolResponse {
  jsonrpc: "2.0";
  method: "sizeOfMempool";
  result: MempoolSizeAndCapacity;
  id?: unknown;
}
export interface MempoolSizeAndCapacity {
  maxCapacity: {
    bytes: Int64;
  };
  currentSize: {
    bytes: Int64;
  };
  transactions: {
    count: UInt32;
  };
}
/**
 * Release a previously acquired mempool snapshot.
 */
export interface ReleaseMempool {
  jsonrpc: "2.0";
  method: "releaseMempool";
  id?: unknown;
}
/**
 * Response to a 'releaseMempool' request.
 */
export interface ReleaseMempoolResponse {
  jsonrpc: "2.0";
  method: "releaseMempool";
  result: {
    released: "mempool";
  };
  id?: unknown;
}
/**
 * A generic error in the JSON-RPC protocol. This is returned by the server when a request from clients is deemed invalid or, when the server was unable to reply to a well-formed request.
 */
export interface RpcError {
  jsonrpc: "2.0";
  error: {
    /**
     * An error code telling about the nature of the error.
     */
    code: number;
    /**
     * A descriptive error message giving hints about the error.
     */
    message?: string;
    data?: unknown;
  };
  id?: unknown;
}
