# Contributing

## What & How Can You Contribute?

#### 1. Feedback

Contributions in the form of feedback and issue is very much welcome. Might it be a suggestion, a bug report or maybe some questions that you have. It helps improving Ogmios in the long run and these are probably the best kind of contributions to start with. See [About Issues/Discussions](#about-issues--discussion) below for guidelines.

Do not hesitate to upvote discussions or comments to show your interest!

#### 2. Code

 Refer to the [building](https://ogmios.dev/getting-started/building/) and [testing](https://ogmios.dev/getting-started/testing/) sections of the [user-manual](https://ogmios.dev) if you're willing to hack a bit on Ogmios. The project follows a quite strict architecture as detailed in the [server's README](https://github.com/CardanoSolutions/ogmios/tree/master/server#architecture).

 Past (and future) design decisions have been (will be) recorded as [Architectural Decision Records](https://github.com/CardanoSolutions/ogmios/tree/master/architectural-decisions/accepted). Have a look at them before you start hacking to better understand some of trade-offs made during the development.

 Coding standards are enforced using tools and configuration defined in the repository. Make sure to configure your editor to pick them up.

 Pull requests are welcome, but we do recommend to open an issue to bring any idea to discussion first!

#### 3. Donation

Want to give some financial support? Have a look at the [sponsors page](https://github.com/sponsors/KtorZ/) for more details.

## About Issues

### :bug: How To Report A Bug

Open a [Bug Issue](https://github.com/cardanosolutions/ogmios/issues/new?template=bug.md).

### :bulb: How To Propose An Idea

Feel free to bring it as a [discussion [category: idea]](https://github.com/CardanoSolutions/kupo/discussions/new?category=ideas). Make sure to highlight your use case so we can understand the design space and agree on a solution.

> **Note** Ideally, follow this simple template:
>
> - What is your idea? Describe it in simple words. Provide a use case.
> - Why is it a good idea?
> - What is the current alternative and why is it not good enough?

### :question: How To Ask a Question

Open a [Q&A Discussion](https://github.com/CardanoSolutions/ogmios/discussions/new?category=q-a).

> **Warning**
> Make sure to mark your question as _Answered_ once resolved!

## Need Help Getting Started?

Should you be unsure about where to start, feel free to come and chat on <a href="https://discord.gg/ZeyDn65t5v"><img src=".github/discord.svg" alt="Discord">Discord (#ogmios)</a>.
