# ics-js

Create ICS files in ES6. Works in Node.js or in the browser.

## Status

[![npm version](https://badge.fury.io/js/ics-js.svg)](http://badge.fury.io/js/ics-js)
[![Build Status](https://secure.travis-ci.org/angeloashmore/ics-js.svg?branch=master)](http://travis-ci.org/angeloashmore/ics-js?branch=master)
[![Canonical Code Style](https://img.shields.io/badge/code%20style-canonical-blue.svg?style=flat)](https://github.com/gajus/canonical)

## Installation

```shell
npm install --save ics-js
```

## Documentation

[![Documentation](https://doc.esdoc.org/github.com/angeloashmore/ics-js/badge.svg)](https://doc.esdoc.org/github.com/angeloashmore/ics-js/)

[View documentation on ESDoc](https://doc.esdoc.org/github.com/angeloashmore/ics-js/).

## Quick Guide

Import the module:

```js
import ICS from 'ics-js';
```

### Create a component

```js
const cal = new ICS.VCALENDAR();
```

The following components are implenented:

* `VCALENDAR`
* `VEVENT`
* `VALARM`
* `VTODO`

### Add properties to a component

```js
/**
 * Component#addProp(name, value, props = {}, skipTransformer = false)
 *
 * @param {string} name - Name of the property (e.g. DTSTAMP).
 * @param {*} [value] - Value of the property.
 * @param {Object} [props={}] - Object of properties for the property. Object keys and values are directly injected.
 * @param {boolean} [skipTransformer=false] - Explicitly determine if the property's value is transformed.
 */

cal.addProp('VERSION', 2) // Number(2) is converted to '2.0'
cal.addProp('PRODID', 'XYZ Corp');
```

Each component contains a list of property validations. Only valid properties
can be added according to the RFC 5545 spec.

The following properties are implemented:

| Name | Input | Output |
| ---- | ----- | ------ |
| `CATEGORIES` | `Array<String>` | Array items separated by `,` |
| `CREATED` | `Date` | Formatted date to spec |
| `DTEND` | `Date` | Formatted date to spec |
| `DTSTAMP` | `Date` | Formatted date to spec |
| `DTSTART` | `Date` | Formatted date to spec |
| `DUE` | `Date` | Formatted date to spec |
| `EXDATE` | `Array<Date>` | Array items separated by `,` formatted to spec |
| `GEO` | `Array<Float>` | Array items separated by `;` (should be `[x, y]`) |
| `LAST-MODIFIED` | `Date` | Formatted date to spec |
| `RDATE` | `Date` | Formatted date to spec |
| `TRANSP` | `Boolean` | `TRANSPARENT` if true, `OPAQUE` if false |
| `UID` | `String` or none | If no input is provided, generates a random GUID |
| `VERSION` | `Number` | Float with 1 decimal to spec |

All other properties (e.g. `SUMMARY`, `LOCATION`) are stored as-is without transformations.

### Nest a component

```js
const event = new ICS.VEVENT();
event.addProp('UID');
event.addProp('DTSTAMP', new Date('2015-07-18 10:00:00'), { VALUE: 'DATE-TIME' });

cal.addComponent(event);
```

Each component contains a list of valid nested components. Only valid components
can be nested according to the RFC 5545 spec.

### Generate ICS data

```js
cal.toString(); // Returns a string
cal.toBlob(); // Returns a Blob
cal.toBase64(); // Returns a Promise with a base64 string as the resolved value
```
