% DRM(1)

# NAME

drm - distributed remove

# SYNOPSIS

**drm [OPTION] PATH...**

# DESCRIPTION

Parallel MPI application to recursively delete a directory and its contents.

drm is a tool for removing files recursively in parallel. 
Be careful: drm behaves like *rm -rf*, but it is much faster.  

# OPTIONS

-i, \--input FILE
:	Read source list from FILE.  FILE must be generated by another tool from the mpiFileUtils suite.

-l, \--lite 
:	Walk file system without stat.

--exclude REGEX
:       Do not remove items whose full path matches REGEX, processed by regexec(3).

--match REGEX
:	Only remove items whose full path matches REGEX, processed by regexec(3).

--name
:	Change --exclude and --match to apply to item name rather than its full path.

-d, \--dryrun
:	Print a list of files that **would** be deleted without deleting them. This is useful
        to check list of items satisfying --exclude or --match options before actually deleting anything.

-v, \--verbose
:   Run in verbose mode.

-h, \--help
:   Print a brief message listing the *drm(1)* options and usage.

# EXAMPLES

1. To delete a directory and its contents:

mpirun -np 128 drm -v /dir/to/delete

2. Delete all items (files and directories) ending with .core from directory tree:

mpirun -np 128 drm --match '.core$' /dir/to/delete/from

3. List items that would be deleted without removing them:

mpirun -np 128 drm --dryrun --match '.core$' /dir/to/delete/from

4. Delete all items named foo:

mpirun -np 128 drm --name --match '^foo$' /dir/to/delete/from

# SEE ALSO

`dbcast` (1).
`dchmod` (1).
`dcmp` (1).
`dcp` (1).
`drm` (1).
`dstripe` (1).
`dwalk` (1).

The mpiFileUtils source code and all documentation may be downloaded from
<https://github.com/hpc/mpifileutils>
