% DCP(1)

# NAME

dcp - distributed copy

# SYNOPSIS

**dcp [OPTION] SRC DEST**

# DESCRIPTION

Parallel MPI application to recursively copy files and directories.

dcp is a file copy tool in the spirit of *cp(1)* that evenly distributes work
across a large cluster without any centralized state. It is designed for
copying files that are located on a distributed parallel file system.

# OPTIONS

-i, \--input FILE
:   Read source list from FILE.  FILE must be generated by another tool from the mpiFileUtils suite.

-p, \--preserve 
:   Preserve permissions, group, timestamps, and extended attributes.

-s, \--synchronous
:   Use synchronous read/write calls (open files with 0_DIRECT)

-S, \--sparse
:   Create sparse files when possible (non-functioning).

-v, \--verbose
:   Run in verbose mode.

-h, \--help
:   Print a brief message listing the *dcp(1)* options and usage.

# RESTRICTIONS

If a long-running copy is interrupted, one should delete the partial copy and run dcp again from the beginning.  One may use drm to quickly remove a partial copy of a large directory tree.

To ensure the copy is successful, one should run dcmp after dcp completes to verify the copy, especially if dcp was not run with the -s option.

# EXAMPLES

1. To copy dir1 as dir2:

mpirun -np 128 dcp /source/dir1 /dest/dir2

2. To copy contents of dir1 into dir2:

mkdir /dest/dir2
mpirun -np 128 dcp /source/dir1/* /dest/dir2

3. To copy while preserving permissions, group, timestamps, and attributes:

mpirun -np 128 dcp -p /source/dir1/ /dest/dir2

# KNOWN BUGS

Using the -S option for sparse files does not work yet at LLNL. If you try
to use it then dcp will default to a normal copy.

The maximum supported file name length for any file transferred is approximately 4068 characters.  This may be less than the number of characters that your operating system supports.

# SEE ALSO

`dbcast` (1).
`dchmod` (1).
`dcmp` (1).
`dcp` (1).
`drm` (1).
`dstripe` (1).
`dwalk` (1).

The mpiFileUtils source code and all documentation may be downloaded from
<https://github.com/hpc/mpifileutils>
