% DCHMOD(1)

# NAME
dchmod - distributed tool to set permissions and group

# SYNOPSIS
**dchmod [OPTION] PATH...**

# DESCRIPTION

Parallel MPI application to recursively change permissions and/or group from a top level directory. 

dchmod provides functionality similar to *chmod(1)* and *chgrp(1)*. Like *chmod(1)*, the tool supports the use of octal or symbolic mode to change the permissions.

# OPTIONS

-i, \--input FILE
:	Read source list from FILE.  FILE must be generated by another tool from the mpiFileUtils suite.

-g, \--group GROUP 
:   Change group to specified GROUP name. 

-m, \--mode MODE
:   The mode to apply to each item.  MODE may be octal or symbolic syntax similar to chmod(1).  In symbolic notation, "ugoa" are supported as are "rwxX".  As with chmod, if no leading letter "ugoa" is provided, mode bits are combined with umask to determine the actual mode.

--exclude REGEX
:   Do not modify items whose full path matches REGEX, processed by regexec(3).

--match REGEX
:   Only modify items whose full path matches REGEX, processed by regexec(3).

--name 
:   Change --exclude and --match to apply to item name rather than its full path.

-v, \--verbose 
: 	Run in verbose mode.  Prints a list of statistics including the number of files walked, the number of levels there are in the directory tree, and the number of files the command operated on, and the files/sec rate for each of those.

-h, \--help 
: 	Print the command usage, and the list of options available. 

# EXAMPLES

1. Use octal mode to change permissions:

mpirun -np 128 dchmod --mode 755 /directory

2. Set group and mode in a single command using symbolic mode:

mpirun -np 128 dchmod --group mygroup --mode u+r,g+rw /directory

3. Change permissions to u+rw on all items EXCEPT those whose name match regex:

mpirun -np 128 dchmod --name --exclude 'afilename' --mode u+rw /directory

Note: You can use --match to change file permissions on all of the files/directories that match the regex.

# SEE ALSO

`dbcast` (1).
`dchmod` (1).
`dcmp` (1).
`dcp` (1).
`drm` (1).
`dstripe` (1).
`dwalk` (1).

The mpiFileUtils source code and all documentation may be downloaded from <https://github.com/hpc/mpifileutils>
