# ExtractFactory.pm
package MMTests::ExtractFactory;
use MMTests::Report;
use strict;

sub new() {
	my $class = shift;
	my $self = { };

	bless $self, $class;
	return $self;
}

sub loadModule($$$) {
	my ($self, $type, $moduleName, $opt_reportDirectory, $testName, $format, $subheading) = @_;
	printVerbose("Loading module $moduleName\n");

	my $pmName = ucfirst($moduleName);
	$pmName =~ s/-//g;
	$type = ucfirst($type);
   	require "MMTests/$type$pmName.pm";
    	$pmName->import();

	my $className = "MMTests::$type$pmName";
	my $classInstance = $className->new(0);
	$classInstance->initialise($opt_reportDirectory, $testName, $subheading);
	$classInstance->setFormat($format);
	printVerbose("Loaded  module " . $classInstance->getModuleName() . "\n");

	bless $classInstance, $className;
}

1;
