# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# See LICENSE for more details.
#
# Copyright: Red Hat Inc. 2016
# Authors: Cleber Rosa <crosa@redhat.com>

"""Result Archive Plugin"""

from avocado.core.plugin_interfaces import CLI, Result
from avocado.utils import archive


class Archive(Result):

    name = 'zip_archive'
    description = 'Result archive (ZIP) support'

    def render(self, result, job):
        if getattr(job.args, 'archive', False):
            archive.compress("%s.zip" % job.logdir, job.logdir)


class ArchiveCLI(CLI):

    name = 'zip_archive'
    description = 'Result archive (ZIP) support to run command'

    def configure(self, parser):
        run_subcommand_parser = parser.subcommands.choices.get('run', None)
        if run_subcommand_parser is None:
            return

        run_subcommand_parser.output.add_argument(
            '-z', '--archive', action='store_true',
            dest='archive', default=False,
            help='Archive (ZIP) files generated by tests')

    def run(self, args):
        pass
