---
project.description: Release notes for all Alpakka 2.0.x releases.
---
# Alpakka 2.0.x

@@@ note { title="Major version change" }
The major version tick for Alpakka is due to major upgrades and changes in the dependencies used by the various connectors.
Some Alpakka APIs changed as well, but we try to keep those changes minimal.

To understand the forces on version numbers, read about @ref:[Alpakka's versioning scheme](../other-docs/versioning.md). 

@@@

@@@ note
In case you are browsing a specific version's documentation: check out the [latest release notes](https://doc.akka.io/docs/alpakka/current/release-notes/)
@@@

All Alpakka modules are available for Scala 2.13 and all Alpakka modules are compatible with Akka 2.6.0+ and Akka 2.5.26+.

**Alpakka 2.0 updates dependencies for most connectors.**


## 2.0.0-M1

Released 2019-11-08

## Notable changes in 2.0.0-M1

- Akka 2.6/2.5 cross-compilation [#1988](https://github.com/akka/alpakka/issues/1988) by [@ennru](https://github.com/ennru)
- AWS S3: Migrate S3 connector to AWS SDK 2 authentication lib [#1905](https://github.com/akka/alpakka/pull/1905) by [@2m](https://github.com/2m)
- AWS S3: Custom header injection [#1947](https://github.com/akka/alpakka/pull/1947) by [@vigoo](https://github.com/vigoo)
- DynamoDb: Update to AWS SDK 2.0 [#1725](https://github.com/akka/alpakka/pull/1725) by [@RustedBones](https://github.com/RustedBones)
- HDFS: upgrade Cats to 2.0.0 and enable Scala 2.13 [#1925](https://github.com/akka/alpakka/pull/1925)
- File: Added flow for creating file ZIP archive [#1890](https://github.com/akka/alpakka/pull/1890) by [@michalbogacz](https://github.com/michalbogacz)
- FTP - Add proxy support to FTP, SFTP, and FTPS connectors [#1907](https://github.com/akka/alpakka/pull/1907) by [@mjp426](https://github.com/mjp426)
- IronMq: support Scala 2.13 (and drop 2.11) by akka-http-circe 1.21 to 1.29.1 [#1957](https://github.com/akka/alpakka/issues/1957) by [@tg44](https://github.com/tg44)
- XML: add support for supplying XMLInputFactory configuration [#1982](https://github.com/akka/alpakka/issues/1982) by [@jphelp32](https://github.com/jphelp32)
- XML: add ability to provide a specific XMLOutputFactory [#1945](https://github.com/akka/alpakka/pull/1945) by [@jphelp32](https://github.com/jphelp32)

This milestone contains changes from 30 contributors in the Alpakka community. Thank you all!

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&amp;s=40"/> **ennru**](https://github.com/ennru) | 33 | 3335 | 2791 |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&amp;s=40"/> **2m**](https://github.com/2m) | 19 | 1823 | 560 |
| [<img width="20" alt="huntc" src="https://avatars2.githubusercontent.com/u/694893?v=4&amp;s=40"/> **huntc**](https://github.com/huntc) | 6 | 219 | 99 |
| [<img width="20" alt="LGLO" src="https://avatars2.githubusercontent.com/u/2694353?v=4&amp;s=40"/> **LGLO**](https://github.com/LGLO) | 5 | 524 | 161 |
| [<img width="20" alt="jphelp32" src="https://avatars3.githubusercontent.com/u/2238383?v=4&amp;s=40"/> **jphelp32**](https://github.com/jphelp32) | 3 | 222 | 13 |
| [<img width="20" alt="cheleb" src="https://avatars0.githubusercontent.com/u/378539?v=4&amp;s=40"/> **cheleb**](https://github.com/cheleb) | 3 | 12 | 35 |
| [<img width="20" alt="michalbogacz" src="https://avatars0.githubusercontent.com/u/11833270?v=4&amp;s=40"/> **michalbogacz**](https://github.com/michalbogacz) | 2 | 600 | 20 |
| [<img width="20" alt="dotbg" src="https://avatars0.githubusercontent.com/u/367403?v=4&amp;s=40"/> **dotbg**](https://github.com/dotbg) | 2 | 50 | 9 |
| [<img width="20" alt="maxrem" src="https://avatars3.githubusercontent.com/u/21196963?v=4&amp;s=40"/> **maxrem**](https://github.com/maxrem) | 1 | 560 | 41 |
| [<img width="20" alt="vigoo" src="https://avatars2.githubusercontent.com/u/2292489?v=4&amp;s=40"/> **vigoo**](https://github.com/vigoo) | 1 | 488 | 81 |
| [<img width="20" alt="RustedBones" src="https://avatars3.githubusercontent.com/u/2845540?v=4&amp;s=40"/> **RustedBones**](https://github.com/RustedBones) | 1 | 395 | 1300 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&amp;s=40"/> **longshorej**](https://github.com/longshorej) | 1 | 374 | 217 |
| [<img width="20" alt="RomanLebid" src="https://avatars0.githubusercontent.com/u/51950394?v=4&amp;s=40"/> **RomanLebid**](https://github.com/RomanLebid) | 1 | 361 | 81 |
| [<img width="20" alt="mjp426" src="https://avatars1.githubusercontent.com/u/12141026?v=4&amp;s=40"/> **mjp426**](https://github.com/mjp426) | 1 | 326 | 16 |
| [<img width="20" alt="seglo" src="https://avatars2.githubusercontent.com/u/1148412?v=4&amp;s=40"/> **seglo**](https://github.com/seglo) | 1 | 223 | 1 |
| [<img width="20" alt="janjaali" src="https://avatars2.githubusercontent.com/u/1159996?v=4&amp;s=40"/> **janjaali**](https://github.com/janjaali) | 1 | 135 | 58 |
| [<img width="20" alt="francisdb" src="https://avatars0.githubusercontent.com/u/161305?v=4&amp;s=40"/> **francisdb**](https://github.com/francisdb) | 1 | 76 | 46 |
| [<img width="20" alt="Kreinoee" src="https://avatars3.githubusercontent.com/u/851301?v=4&amp;s=40"/> **Kreinoee**](https://github.com/Kreinoee) | 1 | 55 | 16 |
| [<img width="20" alt="WellingR" src="https://avatars1.githubusercontent.com/u/4014179?v=4&amp;s=40"/> **WellingR**](https://github.com/WellingR) | 1 | 43 | 1 |
| [<img width="20" alt="tg44" src="https://avatars1.githubusercontent.com/u/31839?v=4&amp;s=40"/> **tg44**](https://github.com/tg44) | 1 | 17 | 21 |
| [<img width="20" alt="anzecesar" src="https://avatars1.githubusercontent.com/u/71454?v=4&amp;s=40"/> **anzecesar**](https://github.com/anzecesar) | 1 | 15 | 6 |
| [<img width="20" alt="bpiper" src="https://avatars3.githubusercontent.com/u/12616466?v=4&amp;s=40"/> **bpiper**](https://github.com/bpiper) | 1 | 11 | 9 |
| [<img width="20" alt="TimMoore" src="https://avatars0.githubusercontent.com/u/44385?v=4&amp;s=40"/> **TimMoore**](https://github.com/TimMoore) | 1 | 9 | 32 |
| [<img width="20" alt="shimamoto" src="https://avatars1.githubusercontent.com/u/1875052?v=4&amp;s=40"/> **shimamoto**](https://github.com/shimamoto) | 1 | 8 | 11 |
| [<img width="20" alt="DanieleSassoli" src="https://avatars0.githubusercontent.com/u/4007741?v=4&amp;s=40"/> **DanieleSassoli**](https://github.com/DanieleSassoli) | 1 | 5 | 5 |
| [<img width="20" alt="giena" src="https://avatars3.githubusercontent.com/u/6929360?v=4&amp;s=40"/> **giena**](https://github.com/giena) | 1 | 2 | 2 |
| [<img width="20" alt="lewisjkl" src="https://avatars3.githubusercontent.com/u/13733772?v=4&amp;s=40"/> **lewisjkl**](https://github.com/lewisjkl) | 1 | 2 | 1 |
| [<img width="20" alt="laszlovandenhoek" src="https://avatars3.githubusercontent.com/u/998449?v=4&amp;s=40"/> **laszlovandenhoek**](https://github.com/laszlovandenhoek) | 1 | 1 | 1 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&amp;s=40"/> **sullis**](https://github.com/sullis) | 1 | 1 | 1 |
| [<img width="20" alt="ashwanthkumar" src="https://avatars0.githubusercontent.com/u/600279?v=4&amp;s=40"/> **ashwanthkumar**](https://github.com/ashwanthkumar) | 1 | 1 | 1 |


## Changes per module

@@toc { depth=1 }

@@@ index

* [AMQP](2.0.x/amqp.md)
* [Apache Cassandra](2.0.x/cassandra.md)
* [Apache Geode](2.0.x/geode.md)
* [Apache Kafka](2.0.x/kafka.md)
* [Apache Kudu](2.0.x/kudu.md)
* [Apache Solr](2.0.x/solr.md)
* [Avro Parquet](2.0.x/avroparquet.md)
* [AWS DynamoDB](2.0.x/dynamodb.md)
* [AWS Kinesis](2.0.x/kinesis.md)
* [AWS Lambda](2.0.x/awslambda.md)
* [AWS S3](2.0.x/s3.md)
* [AWS SNS](2.0.x/sns.md)
* [AWS SQS](2.0.x/sqs.md)
* [Azure Storage Queue](2.0.x/azure-storage-queue.md)
* [CSV](2.0.x/csv.md)
* [Couchbase](2.0.x/couchbase.md)
* [Elasticsearch](2.0.x/elasticsearch.md)
* [File](2.0.x/file.md)
* [FTP](2.0.x/ftp.md)
* [Google Cloud Pub/Sub](2.0.x/google-cloud-pub-sub.md)
* [Google Cloud Pub/Sub gRPC](2.0.x/google-cloud-pub-sub-grpc.md)
* [Google Firebase Cloud Messaging](2.0.x/google-fcm.md)
* [Google Cloud Storage](2.0.x/google-cloud-storage.md)
* [Hadoop Distributed File System](2.0.x/hdfs.md)
* [HBase](2.0.x/hbase.md)
* [InfluxDB](2.0.x/influxdb.md)
* [IronMQ](2.0.x/ironmq.md)
* [JMS](2.0.x/jms.md)
* [Json streaming](2.0.x/json-streaming.md)
* [MongoDB](2.0.x/mongodb.md)
* [MQTT](2.0.x/mqtt.md)
* [MQTT Streaming](2.0.x/mqtt-streaming.md)
* [OrientDB](2.0.x/orientdb.md)
* [Server-sent Events (SSE)](2.0.x/sse.md)
* [Simple Codecs (RecordIO)](2.0.x/simple-codecs.md)
* [Slick (JDBC)](2.0.x/slick.md)
* [Spring Web](2.0.x/spring-web.md)
* [UDP](2.0.x/udp.md)
* [Unix Domain Sockets](2.0.x/unix-domain-socket.md)
* [XML](2.0.x/xml.md)


@@@
