# Alpakka 1.1.x

To understand the forces on version numbers, read about @ref:[Alpakka's versioning scheme](../other-docs/versioning.md). 

## 1.1.2

Released 2019-10-10

## Notable changes in 1.1.2

- AWS S3: make raw request URI contain path and query  [#1923](https://github.com/akka/alpakka/issues/1923) by [@ennru](https://github.com/ennru) backported in [#1963](https://github.com/akka/alpakka/pull/1963)
- JMS: Added withHeader(s) withProperty(-ies) and withoutDestination methods… [#1830](https://github.com/akka/alpakka/issues/1830) by [@WellingR](https://github.com/WellingR) backported in [#1974](https://github.com/akka/alpakka/pull/1974)
- JMS: Java API for JmsMessages withProperties [#1904](https://github.com/akka/alpakka/issues/1904) by [@dotbg](https://github.com/dotbg) backported in [#1977](https://github.com/akka/alpakka/pull/1977)
- MQTT Streaming: Automatically unregister packet ids and other resources [#1853](https://github.com/akka/alpakka/issues/1853) by [@huntc](https://github.com/huntc) backported in [#1961](https://github.com/akka/alpakka/pull/1961)
- AWS S3, SNS, SQS, IronMQ, SSE: Akka HTTP 10.1.10 [#1939](https://github.com/akka/alpakka/issues/1939) by [@ennru](https://github.com/ennru) backported in [#1969](https://github.com/akka/alpakka/pull/1969)

**See @ref:[changes per module](#changes-per-module)**


## 1.1.1

Released 2019-08-08

To allow for API-breaking changes and major dependency upgrades, we expect to release Alpakka 2.0.0 in a few months.


## Notable changes in 1.1.1

- FTP: Mkdir [#1816](https://github.com/akka/alpakka/issues/1816) by [@MarcinAman](https://github.com/MarcinAman)
- MQTT streaming: diverse improvements (see @ref:[MQTT Streaming](1.1.x/mqtt-streaming.md))

**See @ref:[changes per module](#changes-per-module)**

## Contributors in 1.1.1

| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&s=40"> **2m**](https://github.com/2m) | 27 | 493 | 533 |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&s=40"> **ennru**](https://github.com/ennru) | 12 | 417 | 485 |
| [<img width="20" alt="huntc" src="https://avatars2.githubusercontent.com/u/694893?v=4&s=40"> **huntc**](https://github.com/huntc) | 3 | 108 | 76 |
| [<img width="20" alt="fagossa" src="https://avatars1.githubusercontent.com/u/6917738?v=4&s=40"> **fagossa**](https://github.com/fagossa) | 2 | 146 | 1 |
| [<img width="20" alt="MarcinAman" src="https://avatars0.githubusercontent.com/u/15652452?v=4&s=40"> **MarcinAman**](https://github.com/MarcinAman) | 1 | 300 | 39 |
| [<img width="20" alt="markarasev" src="https://avatars2.githubusercontent.com/u/3638968?v=4&s=40"> **markarasev**](https://github.com/markarasev) | 1 | 77 | 29 |
| [<img width="20" alt="raboof" src="https://avatars2.githubusercontent.com/u/131856?v=4&s=40"> **raboof**](https://github.com/raboof) | 1 | 15 | 7 |
| [<img width="20" alt="newca12" src="https://avatars1.githubusercontent.com/u/543542?v=4&s=40"> **newca12**](https://github.com/newca12) | 1 | 6 | 1 |
| [<img width="20" alt="pulltab" src="https://avatars3.githubusercontent.com/u/6842323?v=4&s=40"> **pulltab**](https://github.com/pulltab) | 1 | 4 | 1 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&s=40"> **longshorej**](https://github.com/longshorej) | 1 | 1 | 1 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&s=40"> **sullis**](https://github.com/sullis) | 1 | 1 | 1 |


## 1.1.0

Released 2019-07-03

@@@ note

This minor version release is motivated by the addition of the two new connectors for InfluxDB and Google Cloud Storage. Most connectors do not have any changes since 1.0.2.

**All APIs are backwards compatible with 1.0.0** (excluding those that were marked as "API may change").

@@@

To allow for API-breaking changes and major dependency upgrades, we expect to release Alpakka 2.0.0 in a few months.


## Notable changes in 1.1.0

* New: @ref:[Alpakka InfluxDB](../influxdb.md) 
* New: @ref:[Alpakka Google Cloud Storage](../google-cloud-storage.md) 
* Most connectors are available for Scala 2.13 (for remaining see the [Alpakka Scala 2.13 project board](https://github.com/akka/alpakka/projects/2))
* Alpakka Couchbase has built-in support for Akka Discovery [#1746](https://github.com/akka/alpakka/issues/1746)
* MQTT streaming: SourceQueue backpressure [#1577](https://github.com/akka/alpakka/pull/1577) 
* **Akka 2.5.23** is now required. This upgrade gives Alpakka access to
    * Scala 2.13
    * the new @extref[`setup` operator](akka:stream/operators/Source-or-Flow/setup.html#source-flow-setup) used by many Alpakka connectors
* **Akka HTTP 10.1.8** is now required for Alapkka connectors using it. This upgrade gives Alpakka access to
    * Scala 2.13
    * improvements for Server-sent Events (SSE)

**See [changes per module](#changes-per-module)**

## Contributors in 1.1.0


| Author | Commits | Lines added | Lines removed |
| ------ | ------- | ----------- | ------------- |
| [<img width="20" alt="ennru" src="https://avatars3.githubusercontent.com/u/458526?v=4&amp;s=40"/> **ennru**](https://github.com/ennru) | 29 | 2274 | 3366 |
| [<img width="20" alt="2m" src="https://avatars3.githubusercontent.com/u/422086?v=4&amp;s=40"/> **2m**](https://github.com/2m) | 20 | 5553 | 125 |
| [<img width="20" alt="gipeshka" src="https://avatars1.githubusercontent.com/u/1704933?v=4&amp;s=40"/> **gipeshka**](https://github.com/gipeshka) | 20 | 864 | 519 |
| [<img width="20" alt="sullis" src="https://avatars3.githubusercontent.com/u/30938?v=4&amp;s=40"/> **sullis**](https://github.com/sullis) | 2 | 2 | 2 |
| [<img width="20" alt="jkobejs" src="https://avatars0.githubusercontent.com/u/10402628?v=4&amp;s=40"/> **jkobejs**](https://github.com/jkobejs) | 1 | 5216 | 1106 |
| [<img width="20" alt="gkatzioura" src="https://avatars1.githubusercontent.com/u/671486?v=4&amp;s=40"/> **gkatzioura**](https://github.com/gkatzioura) | 1 | 2095 | 0 |
| [<img width="20" alt="francisdb" src="https://avatars0.githubusercontent.com/u/161305?v=4&amp;s=40"/> **francisdb**](https://github.com/francisdb) | 1 | 1216 | 0 |
| [<img width="20" alt="nsandroni" src="https://avatars3.githubusercontent.com/u/51410599?v=4&amp;s=40"/> **nsandroni**](https://github.com/nsandroni) | 1 | 555 | 216 |
| [<img width="20" alt="codingismy11to7" src="https://avatars1.githubusercontent.com/u/422765?v=4&amp;s=40"/> **codingismy11to7**](https://github.com/codingismy11to7) | 1 | 496 | 4 |
| [<img width="20" alt="longshorej" src="https://avatars1.githubusercontent.com/u/515201?v=4&amp;s=40"/> **longshorej**](https://github.com/longshorej) | 1 | 355 | 106 |
| [<img width="20" alt="LGLO" src="https://avatars2.githubusercontent.com/u/2694353?v=4&amp;s=40"/> **LGLO**](https://github.com/LGLO) | 1 | 76 | 20 |
| [<img width="20" alt="MarcinAman" src="https://avatars0.githubusercontent.com/u/15652452?v=4&amp;s=40"/> **MarcinAman**](https://github.com/MarcinAman) | 1 | 59 | 23 |
| [<img width="20" alt="kubukoz" src="https://avatars0.githubusercontent.com/u/894884?v=4&amp;s=40"/> **kubukoz**](https://github.com/kubukoz) | 1 | 15 | 0 |
| [<img width="20" alt="jefftt" src="https://avatars2.githubusercontent.com/u/7140426?v=4&amp;s=40"/> **jefftt**](https://github.com/jefftt) | 1 | 8 | 9 |
| [<img width="20" alt="srxx" src="https://avatars0.githubusercontent.com/u/51457074?v=4&amp;s=40"/> **srxx**](https://github.com/srxx) | 1 | 6 | 4 |
| [<img width="20" alt="EldarKZ16" src="https://avatars0.githubusercontent.com/u/38246993?v=4&amp;s=40"/> **EldarKZ16**](https://github.com/EldarKZ16) | 1 | 6 | 0 |
| [<img width="20" alt="tonicebrian" src="https://avatars2.githubusercontent.com/u/132687?v=4&amp;s=40"/> **tonicebrian**](https://github.com/tonicebrian) | 1 | 1 | 1 |

## Changes per module

@@toc { depth=1 }

@@@ index

* [AMQP](1.1.x/amqp.md)
* [Apache Cassandra](1.1.x/cassandra.md)
* [Apache Geode](1.1.x/geode.md)
* [Apache Kafka](1.1.x/kafka.md)
* [Apache Kudu](1.1.x/kudu.md)
* [Apache Solr](1.1.x/solr.md)
* [Avro Parquet](1.1.x/avroparquet.md)
* [AWS DynamoDB](1.1.x/dynamodb.md)
* [AWS Kinesis](1.1.x/kinesis.md)
* [AWS Lambda](1.1.x/awslambda.md)
* [AWS S3](1.1.x/s3.md)
* [AWS SNS](1.1.x/sns.md)
* [AWS SQS](1.1.x/sqs.md)
* [Azure Storage Queue](1.1.x/azure-storage-queue.md)
* [CSV](1.1.x/csv.md)
* [Couchbase](1.1.x/couchbase.md)
* [Elasticsearch](1.1.x/elasticsearch.md)
* [File](1.1.x/file.md)
* [FTP](1.1.x/ftp.md)
* [Google Cloud Pub/Sub](1.1.x/google-cloud-pub-sub.md)
* [Google Cloud Pub/Sub gRPC](1.1.x/google-cloud-pub-sub-grpc.md)
* [Google Firebase Cloud Messaging](1.1.x/google-fcm.md)
* [Google Cloud Storage](1.1.x/google-cloud-storage.md)
* [Hadoop Distributed File System](1.1.x/hdfs.md)
* [HBase](1.1.x/hbase.md)
* [InfluxDB](1.1.x/influxdb.md)
* [IronMQ](1.1.x/ironmq.md)
* [JMS](1.1.x/jms.md)
* [Json streaming](1.1.x/json-streaming.md)
* [MongoDB](1.1.x/mongodb.md)
* [MQTT](1.1.x/mqtt.md)
* [MQTT Streaming](1.1.x/mqtt-streaming.md)
* [OrientDB](1.1.x/orientdb.md)
* [Server-sent Events (SSE)](1.1.x/sse.md)
* [Simple Codecs (RecordIO)](1.1.x/simple-codecs.md)
* [Slick (JDBC)](1.1.x/slick.md)
* [Spring Web](1.1.x/spring-web.md)
* [UDP](1.1.x/udp.md)
* [Unix Domain Sockets](1.1.x/unix-domain-socket.md)
* [XML](1.1.x/xml.md)


@@@
